
/* /web/static/src/js/services/session.js defined in bundle 'web.assets_frontend' */
odoo.define('web.session',function(require){"use strict";var Session=require('web.Session');var modules=odoo._modules;var session=new Session(undefined,undefined,{modules:modules,use_cors:false});session.is_bound=session.session_bind();return session;});;

/* /web_editor/static/src/js/content/body_manager.js defined in bundle 'web.assets_frontend' */
odoo.define('web_editor.BodyManager',function(require){'use strict';var mixins=require('web.mixins');var session=require('web.session');var rootWidget=require('web_editor.root_widget');var BodyManager=rootWidget.RootWidget.extend(mixins.ServiceProvider,{init:function(){mixins.ServiceProvider.init.call(this);this._super.apply(this,arguments);},willStart:function(){return $.when(this._super.apply(this,arguments),session.is_bound);},});return BodyManager;});;

/* /web_editor/static/src/js/root_widget.js defined in bundle 'web.assets_frontend' */
odoo.define('web_editor.root_widget',function(require){'use strict';var Class=require('web.Class');var dom=require('web.dom');var mixins=require('web.mixins');var Widget=require('web.Widget');var RootWidget=Widget.extend({custom_events:_.extend({},Widget.prototype.custom_events||{},{registry_update:'_onRegistryUpdate',}),init:function(){this._super.apply(this,arguments);this._widgets=[];this._listenToUpdates=false;this._getRegistry().setParent(this);},start:function(){var defs=[this._super.apply(this,arguments)];defs.push(this._attachComponents());this._listenToUpdates=true;return $.when.apply($,defs);},_attachComponent:function(childInfo,$from){var self=this;var $elements=dom.cssFind($from||this.$el,childInfo.selector);var defs=_.map($elements,function(element){var w=new childInfo.Widget(self);self._widgets.push(w);return w.attachTo(element);});return $.when.apply($,defs);},_attachComponents:function($from){var self=this;var childInfos=this._getRegistry().get();var defs=_.map(childInfos,function(childInfo){return self._attachComponent(childInfo,$from);});return $.when.apply($,defs);},_getRegistry:function(){},_onRegistryUpdate:function(ev){ev.stopPropagation();if(this._listenToUpdates){this._attachComponent(ev.data);}},});var RootWidgetRegistry=Class.extend(mixins.EventDispatcherMixin,{init:function(){mixins.EventDispatcherMixin.init.call(this);this._registry=[];},add:function(Widget,selector){var registryInfo={Widget:Widget,selector:selector,};this._registry.push(registryInfo);this.trigger_up('registry_update',registryInfo);},get:function(){return this._registry;},});return{RootWidget:RootWidget,RootWidgetRegistry:RootWidgetRegistry,};});;

/* /auth_signup/static/src/js/signup.js defined in bundle 'web.assets_frontend' */
odoo.define('auth_signup.signup',function(require){'use strict';var base=require('web_editor.base');base.ready().then(function(){if($('.oe_signup_form').length>0){$('.oe_signup_form').on('submit',function(){$('.o_signup_btn').attr('disabled','disabled');$('.o_signup_btn').prepend('<i class="fa fa-refresh fa-spin"/> ');});}});});;

/* /portal/static/src/js/portal.js defined in bundle 'web.assets_frontend' */
odoo.define('portal.portal',function(require){'use strict';require('web.dom_ready');if(!$('.o_portal').length){return $.Deferred().reject("DOM doesn't contain '.o_portal'");}
if($('.o_portal_details').length){var state_options=$("select[name='state_id']:enabled option:not(:first)");$('.o_portal_details').on('change',"select[name='country_id']",function(){var select=$("select[name='state_id']");state_options.detach();var displayed_state=state_options.filter("[data-country_id="+($(this).val()||0)+"]");var nb=displayed_state.appendTo(select).show().size();select.parent().toggle(nb>=1);});$('.o_portal_details').find("select[name='country_id']").change();}
if($('.o_portal_search_panel').length){$('.o_portal_search_panel .search-submit').click(function(){var search=$.deparam(window.location.search.substring(1));search.search_in=$(".o_portal_search_panel li.active a").attr("href").replace("#","");search.search=$(".o_portal_search_panel input[name='search']").val();window.location.search=$.param(search);});$('.o_portal_search_panel .dropdown-menu').find('a').click(function(e){e.preventDefault();$(this).parents('.dropdown-menu').find('li').removeClass('active');$(this).parent('li').addClass('active');var label=$(this).clone();label.find('span.nolabel').remove();$(".o_portal_search_panel span#search_label").text(label.text());});$('.o_portal_search_panel .dropdown-menu').find('li.active a').trigger('click');$(".o_portal_search_panel input[name='search']").on('keyup',function(e){if(e.keyCode===13){$('.o_portal_search_panel .search-submit').trigger('click');}});}});;

/* /portal/static/src/js/portal_tour.js defined in bundle 'web.assets_frontend' */
odoo.define('portal.tour',function(require){'use strict';var tour=require("web_tour.tour");tour.register('portal_load_homepage',{test:true,url:'/my',},[{content:"Check portal is loaded",trigger:'a[href*="/my/account"]:contains("Change"):first',},{content:"Load my account details",trigger:'body:contains("Your Details")',}]);});;

/* /portal/static/src/js/portal_chatter.js defined in bundle 'web.assets_frontend' */
odoo.define('portal.chatter',function(require){'use strict';var base=require('web_editor.base');var ajax=require('web.ajax');var core=require('web.core');var Widget=require('web.Widget');var rpc=require('web.rpc');var time=require('web.time');var qweb=core.qweb;var _t=core._t;var PortalChatter=Widget.extend({template:'portal.chatter',events:{"click .o_portal_chatter_pager_btn":'_onClickPager'},init:function(parent,options){this._super.apply(this,arguments);this.options=_.defaults(options||{},{'allow_composer':true,'display_composer':false,'csrf_token':odoo.csrf_token,'message_count':0,'pager_step':10,'pager_scope':5,'pager_start':1,'is_user_public':true,'is_user_publisher':false,'domain':[],});this.set('messages',[]);this.set('message_count',this.options['message_count']);this.set('pager',{});this.set('domain',this.options['domain']);this._current_page=this.options['pager_start'];},willStart:function(){var self=this;return $.when(rpc.query({route:'/mail/chatter_init',params:this._messageFetchPrepareParams()}),this._loadTemplates()).then(function(result){self.on("change:messages",self,self._renderMessages);self.on("change:message_count",self,function(){self._renderMessageCount();self.set('pager',self._pager(self._current_page));});self.on("change:pager",self,self._renderPager);self.on("change:domain",self,self._onChangeDomain);self.options=_.extend(self.options,result['options']||{});self.set('message_count',self.options['message_count']);self.set('messages',self.preprocessMessages(result['messages']));return result;});},messageFetch:function(domain){var self=this;return rpc.query({route:'/mail/chatter_fetch',params:self._messageFetchPrepareParams()}).then(function(result){self.set('messages',self.preprocessMessages(result['messages']));self.set('message_count',result['message_count']);});},preprocessMessages:function(messages){_.each(messages,function(m){m['author_avatar_url']=_.str.sprintf('/web/image/%s/%s/author_avatar/50x50','mail.message',m.id);m['published_date_str']=_.str.sprintf(_t('Published on %s'),moment(time.str_to_datetime(m.date)).format('MMMM Do YYYY, h:mm:ss a'));});return messages;},_changeCurrentPage:function(page,domain){this._current_page=page;var d=domain?domain:_.clone(this.get('domain'));this.set('domain',d);},_loadTemplates:function(){return ajax.loadXML('/portal/static/src/xml/portal_chatter.xml',qweb);},_messageFetchPrepareParams:function(){var self=this;var data={'res_model':this.options['res_model'],'res_id':this.options['res_id'],'limit':this.options['pager_step'],'offset':(this._current_page-1)*this.options['pager_step'],'allow_composer':this.options['allow_composer'],};if(self.options['token']){data['token']=self.options['token'];}
if(this.get('domain')){data['domain']=this.get('domain');}
return data;},_pager:function(page){var page=page||1;var total=this.get('message_count');var scope=this.options['pager_scope'];var step=this.options['pager_step'];var page_count=Math.ceil(parseFloat(total)/step);var page=Math.max(1,Math.min(parseInt(page),page_count));scope-=1;var pmin=Math.max(page-parseInt(Math.floor(scope/2)),1);var pmax=Math.min(pmin+scope,page_count);if(pmax-scope>0){pmin=pmax-scope;}else{pmin=1;}
var pages=[];_.each(_.range(pmin,pmax+1),function(index){pages.push(index);});return{"page_count":page_count,"offset":(page-1)*step,"page":page,"page_start":pmin,"page_previous":Math.max(pmin,page-1),"page_next":Math.min(pmax,page+1),"page_end":pmax,"pages":pages};},_renderMessages:function(){this.$('.o_portal_chatter_messages').html(qweb.render("portal.chatter_messages",{widget:this}));},_renderMessageCount:function(){this.$('.o_message_counter').replaceWith(qweb.render("portal.chatter_message_count",{widget:this}));},_renderPager:function(){this.$('.o_portal_chatter_pager').replaceWith(qweb.render("portal.pager",{widget:this}));},_onChangeDomain:function(){var self=this;this.messageFetch().then(function(){var p=self._current_page;self.set('pager',self._pager(p));});},_onClickPager:function(ev){ev.preventDefault();var page=$(ev.currentTarget).data('page');this._changeCurrentPage(page);},});base.ready().then(function(){$('.o_portal_chatter').each(function(index){var $elem=$(this);var mail_thread=new PortalChatter(null,$elem.data());mail_thread.appendTo($elem);});});return{PortalChatter:PortalChatter,};});;

/* /portal/static/src/js/portal_signature.js defined in bundle 'web.assets_frontend' */
odoo.define('portal.signature_form',function(require){"use strict";require('web_editor.ready');var ajax=require('web.ajax');var base=require('web_editor.base');var core=require('web.core');var Widget=require("web.Widget");var rpc=require("web.rpc");var qweb=core.qweb;var SignatureForm=Widget.extend({template:'portal.portal_signature',events:{'click #o_portal_sign_clear':'clearSign','click .o_portal_sign_submit':'submitSign','init #o_portal_sign_accept':'initSign',},init:function(parent,options){this._super.apply(this,arguments);this.options=_.extend(options||{},{csrf_token:odoo.csrf_token,});},willStart:function(){return this._loadTemplates();},start:function(){this.initSign();},initSign:function(){this.$("#o_portal_signature").empty().jSignature({'decor-color':'#D1D0CE','color':'#000','background-color':'#fff','height':'142px',});this.empty_sign=this.$("#o_portal_signature").jSignature('getData','image');},clearSign:function(){this.$("#o_portal_signature").jSignature('reset');},submitSign:function(ev){ev.preventDefault();var self=this;var $confirm_btn=self.$el.find('button[type="submit"]');var partner_name=self.$("#o_portal_sign_name").val();var signature=self.$("#o_portal_signature").jSignature('getData','image');var is_empty=signature?this.empty_sign[1]===signature[1]:true;this.$('#o_portal_sign_name').parent().toggleClass('has-error',!partner_name);this.$('#o_portal_sign_draw').toggleClass('panel-danger',is_empty).toggleClass('panel-default',!is_empty);if(is_empty||!partner_name){return false;}
$confirm_btn.prepend('<i class="fa fa-spinner fa-spin"></i> ');$confirm_btn.attr('disabled',true);return rpc.query({route:this.options.callUrl,params:{'res_id':this.options.resId,'access_token':this.options.accessToken,'partner_name':partner_name,'signature':signature?signature[1]:false,},}).then(function(data){self.$('.fa-spinner').remove();self.$('#o_portal_sign_accept').prepend('<div>PROUT'+data+'</div>');if(data.error){$confirm_btn.attr('disabled',false);}
else if(data.success){$confirm_btn.remove();var $success=qweb.render("portal.portal_signature_success",{widget:data});self.$('#o_portal_sign_draw').parent().replaceWith($success);}});},_loadTemplates:function(){return ajax.loadXML('/portal/static/src/xml/portal_signature.xml',qweb);},});base.ready().then(function(){$('.o_portal_signature_form').each(function(){var $elem=$(this);var form=new SignatureForm(null,$elem.data());form.appendTo($elem);});});return{SignatureForm:SignatureForm,};});;

/* /payment/static/lib/jquery.payment/jquery.payment.js defined in bundle 'web.assets_frontend' */
(function(){var $,cardFromNumber,cardFromType,cards,defaultFormat,formatBackCardNumber,formatBackExpiry,formatCardNumber,formatExpiry,formatForwardExpiry,formatForwardSlash,hasTextSelected,luhnCheck,reFormatCardNumber,restrictCVC,restrictCardNumber,restrictExpiry,restrictNumeric,setCardType,__slice=[].slice,__indexOf=[].indexOf||function(item){for(var i=0,l=this.length;i<l;i++){if(i in this&&this[i]===item)return i;}return-1;},_this=this;$=jQuery;$.payment={};$.payment.fn={};$.fn.payment=function(){var args,method;method=arguments[0],args=2<=arguments.length?__slice.call(arguments,1):[];return $.payment.fn[method].apply(this,args);};defaultFormat=/(\d{1,4})/g;cards=[{type:'maestro',pattern:/^(5018|5020|5038|6304|6759|676[1-3])/,format:defaultFormat,length:[12,13,14,15,16,17,18,19],cvcLength:[3],luhn:true},{type:'dinersclub',pattern:/^(36|38|30[0-5])/,format:defaultFormat,length:[14],cvcLength:[3],luhn:true},{type:'laser',pattern:/^(6706|6771|6709)/,format:defaultFormat,length:[16,17,18,19],cvcLength:[3],luhn:true},{type:'jcb',pattern:/^35/,format:defaultFormat,length:[16],cvcLength:[3],luhn:true},{type:'unionpay',pattern:/^62/,format:defaultFormat,length:[16,17,18,19],cvcLength:[3],luhn:false},{type:'discover',pattern:/^(6011|65|64[4-9]|622)/,format:defaultFormat,length:[16],cvcLength:[3],luhn:true},{type:'mastercard',pattern:/^(5[1-5]|2[2-7])/,format:defaultFormat,length:[16],cvcLength:[3],luhn:true},{type:'amex',pattern:/^3[47]/,format:/(\d{1,4})(\d{1,6})?(\d{1,5})?/,length:[15],cvcLength:[3,4],luhn:true},{type:'visa',pattern:/^4/,format:defaultFormat,length:[13,14,15,16],cvcLength:[3],luhn:true}];cardFromNumber=function(num){var card,_i,_len;num=(num+'').replace(/\D/g,'');for(_i=0,_len=cards.length;_i<_len;_i++){card=cards[_i];if(card.pattern.test(num)){return card;}}};cardFromType=function(type){var card,_i,_len;for(_i=0,_len=cards.length;_i<_len;_i++){card=cards[_i];if(card.type===type){return card;}}};luhnCheck=function(num){var digit,digits,odd,sum,_i,_len;odd=true;sum=0;digits=(num+'').split('').reverse();for(_i=0,_len=digits.length;_i<_len;_i++){digit=digits[_i];digit=parseInt(digit,10);if((odd=!odd)){digit*=2;}
if(digit>9){digit-=9;}
sum+=digit;}
return sum%10===0;};hasTextSelected=function($target){var _ref;if(($target.prop('selectionStart')!=null)&&$target.prop('selectionStart')!==$target.prop('selectionEnd')){return true;}
if(typeof document!=="undefined"&&document!==null?(_ref=document.selection)!=null?typeof _ref.createRange==="function"?_ref.createRange().text:void 0:void 0:void 0){return true;}
return false;};reFormatCardNumber=function(e){var _this=this;return setTimeout(function(){var $target,value;$target=$(e.currentTarget);value=$target.val();value=$.payment.formatCardNumber(value);return $target.val(value);});};formatCardNumber=function(e){var $target,card,digit,length,re,upperLength,value;digit=String.fromCharCode(e.which);if(!/^\d+$/.test(digit)){return;}
$target=$(e.currentTarget);value=$target.val();card=cardFromNumber(value+digit);length=(value.replace(/\D/g,'')+digit).length;upperLength=16;if(card){upperLength=card.length[card.length.length-1];}
if(length>=upperLength){return;}
if(($target.prop('selectionStart')!=null)&&$target.prop('selectionStart')!==value.length){return;}
if(card&&card.type==='amex'){re=/^(\d{4}|\d{4}\s\d{6})$/;}else{re=/(?:^|\s)(\d{4})$/;}
if(re.test(value)){e.preventDefault();return $target.val(value+' '+digit);}else if(re.test(value+digit)){e.preventDefault();return $target.val(value+digit+' ');}};formatBackCardNumber=function(e){var $target,value;$target=$(e.currentTarget);value=$target.val();if(e.meta){return;}
if(e.which!==8){return;}
if(($target.prop('selectionStart')!=null)&&$target.prop('selectionStart')!==value.length){return;}
if(/\d\s$/.test(value)){e.preventDefault();return $target.val(value.replace(/\d\s$/,''));}else if(/\s\d?$/.test(value)){e.preventDefault();return $target.val(value.replace(/\s\d?$/,''));}};formatExpiry=function(e){var $target,digit,val;digit=String.fromCharCode(e.which);if(!/^\d+$/.test(digit)){return;}
$target=$(e.currentTarget);val=$target.val()+digit;if(/^\d$/.test(val)&&(val!=='0'&&val!=='1')){e.preventDefault();return $target.val("0"+val+" / ");}else if(/^\d\d$/.test(val)){e.preventDefault();return $target.val(""+val+" / ");}};formatForwardExpiry=function(e){var $target,digit,val;digit=String.fromCharCode(e.which);if(!/^\d+$/.test(digit)){return;}
$target=$(e.currentTarget);val=$target.val();if(/^\d\d$/.test(val)){return $target.val(""+val+" / ");}};formatForwardSlash=function(e){var $target,slash,val;slash=String.fromCharCode(e.which);if(slash!=='/'){return;}
$target=$(e.currentTarget);val=$target.val();if(/^\d$/.test(val)&&val!=='0'){return $target.val("0"+val+" / ");}};formatBackExpiry=function(e){var $target,value;if(e.meta){return;}
$target=$(e.currentTarget);value=$target.val();if(e.which!==8){return;}
if(($target.prop('selectionStart')!=null)&&$target.prop('selectionStart')!==value.length){return;}
if(/\d(\s|\/)+$/.test(value)){e.preventDefault();return $target.val(value.replace(/\d(\s|\/)*$/,''));}else if(/\s\/\s?\d?$/.test(value)){e.preventDefault();return $target.val(value.replace(/\s\/\s?\d?$/,''));}};restrictNumeric=function(e){var input;if(e.metaKey||e.ctrlKey){return true;}
if(e.which===32){return false;}
if(e.which===0){return true;}
if(e.which<33){return true;}
input=String.fromCharCode(e.which);return!!/[\d\s]/.test(input);};restrictCardNumber=function(e){var $target,card,digit,value;$target=$(e.currentTarget);digit=String.fromCharCode(e.which);if(!/^\d+$/.test(digit)){return;}
if(hasTextSelected($target)){return;}
value=($target.val()+digit).replace(/\D/g,'');card=cardFromNumber(value);if(card){return value.length<=card.length[card.length.length-1];}else{return value.length<=16;}};restrictExpiry=function(e){var $target,digit,value;$target=$(e.currentTarget);digit=String.fromCharCode(e.which);if(!/^\d+$/.test(digit)){return;}
if(hasTextSelected($target)){return;}
value=$target.val()+digit;value=value.replace(/\D/g,'');if(value.length>6){return false;}};restrictCVC=function(e){var $target,digit,val;$target=$(e.currentTarget);digit=String.fromCharCode(e.which);if(!/^\d+$/.test(digit)){return;}
val=$target.val()+digit;return val.length<=4;};setCardType=function(e){var $target,allTypes,card,cardType,val;$target=$(e.currentTarget);val=$target.val();cardType=$.payment.cardType(val)||'unknown';if(!$target.hasClass(cardType)){allTypes=(function(){var _i,_len,_results;_results=[];for(_i=0,_len=cards.length;_i<_len;_i++){card=cards[_i];_results.push(card.type);}
return _results;})();$target.removeClass('unknown');$target.removeClass(allTypes.join(' '));$target.addClass(cardType);$target.toggleClass('identified',cardType!=='unknown');return $target.trigger('payment.cardType',cardType);}};$.payment.fn.formatCardCVC=function(){this.payment('restrictNumeric');this.on('keypress',restrictCVC);return this;};$.payment.fn.formatCardExpiry=function(){this.payment('restrictNumeric');this.on('keypress',restrictExpiry);this.on('keypress',formatExpiry);this.on('keypress',formatForwardSlash);this.on('keypress',formatForwardExpiry);this.on('keydown',formatBackExpiry);return this;};$.payment.fn.formatCardNumber=function(){this.payment('restrictNumeric');this.on('keypress',restrictCardNumber);this.on('keypress',formatCardNumber);this.on('keydown',formatBackCardNumber);this.on('keyup',setCardType);this.on('paste',reFormatCardNumber);return this;};$.payment.fn.restrictNumeric=function(){this.on('keypress',restrictNumeric);return this;};$.payment.fn.cardExpiryVal=function(){return $.payment.cardExpiryVal($(this).val());};$.payment.cardExpiryVal=function(value){var month,prefix,year,_ref;value=value.replace(/\s/g,'');_ref=value.split('/',2),month=_ref[0],year=_ref[1];if((year!=null?year.length:void 0)===2&&/^\d+$/.test(year)){prefix=(new Date).getFullYear();prefix=prefix.toString().slice(0,2);year=prefix+year;}
month=parseInt(month,10);year=parseInt(year,10);return{month:month,year:year};};$.payment.validateCardNumber=function(num){var card,_ref;num=(num+'').replace(/\s+|-/g,'');if(!/^\d+$/.test(num)){return false;}
card=cardFromNumber(num);if(!card){return false;}
return(_ref=num.length,__indexOf.call(card.length,_ref)>=0)&&(card.luhn===false||luhnCheck(num));};$.payment.validateCardExpiry=function(month,year){var currentTime,expiry,prefix,_ref;if(typeof month==='object'&&'month'in month){_ref=month,month=_ref.month,year=_ref.year;}
if(!(month&&year)){return false;}
month=$.trim(month);year=$.trim(year);if(!/^\d+$/.test(month)){return false;}
if(!/^\d+$/.test(year)){return false;}
if(!(parseInt(month,10)<=12)){return false;}
if(year.length===2){prefix=(new Date).getFullYear();prefix=prefix.toString().slice(0,2);year=prefix+year;}
expiry=new Date(year,month);currentTime=new Date;expiry.setMonth(expiry.getMonth()-1);expiry.setMonth(expiry.getMonth()+1,1);return expiry>currentTime;};$.payment.validateCardCVC=function(cvc,type){var _ref,_ref1;cvc=$.trim(cvc);if(!/^\d+$/.test(cvc)){return false;}
if(type){return _ref=cvc.length,__indexOf.call((_ref1=cardFromType(type))!=null?_ref1.cvcLength:void 0,_ref)>=0;}else{return cvc.length>=3&&cvc.length<=4;}};$.payment.cardType=function(num){var _ref;if(!num){return null;}
return((_ref=cardFromNumber(num))!=null?_ref.type:void 0)||null;};$.payment.formatCardNumber=function(num){var card,groups,upperLength,_ref;card=cardFromNumber(num);if(!card){return num;}
upperLength=card.length[card.length.length-1];num=num.replace(/\D/g,'');num=num.slice(0,+upperLength+1||9e9);if(card.format.global){return(_ref=num.match(card.format))!=null?_ref.join(' '):void 0;}else{groups=card.format.exec(num);if(groups!=null){groups.shift();}
return groups!=null?groups.join(' '):void 0;}};}).call(this);;

/* /payment/static/src/js/payment_portal.js defined in bundle 'web.assets_frontend' */
$(document).ready(function(){$('input#cc_number').payment('formatCardNumber');$('input#cc_cvc').payment('formatCardCVC');$('input#cc_expiry').payment('formatCardExpiry')
$('input#cc_number').on('focusout',function(e){var valid_value=$.payment.validateCardNumber(this.value);var card_type=$.payment.cardType(this.value);if(card_type){$(this).parent('.form-group').children('.card_placeholder').removeClass().addClass('card_placeholder '+card_type);$(this).parent('.form-group').children('input[name="cc_brand"]').val(card_type)}
else{$(this).parent('.form-group').children('.card_placeholder').removeClass().addClass('card_placeholder');}
if(valid_value){$(this).parent('.form-group').addClass('has-success');$(this).parent('.form-group').removeClass('has-error');$(this).siblings('.o_invalid_field').remove();}
else{$(this).parent('.form-group').addClass('has-error');$(this).parent('.form-group').removeClass('has-success');}});$('input#cc_cvc').on('focusout',function(e){var cc_nbr=$(this).parents('.oe_cc').find('#cc_number').val();var card_type=$.payment.cardType(cc_nbr);var valid_value=$.payment.validateCardCVC(this.value,card_type);if(valid_value){$(this).parent('.form-group').addClass('has-success');$(this).parent('.form-group').removeClass('has-error');$(this).siblings('.o_invalid_field').remove();}
else{$(this).parent('.form-group').addClass('has-error');$(this).parent('.form-group').removeClass('has-success');}});$('input#cc_expiry').on('focusout',function(e){var expiry_value=$.payment.cardExpiryVal(this.value);var month=expiry_value.month||'';var year=expiry_value.year||'';var valid_value=$.payment.validateCardExpiry(month,year);if(valid_value){$(this).parent('.form-group').addClass('has-success');$(this).parent('.form-group').removeClass('has-error');$(this).siblings('.o_invalid_field').remove();}
else{$(this).parent('.form-group').addClass('has-error');$(this).parent('.form-group').removeClass('has-success');}});$('select[name="pm_acquirer_id"]').on('change',function(){var acquirer_id=$(this).val();$('.acquirer').addClass('hidden');$('.acquirer[data-acquirer-id="'+acquirer_id+'"]').removeClass('hidden');});});;

/* /payment/static/src/js/payment_transaction_portal.js defined in bundle 'web.assets_frontend' */
;

/* /payment/static/src/js/payment_form.js defined in bundle 'web.assets_frontend' */
odoo.define('payment.payment_form',function(require){"use strict";var ajax=require('web.ajax');var core=require('web.core');var Dialog=require("web.Dialog");var Widget=require("web.Widget");var rpc=require("web.rpc");var _t=core._t;var PaymentForm=Widget.extend({events:{'click #o_payment_form_pay':'payEvent','click #o_payment_form_add_pm':'addPmEvent','click button[name="delete_pm"]':'deletePmEvent','click input[type="radio"]':'radioClickEvent','click .o_payment_form_pay_icon_more':'onClickMorePaymentIcon',},init:function(parent,options){this._super.apply(this,arguments);this.options=_.extend(options||{},{});},start:function(){this.updateNewPaymentDisplayStatus();$('[data-toggle="tooltip"]').tooltip();},disableButton:function(button){$(button).attr('disabled',true);$(button).children('.fa-lock').removeClass('fa-lock');$(button).prepend('<span class="o_loader"><i class="fa fa-refresh fa-spin"></i>&nbsp;</span>');},enableButton:function(button){$(button).attr('disabled',false);$(button).children('.fa').addClass('fa-lock');$(button).find('span.o_loader').remove();},payEvent:function(ev){ev.preventDefault();var form=this.el;var checked_radio=this.$('input[type="radio"]:checked');var self=this;var button=ev.target;if(checked_radio.length===1){checked_radio=checked_radio[0];var acquirer_id=this.getAcquirerIdFromRadio(checked_radio);var acquirer_form=false;if(this.isNewPaymentRadio(checked_radio)){acquirer_form=this.$('#o_payment_add_token_acq_'+acquirer_id);}else{acquirer_form=this.$('#o_payment_form_acq_'+acquirer_id);}
var inputs_form=$('input',acquirer_form);var ds=$('input[name="data_set"]',acquirer_form)[0];if(this.isNewPaymentRadio(checked_radio)){if(this.options.partnerId===undefined){console.warn('payment_form: unset partner_id when adding new token; things could go wrong');}
var form_data=this.getFormData(inputs_form);var wrong_input=false;inputs_form.toArray().forEach(function(element){if($(element).attr('type')=='hidden'){return true;}
$(element).closest('div.form-group').removeClass('has-error');$(element).siblings(".o_invalid_field").remove();$(element).trigger("focusout");if(element.dataset.isRequired&&element.value.length===0){$(element).closest('div.form-group').addClass('has-error');$(element).closest('div.form-group').append('<div style="color: red" class="o_invalid_field">'+_.str.escapeHTML("The value is invalid.")+'</div>');wrong_input=true;}
else if($(element).closest('div.form-group').hasClass('has-error')){wrong_input=true;$(element).closest('div.form-group').append('<div style="color: red" class="o_invalid_field">'+_.str.escapeHTML("The value is invalid.")+'</div>');}});if(wrong_input){return;}
this.disableButton(button);var verify_validity=this.$el.find('input[name="verify_validity"]');if(verify_validity.length>0){form_data.verify_validity=verify_validity[0].value==="1";}
ajax.jsonRpc(ds.dataset.createRoute,'call',form_data).then(function(data){if(data.result){if(data['3d_secure']!==false){$("body").html(data['3d_secure']);}
else{checked_radio.value=data.id;form.submit();return;}}
else{if(data.error){self.displayError('',data.error);}else{self.displayError(_t('Server Error'),_t('e.g. Your credit card details are wrong. Please verify.'));}}
self.enableButton(button);}).fail(function(message,data){self.enableButton(button);self.displayError(_t('Server Error'),_t("We are not able to add your payment method at the moment.")+
message.data.message);});}
else if(this.isFormPaymentRadio(checked_radio)){var $tx_url=this.$el.find('input[name="prepare_tx_url"]');if($tx_url.length===1){var form_save_token=acquirer_form.find('input[name="o_payment_form_save_token"]').prop('checked');ajax.jsonRpc($tx_url[0].value,'call',{'acquirer_id':parseInt(acquirer_id),'save_token':form_save_token,'access_token':self.options.accessToken,'success_url':self.options.successUrl,'error_url':self.options.errorUrl,'callback_method':self.options.callbackMethod,}).then(function(result){if(result){var newForm=document.createElement('form');newForm.setAttribute("method","post");newForm.setAttribute("provider",checked_radio.dataset.provider);newForm.hidden=true;newForm.innerHTML=result;var action_url=$(newForm).find('input[name="data_set"]').data('actionUrl');newForm.setAttribute("action",action_url);$(document.getElementsByTagName('body')[0]).append(newForm);$(newForm).find('input[data-remove-me]').remove();if(action_url){newForm.submit();}}
else{self.displayError(_t('Server Error'),_t("We are not able to redirect you to the payment form."));}}).fail(function(message,data){self.displayError(_t('Server Error'),_t("We are not able to redirect you to the payment form. ")+
message.data.message);});}
else{this.displayError(_t("Cannot set-up the payment"),_t("We're unable to process your payment."));}}
else{this.disableButton(button);form.submit();}}
else{this.displayError(_t('No payment method selected'),_t('Please select a payment method.'));}},addPmEvent:function(ev){ev.stopPropagation();ev.preventDefault();var checked_radio=this.$('input[type="radio"]:checked');var self=this;var button=ev.target;if(checked_radio.length===1&&this.isNewPaymentRadio(checked_radio[0])){checked_radio=checked_radio[0];var acquirer_id=this.getAcquirerIdFromRadio(checked_radio);var acquirer_form=this.$('#o_payment_add_token_acq_'+acquirer_id);var inputs_form=$('input',acquirer_form);var form_data=this.getFormData(inputs_form);var ds=$('input[name="data_set"]',acquirer_form)[0];var wrong_input=false;inputs_form.toArray().forEach(function(element){if($(element).attr('type')=='hidden'){return true;}
$(element).closest('div.form-group').removeClass('has-error');$(element).siblings(".o_invalid_field").remove();$(element).trigger("focusout");if(element.dataset.isRequired&&element.value.length===0){$(element).closest('div.form-group').addClass('has-error');var message='<div style="color: red" class="o_invalid_field">'+_.str.escapeHTML("The value is invalid.")+'</div>';$(element).closest('div.form-group').append(message);wrong_input=true;}
else if($(element).closest('div.form-group').hasClass('has-error')){wrong_input=true;var message='<div style="color: red" class="o_invalid_field">'+_.str.escapeHTML("The value is invalid.")+'</div>';$(element).closest('div.form-group').append(message);}});if(wrong_input){return;}
$(button).attr('disabled',true);$(button).children('.fa-plus-circle').removeClass('fa-plus-circle')
$(button).prepend('<span class="o_loader"><i class="fa fa-refresh fa-spin"></i>&nbsp;</span>');form_data.verify_validity=true;ajax.jsonRpc(ds.dataset.createRoute,'call',form_data).then(function(data){if(data.result){if(data['3d_secure']!==false){$("body").html(data['3d_secure']);}
else{if(form_data.return_url){window.location=form_data.return_url;}
else{window.location.reload();}}}
else{if(data.error){self.displayError('',data.error);}else{self.displayError(_t('Server Error'),_t('e.g. Your credit card details are wrong. Please verify.'));}}
$(button).attr('disabled',false);$(button).children('.fa').addClass('fa-plus-circle')
$(button).find('span.o_loader').remove();}).fail(function(message,data){$(button).attr('disabled',false);$(button).children('.fa').addClass('fa-plus-circle')
$(button).find('span.o_loader').remove();self.displayError(_t('Server error'),_t("We are not able to add your payment method at the moment.</p>")+
data.data.message);});}
else{this.displayError(_t('No payment method selected'),_t('Please select the option to add a new payment method.'));}},deletePmEvent:function(ev){ev.stopPropagation();ev.preventDefault();var self=this;var pm_id=parseInt(ev.target.value);var tokenDelete=function(){rpc.query({model:'payment.token',method:'unlink',args:[pm_id],}).then(function(result){if(result===true){ev.target.closest('div').remove();}},function(){self.displayError(_t('Server Error'),_t("We are not able to delete your payment method at the moment."));});};rpc.query({model:'payment.token',method:'get_linked_records',args:[pm_id],}).then(function(result){if(result[pm_id].length>0){var content='';result[pm_id].forEach(function(sub){content+='<p><a href="'+sub.url+'" title="'+sub.description+'">'+sub.name+'</a><p/>';});content=$('<div>').html(_t('<p>This card is currently linked to the following records:<p/>')+content);new Dialog(self,{title:_t('Warning!'),size:'medium',$content:content,buttons:[{text:_t('Confirm Deletion'),classes:'btn-primary',close:true,click:tokenDelete},{text:_t('Cancel'),close:true}]}).open();}
else{tokenDelete();}},function(type,err){self.displayError(_t('Server Error'),_t("We are not able to delete your payment method at the moment.")+err.data.message);});},onClickMorePaymentIcon:function(ev){ev.preventDefault();var $listItems=$(ev.currentTarget).parents('ul').children('li');var $moreItem=$(ev.currentTarget).parents('li');$listItems.removeClass('hidden');$moreItem.addClass('hidden');},radioClickEvent:function(ev){this.updateNewPaymentDisplayStatus();},updateNewPaymentDisplayStatus:function()
{var checked_radio=this.$('input[type="radio"]:checked');this.$('[id*="o_payment_add_token_acq_"]').addClass('hidden');this.$('[id*="o_payment_form_acq_"]').addClass('hidden');if(checked_radio.length!==1){return;}
checked_radio=checked_radio[0];var acquirer_id=this.getAcquirerIdFromRadio(checked_radio);if(this.isNewPaymentRadio(checked_radio)){this.$('#o_payment_add_token_acq_'+acquirer_id).removeClass('hidden');}
else if(this.isFormPaymentRadio(checked_radio)){this.$('#o_payment_form_acq_'+acquirer_id).removeClass('hidden');}},isNewPaymentRadio:function(element){return $(element).data('s2s-payment')==='True';},isFormPaymentRadio:function(element){return $(element).data('form-payment')==='True';},getAcquirerIdFromRadio:function(element){return $(element).data('acquirer-id');},displayError:function(title,message){var $checkedRadio=this.$('input[type="radio"]:checked'),acquirerID=this.getAcquirerIdFromRadio($checkedRadio[0]);var $acquirerForm;if(this.isNewPaymentRadio($checkedRadio[0])){$acquirerForm=this.$('#o_payment_add_token_acq_'+acquirerID);}
else if(this.isFormPaymentRadio($checkedRadio[0])){$acquirerForm=this.$('#o_payment_form_acq_'+acquirerID);}
if(!$acquirerForm||$checkedRadio.length===0){return new Dialog(null,{title:_t('Error: ')+_.str.escapeHTML(title),size:'medium',$content:"<p>"+(_.str.escapeHTML(message)||"")+"</p>",buttons:[{text:_t('Ok'),close:true}]}).open();}else{this.$('#payment_error').remove();var messageResult='<div class="alert alert-danger mb4" id="payment_error">';if(title!=''){messageResult=messageResult+'<b>'+_.str.escapeHTML(title)+':</b></br>';}
messageResult=messageResult+_.str.escapeHTML(message)+'</div>';$acquirerForm.append(messageResult);}},getFormData:function($form){var unindexed_array=$form.serializeArray();var indexed_array={};$.map(unindexed_array,function(n,i){indexed_array[n.name]=n.value;});return indexed_array;},});$(function(){if(!$('.o_payment_form').length){console.log("DOM doesn't contain '.o_payment_form'");return;}
$('.o_payment_form').each(function(){var $elem=$(this);var form=new PaymentForm(null,$elem.data());form.attachTo($elem);});});return PaymentForm;});;

/* /website/static/src/js/utils.js defined in bundle 'web.assets_frontend' */
odoo.define('website.utils',function(require){'use strict';var ajax=require('web.ajax');var core=require('web.core');var weContext=require('web_editor.context');var qweb=core.qweb;function autocompleteWithPages(self,$input){$input.autocomplete({source:function(request,response){return self._rpc({model:'website',method:'search_pages',args:[null,request.term],kwargs:{limit:15,context:weContext.get(),},}).then(function(exists){var rs=_.map(exists,function(r){return r.loc;});response(rs);});},});}
function prompt(options,_qweb){if(typeof options==='string'){options={text:options};}
var xmlDef;if(_.isUndefined(_qweb)){_qweb='website.prompt';xmlDef=ajax.loadXML('/website/static/src/xml/website.xml',core.qweb);}
options=_.extend({window_title:'',field_name:'','default':'',init:function(){},},options||{});var type=_.intersection(Object.keys(options),['input','textarea','select']);type=type.length?type[0]:'input';options.field_type=type;options.field_name=options.field_name||options[type];var def=$.Deferred();$.when(xmlDef).then(function(){var dialog=$(qweb.render(_qweb,options)).appendTo('body');options.$dialog=dialog;var field=dialog.find(options.field_type).first();field.val(options['default']);field.fillWith=function(data){if(field.is('select')){var select=field[0];data.forEach(function(item){select.options[select.options.length]=new window.Option(item[1],item[0]);});}else{field.val(data);}};var init=options.init(field,dialog);$.when(init).then(function(fill){if(fill){field.fillWith(fill);}
dialog.modal('show');field.focus();dialog.on('click','.btn-primary',function(){var backdrop=$('.modal-backdrop');def.resolve(field.val(),field,dialog);dialog.modal('hide').remove();backdrop.remove();});});dialog.on('hidden.bs.modal',function(){var backdrop=$('.modal-backdrop');def.reject();dialog.remove();backdrop.remove();});if(field.is('input[type="text"], select')){field.keypress(function(e){if(e.which===13){e.preventDefault();dialog.find('.btn-primary').trigger('click');}});}});return def;}
return{autocompleteWithPages:autocompleteWithPages,prompt:prompt,};});;

/* /website/static/src/js/website.js defined in bundle 'web.assets_frontend' */
odoo.define('website.website',function(require){'use strict';var weContext=require('web_editor.context');var weGetContext=weContext.get;weContext.get=function(context){var html=document.documentElement;return _.extend({website_id:html.getAttribute('data-website-id')|0,},weGetContext(context),context);};});;

/* /website/static/src/js/content/compatibility.js defined in bundle 'web.assets_frontend' */
odoo.define('website.content.compatibility',function(require){'use strict';require('web.dom_ready');var browser=_.findKey($.browser,function(v){return v===true;});if($.browser.mozilla&&+$.browser.version.replace(/^([0-9]+\.[0-9]+).*/,'\$1')<20){browser='msie';}
browser+=(','+$.browser.version);var mobileRegex=/android|webos|iphone|ipad|ipod|blackberry|iemobile|opera mini/i;if(mobileRegex.test(window.navigator.userAgent.toLowerCase())){browser+=',mobile';}
document.documentElement.setAttribute('data-browser',browser);var htmlStyle=document.documentElement.style;var isFlexSupported=(('flexWrap'in htmlStyle)||('WebkitFlexWrap'in htmlStyle)||('msFlexWrap'in htmlStyle));if(!isFlexSupported){document.documentElement.setAttribute('data-no-flex','');}
return{browser:browser,isFlexSupported:isFlexSupported,};});;

/* /website/static/src/js/content/lazy_template_call.js defined in bundle 'web.assets_frontend' */
odoo.define('website.content.lazy_template_call',function(require){'use strict';var Widget=require('web.Widget');var websiteRootData=require('website.WebsiteRoot');var LazyTemplateRenderer=Widget.extend({start:function(){var $oeCalls=this.$('[data-oe-call]');var oeCalls=_.uniq($oeCalls.map(function(){return $(this).data('oe-call');}).get());if(!oeCalls.length){return $.when(this._super.apply(this,arguments));}
var def=this._rpc({route:'/website/multi_render',params:{ids_or_xml_ids:oeCalls,},}).then(function(data){_.each(data,function(d,k){var $data=$(d).addClass('o_block_'+k);$oeCalls.filter('[data-oe-call="'+k+'"]').each(function(){$(this).replaceWith($data.clone());});});});return $.when(this._super.apply(this,arguments),def);},});websiteRootData.websiteRootRegistry.add(LazyTemplateRenderer,'#wrapwrap');return LazyTemplateRenderer;});;

/* /website/static/src/js/content/snippets.animation.js defined in bundle 'web.assets_frontend' */
odoo.define('website.content.snippets.animation',function(require){'use strict';var Class=require('web.Class');var core=require('web.core');var mixins=require('web.mixins');var Widget=require('web.Widget');var qweb=core.qweb;window.requestAnimationFrame=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.msRequestAnimationFrame||window.oRequestAnimationFrame||function(callback){setTimeout(callback,10);};window.cancelAnimationFrame=window.cancelAnimationFrame||window.webkitCancelAnimationFrame||window.mozCancelAnimationFrame||window.msCancelAnimationFrame||window.oCancelAnimationFrame||function(id){clearTimeout(id);};if(!window.performance||!window.performance.now){window.performance={now:function(){return Date.now();}};}
var AnimationEffect=Class.extend(mixins.ParentedMixin,{init:function(parent,updateCallback,startEvents,$startTarget,options){mixins.ParentedMixin.init.call(this);this.setParent(parent);options=options||{};this._minFrameTime=1000/(options.maxFPS||100);this._updateCallback=updateCallback;this.startEvents=startEvents||'scroll';this.$startTarget=$($startTarget||window);this._getStateCallback=options.getStateCallback||((this.startEvents==='scroll'&&this.$startTarget[0]===window)?function(){return window.pageYOffset;}:false)||((this.startEvents==='resize'&&this.$startTarget[0]===window)?function(){return{width:window.innerWidth,height:window.innerHeight};}:false)||function(){return undefined;};this.endEvents=options.endEvents||false;this.$endTarget=options.$endTarget?$(options.$endTarget):this.$startTarget;this._updateCallback=this._updateCallback.bind(parent);this._getStateCallback=this._getStateCallback.bind(parent);this._uid='_animationEffect'+_.uniqueId();this.startEvents=_processEvents(this.startEvents,this._uid);if(this.endEvents){this.endEvents=_processEvents(this.endEvents,this._uid);}
function _processEvents(events,namespace){events=events.split(' ');return _.each(events,function(e,index){events[index]+=('.'+namespace);}).join(' ');}},destroy:function(){mixins.ParentedMixin.destroy.call(this);this.stop();},start:function(){this._paused=false;this._rafID=window.requestAnimationFrame((function(t){this._update(t);this._paused=true;}).bind(this));if(this.endEvents){this.$startTarget.on(this.startEvents,(function(e){if(this._paused){_.defer(this.play.bind(this,e));}}).bind(this));this.$endTarget.on(this.endEvents,(function(){if(!this._paused){_.defer(this.pause.bind(this));}}).bind(this));}else{var pauseTimer=null;this.$startTarget.on(this.startEvents,_.throttle((function(e){this.play(e);clearTimeout(pauseTimer);pauseTimer=_.delay((function(){this.pause();pauseTimer=null;}).bind(this),2000);}).bind(this),250,{trailing:false}));}},stop:function(){this.$startTarget.off(this.startEvents);if(this.endEvents){this.$endTarget.off(this.endEvents);}
this.pause();},play:function(e){this._newEvent=e;if(!this._paused)return;this._paused=false;this._rafID=window.requestAnimationFrame(this._update.bind(this));this._lastUpdateTimestamp=undefined;},pause:function(){if(this._paused)return;this._paused=true;window.cancelAnimationFrame(this._rafID);this._lastUpdateTimestamp=undefined;},_update:function(timestamp){if(this._paused)return;this._rafID=window.requestAnimationFrame(this._update.bind(this));var elapsedTime=0;if(this._lastUpdateTimestamp){elapsedTime=timestamp-this._lastUpdateTimestamp;if(elapsedTime<this._minFrameTime)return;}
var animationState=this._getStateCallback(elapsedTime,this._newEvent);if(!this._newEvent&&animationState!==undefined&&_.isEqual(animationState,this._animationLastState)){return;}
this._animationLastState=animationState;this._updateCallback(this._animationLastState,elapsedTime,this._newEvent);this._lastUpdateTimestamp=timestamp;this._newEvent=undefined;},});var Animation=Widget.extend({selector:false,edit_events:{},read_events:{},maxFPS:100,effects:[],init:function(parent,editableMode){this._super.apply(this,arguments);this.editableMode=editableMode;if(editableMode){this.events=_.extend({},this.events||{},this.edit_events||{});}else{this.events=_.extend({},this.events||{},this.read_events||{});}},start:function(){this._prepareEffects();_.each(this._animationEffects,function(effect){effect.start();});return this._super.apply(this,arguments);},destroy:function(){var $oldel=this.$el;this.setElement(null);this._super.apply(this,arguments);this.$el=$oldel;this.el=$oldel[0];this.$target=this.$el;this.target=this.el;},setElement:function(){this._super.apply(this,arguments);this.$target=this.$el;this.target=this.el;},_prepareEffects:function(){this._animationEffects=[];var self=this;_.each(this.effects,function(desc){self._addEffect(self[desc.update],desc.startEvents,_findTarget(desc.startTarget),{getStateCallback:desc.getState&&self[desc.getState],endEvents:desc.endEvents||undefined,$endTarget:_findTarget(desc.endTarget),maxFPS:self.maxFPS,});function _findTarget(selector){if(selector){if(selector==='selector'){return self.$target;}
return self.$(selector);}
return undefined;}});},_addEffect:function(updateCallback,startEvents,$startTarget,options){this._animationEffects.push(new AnimationEffect(this,updateCallback,startEvents,$startTarget,options));},});var registry={};registry.slider=Animation.extend({selector:'.carousel',start:function(){this.$target.carousel();return this._super.apply(this,arguments);},destroy:function(){this._super.apply(this,arguments);this.$target.carousel('pause');this.$target.removeData('bs.carousel');},});registry.parallax=Animation.extend({selector:'.parallax',effects:[{startEvents:'scroll',update:'_onWindowScroll',}],start:function(){this._rebuild();$(window).on('resize.animation_parallax',_.debounce(this._rebuild.bind(this),500));return this._super.apply(this,arguments);},destroy:function(){this._super.apply(this,arguments);$(window).off('.animation_parallax');},_rebuild:function(){if(!this.$bg||!this.$bg.length){this.$bg=this.$('> .s_parallax_bg');if(!this.$bg.length){this.$bg=$('<span/>',{class:'s_parallax_bg'+(this.$target.hasClass('oe_custom_bg')?' oe_custom_bg':''),}).prependTo(this.$target);}}
var urlTarget=this.$target.css('background-image');if(urlTarget!=='none'){this.$bg.css('background-image',urlTarget);}
this.$target.css('background-image','none');this.speed=parseFloat(this.$target.attr('data-scroll-background-ratio')||0);this.$target.toggleClass('s_parallax_is_fixed',this.speed===1);if(this.speed===0||this.speed===1){this.$bg.css({transform:'',top:'',bottom:''});return;}
this.viewport=document.body.clientHeight-$('#wrapwrap').position().top;this.visible_area=[this.$target.offset().top];this.visible_area.push(this.visible_area[0]+this.$target.innerHeight()+this.viewport);this.ratio=this.speed*(this.viewport/10);this.$bg.css({top:-this.ratio,bottom:-this.ratio,});},_onWindowScroll:function(scrollOffset){if(this.speed===0||this.speed===1){return;}
var vpEndOffset=scrollOffset+this.viewport;if(vpEndOffset>=this.visible_area[0]&&vpEndOffset<=this.visible_area[1]){this.$bg.css('transform','translateY('+_getNormalizedPosition.call(this,vpEndOffset)+'px)');}
function _getNormalizedPosition(pos){var r=(pos-this.visible_area[1])/(this.visible_area[0]-this.visible_area[1]);return Math.round(this.ratio*(2*r-1));}},});registry.share=Animation.extend({selector:'.oe_share',start:function(){var url_regex=/(\?(?:|.*&)(?:u|url|body)=)(.*?)(&|#|$)/;var title_regex=/(\?(?:|.*&)(?:title|text|subject)=)(.*?)(&|#|$)/;var url=encodeURIComponent(window.location.href);var title=encodeURIComponent($('title').text());this.$('a').each(function(){var $a=$(this);$a.attr('href',function(i,href){return href.replace(url_regex,function(match,a,b,c){return a+url+c;}).replace(title_regex,function(match,a,b,c){return a+title+c;});});if($a.attr('target')&&$a.attr('target').match(/_blank/i)&&!$a.closest('.o_editable').length){$a.on('click',function(){window.open(this.href,'','menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=550,width=600');return false;});}});return this._super.apply(this,arguments);},});registry.mediaVideo=Animation.extend({selector:'.media_iframe_video',start:function(){var def=this._super.apply(this,arguments);if(this.$target.children('iframe').length){return def;}
this.$target.empty();this.$target.append('<div class="css_editable_mode_display">&nbsp;</div>'+'<div class="media_iframe_video_size">&nbsp;</div>');this.$target.append($('<iframe/>',{src:_.escape(this.$target.data('oe-expression')||this.$target.data('src')),frameborder:'0',allowfullscreen:'allowfullscreen',sandbox:'allow-scripts allow-same-origin',}));return def;},});registry.ul=Animation.extend({selector:'ul.o_ul_folded, ol.o_ul_folded',events:{'click .o_ul_toggle_next':'_onToggleNextClick','click .o_ul_toggle_self':'_onToggleSelfClick',},_onToggleNextClick:function(ev){ev.preventDefault();var $target=$(ev.currentTarget);$target.toggleClass('o_open');$target.closest('li').next().toggleClass('o_close');},_onToggleSelfClick:function(ev){ev.preventDefault();var $target=$(ev.currentTarget);$target.toggleClass('o_open');$target.closest('li').find('ul,ol').toggleClass('o_close');},});registry.gallery=Animation.extend({selector:'.o_gallery:not(.o_slideshow)',xmlDependencies:['/website/static/src/xml/website.gallery.xml'],read_events:{'click img':'_onClickImg',},_onClickImg:function(ev){var self=this;var $cur=$(ev.currentTarget);var urls=[];var idx=undefined;var milliseconds=undefined;var params=undefined;var $images=$cur.closest('.o_gallery').find('img');var size=0.8;var dimensions={min_width:Math.round(window.innerWidth*size*0.9),min_height:Math.round(window.innerHeight*size),max_width:Math.round(window.innerWidth*size*0.9),max_height:Math.round(window.innerHeight*size),width:Math.round(window.innerWidth*size*0.9),height:Math.round(window.innerHeight*size)};$images.each(function(){urls.push($(this).attr('src'));});var $img=($cur.is('img')===true)?$cur:$cur.closest('img');idx=urls.indexOf($img.attr('src'));milliseconds=$cur.closest('.o_gallery').data('interval')||false;params={srcs:urls,index:idx,dim:dimensions,interval:milliseconds,id:_.uniqueId('slideshow_')};var $modal=$(qweb.render('website.gallery.slideshow.lightbox',params));$modal.modal({keyboard:true,backdrop:true,});$modal.on('hidden.bs.modal',function(){$(this).hide();$(this).siblings().filter('.modal-backdrop').remove();$(this).remove();});$modal.find('.modal-content, .modal-body.o_slideshow').css('height','100%');$modal.appendTo(document.body);$modal.one('shown.bs.modal',function(){self.trigger_up('animation_start_demand',{editableMode:false,$target:$modal.find('.modal-body.o_slideshow'),});});},});registry.gallerySlider=Animation.extend({selector:'.o_slideshow',xmlDependencies:['/website/static/src/xml/website.gallery.xml'],start:function(){var self=this;this.$carousel=this.$target.is('.carousel')?this.$target:this.$target.find('.carousel');this.$indicator=this.$carousel.find('.carousel-indicators');this.$prev=this.$indicator.find('li.fa:first').css('visibility','');this.$next=this.$indicator.find('li.fa:last').css('visibility','');var $lis=this.$indicator.find('li:not(.fa)');var nbPerPage=Math.floor(this.$indicator.width()/$lis.first().outerWidth(true))-3;var realNbPerPage=nbPerPage||1;var nbPages=Math.ceil($lis.length/realNbPerPage);var index;var page;update();function hide(){$lis.each(function(i){$(this).toggleClass('hidden',!(i>=page*nbPerPage&&i<(page+1)*nbPerPage));});if(self.editableMode){return;}
if(page<=0){self.$prev.detach();}else{self.$prev.prependTo(self.$indicator);}
if(page>=nbPages-1){self.$next.detach();}else{self.$next.appendTo(self.$indicator);}}
function update(){index=$lis.index($lis.filter('.active'))||0;page=Math.floor(index/realNbPerPage);hide();}
this.$carousel.on('slide.bs.carousel.gallery_slider',function(){setTimeout(function(){var $item=self.$carousel.find('.carousel-inner .prev, .carousel-inner .next');var index=$item.index();$lis.removeClass('active').filter('[data-slide-to="'+index+'"]').addClass('active');},0);});this.$indicator.on('click.gallery_slider','> li.fa',function(){page+=($(this).hasClass('o_indicators_left')?-1:1);page=Math.max(0,Math.min(nbPages-1,page));self.$carousel.carousel(page*realNbPerPage);hide();});this.$carousel.on('slid.bs.carousel.gallery_slider',update);return this._super.apply(this,arguments);},destroy:function(){this._super.apply(this,arguments);if(!this.$indicator){return;}
this.$prev.prependTo(this.$indicator);this.$next.appendTo(this.$indicator);this.$carousel.off('.gallery_slider');this.$indicator.off('.gallery_slider');},});registry.socialShare=Animation.extend({selector:'.oe_social_share',xmlDependencies:['/website/static/src/xml/website.share.xml'],read_events:{'mouseenter':'_onMouseEnter',},_bindSocialEvent:function(){this.$('.oe_social_facebook').click($.proxy(this._renderSocial,this,'facebook'));this.$('.oe_social_twitter').click($.proxy(this._renderSocial,this,'twitter'));this.$('.oe_social_linkedin').click($.proxy(this._renderSocial,this,'linkedin'));this.$('.oe_social_google-plus').click($.proxy(this._renderSocial,this,'google-plus'));},_render:function(){this.$target.popover({content:qweb.render('website.social_hover',{medias:this.socialList}),placement:'bottom',container:this.$target,html:true,trigger:'manual',animation:false,}).popover("show");this.$target.off('mouseleave.socialShare').on('mouseleave.socialShare',function(){var self=this;setTimeout(function(){if(!$(".popover:hover").length){$(self).popover("destroy");}},200);});},_renderSocial:function(social){var url=encodeURIComponent(document.URL.split(/[?#]/)[0]);var title=document.title.split(" | ")[0];var hashtags=' #'+document.title.split(" | ")[1].replace(' ','')+' '+this.hashtags;var social_network={'facebook':'https://www.facebook.com/sharer/sharer.php?u='+url,'twitter':'https://twitter.com/intent/tweet?original_referer='+url+'&text='+encodeURIComponent(title+hashtags+' - ')+url,'linkedin':'https://www.linkedin.com/shareArticle?mini=true&url='+url+'&title='+encodeURIComponent(title),'google-plus':'https://plus.google.com/share?url='+url,};if(!_.contains(_.keys(social_network),social)){return;}
var wHeight=500;var wWidth=500;window.open(social_network[social],'','menubar=no, toolbar=no, resizable=yes, scrollbar=yes, height='+wHeight+',width='+wWidth);},_onMouseEnter:function(){var social=this.$target.data('social');this.socialList=social?social.split(','):['facebook','twitter','linkedin','google-plus'];this.hashtags=this.$target.data('hashtags')||'';this._render();this._bindSocialEvent();},});registry._fixAppleCollapse=Animation.extend({selector:'.s_faq_collapse [data-toggle="collapse"]',events:{'click':function(){},},});return{Class:Animation,registry:registry,};});;

/* /website/static/src/js/content/website_root.js defined in bundle 'web.assets_frontend' */
odoo.define('website.WebsiteRoot.instance',function(require){'use strict';require('web.dom_ready');var websiteRootData=require('website.WebsiteRoot');var websiteRoot=new websiteRootData.WebsiteRoot(null);return websiteRoot.attachTo(document.body).then(function(){return websiteRoot;});});odoo.define('website.WebsiteRoot',function(require){'use strict';var ajax=require('web.ajax');var core=require('web.core');var Dialog=require('web.Dialog');var utils=require('web.utils');var BodyManager=require('web_editor.BodyManager');var weContext=require('web_editor.context');var rootWidget=require('web_editor.root_widget');var sAnimation=require('website.content.snippets.animation');require("website.content.zoomodoo");var _t=core._t;var websiteRootRegistry=new rootWidget.RootWidgetRegistry();var lang=utils.get_cookie('frontend_lang')||weContext.get().lang;var localeDef=ajax.loadJS('/web/webclient/locale/'+lang.replace('-','_'));var WebsiteRoot=BodyManager.extend({events:_.extend({},BodyManager.prototype.events||{},{'click .js_change_lang':'_onLangChangeClick','click .js_publish_management .js_publish_btn':'_onPublishBtnClick','submit .js_website_submit_form':'_onWebsiteFormSubmit','click .js_disable_on_click':'_onDisableOnClick',}),custom_events:_.extend({},BodyManager.prototype.custom_events||{},{animation_start_demand:'_onAnimationStartDemand',animation_stop_demand:'_onAnimationStopDemand',ready_to_clean_for_save:'_onAnimationStopDemand',}),init:function(){this._super.apply(this,arguments);this.animations=[];},willStart:function(){return $.when(this._super.apply(this,arguments),localeDef);},start:function(){var defs=[this._super.apply(this,arguments)];defs.push(this._startAnimations());if(!this.$('.js_change_lang').length){var $links=this.$('ul.js_language_selector li a:not([data-oe-id])');var m=$(_.min($links,function(l){return $(l).attr('href').length;})).attr('href');$links.each(function(){var $link=$(this);var t=$link.attr('href');var l=(t===m)?"default":t.split('/')[1];$link.data('lang',l).addClass('js_change_lang');});}
this.$(".o_image[data-mimetype^='image']").each(function(){var $img=$(this);if(/gif|jpe|jpg|png/.test($img.data('mimetype'))&&$img.data('src')){$img.css('background-image',"url('"+$img.data('src')+"')");}});this.$('.zoomable img[data-zoom]').zoomOdoo();if(window.location.hash.indexOf("scrollTop=")>-1){this.el.scrollTop=+window.location.hash.match(/scrollTop=([0-9]+)/)[1];}
if($.fn.placeholder){$('input, textarea').placeholder();}
return $.when.apply($,defs);},_getRegistry:function(){return websiteRootRegistry;},_startAnimations:function(editableMode,$from){var self=this;editableMode=editableMode||false;if($from===undefined){$from=this.$('#wrapwrap');}
var defs=_.map(sAnimation.registry,function(Animation){var selector=Animation.prototype.selector||'';var $target=$from.find(selector).addBack(selector);var defs=_.map($target,function(el){var $snippet=$(el);var animation=$snippet.data('snippet-view');if(animation){self.animations=_.without(self.animations,animation);animation.destroy();}
animation=new Animation(self,editableMode);self.animations.push(animation);$snippet.data('snippet-view',animation);return animation.attachTo($snippet);});return $.when.apply($,defs);});return $.when.apply($,defs);},_stopAnimations:function($from){var removedAnimations=_.map(this.animations,function(animation){if(!$from||$from.filter(animation.el).length||$from.find(animation.el).length){animation.destroy();return animation;}
return null;});this.animations=_.difference(this.animations,removedAnimations);},_onAnimationStartDemand:function(ev){this._startAnimations(ev.data.editableMode,ev.data.$target).done(ev.data.onSuccess).fail(ev.data.onFailure);},_onAnimationStopDemand:function(ev){this._stopAnimations(ev.data.$target);},_onLangChangeClick:function(ev){ev.preventDefault();var $target=$(ev.target);var redirect={lang:$target.data('lang'),url:encodeURIComponent($target.attr('href').replace(/[&?]edit_translations[^&?]+/,'')),hash:encodeURIComponent(window.location.hash)};window.location.href=_.str.sprintf("/website/lang/%(lang)s?r=%(url)s%(hash)s",redirect);},_onPublishBtnClick:function(ev){ev.preventDefault();var self=this;var $data=$(ev.currentTarget).parents(".js_publish_management:first");this._rpc({route:$data.data('controller')||'/website/publish',params:{id:+$data.data('id'),object:$data.data('object'),},}).done(function(result){$data.toggleClass("css_unpublished css_published");$data.find('input').prop("checked",result);$data.parents("[data-publish]").attr("data-publish",+result?'on':'off');}).fail(function(err,data){return new Dialog(self,{title:data.data?data.data.arguments[0]:"",$content:$('<div/>',{html:(data.data?data.data.arguments[1]:data.statusText)
+'<br/>'
+_.str.sprintf(_t('It might be possible to edit the relevant items or fix the issue in <a href="%s">the classic Odoo interface</a>'),'/web#return_label=Website&model='+$data.data('object')+'&id='+$data.data('id')),}),}).open();});},_onWebsiteFormSubmit:function(ev){var $buttons=$(ev.currentTarget).find('button[type="submit"], a.a-submit');_.each($buttons,function(btn){var $btn=$(btn);$btn.attr('data-loading-text','<i class="fa fa-spinner fa-spin"></i> '+$(btn).text());$btn.button('loading');});},_onDisableOnClick:function(ev){$(ev.currentTarget).addClass('disabled');},});return{WebsiteRoot:WebsiteRoot,websiteRootRegistry:websiteRootRegistry,};});;

/* /website/static/src/js/content/zoomodoo.js defined in bundle 'web.assets_frontend' */
odoo.define('website.content.zoomodoo',function(require){'use strict';var dw,dh,rw,rh,lx,ly;var defaults={linkTag:'a',linkAttribute:'data-zoom-image',event:'click',preventClicks:true,disabledOnMobile:true,beforeShow:$.noop,beforeHide:$.noop,onShow:$.noop,onHide:$.noop,onMove:$.noop};function ZoomOdoo(target,options){this.$target=$(target);this.opts=$.extend({},defaults,options,this.$target.data());if(this.isOpen===undefined){this._init();}}
ZoomOdoo.prototype._init=function(){if(window.outerWidth>467||!this.opts.disabledOnMobile){this.$link=this.$target.find(this.opts.linkTag).length&&this.$target.find(this.opts.linkTag)||this.$target;this.$image=this.$target.find('img').length&&this.$target.find('img')||this.$target;this.$flyout=$('<div class="zoomodoo-flyout" />');var $attach=this.$target;if(this.opts.attach!==undefined&&this.$target.parents(this.opts.attach).length){$attach=this.$target.parents(this.opts.attach);}
$attach.parent().on('mousemove.zoomodoo touchmove.zoomodoo',$.proxy(this._onMove,this));$attach.parent().on('mouseleave.zoomodoo touchend.zoomodoo',$.proxy(this._onLeave,this));this.$target.parent().on(this.opts.event+'.zoomodoo touchstart.zoomodoo',$.proxy(this._onEnter,this));if(this.opts.preventClicks){this.$target.on('click.zoomodoo',function(e){e.preventDefault();});}}};ZoomOdoo.prototype.show=function(e,testMouseOver){var w1,h1,w2,h2;var self=this;if(this.opts.beforeShow.call(this)===false)return;if(!this.isReady){return this._loadImage(this.$link.attr(this.opts.linkAttribute),function(){if(self.isMouseOver||!testMouseOver){self.show(e);}});}
var $attach=this.$target;if(this.opts.attach!==undefined&&this.$target.parents(this.opts.attach).length){$attach=this.$target.parents(this.opts.attach);}
$attach.parent().append(this.$flyout);w1=this.$target.width();h1=this.$target.height();w2=this.$flyout.width();h2=this.$flyout.height();dw=this.$zoom.width()-w2;dh=this.$zoom.height()-h2;if(dw<0)dw=0;if(dh<0)dh=0;rw=dw/w1;rh=dh/h1;this.isOpen=true;this.opts.onShow.call(this);if(e){this._move(e);}};ZoomOdoo.prototype._onEnter=function(e){var touches=e.originalEvent.touches;this.isMouseOver=true;if(!touches||touches.length===1){e.preventDefault();this.show(e,true);}};ZoomOdoo.prototype._onMove=function(e){if(!this.isOpen)return;e.preventDefault();this._move(e);};ZoomOdoo.prototype._onLeave=function(){this.isMouseOver=false;if(this.isOpen){this.hide();}};ZoomOdoo.prototype._onLoad=function(e){if(!e.currentTarget.width)return;this.isReady=true;this.$flyout.html(this.$zoom);if(e.data.call){e.data();}};ZoomOdoo.prototype._loadImage=function(href,callback){var zoom=new Image();this.$zoom=$(zoom).on('load',callback,$.proxy(this._onLoad,this));zoom.style.position='absolute';zoom.src=href;};ZoomOdoo.prototype._move=function(e){if(e.type.indexOf('touch')===0){var touchlist=e.touches||e.originalEvent.touches;lx=touchlist[0].pageX;ly=touchlist[0].pageY;}else{lx=e.pageX||lx;ly=e.pageY||ly;}
var offset=this.$target.offset();var pt=ly-offset.top;var pl=lx-offset.left;var xt=Math.ceil(pt*rh);var xl=Math.ceil(pl*rw);if(xl<0||xt<0||xl>dw||xt>dh){this.hide();}else{var top=xt*-1;var left=xl*-1;this.$zoom.css({top:top,left:left});this.opts.onMove.call(this,top,left);}};ZoomOdoo.prototype.hide=function(){if(!this.isOpen)return;if(this.opts.beforeHide.call(this)===false)return;this.$flyout.detach();this.isOpen=false;this.opts.onHide.call(this);};$.fn.zoomOdoo=function(options){return this.each(function(){var api=$.data(this,'zoomOdoo');if(!api){$.data(this,'zoomOdoo',new ZoomOdoo(this,options));}else if(api.isOpen===undefined){api._init();}});};});;

/* /website/static/src/js/menu/navbar.js defined in bundle 'web.assets_frontend' */
odoo.define('website.navbar',function(require){'use strict';var rootWidget=require('web_editor.root_widget');var concurrency=require('web.concurrency');var Widget=require('web.Widget');var websiteRootData=require('website.WebsiteRoot');var websiteNavbarRegistry=new rootWidget.RootWidgetRegistry();var WebsiteNavbar=rootWidget.RootWidget.extend({events:_.extend({},rootWidget.RootWidget.prototype.events||{},{'click [data-action]':'_onActionMenuClick','mouseover > ul > li.dropdown:not(.open)':'_onMenuHovered','click .o_mobile_menu_toggle':'_onMobileMenuToggleClick',}),custom_events:_.extend({},rootWidget.RootWidget.prototype.custom_events||{},{action_demand:'_onActionDemand',edit_mode:'_onEditMode',}),_getRegistry:function(){return websiteNavbarRegistry;},_handleAction:function(actionName,params,_i){var defs=[];_.each(this._widgets,function(w){if(!w.handleAction){return;}
var def=w.handleAction(actionName,params);if(def!==null){defs.push(def);}});if(!defs.length){var self=this;if(_i>50){console.warn(_.str.sprintf("Action '%s' was not able to be handled.",actionName));return $.Deferred().reject();}
return concurrency.delay(100).then(function(){return self._handleAction(actionName,params,(_i||0)+1);});}
return $.when.apply($,defs);},_onActionMenuClick:function(ev){var $button=$(ev.currentTarget);$button.prop('disabled',true);this._handleAction($button.data('action')).always(function(){$button.prop('disabled',false);});},_onActionDemand:function(ev){var def=this._handleAction(ev.data.actionName,ev.data.params);if(ev.data.onSuccess){def.done(ev.data.onSuccess);}
if(ev.data.onFailure){def.fail(ev.data.onFailure);}},_onEditMode:function(){var self=this;this.$el.addClass('editing_mode');_.delay(function(){self.do_hide();},800);},_onMenuHovered:function(ev){var $opened=this.$('> ul > li.dropdown.open');if($opened.length){$opened.removeClass('open');$(ev.currentTarget).find('.dropdown-toggle').mousedown().focus().mouseup().click();}},_onMobileMenuToggleClick:function(){this.$el.parent().toggleClass('o_mobile_menu_opened');},});var WebsiteNavbarActionWidget=Widget.extend({actions:{},handleAction:function(actionName,params){var action=this[this.actions[actionName]];if(action){return $.when(action.apply(this,params||[]));}
return null;},});websiteRootData.websiteRootRegistry.add(WebsiteNavbar,'#oe_main_menu_navbar');return{WebsiteNavbar:WebsiteNavbar,websiteNavbarRegistry:websiteNavbarRegistry,WebsiteNavbarActionWidget:WebsiteNavbarActionWidget,};});;

/* /website_mail/static/src/js/follow.js defined in bundle 'web.assets_frontend' */
odoo.define('website_mail.follow',function(require){'use strict';var sAnimation=require('website.content.snippets.animation');sAnimation.registry.follow=sAnimation.Class.extend({selector:'.js_follow',start:function(){var self=this;this.is_user=false;this._rpc({route:'/website_mail/is_follower',params:{model:this.$target.data('object'),res_id:this.$target.data('id'),},}).always(function(data){self.is_user=data.is_user;self.email=data.email;self.toggle_subscription(data.is_follower,data.email);self.$target.removeClass("hidden");});if(!this.editableMode){$('.js_follow > .input-group-btn.hidden').removeClass("hidden");this.$target.find('.js_follow_btn, .js_unfollow_btn').on('click',function(event){event.preventDefault();self._onClick();});}
return this._super.apply(this,arguments);},_onClick:function(){var self=this;var $email=this.$target.find(".js_follow_email");if($email.length&&!$email.val().match(/.+@.+/)){this.$target.addClass('has-error');return false;}
this.$target.removeClass('has-error');var email=$email.length?$email.val():false;if(email||this.is_user){this._rpc({route:'/website_mail/follow',params:{'id':+this.$target.data('id'),'object':this.$target.data('object'),'message_is_follower':this.$target.attr("data-follow")||"off",'email':email,},}).then(function(follow){self.toggle_subscription(follow,email);});}},toggle_subscription:function(follow,email){follow=follow||(!email&&this.$target.attr('data-unsubscribe'));if(follow){this.$target.find(".js_follow_btn").addClass("hidden");this.$target.find(".js_unfollow_btn").removeClass("hidden");}
else{this.$target.find(".js_follow_btn").removeClass("hidden");this.$target.find(".js_unfollow_btn").addClass("hidden");}
this.$target.find('input.js_follow_email').val(email||"").attr("disabled",email&&(follow||this.is_user)?"disabled":false);this.$target.attr("data-follow",follow?'on':'off');},});});;

/* /website_mail/static/src/js/website_mail.js defined in bundle 'web.assets_frontend' */
odoo.define('website_mail.thread',function(require){'use strict';var ajax=require('web.ajax');var core=require('web.core');var qweb=core.qweb;var PortalChatter=require('portal.chatter').PortalChatter;PortalChatter.include({_loadTemplates:function(){return $.when(this._super(),ajax.loadXML('/website_mail/static/src/xml/website_mail.xml',qweb));},});});;

/* /website_form/static/src/js/website_form.js defined in bundle 'web.assets_frontend' */
odoo.define('website_form.animation',function(require){'use strict';var core=require('web.core');var time=require('web.time');var ajax=require('web.ajax');var sAnimation=require('website.content.snippets.animation');var _t=core._t;var qweb=core.qweb;sAnimation.registry.form_builder_send=sAnimation.Class.extend({selector:'.s_website_form',willStart:function(){var def;if(!$.fn.datetimepicker){def=ajax.loadJS("/web/static/lib/bootstrap-datetimepicker/src/js/bootstrap-datetimepicker.js");}
return $.when(this._super.apply(this,arguments),def);},start:function(editable_mode){if(editable_mode){this.stop();return;}
var self=this;this.templates_loaded=ajax.loadXML('/website_form/static/src/xml/website_form.xml',qweb);this.$target.find('.o_website_form_send').on('click',function(e){self.send(e);});var l10n=_t.database.parameters;var datepickers_options={minDate:moment({y:1900}),maxDate:moment().add(200,"y"),calendarWeeks:true,icons:{time:'fa fa-clock-o',date:'fa fa-calendar',next:'fa fa-chevron-right',previous:'fa fa-chevron-left',up:'fa fa-chevron-up',down:'fa fa-chevron-down',},locale:moment.locale(),format:time.getLangDatetimeFormat(),};this.$target.find('.o_website_form_datetime').datetimepicker(datepickers_options);datepickers_options.format=time.getLangDateFormat();this.$target.find('.o_website_form_date').datetimepicker(datepickers_options);return this._super.apply(this,arguments);},destroy:function(){this._super.apply(this,arguments);this.$target.find('button').off('click');},send:function(e){e.preventDefault();this.$target.find('.o_website_form_send').off().addClass('disabled');var self=this;self.$target.find('#o_website_form_result').empty();if(!self.check_error_fields({})){self.update_status('invalid');return false;}
this.form_fields=this.$target.serializeArray();$.each(this.$target.find('input[type=file]'),function(outer_index,input){$.each($(input).prop('files'),function(index,file){self.form_fields.push({name:input.name+'['+outer_index+']['+index+']',value:file});});});var form_values={};_.each(this.form_fields,function(input){if(input.name in form_values){if(Array.isArray(form_values[input.name])){form_values[input.name].push(input.value);}else{form_values[input.name]=[form_values[input.name],input.value];}}else{if(input.value!==''){form_values[input.name]=input.value;}}});for(var key in this.$target.data()){if(_.str.startsWith(key,'form_field_')){form_values[key.replace('form_field_','')]=this.$target.data(key);}}
ajax.post(this.$target.attr('action')+(this.$target.data('force_action')||this.$target.data('model_name')),form_values).then(function(result_data){result_data=$.parseJSON(result_data);if(!result_data.id){self.update_status('error');if(result_data.error_fields){self.check_error_fields(result_data.error_fields);}}else{var success_page=self.$target.attr('data-success_page');if(success_page){$(window.location).attr('href',success_page);}
else{self.update_status('success');}
self.$target[0].reset();}}).fail(function(result_data){self.update_status('error');});},check_error_fields:function(error_fields){var self=this;var form_valid=true;this.$target.find('.form-field').each(function(k,field){var $field=$(field);var field_name=$field.find('.control-label').attr('for');var inputs=$field.find('.o_website_form_input:not(#editable_select)');var invalid_inputs=inputs.toArray().filter(function(input,k,inputs){if(input.required&&input.type==='checkbox'){var checkboxes=_.filter(inputs,function(input){return input.required&&input.type==='checkbox';});return!_.any(checkboxes,function(checkbox){return checkbox.checked;});}else if($(input).hasClass('o_website_form_date')){if(!self.is_datetime_valid(input.value,'date')){return true;}}else if($(input).hasClass('o_website_form_datetime')){if(!self.is_datetime_valid(input.value,'datetime')){return true;}}
return!input.checkValidity();});$field.removeClass('has-error');if(invalid_inputs.length||error_fields[field_name]){$field.addClass('has-error');if(_.isString(error_fields[field_name])){$field.popover({content:error_fields[field_name],trigger:'hover',container:'body',placement:'top'});$field.data("bs.popover").options.content=error_fields[field_name];$field.popover('show');}
form_valid=false;}});return form_valid;},is_datetime_valid:function(value,type_of_date){if(value===""){return true;}else{try{this.parse_date(value,type_of_date);return true;}catch(e){return false;}}},parse_date:function(value,type_of_date,value_if_empty){var date_pattern=time.getLangDateFormat(),time_pattern=time.getLangTimeFormat();var date_pattern_wo_zero=date_pattern.replace('MM','M').replace('DD','D'),time_pattern_wo_zero=time_pattern.replace('HH','H').replace('mm','m').replace('ss','s');switch(type_of_date){case'datetime':var datetime=moment(value,[date_pattern+' '+time_pattern,date_pattern_wo_zero+' '+time_pattern_wo_zero],true);if(datetime.isValid())
return time.datetime_to_str(datetime.toDate());throw new Error(_.str.sprintf(_t("'%s' is not a correct datetime"),value));case'date':var date=moment(value,[date_pattern,date_pattern_wo_zero],true);if(date.isValid())
return time.date_to_str(date.toDate());throw new Error(_.str.sprintf(_t("'%s' is not a correct date"),value));}
return value;},update_status:function(status){var self=this;if(status!=='success'){this.$target.find('.o_website_form_send').on('click',function(e){self.send(e);}).removeClass('disabled');}
var $result=this.$('#o_website_form_result');this.templates_loaded.done(function(){$result.replaceWith(qweb.render("website_form.status_"+status));});},});});;

/* /website_rating/static/src/js/website_mail.js defined in bundle 'web.assets_frontend' */
odoo.define('website_rating.thread',function(require){'use strict';var ajax=require('web.ajax');var core=require('web.core');var Widget=require('web.Widget');var qweb=core.qweb;var _t=core._t;var PortalChatter=require('portal.chatter').PortalChatter;PortalChatter.include({events:_.extend({},PortalChatter.prototype.events,{"mousemove .stars i":"_onMoveStar","mouseleave .stars i":"_onMoveOutStar","click .stars":"_onClickStar","mouseleave .stars":"_onMouseleaveStar","click .o_website_rating_select":"_onClickStarDomain","click .o_website_rating_select_text":"_onClickStarDomainReset",}),init:function(parent,options){this._super.apply(this,arguments);if(!_.contains(this.options,'display_rating')){this.options=_.defaults(this.options,{'display_rating':false,'rating_default_value':0.0,});}
this.set('rating_card_values',{});this.set('rating_value',false);this.on("change:rating_value",this,this._onChangeRatingDomain);this.labels={'0':"",'1':_t("I hate it"),'2':_t("I don't like it"),'3':_t("It's okay"),'4':_t("I like it"),'5':_t("I love it"),};this.user_click=false;this.set("star_value",this.options.rating_default_value);this.on("change:star_value",this,this._onChangeStarValue);},willStart:function(){var self=this;return this._super.apply(this,arguments).then(function(result){if(result['rating_stats']){var rating_data={'avg':self.round_to_half(result['rating_stats']['avg']),'percent':[],};_.each(_.keys(result['rating_stats']['percent']),function(rating){if(0<rating&&rating<=5){rating_data['percent'].push({'num':rating,'percent':result['rating_stats']['percent'][rating],});}});self.set('rating_card_values',rating_data);}});},start:function(){var self=this;return this._super.apply(this,arguments).then(function(){self.$input=self.$('input[name="rating_value"]');self.$star_list=self.$('.stars').find('i');self.set("star_value",self.options.rating_default_value);});},preprocessMessages:function(messages){var self=this;var messages=this._super.apply(this,arguments);if(this.options['display_rating']){_.each(messages,function(m){m['rating_value']=self.round_to_half(m['rating_value']);});}
return messages;},round_to_half:function(value){var converted=parseFloat(value);var decimal=(converted-parseInt(converted,10));decimal=Math.round(decimal*10);if(decimal===5){return(parseInt(converted,10)+0.5);}
if((decimal<3)||(decimal>7)){return Math.round(converted);}else{return(parseInt(converted,10)+0.5);}},_loadTemplates:function(){return $.when(this._super(),ajax.loadXML('/website_rating/static/src/xml/website_mail.xml',qweb));},_messageFetchPrepareParams:function(){var params=this._super.apply(this,arguments);if(this.options['display_rating']){params['rating_include']=true;}
return params;},_onClickStar:function(e){this.user_click=true;this.$input.val(this.get("star_value"));},_onClickStarDomain:function(e){var $tr=this.$(e.currentTarget);var num=$tr.data('star');if($tr.css('opacity')==1){this.set('rating_value',num);this.$('.o_website_rating_select').css({'opacity':0.5,});this.$('.o_website_rating_select_text[data-star="'+num+'"]').css({'visibility':'visible','opacity':1,});this.$('.o_website_rating_select[data-star="'+num+'"]').css({'opacity':1,});}},_onClickStarDomainReset:function(e){e.stopPropagation();this.set('rating_value',false);this.$('.o_website_rating_select_text').css('visibility','hidden');this.$('.o_website_rating_select').css({'opacity':1,});},_onChangeRatingDomain:function(){var domain=[];if(this.get('rating_value')){domain=[['rating_value','=',this.get('rating_value')]];}
this._changeCurrentPage(1,domain);},_onChangeStarValue:function(){var val=this.get("star_value");var index=Math.floor(val);var decimal=val-index;this.$star_list.removeClass('fa-star fa-star-half-o').addClass('fa-star-o');this.$('.stars').find("i:lt("+index+")").removeClass('fa-star-o fa-star-half-o').addClass('fa-star');if(decimal){this.$('.stars').find("i:eq("+(index)+")").removeClass('fa-star-o fa-star fa-star-half-o').addClass('fa-star-half-o');}
this.$('.rate_text .label').text(this.labels[index]);},_onMouseleaveStar:function(e){this.$('.rate_text').hide();},_onMoveStar:function(e){var index=this.$('.stars i').index(e.currentTarget);this.$('.rate_text').show();this.set("star_value",index+1);},_onMoveOutStar:function(){if(!this.user_click){this.set("star_value",parseInt(this.$input.val()));}
this.user_click=false;},});});;

/* /website_sale/static/src/js/website_sale.js defined in bundle 'web.assets_frontend' */
odoo.define('website_sale.cart',function(require){"use strict";require('web.dom_ready');var core=require('web.core');var _t=core._t;var shopping_cart_link=$('ul#top_menu li a[href$="/shop/cart"]');var shopping_cart_link_counter;var popoverRpc=null;shopping_cart_link.popover({trigger:'manual',animation:true,html:true,title:function(){return _t("My Cart");},container:'body',placement:'auto',template:'<div class="popover mycart-popover" role="tooltip"><div class="arrow"></div><h3 class="popover-title"></h3><div class="popover-content"></div></div>'}).on("mouseenter",function(){var self=this;clearTimeout(shopping_cart_link_counter);shopping_cart_link.not(self).popover('hide');shopping_cart_link_counter=setTimeout(function(){if($(self).is(':hover')&&!$(".mycart-popover:visible").length)
{popoverRpc=$.get("/shop/cart",{'type':'popover'}).then(function(data){$(self).data("bs.popover").options.content=data;$(self).popover("show");$(".popover").on("mouseleave",function(){$(self).trigger('mouseleave');});});}},300);}).on("mouseleave",function(){var self=this;setTimeout(function(){if(!$(".popover:hover").length){if(!$(self).is(':hover')){$(self).popover('hide');}}},1000);}).on('click',function(ev){clearTimeout(shopping_cart_link_counter);if(popoverRpc&&popoverRpc.state()==='pending'){ev.preventDefault();var href=ev.currentTarget.href;popoverRpc.then(function(){window.location.href=href;});}});});odoo.define('website_sale.website_sale_category',function(require){"use strict";require('web.dom_ready');if(!$('#o_shop_collapse_category').length){return $.Deferred().reject("DOM doesn't contain '#o_shop_collapse_category'");}
$('#o_shop_collapse_category').on('click','.fa-chevron-right',function(){$(this).parent().siblings().find('.fa-chevron-down:first').click();$(this).parents('li').find('ul:first').show('normal');$(this).toggleClass('fa-chevron-down fa-chevron-right');});$('#o_shop_collapse_category').on('click','.fa-chevron-down',function(){$(this).parent().find('ul:first').hide('normal');$(this).toggleClass('fa-chevron-down fa-chevron-right');});});odoo.define('website_sale.website_sale',function(require){"use strict";require('web.dom_ready');var base=require("web_editor.base");var ajax=require('web.ajax');var utils=require('web.utils');var core=require('web.core');var config=require('web.config');require("website.content.zoomodoo");var _t=core._t;if(!$('.oe_website_sale').length){return $.Deferred().reject("DOM doesn't contain '.oe_website_sale'");}
$('.oe_website_sale').each(function(){var oe_website_sale=this;$(oe_website_sale).on("change",'input[name="add_qty"]',function(event){var product_ids=[];var product_dom=$(event.target).closest(".js_product").find("ul.js_add_cart_variants");var qty=$(event.target).closest('form').find('input[name="add_qty"]').val();if(!product_dom.length||$('body').hasClass('editor_enable')){var $list_products=$(event.target).closest('.js_product').find('.js_product_change');if($list_products.length){ajax.jsonRpc("/shop/get_unit_price",'call',{'product_ids':_.map($list_products,function(variant){return parseInt(variant.value);}),'add_qty':parseInt(qty)}).then(function(data){_.each(data,function(value,key){$list_products.filter('[value="'+key+'"]').data('price',value);});$list_products.filter(':checked').change();});}
return;}
var attribute_value_ids=product_dom.data("attribute_value_ids");if(_.isString(attribute_value_ids)){attribute_value_ids=JSON.parse(attribute_value_ids.replace(/'/g,'"'));product_dom.data('attribute_value_ids',attribute_value_ids);}
_.each(attribute_value_ids,function(entry){product_ids.push(entry[0]);});if($("#product_detail").length){ajax.jsonRpc("/shop/get_unit_price",'call',{'product_ids':product_ids,'add_qty':parseInt(qty)}).then(function(data){var current=attribute_value_ids;for(var j=0;j<current.length;j++){current[j][2]=data[current[j][0]];}
product_dom.trigger("change");});}});$(oe_website_sale).on('mouseup touchend','.js_publish',function(ev){$(ev.currentTarget).parents(".thumbnail").toggleClass("disabled");});var clickwatch=(function(){var timer=0;return function(callback,ms){clearTimeout(timer);timer=setTimeout(callback,ms);};})();$(oe_website_sale).on("change",".oe_cart input.js_quantity[data-product-id]",function(){var $input=$(this);if($input.data('update_change')||$('body').hasClass('editor_enable')){return;}
var value=parseInt($input.val()||0,10);if(isNaN(value)){value=1;}
var $dom=$(this).closest('tr');var $dom_optional=$dom.nextUntil(':not(.optional_product.info)');var line_id=parseInt($input.data('line-id'),10);var product_ids=[parseInt($input.data('product-id'),10)];clickwatch(function(){$dom_optional.each(function(){$(this).find('.js_quantity').text(value);product_ids.push($(this).find('span[data-product-id]').data('product-id'));});$input.data('update_change',true);ajax.jsonRpc("/shop/cart/update_json",'call',{'line_id':line_id,'product_id':parseInt($input.data('product-id'),10),'set_qty':value}).then(function(data){$input.data('update_change',false);var check_value=parseInt($input.val()||0,10);if(isNaN(check_value)){check_value=1;}
if(value!==check_value){$input.trigger('change');return;}
var $q=$(".my_cart_quantity");if(data.cart_quantity){$q.parents('li:first').removeClass("hidden");}
else{$q.parents('li:first').addClass("hidden");$('a[href*="/shop/checkout"]').addClass("hidden");}
$q.html(data.cart_quantity).hide().fadeIn(600);$input.val(data.quantity);$('.js_quantity[data-line-id='+line_id+']').val(data.quantity).html(data.quantity);$(".js_cart_lines").first().before(data['website_sale.cart_lines']).end().remove();if(data.warning){var cart_alert=$('.oe_cart').parent().find('#data_warning');if(cart_alert.length===0){$('.oe_cart').prepend('<div class="alert alert-danger alert-dismissable" role="alert" id="data_warning">'+'<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button> '+data.warning+'</div>');}
else{cart_alert.html('<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button> '+data.warning);}
$input.val(data.quantity);}});},500);});$(oe_website_sale).on("click",".oe_cart a.js_add_suggested_products",function(){$(this).prev('input').val(1).trigger('change');});$(oe_website_sale).on('click','a.js_add_cart_json',function(ev){if($('body').hasClass('editor_enable')){return;}
ev.preventDefault();var $link=$(ev.currentTarget);var $input=$link.parent().find("input");var product_id=+$input.closest('*:has(input[name="product_id"])').find('input[name="product_id"]').val();var min=parseFloat($input.data("min")||0);var max=parseFloat($input.data("max")||Infinity);var quantity=($link.has(".fa-minus").length?-1:1)+parseFloat($input.val()||0,10);var new_qty=quantity>min?(quantity<max?quantity:max):min;$('input[name="'+$input.attr("name")+'"]').add($input).filter(function(){var $prod=$(this).closest('*:has(input[name="product_id"])');return!$prod.length||+$prod.find('input[name="product_id"]').val()===product_id;}).val(new_qty).change();return false;});$('.oe_website_sale, #comment').off('click','.a-submit').on('click','.a-submit',function(event){if(!event.isDefaultPrevented()&&!$(this).is(".disabled")){event.preventDefault();$(this).closest('form').submit();}
if($(this).hasClass('a-submit-disable')){$(this).addClass("disabled");}
if($(this).hasClass('a-submit-loading')){var loading='<span class="fa fa-cog fa-spin"/>';var fa_span=$(this).find('span[class*="fa"]');if(fa_span.length){fa_span.replaceWith(loading);}
else{$(this).append(loading);}}});$('form.js_attributes input, form.js_attributes select',oe_website_sale).on('change',function(event){if(!event.isDefaultPrevented()){event.preventDefault();$(this).closest("form").submit();}});$('form.js_add_cart_json label',oe_website_sale).on('mouseup touchend',function(){var $label=$(this);var $price=$label.parents("form:first").find(".oe_price .oe_currency_value");if(!$price.data("price")){$price.data("price",parseFloat($price.text()));}
var value=$price.data("price")+parseFloat($label.find(".badge span").text()||0);var dec=value%1;$price.html(value+(dec<0.01?".00":(dec<1?"0":"")));});$('.css_attribute_color input',oe_website_sale).on('change',function(){$('.css_attribute_color').removeClass("active");$('.css_attribute_color:has(input:checked)').addClass("active");});function price_to_str(price){var l10n=_t.database.parameters;var precision=2;if($(".decimal_precision").length){precision=parseInt($(".decimal_precision").last().data('precision'));}
var formatted=_.str.sprintf('%.'+precision+'f',price).split('.');formatted[0]=utils.insert_thousand_seps(formatted[0]);return formatted.join(l10n.decimal_point);}
function update_product_image(event_source,product_id){var $img;if($('#o-carousel-product').length){$img=$(event_source).closest('tr.js_product, .oe_website_sale').find('img.js_variant_img');$img.attr("src","/web/image/product.product/"+product_id+"/image");$img.parent().attr('data-oe-model','product.product').attr('data-oe-id',product_id).data('oe-model','product.product').data('oe-id',product_id);var $thumbnail=$(event_source).closest('tr.js_product, .oe_website_sale').find('img.js_variant_img_small');if($thumbnail.length!==0){$thumbnail.attr("src","/web/image/product.product/"+product_id+"/image/90x90");$('.carousel').carousel(0);}}
else{$img=$(event_source).closest('tr.js_product, .oe_website_sale').find('span[data-oe-model^="product."][data-oe-type="image"] img:first, img.product_detail_img');$img.attr("src","/web/image/product.product/"+product_id+"/image");$img.parent().attr('data-oe-model','product.product').attr('data-oe-id',product_id).data('oe-model','product.product').data('oe-id',product_id);}
$img.filter('[data-zoom-image]').attr('data-zoom-image',$img.attr('src'));if($img.data('zoomOdoo')!==undefined){$img.data('zoomOdoo').isReady=false;}}
$(oe_website_sale).on('change','input.js_product_change',function(){var self=this;var $parent=$(this).closest('.js_product');$.when(base.ready()).then(function(){$parent.find(".oe_default_price:first .oe_currency_value").html(price_to_str(+$(self).data('lst_price')));$parent.find(".oe_price:first .oe_currency_value").html(price_to_str(+$(self).data('price')));});update_product_image(this,+$(this).val());});$(oe_website_sale).on('change','input.js_variant_change, select.js_variant_change, ul[data-attribute_value_ids]',function(ev){var $ul=$(ev.target).closest('.js_add_cart_variants');var $parent=$ul.closest('.js_product');var $product_id=$parent.find('.product_id').first();var $price=$parent.find(".oe_price:first .oe_currency_value");var $default_price=$parent.find(".oe_default_price:first .oe_currency_value");var $optional_price=$parent.find(".oe_optional:first .oe_currency_value");var variant_ids=$ul.data("attribute_value_ids");if(_.isString(variant_ids)){variant_ids=JSON.parse(variant_ids.replace(/'/g,'"'));}
var values=[];var unchanged_values=$parent.find('div.oe_unchanged_value_ids').data('unchanged_value_ids')||[];$parent.find('input.js_variant_change:checked, select.js_variant_change').each(function(){values.push(+$(this).val());});values=values.concat(unchanged_values);$parent.find("label").removeClass("text-muted css_not_available");var product_id=false;for(var k in variant_ids){if(_.isEmpty(_.difference(variant_ids[k][1],values))){$.when(base.ready()).then(function(){$price.html(price_to_str(variant_ids[k][2]));$default_price.html(price_to_str(variant_ids[k][3]));});if(variant_ids[k][3]-variant_ids[k][2]>0.01){$default_price.closest('.oe_website_sale').addClass("discount");$optional_price.closest('.oe_optional').show().css('text-decoration','line-through');$default_price.parent().removeClass('hidden');}else{$optional_price.closest('.oe_optional').hide();$default_price.parent().addClass('hidden');}
product_id=variant_ids[k][0];update_product_image(this,product_id);break;}}
$parent.find("input.js_variant_change:radio, select.js_variant_change").each(function(){var $input=$(this);var id=+$input.val();var values=[id];$parent.find("ul:not(:has(input.js_variant_change[value='"+id+"'])) input.js_variant_change:checked, select.js_variant_change").each(function(){values.push(+$(this).val());});for(var k in variant_ids){if(!_.difference(values,variant_ids[k][1]).length){return;}}
$input.closest("label").addClass("css_not_available");$input.find("option[value='"+id+"']").addClass("css_not_available");});if(product_id){$parent.removeClass("css_not_available");$product_id.val(product_id);$parent.find("#add_to_cart").removeClass("disabled");}else{$parent.addClass("css_not_available");$product_id.val(0);$parent.find("#add_to_cart").addClass("disabled");}});$('div.js_product',oe_website_sale).each(function(){$('input.js_product_change',this).first().prop('checked','checked').trigger('change');});$('.js_add_cart_variants',oe_website_sale).each(function(){$('input.js_variant_change, select.js_variant_change',this).first().trigger('change');});$('.oe_cart').on('click','.js_change_shipping',function(){if(!$('body.editor_enable').length){var $old=$('.all_shipping').find('.panel.border_primary');$old.find('.btn-ship').toggle();$old.addClass('js_change_shipping');$old.removeClass('border_primary');var $new=$(this).parent('div.one_kanban').find('.panel');$new.find('.btn-ship').toggle();$new.removeClass('js_change_shipping');$new.addClass('border_primary');var $form=$(this).parent('div.one_kanban').find('form.hide');$.post($form.attr('action'),$form.serialize()+'&xhr=1');}});$('.oe_cart').on('click','.js_edit_address',function(){$(this).parent('div.one_kanban').find('form.hide').attr('action','/shop/address').submit();});$('.oe_cart').on('click','.js_delete_product',function(e){e.preventDefault();$(this).closest('tr').find('.js_quantity').val(0).trigger('change');});if($('.oe_website_sale .dropdown_sorty_by').length){$('.oe_website_sale .o_website_sale_search').on('submit',function(event){var $this=$(this);if(!event.isDefaultPrevented()&&!$this.is(".disabled")){event.preventDefault();var oldurl=$this.attr('action');oldurl+=(oldurl.indexOf("?")===-1)?"?":"";var search=$this.find('input.search-query');window.location=oldurl+'&'+search.attr('name')+'='+encodeURIComponent(search.val());}});}
if($(".checkout_autoformat").length){$(oe_website_sale).on('change',"select[name='country_id']",function(){clickwatch(function(){if($("#country_id").val()){ajax.jsonRpc("/shop/country_infos/"+$("#country_id").val(),'call',{mode:'shipping'}).then(function(data){var selectStates=$("select[name='state_id']");if(selectStates.data('init')===0||selectStates.find('option').length===1){if(data.states.length){selectStates.html('');_.each(data.states,function(x){var opt=$('<option>').text(x[1]).attr('value',x[0]).attr('data-code',x[2]);selectStates.append(opt);});selectStates.parent('div').show();}
else{selectStates.val('').parent('div').hide();}
selectStates.data('init',0);}
else{selectStates.data('init',0);}
if(data.fields){if($.inArray('zip',data.fields)>$.inArray('city',data.fields)){$(".div_zip").before($(".div_city"));}
else{$(".div_zip").after($(".div_city"));}
var all_fields=["street","zip","city","country_name"];_.each(all_fields,function(field){$(".checkout_autoformat .div_"+field.split('_')[0]).toggle($.inArray(field,data.fields)>=0);});}});}},500);});}
$("select[name='country_id']").change();});if(config.device.size_class>config.device.SIZES.XS){$('.ecom-zoomable img[data-zoom]').zoomOdoo({attach:'#o-carousel-product'});}});;

/* /website_sale/static/src/js/website_sale_utils.js defined in bundle 'web.assets_frontend' */
odoo.define('website_sale.utils',function(require){"use strict";var animate_clone=function(cart,$elem,offset_top,offset_left){cart.find('.o_animate_blink').addClass('o_red_highlight o_shadow_animation').delay(500).queue(function(){$(this).removeClass("o_shadow_animation").dequeue();}).delay(2000).queue(function(){$(this).removeClass("o_red_highlight").dequeue();});var imgtodrag=$elem.find('img').eq(0);if(imgtodrag.length){var imgclone=imgtodrag.clone().offset({top:imgtodrag.offset().top,left:imgtodrag.offset().left}).addClass('o_website_sale_animate').appendTo($('body')).animate({'top':cart.offset().top+offset_top,'left':cart.offset().left+offset_left,'width':75,'height':75},1000,'easeInOutExpo');imgclone.animate({'width':0,'height':0},function(){$(this).detach();});}};return{animate_clone:animate_clone,};});;

/* /website_sale/static/src/js/website_sale_payment.js defined in bundle 'web.assets_frontend' */
odoo.define('website_sale.payment',function(require){"use strict";$(document).ready(function(){if($("#checkbox_cgv").length){$("#checkbox_cgv").change(function(){$("button#o_payment_form_pay").prop("disabled",!this.checked);});$('#checkbox_cgv').trigger('change');}});});;

/* /website_sale/static/src/js/website_sale_validate.js defined in bundle 'web.assets_frontend' */
odoo.define('website_sale.validate',function(require){"use strict";var ajax=require('web.ajax');$(document).ready(function(){var _poll_nbr=0;function payment_transaction_poll_status(){var order_node=$('div.oe_website_sale_tx_status');if(!order_node||order_node.data('order-id')===undefined){return;}
var order_id=parseInt(order_node.data('order-id'));return ajax.jsonRpc('/shop/payment/get_status/'+order_id,'call',{}).then(function(result){_poll_nbr+=1;if(result.recall){if(_poll_nbr<20){setTimeout(function(){payment_transaction_poll_status();},Math.ceil(_poll_nbr/3)*1000);}
else{var $message=$(result.message);$message.find('span:first').prepend($("<i title='We are waiting the confirmation of the bank or payment provider' class='fa fa-warning' style='margin-right:10px;'>"));result.message=$message.html();}}
$('div.oe_website_sale_tx_status').html(result.message);});}
payment_transaction_poll_status();});});;

/* /website_sale/static/src/js/website_sale_tour_buy.js defined in bundle 'web.assets_frontend' */
odoo.define('website_sale.tour',function(require){'use strict';var tour=require("web_tour.tour");var base=require("web_editor.base");tour.register('shop_buy_product',{test:true,url:'/shop',wait_for:base.ready()},[{content:"search ipod",trigger:'form input[name="search"]',run:"text ipod",},{content:"search ipod",trigger:'form:has(input[name="search"]) .oe_search_button',},{content:"select ipod",trigger:'.oe_product_cart a:contains("iPod")',},{content:"select ipod 32GB",extra_trigger:'#product_detail',trigger:'label:contains(32 GB) input',},{content:"select ipod 16GB",extra_trigger:'#product_detail',trigger:'label:contains(16 GB) input',},{content:"click on add to cart",extra_trigger:'label:contains(16 GB) input:propChecked',trigger:'#product_detail form[action^="/shop/cart/update"] .btn',},{content:"add suggested",extra_trigger:'#wrap:not(:has(#cart_products:contains("[A8767] Apple In-Ear Headphones")))',trigger:'.oe_cart:has(tr:contains("16 GB")) a:contains("Add to Cart")',},{content:"add one more iPod",extra_trigger:'.my_cart_quantity:contains(2)',trigger:'#cart_products tr:contains("16 GB") a.js_add_cart_json:eq(1)',},{content:"remove Headphones",extra_trigger:'#cart_products tr:contains("16 GB") input.js_quantity:propValue(2)',trigger:'#cart_products tr:contains("Apple In-Ear Headphones") a.js_add_cart_json:first',},{content:"set one iPod",extra_trigger:'#wrap:not(:has(#cart_products tr:contains("Apple In-Ear Headphones")))',trigger:'#cart_products input.js_quantity',run:'text 1',},{content:"go to checkout",extra_trigger:'#cart_products input.js_quantity:propValue(1)',trigger:'a[href="/shop/checkout"]',},{content:"Confirm checkout",extra_trigger:"div.all_shipping .panel",trigger:'a[href="/shop/confirm_order"]',},{content:"select payment",trigger:'#payment_method label:contains("Wire Transfer")',},{content:"Pay Now",extra_trigger:'#payment_method label:contains("Wire Transfer") input:checked,#payment_method:not(:has("input:radio:visible"))',trigger:'button[id="o_payment_form_pay"]:visible:not(:disabled)',},{content:"finish",trigger:'.oe_website_sale:contains("Thank you for your order")',timeout:30000,}]);});;

/* /website_sale/static/src/js/website_sale_tracking.js defined in bundle 'web.assets_frontend' */
odoo.define('website_sale.tracking',function(require){var ajax=require('web.ajax');$(document).ready(function(){if($("#product_detail.oe_website_sale").length){var prod_id=$("input[name='product_id']").attr('value');vpv("/stats/ecom/product_view/"+prod_id);}
$(".oe_website_sale form[action='/shop/cart/update'] a.a-submit").on('click',function(o){var prod_id=$("input[name='product_id']").attr('value');vpv("/stats/ecom/product_add_to_cart/"+prod_id);});$(".oe_website_sale a[href='/shop/checkout']").on('click',function(o){vpv("/stats/ecom/customer_checkout");});$(".oe_website_sale div.oe_cart a[href^='/web?redirect'][href$='/shop/checkout']").on('click',function(o){vpv("/stats/ecom/customer_signin");});$(".oe_website_sale form[action='/shop/confirm_order'] a.a-submit").on('click',function(o){if($("#top_menu > li > a[href='/web/login']").length){vpv("/stats/ecom/customer_signup");}
vpv("/stats/ecom/order_checkout");});$(".oe_website_sale form[target='_self'] button[type=submit]").on('click',function(o){var method=$("#payment_method input[name=acquirer]:checked").nextAll("span:first").text();vpv("/stats/ecom/order_payment/"+method);});if($(".oe_website_sale div.oe_website_sale_tx_status").length){track_ga('require','ecommerce');var order_id=$(".oe_website_sale div.oe_website_sale_tx_status").data("order-id");vpv("/stats/ecom/order_confirmed/"+order_id);ajax.jsonRpc("/shop/tracking_last_order/").then(function(o){track_ga('ecommerce:clear');if(o.transaction&&o.lines){track_ga('ecommerce:addTransaction',o.transaction);_.forEach(o.lines,function(line){track_ga('ecommerce:addItem',line);});}
track_ga('ecommerce:send');});}
function vpv(page){track_ga('send','pageview',{'page':page,'title':document.title,});}
function track_ga(){website_ga=this.ga||function(){};website_ga.apply(this,arguments);}});});;

/* /bus/static/src/js/bus.js defined in bundle 'web.assets_frontend' */
odoo.define('bus.bus',function(require){"use strict";var local_storage=require('web.local_storage');var session=require('web.session');var Widget=require('web.Widget');var bus={};var PARTNERS_PRESENCE_CHECK_PERIOD=30000;var TAB_HEARTBEAT_PERIOD=10000;var MASTER_TAB_HEARTBEAT_PERIOD=1500;bus.ERROR_DELAY=10000;bus.Bus=Widget.extend({init:function(){var self=this;this._super();this.options={};this.activated=false;this.bus_id=_.uniqueId('bus');this.channels=[];this.last=0;this.stop=false;this.is_master=true;this.last_presence=new Date().getTime();this.last_partners_presence_check=this.last_presence;this.set("window_focus",true);this.on("change:window_focus",this,function(){if(this.get("window_focus")){this.trigger('window_focus',this.is_master);}});$(window).on("focus."+this.bus_id,_.bind(this.focus_change,this,true));$(window).on("blur."+this.bus_id,_.bind(this.focus_change,this,false));$(window).on("unload."+this.bus_id,_.bind(this.focus_change,this,false));_.each('click,keydown,keyup'.split(','),function(evtype){$(window).on(evtype+"."+self.bus_id,function(){self.last_presence=new Date().getTime();});});},destroy:function(){var self=this;$(window).off("focus."+this.bus_id);$(window).off("blur."+this.bus_id);$(window).off("unload."+this.bus_id);_.each('click,keydown,keyup'.split(','),function(evtype){$(window).off(evtype+"."+self.bus_id);});},start_polling:function(){if(!this.activated){this.poll();this.stop=false;}},stop_polling:function(){this.activated=false;this.stop=true;this.channels=[];},poll:function(){var self=this;self.activated=true;var now=new Date().getTime();var options=_.extend({},this.options,{bus_inactivity:now-this.get_last_presence(),});if(this.last_partners_presence_check+PARTNERS_PRESENCE_CHECK_PERIOD>now){options=_.omit(options,'bus_presence_partner_ids');}else{this.last_partners_presence_check=now;}
var data={channels:self.channels,last:self.last,options:options};session.rpc('/longpolling/poll',data,{shadow:true,timeout:60000}).then(function(result){self.on_notification(result);if(!self.stop){self.poll();}},function(unused,e){e.preventDefault();setTimeout(_.bind(self.poll,self),bus.ERROR_DELAY+(Math.floor((Math.random()*20)+1)*1000));});},on_notification:function(notifications){var self=this;var notifs=_.map(notifications,function(notif){if(notif.id>self.last){self.last=notif.id;}
return[notif.channel,notif.message];});this.trigger("notification",notifs);},add_channel:function(channel){this.channels.push(channel);this.channels=_.uniq(this.channels);},delete_channel:function(channel){this.channels=_.without(this.channels,channel);},focus_change:function(focus){this.set("window_focus",focus);},is_odoo_focused:function(){return this.get("window_focus");},get_last_presence:function(){return this.last_presence;},update_option:function(key,value){this.options[key]=value;},delete_option:function(key){if(_.contains(_.keys(this.options),key)){delete this.options[key];}},});var CrossTabBus=bus.Bus.extend({init:function(){this._super.apply(this,arguments);this.is_master=false;this.is_registered=false;if(parseInt(getItem('bus.last_ts',0))+50000<new Date().getTime()){setItem('bus.last',-1);}
on("storage",this.on_storage.bind(this));},start_polling:function(){var self=this;if(!this.is_registered){this.is_registered=true;tab_manager.register_tab(function(){self.is_master=true;self.start_polling();},function(){self.is_master=false;self.stop_polling();},function(){var hb_period=this.is_master?MASTER_TAB_HEARTBEAT_PERIOD:TAB_HEARTBEAT_PERIOD;if(self.last_presence+hb_period>new Date().getTime()){setItem('bus.last_presence',self.last_presence);}});if(this.is_master){setItem('bus.channels',this.channels);setItem('bus.options',this.options);}else{this.channels=getItem('bus.channels',this.channels);this.options=getItem('bus.options',this.options);}
return;}
if(this.is_master){this._super.apply(this,arguments);}},on_notification:function(notifications){if(this.is_master){var last=getItem('bus.last',-1);var max_id=Math.max(last,0);var new_notifications=_.filter(notifications,function(notif){max_id=Math.max(max_id,notif.id);return notif.id<0||notif.id>last;});this.last=max_id;if(new_notifications.length){setItem('bus.last',max_id);setItem('bus.last_ts',new Date().getTime());setItem('bus.notification',new_notifications);this._super(new_notifications);}}else{this._super.apply(this,arguments);}},on_storage:function(e){var value=e.newValue;if(e.key==='bus.notification'){var notifs=JSON.parse(value);this.on_notification(notifs);}
if(e.key==='bus.channels'){this.channels=JSON.parse(value);}
if(e.key==='bus.options'){this.options=JSON.parse(value);}
if(e.key==='bus.focus'){this.set('window_focus',JSON.parse(value));}},add_channel:function(){this._super.apply(this,arguments);setItem('bus.channels',this.channels);},delete_channel:function(){this._super.apply(this,arguments);setItem('bus.channels',this.channels);},get_last_presence:function(){return getItem('bus.last_presence')||new Date().getTime();},update_option:function(){this._super.apply(this,arguments);setItem('bus.options',this.options);},delete_option:function(){this._super.apply(this,arguments);setItem('bus.options',this.options);},focus_change:function(focus){this._super.apply(this,arguments);setItem('bus.focus',focus);},});function on(type,listener){if(window.addEventListener){window.addEventListener(type,listener);}else{window.attachEvent('on'+type,listener);}}
function getItem(key,defaultValue){var val=local_storage.getItem(key);return val?JSON.parse(val):defaultValue;}
function setItem(key,value){local_storage.setItem(key,JSON.stringify(value));}
var tab_manager={peersKey:'bus.peers',masterKey:'bus.master',heartbeatKey:'bus.heartbeat',isMaster:false,id:new Date().getTime()+':'+(Math.random()*1000000000|0),register_tab:function(is_master_callback,is_no_longer_master,on_heartbeat_callback){this.is_master_callback=is_master_callback;this.is_no_longer_master=is_no_longer_master||function(){};this.on_heartbeat_callback=on_heartbeat_callback||function(){};var peers=getItem(tab_manager.peersKey,{});peers[tab_manager.id]=new Date().getTime();setItem(tab_manager.peersKey,peers);on('unload',function(){var peers=getItem(tab_manager.peersKey,{});delete peers[tab_manager.id];setItem(tab_manager.peersKey,peers);if(tab_manager.isMaster){local_storage.removeItem(tab_manager.masterKey);}});if(!local_storage.getItem(tab_manager.masterKey)){tab_manager.start_election();}
on('storage',function(e){if(!e){e=window.event;}
if(e.key!==tab_manager.masterKey){return;}
if(e.newValue===null){tab_manager.start_election();}});tab_manager.heartbeat();},heartbeat:function(){var current=new Date().getTime();var heartbeatValue=local_storage.getItem(tab_manager.heartbeatKey)||0;var peers=getItem(tab_manager.peersKey,{});if((parseInt(heartbeatValue)+5000)<current){tab_manager.start_election();}
if(tab_manager.isMaster){var cleanedPeers={};for(var peerName in peers){if(peers[peerName]+15000>current){cleanedPeers[peerName]=peers[peerName];}}
if(!tab_manager.is_last_heartbeat_mine()){tab_manager.isMaster=false;tab_manager.last_heartbeat=0;peers[tab_manager.id]=current;setItem(tab_manager.peersKey,peers);tab_manager.is_no_longer_master();}else{tab_manager.last_heartbeat=current;local_storage.setItem(tab_manager.heartbeatKey,current);setItem(tab_manager.peersKey,cleanedPeers);}}else{peers[tab_manager.id]=current;setItem(tab_manager.peersKey,peers);}
this.on_heartbeat_callback();setTimeout(function(){tab_manager.heartbeat();},tab_manager.isMaster?MASTER_TAB_HEARTBEAT_PERIOD:TAB_HEARTBEAT_PERIOD);},is_last_heartbeat_mine:function(){var heartbeatValue=local_storage.getItem(tab_manager.heartbeatKey)||0;return(parseInt(heartbeatValue)===tab_manager.last_heartbeat);},start_election:function(){if(tab_manager.isMaster){return;}
var peers=getItem(tab_manager.peersKey,{});var now=new Date().getTime();var newMaster;for(var peerName in peers){if(peers[peerName]+15000<now){continue;}
newMaster=peerName;break;}
if(newMaster===tab_manager.id){setItem(tab_manager.masterKey,tab_manager.id);tab_manager.last_heartbeat=new Date().getTime();setItem(tab_manager.heartbeatKey,tab_manager.last_heartbeat);tab_manager.isMaster=true;tab_manager.is_master_callback();delete peers[newMaster];setItem(tab_manager.peersKey,peers);}},};if(typeof Storage!=="undefined"){bus.bus=new CrossTabBus();}else{bus.bus=new bus.Bus();}
return bus;});;

/* /mail/static/src/js/chat_window.js defined in bundle 'web.assets_frontend' */
odoo.define('mail.ChatWindow',function(require){"use strict";var ChatThread=require('mail.ChatThread');var config=require('web.config');var core=require('web.core');var Widget=require('web.Widget');var QWeb=core.qweb;var _t=core._t;var HEIGHT_OPEN='400px';var HEIGHT_FOLDED='34px';return Widget.extend({template:"mail.ChatWindow",custom_events:{escape_pressed:'_onEscapePressed',document_viewer_closed:'_onDocumentViewerClose',},events:{'click .o_chat_composer':'_onComposerClick',"click .o_mail_thread":"_onChatWindowClicked","keydown .o_chat_composer":"on_keydown","keypress .o_chat_composer":"on_keypress","click .o_chat_window_close":"on_click_close","click .o_chat_title":"on_click_fold",},init:function(parent,channel_id,title,is_folded,unread_msgs,options){this._super(parent);this.title=title;this.channel_id=channel_id;this.folded=is_folded;this.options=_.defaults(options||{},{autofocus:true,display_stars:true,display_reply_icon:false,display_email_icon:false,placeholder:_t("Say something"),input_less:false,});this.status=this.options.status;this.unread_msgs=unread_msgs||0;this.is_hidden=false;this.isMobile=config.device.isMobile;},start:function(){this.$input=this.$('.o_composer_text_field');this.$header=this.$('.o_chat_header');this.thread=new ChatThread(this,{channel_id:this.channel_id,display_needactions:false,display_stars:this.options.display_stars,});this.thread.on('toggle_star_status',null,this.trigger.bind(this,'toggle_star_status'));this.thread.on('redirect_to_channel',null,this.trigger.bind(this,'redirect_to_channel'));this.thread.on('redirect',null,this.trigger.bind(this,'redirect'));if(this.folded){this.$el.css('height',HEIGHT_FOLDED);}else if(this.options.autofocus){this.focus_input();}
if(!config.device.isMobile){this.$el.css('margin-right',$.position.scrollbarWidth());}
var def=this.thread.replace(this.$('.o_chat_content'));return $.when(this._super(),def);},render:function(messages){this.update_unread(this.unread_msgs);this.thread.render(messages,{display_load_more:false});},update_unread:function(counter){this.unread_msgs=counter;this.render_header();},update_status:function(status){this.status=status;this.render_header();},render_header:function(){this.$header.html(QWeb.render('mail.ChatWindowHeaderContent',{status:this.status,title:this.title,unread_counter:this.unread_msgs,widget:this,}));},fold:function(){this.$el.animate({height:this.folded?HEIGHT_FOLDED:HEIGHT_OPEN},200);},toggle_fold:function(fold){this.folded=_.isBoolean(fold)?fold:!this.folded;if(!this.folded){this.thread.scroll_to();this.focus_input();}
this.fold();},focus_input:function(){if(config.device.touch&&config.device.size_class<=config.device.SIZES.SM){return;}
this.$input.focus();},do_show:function(){this.is_hidden=false;this._super.apply(this,arguments);},do_hide:function(){this.is_hidden=true;this._super.apply(this,arguments);},do_toggle:function(display){this.is_hidden=_.isBoolean(display)?!display:!this.is_hidden;this._super.apply(this,arguments);},on_keypress:function(event){event.stopPropagation();},on_keydown:function(event){event.stopPropagation();if(event.which===13){var content=_.str.trim(this.$input.val());var message={content:content,attachment_ids:[],partner_ids:[],};this.$input.val('');if(content){this.trigger('post_message',message,this.channel_id);}}},on_click_close:function(event){event.stopPropagation();event.preventDefault();this.trigger("close_chat_session");},on_click_fold:function(){if(config.device.size_class!==config.device.SIZES.XS){this.toggle_fold();this.trigger("fold_channel",this.channel_id,this.folded);}},_onChatWindowClicked:function(){var selectObj=window.getSelection();if(selectObj.anchorOffset===selectObj.focusOffset){this.$input.focus();}},_onComposerClick:function(ev){if($(ev.target).closest('a, button').length){return;}
this.focus_input();},_onDocumentViewerClose:function(ev){this.focus_input();},_onEscapePressed:function(){if(!this.folded){this.trigger("close_chat_session");}},});});;

/* /mail/static/src/js/document_viewer.js defined in bundle 'web.assets_frontend' */
odoo.define('mail.DocumentViewer',function(require){"use strict";var core=require('web.core');var Widget=require('web.Widget');var QWeb=core.qweb;var SCROLL_ZOOM_STEP=0.1;var ZOOM_STEP=0.5;var DocumentViewer=Widget.extend({template:"DocumentViewer",events:{'click .o_download_btn':'_onDownload','click .o_viewer_img':'_onImageClicked','click .o_viewer_video':'_onVideoClicked','click .move_next':'_onNext','click .move_previous':'_onPrevious','click .o_rotate':'_onRotate','click .o_zoom_in':'_onZoomIn','click .o_zoom_out':'_onZoomOut','click .o_close_btn, .o_viewer_img_wrapper':'_onClose','click .o_print_btn':'_onPrint','DOMMouseScroll .o_viewer_content':'_onScroll','mousewheel .o_viewer_content':'_onScroll','keydown':'_onKeydown','keyup':'_onKeyUp','mousedown .o_viewer_img':'_onStartDrag','mousemove .o_viewer_content':'_onDrag','mouseup .o_viewer_content':'_onEndDrag'},init:function(parent,attachments,activeAttachmentID){this._super.apply(this,arguments);this.attachment=_.filter(attachments,function(attachment){var match=attachment.mimetype.match("(image|video|application/pdf)");if(match){attachment.type=match[1];return true;}});this.activeAttachment=_.findWhere(attachments,{id:activeAttachmentID});this._reset();},start:function(){this.$el.modal('show');this.$el.on('hidden.bs.modal',_.bind(this._onDestroy,this));this.$('.o_viewer_img').load(_.bind(this._onImageLoaded,this));return this._super.apply(this,arguments);},_next:function(){var index=_.findIndex(this.attachment,this.activeAttachment);index=(index+1)%this.attachment.length;this.activeAttachment=this.attachment[index];this._updateContent();},_previous:function(){var index=_.findIndex(this.attachment,this.activeAttachment);index=index===0?this.attachment.length-1:index-1;this.activeAttachment=this.attachment[index];this._updateContent();},_reset:function(){this.scale=1;this.dragStartX=this.dragstopX=0;this.dragStartY=this.dragstopY=0;},_updateContent:function(){this.$('.o_viewer_content').html(QWeb.render('DocumentViewer.Content',{widget:this}));this.$('.o_viewer_img').load(_.bind(this._onImageLoaded,this));this._reset();},_getTransform:function(scale,angle){return'scale3d('+scale+', '+scale+', 1) rotate('+angle+'deg)'},_rotate:function(angle){this._reset();var new_angle=(this.angle||0)+angle;this.$('.o_viewer_img').css('transform',this._getTransform(this.scale,new_angle));this.$('.o_viewer_img').css('max-width',new_angle%180!==0?$(document).height():'100%');this.$('.o_viewer_img').css('max-height',new_angle%180!==0?$(document).width():'100%');this.angle=new_angle;},_zoom:function(scale){if(scale>0.5){this.$('.o_viewer_img').css('transform',this._getTransform(scale,this.angle||0));this.scale=scale;}},_onClose:function(e){e.preventDefault();this.$el.modal('hide');this.trigger_up('document_viewer_closed');},_onDestroy:function(){if(this.isDestroyed()){return;}
this.$el.modal('hide');this.$el.remove();},_onDownload:function(e){e.preventDefault();window.location='/web/content/'+this.activeAttachment.id+'?download=true';},_onDrag:function(e){e.preventDefault();if(this.enableDrag){var $image=this.$('.o_viewer_img');var $zoomer=this.$('.o_viewer_zoomer');var top=$image.prop('offsetHeight')*this.scale>$zoomer.height()?e.clientY-this.dragStartY:0;var left=$image.prop('offsetWidth')*this.scale>$zoomer.width()?e.clientX-this.dragStartX:0;$zoomer.css("transform","translate3d("+left+"px, "+top+"px, 0)");}},_onEndDrag:function(e){e.preventDefault();if(this.enableDrag){this.enableDrag=false;this.dragstopX=e.clientX-this.dragStartX;this.dragstopY=e.clientY-this.dragStartY;}},_onImageClicked:function(e){e.stopPropagation();},_onImageLoaded:function(){this.$('.o_loading_img').hide();},_onKeydown:function(e){switch(e.which){case $.ui.keyCode.RIGHT:e.preventDefault();this._next();break;case $.ui.keyCode.LEFT:e.preventDefault();this._previous();break;}},_onKeyUp:function(e){switch(e.which){case $.ui.keyCode.ESCAPE:e.preventDefault();this._onClose(e);break;}},_onNext:function(e){e.preventDefault();this._next();},_onPrevious:function(e){e.preventDefault();this._previous();},_onPrint:function(e){e.preventDefault();var src=this.$('.o_viewer_img').prop('src');var script=QWeb.render('PrintImage',{src:src});var printWindow=window.open('about:blank',"_new");printWindow.document.open();printWindow.document.write(script);printWindow.document.close();},_onScroll:function(e){var scale;if(e.originalEvent.wheelDelta>0||e.originalEvent.detail<0){scale=this.scale+SCROLL_ZOOM_STEP;this._zoom(scale);}else{scale=this.scale-SCROLL_ZOOM_STEP;this._zoom(scale);}},_onStartDrag:function(e){e.preventDefault();this.enableDrag=true;this.dragStartX=e.clientX-(this.dragstopX||0);this.dragStartY=e.clientY-(this.dragstopY||0);},_onVideoClicked:function(e){e.stopPropagation();var videoElement=e.target;if(videoElement.paused){videoElement.play();}else{videoElement.pause();}},_onRotate:function(e){e.preventDefault();this._rotate(90);},_onZoomIn:function(e){e.preventDefault();var scale=this.scale+ZOOM_STEP;this._zoom(scale);},_onZoomOut:function(e){e.preventDefault();var scale=this.scale-ZOOM_STEP;this._zoom(scale);},});return DocumentViewer;});;

/* /mail/static/src/js/thread.js defined in bundle 'web.assets_frontend' */
odoo.define('mail.ChatThread',function(require){"use strict";var core=require('web.core');var time=require('web.time');var DocumentViewer=require('mail.DocumentViewer');var Widget=require('web.Widget');var QWeb=core.qweb;var _t=core._t;var _lt=core._lt;var ORDER={ASC:1,DESC:-1,};var read_more=_lt('read more');var read_less=_lt('read less');function time_from_now(date){if(moment().diff(date,'seconds')<45){return _t("now");}
return date.fromNow();}
var Thread=Widget.extend({className:'o_mail_thread',events:{"click a":"on_click_redirect","click img":"on_click_redirect","click strong":"on_click_redirect","click .o_thread_show_more":"on_click_show_more","click .o_attachment_download":"_onAttachmentDownload","click .o_attachment_view":"_onAttachmentView","click .o_thread_message_needaction":function(event){var message_id=$(event.currentTarget).data('message-id');this.trigger("mark_as_read",message_id);},"click .o_thread_message_star":function(event){var message_id=$(event.currentTarget).data('message-id');this.trigger("toggle_star_status",message_id);},"click .o_thread_message_reply":function(event){this.selected_id=$(event.currentTarget).data('message-id');this.$('.o_thread_message').removeClass('o_thread_selected_message');this.$('.o_thread_message[data-message-id="'+this.selected_id+'"]').addClass('o_thread_selected_message');this.trigger('select_message',this.selected_id);event.stopPropagation();},"click .oe_mail_expand":function(event){event.preventDefault();var $message=$(event.currentTarget).parents('.o_thread_message');$message.addClass('o_message_expanded');this.expanded_msg_ids.push($message.data('message-id'));},"click .o_thread_message":function(event){$(event.currentTarget).toggleClass('o_thread_selected_message');},"click":function(){if(this.selected_id){this.unselect();this.trigger('unselect_message');}},},init:function(parent,options){this._super.apply(this,arguments);this.options=_.defaults(options||{},{display_order:ORDER.ASC,display_needactions:true,display_stars:true,display_document_link:true,display_avatar:true,squash_close_messages:true,display_email_icon:true,display_reply_icon:false,});this.expanded_msg_ids=[];this.selected_id=null;},render:function(messages,options){var self=this;var msgs=_.map(messages,this._preprocess_message.bind(this));if(this.options.display_order===ORDER.DESC){msgs.reverse();}
options=_.extend({},this.options,options);var prev_msg;_.each(msgs,function(msg){if(!prev_msg||(Math.abs(msg.date.diff(prev_msg.date))>60000)||prev_msg.message_type!=='comment'||msg.message_type!=='comment'||(prev_msg.author_id[0]!==msg.author_id[0])||prev_msg.model!==msg.model||prev_msg.res_id!==msg.res_id){msg.display_author=true;}else{msg.display_author=!options.squash_close_messages;}
prev_msg=msg;});this.$el.html(QWeb.render('mail.ChatThread',{messages:msgs,options:options,ORDER:ORDER,date_format:time.getLangDatetimeFormat(),}));this.attachments=_.uniq(_.flatten(_.map(messages,'attachment_ids')));_.each(msgs,function(msg){var $msg=self.$('.o_thread_message[data-message-id="'+msg.id+'"]');$msg.find('.o_mail_timestamp').data('date',msg.date);self.insert_read_more($msg);});if(!this.update_timestamps_interval){this.update_timestamps_interval=setInterval(function(){self.update_timestamps();},1000*60);}},insert_read_more:function($element){var self=this;var groups=[];var read_more_nodes;var $children=$element.contents().filter(function(){return this.nodeType===1||this.nodeType===3&&this.nodeValue.trim();});_.each($children,function(child){var $child=$(child);if(child.nodeType===3&&$child.prevAll("[id*='stopSpelling']").length>0){var $child=$('<span>',{text:child.textContent,"data-o-mail-quote":"1",});child.parentNode.replaceChild($child[0],child);}
if($child.attr('data-o-mail-quote')||($child.get(0).nodeName==='BR'&&$child.prev("[data-o-mail-quote='1']").length>0)){if(!read_more_nodes){read_more_nodes=[];groups.push(read_more_nodes);}
$child.hide();read_more_nodes.push($child);}else{read_more_nodes=undefined;self.insert_read_more($child);}});_.each(groups,function(group){var $read_more=$('<a>',{class:"o_mail_read_more",href:"#",text:read_more,}).insertBefore(group[0]);var is_read_more=true;$read_more.click(function(e){e.preventDefault();is_read_more=!is_read_more;_.each(group,function($child){$child.hide();$child.toggle(!is_read_more);});$read_more.text(is_read_more?read_more:read_less);});});},update_timestamps:function(){var isAtBottom=this.is_at_bottom();this.$('.o_mail_timestamp').each(function(){var date=$(this).data('date');$(this).html(time_from_now(date));});if(isAtBottom&&!this.is_at_bottom()){this.scroll_to();}},on_click_redirect:function(event){if($(event.target).data('oe-field')!==undefined){return;}
var id=$(event.target).data('oe-id');if(id){event.preventDefault();var model=$(event.target).data('oe-model');var options=model&&(model!=='mail.channel')?{model:model,id:id}:{channel_id:id};this._redirect(options);}},_redirect:_.debounce(function(options){if('channel_id'in options){this.trigger('redirect_to_channel',options.channel_id);}else{this.trigger('redirect',options.model,options.id);}},500,true),on_click_show_more:function(){this.trigger('load_more_messages');},_preprocess_message:function(message){var msg=_.extend({},message);msg.date=moment.min(msg.date,moment());msg.hour=time_from_now(msg.date);var date=msg.date.format('YYYY-MM-DD');if(date===moment().format('YYYY-MM-DD')){msg.day=_t("Today");}else if(date===moment().subtract(1,'days').format('YYYY-MM-DD')){msg.day=_t("Yesterday");}else{msg.day=msg.date.format('LL');}
if(_.contains(this.expanded_msg_ids,message.id)){msg.expanded=true;}
msg.display_subject=message.subject&&message.message_type!=='notification'&&!(message.model&&(message.model!=='mail.channel'));msg.is_selected=msg.id===this.selected_id;return msg;},remove_message_and_render:function(message_id,messages,options){var self=this;var done=$.Deferred();this.$('.o_thread_message[data-message-id="'+message_id+'"]').fadeOut({done:function(){self.render(messages,options);done.resolve();},duration:200,});return done;},scroll_to:function(options){options=options||{};if(options.id!==undefined){var $target=this.$('.o_thread_message[data-message-id="'+options.id+'"]');if(options.only_if_necessary){var delta=$target.parent().height()-$target.height();var offset=delta<0?0:delta-($target.offset().top-$target.offsetParent().offset().top);offset=-Math.min(offset,0);this.$el.scrollTo("+="+offset+"px",options);}else if($target.length){this.$el.scrollTo($target);}}else if(options.offset!==undefined){this.$el.scrollTop(options.offset);}else{this.$el.scrollTop(this.el.scrollHeight);}},get_scrolltop:function(){return this.$el.scrollTop();},is_at_bottom:function(){return this.el.scrollHeight-this.$el.scrollTop()-this.$el.outerHeight()<5;},unselect:function(){this.$('.o_thread_message').removeClass('o_thread_selected_message');this.selected_id=null;},destroy:function(){clearInterval(this.update_timestamps_interval);},_onAttachmentDownload:function(event){event.stopPropagation();},_onAttachmentView:function(event){event.stopPropagation();var activeAttachmentID=$(event.currentTarget).data('id');if(activeAttachmentID){var attachmentViewer=new DocumentViewer(this,this.attachments,activeAttachmentID);attachmentViewer.appendTo($('body'));}},});Thread.ORDER=ORDER;return Thread;});;

/* /im_livechat/static/src/js/im_livechat.js defined in bundle 'web.assets_frontend' */
odoo.define('im_livechat.im_livechat',function(require){"use strict";var local_storage=require('web.local_storage');var bus=require('bus.bus').bus;var concurrency=require('web.concurrency');var config=require('web.config');var core=require('web.core');var session=require('web.session');var time=require('web.time');var utils=require('web.utils');var Widget=require('web.Widget');var ChatWindow=require('mail.ChatWindow');var _t=core._t;var QWeb=core.qweb;var LIVECHAT_COOKIE_HISTORY='im_livechat_history';var HISTORY_LIMIT=15;var page=window.location.href.replace(/^.*\/\/[^\/]+/,'');var page_history=utils.get_cookie(LIVECHAT_COOKIE_HISTORY);var url_history=[];if(page_history){url_history=JSON.parse(page_history)||[];}
if(!_.contains(url_history,page)){url_history.push(page);while(url_history.length>HISTORY_LIMIT){url_history.shift();}
utils.set_cookie(LIVECHAT_COOKIE_HISTORY,JSON.stringify(url_history),60*60*24);}
var LivechatButton=Widget.extend({className:"openerp o_livechat_button hidden-print",events:{"click":"open_chat"},init:function(parent,server_url,options){this._super(parent);this.options=_.defaults(options||{},{input_placeholder:_t('Ask something ...'),default_username:_t("Visitor"),button_text:_t("Chat with one of our collaborators"),default_message:_t("How may I help you?"),});this.channel=null;this.chat_window=null;this.messages=[];this.server_url=server_url;},willStart:function(){var self=this;var cookie=utils.get_cookie('im_livechat_session');var ready;if(!cookie){ready=session.rpc("/im_livechat/init",{channel_id:this.options.channel_id}).then(function(result){if(!result.available_for_me){return $.Deferred().reject();}
self.rule=result.rule;});}else{var channel=JSON.parse(cookie);ready=session.rpc("/mail/chat_history",{uuid:channel.uuid,limit:100}).then(function(history){self.history=history;});}
return ready.then(this.load_qweb_template.bind(this));},start:function(){this.$el.text(this.options.button_text);var small_screen=config.device.size_class===config.device.SIZES.XS;if(this.history){_.each(this.history.reverse(),this.add_message.bind(this));this.open_chat();}else if(!small_screen&&this.rule.action==='auto_popup'){var auto_popup_cookie=utils.get_cookie('im_livechat_auto_popup');if(!auto_popup_cookie||JSON.parse(auto_popup_cookie)){this.auto_popup_timeout=setTimeout(this.open_chat.bind(this),this.rule.auto_popup_timer*1000);}}
bus.on('notification',this,function(notifications){var self=this;_.each(notifications,function(notification){self._on_notification(notification);});});return this._super();},_on_notification:function(notification){if(this.channel&&(notification[0]===this.channel.uuid)){if(notification[1]._type==="history_command"){var cookie=utils.get_cookie(LIVECHAT_COOKIE_HISTORY);var history=cookie?JSON.parse(cookie):[];session.rpc("/im_livechat/history",{pid:this.channel.operator_pid[0],channel_uuid:this.channel.uuid,page_history:history,});}else{this.add_message(notification[1]);this.render_messages();if(this.chat_window.folded||!this.chat_window.thread.is_at_bottom()){this.chat_window.update_unread(this.chat_window.unread_msgs+1);}}}},load_qweb_template:function(){var xml_files=['/mail/static/src/xml/chat_window.xml','/mail/static/src/xml/thread.xml','/im_livechat/static/src/xml/im_livechat.xml'];var defs=_.map(xml_files,function(tmpl){return session.rpc('/web/proxy/load',{path:tmpl}).then(function(xml){QWeb.add_template(xml);});});return $.when.apply($,defs);},open_chat:_.debounce(function(){if(this.opening_chat){return;}
var self=this;var cookie=utils.get_cookie('im_livechat_session');var def;this.opening_chat=true;clearTimeout(this.auto_popup_timeout);if(cookie){def=$.when(JSON.parse(cookie));}else{this.messages=[];def=session.rpc('/im_livechat/get_session',{channel_id:this.options.channel_id,anonymous_name:this.options.default_username,},{shadow:true});}
def.then(function(channel){if(!channel||!channel.operator_pid){alert(_t("None of our collaborators seems to be available, please try again later."));}else{self.channel=channel;self.open_chat_window(channel);self.send_welcome_message();self.render_messages();bus.add_channel(channel.uuid);bus.start_polling();utils.set_cookie('im_livechat_session',JSON.stringify(channel),60*60);utils.set_cookie('im_livechat_auto_popup',JSON.stringify(false),60*60);}}).always(function(){self.opening_chat=false;});},200,true),open_chat_window:function(channel){var self=this;var options={display_stars:false,placeholder:this.options.input_placeholder||"",};var is_folded=(channel.state==='folded');this.chat_window=new ChatWindow(this,channel.id,channel.name,is_folded,channel.message_unread_counter,options);this.chat_window.appendTo($('body')).then(function(){self.chat_window.$el.css({right:0,bottom:0});self.$el.hide();});this.chat_window.on("close_chat_session",this,function(){var input_disabled=this.chat_window.$(".o_chat_composer input").prop('disabled');var ask_fb=!input_disabled&&_.find(this.messages,function(msg){return msg.id!=='_welcome';});if(ask_fb){this.chat_window.toggle_fold(false);this.ask_feedback();}else{this.close_chat();}});this.chat_window.on("post_message",this,function(message){self.send_message(message).fail(function(error,e){e.preventDefault();return self.send_message(message);});});this.chat_window.on("fold_channel",this,function(){this.channel.state=(this.channel.state==='open')?'folded':'open';utils.set_cookie('im_livechat_session',JSON.stringify(this.channel),60*60);});this.chat_window.thread.$el.on("scroll",null,_.debounce(function(){if(self.chat_window.thread.is_at_bottom()){self.chat_window.update_unread(0);}},100));},close_chat:function(){this.chat_window.destroy();utils.set_cookie('im_livechat_session',"",-1);},send_message:function(message){var self=this;return session.rpc("/mail/chat_post",{uuid:this.channel.uuid,message_content:message.content}).then(function(){self.chat_window.thread.scroll_to();});},add_message:function(data,options){var msg={id:data.id,attachment_ids:data.attachment_ids,author_id:data.author_id,body:data.body,date:moment(time.str_to_datetime(data.date)),is_needaction:false,is_note:data.is_note,customer_email_data:[]};var hasAlreadyMessage=_.some(this.messages,function(message){return message.id===msg.id;});if(hasAlreadyMessage){return;}
msg.displayed_author=msg.author_id&&msg.author_id[1]||this.options.default_username;msg.avatar_src=this.server_url;if(msg.author_id&&msg.author_id[0]){msg.avatar_src+="/web/image/res.partner/"+msg.author_id[0]+"/image_small";}else{msg.avatar_src+="/mail/static/src/img/smiley/avatar.jpg";}
if(options&&options.prepend){this.messages.unshift(msg);}else{this.messages.push(msg);}},render_messages:function(){var should_scroll=!this.chat_window.folded&&this.chat_window.thread.is_at_bottom();this.chat_window.render(this.messages);if(should_scroll){this.chat_window.thread.scroll_to();}},send_welcome_message:function(){if(this.options.default_message){this.add_message({id:'_welcome',attachment_ids:[],author_id:this.channel.operator_pid,body:this.options.default_message,channel_ids:[this.channel.id],date:time.datetime_to_str(new Date()),tracking_value_ids:[],},{prepend:true});}},ask_feedback:function(){this.chat_window.$(".o_chat_composer input").prop('disabled',true);var feedback=new Feedback(this,this.channel.uuid);feedback.replace(this.chat_window.thread.$el);feedback.on("send_message",this,this.send_message);feedback.on("feedback_sent",this,this.close_chat);}});var Feedback=Widget.extend({template:"im_livechat.FeedBack",events:{'click .o_livechat_rating_choices img':'on_click_smiley','click .o_livechat_no_feedback em':'on_click_no_feedback','click .o_rating_submit_button':'on_click_send',},init:function(parent,channel_uuid){this._super(parent);this.channel_uuid=channel_uuid;this.server_origin=session.origin;this.rating=undefined;this.dp=new concurrency.DropPrevious();},on_click_smiley:function(ev){this.rating=parseInt($(ev.currentTarget).data('value'));this.$('.o_livechat_rating_choices img').removeClass('selected');this.$('.o_livechat_rating_choices img[data-value="'+this.rating+'"]').addClass('selected');var close_chat=false;if(this.rating===1){this.$('.o_livechat_rating_reason').show();}else{this.$('.o_livechat_rating_reason').hide();close_chat=true;}
this._send_feedback({close:close_chat});},on_click_no_feedback:function(){this.trigger("feedback_sent");},on_click_send:function(){if(_.isNumber(this.rating)){this._send_feedback({reason:this.$('textarea').val(),close:true});}},_send_feedback:function(options){var self=this;var args={uuid:this.channel_uuid,rate:this.rating,reason:options.reason};this.dp.add(session.rpc('/im_livechat/feedback',args)).then(function(){if(options.close){var content=_.str.sprintf(_t("Rating: :rating_%d"),self.rating);if(options.reason){content+=" \n"+options.reason;}
self.trigger("send_message",{content:content});self.trigger("feedback_sent");}});}});return{LivechatButton:LivechatButton,Feedback:Feedback,};});;

/* /website_forum/static/src/js/website_forum.js defined in bundle 'web.assets_frontend' */
odoo.define('website_forum.website_forum',function(require){'use strict';require('web.dom_ready');var ajax=require('web.ajax');var core=require('web.core');var _t=core._t;var lastsearch;if(!$('.website_forum').length){return $.Deferred().reject("DOM doesn't contain '.website_forum'");}
$('span[data-oe-model="forum.post"][data-oe-field="content"]').find('img.pull-left').removeClass('pull-left');$("[data-toggle='popover']").popover();$('.karma_required').on('click',function(ev){var karma=$(ev.currentTarget).data('karma');if(karma){ev.preventDefault();var msg=karma+' '+_t(' karma is required to perform this action. You can earn karma by having your answers upvoted by the community.');if($('a[href*="/login"]').length){msg=_t('Sorry you must be logged in to perform this action');}
var $warning=$('<div class="alert alert-danger alert-dismissable oe_forum_alert mt8" id="karma_alert">'+'<button type="button" class="close notification_close" data-dismiss="alert" aria-hidden="true">&times;</button>'+
msg+'</div>');var $voteAlert=$('#karma_alert');if($voteAlert.length){$voteAlert.remove();}
$(ev.currentTarget).after($warning);}});$('.o_js_forum_tag_follow').hover(function(event){$(this).find('.o_forum_tag_follow_box').stop().fadeIn().css('display','block');},function(event){$(this).find('.o_forum_tag_follow_box').stop().fadeOut().css('display','none');});$('.o_forum_profile_pic_edit').on('click',function(ev){ev.preventDefault();$(this).closest('form').find('.o_forum_file_upload').trigger('click');});$('.o_forum_file_upload').on('change',function(){if(this.files.length){var $form=$(this).closest('form');var reader=new window.FileReader();reader.onload=function(ev){$form.find('.o_forum_avatar_img').attr('src',ev.target.result);};reader.readAsDataURL(this.files[0]);$form.find('#forum_clear_image').remove();}});$('.o_forum_profile_pic_clear').click(function(){var $form=$(this).closest('form');$form.find('.o_forum_avatar_img').attr("src","/web/static/src/img/placeholder.png");$form.append($('<input/>',{name:'clear_image',id:'forum_clear_image',type:'hidden',}));});$('.o_forum_user_info').hover(function(){$(this).parent().find('.o_forum_user_bio_expand').delay(500).toggle('fast');},function(){$(this).parent().find('.o_forum_user_bio_expand').clearQueue();});$('.o_forum_user_bio_expand').hover(function(){},function(){$(this).fadeOut('fast');});$('.flag').not('.karma_required').on('click',function(ev){ev.preventDefault();var $link=$(ev.currentTarget);ajax.jsonRpc($link.data('href'),'call',{}).then(function(data){if(data.error){var $warning;if(data.error==='anonymous_user'){$warning=$('<div class="alert alert-danger alert-dismissable oe_forum_alert" id="flag_alert">'+'<button type="button" class="close notification_close" data-dismiss="alert" aria-hidden="true">&times;</button>'+
_t('Sorry you must be logged to flag a post')+'</div>');}else if(data.error==='post_already_flagged'){$warning=$('<div class="alert alert-danger alert-dismissable oe_forum_alert" id="flag_alert">'+'<button type="button" class="close notification_close" data-dismiss="alert" aria-hidden="true">&times;</button>'+
_t('This post is already flagged')+'</div>');}else if(data.error==='post_non_flaggable'){$warning=$('<div class="alert alert-danger alert-dismissable oe_forum_alert" id="flag_alert">'+'<button type="button" class="close notification_close" data-dismiss="alert" aria-hidden="true">&times;</button>'+
_t('This post can not be flagged')+'</div>');}
var flag_alert=$link.parent().find("#flag_alert");if(flag_alert.length===0){$link.parent().append($warning);}}else if(data.success){var elem=$link;if(data.success==='post_flagged_moderator'){elem.html(' Flagged');var c=parseInt($('#count_flagged_posts').html(),10);c++;$('#count_flagged_posts').html(c);}else if(data.success==='post_flagged_non_moderator'){elem.html(' Flagged');var forum_answer=elem.closest('.forum_answer');forum_answer.fadeIn(1000);forum_answer.slideUp(1000);}}});});$('.vote_up,.vote_down').not('.karma_required').on('click',function(ev){ev.preventDefault();var $link=$(ev.currentTarget);ajax.jsonRpc($link.data('href'),'call',{}).then(function(data){if(data.error){var $warning;if(data.error==='own_post'){$warning=$('<div class="alert alert-danger alert-dismissable oe_forum_alert" id="vote_alert">'+'<button type="button" class="close notification_close" data-dismiss="alert" aria-hidden="true">&times;</button>'+
_t('Sorry, you cannot vote for your own posts')+'</div>');}else if(data.error==='anonymous_user'){$warning=$('<div class="alert alert-danger alert-dismissable oe_forum_alert" id="vote_alert">'+'<button type="button" class="close notification_close" data-dismiss="alert" aria-hidden="true">&times;</button>'+
_t('Sorry you must be logged to vote')+'</div>');}
var vote_alert=$link.parent().find("#vote_alert");if(vote_alert.length===0){$link.parent().append($warning);}}else{$link.parent().find(".vote_count").html(data['vote_count']);if(data.user_vote===0){$link.parent().find(".text-success").removeClass("text-success");$link.parent().find(".text-warning").removeClass("text-warning");}else{if(data.user_vote===1){$link.addClass("text-success");}else{$link.addClass("text-warning");}}}});});$(".o_js_validation_queue a[href*='/validate']").on('click',function(ev){ev.preventDefault();var $link=$(ev.currentTarget);var self=$(this);$(this).parents('.post_to_validate').hide();$.get($link.attr('href')).fail(function(){self.parents('.o_js_validation_queue > div').addClass('panel-danger').css('background-color','#FAA');self.parents('.post_to_validate').show();}).done(function(){var left=$('.o_js_validation_queue:visible').length;var type=$('h2.page-header li.active a').data('type');$('#count_post').text(left);$('#moderation_tools a[href*="/'+type+'_"]').find('strong').text(left);});});$('.accept_answer').not('.karma_required').on('click',function(ev){ev.preventDefault();var $link=$(ev.currentTarget);ajax.jsonRpc($link.data('href'),'call',{}).then(function(data){if(data.error){if(data.error==='anonymous_user'){var $warning=$('<div class="alert alert-danger alert-dismissable" id="correct_answer_alert" style="position:absolute; margin-top: -30px; margin-left: 90px;">'+'<button type="button" class="close notification_close" data-dismiss="alert" aria-hidden="true">&times;</button>'+
_t('Sorry, anonymous users cannot choose correct answer.')+'</div>');}
var correct_answer_alert=$link.parent().find("#correct_answer_alert");if(correct_answer_alert.length===0){$link.parent().append($warning);}}else{if(data){$(".oe_answer_true").addClass('oe_answer_false').removeClass("oe_answer_true");$link.addClass("oe_answer_true").removeClass('oe_answer_false');}else{$link.removeClass("oe_answer_true").addClass('oe_answer_false');}}});});$('.favourite_question').on('click',function(ev){ev.preventDefault();var $link=$(ev.currentTarget);ajax.jsonRpc($link.data('href'),'call',{}).then(function(data){$link.toggleClass("forum_favourite_question",!!data);});});$('.comment_delete').on('click',function(ev){ev.preventDefault();var $link=$(ev.currentTarget);ajax.jsonRpc($link.closest('form').attr('action'),'call',{}).then(function(){$link.parents('.comment').first().remove();});});$('.notification_close').on('click',function(ev){ev.preventDefault();var $link=$(ev.currentTarget);ajax.jsonRpc("/forum/notification_read",'call',{'notification_id':$link.attr("id")});});$('.send_validation_email').on('click',function(ev){ev.preventDefault();var $link=$(ev.currentTarget);ajax.jsonRpc("/forum/send_validation_email",'call',{'forum_id':$link.attr('forum-id'),}).then(function(data){if(data){$('button.validation_email_close').click();}});});$('.validated_email_close').on('click',function(ev){ajax.jsonRpc("/forum/validate_email/close",'call',{});});var forum_login=_.string.sprintf('%s/web?redirect=%s',window.location.origin,escape(window.location.href));$('.forum_register_url').attr('href',forum_login);$('.js_close_intro').on('click',function(ev){ev.preventDefault();document.cookie="forum_welcome_message = false";$('.forum_intro').slideUp();return true;});$('.link_url, .o_forum_post_link').on('change',function(ev){ev.preventDefault();var $link=$(ev.currentTarget);var display_error=function(){var $warning=$('<div class="alert alert-danger alert-dismissable" style="position:absolute; margin-top: -180px; margin-left: 90px;">'+'<button type="button" class="close notification_close" data-dismiss="alert" aria-hidden="true">&times;</button>'+'Please enter valid URL. Example: http://www.odoo.com'+'</div>');$link.parent().append($warning);$link.parents('form').find('button')[0].disabled=true;};var url=$link.val();if(url.search("^http(s?)://.*")){url='http://'+url;}
var regex=new RegExp("^"+"(?:(?:https?|ftp)://)"+"(?:\\S+(?::\\S*)?@)?"+"(?:"+"(?!(?:10|127)(?:\\.\\d{1,3}){3})"+"(?!(?:169\\.254|192\\.168)(?:\\.\\d{1,3}){2})"+"(?!172\\.(?:1[6-9]|2\\d|3[0-1])(?:\\.\\d{1,3}){2})"+"(?:[1-9]\\d?|1\\d\\d|2[01]\\d|22[0-3])"+"(?:\\.(?:1?\\d{1,2}|2[0-4]\\d|25[0-5])){2}"+"(?:\\.(?:[1-9]\\d?|1\\d\\d|2[0-4]\\d|25[0-4]))"+"|"+"(?:(?:[a-z\\u00a1-\\uffff0-9]-*)*[a-z\\u00a1-\\uffff0-9]+)"+"(?:\\.(?:[a-z\\u00a1-\\uffff0-9]-*)*[a-z\\u00a1-\\uffff0-9]+)*"+"(?:\\.(?:[a-z\\u00a1-\\uffff]{2,}))"+"\\.?"+")"+"(?::\\d{2,5})?"+"(?:[/?#]\\S*)?"+"$","i");if(regex.test(url)){ajax.jsonRpc("/forum/get_url_title",'call',{'url':url}).then(function(data){if(data){$("input[name='post_name']")[0].value=data;$link.parents('form').find('button')[0].disabled=false;}else{display_error();}});}else{display_error();}});$('input.js_select2').select2({tags:true,tokenSeparators:[","," ","_"],maximumInputLength:35,minimumInputLength:2,maximumSelectionSize:5,lastsearch:[],createSearchChoice:function(term){if($(lastsearch).filter(function(){return this.text.localeCompare(term)===0;}).length===0){if(parseInt($("#karma").val())>=parseInt($("#karma_edit_retag").val())){return{id:"_"+$.trim(term),text:$.trim(term)+' *',isNew:true,};}}},formatResult:function(term){if(term.isNew){return'<span class="label label-primary">New</span> '+_.escape(term.text);}
else{return _.escape(term.text);}},ajax:{url:'/forum/get_tags',dataType:'json',data:function(term){return{q:term,l:50};},results:function(data){var ret=[];_.each(data,function(x){ret.push({id:x.id,text:x.name,isNew:false});});lastsearch=ret;return{results:ret};}},initSelection:function(element,callback){var data=[];_.each(element.data('init-value'),function(x){data.push({id:x.id,text:x.name,isNew:false});});element.val('');callback(data);},});$('textarea.load_editor').each(function(){var $textarea=$(this);var editor_karma=$textarea.data('karma')||30;if(!$textarea.val().match(/\S/)){$textarea.val("<p><br/></p>");}
var $form=$textarea.closest('form');var toolbar=[['style',['style']],['font',['bold','italic','underline','clear']],['para',['ul','ol','paragraph']],['table',['table']],['history',['undo','redo']],];if(parseInt($("#karma").val())>=editor_karma){toolbar.push(['insert',['link','picture']]);}
$textarea.summernote({height:150,toolbar:toolbar,styleWithSpan:false});$form.find('.note-editable').find('img.pull-left').removeClass('pull-left');$form.on('click','button, .a-submit',function(){$textarea.html($form.find('.note-editable').code());});});});;

/* /website_forum/static/src/js/website_forum.share.js defined in bundle 'web.assets_frontend' */
odoo.define('website_forum.share',function(require){'use strict';require('web.dom_ready');var core=require('web.core');var base=require('web_editor.base');var sAnimation=require('website.content.snippets.animation');var qweb=core.qweb;if(!$('.website_forum').length){return $.Deferred().reject("DOM doesn't contain '.website_forum'");}
var ForumShare=sAnimation.registry.socialShare.extend({xmlDependencies:sAnimation.registry.socialShare.prototype.xmlDependencies.concat(['/website_forum/static/src/xml/website_forum_share_templates.xml']),read_events:{},init:function(parent,editableMode,targetType){this._super.apply(this,arguments);this.targetType=targetType;},start:function(){var def=this._super.apply(this,arguments);this._onMouseEnter();return def;},_bindSocialEvent:function(){this._super.apply(this,arguments);$('.oe_share_bump').click($.proxy(this._postBump,this));},_render:function(){if(!this.targetType){this._super.apply(this,arguments);}else if(this.targetType==='social-alert'){$('.row .question').before(qweb.render('website.social_alert',{medias:this.socialList}));}else{$('body').append(qweb.render('website.social_modal',{medias:this.socialList,target_type:this.targetType}));$('#oe_social_share_modal').modal('show');}},_postBump:function(){this._rpc({route:'/forum/post/bump',params:{post_id:this.element.data('id'),},});},});base.ready().then(function(){$(document.body).on('click',':not(.karma_required).oe_social_share_call',function(){sessionStorage.setItem('social_share',JSON.stringify({targetType:$(this).data('social-target-type'),}));});if(sessionStorage.getItem('social_share')){var socialData=JSON.parse(sessionStorage.getItem('social_share'));(new ForumShare(null,false,socialData.targetType)).attachTo($(document.body));sessionStorage.removeItem('social_share');}
var $questionContainer=$('.oe_js_bump');if($questionContainer.length){new ForumShare(null,false,'social-alert').attachTo($questionContainer);}});});;

/* /website_forum/static/src/js/website_tour_forum_question.js defined in bundle 'web.assets_frontend' */
odoo.define('website_forum.tour_forum_question',function(require){'use strict';var tour=require("web_tour.tour");var base=require("web_editor.base");tour.register('forum_question',{test:true,url:'/forum/help-1',wait_for:base.ready(),},[{content:"Ask the question in this forum by clicking on the button.",trigger:'.btn-block a:first',},{content:"Give your question content.",trigger:'input[name=post_name]',run:'text First Question Title',},{content:"Put your question here.",extra_trigger:"#wrap:not(:has(input[name=post_name]:propValue('')))",trigger:'.note-editable p',run:'text First Question',},{content:"Insert tags related to your question.",extra_trigger:'.note-editable:not(:has(br))',trigger:'.select2-choices',run:'text Tag',},{content:"Click to post your question.",extra_trigger:"#wrap:not(:has(input[id=s2id_autogen2]:propValue('')))",trigger:'button:contains("Post Your Question")',},{content:"This page contain new created question.",extra_trigger:'#wrap:has(".fa-star")',trigger:'button[data-dismiss="modal"]',},{content:"Put your answer here.",trigger:'.note-editable p',run:'text First Answer',},{content:"Click to post your answer.",extra_trigger:'.note-editable:not(:has(br))',trigger:'button:contains("Post Answer")',},{content:"This page contain new created question and its answer.",extra_trigger:'#wrap:has(".fa-check-circle")',trigger:'button[data-dismiss="modal"]',},{content:"Click here to accept this answer.",trigger:'a[data-karma="20"]:first',},{content:"Congratulations! You just created and post your first question and answer.",trigger:'#wrap:has(".oe_answer_true")',}]);});;

/* /website_crm_partner_assign/static/src/js/crm_partner_assign.js defined in bundle 'web.assets_frontend' */
odoo.define('crm.partner_assign',function(require){'use strict';var rpc=require('web.rpc');require('web.dom_ready');var interested_form=$('.interested_partner_assign_form');var desinterested_form=$('.desinterested_partner_assign_form');var opp_stage_buttons=$('.opp-stage-button');var new_opp_form=$('.new_opp_form');if(!interested_form.length&&!desinterested_form.length&&!opp_stage_buttons.length&&!new_opp_form.length){return $.Deferred().reject("DOM doesn't contain website_crm_partner_assign elements");}
$('.interested_partner_assign_confirm').on('click',function(e){var $btn=$(this);if($('.interested_partner_assign_form .comment_interested').val()&&$('.interested_partner_assign_form .contacted_interested').prop('checked')){$btn.prop('disabled',true);rpc.query({model:'crm.lead',method:"partner_interested",args:[[parseInt($('.interested_partner_assign_form .assign_lead_id').val())],$('.interested_partner_assign_form .comment_interested').val()],}).then(function(){window.location.href='/my/leads';}).always(function(){$btn.prop('disabled',false);});}else{$('.interested_partner_assign_form .error_partner_assign_interested').css('display','block');}
return false;});$('.desinterested_partner_assign_confirm').on('click',function(){var $btn=$(this);$btn.prop('disabled',true);rpc.query({model:'crm.lead',method:'partner_desinterested',args:[[parseInt($('.desinterested_partner_assign_form .assign_lead_id').val())],$('.desinterested_partner_assign_form .comment_desinterested').val(),$('.desinterested_partner_assign_form .contacted_desinterested').prop('checked'),$('.desinterested_partner_assign_form .customer_mark_spam').prop('checked'),],}).then(function(){window.location.href='/my/leads';}).always(function(){$btn.prop('disabled',false);});return false;});opp_stage_buttons.on('click',function(e){var $btn=$(this);$btn.prop('disabled',true);rpc.query({model:'crm.lead',method:'write',args:[[parseInt(e.currentTarget.getAttribute('opp'))],{stage_id:parseInt(e.currentTarget.getAttribute('data')),},],context:{website_partner_assign:1},}).fail(function(){$btn.prop('disabled',false);}).done(function(){window.location.reload();});});$('.edit_contact_form .country_id').on('change',function(){var country_id=$('.edit_contact_form .country_id').find(":selected").attr('value');$(".edit_contact_form .state[country!="+country_id+"]").css('display','none');$(".edit_contact_form .state[country="+country_id+"]").css('display','block');});$('.edit_contact_confirm').on('click',function(){var $btn=$(this);$btn.prop('disabled',true);rpc.query({model:'crm.lead',method:"write",args:[[parseInt($('.edit_contact_form .opportunity_id').val())],{partner_name:$('.edit_contact_form .partner_name').val(),phone:$('.edit_contact_form .phone').val(),mobile:$('.edit_contact_form .mobile').val(),email_from:$('.edit_contact_form .email_from').val(),street:$('.edit_contact_form .street').val(),street2:$('.edit_contact_form .street2').val(),city:$('.edit_contact_form .city').val(),zip:$('.edit_contact_form .zip').val(),state_id:parseInt($('.edit_contact_form .state_id').find(":selected").attr('value')),country_id:parseInt($('.edit_contact_form .country_id').find(":selected").attr('value')),}],}).fail(function(){$btn.prop('disabled',false);}).done(function(){window.location.reload();});return false;});$('.new_opp_confirm').on('click',function(e){var $btn=$(this);$btn.prop('disabled',true);rpc.query({model:'crm.lead',method:'create_opp_portal',args:[{contact_name:$('.new_opp_form .contact_name').val(),title:$('.new_opp_form .title').val(),description:$('.new_opp_form .description').val(),}],}).done(function(response){if(response.errors){$('#new-opp-dialog .alert').remove();$('#new-opp-dialog div:first').prepend("<div class='alert alert-danger'>"+response.errors+"</div>");$btn.prop('disabled',false);}
else{window.location='/my/opportunity/'+response.id;}}).fail(function(){$btn.prop('disabled',false);});return false;});$('.edit_opp_confirm').on('click',function(){var $btn=$(this);$btn.prop('disabled',true);rpc.query({model:'crm.lead',method:'update_lead_portal',args:[[parseInt($('.edit_opp_form .opportunity_id').val())],{date_deadline:$('.edit_opp_form .date_deadline').val(),planned_revenue:parseFloat($('.edit_opp_form .planned_revenue').val()),probability:parseFloat($('.edit_opp_form .probability').val()),activity_type_id:parseInt($('.edit_opp_form .next_activity').find(":selected").attr('data')),activity_summary:$('.edit_opp_form .activity_summary').val(),activity_date_deadline:$('.edit_opp_form .activity_date_deadline').val(),priority:$('input[name="PriorityRadioOptions"]:checked').val(),}],}).fail(function(){$btn.prop('disabled',false);}).done(function(){window.location.reload();});return false;});$('.edit_opp_form .next_activity').on('change',function(){var selected=$('.edit_opp_form .next_activity').find(":selected");if(selected.attr('activity_summary')){$('.edit_opp_form .activity_summary').val(selected.attr('activity_summary'));}
if(selected.attr('days')){var date_now=moment();var days=parseInt(selected.attr('days'));var date=date_now.add(days,'days');$('.edit_opp_form .activity_date_deadline').val(date.format('YYYY-MM-DD'));}});$("div.input-group span.fa-calendar").on('click',function(e){$(e.currentTarget).closest("div.date").datetimepicker({icons:{time:'fa fa-clock-o',date:'fa fa-calendar',up:'fa fa-chevron-up',down:'fa fa-chevron-down'},});});});;

/* /website_sale_comparison/static/src/js/website_sale_comparison.js defined in bundle 'web.assets_frontend' */
odoo.define('website_sale_comparison.comparison',function(require){"use strict";require('web.dom_ready');var ajax=require('web.ajax');var concurrency=require('web.concurrency');var core=require('web.core');var _t=core._t;var utils=require('web.utils');var Widget=require('web.Widget');var website=require('web_editor.base');var website_sale_utils=require('website_sale.utils');if(!$('.oe_website_sale').length){return $.Deferred().reject("DOM doesn't contain '.oe_website_sale'");}
var qweb=core.qweb;ajax.loadXML('/website_sale_comparison/static/src/xml/comparison.xml',qweb);var ProductComparison=Widget.extend({template:"product_comparison_template",events:{'click .o_product_panel_header':'toggle_panel',},product_data:{},init:function(){this.comparelist_product_ids=JSON.parse(utils.get_cookie('comparelist_product_ids')||'[]');this.product_compare_limit=4;this.guard=new concurrency.Mutex();},start:function(){var self=this;self.load_products(this.comparelist_product_ids).then(function(){self.update_content(self.comparelist_product_ids,true);if(self.comparelist_product_ids.length){$('.o_product_feature_panel').show();self.update_comparelist_view();}});self.popover=$('#comparelist .o_product_panel_header').popover({trigger:'manual',animation:true,html:true,title:function(){return _t("Compare Products");},container:'.o_product_feature_panel',placement:'top',template:'<div style="width:600px;" class="popover comparator-popover" role="tooltip"><div class="arrow"></div><h3 class="popover-title"></h3><div class="popover-content"></div></div>',content:function(){return $('#comparelist .o_product_panel_content').html();}});$('.oe_website_sale .o_add_compare, .oe_website_sale .o_add_compare_dyn').click(function(e){if(self.comparelist_product_ids.length<self.product_compare_limit){var prod=$(this).data('product-product-id');if(e.currentTarget.classList.contains('o_add_compare_dyn')){prod=$(this).parent().find('.product_id').val();if(!prod){prod=$(this).parent().find('input:checked').first().val();}
prod=parseInt(prod,10);}
if(!prod){return;}
self.add_new_products(prod);website_sale_utils.animate_clone($('#comparelist .o_product_panel_header'),$(this).closest('form'),-50,10);}else{self.$('.o_comparelist_limit_warning').show();self.show_panel(true);}});$('body').on('click','.comparator-popover .o_comparelist_products .o_remove',function(e){self.rm_from_comparelist(e);});$('body').on('click','.o_comparelist_remove',function(e){self.rm_from_comparelist(e);var new_link='/shop/compare/?products='+self.comparelist_product_ids.toString();window.location=_.isEmpty(self.comparelist_product_ids)?'/shop':new_link;});$("#o_comparelist_table tr").click(function(){$($(this).data('target')).children().slideToggle(100);$(this).find('.fa-chevron-circle-down, .fa-chevron-circle-right').toggleClass('fa-chevron-circle-down fa-chevron-circle-right');});},load_products:function(product_ids){var self=this;return ajax.jsonRpc('/shop/get_product_data','call',{'product_ids':product_ids,'cookies':JSON.parse(utils.get_cookie('comparelist_product_ids')||'[]'),}).then(function(data){self.comparelist_product_ids=JSON.parse(data.cookies);delete data.cookies;_.each(data,function(product){self.product_data[product.product.id]=product;});});},toggle_panel:function(){$('#comparelist .o_product_panel_header').popover('toggle');},show_panel:function(force){if((!$('.comparator-popover').length)||force){$('#comparelist .o_product_panel_header').popover('show');}},refresh_panel:function(){if($('.comparator-popover').length){$('#comparelist .o_product_panel_header').popover('show');}},add_new_products:function(product_id){this.guard.exec(this._add_new_products.bind(this,product_id));},_add_new_products:function(product_id){var self=this;$('.o_product_feature_panel').show();if(!_.contains(self.comparelist_product_ids,product_id)){self.comparelist_product_ids.push(product_id);if(_.has(self.product_data,product_id)){self.update_content([product_id],false);}else{return self.load_products([product_id]).then(function(){self.update_content([product_id],false);self.update_cookie();});}}
self.update_cookie();},update_content:function(product_ids,reset){var self=this;if(reset){self.$('.o_comparelist_products .o_product_row').remove();}
_.each(product_ids,function(res){var $template=self.product_data[res].render;self.$('.o_comparelist_products').append($template);});this.refresh_panel();},rm_from_comparelist:function(e){this.guard.exec(this._rm_from_comparelist.bind(this,e));},_rm_from_comparelist:function(e){this.comparelist_product_ids=_.without(this.comparelist_product_ids,$(e.currentTarget).data('product_product_id'));$(e.currentTarget).parents('.o_product_row').remove();this.update_cookie();$('.o_comparelist_limit_warning').hide();this.update_content(this.comparelist_product_ids,true);},update_cookie:function(){document.cookie='comparelist_product_ids='+JSON.stringify(this.comparelist_product_ids)+'; path=/';this.update_comparelist_view();},update_comparelist_view:function(){this.$('.o_product_circle').text(this.comparelist_product_ids.length);this.$('.o_comparelist_button').hide();if(_.isEmpty(this.comparelist_product_ids)){$('.o_product_feature_panel').hide();this.toggle_panel();}else{this.$('.o_comparelist_products').show();if(this.comparelist_product_ids.length>=2){this.$('.o_comparelist_button').show();this.$('.o_comparelist_button a').attr('href','/shop/compare/?products='+this.comparelist_product_ids.toString());}}}});website.ready().done(function(){new ProductComparison().appendTo('.oe_website_sale');});});;

/* /website_sale_options/static/src/js/website_sale.test.js defined in bundle 'web.assets_frontend' */
odoo.define('website_sale.test',function(require){'use strict';require("website_sale.tour");var tour=require("web_tour.tour");var base=require("web_editor.base");var steps=tour.tours.shop_buy_product.steps;for(var k=0;k<steps.length;k++){if(steps[k].content==="click on add to cart"){steps.splice(k+1,0,{content:"click in modal on 'Proceed to checkout' button",trigger:'a:contains("Proceed to Checkout")',});break;}}
tour.register('shop_customize',{test:true,url:'/shop',wait_for:base.ready()},[{content:"open customize menu",trigger:'#customize-menu > a',},{content:"click on 'Product Attribute's Filters'",trigger:"#customize-menu a:contains(Product Attribute's Filters)",},{content:"select product attribute memory 16 GB",extra_trigger:'body:not(:has(#customize-menu:visible .dropdown-menu:visible))',trigger:'form.js_attributes label:contains(16 GB) input:not(:checked)',},{content:"check the selection",trigger:'form.js_attributes label:contains(16 GB) input:checked',run:function(){},},{content:"select iPad",extra_trigger:'body:not(:has(.oe_website_sale .oe_product_cart:eq(2)))',trigger:'.oe_product_cart a:contains("iPad")',},{content:"open customize menu",trigger:'#customize-menu',extra_trigger:"#product_detail",run:function(){$('body').addClass('notReady');var ajax=odoo.__DEBUG__.services['web.ajax'];var get_group_payload={model:'ir.model.data',method:'xmlid_to_res_id',args:['product.group_product_variant',false],kwargs:{}};ajax.jsonpRpc('/web/dataset/call_kw','call',get_group_payload).then(function(group_id){ajax.jsonpRpc('/web/dataset/call_kw','call',{model:'res.groups',method:'write',args:[group_id,{'users':[[4,1]]}],kwargs:{}}).then(function(){location.reload(true);});});},},{content:"open customize menu",trigger:'#customize-menu > a',extra_trigger:'body:not(.notReady)',},{content:"check page loaded after enable  variant group",trigger:'#customize-menu a:contains(List View of Variants)',run:function(){},},{content:"click on 'List View of Variants'",trigger:"#customize-menu a:contains(List View of Variants)",},{content:"check page loaded after list of variant customization enabled",trigger:'.js_product_change',run:function(){},},{content:"check price is 600 and set quantity to 2",trigger:".js_product:first input.quantity:propValue(1)",extra_trigger:".product_price .oe_price .oe_currency_value:containsExact(600.00)",run:"text 2",},{content:"verify pricelist based on quantity has effect",trigger:".product_price .oe_price .oe_currency_value:containsExact(450.00)",run:function(){},},{content:"check pricelit has been applied and switch to 32 GB variant",trigger:".js_product label:contains('32 GB')",},{content:"verify that price has changed when changing variant",trigger:".product_price .oe_price .oe_currency_value:not(:containsExact(450.00))",run:function(){},},{content:"open customize menu",trigger:'#customize-menu > a',},{content:"remove 'List View of Variants'",trigger:"#customize-menu a:contains(List View of Variants):has(input:checked)",},{content:"check page loaded after list of variant customization disabled",trigger:".js_product:not(:has(.js_product_change))",run:function(){},},{content:"check price is 600 and set quantity to 2",trigger:".js_product:first input.quantity:propValue(1)",extra_trigger:".product_price .oe_price .oe_currency_value:containsExact(600.00)",run:"text 2",},{content:"verify pricelist based on quantity has effect",trigger:".product_price .oe_price .oe_currency_value:containsExact(450.00)",run:function(){},},{content:"switch to 32 GB variant",trigger:".js_product label:contains('32 GB')",},{content:"verify that price has changed when changing variant",trigger:".product_price .oe_price .oe_currency_value:not(:containsExact(450.00))",run:function(){},},{content:"switch back to 16 GB variant",trigger:".js_product label:contains('16 GB')",},{content:"click on 'Add to Cart' button",trigger:"a:contains(Add to Cart)",},{content:"price is lowered by pricelist and not multiplied by quantity",trigger:"#product_confirmation .oe_price .oe_currency_value:containsExact(450.00)",extra_trigger:"#product_confirmation input.quantity:propValue(2)",run:function(){},},{content:"set quantity to 1",trigger:"#product_confirmation .js_add_cart_json .fa-minus",},{content:"check that product page has been updated",trigger:".js_product:first input.quantity:propValue(1)",extra_trigger:".product_price .oe_price .oe_currency_value:containsExact(600.00)",run:function(){},},{content:"check that add to cart modal has been updated",trigger:"#product_confirmation .oe_price .oe_currency_value:containsExact(600.00)",extra_trigger:"#product_confirmation input.quantity:propValue(1)",run:function(){},},{content:"add an optional Warranty",trigger:".js_product:contains(Warranty) a:contains(Add to Cart)",},{content:"click in modal on 'Proceed to checkout' button",extra_trigger:'body:has(.js_product:contains(Warranty) a:contains(Add to Cart):hidden)',trigger:'.modal-dialog a:contains("Proceed to Checkout")',},{content:"check quantity",trigger:'.my_cart_quantity:containsExact(2)',run:function(){},},{content:"check optional product",trigger:'.optional_product',run:function(){},},{content:"remove iPad from cart",trigger:'#cart_products a.js_add_cart_json:first',},{content:"check optional product is removed",trigger:'#wrap:not(:has(.optional_product))',run:function(){},},{content:"click on shop",trigger:"a:contains(Continue Shopping)",extra_trigger:'body:not(:has(#products_grid_before .js_attributes))',},{content:"open customize menu bis",extra_trigger:'#products_grid_before .js_attributes',trigger:'#customize-menu > a',},{content:"remove 'Product Attribute's Filters'",trigger:"#customize-menu a:contains(Product Attribute's Filters):has(input:checked)",},{content:"finish",extra_trigger:'body:not(:has(#products_grid_before .js_attributes))',trigger:'#wrap:not(:has(li:has(.my_cart_quantity):visible))',run:function(){},},]);});;

/* /website_sale_options/static/src/js/website_sale.js defined in bundle 'web.assets_frontend' */
odoo.define('website_sale_options.website_sale',function(require){"use strict";var ajax=require('web.ajax');require('web.dom_ready');var weContext=require("web_editor.context");require('website_sale.website_sale');$('.oe_website_sale #add_to_cart, .oe_website_sale #products_grid .a-submit').off('click').removeClass('a-submit').click(_.debounce(function(event){var $form=$(this).closest('form');var quantity=parseFloat($form.find('input[name="add_qty"]').val()||1);var product_id=parseInt($form.find('input[type="hidden"][name="product_id"], input[type="radio"][name="product_id"]:checked').first().val(),10);event.preventDefault();ajax.jsonRpc("/shop/modal",'call',{'product_id':product_id,'kwargs':{'context':_.extend({'quantity':quantity},weContext.get())},}).then(function(modal){var $modal=$(modal);$modal.find('img:first').attr("src","/web/image/product.product/"+product_id+"/image_medium");$form.addClass('css_options');$modal.appendTo($form).modal().on('hidden.bs.modal',function(){$form.removeClass('css_options');$(this).remove();});$modal.on('click','.a-submit',function(ev){var $a=$(this);$form.ajaxSubmit({url:'/shop/cart/update_option',data:{lang:weContext.get().lang},success:function(quantity){if(!$a.hasClass('js_goto_shop')){window.location.pathname=window.location.pathname.replace(/shop([\/?].*)?$/,"shop/cart");}
var $q=$(".my_cart_quantity");$q.parent().parent().removeClass("hidden",!quantity);$q.html(quantity).hide().fadeIn(600);}});$modal.modal('hide');ev.preventDefault();});$modal.on('click','.css_attribute_color input',function(event){$modal.find('.css_attribute_color').removeClass("active");$modal.find('.css_attribute_color:has(input:checked)').addClass("active");});$modal.on("click","a.js_add, a.js_remove",function(event){event.preventDefault();var $parent=$(this).parents('.js_product:first');$parent.find("a.js_add, span.js_remove").toggleClass("hidden");$parent.find("input.js_optional_same_quantity").val($(this).hasClass("js_add")?1:0);$parent.find(".js_remove");});$modal.on("change","input.js_quantity",function(){var qty=parseFloat($(this).val());if(qty===1){$(".js_remove .js_items").addClass("hidden");$(".js_remove .js_item").removeClass("hidden");}else{$(".js_remove .js_items").removeClass("hidden").text($(".js_remove .js_items:first").text().replace(/[0-9.,]+/,qty));$(".js_remove .js_item").addClass("hidden");}});$modal.find('input[name="add_qty"]').val(quantity).change();$('.js_add_cart_variants').each(function(){$('input.js_variant_change, select.js_variant_change',this).first().trigger('change');});$modal.on("change",'input[name="add_qty"]',function(event){var product_id=$($modal.find('span.oe_price[data-product-id]')).first().data('product-id');var product_ids=[product_id];var $products_dom=[];$("ul.js_add_cart_variants[data-attribute_value_ids]").each(function(){var $el=$(this);$products_dom.push($el);_.each($el.data("attribute_value_ids"),function(values){product_ids.push(values[0]);});});});});return false;},200,true));});;

/* /website_sale_wishlist/static/src/js/website_sale_wishlist.js defined in bundle 'web.assets_frontend' */
odoo.define('website_sale_wishlist.wishlist',function(require){"use strict";require('web.dom_ready');var ajax=require('web.ajax');var Widget=require('web.Widget');var base=require('web_editor.base');var website_sale_utils=require('website_sale.utils');if(!$('.oe_website_sale').length){return $.Deferred().reject("DOM doesn't contain '.oe_website_sale'");}
var ProductWishlist=Widget.extend({events:{'click #my_wish':'display_wishlist',},init:function(){var self=this;this.wishlist_product_ids=[];var wish_loading=$.get('/shop/wishlist',{'count':1}).then(function(res){self.wishlist_product_ids=JSON.parse(res);self.update_wishlist_view();});$('.oe_website_sale .o_add_wishlist, .oe_website_sale .o_add_wishlist_dyn').click(function(e){self.add_new_products($(this),e);});if($('.wishlist-section').length){$('.wishlist-section a.o_wish_rm').on('click',function(e){self.wishlist_rm(e,false);});$('.wishlist-section a.o_wish_add').on('click',function(e){$('.wishlist-section a.o_wish_add').addClass('disabled');self.wishlist_add_or_mv(e).then(function(o){$('.wishlist-section a.o_wish_add').removeClass('disabled');});});}
$('.oe_website_sale').on('change','input.js_variant_change, select.js_variant_change, ul[data-attribute_value_ids]',function(ev){var $ul=$(ev.target).closest('.js_add_cart_variants');var $parent=$ul.closest('.js_product');var $product_id=$parent.find('.product_id').first();var $el=$parent.find("[data-action='o_wishlist']");if(!_.contains(self.wishlist_product_ids,parseInt($product_id.val(),10))){$el.prop("disabled",false).removeClass('disabled').removeAttr('disabled');}
else{$el.prop("disabled",true).addClass('disabled').attr('disabled','disabled');}
$el.data('product-product-id',parseInt($product_id.val(),10));});$('.oe_website_sale').on('change','input.js_product_change',function(ev){var product_id=ev.currentTarget.value;var $el=$(ev.target).closest('.js_add_cart_variants').find("[data-action='o_wishlist']");if(!_.contains(self.wishlist_product_ids,parseInt(product_id,10))){$el.prop("disabled",false).removeClass('disabled').removeAttr('disabled');}
else{$el.prop("disabled",true).addClass('disabled').attr('disabled','disabled');}
$el.data('product-product-id',product_id);});wish_loading.then(function(){if($('input.js_product_change').length){$('input.js_product_change:checked').first().trigger('change');}
else{$('input.js_variant_change:checked').first().trigger('change');}});},add_new_products:function($el,e){var self=this;var product_id=parseInt($el.data('product-product-id'),10);if(!product_id&&e.currentTarget.classList.contains('o_add_wishlist_dyn')){product_id=parseInt($el.parent().find('.product_id').val());}
if(product_id&&!_.contains(self.wishlist_product_ids,product_id)){return ajax.jsonRpc('/shop/wishlist/add','call',{'product_id':product_id}).then(function(){self.wishlist_product_ids.push(product_id);self.update_wishlist_view();website_sale_utils.animate_clone($('#my_wish'),$el.closest('form'),25,40);$el.prop("disabled",true).addClass('disabled');});}},display_wishlist:function(){if(this.wishlist_product_ids.length===0){this.update_wishlist_view();this.redirect_no_wish();}
else{window.location='/shop/wishlist';}},update_wishlist_view:function(){if(this.wishlist_product_ids.length>0){$('#my_wish').show();$('.my_wish_quantity').text(this.wishlist_product_ids.length);}
else{$('#my_wish').hide();}},wishlist_rm:function(e,deferred_redirect){var tr=$(e.currentTarget).parents('tr');var wish=tr.data('wish-id');var product=tr.data('product-id');var self=this;ajax.jsonRpc('/shop/wishlist/remove/'+wish).done(function(){$(tr).hide();});this.wishlist_product_ids=_.without(this.wishlist_product_ids,product);if(this.wishlist_product_ids.length===0){deferred_redirect=deferred_redirect?deferred_redirect:$.Deferred();deferred_redirect.then(function(){self.redirect_no_wish();});}
this.update_wishlist_view();},wishlist_add_or_mv:function(e){return $('#b2b_wish').is(':checked')?this.wishlist_add(e):this.wishlist_mv(e);},wishlist_add:function(e){var tr=$(e.currentTarget).parents('tr');var product=tr.data('product-id');$('#my_cart').removeClass('hidden');website_sale_utils.animate_clone($('#my_cart'),tr,25,40);return this.add_to_cart(product,tr.find('input[name="add_qty"]').val()||1);},wishlist_mv:function(e){var tr=$(e.currentTarget).parents('tr');var product=tr.data('product-id');$('#my_cart').removeClass('hidden');website_sale_utils.animate_clone($('#my_cart'),tr,25,40);var adding_deffered=this.add_to_cart(product,tr.find('input[name="add_qty"]').val()||1);this.wishlist_rm(e,adding_deffered);return adding_deffered;},add_to_cart:function(product_id,qty_id){var add_to_cart=ajax.jsonRpc("/shop/cart/update_json",'call',{'product_id':parseInt(product_id,10),'add_qty':parseInt(qty_id,10),'display':false,});add_to_cart.then(function(resp){if(resp.warning){if(!$('#data_warning').length){$('.wishlist-section').prepend('<div class="mt16 alert alert-danger alert-dismissable" role="alert" id="data_warning"></div>');}
var cart_alert=$('.wishlist-section').parent().find('#data_warning');cart_alert.html('<button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button> '+resp.warning);}
$('.my_cart_quantity').html(resp.cart_quantity||'<i class="fa fa-warning" /> ');});return add_to_cart;},redirect_no_wish:function(){window.location='/shop/cart';}});new ProductWishlist();});;

/* /website_links/static/lib/zeroclipboard/ZeroClipboard.js defined in bundle 'web.assets_frontend' */
(function(window,undefined){"use strict";var _window=window,_document=_window.document,_navigator=_window.navigator,_setTimeout=_window.setTimeout,_encodeURIComponent=_window.encodeURIComponent,_ActiveXObject=_window.ActiveXObject,_Error=_window.Error,_parseInt=_window.Number.parseInt||_window.parseInt,_parseFloat=_window.Number.parseFloat||_window.parseFloat,_isNaN=_window.Number.isNaN||_window.isNaN,_round=_window.Math.round,_now=_window.Date.now,_keys=_window.Object.keys,_defineProperty=_window.Object.defineProperty,_hasOwn=_window.Object.prototype.hasOwnProperty,_slice=_window.Array.prototype.slice,_unwrap=function(){var unwrapper=function(el){return el;};if(typeof _window.wrap==="function"&&typeof _window.unwrap==="function"){try{var div=_document.createElement("div");var unwrappedDiv=_window.unwrap(div);if(div.nodeType===1&&unwrappedDiv&&unwrappedDiv.nodeType===1){unwrapper=_window.unwrap;}}catch(e){}}
return unwrapper;}();var _args=function(argumentsObj){return _slice.call(argumentsObj,0);};var _extend=function(){var i,len,arg,prop,src,copy,args=_args(arguments),target=args[0]||{};for(i=1,len=args.length;i<len;i++){if((arg=args[i])!=null){for(prop in arg){if(_hasOwn.call(arg,prop)){src=target[prop];copy=arg[prop];if(target!==copy&&copy!==undefined){target[prop]=copy;}}}}}
return target;};var _deepCopy=function(source){var copy,i,len,prop;if(typeof source!=="object"||source==null){copy=source;}else if(typeof source.length==="number"){copy=[];for(i=0,len=source.length;i<len;i++){if(_hasOwn.call(source,i)){copy[i]=_deepCopy(source[i]);}}}else{copy={};for(prop in source){if(_hasOwn.call(source,prop)){copy[prop]=_deepCopy(source[prop]);}}}
return copy;};var _pick=function(obj,keys){var newObj={};for(var i=0,len=keys.length;i<len;i++){if(keys[i]in obj){newObj[keys[i]]=obj[keys[i]];}}
return newObj;};var _omit=function(obj,keys){var newObj={};for(var prop in obj){if(keys.indexOf(prop)===-1){newObj[prop]=obj[prop];}}
return newObj;};var _deleteOwnProperties=function(obj){if(obj){for(var prop in obj){if(_hasOwn.call(obj,prop)){delete obj[prop];}}}
return obj;};var _containedBy=function(el,ancestorEl){if(el&&el.nodeType===1&&el.ownerDocument&&ancestorEl&&(ancestorEl.nodeType===1&&ancestorEl.ownerDocument&&ancestorEl.ownerDocument===el.ownerDocument||ancestorEl.nodeType===9&&!ancestorEl.ownerDocument&&ancestorEl===el.ownerDocument)){do{if(el===ancestorEl){return true;}
el=el.parentNode;}while(el);}
return false;};var _getDirPathOfUrl=function(url){var dir;if(typeof url==="string"&&url){dir=url.split("#")[0].split("?")[0];dir=url.slice(0,url.lastIndexOf("/")+1);}
return dir;};var _getCurrentScriptUrlFromErrorStack=function(stack){var url,matches;if(typeof stack==="string"&&stack){matches=stack.match(/^(?:|[^:@]*@|.+\)@(?=http[s]?|file)|.+?\s+(?: at |@)(?:[^:\(]+ )*[\(]?)((?:http[s]?|file):\/\/[\/]?.+?\/[^:\)]*?)(?::\d+)(?::\d+)?/);if(matches&&matches[1]){url=matches[1];}else{matches=stack.match(/\)@((?:http[s]?|file):\/\/[\/]?.+?\/[^:\)]*?)(?::\d+)(?::\d+)?/);if(matches&&matches[1]){url=matches[1];}}}
return url;};var _getCurrentScriptUrlFromError=function(){var url,err;try{throw new _Error();}catch(e){err=e;}
if(err){url=err.sourceURL||err.fileName||_getCurrentScriptUrlFromErrorStack(err.stack);}
return url;};var _getCurrentScriptUrl=function(){var jsPath,scripts,i;if(_document.currentScript&&(jsPath=_document.currentScript.src)){return jsPath;}
scripts=_document.getElementsByTagName("script");if(scripts.length===1){return scripts[0].src||undefined;}
if("readyState"in scripts[0]){for(i=scripts.length;i--;){if(scripts[i].readyState==="interactive"&&(jsPath=scripts[i].src)){return jsPath;}}}
if(_document.readyState==="loading"&&(jsPath=scripts[scripts.length-1].src)){return jsPath;}
if(jsPath=_getCurrentScriptUrlFromError()){return jsPath;}
return undefined;};var _getUnanimousScriptParentDir=function(){var i,jsDir,jsPath,scripts=_document.getElementsByTagName("script");for(i=scripts.length;i--;){if(!(jsPath=scripts[i].src)){jsDir=null;break;}
jsPath=_getDirPathOfUrl(jsPath);if(jsDir==null){jsDir=jsPath;}else if(jsDir!==jsPath){jsDir=null;break;}}
return jsDir||undefined;};var _getDefaultSwfPath=function(){var jsDir=_getDirPathOfUrl(_getCurrentScriptUrl())||_getUnanimousScriptParentDir()||"";return jsDir+"ZeroClipboard.swf";};var _flashState={bridge:null,version:"0.0.0",pluginType:"unknown",disabled:null,outdated:null,unavailable:null,deactivated:null,overdue:null,ready:null};var _minimumFlashVersion="11.0.0";var _handlers={};var _currentElement;var _copyTarget;var _clipData={};var _clipDataFormatMap=null;var _eventMessages={ready:"Flash communication is established",error:{"flash-disabled":"Flash is disabled or not installed","flash-outdated":"Flash is too outdated to support ZeroClipboard","flash-unavailable":"Flash is unable to communicate bidirectionally with JavaScript","flash-deactivated":"Flash is too outdated for your browser and/or is configured as click-to-activate","flash-overdue":"Flash communication was established but NOT within the acceptable time limit"}};var _globalConfig={swfPath:_getDefaultSwfPath(),trustedDomains:window.location.host?[window.location.host]:[],cacheBust:true,forceEnhancedClipboard:false,flashLoadTimeout:3e4,autoActivate:true,bubbleEvents:true,containerId:"global-zeroclipboard-html-bridge",containerClass:"global-zeroclipboard-container",swfObjectId:"global-zeroclipboard-flash-bridge",hoverClass:"zeroclipboard-is-hover",activeClass:"zeroclipboard-is-active",forceHandCursor:false,title:null,zIndex:999999999};var _config=function(options){if(typeof options==="object"&&options!==null){for(var prop in options){if(_hasOwn.call(options,prop)){if(/^(?:forceHandCursor|title|zIndex|bubbleEvents)$/.test(prop)){_globalConfig[prop]=options[prop];}else if(_flashState.bridge==null){if(prop==="containerId"||prop==="swfObjectId"){if(_isValidHtml4Id(options[prop])){_globalConfig[prop]=options[prop];}else{throw new Error("The specified `"+prop+"` value is not valid as an HTML4 Element ID");}}else{_globalConfig[prop]=options[prop];}}}}}
if(typeof options==="string"&&options){if(_hasOwn.call(_globalConfig,options)){return _globalConfig[options];}
return;}
return _deepCopy(_globalConfig);};var _state=function(){return{browser:_pick(_navigator,["userAgent","platform","appName"]),flash:_omit(_flashState,["bridge"]),zeroclipboard:{version:ZeroClipboard.version,config:ZeroClipboard.config()}};};var _isFlashUnusable=function(){return!!(_flashState.disabled||_flashState.outdated||_flashState.unavailable||_flashState.deactivated);};var _on=function(eventType,listener){var i,len,events,added={};if(typeof eventType==="string"&&eventType){events=eventType.toLowerCase().split(/\s+/);}else if(typeof eventType==="object"&&eventType&&typeof listener==="undefined"){for(i in eventType){if(_hasOwn.call(eventType,i)&&typeof i==="string"&&i&&typeof eventType[i]==="function"){ZeroClipboard.on(i,eventType[i]);}}}
if(events&&events.length){for(i=0,len=events.length;i<len;i++){eventType=events[i].replace(/^on/,"");added[eventType]=true;if(!_handlers[eventType]){_handlers[eventType]=[];}
_handlers[eventType].push(listener);}
if(added.ready&&_flashState.ready){ZeroClipboard.emit({type:"ready"});}
if(added.error){var errorTypes=["disabled","outdated","unavailable","deactivated","overdue"];for(i=0,len=errorTypes.length;i<len;i++){if(_flashState[errorTypes[i]]===true){ZeroClipboard.emit({type:"error",name:"flash-"+errorTypes[i]});break;}}}}
return ZeroClipboard;};var _off=function(eventType,listener){var i,len,foundIndex,events,perEventHandlers;if(arguments.length===0){events=_keys(_handlers);}else if(typeof eventType==="string"&&eventType){events=eventType.split(/\s+/);}else if(typeof eventType==="object"&&eventType&&typeof listener==="undefined"){for(i in eventType){if(_hasOwn.call(eventType,i)&&typeof i==="string"&&i&&typeof eventType[i]==="function"){ZeroClipboard.off(i,eventType[i]);}}}
if(events&&events.length){for(i=0,len=events.length;i<len;i++){eventType=events[i].toLowerCase().replace(/^on/,"");perEventHandlers=_handlers[eventType];if(perEventHandlers&&perEventHandlers.length){if(listener){foundIndex=perEventHandlers.indexOf(listener);while(foundIndex!==-1){perEventHandlers.splice(foundIndex,1);foundIndex=perEventHandlers.indexOf(listener,foundIndex);}}else{perEventHandlers.length=0;}}}}
return ZeroClipboard;};var _listeners=function(eventType){var copy;if(typeof eventType==="string"&&eventType){copy=_deepCopy(_handlers[eventType])||null;}else{copy=_deepCopy(_handlers);}
return copy;};var _emit=function(event){var eventCopy,returnVal,tmp;event=_createEvent(event);if(!event){return;}
if(_preprocessEvent(event)){return;}
if(event.type==="ready"&&_flashState.overdue===true){return ZeroClipboard.emit({type:"error",name:"flash-overdue"});}
eventCopy=_extend({},event);_dispatchCallbacks.call(this,eventCopy);if(event.type==="copy"){tmp=_mapClipDataToFlash(_clipData);returnVal=tmp.data;_clipDataFormatMap=tmp.formatMap;}
return returnVal;};var _create=function(){if(typeof _flashState.ready!=="boolean"){_flashState.ready=false;}
if(!ZeroClipboard.isFlashUnusable()&&_flashState.bridge===null){var maxWait=_globalConfig.flashLoadTimeout;if(typeof maxWait==="number"&&maxWait>=0){_setTimeout(function(){if(typeof _flashState.deactivated!=="boolean"){_flashState.deactivated=true;}
if(_flashState.deactivated===true){ZeroClipboard.emit({type:"error",name:"flash-deactivated"});}},maxWait);}
_flashState.overdue=false;_embedSwf();}};var _destroy=function(){ZeroClipboard.clearData();ZeroClipboard.blur();ZeroClipboard.emit("destroy");_unembedSwf();ZeroClipboard.off();};var _setData=function(format,data){var dataObj;if(typeof format==="object"&&format&&typeof data==="undefined"){dataObj=format;ZeroClipboard.clearData();}else if(typeof format==="string"&&format){dataObj={};dataObj[format]=data;}else{return;}
for(var dataFormat in dataObj){if(typeof dataFormat==="string"&&dataFormat&&_hasOwn.call(dataObj,dataFormat)&&typeof dataObj[dataFormat]==="string"&&dataObj[dataFormat]){_clipData[dataFormat]=dataObj[dataFormat];}}};var _clearData=function(format){if(typeof format==="undefined"){_deleteOwnProperties(_clipData);_clipDataFormatMap=null;}else if(typeof format==="string"&&_hasOwn.call(_clipData,format)){delete _clipData[format];}};var _getData=function(format){if(typeof format==="undefined"){return _deepCopy(_clipData);}else if(typeof format==="string"&&_hasOwn.call(_clipData,format)){return _clipData[format];}};var _focus=function(element){if(!(element&&element.nodeType===1)){return;}
if(_currentElement){_removeClass(_currentElement,_globalConfig.activeClass);if(_currentElement!==element){_removeClass(_currentElement,_globalConfig.hoverClass);}}
_currentElement=element;_addClass(element,_globalConfig.hoverClass);var newTitle=element.getAttribute("title")||_globalConfig.title;if(typeof newTitle==="string"&&newTitle){var htmlBridge=_getHtmlBridge(_flashState.bridge);if(htmlBridge){htmlBridge.setAttribute("title",newTitle);}}
var useHandCursor=_globalConfig.forceHandCursor===true||_getStyle(element,"cursor")==="pointer";_setHandCursor(useHandCursor);_reposition();};var _blur=function(){var htmlBridge=_getHtmlBridge(_flashState.bridge);if(htmlBridge){htmlBridge.removeAttribute("title");htmlBridge.style.left="0px";htmlBridge.style.top="-9999px";htmlBridge.style.width="1px";htmlBridge.style.top="1px";}
if(_currentElement){_removeClass(_currentElement,_globalConfig.hoverClass);_removeClass(_currentElement,_globalConfig.activeClass);_currentElement=null;}};var _activeElement=function(){return _currentElement||null;};var _isValidHtml4Id=function(id){return typeof id==="string"&&id&&/^[A-Za-z][A-Za-z0-9_:\-\.]*$/.test(id);};var _createEvent=function(event){var eventType;if(typeof event==="string"&&event){eventType=event;event={};}else if(typeof event==="object"&&event&&typeof event.type==="string"&&event.type){eventType=event.type;}
if(!eventType){return;}
if(!event.target&&/^(copy|aftercopy|_click)$/.test(eventType.toLowerCase())){event.target=_copyTarget;}
_extend(event,{type:eventType.toLowerCase(),target:event.target||_currentElement||null,relatedTarget:event.relatedTarget||null,currentTarget:_flashState&&_flashState.bridge||null,timeStamp:event.timeStamp||_now()||null});var msg=_eventMessages[event.type];if(event.type==="error"&&event.name&&msg){msg=msg[event.name];}
if(msg){event.message=msg;}
if(event.type==="ready"){_extend(event,{target:null,version:_flashState.version});}
if(event.type==="error"){if(/^flash-(disabled|outdated|unavailable|deactivated|overdue)$/.test(event.name)){_extend(event,{target:null,minimumVersion:_minimumFlashVersion});}
if(/^flash-(outdated|unavailable|deactivated|overdue)$/.test(event.name)){_extend(event,{version:_flashState.version});}}
if(event.type==="copy"){event.clipboardData={setData:ZeroClipboard.setData,clearData:ZeroClipboard.clearData};}
if(event.type==="aftercopy"){event=_mapClipResultsFromFlash(event,_clipDataFormatMap);}
if(event.target&&!event.relatedTarget){event.relatedTarget=_getRelatedTarget(event.target);}
event=_addMouseData(event);return event;};var _getRelatedTarget=function(targetEl){var relatedTargetId=targetEl&&targetEl.getAttribute&&targetEl.getAttribute("data-clipboard-target");return relatedTargetId?_document.getElementById(relatedTargetId):null;};var _addMouseData=function(event){if(event&&/^_(?:click|mouse(?:over|out|down|up|move))$/.test(event.type)){var srcElement=event.target;var fromElement=event.type==="_mouseover"&&event.relatedTarget?event.relatedTarget:undefined;var toElement=event.type==="_mouseout"&&event.relatedTarget?event.relatedTarget:undefined;var pos=_getDOMObjectPosition(srcElement);var screenLeft=_window.screenLeft||_window.screenX||0;var screenTop=_window.screenTop||_window.screenY||0;var scrollLeft=_document.body.scrollLeft+_document.documentElement.scrollLeft;var scrollTop=_document.body.scrollTop+_document.documentElement.scrollTop;var pageX=pos.left+(typeof event._stageX==="number"?event._stageX:0);var pageY=pos.top+(typeof event._stageY==="number"?event._stageY:0);var clientX=pageX-scrollLeft;var clientY=pageY-scrollTop;var screenX=screenLeft+clientX;var screenY=screenTop+clientY;var moveX=typeof event.movementX==="number"?event.movementX:0;var moveY=typeof event.movementY==="number"?event.movementY:0;delete event._stageX;delete event._stageY;_extend(event,{srcElement:srcElement,fromElement:fromElement,toElement:toElement,screenX:screenX,screenY:screenY,pageX:pageX,pageY:pageY,clientX:clientX,clientY:clientY,x:clientX,y:clientY,movementX:moveX,movementY:moveY,offsetX:0,offsetY:0,layerX:0,layerY:0});}
return event;};var _shouldPerformAsync=function(event){var eventType=event&&typeof event.type==="string"&&event.type||"";return!/^(?:(?:before)?copy|destroy)$/.test(eventType);};var _dispatchCallback=function(func,context,args,async){if(async){_setTimeout(function(){func.apply(context,args);},0);}else{func.apply(context,args);}};var _dispatchCallbacks=function(event){if(!(typeof event==="object"&&event&&event.type)){return;}
var async=_shouldPerformAsync(event);var wildcardTypeHandlers=_handlers["*"]||[];var specificTypeHandlers=_handlers[event.type]||[];var handlers=wildcardTypeHandlers.concat(specificTypeHandlers);if(handlers&&handlers.length){var i,len,func,context,eventCopy,originalContext=this;for(i=0,len=handlers.length;i<len;i++){func=handlers[i];context=originalContext;if(typeof func==="string"&&typeof _window[func]==="function"){func=_window[func];}
if(typeof func==="object"&&func&&typeof func.handleEvent==="function"){context=func;func=func.handleEvent;}
if(typeof func==="function"){eventCopy=_extend({},event);_dispatchCallback(func,context,[eventCopy],async);}}}
return this;};var _preprocessEvent=function(event){var element=event.target||_currentElement||null;var sourceIsSwf=event._source==="swf";delete event._source;var flashErrorNames=["flash-disabled","flash-outdated","flash-unavailable","flash-deactivated","flash-overdue"];switch(event.type){case"error":if(flashErrorNames.indexOf(event.name)!==-1){_extend(_flashState,{disabled:event.name==="flash-disabled",outdated:event.name==="flash-outdated",unavailable:event.name==="flash-unavailable",deactivated:event.name==="flash-deactivated",overdue:event.name==="flash-overdue",ready:false});}
break;case"ready":var wasDeactivated=_flashState.deactivated===true;_extend(_flashState,{disabled:false,outdated:false,unavailable:false,deactivated:false,overdue:wasDeactivated,ready:!wasDeactivated});break;case"beforecopy":_copyTarget=element;break;case"copy":var textContent,htmlContent,targetEl=event.relatedTarget;if(!(_clipData["text/html"]||_clipData["text/plain"])&&targetEl&&(htmlContent=targetEl.value||targetEl.outerHTML||targetEl.innerHTML)&&(textContent=targetEl.value||targetEl.textContent||targetEl.innerText)){event.clipboardData.clearData();event.clipboardData.setData("text/plain",textContent);if(htmlContent!==textContent){event.clipboardData.setData("text/html",htmlContent);}}else if(!_clipData["text/plain"]&&event.target&&(textContent=event.target.getAttribute("data-clipboard-text"))){event.clipboardData.clearData();event.clipboardData.setData("text/plain",textContent);}
break;case"aftercopy":ZeroClipboard.clearData();if(element&&element!==_safeActiveElement()&&element.focus){element.focus();}
break;case"_mouseover":ZeroClipboard.focus(element);if(_globalConfig.bubbleEvents===true&&sourceIsSwf){if(element&&element!==event.relatedTarget&&!_containedBy(event.relatedTarget,element)){_fireMouseEvent(_extend({},event,{type:"mouseenter",bubbles:false,cancelable:false}));}
_fireMouseEvent(_extend({},event,{type:"mouseover"}));}
break;case"_mouseout":ZeroClipboard.blur();if(_globalConfig.bubbleEvents===true&&sourceIsSwf){if(element&&element!==event.relatedTarget&&!_containedBy(event.relatedTarget,element)){_fireMouseEvent(_extend({},event,{type:"mouseleave",bubbles:false,cancelable:false}));}
_fireMouseEvent(_extend({},event,{type:"mouseout"}));}
break;case"_mousedown":_addClass(element,_globalConfig.activeClass);if(_globalConfig.bubbleEvents===true&&sourceIsSwf){_fireMouseEvent(_extend({},event,{type:event.type.slice(1)}));}
break;case"_mouseup":_removeClass(element,_globalConfig.activeClass);if(_globalConfig.bubbleEvents===true&&sourceIsSwf){_fireMouseEvent(_extend({},event,{type:event.type.slice(1)}));}
break;case"_click":_copyTarget=null;if(_globalConfig.bubbleEvents===true&&sourceIsSwf){_fireMouseEvent(_extend({},event,{type:event.type.slice(1)}));}
break;case"_mousemove":if(_globalConfig.bubbleEvents===true&&sourceIsSwf){_fireMouseEvent(_extend({},event,{type:event.type.slice(1)}));}
break;}
if(/^_(?:click|mouse(?:over|out|down|up|move))$/.test(event.type)){return true;}};var _fireMouseEvent=function(event){if(!(event&&typeof event.type==="string"&&event)){return;}
var e,target=event.target||null,doc=target&&target.ownerDocument||_document,defaults={view:doc.defaultView||_window,canBubble:true,cancelable:true,detail:event.type==="click"?1:0,button:typeof event.which==="number"?event.which-1:typeof event.button==="number"?event.button:doc.createEvent?0:1},args=_extend(defaults,event);if(!target){return;}
if(doc.createEvent&&target.dispatchEvent){args=[args.type,args.canBubble,args.cancelable,args.view,args.detail,args.screenX,args.screenY,args.clientX,args.clientY,args.ctrlKey,args.altKey,args.shiftKey,args.metaKey,args.button,args.relatedTarget];e=doc.createEvent("MouseEvents");if(e.initMouseEvent){e.initMouseEvent.apply(e,args);e._source="js";target.dispatchEvent(e);}}};var _createHtmlBridge=function(){var container=_document.createElement("div");container.id=_globalConfig.containerId;container.className=_globalConfig.containerClass;container.style.position="absolute";container.style.left="0px";container.style.top="-9999px";container.style.width="1px";container.style.height="1px";container.style.zIndex=""+_getSafeZIndex(_globalConfig.zIndex);return container;};var _getHtmlBridge=function(flashBridge){var htmlBridge=flashBridge&&flashBridge.parentNode;while(htmlBridge&&htmlBridge.nodeName==="OBJECT"&&htmlBridge.parentNode){htmlBridge=htmlBridge.parentNode;}
return htmlBridge||null;};var _embedSwf=function(){var len,flashBridge=_flashState.bridge,container=_getHtmlBridge(flashBridge);if(!flashBridge){var allowScriptAccess=_determineScriptAccess(_window.location.host,_globalConfig);var allowNetworking=allowScriptAccess==="never"?"none":"all";var flashvars=_vars(_globalConfig);var swfUrl=_globalConfig.swfPath+_cacheBust(_globalConfig.swfPath,_globalConfig);container=_createHtmlBridge();var divToBeReplaced=_document.createElement("div");container.appendChild(divToBeReplaced);_document.body.appendChild(container);var tmpDiv=_document.createElement("div");var oldIE=_flashState.pluginType==="activex";tmpDiv.innerHTML='<object id="'+_globalConfig.swfObjectId+'" name="'+_globalConfig.swfObjectId+'" '+'width="100%" height="100%" '+(oldIE?'classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000"':'type="application/x-shockwave-flash" data="'+swfUrl+'"')+">"+(oldIE?'<param name="movie" value="'+swfUrl+'"/>':"")+'<param name="allowScriptAccess" value="'+allowScriptAccess+'"/>'+'<param name="allowNetworking" value="'+allowNetworking+'"/>'+'<param name="menu" value="false"/>'+'<param name="wmode" value="transparent"/>'+'<param name="flashvars" value="'+flashvars+'"/>'+"</object>";flashBridge=tmpDiv.firstChild;tmpDiv=null;_unwrap(flashBridge).ZeroClipboard=ZeroClipboard;container.replaceChild(flashBridge,divToBeReplaced);}
if(!flashBridge){flashBridge=_document[_globalConfig.swfObjectId];if(flashBridge&&(len=flashBridge.length)){flashBridge=flashBridge[len-1];}
if(!flashBridge&&container){flashBridge=container.firstChild;}}
_flashState.bridge=flashBridge||null;return flashBridge;};var _unembedSwf=function(){var flashBridge=_flashState.bridge;if(flashBridge){var htmlBridge=_getHtmlBridge(flashBridge);if(htmlBridge){if(_flashState.pluginType==="activex"&&"readyState"in flashBridge){flashBridge.style.display="none";(function removeSwfFromIE(){if(flashBridge.readyState===4){for(var prop in flashBridge){if(typeof flashBridge[prop]==="function"){flashBridge[prop]=null;}}
if(flashBridge.parentNode){flashBridge.parentNode.removeChild(flashBridge);}
if(htmlBridge.parentNode){htmlBridge.parentNode.removeChild(htmlBridge);}}else{_setTimeout(removeSwfFromIE,10);}})();}else{if(flashBridge.parentNode){flashBridge.parentNode.removeChild(flashBridge);}
if(htmlBridge.parentNode){htmlBridge.parentNode.removeChild(htmlBridge);}}}
_flashState.ready=null;_flashState.bridge=null;_flashState.deactivated=null;}};var _mapClipDataToFlash=function(clipData){var newClipData={},formatMap={};if(!(typeof clipData==="object"&&clipData)){return;}
for(var dataFormat in clipData){if(dataFormat&&_hasOwn.call(clipData,dataFormat)&&typeof clipData[dataFormat]==="string"&&clipData[dataFormat]){switch(dataFormat.toLowerCase()){case"text/plain":case"text":case"air:text":case"flash:text":newClipData.text=clipData[dataFormat];formatMap.text=dataFormat;break;case"text/html":case"html":case"air:html":case"flash:html":newClipData.html=clipData[dataFormat];formatMap.html=dataFormat;break;case"application/rtf":case"text/rtf":case"rtf":case"richtext":case"air:rtf":case"flash:rtf":newClipData.rtf=clipData[dataFormat];formatMap.rtf=dataFormat;break;default:break;}}}
return{data:newClipData,formatMap:formatMap};};var _mapClipResultsFromFlash=function(clipResults,formatMap){if(!(typeof clipResults==="object"&&clipResults&&typeof formatMap==="object"&&formatMap)){return clipResults;}
var newResults={};for(var prop in clipResults){if(_hasOwn.call(clipResults,prop)){if(prop!=="success"&&prop!=="data"){newResults[prop]=clipResults[prop];continue;}
newResults[prop]={};var tmpHash=clipResults[prop];for(var dataFormat in tmpHash){if(dataFormat&&_hasOwn.call(tmpHash,dataFormat)&&_hasOwn.call(formatMap,dataFormat)){newResults[prop][formatMap[dataFormat]]=tmpHash[dataFormat];}}}}
return newResults;};var _cacheBust=function(path,options){var cacheBust=options==null||options&&options.cacheBust===true;if(cacheBust){return(path.indexOf("?")===-1?"?":"&")+"noCache="+_now();}else{return"";}};var _vars=function(options){var i,len,domain,domains,str="",trustedOriginsExpanded=[];if(options.trustedDomains){if(typeof options.trustedDomains==="string"){domains=[options.trustedDomains];}else if(typeof options.trustedDomains==="object"&&"length"in options.trustedDomains){domains=options.trustedDomains;}}
if(domains&&domains.length){for(i=0,len=domains.length;i<len;i++){if(_hasOwn.call(domains,i)&&domains[i]&&typeof domains[i]==="string"){domain=_extractDomain(domains[i]);if(!domain){continue;}
if(domain==="*"){trustedOriginsExpanded.length=0;trustedOriginsExpanded.push(domain);break;}
trustedOriginsExpanded.push.apply(trustedOriginsExpanded,[domain,"//"+domain,_window.location.protocol+"//"+domain]);}}}
if(trustedOriginsExpanded.length){str+="trustedOrigins="+_encodeURIComponent(trustedOriginsExpanded.join(","));}
if(options.forceEnhancedClipboard===true){str+=(str?"&":"")+"forceEnhancedClipboard=true";}
if(typeof options.swfObjectId==="string"&&options.swfObjectId){str+=(str?"&":"")+"swfObjectId="+_encodeURIComponent(options.swfObjectId);}
return str;};var _extractDomain=function(originOrUrl){if(originOrUrl==null||originOrUrl===""){return null;}
originOrUrl=originOrUrl.replace(/^\s+|\s+$/g,"");if(originOrUrl===""){return null;}
var protocolIndex=originOrUrl.indexOf("//");originOrUrl=protocolIndex===-1?originOrUrl:originOrUrl.slice(protocolIndex+2);var pathIndex=originOrUrl.indexOf("/");originOrUrl=pathIndex===-1?originOrUrl:protocolIndex===-1||pathIndex===0?null:originOrUrl.slice(0,pathIndex);if(originOrUrl&&originOrUrl.slice(-4).toLowerCase()===".swf"){return null;}
return originOrUrl||null;};var _determineScriptAccess=function(){var _extractAllDomains=function(origins){var i,len,tmp,resultsArray=[];if(typeof origins==="string"){origins=[origins];}
if(!(typeof origins==="object"&&origins&&typeof origins.length==="number")){return resultsArray;}
for(i=0,len=origins.length;i<len;i++){if(_hasOwn.call(origins,i)&&(tmp=_extractDomain(origins[i]))){if(tmp==="*"){resultsArray.length=0;resultsArray.push("*");break;}
if(resultsArray.indexOf(tmp)===-1){resultsArray.push(tmp);}}}
return resultsArray;};return function(currentDomain,configOptions){var swfDomain=_extractDomain(configOptions.swfPath);if(swfDomain===null){swfDomain=currentDomain;}
var trustedDomains=_extractAllDomains(configOptions.trustedDomains);var len=trustedDomains.length;if(len>0){if(len===1&&trustedDomains[0]==="*"){return"always";}
if(trustedDomains.indexOf(currentDomain)!==-1){if(len===1&&currentDomain===swfDomain){return"sameDomain";}
return"always";}}
return"never";};}();var _safeActiveElement=function(){try{return _document.activeElement;}catch(err){return null;}};var _addClass=function(element,value){if(!element||element.nodeType!==1){return element;}
if(element.classList){if(!element.classList.contains(value)){element.classList.add(value);}
return element;}
if(value&&typeof value==="string"){var classNames=(value||"").split(/\s+/);if(element.nodeType===1){if(!element.className){element.className=value;}else{var className=" "+element.className+" ",setClass=element.className;for(var c=0,cl=classNames.length;c<cl;c++){if(className.indexOf(" "+classNames[c]+" ")<0){setClass+=" "+classNames[c];}}
element.className=setClass.replace(/^\s+|\s+$/g,"");}}}
return element;};var _removeClass=function(element,value){if(!element||element.nodeType!==1){return element;}
if(element.classList){if(element.classList.contains(value)){element.classList.remove(value);}
return element;}
if(typeof value==="string"&&value){var classNames=value.split(/\s+/);if(element.nodeType===1&&element.className){var className=(" "+element.className+" ").replace(/[\n\t]/g," ");for(var c=0,cl=classNames.length;c<cl;c++){className=className.replace(" "+classNames[c]+" "," ");}
element.className=className.replace(/^\s+|\s+$/g,"");}}
return element;};var _getStyle=function(el,prop){var value=_window.getComputedStyle(el,null).getPropertyValue(prop);if(prop==="cursor"){if(!value||value==="auto"){if(el.nodeName==="A"){return"pointer";}}}
return value;};var _getZoomFactor=function(){var rect,physicalWidth,logicalWidth,zoomFactor=1;if(typeof _document.body.getBoundingClientRect==="function"){rect=_document.body.getBoundingClientRect();physicalWidth=rect.right-rect.left;logicalWidth=_document.body.offsetWidth;zoomFactor=_round(physicalWidth/logicalWidth*100)/100;}
return zoomFactor;};var _getDOMObjectPosition=function(obj){var info={left:0,top:0,width:0,height:0};if(obj.getBoundingClientRect){var rect=obj.getBoundingClientRect();var pageXOffset,pageYOffset,zoomFactor;if("pageXOffset"in _window&&"pageYOffset"in _window){pageXOffset=_window.pageXOffset;pageYOffset=_window.pageYOffset;}else{zoomFactor=_getZoomFactor();pageXOffset=_round(_document.documentElement.scrollLeft/zoomFactor);pageYOffset=_round(_document.documentElement.scrollTop/zoomFactor);}
var leftBorderWidth=_document.documentElement.clientLeft||0;var topBorderWidth=_document.documentElement.clientTop||0;info.left=rect.left+pageXOffset-leftBorderWidth;info.top=rect.top+pageYOffset-topBorderWidth;info.width="width"in rect?rect.width:rect.right-rect.left;info.height="height"in rect?rect.height:rect.bottom-rect.top;}
return info;};var _reposition=function(){var htmlBridge;if(_currentElement&&(htmlBridge=_getHtmlBridge(_flashState.bridge))){var pos=_getDOMObjectPosition(_currentElement);_extend(htmlBridge.style,{width:pos.width+"px",height:pos.height+"px",top:pos.top+"px",left:pos.left+"px",zIndex:""+_getSafeZIndex(_globalConfig.zIndex)});}};var _setHandCursor=function(enabled){if(_flashState.ready===true){if(_flashState.bridge&&typeof _flashState.bridge.setHandCursor==="function"){_flashState.bridge.setHandCursor(enabled);}else{_flashState.ready=false;}}};var _getSafeZIndex=function(val){if(/^(?:auto|inherit)$/.test(val)){return val;}
var zIndex;if(typeof val==="number"&&!_isNaN(val)){zIndex=val;}else if(typeof val==="string"){zIndex=_getSafeZIndex(_parseInt(val,10));}
return typeof zIndex==="number"?zIndex:"auto";};var _detectFlashSupport=function(ActiveXObject){var plugin,ax,mimeType,hasFlash=false,isActiveX=false,isPPAPI=false,flashVersion="";function parseFlashVersion(desc){var matches=desc.match(/[\d]+/g);matches.length=3;return matches.join(".");}
function isPepperFlash(flashPlayerFileName){return!!flashPlayerFileName&&(flashPlayerFileName=flashPlayerFileName.toLowerCase())&&(/^(pepflashplayer\.dll|libpepflashplayer\.so|pepperflashplayer\.plugin)$/.test(flashPlayerFileName)||flashPlayerFileName.slice(-13)==="chrome.plugin");}
function inspectPlugin(plugin){if(plugin){hasFlash=true;if(plugin.version){flashVersion=parseFlashVersion(plugin.version);}
if(!flashVersion&&plugin.description){flashVersion=parseFlashVersion(plugin.description);}
if(plugin.filename){isPPAPI=isPepperFlash(plugin.filename);}}}
if(_navigator.plugins&&_navigator.plugins.length){plugin=_navigator.plugins["Shockwave Flash"];inspectPlugin(plugin);if(_navigator.plugins["Shockwave Flash 2.0"]){hasFlash=true;flashVersion="2.0.0.11";}}else if(_navigator.mimeTypes&&_navigator.mimeTypes.length){mimeType=_navigator.mimeTypes["application/x-shockwave-flash"];plugin=mimeType&&mimeType.enabledPlugin;inspectPlugin(plugin);}else if(typeof ActiveXObject!=="undefined"){isActiveX=true;try{ax=new ActiveXObject("ShockwaveFlash.ShockwaveFlash.7");hasFlash=true;flashVersion=parseFlashVersion(ax.GetVariable("$version"));}catch(e1){try{ax=new ActiveXObject("ShockwaveFlash.ShockwaveFlash.6");hasFlash=true;flashVersion="6.0.21";}catch(e2){try{ax=new ActiveXObject("ShockwaveFlash.ShockwaveFlash");hasFlash=true;flashVersion=parseFlashVersion(ax.GetVariable("$version"));}catch(e3){isActiveX=false;}}}}
_flashState.disabled=hasFlash!==true;_flashState.outdated=flashVersion&&_parseFloat(flashVersion)<_parseFloat(_minimumFlashVersion);_flashState.version=flashVersion||"0.0.0";_flashState.pluginType=isPPAPI?"pepper":isActiveX?"activex":hasFlash?"netscape":"unknown";};_detectFlashSupport(_ActiveXObject);var ZeroClipboard=function(){if(!(this instanceof ZeroClipboard)){return new ZeroClipboard();}
if(typeof ZeroClipboard._createClient==="function"){ZeroClipboard._createClient.apply(this,_args(arguments));}};_defineProperty(ZeroClipboard,"version",{value:"2.1.6",writable:false,configurable:true,enumerable:true});ZeroClipboard.config=function(){return _config.apply(this,_args(arguments));};ZeroClipboard.state=function(){return _state.apply(this,_args(arguments));};ZeroClipboard.isFlashUnusable=function(){return _isFlashUnusable.apply(this,_args(arguments));};ZeroClipboard.on=function(){return _on.apply(this,_args(arguments));};ZeroClipboard.off=function(){return _off.apply(this,_args(arguments));};ZeroClipboard.handlers=function(){return _listeners.apply(this,_args(arguments));};ZeroClipboard.emit=function(){return _emit.apply(this,_args(arguments));};ZeroClipboard.create=function(){return _create.apply(this,_args(arguments));};ZeroClipboard.destroy=function(){return _destroy.apply(this,_args(arguments));};ZeroClipboard.setData=function(){return _setData.apply(this,_args(arguments));};ZeroClipboard.clearData=function(){return _clearData.apply(this,_args(arguments));};ZeroClipboard.getData=function(){return _getData.apply(this,_args(arguments));};ZeroClipboard.focus=ZeroClipboard.activate=function(){return _focus.apply(this,_args(arguments));};ZeroClipboard.blur=ZeroClipboard.deactivate=function(){return _blur.apply(this,_args(arguments));};ZeroClipboard.activeElement=function(){return _activeElement.apply(this,_args(arguments));};var _clientIdCounter=0;var _clientMeta={};var _elementIdCounter=0;var _elementMeta={};var _mouseHandlers={};_extend(_globalConfig,{autoActivate:true});var _clientConstructor=function(elements){var client=this;client.id=""+_clientIdCounter++;_clientMeta[client.id]={instance:client,elements:[],handlers:{}};if(elements){client.clip(elements);}
ZeroClipboard.on("*",function(event){return client.emit(event);});ZeroClipboard.on("destroy",function(){client.destroy();});ZeroClipboard.create();};var _clientOn=function(eventType,listener){var i,len,events,added={},handlers=_clientMeta[this.id]&&_clientMeta[this.id].handlers;if(typeof eventType==="string"&&eventType){events=eventType.toLowerCase().split(/\s+/);}else if(typeof eventType==="object"&&eventType&&typeof listener==="undefined"){for(i in eventType){if(_hasOwn.call(eventType,i)&&typeof i==="string"&&i&&typeof eventType[i]==="function"){this.on(i,eventType[i]);}}}
if(events&&events.length){for(i=0,len=events.length;i<len;i++){eventType=events[i].replace(/^on/,"");added[eventType]=true;if(!handlers[eventType]){handlers[eventType]=[];}
handlers[eventType].push(listener);}
if(added.ready&&_flashState.ready){this.emit({type:"ready",client:this});}
if(added.error){var errorTypes=["disabled","outdated","unavailable","deactivated","overdue"];for(i=0,len=errorTypes.length;i<len;i++){if(_flashState[errorTypes[i]]){this.emit({type:"error",name:"flash-"+errorTypes[i],client:this});break;}}}}
return this;};var _clientOff=function(eventType,listener){var i,len,foundIndex,events,perEventHandlers,handlers=_clientMeta[this.id]&&_clientMeta[this.id].handlers;if(arguments.length===0){events=_keys(handlers);}else if(typeof eventType==="string"&&eventType){events=eventType.split(/\s+/);}else if(typeof eventType==="object"&&eventType&&typeof listener==="undefined"){for(i in eventType){if(_hasOwn.call(eventType,i)&&typeof i==="string"&&i&&typeof eventType[i]==="function"){this.off(i,eventType[i]);}}}
if(events&&events.length){for(i=0,len=events.length;i<len;i++){eventType=events[i].toLowerCase().replace(/^on/,"");perEventHandlers=handlers[eventType];if(perEventHandlers&&perEventHandlers.length){if(listener){foundIndex=perEventHandlers.indexOf(listener);while(foundIndex!==-1){perEventHandlers.splice(foundIndex,1);foundIndex=perEventHandlers.indexOf(listener,foundIndex);}}else{perEventHandlers.length=0;}}}}
return this;};var _clientListeners=function(eventType){var copy=null,handlers=_clientMeta[this.id]&&_clientMeta[this.id].handlers;if(handlers){if(typeof eventType==="string"&&eventType){copy=handlers[eventType]?handlers[eventType].slice(0):[];}else{copy=_deepCopy(handlers);}}
return copy;};var _clientEmit=function(event){if(_clientShouldEmit.call(this,event)){if(typeof event==="object"&&event&&typeof event.type==="string"&&event.type){event=_extend({},event);}
var eventCopy=_extend({},_createEvent(event),{client:this});_clientDispatchCallbacks.call(this,eventCopy);}
return this;};var _clientClip=function(elements){elements=_prepClip(elements);for(var i=0;i<elements.length;i++){if(_hasOwn.call(elements,i)&&elements[i]&&elements[i].nodeType===1){if(!elements[i].zcClippingId){elements[i].zcClippingId="zcClippingId_"+_elementIdCounter++;_elementMeta[elements[i].zcClippingId]=[this.id];if(_globalConfig.autoActivate===true){_addMouseHandlers(elements[i]);}}else if(_elementMeta[elements[i].zcClippingId].indexOf(this.id)===-1){_elementMeta[elements[i].zcClippingId].push(this.id);}
var clippedElements=_clientMeta[this.id]&&_clientMeta[this.id].elements;if(clippedElements.indexOf(elements[i])===-1){clippedElements.push(elements[i]);}}}
return this;};var _clientUnclip=function(elements){var meta=_clientMeta[this.id];if(!meta){return this;}
var clippedElements=meta.elements;var arrayIndex;if(typeof elements==="undefined"){elements=clippedElements.slice(0);}else{elements=_prepClip(elements);}
for(var i=elements.length;i--;){if(_hasOwn.call(elements,i)&&elements[i]&&elements[i].nodeType===1){arrayIndex=0;while((arrayIndex=clippedElements.indexOf(elements[i],arrayIndex))!==-1){clippedElements.splice(arrayIndex,1);}
var clientIds=_elementMeta[elements[i].zcClippingId];if(clientIds){arrayIndex=0;while((arrayIndex=clientIds.indexOf(this.id,arrayIndex))!==-1){clientIds.splice(arrayIndex,1);}
if(clientIds.length===0){if(_globalConfig.autoActivate===true){_removeMouseHandlers(elements[i]);}
delete elements[i].zcClippingId;}}}}
return this;};var _clientElements=function(){var meta=_clientMeta[this.id];return meta&&meta.elements?meta.elements.slice(0):[];};var _clientDestroy=function(){this.unclip();this.off();delete _clientMeta[this.id];};var _clientShouldEmit=function(event){if(!(event&&event.type)){return false;}
if(event.client&&event.client!==this){return false;}
var clippedEls=_clientMeta[this.id]&&_clientMeta[this.id].elements;var hasClippedEls=!!clippedEls&&clippedEls.length>0;var goodTarget=!event.target||hasClippedEls&&clippedEls.indexOf(event.target)!==-1;var goodRelTarget=event.relatedTarget&&hasClippedEls&&clippedEls.indexOf(event.relatedTarget)!==-1;var goodClient=event.client&&event.client===this;if(!(goodTarget||goodRelTarget||goodClient)){return false;}
return true;};var _clientDispatchCallbacks=function(event){if(!(typeof event==="object"&&event&&event.type)){return;}
var async=_shouldPerformAsync(event);var wildcardTypeHandlers=_clientMeta[this.id]&&_clientMeta[this.id].handlers["*"]||[];var specificTypeHandlers=_clientMeta[this.id]&&_clientMeta[this.id].handlers[event.type]||[];var handlers=wildcardTypeHandlers.concat(specificTypeHandlers);if(handlers&&handlers.length){var i,len,func,context,eventCopy,originalContext=this;for(i=0,len=handlers.length;i<len;i++){func=handlers[i];context=originalContext;if(typeof func==="string"&&typeof _window[func]==="function"){func=_window[func];}
if(typeof func==="object"&&func&&typeof func.handleEvent==="function"){context=func;func=func.handleEvent;}
if(typeof func==="function"){eventCopy=_extend({},event);_dispatchCallback(func,context,[eventCopy],async);}}}
return this;};var _prepClip=function(elements){if(typeof elements==="string"){elements=[];}
return typeof elements.length!=="number"?[elements]:elements;};var _addMouseHandlers=function(element){if(!(element&&element.nodeType===1)){return;}
var _suppressMouseEvents=function(event){if(!(event||(event=_window.event))){return;}
if(event._source!=="js"){event.stopImmediatePropagation();event.preventDefault();}
delete event._source;};var _elementMouseOver=function(event){if(!(event||(event=_window.event))){return;}
_suppressMouseEvents(event);ZeroClipboard.focus(element);};element.addEventListener("mouseover",_elementMouseOver,false);element.addEventListener("mouseout",_suppressMouseEvents,false);element.addEventListener("mouseenter",_suppressMouseEvents,false);element.addEventListener("mouseleave",_suppressMouseEvents,false);element.addEventListener("mousemove",_suppressMouseEvents,false);_mouseHandlers[element.zcClippingId]={mouseover:_elementMouseOver,mouseout:_suppressMouseEvents,mouseenter:_suppressMouseEvents,mouseleave:_suppressMouseEvents,mousemove:_suppressMouseEvents};};var _removeMouseHandlers=function(element){if(!(element&&element.nodeType===1)){return;}
var mouseHandlers=_mouseHandlers[element.zcClippingId];if(!(typeof mouseHandlers==="object"&&mouseHandlers)){return;}
var key,val,mouseEvents=["move","leave","enter","out","over"];for(var i=0,len=mouseEvents.length;i<len;i++){key="mouse"+mouseEvents[i];val=mouseHandlers[key];if(typeof val==="function"){element.removeEventListener(key,val,false);}}
delete _mouseHandlers[element.zcClippingId];};ZeroClipboard._createClient=function(){_clientConstructor.apply(this,_args(arguments));};ZeroClipboard.prototype.on=function(){return _clientOn.apply(this,_args(arguments));};ZeroClipboard.prototype.off=function(){return _clientOff.apply(this,_args(arguments));};ZeroClipboard.prototype.handlers=function(){return _clientListeners.apply(this,_args(arguments));};ZeroClipboard.prototype.emit=function(){return _clientEmit.apply(this,_args(arguments));};ZeroClipboard.prototype.clip=function(){return _clientClip.apply(this,_args(arguments));};ZeroClipboard.prototype.unclip=function(){return _clientUnclip.apply(this,_args(arguments));};ZeroClipboard.prototype.elements=function(){return _clientElements.apply(this,_args(arguments));};ZeroClipboard.prototype.destroy=function(){return _clientDestroy.apply(this,_args(arguments));};ZeroClipboard.prototype.setText=function(text){ZeroClipboard.setData("text/plain",text);return this;};ZeroClipboard.prototype.setHtml=function(html){ZeroClipboard.setData("text/html",html);return this;};ZeroClipboard.prototype.setRichText=function(richText){ZeroClipboard.setData("application/rtf",richText);return this;};ZeroClipboard.prototype.setData=function(){ZeroClipboard.setData.apply(this,_args(arguments));return this;};ZeroClipboard.prototype.clearData=function(){ZeroClipboard.clearData.apply(this,_args(arguments));return this;};ZeroClipboard.prototype.getData=function(){return ZeroClipboard.getData.apply(this,_args(arguments));};if(typeof define==="function"&&define.amd){define(function(){return ZeroClipboard;});}else if(typeof module==="object"&&module&&typeof module.exports==="object"&&module.exports){module.exports=ZeroClipboard;}else{window.ZeroClipboard=ZeroClipboard;}})(function(){return this||window;}());;

/* /website_links/static/src/js/website_links.js defined in bundle 'web.assets_frontend' */
odoo.define('website_links.website_links',function(require){'use strict';require('web.dom_ready');var ajax=require('web.ajax');var core=require('web.core');var rpc=require('web.rpc');var Widget=require('web.Widget');var base=require('web_editor.base');var qweb=core.qweb;var _t=core._t;var exports={};if(!$('.o_website_links_create_tracked_url').length){return $.Deferred().reject("DOM doesn't contain '.o_website_links_create_tracked_url'");}
var SelectBox=Widget.extend({init:function(obj){this.obj=obj;},start:function(element,placeholder){var self=this;this.element=element;this.placeholder=placeholder;this.fetch_objects().then(function(results){self.objects=results;element.select2({placeholder:self.placeholder,allowClear:true,createSearchChoice:function(term){if(self.object_exists(term)){return null;}
return{id:term,text:_.str.sprintf("Create '%s'",term)};},createSearchChoicePosition:'bottom',multiple:false,data:self.objects,});element.on('change',function(e){self.on_change(e);});});},fetch_objects:function(){return rpc.query({model:this.obj,method:'search_read',}).then(function(result){return _.map(result,function(val){return{id:val.id,text:val.name};});});},object_exists:function(query){return _.find(this.objects,function(val){return val.text.toLowerCase()===query.toLowerCase();})!==undefined;},on_change:function(e){if(e.added&&_.isString(e.added.id)){this.create_object(e.added.id);}},create_object:function(name){var self=this;return rpc.query({model:this.obj,method:'create',args:[{name:name}],}).then(function(record){self.element.attr('value',record);self.objects.push({'id':record,'text':name});});},});var RecentLinkBox=Widget.extend({template:'website_links.RecentLink',events:{'click .btn_shorten_url_clipboard':'toggle_copy_button','click .o_website_links_edit_code':'edit_code','click .o_website_links_ok_edit':function(e){e.preventDefault();this.submit_code();},'click .o_website_links_cancel_edit':function(e){e.preventDefault();this.cancel_edit();},'submit #o_website_links_edit_code_form':function(e){e.preventDefault();this.submit_code();},},init:function(parent,link_obj){this._super(parent);this.link_obj=link_obj;this.animating_copy=false;},start:function(){new Clipboard(this.$('.btn_shorten_url_clipboard')[0]);},toggle_copy_button:function(){var self=this;if(!this.animating_copy){this.animating_copy=true;var top=this.$('.o_website_links_short_url').position().top;this.$('.o_website_links_short_url').clone().css('position','absolute').css('left',15).css('top',top-2).css('z-index',2).removeClass('o_website_links_short_url').addClass('animated-link').insertAfter(this.$('.o_website_links_short_url')).animate({opacity:0,top:"-=20",},500,function(){self.$('.animated-link').remove();self.animating_copy=false;});}},remove:function(){this.getParent().remove_link(this);},notification:function(message){this.$('.notification').append('<strong>'+message+'</strong>');},edit_code:function(){var init_code=this.$('#o_website_links_code').html();this.$('#o_website_links_code').html("<form style='display:inline;' id='o_website_links_edit_code_form'><input type='hidden' id='init_code' value='"+init_code+"'/><input type='text' id='new_code' value='"+init_code+"'/></form>");this.$('.o_website_links_edit_code').hide();this.$('.copy-to-clipboard').hide();this.$('.o_website_links_edit_tools').show();},cancel_edit:function(){this.$('.o_website_links_edit_code').show();this.$('.copy-to-clipboard').show();this.$('.o_website_links_edit_tools').hide();this.$('.o_website_links_code_error').hide();var old_code=this.$('#o_website_links_edit_code_form #init_code').val();this.$('#o_website_links_code').html(old_code);this.$('#code-error').remove();this.$('#o_website_links_code form').remove();},submit_code:function(){var self=this;var init_code=this.$('#o_website_links_edit_code_form #init_code').val();var new_code=this.$('#o_website_links_edit_code_form #new_code').val();if(new_code===''){self.$('.o_website_links_code_error').html("The code cannot be left empty");self.$('.o_website_links_code_error').show();return;}
function show_new_code(new_code){self.$('.o_website_links_code_error').html('');self.$('.o_website_links_code_error').hide();self.$('#o_website_links_code form').remove();var host=self.$('#o_website_links_host').html();self.$('#o_website_links_code').html(new_code);self.$('.btn_shorten_url_clipboard').attr('data-clipboard-text',host+new_code);self.$('.o_website_links_edit_code').show();self.$('.copy-to-clipboard').show();self.$('.o_website_links_edit_tools').hide();}
if(init_code===new_code){show_new_code(new_code);}
else{ajax.jsonRpc('/website_links/add_code','call',{'init_code':init_code,'new_code':new_code}).then(function(result){show_new_code(result[0].code);}).fail(function(){self.$('.o_website_links_code_error').show();self.$('.o_website_links_code_error').html("This code is already taken");});}},});var RecentLinks=Widget.extend({init:function(){this._super();},get_recent_links:function(filter){var self=this;ajax.jsonRpc('/website_links/recent_links','call',{'filter':filter,'limit':20}).then(function(result){_.each(result.reverse(),function(link){self.add_link(link);});self.update_notification();}).fail(function(){var message=_t("Unable to get recent links");self.$el.append("<div class='alert alert-danger'>"+message+"</div>");});},add_link:function(link){var nb_links=this.getChildren().length;var recent_link_box=new RecentLinkBox(this,link);recent_link_box.prependTo(this.$el);$('.link-tooltip').tooltip();if(nb_links===0){this.update_notification();}},remove_links:function(){_.invoke(this.getChildren(),'remove');},remove_link:function(link){link.destroy();},update_notification:function(){if(this.getChildren().length===0){var message=_t("You don't have any recent links.");$('.o_website_links_recent_links_notification').html("<div class='alert alert-info'>"+message+"</div>");}
else{$('.o_website_links_recent_links_notification').empty();}},});ajax.loadXML('/website_links/static/src/xml/recent_link.xml',qweb);base.ready().done(function(){var campaign_select=new SelectBox('utm.campaign');campaign_select.start($("#campaign-select"),_t('e.g. Promotion of June, Winter Newsletter, ..'));var medium_select=new SelectBox('utm.medium');medium_select.start($("#channel-select"),_t('e.g. Newsletter, Social Network, ..'));var source_select=new SelectBox('utm.source');source_select.start($("#source-select"),_t('e.g. Search Engine, Website page, ..'));var recent_links=new RecentLinks();recent_links.appendTo($("#o_website_links_recent_links"));recent_links.get_recent_links('newest');$('#filter-newest-links').click(function(){recent_links.remove_links();recent_links.get_recent_links('newest');});$('#filter-most-clicked-links').click(function(){recent_links.remove_links();recent_links.get_recent_links('most-clicked');});$('#filter-recently-used-links').click(function(){recent_links.remove_links();recent_links.get_recent_links('recently-used');});new Clipboard($("#btn_shorten_url")[0]);$("#generated_tracked_link a").click(function(){$("#generated_tracked_link a").text("Copied").removeClass("btn-primary").addClass("btn-success");setTimeout(function(){$("#generated_tracked_link a").text("Copy").removeClass("btn-success").addClass("btn-primary");},'5000');});$('#url').on('keyup',function(e){if($('#btn_shorten_url').hasClass('btn-copy')&&e.which!==13){$('#btn_shorten_url').removeClass('btn-success btn-copy').addClass('btn-primary').html('Get tracked link');$('#generated_tracked_link').css('display','none');$('.o_website_links_utm_forms').show();}});var url_copy_animating=false;$('#btn_shorten_url').click(function(){if($('#btn_shorten_url').hasClass('btn-copy')){if(!url_copy_animating){url_copy_animating=true;$('#generated_tracked_link').clone().css('position','absolute').css('left','78px').css('bottom','8px').css('z-index',2).removeClass('#generated_tracked_link').addClass('url-animated-link').appendTo($('#generated_tracked_link')).animate({opacity:0,bottom:"+=20",},500,function(){$('.url-animated-link').remove();url_copy_animating=false;});}}});$("#o_website_links_link_tracker_form").submit(function(event){if($('#btn_shorten_url').hasClass('btn-copy')){event.preventDefault();return;}
event.preventDefault();event.stopPropagation();var campaign_id=$('#campaign-select').attr('value');var medium_id=$('#channel-select').attr('value');var source_id=$('#source-select').attr('value');var params={};params.url=$("#url").val();if(campaign_id!==''){params.campaign_id=parseInt(campaign_id);}
if(medium_id!==''){params.medium_id=parseInt(medium_id);}
if(source_id!==''){params.source_id=parseInt(source_id);}
$('#btn_shorten_url').text(_t('Generating link...'));ajax.jsonRpc("/website_links/new",'call',params).then(function(result){if('error'in result){if(result.error==='empty_url'){$('.notification').html("<div class='alert alert-danger'>The URL is empty.</div>");}
else if(result.error==='url_not_found'){$('.notification').html("<div class='alert alert-danger'>URL not found (404)</div>");}
else{$('.notification').html("<div class='alert alert-danger'>An error occur while trying to generate your link. Try again later.</div>");}}
else{var link=result[0];$('#btn_shorten_url').removeClass('btn-primary').addClass('btn-success btn-copy').html('Copy');$('#btn_shorten_url').attr('data-clipboard-text',link.short_url);$('.notification').html('');$('#generated_tracked_link').html(link.short_url);$('#generated_tracked_link').css('display','inline');recent_links.add_link(link);$('#campaign-select').select2('val','');$('#channel-select').select2('val','');$('#source-select').select2('val','');$('.o_website_links_utm_forms').hide();}});});$(function(){$('[data-toggle="tooltip"]').tooltip();});});exports.SelectBox=SelectBox;exports.RecentLinkBox=RecentLinkBox;exports.RecentLinks=RecentLinks;return exports;});;

/* /website_links/static/src/js/website_links_code_editor.js defined in bundle 'web.assets_frontend' */
odoo.define('website_links.code_editor',function(require){'use strict';require('web.dom_ready');var ajax=require('web.ajax');if(!$('.o_website_links_edit_code').length){return $.Deferred().reject("DOM doesn't contain '.o_website_links_edit_code'");}
$('.o_website_links_edit_code').on('click',function(e){e.preventDefault();var init_code=$('#o_website_links_code').html();$('#o_website_links_code').html("<form style='display:inline;' id='edit-code-form'><input type='hidden' id='init_code' value='"+init_code+"'/><input type='text' id='new_code' value='"+init_code+"'/></form>");$('.o_website_links_edit_code').hide();$('.copy-to-clipboard').hide();$('.o_website_links_edit_tools').show();$('.o_website_links_cancel_edit').on('click',function(e){e.preventDefault();$('.o_website_links_edit_code').show();$('.copy-to-clipboard').show();$('.o_website_links_edit_tools').hide();$('.o_website_links_code_error').hide();var old_code=$('#edit-code-form #init_code').val();$('#o_website_links_code').html(old_code);$('#code-error').remove();$('#o_website_links_code form').remove();});function submit_code(){var init_code=$('#edit-code-form #init_code').val();var new_code=$('#edit-code-form #new_code').val();if(new_code===''){self.$('.o_website_links_code_error').html("The code cannot be left empty");self.$('.o_website_links_code_error').show();return;}
function show_new_code(new_code){$('.o_website_links_code_error').html('');$('.o_website_links_code_error').hide();$('#o_website_links_code form').remove();var host=$('#short-url-host').html();$('#o_website_links_code').html(new_code);$('.copy-to-clipboard').attr('data-clipboard-text',host+new_code);$('.o_website_links_edit_code').show();$('.copy-to-clipboard').show();$('.o_website_links_edit_tools').hide();}
if(init_code===new_code){show_new_code(new_code);}
else{ajax.jsonRpc('/website_links/add_code','call',{'init_code':init_code,'new_code':new_code}).then(function(result){show_new_code(result[0].code);}).fail(function(){$('.o_website_links_code_error').show();$('.o_website_links_code_error').html("This code is already taken");});}}
$('#edit-code-form').submit(function(e){e.preventDefault();submit_code();});$('.o_website_links_ok_edit').click(function(e){e.preventDefault();submit_code();});});});;

/* /website_links/static/src/js/website_links_charts.js defined in bundle 'web.assets_frontend' */
odoo.define('website_links.charts',function(require){'use strict';require('web.dom_ready');var rpc=require('web.rpc');var Widget=require('web.Widget');var base=require('web_editor.base');var core=require('web.core');var _t=core._t;var exports={};if(!$('.o_website_links_chart').length){return $.Deferred().reject("DOM doesn't contain '.o_website_links_chart'");}
var BarChart=Widget.extend({init:function($element,begin_date,end_date,dates){this.$element=$element;this.begin_date=begin_date;this.end_date=end_date;this.number_of_days=this.end_date.diff(this.begin_date,'days')+2;this.dates=dates;},start:function(){var self=this;function getDate(d){return new Date(d[0]);}
function getNbClicks(d){return d[1];}
function getPrunedTickValues(ticks,nb_desired_ticks){var nb_values=ticks.length;var keep_one_of=Math.max(1,Math.floor(nb_values/nb_desired_ticks));return _.filter(ticks,function(d,i){return i%keep_one_of===0;});}
var clicks_array=[];var begin_date_copy=this.begin_date;for(var i=0;i<this.number_of_days;i++){var date_key=begin_date_copy.format('YYYY-MM-DD');clicks_array.push([date_key,(date_key in this.dates)?this.dates[date_key]:0]);begin_date_copy.add(1,'days');}
var nb_clicks=_.reduce(clicks_array,function(total,val){return total+val[1];},0);$(this.$element+' .title').html(nb_clicks+_t(' clicks'));var chart_data=[{}];chart_data[0]['key']=_t('# of clicks');chart_data[0]['values']=clicks_array;nv.addGraph(function(){var chart=nv.models.lineChart().x(function(d){return getDate(d);}).y(function(d){return getNbClicks(d);}).margin({top:10,right:60,bottom:60,left:60}).showYAxis(true).showXAxis(true);var tick_values=getPrunedTickValues(chart_data[0]['values'],10);chart.xAxis.tickFormat(function(d){return d3.time.format("%d/%m/%y")(new Date(d));}).tickValues(_.map(tick_values,function(d){return getDate(d).getTime();})).rotateLabels(55);chart.yAxis.tickFormat(d3.format("d")).ticks(Math.min(chart_data[0]['values'].length-1,10));d3.select(self.$element+' svg').datum(chart_data).call(chart);return self.chart=chart;});},});var PieChart=Widget.extend({init:function($element,data){this.data=data;this.$element=$element;},start:function(){var self=this;var processed_data=[];for(var i=0;i<this.data.length;i++){var country_name=this.data[i]['country_id']?this.data[i]['country_id'][1]:_t('Undefined');processed_data.push({'label':country_name+' ('+this.data[i]['country_id_count']+')','value':this.data[i]['country_id_count']});}
$(this.$element+' .title').html(this.data.length+_t(' countries'));nv.addGraph(function(){var chart=nv.models.pieChart().x(function(d){return d.label;}).y(function(d){return d.value;}).showLabels(false);d3.select(self.$element+' svg').datum(processed_data).transition().duration(1200).call(chart);return self.chart=chart;});},});base.ready().done(function(){var charts={};$(".graph-tabs li a").click(function(e){e.preventDefault();$(this).tab('show');_.chain(charts).pluck('chart').invoke('update');});var link_id=$('#link_id').val();var links_domain=['link_id','=',parseInt(link_id)];var total_clicks=function(){return rpc.query({model:'link.tracker.click',method:'search_count',args:[[links_domain]],});};var clicks_by_day=function(){return rpc.query({model:'link.tracker.click',method:'read_group',args:[[links_domain],['create_date']],kwargs:{groupby:'create_date:day'},});};var clicks_by_country=function(){return rpc.query({model:'link.tracker.click',method:'read_group',args:[[links_domain],['country_id']],kwargs:{groupby:'country_id'},});};var last_week_clicks_by_country=function(){var interval=moment().subtract(7,'days').format("YYYY-MM-DD");return rpc.query({model:'link.tracker.click',method:'read_group',args:[[links_domain,['create_date','>',interval]],['country_id']],kwargs:{groupby:'country_id'},});};var last_month_clicks_by_country=function(){var interval=moment().subtract(30,'days').format("YYYY-MM-DD");return rpc.query({model:'link.tracker.click',method:'read_group',args:[[links_domain,['create_date','>',interval]],['country_id']],kwargs:{groupby:'country_id'},});};$.when(total_clicks(),clicks_by_day(),clicks_by_country(),last_week_clicks_by_country(),last_month_clicks_by_country()).done(function(total_clicks,clicks_by_day,clicks_by_country,last_week_clicks_by_country,last_month_clicks_by_country){if(total_clicks){var formatted_clicks_by_day={};var begin_date,end_date;for(var i=0;i<clicks_by_day.length;i++){var date=moment(clicks_by_day[i]['create_date:day'],"DD MMMM YYYY");if(i===0){begin_date=date;}
if(i===clicks_by_day.length-1){end_date=date;}
formatted_clicks_by_day[date.format("YYYY-MM-DD")]=clicks_by_day[i]['create_date_count'];}
var now=moment();charts.all_time_bar=new BarChart('#all_time_clicks_chart',begin_date,now,formatted_clicks_by_day);begin_date=moment().subtract(30,'days');charts.last_month_bar=new BarChart('#last_month_clicks_chart',begin_date,now,formatted_clicks_by_day);begin_date=moment().subtract(7,'days');charts.last_week_bar=new BarChart('#last_week_clicks_chart',begin_date,now,formatted_clicks_by_day);charts.all_time_pie=new PieChart('#all_time_countries_charts',clicks_by_country);charts.last_month_pie=new PieChart('#last_month_countries_charts',last_month_clicks_by_country);charts.last_week_pie=new PieChart('#last_week_countries_charts',last_week_clicks_by_country);var row_width=$('#all_time_countries_charts').parent().width();var charts_svg=$('#all_time_countries_charts,last_month_countries_charts,last_week_countries_charts').find('svg');charts_svg.css('height',Math.max(clicks_by_country.length*(row_width>750?1:2),20)+'em');_.invoke(charts,'start');nv.utils.windowResize(function(){_.chain(charts).pluck('chart').invoke('update');});}
else{$('#all_time_charts').prepend(_t('There is no data to show'));$('#last_month_charts').prepend(_t('There is no data to show'));$('#last_week_charts').prepend(_t('There is no data to show'));}});ZeroClipboard.config({swfPath:window.location.origin+"/website_links/static/lib/zeroclipboard/ZeroClipboard.swf"});new ZeroClipboard($('.copy-to-clipboard'));var animating_copy=false;$('.copy-to-clipboard').on('click',function(e){e.preventDefault();if(!animating_copy){animating_copy=true;$('.o_website_links_short_url').clone().css('position','absolute').css('left','15px').css('bottom','10px').css('z-index',2).removeClass('.o_website_links_short_url').addClass('animated-link').appendTo($('.o_website_links_short_url')).animate({opacity:0,bottom:"+=20",},500,function(){$('.animated-link').remove();animating_copy=false;});}});});exports.BarChart=BarChart;exports.PieChart=PieChart;return exports;});;

/* /website_blog/static/src/js/contentshare.js defined in bundle 'web.assets_frontend' */
(function(){$.fn.share=function(options){var option=$.extend($.fn.share.defaults,options);var selected_text="";$.extend($.fn.share,{init:function(shareable){var self=this;$.fn.share.defaults.shareable=shareable;$.fn.share.defaults.shareable.on('mouseup',function(){if($(this).parents('body.editor_enable').length===0){self.popOver();}});$.fn.share.defaults.shareable.on('mousedown',function(){self.destroy();});},getContent:function(){var popover_content='';if($('.blog_title, .blog_content').hasClass('js_comment')){selected_text=this.getSelection('string');popover_content+='<a class="o_share_comment mr12"><i class="fa fa-comment fa-lg mr4 ml4"/></a>';}
if($('.blog_title, .blog_content').hasClass('js_tweet')){var tweet='"%s" - %s';var baseLength=tweet.replace(/%s/g,'').length;var selectedText=this.getSelection('string').substring(0,option.maxLength-baseLength-23);var text=encodeURIComponent(_.str.sprintf(tweet,selectedText,window.location.href));popover_content+='<a onclick="window.open(\''+option.shareLink+text+'\',\'_'+option.target+'\',\'location=yes,height=570,width=520,scrollbars=yes,status=yes\')"><i class="ml4 mr4 fa fa-twitter fa-lg"/></a>';}
return popover_content;},commentEdition:function(){var positionComment=($('#comments').position()).top-50;$(".o_portal_chatter_composer_form textarea").val('"'+selected_text+'" ').focus();$('html, body').stop().animate({'scrollTop':positionComment},500,'swing',function(){window.location.hash='blog_post_comment_quote';});},getSelection:function(share){if(window.getSelection){var selection=window.getSelection();if(!selection||selection.rangeCount===0){return"";}
if(share==='string'){return String(selection.getRangeAt(0)).replace(/\s{2,}/g,' ');}else{return selection.getRangeAt(0);}}
else if(document.selection){if(share==='string'){return document.selection.createRange().text.replace(/\s{2,}/g,' ');}else{return document.selection.createRange();}}},popOver:function(){this.destroy();if(this.getSelection('string').length<option.minLength)
return;var data=this.getContent();var range=this.getSelection();var newNode=document.createElement("span");range.insertNode(newNode);newNode.className=option.className;var $pop=$(newNode);$pop.popover({trigger:'manual',placement:option.placement,html:true,content:function(){return data;}}).popover('show');$('.o_share_comment').on('click',this.commentEdition);},destroy:function(){var $span=$('span.'+option.className);$span.popover('hide');$span.remove();}});$.fn.share.init(this);};$.fn.share.defaults={shareLink:"http://twitter.com/intent/tweet?text=",minLength:5,maxLength:140,target:"blank",className:"share",placement:"top",};}());;

/* /website_blog/static/src/js/website_blog.js defined in bundle 'web.assets_frontend' */
odoo.define('website_blog.website_blog',function(require){"use strict";function page_transist(event){event.preventDefault();var newLocation=$('.js_next')[0].href;var top=$('.cover_footer').offset().top;$('.cover_footer').animate({height:$(window).height()+'px'},300);$('html, body').animate({scrollTop:top},300,'swing',function(){window.location.href=newLocation;});}
function animate(event){event.preventDefault();event.stopImmediatePropagation();var target=$(this.hash);$('html, body').stop().animate({'scrollTop':target.offset().top-32},500,'swing',function(){window.location.hash='blog_content';});}
function shareArticle(event){var url='';var articleURL;if($(this).is('*[class*="_complete"]')){var blog_title_complete=encodeURIComponent($('#blog_post_name').html()||'');articleURL=encodeURIComponent(window.location.href);if($(this).hasClass('o_twitter_complete')){url='https://twitter.com/intent/tweet?tw_p=tweetbutton&text=Amazing blog article : '+blog_title_complete+"! Check it live: "+articleURL;}else if($(this).hasClass('o_facebook_complete')){url='https://www.facebook.com/sharer/sharer.php?u='+articleURL;}else if($(this).hasClass('o_linkedin_complete')){url='https://www.linkedin.com/shareArticle?mini=true&url='+articleURL+'&title='+blog_title_complete;}else{url='https://plus.google.com/share?url='+articleURL;}}
else{var blog_post=$(this).parents("[name='blog_post']");var blog_post_title=encodeURIComponent(blog_post.find('.o_blog_post_title').html()||'');var blog_article_link=blog_post.find('.o_blog_post_title').parent('a').attr('href');articleURL=encodeURIComponent(window.location.host+blog_article_link);if($(this).hasClass('o_twitter')){url='https://twitter.com/intent/tweet?tw_p=tweetbutton&text=Amazing blog article : '+blog_post_title+"! "+articleURL;}else if($(this).hasClass('o_facebook')){url='https://www.facebook.com/sharer/sharer.php?u='+articleURL;}else if($(this).hasClass('o_linkedin')){url='https://www.linkedin.com/shareArticle?mini=true&url='+articleURL+'&title='+blog_post_title;}else if($(this).hasClass('o_google')){url='https://plus.google.com/share?url='+articleURL;}}
window.open(url,"","menubar=no, width=500, height=400");}
$(document).ready(function(){if($('.website_blog').length){$(".js_tweet, .js_comment").share({});$('.cover_footer').on('click',page_transist);$('a[href^="#blog_content"]').on('click',animate);$('.o_twitter, .o_facebook, .o_linkedin, .o_google, .o_twitter_complete, .o_facebook_complete, .o_linkedin_complete, .o_google_complete').on('click',shareArticle);}
$('div.o_blog_post_complete a').hover(function(){$('div.o_blog_post_complete a').not('#'+this.id).addClass('unhover');},function(){$('div.o_blog_post_complete a').not('#'+this.id).removeClass('unhover');});});});;

/* /website_slides/static/src/js/slides.js defined in bundle 'web.assets_frontend' */
odoo.define('website_slides.slides',function(require){"use strict";var ajax=require('web.ajax');var core=require('web.core');var time=require('web.time');var Widget=require('web.Widget');var local_storage=require('web.local_storage');var websiteRootInstance=require('website.WebsiteRoot.instance');var _t=core._t;var page_widgets={};(function(){var widget_parent=$('body');$("timeago.timeago").each(function(index,el){var datetime=$(el).attr('datetime'),datetime_obj=time.str_to_datetime(datetime),display_str="";if(datetime_obj&&new Date().getTime()-datetime_obj.getTime()>7*24*60*60*1000){display_str=moment(datetime_obj).format('ll');}else{display_str=moment(datetime_obj).fromNow();}
$(el).text(display_str);});$('.o_slides_hide_channel_settings').on('click',function(ev){var channel_id=$(this).data("channelId");ev.preventDefault();document.cookie="slides_channel_"+channel_id+" = closed";return true;});var LikeButton=Widget.extend({setElement:function($el){this._super.apply(this,arguments);this.$el.on('click',this,_.bind(this.apply_action,this));},apply_action:function(ev){var button=$(ev.currentTarget);var slide_id=button.data('slide-id');var user_id=button.data('user-id');var is_public=button.data('public-user');var href=button.data('href');if(is_public){this.popover_alert(button,_.str.sprintf(_t('Please <a href="/web?redirect=%s">login</a> to vote this slide'),(document.URL)));}else{var target=button.find('.fa');if(local_storage.getItem('slide_vote_'+slide_id)!==user_id.toString()){ajax.jsonRpc(href,'call',{slide_id:slide_id}).then(function(data){target.text(data);local_storage.setItem('slide_vote_'+slide_id,user_id);});}else{this.popover_alert(button,_t('You have already voted for this slide'));}}},popover_alert:function($el,message){$el.popover({trigger:'focus',placement:'bottom',container:'body',html:true,content:function(){return message;}}).popover('show');},});page_widgets['likeButton']=new LikeButton(widget_parent).setElement($('.oe_slide_js_like'));page_widgets['dislikeButton']=new LikeButton(widget_parent).setElement($('.oe_slide_js_unlike'));var SlideSocialEmbed=Widget.extend({events:{'change input':'change_page',},init:function(parent,max_page){this._super(parent);this.max_page=max_page||false;},change_page:function(ev){ev.preventDefault();var input=this.$('input');var page=parseInt(input.val());if(this.max_page&&!(page>0&&page<=this.max_page)){page=1;}
this.update_embedded_code(page);},update_embedded_code:function(page){var embed_input=this.$('.slide_embed_code');var new_code=embed_input.val().replace(/(page=).*?([^\d]+)/,'$1'+page+'$2');embed_input.val(new_code);},});$('iframe.o_wslides_iframe_viewer').ready(function(){var $iframe=$(this);var max_page=$iframe.contents().find('#page_count').val();new SlideSocialEmbed($iframe,max_page).setElement($('.oe_slide_js_embed_code_widget'));});var ShareMail=Widget.extend({events:{'click button':'send_mail',},send_mail:function(){var self=this;var input=this.$('input');var slide_id=this.$('button').data('slide-id');if(input.val()&&input[0].checkValidity()){this.$el.removeClass('has-error');ajax.jsonRpc('/slides/slide/send_share_email','call',{slide_id:slide_id,email:input.val(),}).then(function(){self.$el.html($('<div class="alert alert-info" role="alert"><strong>Thank you!</strong> Mail has been sent.</div>'));});}else{this.$el.addClass('has-error');input.focus();}},});page_widgets['share_mail']=new ShareMail(widget_parent).setElement($('.oe_slide_js_share_email'));if($('div#statistic').length){var slide_url=$("div#statistic").attr('slide-url');var social_urls={'linkedin':'https://www.linkedin.com/countserv/count/share?url=','twitter':'https://cdn.api.twitter.com/1/urls/count.json?url=','facebook':'https://graph.facebook.com/?id=','gplus':'https://clients6.google.com/rpc'}
var update_statistics=function(social_site,slide_url){if(social_site=='gplus'){$.ajax({url:social_urls['gplus'],type:"POST",dataType:'json',contentType:'application/json',data:JSON.stringify([{"method":"pos.plusones.get","id":"p","params":{"nolog":true,"id":slide_url,"source":"widget","userId":"@viewer","groupId":"@self"},"jsonrpc":"2.0","apiVersion":"v1"}]),success:function(data){$('#google-badge').text(data[0].result.metadata.globalCounts.count||0);$('#total-share').text(parseInt($('#total-share').text())+parseInt($('#google-badge').text()));},});}else{$.ajax({url:social_urls[social_site]+slide_url,dataType:'jsonp',success:function(data){var shareCount=(social_site==='facebook'?data.shares:data.count)||0;$('#'+social_site+'-badge').text(shareCount);$('#total-share').text(parseInt($('#total-share').text())+parseInt($('#'+social_site+'-badge').text()));},});}};$.each(social_urls,function(key,value){update_statistics(key,slide_url);});$("a.o_slides_social_share").on('click',function(ev){ev.preventDefault();var key=$(ev.currentTarget).attr('social-key');var popUpURL=$(ev.currentTarget).attr('href');var popUp=window.open(popUpURL,'Share Dialog','width=626,height=436');$(window).on('focus',function(){if(popUp.closed){update_statistics(key,slide_url);$(window).off('focus');}});});}})();return{page_widgets:page_widgets,};});;

/* /website_slides/static/src/js/slides_upload.js defined in bundle 'web.assets_frontend' */
odoo.define('website_slides.upload',function(require){"use strict";var ajax=require('web.ajax');var core=require('web.core');var Widget=require('web.Widget');require('web.dom_ready');var weContext=require("web_editor.context");var slides=require('website_slides.slides');var qweb=core.qweb;var _t=core._t;if(!$('.oe_slide_js_upload').length){return $.Deferred().reject("DOM doesn't contain '.oe_slide_js_upload'");}
ajax.loadXML('/website_slides/static/src/xml/website_slides.xml',qweb);var SlideDialog=Widget.extend({template:'website.slide.upload',events:{'hidden.bs.modal':'destroy','click button.save':'save','click button[data-dismiss="modal"]':'cancel','change input#upload':'slide_upload','change input#url':'slide_url','click .list-group-item':function(ev){this.$('.list-group-item').removeClass('active');$(ev.target).closest('li').addClass('active');}},init:function(el,channel_id){this._super(el,channel_id);this.channel_id=parseInt(channel_id,10);this.file={};this.index_content="";},start:function(){this.$el.modal({backdrop:'static'});this.set_category_id();this.set_tag_ids();},slide_url:function(ev){var self=this,value={'url':$(ev.target).val(),'channel_id':self.channel_id};this.$('.alert-warning').remove();this.is_valid_url=false;this.$('.save').button('loading');ajax.jsonRpc('/slides/dialog_preview/','call',value).then(function(data){self.$('.save').button('reset');if(data.error){self.display_alert(data.error);}else{self.$("#slide-image").attr("src",data.url_src);self.$('#name').val(data.title);self.$('#description').val(data.description);self.is_valid_url=true;}});},check_unique_slide:function(file_name){var self=this;return ajax.jsonRpc('/web/dataset/call_kw','call',{model:'slide.slide',method:'search_count',args:[[['channel_id','=',self.channel_id],['name','=',file_name]]],kwargs:{}});},slide_upload:function(ev){var self=this,file=ev.target.files[0],is_image=/^image\/.*/.test(file.type),loaded=false;this.file.name=file.name;this.file.type=file.type;if(!(is_image||this.file.type==='application/pdf')){this.display_alert(_t("Invalid file type. Please select pdf or image file"));this.reset_file();return;}
if(file.size/1024/1024>25){this.display_alert(_t("File is too big. File size cannot exceed 25MB"));this.reset_file();return;}
this.$('.alert-warning').remove();var BinaryReader=new FileReader();BinaryReader.readAsDataURL(file);BinaryReader.onloadend=function(upload){var buffer=upload.target.result;if(is_image){self.$("#slide-image").attr("src",buffer);}
buffer=buffer.split(',')[1];self.file.data=buffer;};if(file.type==='application/pdf'){var ArrayReader=new FileReader();this.$('.save').button('loading');ArrayReader.readAsArrayBuffer(file);ArrayReader.onload=function(evt){var buffer=evt.target.result;var passwordNeeded=function(){self.display_alert(_t("You can not upload password protected file."));self.reset_file();self.$('.save').button('reset');};PDFJS.getDocument(new Uint8Array(buffer),null,passwordNeeded).then(function getPdf(pdf){pdf.getPage(1).then(function getFirstPage(page){var scale=1;var viewport=page.getViewport(scale);var canvas=document.getElementById('data_canvas');var context=canvas.getContext('2d');canvas.height=viewport.height;canvas.width=viewport.width;page.render({canvasContext:context,viewport:viewport}).then(function(){var image_data=self.$('#data_canvas')[0].toDataURL();self.$("#slide-image").attr("src",image_data);if(loaded){self.$('.save').button('reset');}
loaded=true;});});var maxPages=pdf.pdfInfo.numPages;var page,j;self.index_content="";for(j=1;j<=maxPages;j+=1){page=pdf.getPage(j);page.then(function(page_obj){var page_number=page_obj.pageIndex+1;page_obj.getTextContent().then(function(data){var page_content='';_.each(data.items,function(obj){page_content=page_content+obj.str+" ";});page_content=page_content.replace(/\0/g,"");self.index_content=self.index_content+page_number+". "+page_content+'\n';if(maxPages===page_number){if(loaded){self.$('.save').button('reset');}
loaded=true;}});});}});};}
var input=file.name;var input_val=input.substr(0,input.lastIndexOf('.'))||input;this.check_unique_slide(input_val).then(function(exist){if(exist){var message=_t("Channel contains the given title, please change before Save or Publish.");self.display_alert(message);}
self.$('#name').val(input_val);});},reset_file:function(){var control=this.$('#upload');control.replaceWith(control=control.clone(true));this.file.name=false;},display_alert:function(message){this.$('.alert-warning').remove();$('<div class="alert alert-warning" role="alert">'+message+'</div>').insertBefore(this.$('form'));},select2_wrapper:function(tag,multi,fetch_fnc){return{width:'100%',placeholder:tag,allowClear:true,formatNoMatches:false,multiple:multi,selection_data:false,fetch_rpc_fnc:fetch_fnc,formatSelection:function(data){if(data.tag){data.text=data.tag;}
return data.text;},createSearchChoice:function(term,data){var added_tags=$(this.opts.element).select2('data');if(_.filter(_.union(added_tags,data),function(tag){return tag.text.toLowerCase().localeCompare(term.toLowerCase())===0;}).length===0){return{id:_.uniqueId('tag_'),create:true,tag:term,text:_.str.sprintf(_t("Create new tag '%s'"),term),};}},fill_data:function(query,data){var that=this,tags={results:[]};_.each(data,function(obj){if(that.matcher(query.term,obj.name)){tags.results.push({id:obj.id,text:obj.name});}});query.callback(tags);},query:function(query){var that=this;if(!this.selection_data){this.fetch_rpc_fnc().then(function(data){that.fill_data(query,data);that.selection_data=data;});}else{this.fill_data(query,this.selection_data);}}};},set_category_id:function(){var self=this;$('#category_id').select2(this.select2_wrapper(_t('Category'),false,function(){return ajax.jsonRpc("/web/dataset/call_kw",'call',{model:'slide.category',method:'search_read',args:[],kwargs:{fields:['name'],domain:[['channel_id','=',self.channel_id]],context:weContext.get()}});}));},get_category_id:function(){var value=$('#category_id').select2('data');if(value&&value.create){return[0,{'name':value.text}];}
return[value?value.id:null];},set_tag_ids:function(){$('#tag_ids').select2(this.select2_wrapper(_t('Tags'),true,function(){return ajax.jsonRpc("/web/dataset/call_kw",'call',{model:'slide.tag',method:'search_read',args:[],kwargs:{fields:['name'],context:weContext.get()}});}));},get_tag_ids:function(){var res=[];_.each($('#tag_ids').select2('data'),function(val){if(val.create){res.push([0,0,{'name':val.text}]);}else{res.push([4,val.id]);}});return res;},svg_to_png:function(){var img=this.$el.find("img#slide-image")[0];var canvas=document.createElement("canvas");canvas.width=img.width;canvas.height=img.height;canvas.getContext("2d").drawImage(img,0,0);return canvas.toDataURL("image/png").split(',')[1];},get_value:function(){var canvas=this.$('#data_canvas')[0],values={'channel_id':this.channel_id||'','name':this.$('#name').val(),'url':this.$('#url').val(),'description':this.$('#description').val(),'tag_ids':this.get_tag_ids(),'category_id':this.get_category_id()};if(this.file.type==='application/pdf'){_.extend(values,{'image':canvas.toDataURL().split(',')[1],'index_content':this.index_content,'slide_type':canvas.height>canvas.width?'document':'presentation','mime_type':this.file.type,'datas':this.file.data});}
if(/^image\/.*/.test(this.file.type)){_.extend(values,{'slide_type':'infographic','mime_type':this.file.type==='image/svg+xml'?'image/png':this.file.type,'datas':this.file.type==='image/svg+xml'?this.svg_to_png():this.file.data});}
return values;},validate:function(){this.$('.form-group').removeClass('has-error');if(!this.$('#name').val()){this.$('#name').closest('.form-group').addClass('has-error');return false;}
var url=this.$('#url').val()?this.is_valid_url:false;if(!(this.file.name||url)){this.$('#url').closest('.form-group').addClass('has-error');return false;}
return true;},save:function(ev){var self=this;if(this.validate()){var values=this.get_value();if($(ev.target).data('published')){values.website_published=true;}
this.$('.oe_slides_upload_loading').show();this.$('.modal-footer, .modal-body').hide();ajax.jsonRpc("/slides/add_slide",'call',values).then(function(data){if(data.error){self.display_alert(data.error);self.$('.oe_slides_upload_loading').hide();self.$('.modal-footer, .modal-body').show();}else{window.location=data.url;}});}},cancel:function(){this.trigger("cancel");}});$('.oe_slide_js_upload').on('click',function(){var channel_id=$(this).attr('channel_id');slides.page_widgets['upload_dialog']=new SlideDialog(this,channel_id).appendTo(document.body);});});;

/* /website_mass_mailing/static/src/js/website_mass_mailing.js defined in bundle 'web.assets_frontend' */
odoo.define('mass_mailing.website_integration',function(require){"use strict";var utils=require('web.utils');var sAnimation=require('website.content.snippets.animation');sAnimation.registry.subscribe=sAnimation.Class.extend({selector:".js_subscribe",start:function(){var self=this;self.$target.find("input").removeClass("hidden");this._rpc({route:'/website_mass_mailing/is_subscriber',params:{list_id:this.$target.data('list-id'),},}).always(function(data){self.$target.find('input.js_subscribe_email').val(data.email?data.email:"").attr("disabled",data.is_subscriber&&data.email.length?"disabled":false);self.$target.attr("data-subscribe",data.is_subscriber?'on':'off');self.$target.find('a.js_subscribe_btn').attr("disabled",data.is_subscriber&&data.email.length?"disabled":false);self.$target.removeClass("hidden");self.$target.find('.js_subscribe_btn').toggleClass('hidden',!!data.is_subscriber);self.$target.find('.js_subscribed_btn').toggleClass('hidden',!data.is_subscriber);});if(!this.editableMode){$('.js_subscribe > .alert').addClass("hidden");$('.js_subscribe > .input-group-btn.hidden').removeClass("hidden");this.$target.find('.js_subscribe_btn').on('click',function(event){event.preventDefault();self._onClick();});}},_onClick:function(){var self=this;var $email=this.$target.find(".js_subscribe_email:visible");if($email.length&&!$email.val().match(/.+@.+/)){this.$target.addClass('has-error');return false;}
this.$target.removeClass('has-error');this._rpc({route:'/website_mass_mailing/subscribe',params:{'list_id':this.$target.data('list-id'),'email':$email.length?$email.val():false,},}).then(function(subscribe){self.$target.find(".js_subscribe_email, .input-group-btn").addClass("hidden");self.$target.find(".alert").removeClass("hidden");self.$target.find('input.js_subscribe_email').attr("disabled",subscribe?"disabled":false);self.$target.attr("data-subscribe",subscribe?'on':'off');});},});sAnimation.registry.newsletter_popup=sAnimation.Class.extend({selector:".o_newsletter_popup",start:function(){var self=this;var popupcontent=self.$target.find(".o_popup_content_dev").empty();if(!self.$target.data('list-id'))return;this._rpc({route:'/website_mass_mailing/get_content',params:{newsletter_id:self.$target.data('list-id'),},}).then(function(data){if(data.content){$('<div></div>').append(data.content).appendTo(popupcontent);}
self.$target.find('input.popup_subscribe_email').val(data.email||"");self.redirect_url=data.redirect_url;if(!self.editableMode&&!data.is_subscriber){$(document).on('mouseleave',_.bind(self.show_banner,self));self.$target.find('.popup_subscribe_btn').on('click',function(event){event.preventDefault();self._onClickSubscribe();});}else{$(document).off('mouseleave');}});},_onClickSubscribe:function(){var self=this;var $email=self.$target.find(".popup_subscribe_email:visible");if($email.length&&!$email.val().match(/.+@.+/)){this.$target.addClass('has-error');return false;}
this.$target.removeClass('has-error');this._rpc({route:'/website_mass_mailing/subscribe',params:{'list_id':self.$target.data('list-id'),'email':$email.length?$email.val():false,},}).then(function(subscribe){self.$target.find('#o_newsletter_popup').modal('hide');$(document).off('mouseleave');if(self.redirect_url){if(_.contains(self.redirect_url.split('/'),window.location.host)||self.redirect_url.indexOf('/')===0){window.location.href=self.redirect_url;}else{window.open(self.redirect_url,'_blank');}}});},show_banner:function(){var self=this;if(!utils.get_cookie("newsletter-popup-"+self.$target.data('list-id'))&&self.$target){$('#o_newsletter_popup:first').modal('show').css({'margin-top':'70px','position':'fixed'});document.cookie="newsletter-popup-"+self.$target.data('list-id')+"="+true+";path=/";}}});});odoo.define('mass_mailing.unsubscribe',function(require){'use strict';var ajax=require('web.ajax');var core=require('web.core');require('web.dom_ready');var _t=core._t;if(!$('.o_unsubscribe_form').length){return $.Deferred().reject("DOM doesn't contain '.o_unsubscribe_form'");}
$('#unsubscribe_form').on('submit',function(e){e.preventDefault();var email=$("input[name='email']").val();var mailing_id=parseInt($("input[name='mailing_id']").val());var checked_ids=[];$("input[type='checkbox']:checked").each(function(i){checked_ids[i]=parseInt($(this).val());});var unchecked_ids=[];$("input[type='checkbox']:not(:checked)").each(function(i){unchecked_ids[i]=parseInt($(this).val());});ajax.jsonRpc('/mail/mailing/unsubscribe','call',{'opt_in_ids':checked_ids,'opt_out_ids':unchecked_ids,'email':email,'mailing_id':mailing_id}).then(function(result){$('.alert-info').html(_t('Your changes have been saved.')).removeClass('alert-info').addClass('alert-success');}).fail(function(){$('.alert-info').html(_t('Your changes have not been saved, try again later.')).removeClass('alert-info').addClass('alert-warning');});});});;

/* /website_sale_stock/static/src/js/website_sale_stock.js defined in bundle 'web.assets_frontend' */
odoo.define('website_sale_stock.website_sale',function(require){'use strict';require('web.dom_ready');var base=require('web_editor.base');var ajax=require('web.ajax');var core=require('web.core');var QWeb=core.qweb;var xml_load=ajax.loadXML('/website_sale_stock/static/src/xml/website_sale_stock_product_availability.xml',QWeb);if(!$('.oe_website_sale').length){return $.Deferred().reject("DOM doesn't contain '.oe_website_sale'");}
$('.oe_website_sale').each(function(){var oe_website_sale=this;$(oe_website_sale).on('change','input[name="add_qty"]',function(){$(oe_website_sale).find('ul[data-attribute_value_ids]').trigger('change');});$(oe_website_sale).find('input[name="add_qty"]').trigger('change');$(oe_website_sale).prependEvent('change','.oe_cart input.js_quantity[data-product-id]',function(event){var $input=$(event.currentTarget);var max_qty=parseInt($input.data('max'));if($input.val()>max_qty){$input.val(max_qty);}});$(oe_website_sale).on('change','ul[data-attribute_value_ids]',function(event){var $ul=$(event.target).closest('.js_add_cart_variants');var $parent=$ul.closest('.js_product');var variant_ids=$ul.data("attribute_value_ids");if(_.isString(variant_ids)){variant_ids=JSON.parse(variant_ids.replace(/'/g,'"'));}
var values=[];$parent.find('input.js_variant_change:checked, select.js_variant_change').each(function(){values.push(+$(this).val());});var qty=$parent.find('input[name="add_qty"]').val();for(var k in variant_ids){if(_.isEmpty(_.difference(variant_ids[k][1],values))){var info=_.clone(variant_ids[k][4]);if(_.contains(['always','threshold'],info['inventory_availability'])){info['virtual_available']-=parseInt(info['cart_qty']);if(info['virtual_available']<0){info['virtual_available']=0;}
if(qty>info['virtual_available']){$parent.find('input[name="add_qty"]').val(info['virtual_available']||1);}
if(qty>info['virtual_available']||info['virtual_available']<1||qty<1){$parent.find('#add_to_cart').addClass('disabled');}
$parent.find('.js_add').toggleClass('disabled btn',info['virtual_available']<1);}
xml_load.then(function(){$(oe_website_sale).find('.availability_message_'+info['product_template']).remove();var $message=$(QWeb.render('website_sale_stock.product_availability',info));$('div.availability_messages').html($message);});}}});});});;

/* /website_sale_delivery/static/src/js/website_sale_delivery.js defined in bundle 'web.assets_frontend' */
odoo.define('website_sale_delivery.checkout',function(require){'use strict';require('web.dom_ready');var ajax=require('web.ajax');var core=require('web.core');var _t=core._t;var concurrency=require('web.concurrency');var dp=new concurrency.DropPrevious();var $pay_button=$('#o_payment_form_pay');var _onCarrierUpdateAnswer=function(result){var $amount_delivery=$('#order_delivery span.oe_currency_value');var $amount_untaxed=$('#order_total_untaxed span.oe_currency_value');var $amount_tax=$('#order_total_taxes span.oe_currency_value');var $amount_total=$('#order_total span.oe_currency_value');var $carrier_badge=$('#delivery_carrier input[name="delivery_type"][value='+result.carrier_id+'] ~ .badge:not(.o_delivery_compute)');var $compute_badge=$('#delivery_carrier input[name="delivery_type"][value='+result.carrier_id+'] ~ .o_delivery_compute');var $discount=$('#order_discounted');if($discount&&result.new_amount_order_discounted){$discount.find('.oe_currency_value').text(result.new_amount_order_discounted);$('#delivery_carrier .badge').text(_t('Free'));}
if(result.status===true){$amount_delivery.text(result.new_amount_delivery);$amount_untaxed.text(result.new_amount_untaxed);$amount_tax.text(result.new_amount_tax);$amount_total.text(result.new_amount_total);$carrier_badge.children('span').text(result.new_amount_delivery);$carrier_badge.removeClass('hidden');$compute_badge.addClass('hidden');$pay_button.prop('disabled',false);}
else{console.error(result.error_message);$compute_badge.text(result.error_message);$amount_delivery.text(result.new_amount_delivery);$amount_untaxed.text(result.new_amount_untaxed);$amount_tax.text(result.new_amount_tax);$amount_total.text(result.new_amount_total);}};var _onCarrierClick=function(ev){$pay_button.prop('disabled',true);var carrier_id=$(ev.currentTarget).val();var values={'carrier_id':carrier_id};dp.add(ajax.jsonRpc('/shop/update_carrier','call',values)).then(_onCarrierUpdateAnswer);};var $carriers=$("#delivery_carrier input[name='delivery_type']");$carriers.click(_onCarrierClick);if($carriers.length>0){$carriers.filter(':checked').click();}
$(".oe_website_sale select[name='shipping_id']").on('change',function(){var value=$(this).val();var $provider_free=$("select[name='country_id']:not(.o_provider_restricted), select[name='state_id']:not(.o_provider_restricted)");var $provider_restricted=$("select[name='country_id'].o_provider_restricted, select[name='state_id'].o_provider_restricted");if(value===0){$provider_free.hide().attr('disabled',true);$provider_restricted.show().attr('disabled',false).change();}else{$provider_free.show().attr('disabled',false).change();$provider_restricted.hide().attr('disabled',true);}});});;

/* /website_event/static/src/js/website_geolocation.js defined in bundle 'web.assets_frontend' */
odoo.define('website_event.geolocation',function(require){'use strict';var sAnimation=require('website.content.snippets.animation');sAnimation.registry.visitor=sAnimation.Class.extend({selector:".oe_country_events, .country_events",start:function(){var defs=[this._super.apply(this,arguments)];var self=this;var $eventList=this.$('.country_events_list');this._originalContent=$eventList[0].outerHTML;defs.push(this._rpc({route:'/event/get_country_event_list'}).then(function(data){if(data){self._$loadedContent=$(data);self._$loadedContent.addClass('o_temp_auto_element');self._$loadedContent.attr('data-temp-auto-element-original-content',self._originalContent);$eventList.replaceWith(self._$loadedContent);}}));return $.when.apply($,defs);},destroy:function(){this._super.apply(this,arguments);if(this._$loadedContent){this._$loadedContent.replaceWith(this._originalContent);}},});});;

/* /website_event/static/src/js/website_event.js defined in bundle 'web.assets_frontend' */
odoo.define('website_event.registration_form.instance',function(require){'use strict';require('web_editor.ready');var EventRegistrationForm=require('website_event.website_event');var $form=$('#registration_form');if(!$form.length){return null;}
var instance=new EventRegistrationForm();return instance.appendTo($form).then(function(){return instance;});});odoo.define('website_event.website_event',function(require){var ajax=require('web.ajax');var core=require('web.core');var Widget=require('web.Widget');var _t=core._t;var EventRegistrationForm=Widget.extend({start:function(){var self=this;var res=this._super.apply(this.arguments).then(function(){$('#registration_form .a-submit').off('click').removeClass('a-submit').click(function(ev){self.on_click(ev);});});return res;},on_click:function(ev){ev.preventDefault();ev.stopPropagation();var $form=$(ev.currentTarget).closest('form');var $button=$(ev.currentTarget).closest('[type="submit"]');var post={};$('#registration_form table').siblings('.alert').remove();$('#registration_form select').each(function(){post[$(this).attr('name')]=$(this).val();});var tickets_ordered=_.some(_.map(post,function(value,key){return parseInt(value);}));if(!tickets_ordered){$('<div class="alert alert-info"/>').text(_t('Please select at least one ticket.')).insertAfter('#registration_form table');return $.Deferred();}else{$button.attr('disabled',true);return ajax.jsonRpc($form.attr('action'),'call',post).then(function(modal){var $modal=$(modal);$modal.modal({backdrop:'static',keyboard:false});$modal.find('.modal-body > div').removeClass('container');$modal.insertAfter($form).modal();$modal.on('click','.js_goto_event',function(){$modal.modal('hide');$button.prop('disabled',false);});$modal.on('click','.close',function(){$button.prop('disabled',false);});});}},});return EventRegistrationForm;});;

/* /snippet_latest_posts/static/src/js/s_latest_posts_frontend.js defined in bundle 'web.assets_frontend' */
odoo.define('snippet_latest_posts.s_latest_posts_frontend',function(require){'use strict';var sAnimation=require('website.content.snippets.animation');sAnimation.registry.js_get_posts=sAnimation.Class.extend({selector:".js_get_posts",start:function(){this.redrow();return this._super.apply(this,arguments);},destroy:function(){this._super.apply(this,arguments);this.clean();},redrow:function(debug){this.clean(debug);this.build(debug);},clean:function(debug){this.$target.empty();},build:function(debug){var self=this,limit=self.$target.data("posts_limit"),blog_id=self.$target.data("filter_by_blog_id"),template=self.$target.data("template"),loading=self.$target.data("loading");self.$target.attr("contenteditable","False");if(!limit)limit=3;if(!template)template='snippet_latest_posts.media_list_template';var domain=[['website_published','=',true]];if(blog_id){domain.push(['blog_id','=',parseInt(blog_id)]);}
this._rpc({route:'/snippet_latest_posts/render',params:{template:template,domain:domain,limit:limit,},}).then(function(posts){if(loading&&loading===true){self.loading(posts,debug);}else{$(posts).appendTo(self.$target);}}).fail(function(e){return;});},loading:function(posts,debug){var self=this,$posts=$(posts);if(!$posts.first().find(".loading_container")&&!$posts.first().is(".loading_container")){console.log("loading_container dont exist??");if(debug){console.info("No '.loading_container' defined \n Please, add a 'loading_container' class to the element that must be filled by the loading bar");}}else if(!$posts.first().is(".thumb")&&!$posts.first().find(".thumb")){console.log("thumb dont exist??");if(debug){console.info("No '.thumb' defined \n Please, add a 'thumb' class to your thumbnail div");}}else{$posts.each(function(){var $post=$(this),$load_c=$post.find(".loading_container"),$thumb=$post.find(".thumb .o_blog_cover_image"),$progress=$('<div class="progress js-loading"><div class="progress-bar" role="progressbar" aria-valuenow="0" aria-valuemin="0" aria-valuemax="100" style="width:0;" /></div>');if($post.html()===undefined){return;}
if($load_c.length===0){$load_c=$post;}
if($thumb.length===0){$thumb=$post;}
$post.addClass("js-loading");$progress.appendTo($load_c);$post.appendTo(self.$target);var bg=$thumb.css('background-image').replace('url("','').replace('")',''),loaded=false;$progress.find(".progress-bar").css("width","50%").attr("aria-valuenow","50");var dummyImg=$('<img/>').attr('src',bg).load(function(){$progress.find(".progress-bar").find(".progress-bar").css("width","100%").attr("aria-valuenow","100");setTimeout(function(){self.showPost($post,$progress);},500);$(this).remove();loaded=true;});setTimeout(function(){if(loaded===false){dummyImg.remove();self.showPost($post,$progress);}},5000);});}},showPost:function($post,$progress){$post.removeClass("js-loading");$progress.fadeOut(500);},});});;

/* /website_enterprise/static/src/js/website_enterprise.js defined in bundle 'web.assets_frontend' */
odoo.define('website.app_switcher',function(require){'use strict';var session=require('web.session');var websiteNavbarData=require('website.navbar');websiteNavbarData.WebsiteNavbar.include({events:_.extend({},websiteNavbarData.WebsiteNavbar.prototype.events||{},{'click .o_menu_toggle':'_onMenuToggleClick',}),_onMenuToggleClick:function(ev){ev.preventDefault();var $button=$(ev.currentTarget);if(!$button.hasClass('fa')){return;}
$button.removeClass('fa fa-th').append($('<span/>',{'class':'fa fa-spin fa-spinner'}));var url='/web#home';window.location.href=session.debug?$.param.querystring(url,{debug:session.debug}):url;},});});;

/* /website_helpdesk/static/src/js/website_helpdesk.menu.js defined in bundle 'web.assets_frontend' */
odoo.define("website_helpdesk.menu",function(require){"use strict";require("web.dom_ready");var pathname=$(window.location).attr("pathname");var $link=$(".team_menu li a");if(pathname!=="/helpdesk/"){$link=$link.filter("[href$='"+pathname+"']");}
$link.first().closest("li").addClass("active");});;

/* /website_sale_coupon/static/src/js/website_sale_coupon.test.js defined in bundle 'web.assets_frontend' */
odoo.define('website_sale_coupon.test',function(require){'use strict';require("website_sale.tour");var tour=require("web_tour.tour");var base=require("web_editor.base");var ajax=require('web.ajax');tour.register('shop_sale_coupon',{test:true,url:'/shop',wait_for:base.ready()},[{content:"open customize menu",trigger:'#customize-menu > a',},{content:"click on 'Show # found'",trigger:"#customize-menu a:contains(Show # found)",run:function(){if(!$('#customize-menu a:contains(Show # found) input').prop('checked')){$('#customize-menu a:contains(Show # found)').click();}},},{content:"type iPad Mini in search",trigger:'form input[name="search"]',run:"text iPad Mini",},{content:"start search",trigger:'form:has(input[name="search"]) .oe_search_button',},{content:"select iPad Mini",extra_trigger:'.oe_search_found',trigger:'.oe_product_cart a:contains("iPad Mini")',},{content:"add 2 iPad Mini into cart",trigger:'#product_details input[name="add_qty"]',run:"text 2",},{content:"click on 'Add to Cart' button",trigger:"a:contains(Add to Cart)",},{content:"open customize menu",extra_trigger:'.oe_website_sale .oe_cart',trigger:'#customize-menu > a',},{content:"click on 'Promo Code'",trigger:"#customize-menu a:contains(Promo Code)",run:function(){if(!$('#customize-menu a:contains(Promo Code) input').prop('checked')){$('#customize-menu a:contains(Promo Code)').click();}},},{content:"insert promo code '10pc'",extra_trigger:'form[name="coupon_code"]',trigger:'form[name="coupon_code"] input[name="promo"]',run:"text 10pc",},{content:"validate the coupon",trigger:'form[name="coupon_code"] .a-submit',},{content:"check reward product",trigger:'.reward_product:contains("10.0 % discount on total amount")',run:function(){},},{content:"go to shop",trigger:'.reward_product:contains("10.0 % discount on total amount")',run:function(){ajax.jsonRpc('/web/dataset/call','call',{model:'account.tax',method:'create',args:[{'name':'15% tax incl','amount':15,}],}).then(function(tax_id){ajax.jsonRpc('/web/dataset/call','call',{model:'product.template',method:'create',args:[{'name':'Taxed Product','taxes_id':[([6,false,[tax_id]])],'list_price':100,'website_published':true,}],}).then(function(data){location.href='/shop';});});},},{content:"type Taxed Product in search",trigger:'form input[name="search"]',run:"text Taxed Product",},{content:"start search",trigger:'form:has(input[name="search"]) .oe_search_button',},{content:"select Taxed Product",extra_trigger:'.oe_search_found',trigger:'.oe_product_cart a:containsExact("Taxed Product")',},{content:"click on 'Add to Cart' button",trigger:"a:contains(Add to Cart)",},{content:"check reduction amount got recomputed and merged both discount lines into one only",extra_trigger:'.oe_currency_value:contains("-﻿74.00"):not(#cart_total .oe_currency_value:contains("-﻿74.00"))',trigger:'.oe_website_sale .oe_cart',run:function(){},},{content:"add one iPad",trigger:'#cart_products input.js_quantity',run:"text 3",},{content:"check reduction amount got recomputed when changing qty",trigger:'.oe_currency_value:contains("-﻿106.00")',run:function(){},},{content:"add more iPad Mini into cart",trigger:'#cart_products input.js_quantity',run:"text 4",},{content:"check free product is added",trigger:'#wrap:has(.reward_product:contains("Free Product - iPad Mini"))',run:function(){},},{content:"remove one iPad from cart",trigger:'#cart_products input.js_quantity[value="4"]',run:"text 3",},{content:"check free product is removed",trigger:'#wrap:not(:has(.reward_product:contains("Free Product - iPad Mini")))',run:function(){},},{content:"go to checkout",trigger:'a[href="/shop/checkout"]',},{content:"Confirm checkout",extra_trigger:"div.all_shipping .panel",trigger:'a[href="/shop/confirm_order"]',},{content:"check total is unchanged once we land on payment page",extra_trigger:'#payment_method h3:contains("Pay with")',trigger:'.oe_currency_value:contains("967.50")',run:function(){},},]);if('website_sale_options.website_sale'in odoo.__DEBUG__.services){var steps=tour.tours.shop_sale_coupon.steps;for(var k=0;k<steps.length;k++){if(steps[k].content==="click on 'Add to Cart' button"){steps.splice(k+1,0,{content:"click in modal on 'Proceed to Checkout' button",trigger:'a:contains("Proceed to Checkout")',});}}}});;

/* /website_event_sale/static/src/js/website.tour.event_sale.js defined in bundle 'web.assets_frontend' */
odoo.define('website_event_sale.tour',function(require){'use strict';var tour=require('web_tour.tour');var base=require("web_editor.base");tour.register('event_buy_tickets',{test:true,url:'/event',wait_for:base.ready()},[{content:"Go to the `Events` page",trigger:'a[href*="/event"]:contains("Conference on Business Apps"):first',},{content:"Select 1 unit of `Standard` ticket type",extra_trigger:'#wrap:not(:has(a[href*="/event"]:contains("Conference on Business Apps")))',trigger:'select:eq(0)',run:'text 1',},{content:"Select 2 units of `VIP` ticket type",extra_trigger:'select:eq(0):has(option:contains(1):propSelected)',trigger:'select:eq(1)',run:'text 2',},{content:"Click on `Order Now` button",extra_trigger:'select:eq(1):has(option:contains(2):propSelected)',trigger:'.btn-primary:contains("Register Now")',},{content:"Fill attendees details",trigger:'form[id="attendee_registration"] .btn:contains("Continue")',run:function(){$("input[name='1-name']").val("Att1");$("input[name='1-phone']").val("111 111");$("input[name='1-email']").val("att1@example.com");$("input[name='2-name']").val("Att2");$("input[name='2-phone']").val("222 222");$("input[name='2-email']").val("att2@example.com");$("input[name='3-name']").val("Att3");$("input[name='3-phone']").val("333 333");$("input[name='3-email']").val("att3@example.com");},},{content:"Validate attendees details",extra_trigger:"input[name='1-name'], input[name='2-name'], input[name='3-name']",trigger:'button:contains("Continue")',},{content:"Check that the cart contains exactly 3 triggers",trigger:'a:has(.my_cart_quantity:containsExact(3))',run:function(){},},{content:"go to cart",trigger:'a:contains(Return to Cart)',},{content:"Modify the cart to add 1 unit of `VIP` ticket type",extra_trigger:"#cart_products:contains(Standard):contains(VIP)",trigger:"#cart_products tr:contains(VIP) .fa-plus",},{content:"Now click on `Process Checkout`",extra_trigger:'a:has(.my_cart_quantity):contains(4)',trigger:'.btn-primary:contains("Process Checkout")'},{content:"Complete the checkout",trigger:'a[href="/shop/confirm_order"]:contains("Confirm")',},{content:"Check that the subtotal is 5,500.00 USD",trigger:'#order_total_untaxed .oe_currency_value:contains("5,500.00")',run:function(){},},{content:"Select `Wire Transfer` payment method",trigger:'#payment_method label:contains("Wire Transfer")',},{content:"Pay",extra_trigger:'#payment_method label:contains("Wire Transfer") input:checked,#payment_method:not(:has("input:radio:visible"))',trigger:'button[id="o_payment_form_pay"]:visible',},{content:"Last step",trigger:'.oe_website_sale:contains("Thank you for your order")',timeout:30000,}]);});;

/* /survey/static/src/js/survey.js defined in bundle 'web.assets_frontend' */
odoo.define('survey.survey',function(require){'use strict';require('web.dom_ready');var core=require('web.core');var time=require('web.time');var ajax=require('web.ajax');var base=require('web_editor.base');var context=require('web_editor.context');var field_utils=require('web.field_utils');var _t=core._t;var the_form=$('.js_surveyform');if(!the_form.length){return $.Deferred().reject("DOM doesn't contain '.js_surveyform'");}
console.debug("[survey] Custom JS for survey is loading...");var prefill_controller=the_form.attr("data-prefill");var submit_controller=the_form.attr("data-submit");var scores_controller=the_form.attr("data-scores");var print_mode=false;var quiz_correction_mode=false;if(_.isUndefined(submit_controller)){$(".js_surveyform .input-group-addon span.fa-calendar").css("pointer-events","none");$('.js_surveyform :input').prop('disabled',true);print_mode=true;}
if(!_.isUndefined(scores_controller)){quiz_correction_mode=true;}
$('.js_comments>input[type="text"]').focusin(function(){$(this).prev().find('>input').attr("checked","checked");});$('.js_radio input[type="radio"][data-oe-survey-otherr!="1"]').click(function(){$(this).closest('.js_radio').find('.js_comments>input[type="text"]').val("");});$('.js_comments input[type="radio"]').click(function(){$(this).closest('.js_comments').find('>input[data-oe-survey-othert="1"]').focus();});$('.js_drop input[data-oe-survey-othert="1"]').hide();$('.js_drop select').change(function(){var other_val=$(this).find('.js_other_option').val();if($(this).val()===other_val){$(this).parent().removeClass('col-md-12').addClass('col-md-6');$(this).closest('.js_drop').find('input[data-oe-survey-othert="1"]').show().focus();}
else{$(this).parent().removeClass('col-md-6').addClass('col-md-12');$(this).closest('.js_drop').find('input[data-oe-survey-othert="1"]').val("").hide();}});$('.js_ck_comments>input[type="text"]').focusin(function(){$(this).prev().find('>input').attr("checked","checked");});$('.js_ck_comments input[type="checkbox"]').change(function(){if(!$(this).prop("checked")){$(this).closest('.js_ck_comments').find('input[type="text"]').val("");}});function prefill(){if(!_.isUndefined(prefill_controller)){var prefill_def=$.ajax(prefill_controller,{dataType:"json"}).done(function(json_data){_.each(json_data,function(value,key){var input=the_form.find(".form-control[name="+key+"]");if(input.attr('date')){var moment_date=field_utils.parse.date(value[0]);value=field_utils.format.date(moment_date,null,{timezone:true});}
input.val(value);if(_.string.endsWith(key,"_comment")&&(input.parent().hasClass("js_comments")||input.parent().hasClass("js_ck_comments"))){input.siblings().find('>input').attr("checked","checked");}
the_form.find("input[name^='"+key+"_'][type='checkbox']").each(function(){$(this).val(value);});the_form.find("input[name="+key+"][type!='text']").each(function(){$(this).val(value);});});}).fail(function(){console.warn("[survey] Unable to load prefill data");});return prefill_def;}}
function display_scores(){if(!_.isUndefined(scores_controller)){var score_def=$.ajax(scores_controller,{dataType:"json"}).done(function(json_data){_.each(json_data,function(value,key){the_form.find("span[data-score-question="+key+"]").text("Your score: "+value);});}).fail(function(){console.warn("[survey] Unable to load score data");});return score_def;}}
$('.js_surveyform').ajaxForm({url:submit_controller,type:'POST',dataType:'json',beforeSubmit:function(formData,$form,options){var date_fields=$form.find('div.date > input.form-control');for(var i=0;i<date_fields.length;i++){var el=date_fields[i];var moment_date=$(el).data('DateTimePicker').date();if(moment_date){moment_date.toJSON=function(){return this.clone().locale('en').format('YYYY-MM-DD');};}
var field_obj=_.findWhere(formData,{'name':el.name});field_obj.value=JSON.parse(JSON.stringify(moment_date));}
$('.js_errzone').html("").hide();},success:function(response,status,xhr,wfe){if(_.has(response,'errors')){_.each(_.keys(response.errors),function(key){$("#"+key+'>.js_errzone').append($('<p>',{'text':response.errors[key]})).show();});return false;}
else if(_.has(response,'redirect')){window.location.replace(response.redirect);return true;}
else{console.error("Incorrect answer sent by server");return false;}},timeout:5000,error:function(jqXHR,textStatus,errorThrown){$('#AJAXErrorModal').modal('show');}});function load_locale(){var url="/web/webclient/locale/"+context.get().lang||'en_US';return ajax.loadJS(url);}
var ready_with_locale=$.when(base.ready(),load_locale());ready_with_locale.then(function(){$('.form-control.date').datetimepicker({format:time.getLangDateFormat(),minDate:moment({y:1900}),maxDate:moment().add(200,"y"),calendarWeeks:true,icons:{time:'fa fa-clock-o',date:'fa fa-calendar',next:'fa fa-chevron-right',previous:'fa fa-chevron-left',up:'fa fa-chevron-up',down:'fa fa-chevron-down',},locale:moment.locale(),allowInputToggle:true,keyBinds:null,});});prefill();if(quiz_correction_mode===true){display_scores();}
console.debug("[survey] Custom JS for survey loaded!");});;

/* /survey/static/src/js/tour_test_survey.js defined in bundle 'web.assets_frontend' */
odoo.define('survey.tour_test_survey',function(require){'use strict';var tour=require('web_tour.tour');var base=require("web_editor.base");tour.register('test_survey',{test:true,url:'/survey/start/user-feedback-form-1/phantom',wait_for:base.ready()},[{content:"Clicking on Start Survey",trigger:'a.btn.btn-primary.btn-lg:contains("Start Survey")',},{content:"Selecting answer 'Yes, I use a version < 7.0'",trigger:'select[name="1_1_1"]',run:'text 1',},{content:"Ticking answer 'Sales Management'",trigger:'input[name="1_1_2_5"][value="5"]',run:'text 5',},{content:"Clicking on Next Page",trigger:'button[value="next"]',},{content:"For 'It is up-to-date' checking 'Totally disagree'",trigger:'input[name="1_2_3_15"][value="11"]',run:'text 11',},{content:"For 'It helps in the beginning' ckecking 'Disagree'",trigger:'input[name="1_2_3_16"][value="12"]',run:'text 12',},{content:"For 'I use the contextual help in Odoo' checking 'Agree'",trigger:'input[name="1_2_3_17"][value="13"]',run:'text 13',},{content:"For 'It is complete' checking 'Totally disagree'",trigger:'input[name="1_2_3_18"][value="11"]',run:'text 11',},{content:"For 'It is clear' checking 'Disagree'",trigger:'input[name="1_2_3_19"][value="12"]',run:'text 12',},{content:"For 'They help new users to understand Odoo' checking 'Totally disagree'",trigger:'input[name="1_2_4_24"][value="20"]',run:'text 20',},{content:"For 'They are clean and correct' checking 'Totally disagree'",trigger:'input[name="1_2_4_25"][value="20"]',run:'text 20',},{content:"For 'They are useful on a daily usage' checking 'Totally disagree'",trigger:'input[name="1_2_4_26"][value="20"]',run:'text 20',},{content:"For 'A process is defined for all enterprise flows' checking 'Disagree'",trigger:'input[name="1_2_4_27"][value="21"]',run:'text 21',},{content:"For 'It's easy to find the process you need' checking 'Agree'",trigger:'input[name="1_2_4_28"][value="22"]',run:'text 22',},{content:"Writing answer",trigger:'textarea[name="1_2_5"]',run:'text I do not want to provide any suggestions.',},{content:"Checking 'It can be improved'",trigger:'input[name="1_2_6_30"][value="30"]',run:'text 30',},{content:"For 'The security rules defined on groups are useful' checking 'Agree'",trigger:'input[name="1_2_7_36"][value="32"]',run:'text 32',},{content:"For 'Those security rules are standard and can be used out-of-the-box in most cases' checking 'Totally agree'",trigger:'input[name="1_2_7_37"][value="35"]',run:'text 35',},{content:"For 'The 'Usability/Extended View' group helps in daily work' checking 'Totally agree'",trigger:'input[name="1_2_7_38"][value="35"]',run:'text 35',},{content:"For 'The 'Usability/Extended View' group hides only optional fields' checking 'Totally agree'",trigger:'input[name="1_2_7_39"][value="33"]',run:'text 33',},{content:"For 'The groups set on menu items are relevant' checking 'Totally disagree'",trigger:'input[name="1_2_7_40"][value="32"]',run:'text 32',},{content:"Checking 'There are too few groups defined, security isn't accurate enough'",trigger:'input[name="1_2_8"][value="42"]',run:'text 42',},{content:"For 'Descriptions and help tooltips are clear enough' checking 'Agree'",trigger:'input[name="1_2_9_48"][value="46"]',run:'text 46',},{content:"For 'Configuration wizard exists for each important setting' checking 'Agree'",trigger:'input[name="1_2_9_49"][value="46"]',run:'text 46',},{content:"For 'Extra modules proposed are relevant' checking 'Totally agree'",trigger:'input[name="1_2_9_50"][value="47"]',run:'text 47',},{content:"For 'Running the configuration wizards is a good way to spare time' checking 'Totally disagree'",trigger:'input[name="1_2_9_51"][value="44"]',run:'text 44',},{content:"Clicking on Next Page",trigger:'button[value="next"]',},{content:"Checking 'I would like to contribute but I don not know how?'",trigger:'input[name="1_3_10_53"][value="53"]',run:'text 53',},{content:"Writing answer",trigger:'textarea[name="1_3_11"]',run:'text No. I do not have any proposition to help people to contribute.',},{content:"Writing answer",trigger:'textarea[name="1_3_12"]',run:'text No. I do not have any proposition to Attract new contributors.',},{content:"Clicking on Next Page",trigger:'button[value="next"]',},{content:"Checking 'I host them on my own website'",trigger:'input[name="1_4_13_59"][value="59"]',run:'text 59',},{content:"Finish Survey",trigger:'button[value="finish"]',},{content:"Thank you",trigger:'h1:contains("Thank you!")',}]);});;

/* /web/static/src/js/fields/field_utils.js defined in bundle 'web.assets_frontend' */
odoo.define('web.field_utils',function(require){"use strict";var core=require('web.core');var dom=require('web.dom');var session=require('web.session');var time=require('web.time');var utils=require('web.utils');var _t=core._t;function formatBinary(value,field,options){if(!value){return'';}
return utils.binaryToBinsize(value);}
function formatBoolean(value,field,options){if(options&&options.forceString){return value?_t('True'):_t('False');}
return dom.renderCheckbox({prop:{checked:value,disabled:true,},});}
function formatChar(value,field,options){value=typeof value==='string'?value:'';if(options&&options.isPassword){return _.str.repeat('*',value?value.length:0);}
if(options&&options.escape){value=_.escape(value);}
return value;}
function formatDate(value,field,options){if(value===false){return"";}
if(field&&field.type==='datetime'){if(!options||!('timezone'in options)||options.timezone){value=value.clone().add(session.getTZOffset(value),'minutes');}}
var date_format=time.getLangDateFormat();return value.format(date_format);}
function formatDateTime(value,field,options){if(value===false){return"";}
if(!options||!('timezone'in options)||options.timezone){value=value.clone().add(session.getTZOffset(value),'minutes');}
return value.format(time.getLangDatetimeFormat());}
function formatFloat(value,field,options){if(value===false){return"";}
var l10n=core._t.database.parameters;var precision;if(options&&options.digits){precision=options.digits[1];}else if(field&&field.digits){precision=field.digits[1];}else{precision=2;}
var formatted=_.str.sprintf('%.'+precision+'f',value||0).split('.');formatted[0]=utils.insert_thousand_seps(formatted[0]);return formatted.join(l10n.decimal_point);}
function formatFloatTime(value){var pattern='%02d:%02d';if(value<0){value=Math.abs(value);pattern='-'+pattern;}
var hour=Math.floor(value);var min=Math.round((value%1)*60);if(min===60){min=0;hour=hour+1;}
return _.str.sprintf(pattern,hour,min);}
function formatInteger(value,field,options){if(options&&options.isPassword){return _.str.repeat('*',String(value).length);}
if(!value&&value!==0){return"";}
return utils.insert_thousand_seps(_.str.sprintf('%d',value));}
function formatMany2one(value,field,options){value=value&&(_.isArray(value)?value[1]:value.data.display_name)||'';if(options&&options.escape){value=_.escape(value);}
return value;}
function formatX2Many(value){if(value.data.length===0){return _t('No records');}else if(value.data.length===1){return _t('1 record');}else{return value.data.length+_t(' records');}}
function formatMonetary(value,field,options){if(value===false){return"";}
options=options||{};var currency=options.currency;if(!currency){var currency_id=options.currency_id;if(!currency_id&&options.data){var currency_field=options.currency_field||field.currency_field||'currency_id';currency_id=options.data[currency_field]&&options.data[currency_field].res_id;}
currency=session.get_currency(currency_id);}
var digits=(currency&&currency.digits)||options.digits;if(options.field_digits===true){digits=field.digits||digits;}
var formatted_value=formatFloat(value,field,{digits:digits,});if(!currency||options.noSymbol){return formatted_value;}
if(currency.position==="after"){return formatted_value+='&nbsp;'+currency.symbol;}else{return currency.symbol+'&nbsp;'+formatted_value;}}
function formatSelection(value,field,options){var val=_.find(field.selection,function(option){return option[0]===value;});if(!val){return'';}
value=val[1];if(options&&options.escape){value=_.escape(value);}
return value;}
function parseDate(value,field,options){if(!value){return false;}
var datePattern=time.getLangDateFormat();var datePatternWoZero=datePattern.replace('MM','M').replace('DD','D');var date;if(options&&options.isUTC){date=moment.utc(value);}else{date=moment.utc(value,[datePattern,datePatternWoZero,moment.ISO_8601],true);}
if(date.isValid()){if(date.year()===0){date.year(moment.utc().year());}
if(date.year()>=1900){date.toJSON=function(){return this.clone().locale('en').format('YYYY-MM-DD');};return date;}}
throw new Error(_.str.sprintf(core._t("'%s' is not a correct date"),value));}
function parseDateTime(value,field,options){if(!value){return false;}
var datePattern=time.getLangDateFormat(),timePattern=time.getLangTimeFormat();var datePatternWoZero=datePattern.replace('MM','M').replace('DD','D'),timePatternWoZero=timePattern.replace('HH','H').replace('mm','m').replace('ss','s');var pattern1=datePattern+' '+timePattern;var pattern2=datePatternWoZero+' '+timePatternWoZero;var datetime;if(options&&options.isUTC){datetime=moment.utc(value.replace(' ','T')+'Z');}else{datetime=moment.utc(value,[pattern1,pattern2,moment.ISO_8601],true);if(options&&options.timezone){datetime.add(-session.getTZOffset(datetime),'minutes');}}
if(datetime.isValid()){if(datetime.year()===0){datetime.year(moment.utc().year());}
if(datetime.year()>=1900){datetime.toJSON=function(){return this.clone().locale('en').format('YYYY-MM-DD HH:mm:ss');};return datetime;}}
throw new Error(_.str.sprintf(core._t("'%s' is not a correct datetime"),value));}
function parseNumber(value){if(core._t.database.parameters.thousands_sep){var escapedSep=_.str.escapeRegExp(core._t.database.parameters.thousands_sep);value=value.replace(new RegExp(escapedSep,'g'),'');}
if(core._t.database.parameters.decimal_point){value=value.replace(core._t.database.parameters.decimal_point,'.');}
return Number(value);}
function parseFloat(value){var parsed=parseNumber(value);if(isNaN(parsed)){throw new Error(_.str.sprintf(core._t("'%s' is not a correct float"),value));}
return parsed;}
function parseMonetary(value,field,options){var values=value.split('&nbsp;');if(values.length===1){return parseFloat(value);}
else if(values.length!==2){throw new Error(_.str.sprintf(core._t("'%s' is not a correct monetary field"),value));}
options=options||{};var currency=options.currency;if(!currency){var currency_id=options.currency_id;if(!currency_id&&options.data){var currency_field=options.currency_field||field.currency_field||'currency_id';currency_id=options.data[currency_field]&&options.data[currency_field].res_id;}
currency=session.get_currency(currency_id);}
return parseFloat(values[0]===currency.symbol?values[1]:values[0]);}
function parseFloatTime(value){var factor=1;if(value[0]==='-'){value=value.slice(1);factor=-1;}
var float_time_pair=value.split(":");if(float_time_pair.length!==2)
return factor*parseFloat(value);var hours=parseInteger(float_time_pair[0]);var minutes=parseInteger(float_time_pair[1]);return factor*(hours+(minutes/60));}
function parseInteger(value){var parsed=parseNumber(value);if(isNaN(parsed)||parsed%1||parsed<-2147483648||parsed>2147483647){throw new Error(_.str.sprintf(core._t("'%s' is not a correct integer"),value));}
return parsed;}
function parseMany2one(value){if(_.isArray(value)){return{id:value[0],display_name:value[1],};}
if(_.isNumber(value)||_.isString(value)){return{id:parseInt(value,10),};}
return value;}
return{format:{binary:formatBinary,boolean:formatBoolean,char:formatChar,date:formatDate,datetime:formatDateTime,float:formatFloat,float_time:formatFloatTime,html:_.identity,integer:formatInteger,many2many:formatX2Many,many2one:formatMany2one,monetary:formatMonetary,one2many:formatX2Many,reference:formatMany2one,selection:formatSelection,text:formatChar,},parse:{binary:_.identity,boolean:_.identity,char:_.identity,date:parseDate,datetime:parseDateTime,float:parseFloat,float_time:parseFloatTime,html:_.identity,integer:parseInteger,many2many:_.identity,many2one:parseMany2one,monetary:parseMonetary,one2many:_.identity,reference:parseMany2one,selection:_.identity,text:_.identity,},};});;

/* /web/static/lib/nvd3/d3.v3.js defined in bundle 'web.assets_frontend' */
!function(){var d3={version:"3.5.6"};var d3_arraySlice=[].slice,d3_array=function(list){return d3_arraySlice.call(list);};var d3_document=this.document;function d3_documentElement(node){return node&&(node.ownerDocument||node.document||node).documentElement;}
function d3_window(node){return node&&(node.ownerDocument&&node.ownerDocument.defaultView||node.document&&node||node.defaultView);}
if(d3_document){try{d3_array(d3_document.documentElement.childNodes)[0].nodeType;}catch(e){d3_array=function(list){var i=list.length,array=new Array(i);while(i--)array[i]=list[i];return array;};}}
if(!Date.now)Date.now=function(){return+new Date();};if(d3_document){try{d3_document.createElement("DIV").style.setProperty("opacity",0,"");}catch(error){var d3_element_prototype=this.Element.prototype,d3_element_setAttribute=d3_element_prototype.setAttribute,d3_element_setAttributeNS=d3_element_prototype.setAttributeNS,d3_style_prototype=this.CSSStyleDeclaration.prototype,d3_style_setProperty=d3_style_prototype.setProperty;d3_element_prototype.setAttribute=function(name,value){d3_element_setAttribute.call(this,name,value+"");};d3_element_prototype.setAttributeNS=function(space,local,value){d3_element_setAttributeNS.call(this,space,local,value+"");};d3_style_prototype.setProperty=function(name,value,priority){d3_style_setProperty.call(this,name,value+"",priority);};}}
d3.ascending=d3_ascending;function d3_ascending(a,b){return a<b?-1:a>b?1:a>=b?0:NaN;}
d3.descending=function(a,b){return b<a?-1:b>a?1:b>=a?0:NaN;};d3.min=function(array,f){var i=-1,n=array.length,a,b;if(arguments.length===1){while(++i<n)if((b=array[i])!=null&&b>=b){a=b;break;}
while(++i<n)if((b=array[i])!=null&&a>b)a=b;}else{while(++i<n)if((b=f.call(array,array[i],i))!=null&&b>=b){a=b;break;}
while(++i<n)if((b=f.call(array,array[i],i))!=null&&a>b)a=b;}
return a;};d3.max=function(array,f){var i=-1,n=array.length,a,b;if(arguments.length===1){while(++i<n)if((b=array[i])!=null&&b>=b){a=b;break;}
while(++i<n)if((b=array[i])!=null&&b>a)a=b;}else{while(++i<n)if((b=f.call(array,array[i],i))!=null&&b>=b){a=b;break;}
while(++i<n)if((b=f.call(array,array[i],i))!=null&&b>a)a=b;}
return a;};d3.extent=function(array,f){var i=-1,n=array.length,a,b,c;if(arguments.length===1){while(++i<n)if((b=array[i])!=null&&b>=b){a=c=b;break;}
while(++i<n)if((b=array[i])!=null){if(a>b)a=b;if(c<b)c=b;}}else{while(++i<n)if((b=f.call(array,array[i],i))!=null&&b>=b){a=c=b;break;}
while(++i<n)if((b=f.call(array,array[i],i))!=null){if(a>b)a=b;if(c<b)c=b;}}
return[a,c];};function d3_number(x){return x===null?NaN:+x;}
function d3_numeric(x){return!isNaN(x);}
d3.sum=function(array,f){var s=0,n=array.length,a,i=-1;if(arguments.length===1){while(++i<n)if(d3_numeric(a=+array[i]))s+=a;}else{while(++i<n)if(d3_numeric(a=+f.call(array,array[i],i)))s+=a;}
return s;};d3.mean=function(array,f){var s=0,n=array.length,a,i=-1,j=n;if(arguments.length===1){while(++i<n)if(d3_numeric(a=d3_number(array[i])))s+=a;else--j;}else{while(++i<n)if(d3_numeric(a=d3_number(f.call(array,array[i],i))))s+=a;else--j;}
if(j)return s/j;};d3.quantile=function(values,p){var H=(values.length-1)*p+1,h=Math.floor(H),v=+values[h-1],e=H-h;return e?v+e*(values[h]-v):v;};d3.median=function(array,f){var numbers=[],n=array.length,a,i=-1;if(arguments.length===1){while(++i<n)if(d3_numeric(a=d3_number(array[i])))numbers.push(a);}else{while(++i<n)if(d3_numeric(a=d3_number(f.call(array,array[i],i))))numbers.push(a);}
if(numbers.length)return d3.quantile(numbers.sort(d3_ascending),.5);};d3.variance=function(array,f){var n=array.length,m=0,a,d,s=0,i=-1,j=0;if(arguments.length===1){while(++i<n){if(d3_numeric(a=d3_number(array[i]))){d=a-m;m+=d/++j;s+=d*(a-m);}}}else{while(++i<n){if(d3_numeric(a=d3_number(f.call(array,array[i],i)))){d=a-m;m+=d/++j;s+=d*(a-m);}}}
if(j>1)return s/(j-1);};d3.deviation=function(){var v=d3.variance.apply(this,arguments);return v?Math.sqrt(v):v;};function d3_bisector(compare){return{left:function(a,x,lo,hi){if(arguments.length<3)lo=0;if(arguments.length<4)hi=a.length;while(lo<hi){var mid=lo+hi>>>1;if(compare(a[mid],x)<0)lo=mid+1;else hi=mid;}
return lo;},right:function(a,x,lo,hi){if(arguments.length<3)lo=0;if(arguments.length<4)hi=a.length;while(lo<hi){var mid=lo+hi>>>1;if(compare(a[mid],x)>0)hi=mid;else lo=mid+1;}
return lo;}};}
var d3_bisect=d3_bisector(d3_ascending);d3.bisectLeft=d3_bisect.left;d3.bisect=d3.bisectRight=d3_bisect.right;d3.bisector=function(f){return d3_bisector(f.length===1?function(d,x){return d3_ascending(f(d),x);}:f);};d3.shuffle=function(array,i0,i1){if((m=arguments.length)<3){i1=array.length;if(m<2)i0=0;}
var m=i1-i0,t,i;while(m){i=Math.random()*m--|0;t=array[m+i0],array[m+i0]=array[i+i0],array[i+i0]=t;}
return array;};d3.permute=function(array,indexes){var i=indexes.length,permutes=new Array(i);while(i--)permutes[i]=array[indexes[i]];return permutes;};d3.pairs=function(array){var i=0,n=array.length-1,p0,p1=array[0],pairs=new Array(n<0?0:n);while(i<n)pairs[i]=[p0=p1,p1=array[++i]];return pairs;};d3.zip=function(){if(!(n=arguments.length))return[];for(var i=-1,m=d3.min(arguments,d3_zipLength),zips=new Array(m);++i<m;){for(var j=-1,n,zip=zips[i]=new Array(n);++j<n;){zip[j]=arguments[j][i];}}
return zips;};function d3_zipLength(d){return d.length;}
d3.transpose=function(matrix){return d3.zip.apply(d3,matrix);};d3.keys=function(map){var keys=[];for(var key in map)keys.push(key);return keys;};d3.values=function(map){var values=[];for(var key in map)values.push(map[key]);return values;};d3.entries=function(map){var entries=[];for(var key in map)entries.push({key:key,value:map[key]});return entries;};d3.merge=function(arrays){var n=arrays.length,m,i=-1,j=0,merged,array;while(++i<n)j+=arrays[i].length;merged=new Array(j);while(--n>=0){array=arrays[n];m=array.length;while(--m>=0){merged[--j]=array[m];}}
return merged;};var abs=Math.abs;d3.range=function(start,stop,step){if(arguments.length<3){step=1;if(arguments.length<2){stop=start;start=0;}}
if((stop-start)/step===Infinity)throw new Error("infinite range");var range=[],k=d3_range_integerScale(abs(step)),i=-1,j;start*=k,stop*=k,step*=k;if(step<0)while((j=start+step*++i)>stop)range.push(j/k);else while((j=start+step*++i)<stop)range.push(j/k);return range;};function d3_range_integerScale(x){var k=1;while(x*k%1)k*=10;return k;}
function d3_class(ctor,properties){for(var key in properties){Object.defineProperty(ctor.prototype,key,{value:properties[key],enumerable:false});}}
d3.map=function(object,f){var map=new d3_Map();if(object instanceof d3_Map){object.forEach(function(key,value){map.set(key,value);});}else if(Array.isArray(object)){var i=-1,n=object.length,o;if(arguments.length===1)while(++i<n)map.set(i,object[i]);else while(++i<n)map.set(f.call(object,o=object[i],i),o);}else{for(var key in object)map.set(key,object[key]);}
return map;};function d3_Map(){this._=Object.create(null);}
var d3_map_proto="__proto__",d3_map_zero="\x00";d3_class(d3_Map,{has:d3_map_has,get:function(key){return this._[d3_map_escape(key)];},set:function(key,value){return this._[d3_map_escape(key)]=value;},remove:d3_map_remove,keys:d3_map_keys,values:function(){var values=[];for(var key in this._)values.push(this._[key]);return values;},entries:function(){var entries=[];for(var key in this._)entries.push({key:d3_map_unescape(key),value:this._[key]});return entries;},size:d3_map_size,empty:d3_map_empty,forEach:function(f){for(var key in this._)f.call(this,d3_map_unescape(key),this._[key]);}});function d3_map_escape(key){return(key+="")===d3_map_proto||key[0]===d3_map_zero?d3_map_zero+key:key;}
function d3_map_unescape(key){return(key+="")[0]===d3_map_zero?key.slice(1):key;}
function d3_map_has(key){return d3_map_escape(key)in this._;}
function d3_map_remove(key){return(key=d3_map_escape(key))in this._&&delete this._[key];}
function d3_map_keys(){var keys=[];for(var key in this._)keys.push(d3_map_unescape(key));return keys;}
function d3_map_size(){var size=0;for(var key in this._)++size;return size;}
function d3_map_empty(){for(var key in this._)return false;return true;}
d3.nest=function(){var nest={},keys=[],sortKeys=[],sortValues,rollup;function map(mapType,array,depth){if(depth>=keys.length)return rollup?rollup.call(nest,array):sortValues?array.sort(sortValues):array;var i=-1,n=array.length,key=keys[depth++],keyValue,object,setter,valuesByKey=new d3_Map(),values;while(++i<n){if(values=valuesByKey.get(keyValue=key(object=array[i]))){values.push(object);}else{valuesByKey.set(keyValue,[object]);}}
if(mapType){object=mapType();setter=function(keyValue,values){object.set(keyValue,map(mapType,values,depth));};}else{object={};setter=function(keyValue,values){object[keyValue]=map(mapType,values,depth);};}
valuesByKey.forEach(setter);return object;}
function entries(map,depth){if(depth>=keys.length)return map;var array=[],sortKey=sortKeys[depth++];map.forEach(function(key,keyMap){array.push({key:key,values:entries(keyMap,depth)});});return sortKey?array.sort(function(a,b){return sortKey(a.key,b.key);}):array;}
nest.map=function(array,mapType){return map(mapType,array,0);};nest.entries=function(array){return entries(map(d3.map,array,0),0);};nest.key=function(d){keys.push(d);return nest;};nest.sortKeys=function(order){sortKeys[keys.length-1]=order;return nest;};nest.sortValues=function(order){sortValues=order;return nest;};nest.rollup=function(f){rollup=f;return nest;};return nest;};d3.set=function(array){var set=new d3_Set();if(array)for(var i=0,n=array.length;i<n;++i)set.add(array[i]);return set;};function d3_Set(){this._=Object.create(null);}
d3_class(d3_Set,{has:d3_map_has,add:function(key){this._[d3_map_escape(key+="")]=true;return key;},remove:d3_map_remove,values:d3_map_keys,size:d3_map_size,empty:d3_map_empty,forEach:function(f){for(var key in this._)f.call(this,d3_map_unescape(key));}});d3.behavior={};function d3_identity(d){return d;}
d3.rebind=function(target,source){var i=1,n=arguments.length,method;while(++i<n)target[method=arguments[i]]=d3_rebind(target,source,source[method]);return target;};function d3_rebind(target,source,method){return function(){var value=method.apply(source,arguments);return value===source?target:value;};}
function d3_vendorSymbol(object,name){if(name in object)return name;name=name.charAt(0).toUpperCase()+name.slice(1);for(var i=0,n=d3_vendorPrefixes.length;i<n;++i){var prefixName=d3_vendorPrefixes[i]+name;if(prefixName in object)return prefixName;}}
var d3_vendorPrefixes=["webkit","ms","moz","Moz","o","O"];function d3_noop(){}
d3.dispatch=function(){var dispatch=new d3_dispatch(),i=-1,n=arguments.length;while(++i<n)dispatch[arguments[i]]=d3_dispatch_event(dispatch);return dispatch;};function d3_dispatch(){}
d3_dispatch.prototype.on=function(type,listener){var i=type.indexOf("."),name="";if(i>=0){name=type.slice(i+1);type=type.slice(0,i);}
if(type)return arguments.length<2?this[type].on(name):this[type].on(name,listener);if(arguments.length===2){if(listener==null)for(type in this){if(this.hasOwnProperty(type))this[type].on(name,null);}
return this;}};function d3_dispatch_event(dispatch){var listeners=[],listenerByName=new d3_Map();function event(){var z=listeners,i=-1,n=z.length,l;while(++i<n)if(l=z[i].on)l.apply(this,arguments);return dispatch;}
event.on=function(name,listener){var l=listenerByName.get(name),i;if(arguments.length<2)return l&&l.on;if(l){l.on=null;listeners=listeners.slice(0,i=listeners.indexOf(l)).concat(listeners.slice(i+1));listenerByName.remove(name);}
if(listener)listeners.push(listenerByName.set(name,{on:listener}));return dispatch;};return event;}
d3.event=null;function d3_eventPreventDefault(){d3.event.preventDefault();}
function d3_eventSource(){var e=d3.event,s;while(s=e.sourceEvent)e=s;return e;}
function d3_eventDispatch(target){var dispatch=new d3_dispatch(),i=0,n=arguments.length;while(++i<n)dispatch[arguments[i]]=d3_dispatch_event(dispatch);dispatch.of=function(thiz,argumentz){return function(e1){try{var e0=e1.sourceEvent=d3.event;e1.target=target;d3.event=e1;dispatch[e1.type].apply(thiz,argumentz);}finally{d3.event=e0;}};};return dispatch;}
d3.requote=function(s){return s.replace(d3_requote_re,"\\$&");};var d3_requote_re=/[\\\^\$\*\+\?\|\[\]\(\)\.\{\}]/g;var d3_subclass={}.__proto__?function(object,prototype){object.__proto__=prototype;}:function(object,prototype){for(var property in prototype)object[property]=prototype[property];};function d3_selection(groups){d3_subclass(groups,d3_selectionPrototype);return groups;}
var d3_select=function(s,n){return n.querySelector(s);},d3_selectAll=function(s,n){return n.querySelectorAll(s);},d3_selectMatches=function(n,s){var d3_selectMatcher=n.matches||n[d3_vendorSymbol(n,"matchesSelector")];d3_selectMatches=function(n,s){return d3_selectMatcher.call(n,s);};return d3_selectMatches(n,s);};if(typeof Sizzle==="function"){d3_select=function(s,n){return Sizzle(s,n)[0]||null;};d3_selectAll=Sizzle;d3_selectMatches=Sizzle.matchesSelector;}
d3.selection=function(){return d3.select(d3_document.documentElement);};var d3_selectionPrototype=d3.selection.prototype=[];d3_selectionPrototype.select=function(selector){var subgroups=[],subgroup,subnode,group,node;selector=d3_selection_selector(selector);for(var j=-1,m=this.length;++j<m;){subgroups.push(subgroup=[]);subgroup.parentNode=(group=this[j]).parentNode;for(var i=-1,n=group.length;++i<n;){if(node=group[i]){subgroup.push(subnode=selector.call(node,node.__data__,i,j));if(subnode&&"__data__"in node)subnode.__data__=node.__data__;}else{subgroup.push(null);}}}
return d3_selection(subgroups);};function d3_selection_selector(selector){return typeof selector==="function"?selector:function(){return d3_select(selector,this);};}
d3_selectionPrototype.selectAll=function(selector){var subgroups=[],subgroup,node;selector=d3_selection_selectorAll(selector);for(var j=-1,m=this.length;++j<m;){for(var group=this[j],i=-1,n=group.length;++i<n;){if(node=group[i]){subgroups.push(subgroup=d3_array(selector.call(node,node.__data__,i,j)));subgroup.parentNode=node;}}}
return d3_selection(subgroups);};function d3_selection_selectorAll(selector){return typeof selector==="function"?selector:function(){return d3_selectAll(selector,this);};}
var d3_nsPrefix={svg:"http://www.w3.org/2000/svg",xhtml:"http://www.w3.org/1999/xhtml",xlink:"http://www.w3.org/1999/xlink",xml:"http://www.w3.org/XML/1998/namespace",xmlns:"http://www.w3.org/2000/xmlns/"};d3.ns={prefix:d3_nsPrefix,qualify:function(name){var i=name.indexOf(":"),prefix=name;if(i>=0){prefix=name.slice(0,i);name=name.slice(i+1);}
return d3_nsPrefix.hasOwnProperty(prefix)?{space:d3_nsPrefix[prefix],local:name}:name;}};d3_selectionPrototype.attr=function(name,value){if(arguments.length<2){if(typeof name==="string"){var node=this.node();name=d3.ns.qualify(name);return name.local?node.getAttributeNS(name.space,name.local):node.getAttribute(name);}
for(value in name)this.each(d3_selection_attr(value,name[value]));return this;}
return this.each(d3_selection_attr(name,value));};function d3_selection_attr(name,value){name=d3.ns.qualify(name);function attrNull(){this.removeAttribute(name);}
function attrNullNS(){this.removeAttributeNS(name.space,name.local);}
function attrConstant(){this.setAttribute(name,value);}
function attrConstantNS(){this.setAttributeNS(name.space,name.local,value);}
function attrFunction(){var x=value.apply(this,arguments);if(x==null)this.removeAttribute(name);else this.setAttribute(name,x);}
function attrFunctionNS(){var x=value.apply(this,arguments);if(x==null)this.removeAttributeNS(name.space,name.local);else this.setAttributeNS(name.space,name.local,x);}
return value==null?name.local?attrNullNS:attrNull:typeof value==="function"?name.local?attrFunctionNS:attrFunction:name.local?attrConstantNS:attrConstant;}
function d3_collapse(s){return s.trim().replace(/\s+/g," ");}
d3_selectionPrototype.classed=function(name,value){if(arguments.length<2){if(typeof name==="string"){var node=this.node(),n=(name=d3_selection_classes(name)).length,i=-1;if(value=node.classList){while(++i<n)if(!value.contains(name[i]))return false;}else{value=node.getAttribute("class");while(++i<n)if(!d3_selection_classedRe(name[i]).test(value))return false;}
return true;}
for(value in name)this.each(d3_selection_classed(value,name[value]));return this;}
return this.each(d3_selection_classed(name,value));};function d3_selection_classedRe(name){return new RegExp("(?:^|\\s+)"+d3.requote(name)+"(?:\\s+|$)","g");}
function d3_selection_classes(name){return(name+"").trim().split(/^|\s+/);}
function d3_selection_classed(name,value){name=d3_selection_classes(name).map(d3_selection_classedName);var n=name.length;function classedConstant(){var i=-1;while(++i<n)name[i](this,value);}
function classedFunction(){var i=-1,x=value.apply(this,arguments);while(++i<n)name[i](this,x);}
return typeof value==="function"?classedFunction:classedConstant;}
function d3_selection_classedName(name){var re=d3_selection_classedRe(name);return function(node,value){if(c=node.classList)return value?c.add(name):c.remove(name);var c=node.getAttribute("class")||"";if(value){re.lastIndex=0;if(!re.test(c))node.setAttribute("class",d3_collapse(c+" "+name));}else{node.setAttribute("class",d3_collapse(c.replace(re," ")));}};}
d3_selectionPrototype.style=function(name,value,priority){var n=arguments.length;if(n<3){if(typeof name!=="string"){if(n<2)value="";for(priority in name)this.each(d3_selection_style(priority,name[priority],value));return this;}
if(n<2){var node=this.node();return d3_window(node).getComputedStyle(node,null).getPropertyValue(name);}
priority="";}
return this.each(d3_selection_style(name,value,priority));};function d3_selection_style(name,value,priority){function styleNull(){this.style.removeProperty(name);}
function styleConstant(){this.style.setProperty(name,value,priority);}
function styleFunction(){var x=value.apply(this,arguments);if(x==null)this.style.removeProperty(name);else this.style.setProperty(name,x,priority);}
return value==null?styleNull:typeof value==="function"?styleFunction:styleConstant;}
d3_selectionPrototype.property=function(name,value){if(arguments.length<2){if(typeof name==="string")return this.node()[name];for(value in name)this.each(d3_selection_property(value,name[value]));return this;}
return this.each(d3_selection_property(name,value));};function d3_selection_property(name,value){function propertyNull(){delete this[name];}
function propertyConstant(){this[name]=value;}
function propertyFunction(){var x=value.apply(this,arguments);if(x==null)delete this[name];else this[name]=x;}
return value==null?propertyNull:typeof value==="function"?propertyFunction:propertyConstant;}
d3_selectionPrototype.text=function(value){return arguments.length?this.each(typeof value==="function"?function(){var v=value.apply(this,arguments);this.textContent=v==null?"":v;}:value==null?function(){this.textContent="";}:function(){this.textContent=value;}):this.node().textContent;};d3_selectionPrototype.html=function(value){return arguments.length?this.each(typeof value==="function"?function(){var v=value.apply(this,arguments);this.innerHTML=v==null?"":v;}:value==null?function(){this.innerHTML="";}:function(){this.innerHTML=value;}):this.node().innerHTML;};d3_selectionPrototype.append=function(name){name=d3_selection_creator(name);return this.select(function(){return this.appendChild(name.apply(this,arguments));});};function d3_selection_creator(name){function create(){var document=this.ownerDocument,namespace=this.namespaceURI;return namespace?document.createElementNS(namespace,name):document.createElement(name);}
function createNS(){return this.ownerDocument.createElementNS(name.space,name.local);}
return typeof name==="function"?name:(name=d3.ns.qualify(name)).local?createNS:create;}
d3_selectionPrototype.insert=function(name,before){name=d3_selection_creator(name);before=d3_selection_selector(before);return this.select(function(){return this.insertBefore(name.apply(this,arguments),before.apply(this,arguments)||null);});};d3_selectionPrototype.remove=function(){return this.each(d3_selectionRemove);};function d3_selectionRemove(){var parent=this.parentNode;if(parent)parent.removeChild(this);}
d3_selectionPrototype.data=function(value,key){var i=-1,n=this.length,group,node;if(!arguments.length){value=new Array(n=(group=this[0]).length);while(++i<n){if(node=group[i]){value[i]=node.__data__;}}
return value;}
function bind(group,groupData){var i,n=group.length,m=groupData.length,n0=Math.min(n,m),updateNodes=new Array(m),enterNodes=new Array(m),exitNodes=new Array(n),node,nodeData;if(key){var nodeByKeyValue=new d3_Map(),keyValues=new Array(n),keyValue;for(i=-1;++i<n;){if(nodeByKeyValue.has(keyValue=key.call(node=group[i],node.__data__,i))){exitNodes[i]=node;}else{nodeByKeyValue.set(keyValue,node);}
keyValues[i]=keyValue;}
for(i=-1;++i<m;){if(!(node=nodeByKeyValue.get(keyValue=key.call(groupData,nodeData=groupData[i],i)))){enterNodes[i]=d3_selection_dataNode(nodeData);}else if(node!==true){updateNodes[i]=node;node.__data__=nodeData;}
nodeByKeyValue.set(keyValue,true);}
for(i=-1;++i<n;){if(nodeByKeyValue.get(keyValues[i])!==true){exitNodes[i]=group[i];}}}else{for(i=-1;++i<n0;){node=group[i];nodeData=groupData[i];if(node){node.__data__=nodeData;updateNodes[i]=node;}else{enterNodes[i]=d3_selection_dataNode(nodeData);}}
for(;i<m;++i){enterNodes[i]=d3_selection_dataNode(groupData[i]);}
for(;i<n;++i){exitNodes[i]=group[i];}}
enterNodes.update=updateNodes;enterNodes.parentNode=updateNodes.parentNode=exitNodes.parentNode=group.parentNode;enter.push(enterNodes);update.push(updateNodes);exit.push(exitNodes);}
var enter=d3_selection_enter([]),update=d3_selection([]),exit=d3_selection([]);if(typeof value==="function"){while(++i<n){bind(group=this[i],value.call(group,group.parentNode.__data__,i));}}else{while(++i<n){bind(group=this[i],value);}}
update.enter=function(){return enter;};update.exit=function(){return exit;};return update;};function d3_selection_dataNode(data){return{__data__:data};}
d3_selectionPrototype.datum=function(value){return arguments.length?this.property("__data__",value):this.property("__data__");};d3_selectionPrototype.filter=function(filter){var subgroups=[],subgroup,group,node;if(typeof filter!=="function")filter=d3_selection_filter(filter);for(var j=0,m=this.length;j<m;j++){subgroups.push(subgroup=[]);subgroup.parentNode=(group=this[j]).parentNode;for(var i=0,n=group.length;i<n;i++){if((node=group[i])&&filter.call(node,node.__data__,i,j)){subgroup.push(node);}}}
return d3_selection(subgroups);};function d3_selection_filter(selector){return function(){return d3_selectMatches(this,selector);};}
d3_selectionPrototype.order=function(){for(var j=-1,m=this.length;++j<m;){for(var group=this[j],i=group.length-1,next=group[i],node;--i>=0;){if(node=group[i]){if(next&&next!==node.nextSibling)next.parentNode.insertBefore(node,next);next=node;}}}
return this;};d3_selectionPrototype.sort=function(comparator){comparator=d3_selection_sortComparator.apply(this,arguments);for(var j=-1,m=this.length;++j<m;)this[j].sort(comparator);return this.order();};function d3_selection_sortComparator(comparator){if(!arguments.length)comparator=d3_ascending;return function(a,b){return a&&b?comparator(a.__data__,b.__data__):!a-!b;};}
d3_selectionPrototype.each=function(callback){return d3_selection_each(this,function(node,i,j){callback.call(node,node.__data__,i,j);});};function d3_selection_each(groups,callback){for(var j=0,m=groups.length;j<m;j++){for(var group=groups[j],i=0,n=group.length,node;i<n;i++){if(node=group[i])callback(node,i,j);}}
return groups;}
d3_selectionPrototype.call=function(callback){var args=d3_array(arguments);callback.apply(args[0]=this,args);return this;};d3_selectionPrototype.empty=function(){return!this.node();};d3_selectionPrototype.node=function(){for(var j=0,m=this.length;j<m;j++){for(var group=this[j],i=0,n=group.length;i<n;i++){var node=group[i];if(node)return node;}}
return null;};d3_selectionPrototype.size=function(){var n=0;d3_selection_each(this,function(){++n;});return n;};function d3_selection_enter(selection){d3_subclass(selection,d3_selection_enterPrototype);return selection;}
var d3_selection_enterPrototype=[];d3.selection.enter=d3_selection_enter;d3.selection.enter.prototype=d3_selection_enterPrototype;d3_selection_enterPrototype.append=d3_selectionPrototype.append;d3_selection_enterPrototype.empty=d3_selectionPrototype.empty;d3_selection_enterPrototype.node=d3_selectionPrototype.node;d3_selection_enterPrototype.call=d3_selectionPrototype.call;d3_selection_enterPrototype.size=d3_selectionPrototype.size;d3_selection_enterPrototype.select=function(selector){var subgroups=[],subgroup,subnode,upgroup,group,node;for(var j=-1,m=this.length;++j<m;){upgroup=(group=this[j]).update;subgroups.push(subgroup=[]);subgroup.parentNode=group.parentNode;for(var i=-1,n=group.length;++i<n;){if(node=group[i]){subgroup.push(upgroup[i]=subnode=selector.call(group.parentNode,node.__data__,i,j));subnode.__data__=node.__data__;}else{subgroup.push(null);}}}
return d3_selection(subgroups);};d3_selection_enterPrototype.insert=function(name,before){if(arguments.length<2)before=d3_selection_enterInsertBefore(this);return d3_selectionPrototype.insert.call(this,name,before);};function d3_selection_enterInsertBefore(enter){var i0,j0;return function(d,i,j){var group=enter[j].update,n=group.length,node;if(j!=j0)j0=j,i0=0;if(i>=i0)i0=i+1;while(!(node=group[i0])&&++i0<n);return node;};}
d3.select=function(node){var group;if(typeof node==="string"){group=[d3_select(node,d3_document)];group.parentNode=d3_document.documentElement;}else{group=[node];group.parentNode=d3_documentElement(node);}
return d3_selection([group]);};d3.selectAll=function(nodes){var group;if(typeof nodes==="string"){group=d3_array(d3_selectAll(nodes,d3_document));group.parentNode=d3_document.documentElement;}else{group=nodes;group.parentNode=null;}
return d3_selection([group]);};d3_selectionPrototype.on=function(type,listener,capture){var n=arguments.length;if(n<3){if(typeof type!=="string"){if(n<2)listener=false;for(capture in type)this.each(d3_selection_on(capture,type[capture],listener));return this;}
if(n<2)return(n=this.node()["__on"+type])&&n._;capture=false;}
return this.each(d3_selection_on(type,listener,capture));};function d3_selection_on(type,listener,capture){var name="__on"+type,i=type.indexOf("."),wrap=d3_selection_onListener;if(i>0)type=type.slice(0,i);var filter=d3_selection_onFilters.get(type);if(filter)type=filter,wrap=d3_selection_onFilter;function onRemove(){var l=this[name];if(l){this.removeEventListener(type,l,l.$);delete this[name];}}
function onAdd(){var l=wrap(listener,d3_array(arguments));onRemove.call(this);this.addEventListener(type,this[name]=l,l.$=capture);l._=listener;}
function removeAll(){var re=new RegExp("^__on([^.]+)"+d3.requote(type)+"$"),match;for(var name in this){if(match=name.match(re)){var l=this[name];this.removeEventListener(match[1],l,l.$);delete this[name];}}}
return i?listener?onAdd:onRemove:listener?d3_noop:removeAll;}
var d3_selection_onFilters=d3.map({mouseenter:"mouseover",mouseleave:"mouseout"});if(d3_document){d3_selection_onFilters.forEach(function(k){if("on"+k in d3_document)d3_selection_onFilters.remove(k);});}
function d3_selection_onListener(listener,argumentz){return function(e){var o=d3.event;d3.event=e;argumentz[0]=this.__data__;try{listener.apply(this,argumentz);}finally{d3.event=o;}};}
function d3_selection_onFilter(listener,argumentz){var l=d3_selection_onListener(listener,argumentz);return function(e){var target=this,related=e.relatedTarget;if(!related||related!==target&&!(related.compareDocumentPosition(target)&8)){l.call(target,e);}};}
var d3_event_dragSelect,d3_event_dragId=0;function d3_event_dragSuppress(node){var name=".dragsuppress-"+ ++d3_event_dragId,click="click"+name,w=d3.select(d3_window(node)).on("touchmove"+name,d3_eventPreventDefault).on("dragstart"+name,d3_eventPreventDefault).on("selectstart"+name,d3_eventPreventDefault);if(d3_event_dragSelect==null){d3_event_dragSelect="onselectstart"in node?false:d3_vendorSymbol(node.style,"userSelect");}
if(d3_event_dragSelect){var style=d3_documentElement(node).style,select=style[d3_event_dragSelect];style[d3_event_dragSelect]="none";}
return function(suppressClick){w.on(name,null);if(d3_event_dragSelect)style[d3_event_dragSelect]=select;if(suppressClick){var off=function(){w.on(click,null);};w.on(click,function(){d3_eventPreventDefault();off();},true);setTimeout(off,0);}};}
d3.mouse=function(container){return d3_mousePoint(container,d3_eventSource());};var d3_mouse_bug44083=this.navigator&&/WebKit/.test(this.navigator.userAgent)?-1:0;function d3_mousePoint(container,e){if(e.changedTouches)e=e.changedTouches[0];var svg=container.ownerSVGElement||container;if(svg.createSVGPoint){var point=svg.createSVGPoint();if(d3_mouse_bug44083<0){var window=d3_window(container);if(window.scrollX||window.scrollY){svg=d3.select("body").append("svg").style({position:"absolute",top:0,left:0,margin:0,padding:0,border:"none"},"important");var ctm=svg[0][0].getScreenCTM();d3_mouse_bug44083=!(ctm.f||ctm.e);svg.remove();}}
if(d3_mouse_bug44083)point.x=e.pageX,point.y=e.pageY;else point.x=e.clientX,point.y=e.clientY;point=point.matrixTransform(container.getScreenCTM().inverse());return[point.x,point.y];}
var rect=container.getBoundingClientRect();return[e.clientX-rect.left-container.clientLeft,e.clientY-rect.top-container.clientTop];}
d3.touch=function(container,touches,identifier){if(arguments.length<3)identifier=touches,touches=d3_eventSource().changedTouches;if(touches)for(var i=0,n=touches.length,touch;i<n;++i){if((touch=touches[i]).identifier===identifier){return d3_mousePoint(container,touch);}}};d3.behavior.drag=function(){var event=d3_eventDispatch(drag,"drag","dragstart","dragend"),origin=null,mousedown=dragstart(d3_noop,d3.mouse,d3_window,"mousemove","mouseup"),touchstart=dragstart(d3_behavior_dragTouchId,d3.touch,d3_identity,"touchmove","touchend");function drag(){this.on("mousedown.drag",mousedown).on("touchstart.drag",touchstart);}
function dragstart(id,position,subject,move,end){return function(){var that=this,target=d3.event.target,parent=that.parentNode,dispatch=event.of(that,arguments),dragged=0,dragId=id(),dragName=".drag"+(dragId==null?"":"-"+dragId),dragOffset,dragSubject=d3.select(subject(target)).on(move+dragName,moved).on(end+dragName,ended),dragRestore=d3_event_dragSuppress(target),position0=position(parent,dragId);if(origin){dragOffset=origin.apply(that,arguments);dragOffset=[dragOffset.x-position0[0],dragOffset.y-position0[1]];}else{dragOffset=[0,0];}
dispatch({type:"dragstart"});function moved(){var position1=position(parent,dragId),dx,dy;if(!position1)return;dx=position1[0]-position0[0];dy=position1[1]-position0[1];dragged|=dx|dy;position0=position1;dispatch({type:"drag",x:position1[0]+dragOffset[0],y:position1[1]+dragOffset[1],dx:dx,dy:dy});}
function ended(){if(!position(parent,dragId))return;dragSubject.on(move+dragName,null).on(end+dragName,null);dragRestore(dragged&&d3.event.target===target);dispatch({type:"dragend"});}};}
drag.origin=function(x){if(!arguments.length)return origin;origin=x;return drag;};return d3.rebind(drag,event,"on");};function d3_behavior_dragTouchId(){return d3.event.changedTouches[0].identifier;}
d3.touches=function(container,touches){if(arguments.length<2)touches=d3_eventSource().touches;return touches?d3_array(touches).map(function(touch){var point=d3_mousePoint(container,touch);point.identifier=touch.identifier;return point;}):[];};var ε=1e-6,ε2=ε*ε,π=Math.PI,τ=2*π,τε=τ-ε,halfπ=π/2,d3_radians=π/180,d3_degrees=180/π;function d3_sgn(x){return x>0?1:x<0?-1:0;}
function d3_cross2d(a,b,c){return(b[0]-a[0])*(c[1]-a[1])-(b[1]-a[1])*(c[0]-a[0]);}
function d3_acos(x){return x>1?0:x<-1?π:Math.acos(x);}
function d3_asin(x){return x>1?halfπ:x<-1?-halfπ:Math.asin(x);}
function d3_sinh(x){return((x=Math.exp(x))-1/x)/2;}
function d3_cosh(x){return((x=Math.exp(x))+1/x)/2;}
function d3_tanh(x){return((x=Math.exp(2*x))-1)/(x+1);}
function d3_haversin(x){return(x=Math.sin(x/2))*x;}
var ρ=Math.SQRT2,ρ2=2,ρ4=4;d3.interpolateZoom=function(p0,p1){var ux0=p0[0],uy0=p0[1],w0=p0[2],ux1=p1[0],uy1=p1[1],w1=p1[2];var dx=ux1-ux0,dy=uy1-uy0,d2=dx*dx+dy*dy,d1=Math.sqrt(d2),b0=(w1*w1-w0*w0+ρ4*d2)/(2*w0*ρ2*d1),b1=(w1*w1-w0*w0-ρ4*d2)/(2*w1*ρ2*d1),r0=Math.log(Math.sqrt(b0*b0+1)-b0),r1=Math.log(Math.sqrt(b1*b1+1)-b1),dr=r1-r0,S=(dr||Math.log(w1/w0))/ρ;function interpolate(t){var s=t*S;if(dr){var coshr0=d3_cosh(r0),u=w0/(ρ2*d1)*(coshr0*d3_tanh(ρ*s+r0)-d3_sinh(r0));return[ux0+u*dx,uy0+u*dy,w0*coshr0/d3_cosh(ρ*s+r0)];}
return[ux0+t*dx,uy0+t*dy,w0*Math.exp(ρ*s)];}
interpolate.duration=S*1e3;return interpolate;};d3.behavior.zoom=function(){var view={x:0,y:0,k:1},translate0,center0,center,size=[960,500],scaleExtent=d3_behavior_zoomInfinity,duration=250,zooming=0,mousedown="mousedown.zoom",mousemove="mousemove.zoom",mouseup="mouseup.zoom",mousewheelTimer,touchstart="touchstart.zoom",touchtime,event=d3_eventDispatch(zoom,"zoomstart","zoom","zoomend"),x0,x1,y0,y1;if(!d3_behavior_zoomWheel){d3_behavior_zoomWheel="onwheel"in d3_document?(d3_behavior_zoomDelta=function(){return-d3.event.deltaY*(d3.event.deltaMode?120:1);},"wheel"):"onmousewheel"in d3_document?(d3_behavior_zoomDelta=function(){return d3.event.wheelDelta;},"mousewheel"):(d3_behavior_zoomDelta=function(){return-d3.event.detail;},"MozMousePixelScroll");}
function zoom(g){g.on(mousedown,mousedowned).on(d3_behavior_zoomWheel+".zoom",mousewheeled).on("dblclick.zoom",dblclicked).on(touchstart,touchstarted);}
zoom.event=function(g){g.each(function(){var dispatch=event.of(this,arguments),view1=view;if(d3_transitionInheritId){d3.select(this).transition().each("start.zoom",function(){view=this.__chart__||{x:0,y:0,k:1};zoomstarted(dispatch);}).tween("zoom:zoom",function(){var dx=size[0],dy=size[1],cx=center0?center0[0]:dx/2,cy=center0?center0[1]:dy/2,i=d3.interpolateZoom([(cx-view.x)/view.k,(cy-view.y)/view.k,dx/view.k],[(cx-view1.x)/view1.k,(cy-view1.y)/view1.k,dx/view1.k]);return function(t){var l=i(t),k=dx/l[2];this.__chart__=view={x:cx-l[0]*k,y:cy-l[1]*k,k:k};zoomed(dispatch);};}).each("interrupt.zoom",function(){zoomended(dispatch);}).each("end.zoom",function(){zoomended(dispatch);});}else{this.__chart__=view;zoomstarted(dispatch);zoomed(dispatch);zoomended(dispatch);}});};zoom.translate=function(_){if(!arguments.length)return[view.x,view.y];view={x:+_[0],y:+_[1],k:view.k};rescale();return zoom;};zoom.scale=function(_){if(!arguments.length)return view.k;view={x:view.x,y:view.y,k:+_};rescale();return zoom;};zoom.scaleExtent=function(_){if(!arguments.length)return scaleExtent;scaleExtent=_==null?d3_behavior_zoomInfinity:[+_[0],+_[1]];return zoom;};zoom.center=function(_){if(!arguments.length)return center;center=_&&[+_[0],+_[1]];return zoom;};zoom.size=function(_){if(!arguments.length)return size;size=_&&[+_[0],+_[1]];return zoom;};zoom.duration=function(_){if(!arguments.length)return duration;duration=+_;return zoom;};zoom.x=function(z){if(!arguments.length)return x1;x1=z;x0=z.copy();view={x:0,y:0,k:1};return zoom;};zoom.y=function(z){if(!arguments.length)return y1;y1=z;y0=z.copy();view={x:0,y:0,k:1};return zoom;};function location(p){return[(p[0]-view.x)/view.k,(p[1]-view.y)/view.k];}
function point(l){return[l[0]*view.k+view.x,l[1]*view.k+view.y];}
function scaleTo(s){view.k=Math.max(scaleExtent[0],Math.min(scaleExtent[1],s));}
function translateTo(p,l){l=point(l);view.x+=p[0]-l[0];view.y+=p[1]-l[1];}
function zoomTo(that,p,l,k){that.__chart__={x:view.x,y:view.y,k:view.k};scaleTo(Math.pow(2,k));translateTo(center0=p,l);that=d3.select(that);if(duration>0)that=that.transition().duration(duration);that.call(zoom.event);}
function rescale(){if(x1)x1.domain(x0.range().map(function(x){return(x-view.x)/view.k;}).map(x0.invert));if(y1)y1.domain(y0.range().map(function(y){return(y-view.y)/view.k;}).map(y0.invert));}
function zoomstarted(dispatch){if(!zooming++)dispatch({type:"zoomstart"});}
function zoomed(dispatch){rescale();dispatch({type:"zoom",scale:view.k,translate:[view.x,view.y]});}
function zoomended(dispatch){if(!--zooming)dispatch({type:"zoomend"}),center0=null;}
function mousedowned(){var that=this,target=d3.event.target,dispatch=event.of(that,arguments),dragged=0,subject=d3.select(d3_window(that)).on(mousemove,moved).on(mouseup,ended),location0=location(d3.mouse(that)),dragRestore=d3_event_dragSuppress(that);d3_selection_interrupt.call(that);zoomstarted(dispatch);function moved(){dragged=1;translateTo(d3.mouse(that),location0);zoomed(dispatch);}
function ended(){subject.on(mousemove,null).on(mouseup,null);dragRestore(dragged&&d3.event.target===target);zoomended(dispatch);}}
function touchstarted(){var that=this,dispatch=event.of(that,arguments),locations0={},distance0=0,scale0,zoomName=".zoom-"+d3.event.changedTouches[0].identifier,touchmove="touchmove"+zoomName,touchend="touchend"+zoomName,targets=[],subject=d3.select(that),dragRestore=d3_event_dragSuppress(that);started();zoomstarted(dispatch);subject.on(mousedown,null).on(touchstart,started);function relocate(){var touches=d3.touches(that);scale0=view.k;touches.forEach(function(t){if(t.identifier in locations0)locations0[t.identifier]=location(t);});return touches;}
function started(){var target=d3.event.target;d3.select(target).on(touchmove,moved).on(touchend,ended);targets.push(target);var changed=d3.event.changedTouches;for(var i=0,n=changed.length;i<n;++i){locations0[changed[i].identifier]=null;}
var touches=relocate(),now=Date.now();if(touches.length===1){if(now-touchtime<500){var p=touches[0];zoomTo(that,p,locations0[p.identifier],Math.floor(Math.log(view.k)/Math.LN2)+1);d3_eventPreventDefault();}
touchtime=now;}else if(touches.length>1){var p=touches[0],q=touches[1],dx=p[0]-q[0],dy=p[1]-q[1];distance0=dx*dx+dy*dy;}}
function moved(){var touches=d3.touches(that),p0,l0,p1,l1;d3_selection_interrupt.call(that);for(var i=0,n=touches.length;i<n;++i,l1=null){p1=touches[i];if(l1=locations0[p1.identifier]){if(l0)break;p0=p1,l0=l1;}}
if(l1){var distance1=(distance1=p1[0]-p0[0])*distance1+(distance1=p1[1]-p0[1])*distance1,scale1=distance0&&Math.sqrt(distance1/distance0);p0=[(p0[0]+p1[0])/2,(p0[1]+p1[1])/2];l0=[(l0[0]+l1[0])/2,(l0[1]+l1[1])/2];scaleTo(scale1*scale0);}
touchtime=null;translateTo(p0,l0);zoomed(dispatch);}
function ended(){if(d3.event.touches.length){var changed=d3.event.changedTouches;for(var i=0,n=changed.length;i<n;++i){delete locations0[changed[i].identifier];}
for(var identifier in locations0){return void relocate();}}
d3.selectAll(targets).on(zoomName,null);subject.on(mousedown,mousedowned).on(touchstart,touchstarted);dragRestore();zoomended(dispatch);}}
function mousewheeled(){var dispatch=event.of(this,arguments);if(mousewheelTimer)clearTimeout(mousewheelTimer);else d3_selection_interrupt.call(this),translate0=location(center0=center||d3.mouse(this)),zoomstarted(dispatch);mousewheelTimer=setTimeout(function(){mousewheelTimer=null;zoomended(dispatch);},50);d3_eventPreventDefault();scaleTo(Math.pow(2,d3_behavior_zoomDelta()*.002)*view.k);translateTo(center0,translate0);zoomed(dispatch);}
function dblclicked(){var p=d3.mouse(this),k=Math.log(view.k)/Math.LN2;zoomTo(this,p,location(p),d3.event.shiftKey?Math.ceil(k)-1:Math.floor(k)+1);}
return d3.rebind(zoom,event,"on");};var d3_behavior_zoomInfinity=[0,Infinity],d3_behavior_zoomDelta,d3_behavior_zoomWheel;d3.color=d3_color;function d3_color(){}
d3_color.prototype.toString=function(){return this.rgb()+"";};d3.hsl=d3_hsl;function d3_hsl(h,s,l){return this instanceof d3_hsl?void(this.h=+h,this.s=+s,this.l=+l):arguments.length<2?h instanceof d3_hsl?new d3_hsl(h.h,h.s,h.l):d3_rgb_parse(""+h,d3_rgb_hsl,d3_hsl):new d3_hsl(h,s,l);}
var d3_hslPrototype=d3_hsl.prototype=new d3_color();d3_hslPrototype.brighter=function(k){k=Math.pow(.7,arguments.length?k:1);return new d3_hsl(this.h,this.s,this.l/k);};d3_hslPrototype.darker=function(k){k=Math.pow(.7,arguments.length?k:1);return new d3_hsl(this.h,this.s,k*this.l);};d3_hslPrototype.rgb=function(){return d3_hsl_rgb(this.h,this.s,this.l);};function d3_hsl_rgb(h,s,l){var m1,m2;h=isNaN(h)?0:(h%=360)<0?h+360:h;s=isNaN(s)?0:s<0?0:s>1?1:s;l=l<0?0:l>1?1:l;m2=l<=.5?l*(1+s):l+s-l*s;m1=2*l-m2;function v(h){if(h>360)h-=360;else if(h<0)h+=360;if(h<60)return m1+(m2-m1)*h/60;if(h<180)return m2;if(h<240)return m1+(m2-m1)*(240-h)/60;return m1;}
function vv(h){return Math.round(v(h)*255);}
return new d3_rgb(vv(h+120),vv(h),vv(h-120));}
d3.hcl=d3_hcl;function d3_hcl(h,c,l){return this instanceof d3_hcl?void(this.h=+h,this.c=+c,this.l=+l):arguments.length<2?h instanceof d3_hcl?new d3_hcl(h.h,h.c,h.l):h instanceof d3_lab?d3_lab_hcl(h.l,h.a,h.b):d3_lab_hcl((h=d3_rgb_lab((h=d3.rgb(h)).r,h.g,h.b)).l,h.a,h.b):new d3_hcl(h,c,l);}
var d3_hclPrototype=d3_hcl.prototype=new d3_color();d3_hclPrototype.brighter=function(k){return new d3_hcl(this.h,this.c,Math.min(100,this.l+d3_lab_K*(arguments.length?k:1)));};d3_hclPrototype.darker=function(k){return new d3_hcl(this.h,this.c,Math.max(0,this.l-d3_lab_K*(arguments.length?k:1)));};d3_hclPrototype.rgb=function(){return d3_hcl_lab(this.h,this.c,this.l).rgb();};function d3_hcl_lab(h,c,l){if(isNaN(h))h=0;if(isNaN(c))c=0;return new d3_lab(l,Math.cos(h*=d3_radians)*c,Math.sin(h)*c);}
d3.lab=d3_lab;function d3_lab(l,a,b){return this instanceof d3_lab?void(this.l=+l,this.a=+a,this.b=+b):arguments.length<2?l instanceof d3_lab?new d3_lab(l.l,l.a,l.b):l instanceof d3_hcl?d3_hcl_lab(l.h,l.c,l.l):d3_rgb_lab((l=d3_rgb(l)).r,l.g,l.b):new d3_lab(l,a,b);}
var d3_lab_K=18;var d3_lab_X=.95047,d3_lab_Y=1,d3_lab_Z=1.08883;var d3_labPrototype=d3_lab.prototype=new d3_color();d3_labPrototype.brighter=function(k){return new d3_lab(Math.min(100,this.l+d3_lab_K*(arguments.length?k:1)),this.a,this.b);};d3_labPrototype.darker=function(k){return new d3_lab(Math.max(0,this.l-d3_lab_K*(arguments.length?k:1)),this.a,this.b);};d3_labPrototype.rgb=function(){return d3_lab_rgb(this.l,this.a,this.b);};function d3_lab_rgb(l,a,b){var y=(l+16)/116,x=y+a/500,z=y-b/200;x=d3_lab_xyz(x)*d3_lab_X;y=d3_lab_xyz(y)*d3_lab_Y;z=d3_lab_xyz(z)*d3_lab_Z;return new d3_rgb(d3_xyz_rgb(3.2404542*x-1.5371385*y-.4985314*z),d3_xyz_rgb(-.969266*x+1.8760108*y+.041556*z),d3_xyz_rgb(.0556434*x-.2040259*y+1.0572252*z));}
function d3_lab_hcl(l,a,b){return l>0?new d3_hcl(Math.atan2(b,a)*d3_degrees,Math.sqrt(a*a+b*b),l):new d3_hcl(NaN,NaN,l);}
function d3_lab_xyz(x){return x>.206893034?x*x*x:(x-4/29)/7.787037;}
function d3_xyz_lab(x){return x>.008856?Math.pow(x,1/3):7.787037*x+4/29;}
function d3_xyz_rgb(r){return Math.round(255*(r<=.00304?12.92*r:1.055*Math.pow(r,1/2.4)-.055));}
d3.rgb=d3_rgb;function d3_rgb(r,g,b){return this instanceof d3_rgb?void(this.r=~~r,this.g=~~g,this.b=~~b):arguments.length<2?r instanceof d3_rgb?new d3_rgb(r.r,r.g,r.b):d3_rgb_parse(""+r,d3_rgb,d3_hsl_rgb):new d3_rgb(r,g,b);}
function d3_rgbNumber(value){return new d3_rgb(value>>16,value>>8&255,value&255);}
function d3_rgbString(value){return d3_rgbNumber(value)+"";}
var d3_rgbPrototype=d3_rgb.prototype=new d3_color();d3_rgbPrototype.brighter=function(k){k=Math.pow(.7,arguments.length?k:1);var r=this.r,g=this.g,b=this.b,i=30;if(!r&&!g&&!b)return new d3_rgb(i,i,i);if(r&&r<i)r=i;if(g&&g<i)g=i;if(b&&b<i)b=i;return new d3_rgb(Math.min(255,r/k),Math.min(255,g/k),Math.min(255,b/k));};d3_rgbPrototype.darker=function(k){k=Math.pow(.7,arguments.length?k:1);return new d3_rgb(k*this.r,k*this.g,k*this.b);};d3_rgbPrototype.hsl=function(){return d3_rgb_hsl(this.r,this.g,this.b);};d3_rgbPrototype.toString=function(){return"#"+d3_rgb_hex(this.r)+d3_rgb_hex(this.g)+d3_rgb_hex(this.b);};function d3_rgb_hex(v){return v<16?"0"+Math.max(0,v).toString(16):Math.min(255,v).toString(16);}
function d3_rgb_parse(format,rgb,hsl){var r=0,g=0,b=0,m1,m2,color;m1=/([a-z]+)\((.*)\)/.exec(format=format.toLowerCase());if(m1){m2=m1[2].split(",");switch(m1[1]){case"hsl":{return hsl(parseFloat(m2[0]),parseFloat(m2[1])/100,parseFloat(m2[2])/100);}
case"rgb":{return rgb(d3_rgb_parseNumber(m2[0]),d3_rgb_parseNumber(m2[1]),d3_rgb_parseNumber(m2[2]));}}}
if(color=d3_rgb_names.get(format)){return rgb(color.r,color.g,color.b);}
if(format!=null&&format.charAt(0)==="#"&&!isNaN(color=parseInt(format.slice(1),16))){if(format.length===4){r=(color&3840)>>4;r=r>>4|r;g=color&240;g=g>>4|g;b=color&15;b=b<<4|b;}else if(format.length===7){r=(color&16711680)>>16;g=(color&65280)>>8;b=color&255;}}
return rgb(r,g,b);}
function d3_rgb_hsl(r,g,b){var min=Math.min(r/=255,g/=255,b/=255),max=Math.max(r,g,b),d=max-min,h,s,l=(max+min)/2;if(d){s=l<.5?d/(max+min):d/(2-max-min);if(r==max)h=(g-b)/d+(g<b?6:0);else if(g==max)h=(b-r)/d+2;else h=(r-g)/d+4;h*=60;}else{h=NaN;s=l>0&&l<1?0:h;}
return new d3_hsl(h,s,l);}
function d3_rgb_lab(r,g,b){r=d3_rgb_xyz(r);g=d3_rgb_xyz(g);b=d3_rgb_xyz(b);var x=d3_xyz_lab((.4124564*r+.3575761*g+.1804375*b)/d3_lab_X),y=d3_xyz_lab((.2126729*r+.7151522*g+.072175*b)/d3_lab_Y),z=d3_xyz_lab((.0193339*r+.119192*g+.9503041*b)/d3_lab_Z);return d3_lab(116*y-16,500*(x-y),200*(y-z));}
function d3_rgb_xyz(r){return(r/=255)<=.04045?r/12.92:Math.pow((r+.055)/1.055,2.4);}
function d3_rgb_parseNumber(c){var f=parseFloat(c);return c.charAt(c.length-1)==="%"?Math.round(f*2.55):f;}
var d3_rgb_names=d3.map({aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,rebeccapurple:6697881,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074});d3_rgb_names.forEach(function(key,value){d3_rgb_names.set(key,d3_rgbNumber(value));});function d3_functor(v){return typeof v==="function"?v:function(){return v;};}
d3.functor=d3_functor;d3.xhr=d3_xhrType(d3_identity);function d3_xhrType(response){return function(url,mimeType,callback){if(arguments.length===2&&typeof mimeType==="function")callback=mimeType,mimeType=null;return d3_xhr(url,mimeType,response,callback);};}
function d3_xhr(url,mimeType,response,callback){var xhr={},dispatch=d3.dispatch("beforesend","progress","load","error"),headers={},request=new XMLHttpRequest(),responseType=null;if(this.XDomainRequest&&!("withCredentials"in request)&&/^(http(s)?:)?\/\//.test(url))request=new XDomainRequest();"onload"in request?request.onload=request.onerror=respond:request.onreadystatechange=function(){request.readyState>3&&respond();};function respond(){var status=request.status,result;if(!status&&d3_xhrHasResponse(request)||status>=200&&status<300||status===304){try{result=response.call(xhr,request);}catch(e){dispatch.error.call(xhr,e);return;}
dispatch.load.call(xhr,result);}else{dispatch.error.call(xhr,request);}}
request.onprogress=function(event){var o=d3.event;d3.event=event;try{dispatch.progress.call(xhr,request);}finally{d3.event=o;}};xhr.header=function(name,value){name=(name+"").toLowerCase();if(arguments.length<2)return headers[name];if(value==null)delete headers[name];else headers[name]=value+"";return xhr;};xhr.mimeType=function(value){if(!arguments.length)return mimeType;mimeType=value==null?null:value+"";return xhr;};xhr.responseType=function(value){if(!arguments.length)return responseType;responseType=value;return xhr;};xhr.response=function(value){response=value;return xhr;};["get","post"].forEach(function(method){xhr[method]=function(){return xhr.send.apply(xhr,[method].concat(d3_array(arguments)));};});xhr.send=function(method,data,callback){if(arguments.length===2&&typeof data==="function")callback=data,data=null;request.open(method,url,true);if(mimeType!=null&&!("accept"in headers))headers["accept"]=mimeType+",*/*";if(request.setRequestHeader)for(var name in headers)request.setRequestHeader(name,headers[name]);if(mimeType!=null&&request.overrideMimeType)request.overrideMimeType(mimeType);if(responseType!=null)request.responseType=responseType;if(callback!=null)xhr.on("error",callback).on("load",function(request){callback(null,request);});dispatch.beforesend.call(xhr,request);request.send(data==null?null:data);return xhr;};xhr.abort=function(){request.abort();return xhr;};d3.rebind(xhr,dispatch,"on");return callback==null?xhr:xhr.get(d3_xhr_fixCallback(callback));}
function d3_xhr_fixCallback(callback){return callback.length===1?function(error,request){callback(error==null?request:null);}:callback;}
function d3_xhrHasResponse(request){var type=request.responseType;return type&&type!=="text"?request.response:request.responseText;}
d3.dsv=function(delimiter,mimeType){var reFormat=new RegExp('["'+delimiter+"\n]"),delimiterCode=delimiter.charCodeAt(0);function dsv(url,row,callback){if(arguments.length<3)callback=row,row=null;var xhr=d3_xhr(url,mimeType,row==null?response:typedResponse(row),callback);xhr.row=function(_){return arguments.length?xhr.response((row=_)==null?response:typedResponse(_)):row;};return xhr;}
function response(request){return dsv.parse(request.responseText);}
function typedResponse(f){return function(request){return dsv.parse(request.responseText,f);};}
dsv.parse=function(text,f){var o;return dsv.parseRows(text,function(row,i){if(o)return o(row,i-1);var a=new Function("d","return {"+row.map(function(name,i){return JSON.stringify(name)+": d["+i+"]";}).join(",")+"}");o=f?function(row,i){return f(a(row),i);}:a;});};dsv.parseRows=function(text,f){var EOL={},EOF={},rows=[],N=text.length,I=0,n=0,t,eol;function token(){if(I>=N)return EOF;if(eol)return eol=false,EOL;var j=I;if(text.charCodeAt(j)===34){var i=j;while(i++<N){if(text.charCodeAt(i)===34){if(text.charCodeAt(i+1)!==34)break;++i;}}
I=i+2;var c=text.charCodeAt(i+1);if(c===13){eol=true;if(text.charCodeAt(i+2)===10)++I;}else if(c===10){eol=true;}
return text.slice(j+1,i).replace(/""/g,'"');}
while(I<N){var c=text.charCodeAt(I++),k=1;if(c===10)eol=true;else if(c===13){eol=true;if(text.charCodeAt(I)===10)++I,++k;}else if(c!==delimiterCode)continue;return text.slice(j,I-k);}
return text.slice(j);}
while((t=token())!==EOF){var a=[];while(t!==EOL&&t!==EOF){a.push(t);t=token();}
if(f&&(a=f(a,n++))==null)continue;rows.push(a);}
return rows;};dsv.format=function(rows){if(Array.isArray(rows[0]))return dsv.formatRows(rows);var fieldSet=new d3_Set(),fields=[];rows.forEach(function(row){for(var field in row){if(!fieldSet.has(field)){fields.push(fieldSet.add(field));}}});return[fields.map(formatValue).join(delimiter)].concat(rows.map(function(row){return fields.map(function(field){return formatValue(row[field]);}).join(delimiter);})).join("\n");};dsv.formatRows=function(rows){return rows.map(formatRow).join("\n");};function formatRow(row){return row.map(formatValue).join(delimiter);}
function formatValue(text){return reFormat.test(text)?'"'+text.replace(/\"/g,'""')+'"':text;}
return dsv;};d3.csv=d3.dsv(",","text/csv");d3.tsv=d3.dsv("	","text/tab-separated-values");var d3_timer_queueHead,d3_timer_queueTail,d3_timer_interval,d3_timer_timeout,d3_timer_active,d3_timer_frame=this[d3_vendorSymbol(this,"requestAnimationFrame")]||function(callback){setTimeout(callback,17);};d3.timer=function(callback,delay,then){var n=arguments.length;if(n<2)delay=0;if(n<3)then=Date.now();var time=then+delay,timer={c:callback,t:time,f:false,n:null};if(d3_timer_queueTail)d3_timer_queueTail.n=timer;else d3_timer_queueHead=timer;d3_timer_queueTail=timer;if(!d3_timer_interval){d3_timer_timeout=clearTimeout(d3_timer_timeout);d3_timer_interval=1;d3_timer_frame(d3_timer_step);}};function d3_timer_step(){var now=d3_timer_mark(),delay=d3_timer_sweep()-now;if(delay>24){if(isFinite(delay)){clearTimeout(d3_timer_timeout);d3_timer_timeout=setTimeout(d3_timer_step,delay);}
d3_timer_interval=0;}else{d3_timer_interval=1;d3_timer_frame(d3_timer_step);}}
d3.timer.flush=function(){d3_timer_mark();d3_timer_sweep();};function d3_timer_mark(){var now=Date.now();d3_timer_active=d3_timer_queueHead;while(d3_timer_active){if(now>=d3_timer_active.t)d3_timer_active.f=d3_timer_active.c(now-d3_timer_active.t);d3_timer_active=d3_timer_active.n;}
return now;}
function d3_timer_sweep(){var t0,t1=d3_timer_queueHead,time=Infinity;while(t1){if(t1.f){t1=t0?t0.n=t1.n:d3_timer_queueHead=t1.n;}else{if(t1.t<time)time=t1.t;t1=(t0=t1).n;}}
d3_timer_queueTail=t0;return time;}
function d3_format_precision(x,p){return p-(x?Math.ceil(Math.log(x)/Math.LN10):1);}
d3.round=function(x,n){return n?Math.round(x*(n=Math.pow(10,n)))/n:Math.round(x);};var d3_formatPrefixes=["y","z","a","f","p","n","µ","m","","k","M","G","T","P","E","Z","Y"].map(d3_formatPrefix);d3.formatPrefix=function(value,precision){var i=0;if(value){if(value<0)value*=-1;if(precision)value=d3.round(value,d3_format_precision(value,precision));i=1+Math.floor(1e-12+Math.log(value)/Math.LN10);i=Math.max(-24,Math.min(24,Math.floor((i-1)/3)*3));}
return d3_formatPrefixes[8+i/3];};function d3_formatPrefix(d,i){var k=Math.pow(10,abs(8-i)*3);return{scale:i>8?function(d){return d/k;}:function(d){return d*k;},symbol:d};}
function d3_locale_numberFormat(locale){var locale_decimal=locale.decimal,locale_thousands=locale.thousands,locale_grouping=locale.grouping,locale_currency=locale.currency,formatGroup=locale_grouping&&locale_thousands?function(value,width){var i=value.length,t=[],j=0,g=locale_grouping[0],length=0;while(i>0&&g>0){if(length+g+1>width)g=Math.max(1,width-length);t.push(value.substring(i-=g,i+g));if((length+=g+1)>width)break;g=locale_grouping[j=(j+1)%locale_grouping.length];}
return t.reverse().join(locale_thousands);}:d3_identity;return function(specifier){var match=d3_format_re.exec(specifier),fill=match[1]||" ",align=match[2]||">",sign=match[3]||"-",symbol=match[4]||"",zfill=match[5],width=+match[6],comma=match[7],precision=match[8],type=match[9],scale=1,prefix="",suffix="",integer=false,exponent=true;if(precision)precision=+precision.substring(1);if(zfill||fill==="0"&&align==="="){zfill=fill="0";align="=";}
switch(type){case"n":comma=true;type="g";break;case"%":scale=100;suffix="%";type="f";break;case"p":scale=100;suffix="%";type="r";break;case"b":case"o":case"x":case"X":if(symbol==="#")prefix="0"+type.toLowerCase();case"c":exponent=false;case"d":integer=true;precision=0;break;case"s":scale=-1;type="r";break;}
if(symbol==="$")prefix=locale_currency[0],suffix=locale_currency[1];if(type=="r"&&!precision)type="g";if(precision!=null){if(type=="g")precision=Math.max(1,Math.min(21,precision));else if(type=="e"||type=="f")precision=Math.max(0,Math.min(20,precision));}
type=d3_format_types.get(type)||d3_format_typeDefault;var zcomma=zfill&&comma;return function(value){var fullSuffix=suffix;if(integer&&value%1)return"";var negative=value<0||value===0&&1/value<0?(value=-value,"-"):sign==="-"?"":sign;if(scale<0){var unit=d3.formatPrefix(value,precision);value=unit.scale(value);fullSuffix=unit.symbol+suffix;}else{value*=scale;}
value=type(value,precision);var i=value.lastIndexOf("."),before,after;if(i<0){var j=exponent?value.lastIndexOf("e"):-1;if(j<0)before=value,after="";else before=value.substring(0,j),after=value.substring(j);}else{before=value.substring(0,i);after=locale_decimal+value.substring(i+1);}
if(!zfill&&comma)before=formatGroup(before,Infinity);var length=prefix.length+before.length+after.length+(zcomma?0:negative.length),padding=length<width?new Array(length=width-length+1).join(fill):"";if(zcomma)before=formatGroup(padding+before,padding.length?width-after.length:Infinity);negative+=prefix;value=before+after;return(align==="<"?negative+value+padding:align===">"?padding+negative+value:align==="^"?padding.substring(0,length>>=1)+negative+value+padding.substring(length):negative+(zcomma?value:padding+value))+fullSuffix;};};}
var d3_format_re=/(?:([^{])?([<>=^]))?([+\- ])?([$#])?(0)?(\d+)?(,)?(\.-?\d+)?([a-z%])?/i;var d3_format_types=d3.map({b:function(x){return x.toString(2);},c:function(x){return String.fromCharCode(x);},o:function(x){return x.toString(8);},x:function(x){return x.toString(16);},X:function(x){return x.toString(16).toUpperCase();},g:function(x,p){return x.toPrecision(p);},e:function(x,p){return x.toExponential(p);},f:function(x,p){return x.toFixed(p);},r:function(x,p){return(x=d3.round(x,d3_format_precision(x,p))).toFixed(Math.max(0,Math.min(20,d3_format_precision(x*(1+1e-15),p))));}});function d3_format_typeDefault(x){return x+"";}
var d3_time=d3.time={},d3_date=Date;function d3_date_utc(){this._=new Date(arguments.length>1?Date.UTC.apply(this,arguments):arguments[0]);}
d3_date_utc.prototype={getDate:function(){return this._.getUTCDate();},getDay:function(){return this._.getUTCDay();},getFullYear:function(){return this._.getUTCFullYear();},getHours:function(){return this._.getUTCHours();},getMilliseconds:function(){return this._.getUTCMilliseconds();},getMinutes:function(){return this._.getUTCMinutes();},getMonth:function(){return this._.getUTCMonth();},getSeconds:function(){return this._.getUTCSeconds();},getTime:function(){return this._.getTime();},getTimezoneOffset:function(){return 0;},valueOf:function(){return this._.valueOf();},setDate:function(){d3_time_prototype.setUTCDate.apply(this._,arguments);},setDay:function(){d3_time_prototype.setUTCDay.apply(this._,arguments);},setFullYear:function(){d3_time_prototype.setUTCFullYear.apply(this._,arguments);},setHours:function(){d3_time_prototype.setUTCHours.apply(this._,arguments);},setMilliseconds:function(){d3_time_prototype.setUTCMilliseconds.apply(this._,arguments);},setMinutes:function(){d3_time_prototype.setUTCMinutes.apply(this._,arguments);},setMonth:function(){d3_time_prototype.setUTCMonth.apply(this._,arguments);},setSeconds:function(){d3_time_prototype.setUTCSeconds.apply(this._,arguments);},setTime:function(){d3_time_prototype.setTime.apply(this._,arguments);}};var d3_time_prototype=Date.prototype;function d3_time_interval(local,step,number){function round(date){var d0=local(date),d1=offset(d0,1);return date-d0<d1-date?d0:d1;}
function ceil(date){step(date=local(new d3_date(date-1)),1);return date;}
function offset(date,k){step(date=new d3_date(+date),k);return date;}
function range(t0,t1,dt){var time=ceil(t0),times=[];if(dt>1){while(time<t1){if(!(number(time)%dt))times.push(new Date(+time));step(time,1);}}else{while(time<t1)times.push(new Date(+time)),step(time,1);}
return times;}
function range_utc(t0,t1,dt){try{d3_date=d3_date_utc;var utc=new d3_date_utc();utc._=t0;return range(utc,t1,dt);}finally{d3_date=Date;}}
local.floor=local;local.round=round;local.ceil=ceil;local.offset=offset;local.range=range;var utc=local.utc=d3_time_interval_utc(local);utc.floor=utc;utc.round=d3_time_interval_utc(round);utc.ceil=d3_time_interval_utc(ceil);utc.offset=d3_time_interval_utc(offset);utc.range=range_utc;return local;}
function d3_time_interval_utc(method){return function(date,k){try{d3_date=d3_date_utc;var utc=new d3_date_utc();utc._=date;return method(utc,k)._;}finally{d3_date=Date;}};}
d3_time.year=d3_time_interval(function(date){date=d3_time.day(date);date.setMonth(0,1);return date;},function(date,offset){date.setFullYear(date.getFullYear()+offset);},function(date){return date.getFullYear();});d3_time.years=d3_time.year.range;d3_time.years.utc=d3_time.year.utc.range;d3_time.day=d3_time_interval(function(date){var day=new d3_date(2e3,0);day.setFullYear(date.getFullYear(),date.getMonth(),date.getDate());return day;},function(date,offset){date.setDate(date.getDate()+offset);},function(date){return date.getDate()-1;});d3_time.days=d3_time.day.range;d3_time.days.utc=d3_time.day.utc.range;d3_time.dayOfYear=function(date){var year=d3_time.year(date);return Math.floor((date-year-(date.getTimezoneOffset()-year.getTimezoneOffset())*6e4)/864e5);};["sunday","monday","tuesday","wednesday","thursday","friday","saturday"].forEach(function(day,i){i=7-i;var interval=d3_time[day]=d3_time_interval(function(date){(date=d3_time.day(date)).setDate(date.getDate()-(date.getDay()+i)%7);return date;},function(date,offset){date.setDate(date.getDate()+Math.floor(offset)*7);},function(date){var day=d3_time.year(date).getDay();return Math.floor((d3_time.dayOfYear(date)+(day+i)%7)/7)-(day!==i);});d3_time[day+"s"]=interval.range;d3_time[day+"s"].utc=interval.utc.range;d3_time[day+"OfYear"]=function(date){var day=d3_time.year(date).getDay();return Math.floor((d3_time.dayOfYear(date)+(day+i)%7)/7);};});d3_time.week=d3_time.sunday;d3_time.weeks=d3_time.sunday.range;d3_time.weeks.utc=d3_time.sunday.utc.range;d3_time.weekOfYear=d3_time.sundayOfYear;function d3_locale_timeFormat(locale){var locale_dateTime=locale.dateTime,locale_date=locale.date,locale_time=locale.time,locale_periods=locale.periods,locale_days=locale.days,locale_shortDays=locale.shortDays,locale_months=locale.months,locale_shortMonths=locale.shortMonths;function d3_time_format(template){var n=template.length;function format(date){var string=[],i=-1,j=0,c,p,f;while(++i<n){if(template.charCodeAt(i)===37){string.push(template.slice(j,i));if((p=d3_time_formatPads[c=template.charAt(++i)])!=null)c=template.charAt(++i);if(f=d3_time_formats[c])c=f(date,p==null?c==="e"?" ":"0":p);string.push(c);j=i+1;}}
string.push(template.slice(j,i));return string.join("");}
format.parse=function(string){var d={y:1900,m:0,d:1,H:0,M:0,S:0,L:0,Z:null},i=d3_time_parse(d,template,string,0);if(i!=string.length)return null;if("p"in d)d.H=d.H%12+d.p*12;var localZ=d.Z!=null&&d3_date!==d3_date_utc,date=new(localZ?d3_date_utc:d3_date)();if("j"in d)date.setFullYear(d.y,0,d.j);else if("w"in d&&("W"in d||"U"in d)){date.setFullYear(d.y,0,1);date.setFullYear(d.y,0,"W"in d?(d.w+6)%7+d.W*7-(date.getDay()+5)%7:d.w+d.U*7-(date.getDay()+6)%7);}else date.setFullYear(d.y,d.m,d.d);date.setHours(d.H+(d.Z/100|0),d.M+d.Z%100,d.S,d.L);return localZ?date._:date;};format.toString=function(){return template;};return format;}
function d3_time_parse(date,template,string,j){var c,p,t,i=0,n=template.length,m=string.length;while(i<n){if(j>=m)return-1;c=template.charCodeAt(i++);if(c===37){t=template.charAt(i++);p=d3_time_parsers[t in d3_time_formatPads?template.charAt(i++):t];if(!p||(j=p(date,string,j))<0)return-1;}else if(c!=string.charCodeAt(j++)){return-1;}}
return j;}
d3_time_format.utc=function(template){var local=d3_time_format(template);function format(date){try{d3_date=d3_date_utc;var utc=new d3_date();utc._=date;return local(utc);}finally{d3_date=Date;}}
format.parse=function(string){try{d3_date=d3_date_utc;var date=local.parse(string);return date&&date._;}finally{d3_date=Date;}};format.toString=local.toString;return format;};d3_time_format.multi=d3_time_format.utc.multi=d3_time_formatMulti;var d3_time_periodLookup=d3.map(),d3_time_dayRe=d3_time_formatRe(locale_days),d3_time_dayLookup=d3_time_formatLookup(locale_days),d3_time_dayAbbrevRe=d3_time_formatRe(locale_shortDays),d3_time_dayAbbrevLookup=d3_time_formatLookup(locale_shortDays),d3_time_monthRe=d3_time_formatRe(locale_months),d3_time_monthLookup=d3_time_formatLookup(locale_months),d3_time_monthAbbrevRe=d3_time_formatRe(locale_shortMonths),d3_time_monthAbbrevLookup=d3_time_formatLookup(locale_shortMonths);locale_periods.forEach(function(p,i){d3_time_periodLookup.set(p.toLowerCase(),i);});var d3_time_formats={a:function(d){return locale_shortDays[d.getDay()];},A:function(d){return locale_days[d.getDay()];},b:function(d){return locale_shortMonths[d.getMonth()];},B:function(d){return locale_months[d.getMonth()];},c:d3_time_format(locale_dateTime),d:function(d,p){return d3_time_formatPad(d.getDate(),p,2);},e:function(d,p){return d3_time_formatPad(d.getDate(),p,2);},H:function(d,p){return d3_time_formatPad(d.getHours(),p,2);},I:function(d,p){return d3_time_formatPad(d.getHours()%12||12,p,2);},j:function(d,p){return d3_time_formatPad(1+d3_time.dayOfYear(d),p,3);},L:function(d,p){return d3_time_formatPad(d.getMilliseconds(),p,3);},m:function(d,p){return d3_time_formatPad(d.getMonth()+1,p,2);},M:function(d,p){return d3_time_formatPad(d.getMinutes(),p,2);},p:function(d){return locale_periods[+(d.getHours()>=12)];},S:function(d,p){return d3_time_formatPad(d.getSeconds(),p,2);},U:function(d,p){return d3_time_formatPad(d3_time.sundayOfYear(d),p,2);},w:function(d){return d.getDay();},W:function(d,p){return d3_time_formatPad(d3_time.mondayOfYear(d),p,2);},x:d3_time_format(locale_date),X:d3_time_format(locale_time),y:function(d,p){return d3_time_formatPad(d.getFullYear()%100,p,2);},Y:function(d,p){return d3_time_formatPad(d.getFullYear()%1e4,p,4);},Z:d3_time_zone,"%":function(){return"%";}};var d3_time_parsers={a:d3_time_parseWeekdayAbbrev,A:d3_time_parseWeekday,b:d3_time_parseMonthAbbrev,B:d3_time_parseMonth,c:d3_time_parseLocaleFull,d:d3_time_parseDay,e:d3_time_parseDay,H:d3_time_parseHour24,I:d3_time_parseHour24,j:d3_time_parseDayOfYear,L:d3_time_parseMilliseconds,m:d3_time_parseMonthNumber,M:d3_time_parseMinutes,p:d3_time_parseAmPm,S:d3_time_parseSeconds,U:d3_time_parseWeekNumberSunday,w:d3_time_parseWeekdayNumber,W:d3_time_parseWeekNumberMonday,x:d3_time_parseLocaleDate,X:d3_time_parseLocaleTime,y:d3_time_parseYear,Y:d3_time_parseFullYear,Z:d3_time_parseZone,"%":d3_time_parseLiteralPercent};function d3_time_parseWeekdayAbbrev(date,string,i){d3_time_dayAbbrevRe.lastIndex=0;var n=d3_time_dayAbbrevRe.exec(string.slice(i));return n?(date.w=d3_time_dayAbbrevLookup.get(n[0].toLowerCase()),i+n[0].length):-1;}
function d3_time_parseWeekday(date,string,i){d3_time_dayRe.lastIndex=0;var n=d3_time_dayRe.exec(string.slice(i));return n?(date.w=d3_time_dayLookup.get(n[0].toLowerCase()),i+n[0].length):-1;}
function d3_time_parseMonthAbbrev(date,string,i){d3_time_monthAbbrevRe.lastIndex=0;var n=d3_time_monthAbbrevRe.exec(string.slice(i));return n?(date.m=d3_time_monthAbbrevLookup.get(n[0].toLowerCase()),i+n[0].length):-1;}
function d3_time_parseMonth(date,string,i){d3_time_monthRe.lastIndex=0;var n=d3_time_monthRe.exec(string.slice(i));return n?(date.m=d3_time_monthLookup.get(n[0].toLowerCase()),i+n[0].length):-1;}
function d3_time_parseLocaleFull(date,string,i){return d3_time_parse(date,d3_time_formats.c.toString(),string,i);}
function d3_time_parseLocaleDate(date,string,i){return d3_time_parse(date,d3_time_formats.x.toString(),string,i);}
function d3_time_parseLocaleTime(date,string,i){return d3_time_parse(date,d3_time_formats.X.toString(),string,i);}
function d3_time_parseAmPm(date,string,i){var n=d3_time_periodLookup.get(string.slice(i,i+=2).toLowerCase());return n==null?-1:(date.p=n,i);}
return d3_time_format;}
var d3_time_formatPads={"-":"",_:" ","0":"0"},d3_time_numberRe=/^\s*\d+/,d3_time_percentRe=/^%/;function d3_time_formatPad(value,fill,width){var sign=value<0?"-":"",string=(sign?-value:value)+"",length=string.length;return sign+(length<width?new Array(width-length+1).join(fill)+string:string);}
function d3_time_formatRe(names){return new RegExp("^(?:"+names.map(d3.requote).join("|")+")","i");}
function d3_time_formatLookup(names){var map=new d3_Map(),i=-1,n=names.length;while(++i<n)map.set(names[i].toLowerCase(),i);return map;}
function d3_time_parseWeekdayNumber(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+1));return n?(date.w=+n[0],i+n[0].length):-1;}
function d3_time_parseWeekNumberSunday(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i));return n?(date.U=+n[0],i+n[0].length):-1;}
function d3_time_parseWeekNumberMonday(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i));return n?(date.W=+n[0],i+n[0].length):-1;}
function d3_time_parseFullYear(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+4));return n?(date.y=+n[0],i+n[0].length):-1;}
function d3_time_parseYear(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+2));return n?(date.y=d3_time_expandYear(+n[0]),i+n[0].length):-1;}
function d3_time_parseZone(date,string,i){return/^[+-]\d{4}$/.test(string=string.slice(i,i+5))?(date.Z=-string,i+5):-1;}
function d3_time_expandYear(d){return d+(d>68?1900:2e3);}
function d3_time_parseMonthNumber(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+2));return n?(date.m=n[0]-1,i+n[0].length):-1;}
function d3_time_parseDay(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+2));return n?(date.d=+n[0],i+n[0].length):-1;}
function d3_time_parseDayOfYear(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+3));return n?(date.j=+n[0],i+n[0].length):-1;}
function d3_time_parseHour24(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+2));return n?(date.H=+n[0],i+n[0].length):-1;}
function d3_time_parseMinutes(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+2));return n?(date.M=+n[0],i+n[0].length):-1;}
function d3_time_parseSeconds(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+2));return n?(date.S=+n[0],i+n[0].length):-1;}
function d3_time_parseMilliseconds(date,string,i){d3_time_numberRe.lastIndex=0;var n=d3_time_numberRe.exec(string.slice(i,i+3));return n?(date.L=+n[0],i+n[0].length):-1;}
function d3_time_zone(d){var z=d.getTimezoneOffset(),zs=z>0?"-":"+",zh=abs(z)/60|0,zm=abs(z)%60;return zs+d3_time_formatPad(zh,"0",2)+d3_time_formatPad(zm,"0",2);}
function d3_time_parseLiteralPercent(date,string,i){d3_time_percentRe.lastIndex=0;var n=d3_time_percentRe.exec(string.slice(i,i+1));return n?i+n[0].length:-1;}
function d3_time_formatMulti(formats){var n=formats.length,i=-1;while(++i<n)formats[i][0]=this(formats[i][0]);return function(date){var i=0,f=formats[i];while(!f[1](date))f=formats[++i];return f[0](date);};}
d3.locale=function(locale){return{numberFormat:d3_locale_numberFormat(locale),timeFormat:d3_locale_timeFormat(locale)};};var d3_locale_enUS=d3.locale({decimal:".",thousands:",",grouping:[3],currency:["$",""],dateTime:"%a %b %e %X %Y",date:"%m/%d/%Y",time:"%H:%M:%S",periods:["AM","PM"],days:["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],shortDays:["Sun","Mon","Tue","Wed","Thu","Fri","Sat"],months:["January","February","March","April","May","June","July","August","September","October","November","December"],shortMonths:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]});d3.format=d3_locale_enUS.numberFormat;d3.geo={};function d3_adder(){}
d3_adder.prototype={s:0,t:0,add:function(y){d3_adderSum(y,this.t,d3_adderTemp);d3_adderSum(d3_adderTemp.s,this.s,this);if(this.s)this.t+=d3_adderTemp.t;else this.s=d3_adderTemp.t;},reset:function(){this.s=this.t=0;},valueOf:function(){return this.s;}};var d3_adderTemp=new d3_adder();function d3_adderSum(a,b,o){var x=o.s=a+b,bv=x-a,av=x-bv;o.t=a-av+(b-bv);}
d3.geo.stream=function(object,listener){if(object&&d3_geo_streamObjectType.hasOwnProperty(object.type)){d3_geo_streamObjectType[object.type](object,listener);}else{d3_geo_streamGeometry(object,listener);}};function d3_geo_streamGeometry(geometry,listener){if(geometry&&d3_geo_streamGeometryType.hasOwnProperty(geometry.type)){d3_geo_streamGeometryType[geometry.type](geometry,listener);}}
var d3_geo_streamObjectType={Feature:function(feature,listener){d3_geo_streamGeometry(feature.geometry,listener);},FeatureCollection:function(object,listener){var features=object.features,i=-1,n=features.length;while(++i<n)d3_geo_streamGeometry(features[i].geometry,listener);}};var d3_geo_streamGeometryType={Sphere:function(object,listener){listener.sphere();},Point:function(object,listener){object=object.coordinates;listener.point(object[0],object[1],object[2]);},MultiPoint:function(object,listener){var coordinates=object.coordinates,i=-1,n=coordinates.length;while(++i<n)object=coordinates[i],listener.point(object[0],object[1],object[2]);},LineString:function(object,listener){d3_geo_streamLine(object.coordinates,listener,0);},MultiLineString:function(object,listener){var coordinates=object.coordinates,i=-1,n=coordinates.length;while(++i<n)d3_geo_streamLine(coordinates[i],listener,0);},Polygon:function(object,listener){d3_geo_streamPolygon(object.coordinates,listener);},MultiPolygon:function(object,listener){var coordinates=object.coordinates,i=-1,n=coordinates.length;while(++i<n)d3_geo_streamPolygon(coordinates[i],listener);},GeometryCollection:function(object,listener){var geometries=object.geometries,i=-1,n=geometries.length;while(++i<n)d3_geo_streamGeometry(geometries[i],listener);}};function d3_geo_streamLine(coordinates,listener,closed){var i=-1,n=coordinates.length-closed,coordinate;listener.lineStart();while(++i<n)coordinate=coordinates[i],listener.point(coordinate[0],coordinate[1],coordinate[2]);listener.lineEnd();}
function d3_geo_streamPolygon(coordinates,listener){var i=-1,n=coordinates.length;listener.polygonStart();while(++i<n)d3_geo_streamLine(coordinates[i],listener,1);listener.polygonEnd();}
d3.geo.area=function(object){d3_geo_areaSum=0;d3.geo.stream(object,d3_geo_area);return d3_geo_areaSum;};var d3_geo_areaSum,d3_geo_areaRingSum=new d3_adder();var d3_geo_area={sphere:function(){d3_geo_areaSum+=4*π;},point:d3_noop,lineStart:d3_noop,lineEnd:d3_noop,polygonStart:function(){d3_geo_areaRingSum.reset();d3_geo_area.lineStart=d3_geo_areaRingStart;},polygonEnd:function(){var area=2*d3_geo_areaRingSum;d3_geo_areaSum+=area<0?4*π+area:area;d3_geo_area.lineStart=d3_geo_area.lineEnd=d3_geo_area.point=d3_noop;}};function d3_geo_areaRingStart(){var λ00,φ00,λ0,cosφ0,sinφ0;d3_geo_area.point=function(λ,φ){d3_geo_area.point=nextPoint;λ0=(λ00=λ)*d3_radians,cosφ0=Math.cos(φ=(φ00=φ)*d3_radians/2+π/4),sinφ0=Math.sin(φ);};function nextPoint(λ,φ){λ*=d3_radians;φ=φ*d3_radians/2+π/4;var dλ=λ-λ0,sdλ=dλ>=0?1:-1,adλ=sdλ*dλ,cosφ=Math.cos(φ),sinφ=Math.sin(φ),k=sinφ0*sinφ,u=cosφ0*cosφ+k*Math.cos(adλ),v=k*sdλ*Math.sin(adλ);d3_geo_areaRingSum.add(Math.atan2(v,u));λ0=λ,cosφ0=cosφ,sinφ0=sinφ;}
d3_geo_area.lineEnd=function(){nextPoint(λ00,φ00);};}
function d3_geo_cartesian(spherical){var λ=spherical[0],φ=spherical[1],cosφ=Math.cos(φ);return[cosφ*Math.cos(λ),cosφ*Math.sin(λ),Math.sin(φ)];}
function d3_geo_cartesianDot(a,b){return a[0]*b[0]+a[1]*b[1]+a[2]*b[2];}
function d3_geo_cartesianCross(a,b){return[a[1]*b[2]-a[2]*b[1],a[2]*b[0]-a[0]*b[2],a[0]*b[1]-a[1]*b[0]];}
function d3_geo_cartesianAdd(a,b){a[0]+=b[0];a[1]+=b[1];a[2]+=b[2];}
function d3_geo_cartesianScale(vector,k){return[vector[0]*k,vector[1]*k,vector[2]*k];}
function d3_geo_cartesianNormalize(d){var l=Math.sqrt(d[0]*d[0]+d[1]*d[1]+d[2]*d[2]);d[0]/=l;d[1]/=l;d[2]/=l;}
function d3_geo_spherical(cartesian){return[Math.atan2(cartesian[1],cartesian[0]),d3_asin(cartesian[2])];}
function d3_geo_sphericalEqual(a,b){return abs(a[0]-b[0])<ε&&abs(a[1]-b[1])<ε;}
d3.geo.bounds=function(){var λ0,φ0,λ1,φ1,λ_,λ__,φ__,p0,dλSum,ranges,range;var bound={point:point,lineStart:lineStart,lineEnd:lineEnd,polygonStart:function(){bound.point=ringPoint;bound.lineStart=ringStart;bound.lineEnd=ringEnd;dλSum=0;d3_geo_area.polygonStart();},polygonEnd:function(){d3_geo_area.polygonEnd();bound.point=point;bound.lineStart=lineStart;bound.lineEnd=lineEnd;if(d3_geo_areaRingSum<0)λ0=-(λ1=180),φ0=-(φ1=90);else if(dλSum>ε)φ1=90;else if(dλSum<-ε)φ0=-90;range[0]=λ0,range[1]=λ1;}};function point(λ,φ){ranges.push(range=[λ0=λ,λ1=λ]);if(φ<φ0)φ0=φ;if(φ>φ1)φ1=φ;}
function linePoint(λ,φ){var p=d3_geo_cartesian([λ*d3_radians,φ*d3_radians]);if(p0){var normal=d3_geo_cartesianCross(p0,p),equatorial=[normal[1],-normal[0],0],inflection=d3_geo_cartesianCross(equatorial,normal);d3_geo_cartesianNormalize(inflection);inflection=d3_geo_spherical(inflection);var dλ=λ-λ_,s=dλ>0?1:-1,λi=inflection[0]*d3_degrees*s,antimeridian=abs(dλ)>180;if(antimeridian^(s*λ_<λi&&λi<s*λ)){var φi=inflection[1]*d3_degrees;if(φi>φ1)φ1=φi;}else if(λi=(λi+360)%360-180,antimeridian^(s*λ_<λi&&λi<s*λ)){var φi=-inflection[1]*d3_degrees;if(φi<φ0)φ0=φi;}else{if(φ<φ0)φ0=φ;if(φ>φ1)φ1=φ;}
if(antimeridian){if(λ<λ_){if(angle(λ0,λ)>angle(λ0,λ1))λ1=λ;}else{if(angle(λ,λ1)>angle(λ0,λ1))λ0=λ;}}else{if(λ1>=λ0){if(λ<λ0)λ0=λ;if(λ>λ1)λ1=λ;}else{if(λ>λ_){if(angle(λ0,λ)>angle(λ0,λ1))λ1=λ;}else{if(angle(λ,λ1)>angle(λ0,λ1))λ0=λ;}}}}else{point(λ,φ);}
p0=p,λ_=λ;}
function lineStart(){bound.point=linePoint;}
function lineEnd(){range[0]=λ0,range[1]=λ1;bound.point=point;p0=null;}
function ringPoint(λ,φ){if(p0){var dλ=λ-λ_;dλSum+=abs(dλ)>180?dλ+(dλ>0?360:-360):dλ;}else λ__=λ,φ__=φ;d3_geo_area.point(λ,φ);linePoint(λ,φ);}
function ringStart(){d3_geo_area.lineStart();}
function ringEnd(){ringPoint(λ__,φ__);d3_geo_area.lineEnd();if(abs(dλSum)>ε)λ0=-(λ1=180);range[0]=λ0,range[1]=λ1;p0=null;}
function angle(λ0,λ1){return(λ1-=λ0)<0?λ1+360:λ1;}
function compareRanges(a,b){return a[0]-b[0];}
function withinRange(x,range){return range[0]<=range[1]?range[0]<=x&&x<=range[1]:x<range[0]||range[1]<x;}
return function(feature){φ1=λ1=-(λ0=φ0=Infinity);ranges=[];d3.geo.stream(feature,bound);var n=ranges.length;if(n){ranges.sort(compareRanges);for(var i=1,a=ranges[0],b,merged=[a];i<n;++i){b=ranges[i];if(withinRange(b[0],a)||withinRange(b[1],a)){if(angle(a[0],b[1])>angle(a[0],a[1]))a[1]=b[1];if(angle(b[0],a[1])>angle(a[0],a[1]))a[0]=b[0];}else{merged.push(a=b);}}
var best=-Infinity,dλ;for(var n=merged.length-1,i=0,a=merged[n],b;i<=n;a=b,++i){b=merged[i];if((dλ=angle(a[1],b[0]))>best)best=dλ,λ0=b[0],λ1=a[1];}}
ranges=range=null;return λ0===Infinity||φ0===Infinity?[[NaN,NaN],[NaN,NaN]]:[[λ0,φ0],[λ1,φ1]];};}();d3.geo.centroid=function(object){d3_geo_centroidW0=d3_geo_centroidW1=d3_geo_centroidX0=d3_geo_centroidY0=d3_geo_centroidZ0=d3_geo_centroidX1=d3_geo_centroidY1=d3_geo_centroidZ1=d3_geo_centroidX2=d3_geo_centroidY2=d3_geo_centroidZ2=0;d3.geo.stream(object,d3_geo_centroid);var x=d3_geo_centroidX2,y=d3_geo_centroidY2,z=d3_geo_centroidZ2,m=x*x+y*y+z*z;if(m<ε2){x=d3_geo_centroidX1,y=d3_geo_centroidY1,z=d3_geo_centroidZ1;if(d3_geo_centroidW1<ε)x=d3_geo_centroidX0,y=d3_geo_centroidY0,z=d3_geo_centroidZ0;m=x*x+y*y+z*z;if(m<ε2)return[NaN,NaN];}
return[Math.atan2(y,x)*d3_degrees,d3_asin(z/Math.sqrt(m))*d3_degrees];};var d3_geo_centroidW0,d3_geo_centroidW1,d3_geo_centroidX0,d3_geo_centroidY0,d3_geo_centroidZ0,d3_geo_centroidX1,d3_geo_centroidY1,d3_geo_centroidZ1,d3_geo_centroidX2,d3_geo_centroidY2,d3_geo_centroidZ2;var d3_geo_centroid={sphere:d3_noop,point:d3_geo_centroidPoint,lineStart:d3_geo_centroidLineStart,lineEnd:d3_geo_centroidLineEnd,polygonStart:function(){d3_geo_centroid.lineStart=d3_geo_centroidRingStart;},polygonEnd:function(){d3_geo_centroid.lineStart=d3_geo_centroidLineStart;}};function d3_geo_centroidPoint(λ,φ){λ*=d3_radians;var cosφ=Math.cos(φ*=d3_radians);d3_geo_centroidPointXYZ(cosφ*Math.cos(λ),cosφ*Math.sin(λ),Math.sin(φ));}
function d3_geo_centroidPointXYZ(x,y,z){++d3_geo_centroidW0;d3_geo_centroidX0+=(x-d3_geo_centroidX0)/d3_geo_centroidW0;d3_geo_centroidY0+=(y-d3_geo_centroidY0)/d3_geo_centroidW0;d3_geo_centroidZ0+=(z-d3_geo_centroidZ0)/d3_geo_centroidW0;}
function d3_geo_centroidLineStart(){var x0,y0,z0;d3_geo_centroid.point=function(λ,φ){λ*=d3_radians;var cosφ=Math.cos(φ*=d3_radians);x0=cosφ*Math.cos(λ);y0=cosφ*Math.sin(λ);z0=Math.sin(φ);d3_geo_centroid.point=nextPoint;d3_geo_centroidPointXYZ(x0,y0,z0);};function nextPoint(λ,φ){λ*=d3_radians;var cosφ=Math.cos(φ*=d3_radians),x=cosφ*Math.cos(λ),y=cosφ*Math.sin(λ),z=Math.sin(φ),w=Math.atan2(Math.sqrt((w=y0*z-z0*y)*w+(w=z0*x-x0*z)*w+(w=x0*y-y0*x)*w),x0*x+y0*y+z0*z);d3_geo_centroidW1+=w;d3_geo_centroidX1+=w*(x0+(x0=x));d3_geo_centroidY1+=w*(y0+(y0=y));d3_geo_centroidZ1+=w*(z0+(z0=z));d3_geo_centroidPointXYZ(x0,y0,z0);}}
function d3_geo_centroidLineEnd(){d3_geo_centroid.point=d3_geo_centroidPoint;}
function d3_geo_centroidRingStart(){var λ00,φ00,x0,y0,z0;d3_geo_centroid.point=function(λ,φ){λ00=λ,φ00=φ;d3_geo_centroid.point=nextPoint;λ*=d3_radians;var cosφ=Math.cos(φ*=d3_radians);x0=cosφ*Math.cos(λ);y0=cosφ*Math.sin(λ);z0=Math.sin(φ);d3_geo_centroidPointXYZ(x0,y0,z0);};d3_geo_centroid.lineEnd=function(){nextPoint(λ00,φ00);d3_geo_centroid.lineEnd=d3_geo_centroidLineEnd;d3_geo_centroid.point=d3_geo_centroidPoint;};function nextPoint(λ,φ){λ*=d3_radians;var cosφ=Math.cos(φ*=d3_radians),x=cosφ*Math.cos(λ),y=cosφ*Math.sin(λ),z=Math.sin(φ),cx=y0*z-z0*y,cy=z0*x-x0*z,cz=x0*y-y0*x,m=Math.sqrt(cx*cx+cy*cy+cz*cz),u=x0*x+y0*y+z0*z,v=m&&-d3_acos(u)/m,w=Math.atan2(m,u);d3_geo_centroidX2+=v*cx;d3_geo_centroidY2+=v*cy;d3_geo_centroidZ2+=v*cz;d3_geo_centroidW1+=w;d3_geo_centroidX1+=w*(x0+(x0=x));d3_geo_centroidY1+=w*(y0+(y0=y));d3_geo_centroidZ1+=w*(z0+(z0=z));d3_geo_centroidPointXYZ(x0,y0,z0);}}
function d3_geo_compose(a,b){function compose(x,y){return x=a(x,y),b(x[0],x[1]);}
if(a.invert&&b.invert)compose.invert=function(x,y){return x=b.invert(x,y),x&&a.invert(x[0],x[1]);};return compose;}
function d3_true(){return true;}
function d3_geo_clipPolygon(segments,compare,clipStartInside,interpolate,listener){var subject=[],clip=[];segments.forEach(function(segment){if((n=segment.length-1)<=0)return;var n,p0=segment[0],p1=segment[n];if(d3_geo_sphericalEqual(p0,p1)){listener.lineStart();for(var i=0;i<n;++i)listener.point((p0=segment[i])[0],p0[1]);listener.lineEnd();return;}
var a=new d3_geo_clipPolygonIntersection(p0,segment,null,true),b=new d3_geo_clipPolygonIntersection(p0,null,a,false);a.o=b;subject.push(a);clip.push(b);a=new d3_geo_clipPolygonIntersection(p1,segment,null,false);b=new d3_geo_clipPolygonIntersection(p1,null,a,true);a.o=b;subject.push(a);clip.push(b);});clip.sort(compare);d3_geo_clipPolygonLinkCircular(subject);d3_geo_clipPolygonLinkCircular(clip);if(!subject.length)return;for(var i=0,entry=clipStartInside,n=clip.length;i<n;++i){clip[i].e=entry=!entry;}
var start=subject[0],points,point;while(1){var current=start,isSubject=true;while(current.v)if((current=current.n)===start)return;points=current.z;listener.lineStart();do{current.v=current.o.v=true;if(current.e){if(isSubject){for(var i=0,n=points.length;i<n;++i)listener.point((point=points[i])[0],point[1]);}else{interpolate(current.x,current.n.x,1,listener);}
current=current.n;}else{if(isSubject){points=current.p.z;for(var i=points.length-1;i>=0;--i)listener.point((point=points[i])[0],point[1]);}else{interpolate(current.x,current.p.x,-1,listener);}
current=current.p;}
current=current.o;points=current.z;isSubject=!isSubject;}while(!current.v);listener.lineEnd();}}
function d3_geo_clipPolygonLinkCircular(array){if(!(n=array.length))return;var n,i=0,a=array[0],b;while(++i<n){a.n=b=array[i];b.p=a;a=b;}
a.n=b=array[0];b.p=a;}
function d3_geo_clipPolygonIntersection(point,points,other,entry){this.x=point;this.z=points;this.o=other;this.e=entry;this.v=false;this.n=this.p=null;}
function d3_geo_clip(pointVisible,clipLine,interpolate,clipStart){return function(rotate,listener){var line=clipLine(listener),rotatedClipStart=rotate.invert(clipStart[0],clipStart[1]);var clip={point:point,lineStart:lineStart,lineEnd:lineEnd,polygonStart:function(){clip.point=pointRing;clip.lineStart=ringStart;clip.lineEnd=ringEnd;segments=[];polygon=[];},polygonEnd:function(){clip.point=point;clip.lineStart=lineStart;clip.lineEnd=lineEnd;segments=d3.merge(segments);var clipStartInside=d3_geo_pointInPolygon(rotatedClipStart,polygon);if(segments.length){if(!polygonStarted)listener.polygonStart(),polygonStarted=true;d3_geo_clipPolygon(segments,d3_geo_clipSort,clipStartInside,interpolate,listener);}else if(clipStartInside){if(!polygonStarted)listener.polygonStart(),polygonStarted=true;listener.lineStart();interpolate(null,null,1,listener);listener.lineEnd();}
if(polygonStarted)listener.polygonEnd(),polygonStarted=false;segments=polygon=null;},sphere:function(){listener.polygonStart();listener.lineStart();interpolate(null,null,1,listener);listener.lineEnd();listener.polygonEnd();}};function point(λ,φ){var point=rotate(λ,φ);if(pointVisible(λ=point[0],φ=point[1]))listener.point(λ,φ);}
function pointLine(λ,φ){var point=rotate(λ,φ);line.point(point[0],point[1]);}
function lineStart(){clip.point=pointLine;line.lineStart();}
function lineEnd(){clip.point=point;line.lineEnd();}
var segments;var buffer=d3_geo_clipBufferListener(),ringListener=clipLine(buffer),polygonStarted=false,polygon,ring;function pointRing(λ,φ){ring.push([λ,φ]);var point=rotate(λ,φ);ringListener.point(point[0],point[1]);}
function ringStart(){ringListener.lineStart();ring=[];}
function ringEnd(){pointRing(ring[0][0],ring[0][1]);ringListener.lineEnd();var clean=ringListener.clean(),ringSegments=buffer.buffer(),segment,n=ringSegments.length;ring.pop();polygon.push(ring);ring=null;if(!n)return;if(clean&1){segment=ringSegments[0];var n=segment.length-1,i=-1,point;if(n>0){if(!polygonStarted)listener.polygonStart(),polygonStarted=true;listener.lineStart();while(++i<n)listener.point((point=segment[i])[0],point[1]);listener.lineEnd();}
return;}
if(n>1&&clean&2)ringSegments.push(ringSegments.pop().concat(ringSegments.shift()));segments.push(ringSegments.filter(d3_geo_clipSegmentLength1));}
return clip;};}
function d3_geo_clipSegmentLength1(segment){return segment.length>1;}
function d3_geo_clipBufferListener(){var lines=[],line;return{lineStart:function(){lines.push(line=[]);},point:function(λ,φ){line.push([λ,φ]);},lineEnd:d3_noop,buffer:function(){var buffer=lines;lines=[];line=null;return buffer;},rejoin:function(){if(lines.length>1)lines.push(lines.pop().concat(lines.shift()));}};}
function d3_geo_clipSort(a,b){return((a=a.x)[0]<0?a[1]-halfπ-ε:halfπ-a[1])-((b=b.x)[0]<0?b[1]-halfπ-ε:halfπ-b[1]);}
var d3_geo_clipAntimeridian=d3_geo_clip(d3_true,d3_geo_clipAntimeridianLine,d3_geo_clipAntimeridianInterpolate,[-π,-π/2]);function d3_geo_clipAntimeridianLine(listener){var λ0=NaN,φ0=NaN,sλ0=NaN,clean;return{lineStart:function(){listener.lineStart();clean=1;},point:function(λ1,φ1){var sλ1=λ1>0?π:-π,dλ=abs(λ1-λ0);if(abs(dλ-π)<ε){listener.point(λ0,φ0=(φ0+φ1)/2>0?halfπ:-halfπ);listener.point(sλ0,φ0);listener.lineEnd();listener.lineStart();listener.point(sλ1,φ0);listener.point(λ1,φ0);clean=0;}else if(sλ0!==sλ1&&dλ>=π){if(abs(λ0-sλ0)<ε)λ0-=sλ0*ε;if(abs(λ1-sλ1)<ε)λ1-=sλ1*ε;φ0=d3_geo_clipAntimeridianIntersect(λ0,φ0,λ1,φ1);listener.point(sλ0,φ0);listener.lineEnd();listener.lineStart();listener.point(sλ1,φ0);clean=0;}
listener.point(λ0=λ1,φ0=φ1);sλ0=sλ1;},lineEnd:function(){listener.lineEnd();λ0=φ0=NaN;},clean:function(){return 2-clean;}};}
function d3_geo_clipAntimeridianIntersect(λ0,φ0,λ1,φ1){var cosφ0,cosφ1,sinλ0_λ1=Math.sin(λ0-λ1);return abs(sinλ0_λ1)>ε?Math.atan((Math.sin(φ0)*(cosφ1=Math.cos(φ1))*Math.sin(λ1)-Math.sin(φ1)*(cosφ0=Math.cos(φ0))*Math.sin(λ0))/(cosφ0*cosφ1*sinλ0_λ1)):(φ0+φ1)/2;}
function d3_geo_clipAntimeridianInterpolate(from,to,direction,listener){var φ;if(from==null){φ=direction*halfπ;listener.point(-π,φ);listener.point(0,φ);listener.point(π,φ);listener.point(π,0);listener.point(π,-φ);listener.point(0,-φ);listener.point(-π,-φ);listener.point(-π,0);listener.point(-π,φ);}else if(abs(from[0]-to[0])>ε){var s=from[0]<to[0]?π:-π;φ=direction*s/2;listener.point(-s,φ);listener.point(0,φ);listener.point(s,φ);}else{listener.point(to[0],to[1]);}}
function d3_geo_pointInPolygon(point,polygon){var meridian=point[0],parallel=point[1],meridianNormal=[Math.sin(meridian),-Math.cos(meridian),0],polarAngle=0,winding=0;d3_geo_areaRingSum.reset();for(var i=0,n=polygon.length;i<n;++i){var ring=polygon[i],m=ring.length;if(!m)continue;var point0=ring[0],λ0=point0[0],φ0=point0[1]/2+π/4,sinφ0=Math.sin(φ0),cosφ0=Math.cos(φ0),j=1;while(true){if(j===m)j=0;point=ring[j];var λ=point[0],φ=point[1]/2+π/4,sinφ=Math.sin(φ),cosφ=Math.cos(φ),dλ=λ-λ0,sdλ=dλ>=0?1:-1,adλ=sdλ*dλ,antimeridian=adλ>π,k=sinφ0*sinφ;d3_geo_areaRingSum.add(Math.atan2(k*sdλ*Math.sin(adλ),cosφ0*cosφ+k*Math.cos(adλ)));polarAngle+=antimeridian?dλ+sdλ*τ:dλ;if(antimeridian^λ0>=meridian^λ>=meridian){var arc=d3_geo_cartesianCross(d3_geo_cartesian(point0),d3_geo_cartesian(point));d3_geo_cartesianNormalize(arc);var intersection=d3_geo_cartesianCross(meridianNormal,arc);d3_geo_cartesianNormalize(intersection);var φarc=(antimeridian^dλ>=0?-1:1)*d3_asin(intersection[2]);if(parallel>φarc||parallel===φarc&&(arc[0]||arc[1])){winding+=antimeridian^dλ>=0?1:-1;}}
if(!j++)break;λ0=λ,sinφ0=sinφ,cosφ0=cosφ,point0=point;}}
return(polarAngle<-ε||polarAngle<ε&&d3_geo_areaRingSum<0)^winding&1;}
function d3_geo_clipCircle(radius){var cr=Math.cos(radius),smallRadius=cr>0,notHemisphere=abs(cr)>ε,interpolate=d3_geo_circleInterpolate(radius,6*d3_radians);return d3_geo_clip(visible,clipLine,interpolate,smallRadius?[0,-radius]:[-π,radius-π]);function visible(λ,φ){return Math.cos(λ)*Math.cos(φ)>cr;}
function clipLine(listener){var point0,c0,v0,v00,clean;return{lineStart:function(){v00=v0=false;clean=1;},point:function(λ,φ){var point1=[λ,φ],point2,v=visible(λ,φ),c=smallRadius?v?0:code(λ,φ):v?code(λ+(λ<0?π:-π),φ):0;if(!point0&&(v00=v0=v))listener.lineStart();if(v!==v0){point2=intersect(point0,point1);if(d3_geo_sphericalEqual(point0,point2)||d3_geo_sphericalEqual(point1,point2)){point1[0]+=ε;point1[1]+=ε;v=visible(point1[0],point1[1]);}}
if(v!==v0){clean=0;if(v){listener.lineStart();point2=intersect(point1,point0);listener.point(point2[0],point2[1]);}else{point2=intersect(point0,point1);listener.point(point2[0],point2[1]);listener.lineEnd();}
point0=point2;}else if(notHemisphere&&point0&&smallRadius^v){var t;if(!(c&c0)&&(t=intersect(point1,point0,true))){clean=0;if(smallRadius){listener.lineStart();listener.point(t[0][0],t[0][1]);listener.point(t[1][0],t[1][1]);listener.lineEnd();}else{listener.point(t[1][0],t[1][1]);listener.lineEnd();listener.lineStart();listener.point(t[0][0],t[0][1]);}}}
if(v&&(!point0||!d3_geo_sphericalEqual(point0,point1))){listener.point(point1[0],point1[1]);}
point0=point1,v0=v,c0=c;},lineEnd:function(){if(v0)listener.lineEnd();point0=null;},clean:function(){return clean|(v00&&v0)<<1;}};}
function intersect(a,b,two){var pa=d3_geo_cartesian(a),pb=d3_geo_cartesian(b);var n1=[1,0,0],n2=d3_geo_cartesianCross(pa,pb),n2n2=d3_geo_cartesianDot(n2,n2),n1n2=n2[0],determinant=n2n2-n1n2*n1n2;if(!determinant)return!two&&a;var c1=cr*n2n2/determinant,c2=-cr*n1n2/determinant,n1xn2=d3_geo_cartesianCross(n1,n2),A=d3_geo_cartesianScale(n1,c1),B=d3_geo_cartesianScale(n2,c2);d3_geo_cartesianAdd(A,B);var u=n1xn2,w=d3_geo_cartesianDot(A,u),uu=d3_geo_cartesianDot(u,u),t2=w*w-uu*(d3_geo_cartesianDot(A,A)-1);if(t2<0)return;var t=Math.sqrt(t2),q=d3_geo_cartesianScale(u,(-w-t)/uu);d3_geo_cartesianAdd(q,A);q=d3_geo_spherical(q);if(!two)return q;var λ0=a[0],λ1=b[0],φ0=a[1],φ1=b[1],z;if(λ1<λ0)z=λ0,λ0=λ1,λ1=z;var δλ=λ1-λ0,polar=abs(δλ-π)<ε,meridian=polar||δλ<ε;if(!polar&&φ1<φ0)z=φ0,φ0=φ1,φ1=z;if(meridian?polar?φ0+φ1>0^q[1]<(abs(q[0]-λ0)<ε?φ0:φ1):φ0<=q[1]&&q[1]<=φ1:δλ>π^(λ0<=q[0]&&q[0]<=λ1)){var q1=d3_geo_cartesianScale(u,(-w+t)/uu);d3_geo_cartesianAdd(q1,A);return[q,d3_geo_spherical(q1)];}}
function code(λ,φ){var r=smallRadius?radius:π-radius,code=0;if(λ<-r)code|=1;else if(λ>r)code|=2;if(φ<-r)code|=4;else if(φ>r)code|=8;return code;}}
function d3_geom_clipLine(x0,y0,x1,y1){return function(line){var a=line.a,b=line.b,ax=a.x,ay=a.y,bx=b.x,by=b.y,t0=0,t1=1,dx=bx-ax,dy=by-ay,r;r=x0-ax;if(!dx&&r>0)return;r/=dx;if(dx<0){if(r<t0)return;if(r<t1)t1=r;}else if(dx>0){if(r>t1)return;if(r>t0)t0=r;}
r=x1-ax;if(!dx&&r<0)return;r/=dx;if(dx<0){if(r>t1)return;if(r>t0)t0=r;}else if(dx>0){if(r<t0)return;if(r<t1)t1=r;}
r=y0-ay;if(!dy&&r>0)return;r/=dy;if(dy<0){if(r<t0)return;if(r<t1)t1=r;}else if(dy>0){if(r>t1)return;if(r>t0)t0=r;}
r=y1-ay;if(!dy&&r<0)return;r/=dy;if(dy<0){if(r>t1)return;if(r>t0)t0=r;}else if(dy>0){if(r<t0)return;if(r<t1)t1=r;}
if(t0>0)line.a={x:ax+t0*dx,y:ay+t0*dy};if(t1<1)line.b={x:ax+t1*dx,y:ay+t1*dy};return line;};}
var d3_geo_clipExtentMAX=1e9;d3.geo.clipExtent=function(){var x0,y0,x1,y1,stream,clip,clipExtent={stream:function(output){if(stream)stream.valid=false;stream=clip(output);stream.valid=true;return stream;},extent:function(_){if(!arguments.length)return[[x0,y0],[x1,y1]];clip=d3_geo_clipExtent(x0=+_[0][0],y0=+_[0][1],x1=+_[1][0],y1=+_[1][1]);if(stream)stream.valid=false,stream=null;return clipExtent;}};return clipExtent.extent([[0,0],[960,500]]);};function d3_geo_clipExtent(x0,y0,x1,y1){return function(listener){var listener_=listener,bufferListener=d3_geo_clipBufferListener(),clipLine=d3_geom_clipLine(x0,y0,x1,y1),segments,polygon,ring;var clip={point:point,lineStart:lineStart,lineEnd:lineEnd,polygonStart:function(){listener=bufferListener;segments=[];polygon=[];clean=true;},polygonEnd:function(){listener=listener_;segments=d3.merge(segments);var clipStartInside=insidePolygon([x0,y1]),inside=clean&&clipStartInside,visible=segments.length;if(inside||visible){listener.polygonStart();if(inside){listener.lineStart();interpolate(null,null,1,listener);listener.lineEnd();}
if(visible){d3_geo_clipPolygon(segments,compare,clipStartInside,interpolate,listener);}
listener.polygonEnd();}
segments=polygon=ring=null;}};function insidePolygon(p){var wn=0,n=polygon.length,y=p[1];for(var i=0;i<n;++i){for(var j=1,v=polygon[i],m=v.length,a=v[0],b;j<m;++j){b=v[j];if(a[1]<=y){if(b[1]>y&&d3_cross2d(a,b,p)>0)++wn;}else{if(b[1]<=y&&d3_cross2d(a,b,p)<0)--wn;}
a=b;}}
return wn!==0;}
function interpolate(from,to,direction,listener){var a=0,a1=0;if(from==null||(a=corner(from,direction))!==(a1=corner(to,direction))||comparePoints(from,to)<0^direction>0){do{listener.point(a===0||a===3?x0:x1,a>1?y1:y0);}while((a=(a+direction+4)%4)!==a1);}else{listener.point(to[0],to[1]);}}
function pointVisible(x,y){return x0<=x&&x<=x1&&y0<=y&&y<=y1;}
function point(x,y){if(pointVisible(x,y))listener.point(x,y);}
var x__,y__,v__,x_,y_,v_,first,clean;function lineStart(){clip.point=linePoint;if(polygon)polygon.push(ring=[]);first=true;v_=false;x_=y_=NaN;}
function lineEnd(){if(segments){linePoint(x__,y__);if(v__&&v_)bufferListener.rejoin();segments.push(bufferListener.buffer());}
clip.point=point;if(v_)listener.lineEnd();}
function linePoint(x,y){x=Math.max(-d3_geo_clipExtentMAX,Math.min(d3_geo_clipExtentMAX,x));y=Math.max(-d3_geo_clipExtentMAX,Math.min(d3_geo_clipExtentMAX,y));var v=pointVisible(x,y);if(polygon)ring.push([x,y]);if(first){x__=x,y__=y,v__=v;first=false;if(v){listener.lineStart();listener.point(x,y);}}else{if(v&&v_)listener.point(x,y);else{var l={a:{x:x_,y:y_},b:{x:x,y:y}};if(clipLine(l)){if(!v_){listener.lineStart();listener.point(l.a.x,l.a.y);}
listener.point(l.b.x,l.b.y);if(!v)listener.lineEnd();clean=false;}else if(v){listener.lineStart();listener.point(x,y);clean=false;}}}
x_=x,y_=y,v_=v;}
return clip;};function corner(p,direction){return abs(p[0]-x0)<ε?direction>0?0:3:abs(p[0]-x1)<ε?direction>0?2:1:abs(p[1]-y0)<ε?direction>0?1:0:direction>0?3:2;}
function compare(a,b){return comparePoints(a.x,b.x);}
function comparePoints(a,b){var ca=corner(a,1),cb=corner(b,1);return ca!==cb?ca-cb:ca===0?b[1]-a[1]:ca===1?a[0]-b[0]:ca===2?a[1]-b[1]:b[0]-a[0];}}
function d3_geo_conic(projectAt){var φ0=0,φ1=π/3,m=d3_geo_projectionMutator(projectAt),p=m(φ0,φ1);p.parallels=function(_){if(!arguments.length)return[φ0/π*180,φ1/π*180];return m(φ0=_[0]*π/180,φ1=_[1]*π/180);};return p;}
function d3_geo_conicEqualArea(φ0,φ1){var sinφ0=Math.sin(φ0),n=(sinφ0+Math.sin(φ1))/2,C=1+sinφ0*(2*n-sinφ0),ρ0=Math.sqrt(C)/n;function forward(λ,φ){var ρ=Math.sqrt(C-2*n*Math.sin(φ))/n;return[ρ*Math.sin(λ*=n),ρ0-ρ*Math.cos(λ)];}
forward.invert=function(x,y){var ρ0_y=ρ0-y;return[Math.atan2(x,ρ0_y)/n,d3_asin((C-(x*x+ρ0_y*ρ0_y)*n*n)/(2*n))];};return forward;}
(d3.geo.conicEqualArea=function(){return d3_geo_conic(d3_geo_conicEqualArea);}).raw=d3_geo_conicEqualArea;d3.geo.albers=function(){return d3.geo.conicEqualArea().rotate([96,0]).center([-.6,38.7]).parallels([29.5,45.5]).scale(1070);};d3.geo.albersUsa=function(){var lower48=d3.geo.albers();var alaska=d3.geo.conicEqualArea().rotate([154,0]).center([-2,58.5]).parallels([55,65]);var hawaii=d3.geo.conicEqualArea().rotate([157,0]).center([-3,19.9]).parallels([8,18]);var point,pointStream={point:function(x,y){point=[x,y];}},lower48Point,alaskaPoint,hawaiiPoint;function albersUsa(coordinates){var x=coordinates[0],y=coordinates[1];point=null;(lower48Point(x,y),point)||(alaskaPoint(x,y),point)||hawaiiPoint(x,y);return point;}
albersUsa.invert=function(coordinates){var k=lower48.scale(),t=lower48.translate(),x=(coordinates[0]-t[0])/k,y=(coordinates[1]-t[1])/k;return(y>=.12&&y<.234&&x>=-.425&&x<-.214?alaska:y>=.166&&y<.234&&x>=-.214&&x<-.115?hawaii:lower48).invert(coordinates);};albersUsa.stream=function(stream){var lower48Stream=lower48.stream(stream),alaskaStream=alaska.stream(stream),hawaiiStream=hawaii.stream(stream);return{point:function(x,y){lower48Stream.point(x,y);alaskaStream.point(x,y);hawaiiStream.point(x,y);},sphere:function(){lower48Stream.sphere();alaskaStream.sphere();hawaiiStream.sphere();},lineStart:function(){lower48Stream.lineStart();alaskaStream.lineStart();hawaiiStream.lineStart();},lineEnd:function(){lower48Stream.lineEnd();alaskaStream.lineEnd();hawaiiStream.lineEnd();},polygonStart:function(){lower48Stream.polygonStart();alaskaStream.polygonStart();hawaiiStream.polygonStart();},polygonEnd:function(){lower48Stream.polygonEnd();alaskaStream.polygonEnd();hawaiiStream.polygonEnd();}};};albersUsa.precision=function(_){if(!arguments.length)return lower48.precision();lower48.precision(_);alaska.precision(_);hawaii.precision(_);return albersUsa;};albersUsa.scale=function(_){if(!arguments.length)return lower48.scale();lower48.scale(_);alaska.scale(_*.35);hawaii.scale(_);return albersUsa.translate(lower48.translate());};albersUsa.translate=function(_){if(!arguments.length)return lower48.translate();var k=lower48.scale(),x=+_[0],y=+_[1];lower48Point=lower48.translate(_).clipExtent([[x-.455*k,y-.238*k],[x+.455*k,y+.238*k]]).stream(pointStream).point;alaskaPoint=alaska.translate([x-.307*k,y+.201*k]).clipExtent([[x-.425*k+ε,y+.12*k+ε],[x-.214*k-ε,y+.234*k-ε]]).stream(pointStream).point;hawaiiPoint=hawaii.translate([x-.205*k,y+.212*k]).clipExtent([[x-.214*k+ε,y+.166*k+ε],[x-.115*k-ε,y+.234*k-ε]]).stream(pointStream).point;return albersUsa;};return albersUsa.scale(1070);};var d3_geo_pathAreaSum,d3_geo_pathAreaPolygon,d3_geo_pathArea={point:d3_noop,lineStart:d3_noop,lineEnd:d3_noop,polygonStart:function(){d3_geo_pathAreaPolygon=0;d3_geo_pathArea.lineStart=d3_geo_pathAreaRingStart;},polygonEnd:function(){d3_geo_pathArea.lineStart=d3_geo_pathArea.lineEnd=d3_geo_pathArea.point=d3_noop;d3_geo_pathAreaSum+=abs(d3_geo_pathAreaPolygon/2);}};function d3_geo_pathAreaRingStart(){var x00,y00,x0,y0;d3_geo_pathArea.point=function(x,y){d3_geo_pathArea.point=nextPoint;x00=x0=x,y00=y0=y;};function nextPoint(x,y){d3_geo_pathAreaPolygon+=y0*x-x0*y;x0=x,y0=y;}
d3_geo_pathArea.lineEnd=function(){nextPoint(x00,y00);};}
var d3_geo_pathBoundsX0,d3_geo_pathBoundsY0,d3_geo_pathBoundsX1,d3_geo_pathBoundsY1;var d3_geo_pathBounds={point:d3_geo_pathBoundsPoint,lineStart:d3_noop,lineEnd:d3_noop,polygonStart:d3_noop,polygonEnd:d3_noop};function d3_geo_pathBoundsPoint(x,y){if(x<d3_geo_pathBoundsX0)d3_geo_pathBoundsX0=x;if(x>d3_geo_pathBoundsX1)d3_geo_pathBoundsX1=x;if(y<d3_geo_pathBoundsY0)d3_geo_pathBoundsY0=y;if(y>d3_geo_pathBoundsY1)d3_geo_pathBoundsY1=y;}
function d3_geo_pathBuffer(){var pointCircle=d3_geo_pathBufferCircle(4.5),buffer=[];var stream={point:point,lineStart:function(){stream.point=pointLineStart;},lineEnd:lineEnd,polygonStart:function(){stream.lineEnd=lineEndPolygon;},polygonEnd:function(){stream.lineEnd=lineEnd;stream.point=point;},pointRadius:function(_){pointCircle=d3_geo_pathBufferCircle(_);return stream;},result:function(){if(buffer.length){var result=buffer.join("");buffer=[];return result;}}};function point(x,y){buffer.push("M",x,",",y,pointCircle);}
function pointLineStart(x,y){buffer.push("M",x,",",y);stream.point=pointLine;}
function pointLine(x,y){buffer.push("L",x,",",y);}
function lineEnd(){stream.point=point;}
function lineEndPolygon(){buffer.push("Z");}
return stream;}
function d3_geo_pathBufferCircle(radius){return"m0,"+radius+"a"+radius+","+radius+" 0 1,1 0,"+-2*radius+"a"+radius+","+radius+" 0 1,1 0,"+2*radius+"z";}
var d3_geo_pathCentroid={point:d3_geo_pathCentroidPoint,lineStart:d3_geo_pathCentroidLineStart,lineEnd:d3_geo_pathCentroidLineEnd,polygonStart:function(){d3_geo_pathCentroid.lineStart=d3_geo_pathCentroidRingStart;},polygonEnd:function(){d3_geo_pathCentroid.point=d3_geo_pathCentroidPoint;d3_geo_pathCentroid.lineStart=d3_geo_pathCentroidLineStart;d3_geo_pathCentroid.lineEnd=d3_geo_pathCentroidLineEnd;}};function d3_geo_pathCentroidPoint(x,y){d3_geo_centroidX0+=x;d3_geo_centroidY0+=y;++d3_geo_centroidZ0;}
function d3_geo_pathCentroidLineStart(){var x0,y0;d3_geo_pathCentroid.point=function(x,y){d3_geo_pathCentroid.point=nextPoint;d3_geo_pathCentroidPoint(x0=x,y0=y);};function nextPoint(x,y){var dx=x-x0,dy=y-y0,z=Math.sqrt(dx*dx+dy*dy);d3_geo_centroidX1+=z*(x0+x)/2;d3_geo_centroidY1+=z*(y0+y)/2;d3_geo_centroidZ1+=z;d3_geo_pathCentroidPoint(x0=x,y0=y);}}
function d3_geo_pathCentroidLineEnd(){d3_geo_pathCentroid.point=d3_geo_pathCentroidPoint;}
function d3_geo_pathCentroidRingStart(){var x00,y00,x0,y0;d3_geo_pathCentroid.point=function(x,y){d3_geo_pathCentroid.point=nextPoint;d3_geo_pathCentroidPoint(x00=x0=x,y00=y0=y);};function nextPoint(x,y){var dx=x-x0,dy=y-y0,z=Math.sqrt(dx*dx+dy*dy);d3_geo_centroidX1+=z*(x0+x)/2;d3_geo_centroidY1+=z*(y0+y)/2;d3_geo_centroidZ1+=z;z=y0*x-x0*y;d3_geo_centroidX2+=z*(x0+x);d3_geo_centroidY2+=z*(y0+y);d3_geo_centroidZ2+=z*3;d3_geo_pathCentroidPoint(x0=x,y0=y);}
d3_geo_pathCentroid.lineEnd=function(){nextPoint(x00,y00);};}
function d3_geo_pathContext(context){var pointRadius=4.5;var stream={point:point,lineStart:function(){stream.point=pointLineStart;},lineEnd:lineEnd,polygonStart:function(){stream.lineEnd=lineEndPolygon;},polygonEnd:function(){stream.lineEnd=lineEnd;stream.point=point;},pointRadius:function(_){pointRadius=_;return stream;},result:d3_noop};function point(x,y){context.moveTo(x+pointRadius,y);context.arc(x,y,pointRadius,0,τ);}
function pointLineStart(x,y){context.moveTo(x,y);stream.point=pointLine;}
function pointLine(x,y){context.lineTo(x,y);}
function lineEnd(){stream.point=point;}
function lineEndPolygon(){context.closePath();}
return stream;}
function d3_geo_resample(project){var δ2=.5,cosMinDistance=Math.cos(30*d3_radians),maxDepth=16;function resample(stream){return(maxDepth?resampleRecursive:resampleNone)(stream);}
function resampleNone(stream){return d3_geo_transformPoint(stream,function(x,y){x=project(x,y);stream.point(x[0],x[1]);});}
function resampleRecursive(stream){var λ00,φ00,x00,y00,a00,b00,c00,λ0,x0,y0,a0,b0,c0;var resample={point:point,lineStart:lineStart,lineEnd:lineEnd,polygonStart:function(){stream.polygonStart();resample.lineStart=ringStart;},polygonEnd:function(){stream.polygonEnd();resample.lineStart=lineStart;}};function point(x,y){x=project(x,y);stream.point(x[0],x[1]);}
function lineStart(){x0=NaN;resample.point=linePoint;stream.lineStart();}
function linePoint(λ,φ){var c=d3_geo_cartesian([λ,φ]),p=project(λ,φ);resampleLineTo(x0,y0,λ0,a0,b0,c0,x0=p[0],y0=p[1],λ0=λ,a0=c[0],b0=c[1],c0=c[2],maxDepth,stream);stream.point(x0,y0);}
function lineEnd(){resample.point=point;stream.lineEnd();}
function ringStart(){lineStart();resample.point=ringPoint;resample.lineEnd=ringEnd;}
function ringPoint(λ,φ){linePoint(λ00=λ,φ00=φ),x00=x0,y00=y0,a00=a0,b00=b0,c00=c0;resample.point=linePoint;}
function ringEnd(){resampleLineTo(x0,y0,λ0,a0,b0,c0,x00,y00,λ00,a00,b00,c00,maxDepth,stream);resample.lineEnd=lineEnd;lineEnd();}
return resample;}
function resampleLineTo(x0,y0,λ0,a0,b0,c0,x1,y1,λ1,a1,b1,c1,depth,stream){var dx=x1-x0,dy=y1-y0,d2=dx*dx+dy*dy;if(d2>4*δ2&&depth--){var a=a0+a1,b=b0+b1,c=c0+c1,m=Math.sqrt(a*a+b*b+c*c),φ2=Math.asin(c/=m),λ2=abs(abs(c)-1)<ε||abs(λ0-λ1)<ε?(λ0+λ1)/2:Math.atan2(b,a),p=project(λ2,φ2),x2=p[0],y2=p[1],dx2=x2-x0,dy2=y2-y0,dz=dy*dx2-dx*dy2;if(dz*dz/d2>δ2||abs((dx*dx2+dy*dy2)/d2-.5)>.3||a0*a1+b0*b1+c0*c1<cosMinDistance){resampleLineTo(x0,y0,λ0,a0,b0,c0,x2,y2,λ2,a/=m,b/=m,c,depth,stream);stream.point(x2,y2);resampleLineTo(x2,y2,λ2,a,b,c,x1,y1,λ1,a1,b1,c1,depth,stream);}}}
resample.precision=function(_){if(!arguments.length)return Math.sqrt(δ2);maxDepth=(δ2=_*_)>0&&16;return resample;};return resample;}
d3.geo.path=function(){var pointRadius=4.5,projection,context,projectStream,contextStream,cacheStream;function path(object){if(object){if(typeof pointRadius==="function")contextStream.pointRadius(+pointRadius.apply(this,arguments));if(!cacheStream||!cacheStream.valid)cacheStream=projectStream(contextStream);d3.geo.stream(object,cacheStream);}
return contextStream.result();}
path.area=function(object){d3_geo_pathAreaSum=0;d3.geo.stream(object,projectStream(d3_geo_pathArea));return d3_geo_pathAreaSum;};path.centroid=function(object){d3_geo_centroidX0=d3_geo_centroidY0=d3_geo_centroidZ0=d3_geo_centroidX1=d3_geo_centroidY1=d3_geo_centroidZ1=d3_geo_centroidX2=d3_geo_centroidY2=d3_geo_centroidZ2=0;d3.geo.stream(object,projectStream(d3_geo_pathCentroid));return d3_geo_centroidZ2?[d3_geo_centroidX2/d3_geo_centroidZ2,d3_geo_centroidY2/d3_geo_centroidZ2]:d3_geo_centroidZ1?[d3_geo_centroidX1/d3_geo_centroidZ1,d3_geo_centroidY1/d3_geo_centroidZ1]:d3_geo_centroidZ0?[d3_geo_centroidX0/d3_geo_centroidZ0,d3_geo_centroidY0/d3_geo_centroidZ0]:[NaN,NaN];};path.bounds=function(object){d3_geo_pathBoundsX1=d3_geo_pathBoundsY1=-(d3_geo_pathBoundsX0=d3_geo_pathBoundsY0=Infinity);d3.geo.stream(object,projectStream(d3_geo_pathBounds));return[[d3_geo_pathBoundsX0,d3_geo_pathBoundsY0],[d3_geo_pathBoundsX1,d3_geo_pathBoundsY1]];};path.projection=function(_){if(!arguments.length)return projection;projectStream=(projection=_)?_.stream||d3_geo_pathProjectStream(_):d3_identity;return reset();};path.context=function(_){if(!arguments.length)return context;contextStream=(context=_)==null?new d3_geo_pathBuffer():new d3_geo_pathContext(_);if(typeof pointRadius!=="function")contextStream.pointRadius(pointRadius);return reset();};path.pointRadius=function(_){if(!arguments.length)return pointRadius;pointRadius=typeof _==="function"?_:(contextStream.pointRadius(+_),+_);return path;};function reset(){cacheStream=null;return path;}
return path.projection(d3.geo.albersUsa()).context(null);};function d3_geo_pathProjectStream(project){var resample=d3_geo_resample(function(x,y){return project([x*d3_degrees,y*d3_degrees]);});return function(stream){return d3_geo_projectionRadians(resample(stream));};}
d3.geo.transform=function(methods){return{stream:function(stream){var transform=new d3_geo_transform(stream);for(var k in methods)transform[k]=methods[k];return transform;}};};function d3_geo_transform(stream){this.stream=stream;}
d3_geo_transform.prototype={point:function(x,y){this.stream.point(x,y);},sphere:function(){this.stream.sphere();},lineStart:function(){this.stream.lineStart();},lineEnd:function(){this.stream.lineEnd();},polygonStart:function(){this.stream.polygonStart();},polygonEnd:function(){this.stream.polygonEnd();}};function d3_geo_transformPoint(stream,point){return{point:point,sphere:function(){stream.sphere();},lineStart:function(){stream.lineStart();},lineEnd:function(){stream.lineEnd();},polygonStart:function(){stream.polygonStart();},polygonEnd:function(){stream.polygonEnd();}};}
d3.geo.projection=d3_geo_projection;d3.geo.projectionMutator=d3_geo_projectionMutator;function d3_geo_projection(project){return d3_geo_projectionMutator(function(){return project;})();}
function d3_geo_projectionMutator(projectAt){var project,rotate,projectRotate,projectResample=d3_geo_resample(function(x,y){x=project(x,y);return[x[0]*k+δx,δy-x[1]*k];}),k=150,x=480,y=250,λ=0,φ=0,δλ=0,δφ=0,δγ=0,δx,δy,preclip=d3_geo_clipAntimeridian,postclip=d3_identity,clipAngle=null,clipExtent=null,stream;function projection(point){point=projectRotate(point[0]*d3_radians,point[1]*d3_radians);return[point[0]*k+δx,δy-point[1]*k];}
function invert(point){point=projectRotate.invert((point[0]-δx)/k,(δy-point[1])/k);return point&&[point[0]*d3_degrees,point[1]*d3_degrees];}
projection.stream=function(output){if(stream)stream.valid=false;stream=d3_geo_projectionRadians(preclip(rotate,projectResample(postclip(output))));stream.valid=true;return stream;};projection.clipAngle=function(_){if(!arguments.length)return clipAngle;preclip=_==null?(clipAngle=_,d3_geo_clipAntimeridian):d3_geo_clipCircle((clipAngle=+_)*d3_radians);return invalidate();};projection.clipExtent=function(_){if(!arguments.length)return clipExtent;clipExtent=_;postclip=_?d3_geo_clipExtent(_[0][0],_[0][1],_[1][0],_[1][1]):d3_identity;return invalidate();};projection.scale=function(_){if(!arguments.length)return k;k=+_;return reset();};projection.translate=function(_){if(!arguments.length)return[x,y];x=+_[0];y=+_[1];return reset();};projection.center=function(_){if(!arguments.length)return[λ*d3_degrees,φ*d3_degrees];λ=_[0]%360*d3_radians;φ=_[1]%360*d3_radians;return reset();};projection.rotate=function(_){if(!arguments.length)return[δλ*d3_degrees,δφ*d3_degrees,δγ*d3_degrees];δλ=_[0]%360*d3_radians;δφ=_[1]%360*d3_radians;δγ=_.length>2?_[2]%360*d3_radians:0;return reset();};d3.rebind(projection,projectResample,"precision");function reset(){projectRotate=d3_geo_compose(rotate=d3_geo_rotation(δλ,δφ,δγ),project);var center=project(λ,φ);δx=x-center[0]*k;δy=y+center[1]*k;return invalidate();}
function invalidate(){if(stream)stream.valid=false,stream=null;return projection;}
return function(){project=projectAt.apply(this,arguments);projection.invert=project.invert&&invert;return reset();};}
function d3_geo_projectionRadians(stream){return d3_geo_transformPoint(stream,function(x,y){stream.point(x*d3_radians,y*d3_radians);});}
function d3_geo_equirectangular(λ,φ){return[λ,φ];}
(d3.geo.equirectangular=function(){return d3_geo_projection(d3_geo_equirectangular);}).raw=d3_geo_equirectangular.invert=d3_geo_equirectangular;d3.geo.rotation=function(rotate){rotate=d3_geo_rotation(rotate[0]%360*d3_radians,rotate[1]*d3_radians,rotate.length>2?rotate[2]*d3_radians:0);function forward(coordinates){coordinates=rotate(coordinates[0]*d3_radians,coordinates[1]*d3_radians);return coordinates[0]*=d3_degrees,coordinates[1]*=d3_degrees,coordinates;}
forward.invert=function(coordinates){coordinates=rotate.invert(coordinates[0]*d3_radians,coordinates[1]*d3_radians);return coordinates[0]*=d3_degrees,coordinates[1]*=d3_degrees,coordinates;};return forward;};function d3_geo_identityRotation(λ,φ){return[λ>π?λ-τ:λ<-π?λ+τ:λ,φ];}
d3_geo_identityRotation.invert=d3_geo_equirectangular;function d3_geo_rotation(δλ,δφ,δγ){return δλ?δφ||δγ?d3_geo_compose(d3_geo_rotationλ(δλ),d3_geo_rotationφγ(δφ,δγ)):d3_geo_rotationλ(δλ):δφ||δγ?d3_geo_rotationφγ(δφ,δγ):d3_geo_identityRotation;}
function d3_geo_forwardRotationλ(δλ){return function(λ,φ){return λ+=δλ,[λ>π?λ-τ:λ<-π?λ+τ:λ,φ];};}
function d3_geo_rotationλ(δλ){var rotation=d3_geo_forwardRotationλ(δλ);rotation.invert=d3_geo_forwardRotationλ(-δλ);return rotation;}
function d3_geo_rotationφγ(δφ,δγ){var cosδφ=Math.cos(δφ),sinδφ=Math.sin(δφ),cosδγ=Math.cos(δγ),sinδγ=Math.sin(δγ);function rotation(λ,φ){var cosφ=Math.cos(φ),x=Math.cos(λ)*cosφ,y=Math.sin(λ)*cosφ,z=Math.sin(φ),k=z*cosδφ+x*sinδφ;return[Math.atan2(y*cosδγ-k*sinδγ,x*cosδφ-z*sinδφ),d3_asin(k*cosδγ+y*sinδγ)];}
rotation.invert=function(λ,φ){var cosφ=Math.cos(φ),x=Math.cos(λ)*cosφ,y=Math.sin(λ)*cosφ,z=Math.sin(φ),k=z*cosδγ-y*sinδγ;return[Math.atan2(y*cosδγ+z*sinδγ,x*cosδφ+k*sinδφ),d3_asin(k*cosδφ-x*sinδφ)];};return rotation;}
d3.geo.circle=function(){var origin=[0,0],angle,precision=6,interpolate;function circle(){var center=typeof origin==="function"?origin.apply(this,arguments):origin,rotate=d3_geo_rotation(-center[0]*d3_radians,-center[1]*d3_radians,0).invert,ring=[];interpolate(null,null,1,{point:function(x,y){ring.push(x=rotate(x,y));x[0]*=d3_degrees,x[1]*=d3_degrees;}});return{type:"Polygon",coordinates:[ring]};}
circle.origin=function(x){if(!arguments.length)return origin;origin=x;return circle;};circle.angle=function(x){if(!arguments.length)return angle;interpolate=d3_geo_circleInterpolate((angle=+x)*d3_radians,precision*d3_radians);return circle;};circle.precision=function(_){if(!arguments.length)return precision;interpolate=d3_geo_circleInterpolate(angle*d3_radians,(precision=+_)*d3_radians);return circle;};return circle.angle(90);};function d3_geo_circleInterpolate(radius,precision){var cr=Math.cos(radius),sr=Math.sin(radius);return function(from,to,direction,listener){var step=direction*precision;if(from!=null){from=d3_geo_circleAngle(cr,from);to=d3_geo_circleAngle(cr,to);if(direction>0?from<to:from>to)from+=direction*τ;}else{from=radius+direction*τ;to=radius-.5*step;}
for(var point,t=from;direction>0?t>to:t<to;t-=step){listener.point((point=d3_geo_spherical([cr,-sr*Math.cos(t),-sr*Math.sin(t)]))[0],point[1]);}};}
function d3_geo_circleAngle(cr,point){var a=d3_geo_cartesian(point);a[0]-=cr;d3_geo_cartesianNormalize(a);var angle=d3_acos(-a[1]);return((-a[2]<0?-angle:angle)+2*Math.PI-ε)%(2*Math.PI);}
d3.geo.distance=function(a,b){var Δλ=(b[0]-a[0])*d3_radians,φ0=a[1]*d3_radians,φ1=b[1]*d3_radians,sinΔλ=Math.sin(Δλ),cosΔλ=Math.cos(Δλ),sinφ0=Math.sin(φ0),cosφ0=Math.cos(φ0),sinφ1=Math.sin(φ1),cosφ1=Math.cos(φ1),t;return Math.atan2(Math.sqrt((t=cosφ1*sinΔλ)*t+(t=cosφ0*sinφ1-sinφ0*cosφ1*cosΔλ)*t),sinφ0*sinφ1+cosφ0*cosφ1*cosΔλ);};d3.geo.graticule=function(){var x1,x0,X1,X0,y1,y0,Y1,Y0,dx=10,dy=dx,DX=90,DY=360,x,y,X,Y,precision=2.5;function graticule(){return{type:"MultiLineString",coordinates:lines()};}
function lines(){return d3.range(Math.ceil(X0/DX)*DX,X1,DX).map(X).concat(d3.range(Math.ceil(Y0/DY)*DY,Y1,DY).map(Y)).concat(d3.range(Math.ceil(x0/dx)*dx,x1,dx).filter(function(x){return abs(x%DX)>ε;}).map(x)).concat(d3.range(Math.ceil(y0/dy)*dy,y1,dy).filter(function(y){return abs(y%DY)>ε;}).map(y));}
graticule.lines=function(){return lines().map(function(coordinates){return{type:"LineString",coordinates:coordinates};});};graticule.outline=function(){return{type:"Polygon",coordinates:[X(X0).concat(Y(Y1).slice(1),X(X1).reverse().slice(1),Y(Y0).reverse().slice(1))]};};graticule.extent=function(_){if(!arguments.length)return graticule.minorExtent();return graticule.majorExtent(_).minorExtent(_);};graticule.majorExtent=function(_){if(!arguments.length)return[[X0,Y0],[X1,Y1]];X0=+_[0][0],X1=+_[1][0];Y0=+_[0][1],Y1=+_[1][1];if(X0>X1)_=X0,X0=X1,X1=_;if(Y0>Y1)_=Y0,Y0=Y1,Y1=_;return graticule.precision(precision);};graticule.minorExtent=function(_){if(!arguments.length)return[[x0,y0],[x1,y1]];x0=+_[0][0],x1=+_[1][0];y0=+_[0][1],y1=+_[1][1];if(x0>x1)_=x0,x0=x1,x1=_;if(y0>y1)_=y0,y0=y1,y1=_;return graticule.precision(precision);};graticule.step=function(_){if(!arguments.length)return graticule.minorStep();return graticule.majorStep(_).minorStep(_);};graticule.majorStep=function(_){if(!arguments.length)return[DX,DY];DX=+_[0],DY=+_[1];return graticule;};graticule.minorStep=function(_){if(!arguments.length)return[dx,dy];dx=+_[0],dy=+_[1];return graticule;};graticule.precision=function(_){if(!arguments.length)return precision;precision=+_;x=d3_geo_graticuleX(y0,y1,90);y=d3_geo_graticuleY(x0,x1,precision);X=d3_geo_graticuleX(Y0,Y1,90);Y=d3_geo_graticuleY(X0,X1,precision);return graticule;};return graticule.majorExtent([[-180,-90+ε],[180,90-ε]]).minorExtent([[-180,-80-ε],[180,80+ε]]);};function d3_geo_graticuleX(y0,y1,dy){var y=d3.range(y0,y1-ε,dy).concat(y1);return function(x){return y.map(function(y){return[x,y];});};}
function d3_geo_graticuleY(x0,x1,dx){var x=d3.range(x0,x1-ε,dx).concat(x1);return function(y){return x.map(function(x){return[x,y];});};}
function d3_source(d){return d.source;}
function d3_target(d){return d.target;}
d3.geo.greatArc=function(){var source=d3_source,source_,target=d3_target,target_;function greatArc(){return{type:"LineString",coordinates:[source_||source.apply(this,arguments),target_||target.apply(this,arguments)]};}
greatArc.distance=function(){return d3.geo.distance(source_||source.apply(this,arguments),target_||target.apply(this,arguments));};greatArc.source=function(_){if(!arguments.length)return source;source=_,source_=typeof _==="function"?null:_;return greatArc;};greatArc.target=function(_){if(!arguments.length)return target;target=_,target_=typeof _==="function"?null:_;return greatArc;};greatArc.precision=function(){return arguments.length?greatArc:0;};return greatArc;};d3.geo.interpolate=function(source,target){return d3_geo_interpolate(source[0]*d3_radians,source[1]*d3_radians,target[0]*d3_radians,target[1]*d3_radians);};function d3_geo_interpolate(x0,y0,x1,y1){var cy0=Math.cos(y0),sy0=Math.sin(y0),cy1=Math.cos(y1),sy1=Math.sin(y1),kx0=cy0*Math.cos(x0),ky0=cy0*Math.sin(x0),kx1=cy1*Math.cos(x1),ky1=cy1*Math.sin(x1),d=2*Math.asin(Math.sqrt(d3_haversin(y1-y0)+cy0*cy1*d3_haversin(x1-x0))),k=1/Math.sin(d);var interpolate=d?function(t){var B=Math.sin(t*=d)*k,A=Math.sin(d-t)*k,x=A*kx0+B*kx1,y=A*ky0+B*ky1,z=A*sy0+B*sy1;return[Math.atan2(y,x)*d3_degrees,Math.atan2(z,Math.sqrt(x*x+y*y))*d3_degrees];}:function(){return[x0*d3_degrees,y0*d3_degrees];};interpolate.distance=d;return interpolate;}
d3.geo.length=function(object){d3_geo_lengthSum=0;d3.geo.stream(object,d3_geo_length);return d3_geo_lengthSum;};var d3_geo_lengthSum;var d3_geo_length={sphere:d3_noop,point:d3_noop,lineStart:d3_geo_lengthLineStart,lineEnd:d3_noop,polygonStart:d3_noop,polygonEnd:d3_noop};function d3_geo_lengthLineStart(){var λ0,sinφ0,cosφ0;d3_geo_length.point=function(λ,φ){λ0=λ*d3_radians,sinφ0=Math.sin(φ*=d3_radians),cosφ0=Math.cos(φ);d3_geo_length.point=nextPoint;};d3_geo_length.lineEnd=function(){d3_geo_length.point=d3_geo_length.lineEnd=d3_noop;};function nextPoint(λ,φ){var sinφ=Math.sin(φ*=d3_radians),cosφ=Math.cos(φ),t=abs((λ*=d3_radians)-λ0),cosΔλ=Math.cos(t);d3_geo_lengthSum+=Math.atan2(Math.sqrt((t=cosφ*Math.sin(t))*t+(t=cosφ0*sinφ-sinφ0*cosφ*cosΔλ)*t),sinφ0*sinφ+cosφ0*cosφ*cosΔλ);λ0=λ,sinφ0=sinφ,cosφ0=cosφ;}}
function d3_geo_azimuthal(scale,angle){function azimuthal(λ,φ){var cosλ=Math.cos(λ),cosφ=Math.cos(φ),k=scale(cosλ*cosφ);return[k*cosφ*Math.sin(λ),k*Math.sin(φ)];}
azimuthal.invert=function(x,y){var ρ=Math.sqrt(x*x+y*y),c=angle(ρ),sinc=Math.sin(c),cosc=Math.cos(c);return[Math.atan2(x*sinc,ρ*cosc),Math.asin(ρ&&y*sinc/ρ)];};return azimuthal;}
var d3_geo_azimuthalEqualArea=d3_geo_azimuthal(function(cosλcosφ){return Math.sqrt(2/(1+cosλcosφ));},function(ρ){return 2*Math.asin(ρ/2);});(d3.geo.azimuthalEqualArea=function(){return d3_geo_projection(d3_geo_azimuthalEqualArea);}).raw=d3_geo_azimuthalEqualArea;var d3_geo_azimuthalEquidistant=d3_geo_azimuthal(function(cosλcosφ){var c=Math.acos(cosλcosφ);return c&&c/Math.sin(c);},d3_identity);(d3.geo.azimuthalEquidistant=function(){return d3_geo_projection(d3_geo_azimuthalEquidistant);}).raw=d3_geo_azimuthalEquidistant;function d3_geo_conicConformal(φ0,φ1){var cosφ0=Math.cos(φ0),t=function(φ){return Math.tan(π/4+φ/2);},n=φ0===φ1?Math.sin(φ0):Math.log(cosφ0/Math.cos(φ1))/Math.log(t(φ1)/t(φ0)),F=cosφ0*Math.pow(t(φ0),n)/n;if(!n)return d3_geo_mercator;function forward(λ,φ){if(F>0){if(φ<-halfπ+ε)φ=-halfπ+ε;}else{if(φ>halfπ-ε)φ=halfπ-ε;}
var ρ=F/Math.pow(t(φ),n);return[ρ*Math.sin(n*λ),F-ρ*Math.cos(n*λ)];}
forward.invert=function(x,y){var ρ0_y=F-y,ρ=d3_sgn(n)*Math.sqrt(x*x+ρ0_y*ρ0_y);return[Math.atan2(x,ρ0_y)/n,2*Math.atan(Math.pow(F/ρ,1/n))-halfπ];};return forward;}
(d3.geo.conicConformal=function(){return d3_geo_conic(d3_geo_conicConformal);}).raw=d3_geo_conicConformal;function d3_geo_conicEquidistant(φ0,φ1){var cosφ0=Math.cos(φ0),n=φ0===φ1?Math.sin(φ0):(cosφ0-Math.cos(φ1))/(φ1-φ0),G=cosφ0/n+φ0;if(abs(n)<ε)return d3_geo_equirectangular;function forward(λ,φ){var ρ=G-φ;return[ρ*Math.sin(n*λ),G-ρ*Math.cos(n*λ)];}
forward.invert=function(x,y){var ρ0_y=G-y;return[Math.atan2(x,ρ0_y)/n,G-d3_sgn(n)*Math.sqrt(x*x+ρ0_y*ρ0_y)];};return forward;}
(d3.geo.conicEquidistant=function(){return d3_geo_conic(d3_geo_conicEquidistant);}).raw=d3_geo_conicEquidistant;var d3_geo_gnomonic=d3_geo_azimuthal(function(cosλcosφ){return 1/cosλcosφ;},Math.atan);(d3.geo.gnomonic=function(){return d3_geo_projection(d3_geo_gnomonic);}).raw=d3_geo_gnomonic;function d3_geo_mercator(λ,φ){return[λ,Math.log(Math.tan(π/4+φ/2))];}
d3_geo_mercator.invert=function(x,y){return[x,2*Math.atan(Math.exp(y))-halfπ];};function d3_geo_mercatorProjection(project){var m=d3_geo_projection(project),scale=m.scale,translate=m.translate,clipExtent=m.clipExtent,clipAuto;m.scale=function(){var v=scale.apply(m,arguments);return v===m?clipAuto?m.clipExtent(null):m:v;};m.translate=function(){var v=translate.apply(m,arguments);return v===m?clipAuto?m.clipExtent(null):m:v;};m.clipExtent=function(_){var v=clipExtent.apply(m,arguments);if(v===m){if(clipAuto=_==null){var k=π*scale(),t=translate();clipExtent([[t[0]-k,t[1]-k],[t[0]+k,t[1]+k]]);}}else if(clipAuto){v=null;}
return v;};return m.clipExtent(null);}
(d3.geo.mercator=function(){return d3_geo_mercatorProjection(d3_geo_mercator);}).raw=d3_geo_mercator;var d3_geo_orthographic=d3_geo_azimuthal(function(){return 1;},Math.asin);(d3.geo.orthographic=function(){return d3_geo_projection(d3_geo_orthographic);}).raw=d3_geo_orthographic;var d3_geo_stereographic=d3_geo_azimuthal(function(cosλcosφ){return 1/(1+cosλcosφ);},function(ρ){return 2*Math.atan(ρ);});(d3.geo.stereographic=function(){return d3_geo_projection(d3_geo_stereographic);}).raw=d3_geo_stereographic;function d3_geo_transverseMercator(λ,φ){return[Math.log(Math.tan(π/4+φ/2)),-λ];}
d3_geo_transverseMercator.invert=function(x,y){return[-y,2*Math.atan(Math.exp(x))-halfπ];};(d3.geo.transverseMercator=function(){var projection=d3_geo_mercatorProjection(d3_geo_transverseMercator),center=projection.center,rotate=projection.rotate;projection.center=function(_){return _?center([-_[1],_[0]]):(_=center(),[_[1],-_[0]]);};projection.rotate=function(_){return _?rotate([_[0],_[1],_.length>2?_[2]+90:90]):(_=rotate(),[_[0],_[1],_[2]-90]);};return rotate([0,0,90]);}).raw=d3_geo_transverseMercator;d3.geom={};function d3_geom_pointX(d){return d[0];}
function d3_geom_pointY(d){return d[1];}
d3.geom.hull=function(vertices){var x=d3_geom_pointX,y=d3_geom_pointY;if(arguments.length)return hull(vertices);function hull(data){if(data.length<3)return[];var fx=d3_functor(x),fy=d3_functor(y),i,n=data.length,points=[],flippedPoints=[];for(i=0;i<n;i++){points.push([+fx.call(this,data[i],i),+fy.call(this,data[i],i),i]);}
points.sort(d3_geom_hullOrder);for(i=0;i<n;i++)flippedPoints.push([points[i][0],-points[i][1]]);var upper=d3_geom_hullUpper(points),lower=d3_geom_hullUpper(flippedPoints);var skipLeft=lower[0]===upper[0],skipRight=lower[lower.length-1]===upper[upper.length-1],polygon=[];for(i=upper.length-1;i>=0;--i)polygon.push(data[points[upper[i]][2]]);for(i=+skipLeft;i<lower.length-skipRight;++i)polygon.push(data[points[lower[i]][2]]);return polygon;}
hull.x=function(_){return arguments.length?(x=_,hull):x;};hull.y=function(_){return arguments.length?(y=_,hull):y;};return hull;};function d3_geom_hullUpper(points){var n=points.length,hull=[0,1],hs=2;for(var i=2;i<n;i++){while(hs>1&&d3_cross2d(points[hull[hs-2]],points[hull[hs-1]],points[i])<=0)--hs;hull[hs++]=i;}
return hull.slice(0,hs);}
function d3_geom_hullOrder(a,b){return a[0]-b[0]||a[1]-b[1];}
d3.geom.polygon=function(coordinates){d3_subclass(coordinates,d3_geom_polygonPrototype);return coordinates;};var d3_geom_polygonPrototype=d3.geom.polygon.prototype=[];d3_geom_polygonPrototype.area=function(){var i=-1,n=this.length,a,b=this[n-1],area=0;while(++i<n){a=b;b=this[i];area+=a[1]*b[0]-a[0]*b[1];}
return area*.5;};d3_geom_polygonPrototype.centroid=function(k){var i=-1,n=this.length,x=0,y=0,a,b=this[n-1],c;if(!arguments.length)k=-1/(6*this.area());while(++i<n){a=b;b=this[i];c=a[0]*b[1]-b[0]*a[1];x+=(a[0]+b[0])*c;y+=(a[1]+b[1])*c;}
return[x*k,y*k];};d3_geom_polygonPrototype.clip=function(subject){var input,closed=d3_geom_polygonClosed(subject),i=-1,n=this.length-d3_geom_polygonClosed(this),j,m,a=this[n-1],b,c,d;while(++i<n){input=subject.slice();subject.length=0;b=this[i];c=input[(m=input.length-closed)-1];j=-1;while(++j<m){d=input[j];if(d3_geom_polygonInside(d,a,b)){if(!d3_geom_polygonInside(c,a,b)){subject.push(d3_geom_polygonIntersect(c,d,a,b));}
subject.push(d);}else if(d3_geom_polygonInside(c,a,b)){subject.push(d3_geom_polygonIntersect(c,d,a,b));}
c=d;}
if(closed)subject.push(subject[0]);a=b;}
return subject;};function d3_geom_polygonInside(p,a,b){return(b[0]-a[0])*(p[1]-a[1])<(b[1]-a[1])*(p[0]-a[0]);}
function d3_geom_polygonIntersect(c,d,a,b){var x1=c[0],x3=a[0],x21=d[0]-x1,x43=b[0]-x3,y1=c[1],y3=a[1],y21=d[1]-y1,y43=b[1]-y3,ua=(x43*(y1-y3)-y43*(x1-x3))/(y43*x21-x43*y21);return[x1+ua*x21,y1+ua*y21];}
function d3_geom_polygonClosed(coordinates){var a=coordinates[0],b=coordinates[coordinates.length-1];return!(a[0]-b[0]||a[1]-b[1]);}
var d3_geom_voronoiEdges,d3_geom_voronoiCells,d3_geom_voronoiBeaches,d3_geom_voronoiBeachPool=[],d3_geom_voronoiFirstCircle,d3_geom_voronoiCircles,d3_geom_voronoiCirclePool=[];function d3_geom_voronoiBeach(){d3_geom_voronoiRedBlackNode(this);this.edge=this.site=this.circle=null;}
function d3_geom_voronoiCreateBeach(site){var beach=d3_geom_voronoiBeachPool.pop()||new d3_geom_voronoiBeach();beach.site=site;return beach;}
function d3_geom_voronoiDetachBeach(beach){d3_geom_voronoiDetachCircle(beach);d3_geom_voronoiBeaches.remove(beach);d3_geom_voronoiBeachPool.push(beach);d3_geom_voronoiRedBlackNode(beach);}
function d3_geom_voronoiRemoveBeach(beach){var circle=beach.circle,x=circle.x,y=circle.cy,vertex={x:x,y:y},previous=beach.P,next=beach.N,disappearing=[beach];d3_geom_voronoiDetachBeach(beach);var lArc=previous;while(lArc.circle&&abs(x-lArc.circle.x)<ε&&abs(y-lArc.circle.cy)<ε){previous=lArc.P;disappearing.unshift(lArc);d3_geom_voronoiDetachBeach(lArc);lArc=previous;}
disappearing.unshift(lArc);d3_geom_voronoiDetachCircle(lArc);var rArc=next;while(rArc.circle&&abs(x-rArc.circle.x)<ε&&abs(y-rArc.circle.cy)<ε){next=rArc.N;disappearing.push(rArc);d3_geom_voronoiDetachBeach(rArc);rArc=next;}
disappearing.push(rArc);d3_geom_voronoiDetachCircle(rArc);var nArcs=disappearing.length,iArc;for(iArc=1;iArc<nArcs;++iArc){rArc=disappearing[iArc];lArc=disappearing[iArc-1];d3_geom_voronoiSetEdgeEnd(rArc.edge,lArc.site,rArc.site,vertex);}
lArc=disappearing[0];rArc=disappearing[nArcs-1];rArc.edge=d3_geom_voronoiCreateEdge(lArc.site,rArc.site,null,vertex);d3_geom_voronoiAttachCircle(lArc);d3_geom_voronoiAttachCircle(rArc);}
function d3_geom_voronoiAddBeach(site){var x=site.x,directrix=site.y,lArc,rArc,dxl,dxr,node=d3_geom_voronoiBeaches._;while(node){dxl=d3_geom_voronoiLeftBreakPoint(node,directrix)-x;if(dxl>ε)node=node.L;else{dxr=x-d3_geom_voronoiRightBreakPoint(node,directrix);if(dxr>ε){if(!node.R){lArc=node;break;}
node=node.R;}else{if(dxl>-ε){lArc=node.P;rArc=node;}else if(dxr>-ε){lArc=node;rArc=node.N;}else{lArc=rArc=node;}
break;}}}
var newArc=d3_geom_voronoiCreateBeach(site);d3_geom_voronoiBeaches.insert(lArc,newArc);if(!lArc&&!rArc)return;if(lArc===rArc){d3_geom_voronoiDetachCircle(lArc);rArc=d3_geom_voronoiCreateBeach(lArc.site);d3_geom_voronoiBeaches.insert(newArc,rArc);newArc.edge=rArc.edge=d3_geom_voronoiCreateEdge(lArc.site,newArc.site);d3_geom_voronoiAttachCircle(lArc);d3_geom_voronoiAttachCircle(rArc);return;}
if(!rArc){newArc.edge=d3_geom_voronoiCreateEdge(lArc.site,newArc.site);return;}
d3_geom_voronoiDetachCircle(lArc);d3_geom_voronoiDetachCircle(rArc);var lSite=lArc.site,ax=lSite.x,ay=lSite.y,bx=site.x-ax,by=site.y-ay,rSite=rArc.site,cx=rSite.x-ax,cy=rSite.y-ay,d=2*(bx*cy-by*cx),hb=bx*bx+by*by,hc=cx*cx+cy*cy,vertex={x:(cy*hb-by*hc)/d+ax,y:(bx*hc-cx*hb)/d+ay};d3_geom_voronoiSetEdgeEnd(rArc.edge,lSite,rSite,vertex);newArc.edge=d3_geom_voronoiCreateEdge(lSite,site,null,vertex);rArc.edge=d3_geom_voronoiCreateEdge(site,rSite,null,vertex);d3_geom_voronoiAttachCircle(lArc);d3_geom_voronoiAttachCircle(rArc);}
function d3_geom_voronoiLeftBreakPoint(arc,directrix){var site=arc.site,rfocx=site.x,rfocy=site.y,pby2=rfocy-directrix;if(!pby2)return rfocx;var lArc=arc.P;if(!lArc)return-Infinity;site=lArc.site;var lfocx=site.x,lfocy=site.y,plby2=lfocy-directrix;if(!plby2)return lfocx;var hl=lfocx-rfocx,aby2=1/pby2-1/plby2,b=hl/plby2;if(aby2)return(-b+Math.sqrt(b*b-2*aby2*(hl*hl/(-2*plby2)-lfocy+plby2/2+rfocy-pby2/2)))/aby2+rfocx;return(rfocx+lfocx)/2;}
function d3_geom_voronoiRightBreakPoint(arc,directrix){var rArc=arc.N;if(rArc)return d3_geom_voronoiLeftBreakPoint(rArc,directrix);var site=arc.site;return site.y===directrix?site.x:Infinity;}
function d3_geom_voronoiCell(site){this.site=site;this.edges=[];}
d3_geom_voronoiCell.prototype.prepare=function(){var halfEdges=this.edges,iHalfEdge=halfEdges.length,edge;while(iHalfEdge--){edge=halfEdges[iHalfEdge].edge;if(!edge.b||!edge.a)halfEdges.splice(iHalfEdge,1);}
halfEdges.sort(d3_geom_voronoiHalfEdgeOrder);return halfEdges.length;};function d3_geom_voronoiCloseCells(extent){var x0=extent[0][0],x1=extent[1][0],y0=extent[0][1],y1=extent[1][1],x2,y2,x3,y3,cells=d3_geom_voronoiCells,iCell=cells.length,cell,iHalfEdge,halfEdges,nHalfEdges,start,end;while(iCell--){cell=cells[iCell];if(!cell||!cell.prepare())continue;halfEdges=cell.edges;nHalfEdges=halfEdges.length;iHalfEdge=0;while(iHalfEdge<nHalfEdges){end=halfEdges[iHalfEdge].end(),x3=end.x,y3=end.y;start=halfEdges[++iHalfEdge%nHalfEdges].start(),x2=start.x,y2=start.y;if(abs(x3-x2)>ε||abs(y3-y2)>ε){halfEdges.splice(iHalfEdge,0,new d3_geom_voronoiHalfEdge(d3_geom_voronoiCreateBorderEdge(cell.site,end,abs(x3-x0)<ε&&y1-y3>ε?{x:x0,y:abs(x2-x0)<ε?y2:y1}:abs(y3-y1)<ε&&x1-x3>ε?{x:abs(y2-y1)<ε?x2:x1,y:y1}:abs(x3-x1)<ε&&y3-y0>ε?{x:x1,y:abs(x2-x1)<ε?y2:y0}:abs(y3-y0)<ε&&x3-x0>ε?{x:abs(y2-y0)<ε?x2:x0,y:y0}:null),cell.site,null));++nHalfEdges;}}}}
function d3_geom_voronoiHalfEdgeOrder(a,b){return b.angle-a.angle;}
function d3_geom_voronoiCircle(){d3_geom_voronoiRedBlackNode(this);this.x=this.y=this.arc=this.site=this.cy=null;}
function d3_geom_voronoiAttachCircle(arc){var lArc=arc.P,rArc=arc.N;if(!lArc||!rArc)return;var lSite=lArc.site,cSite=arc.site,rSite=rArc.site;if(lSite===rSite)return;var bx=cSite.x,by=cSite.y,ax=lSite.x-bx,ay=lSite.y-by,cx=rSite.x-bx,cy=rSite.y-by;var d=2*(ax*cy-ay*cx);if(d>=-ε2)return;var ha=ax*ax+ay*ay,hc=cx*cx+cy*cy,x=(cy*ha-ay*hc)/d,y=(ax*hc-cx*ha)/d,cy=y+by;var circle=d3_geom_voronoiCirclePool.pop()||new d3_geom_voronoiCircle();circle.arc=arc;circle.site=cSite;circle.x=x+bx;circle.y=cy+Math.sqrt(x*x+y*y);circle.cy=cy;arc.circle=circle;var before=null,node=d3_geom_voronoiCircles._;while(node){if(circle.y<node.y||circle.y===node.y&&circle.x<=node.x){if(node.L)node=node.L;else{before=node.P;break;}}else{if(node.R)node=node.R;else{before=node;break;}}}
d3_geom_voronoiCircles.insert(before,circle);if(!before)d3_geom_voronoiFirstCircle=circle;}
function d3_geom_voronoiDetachCircle(arc){var circle=arc.circle;if(circle){if(!circle.P)d3_geom_voronoiFirstCircle=circle.N;d3_geom_voronoiCircles.remove(circle);d3_geom_voronoiCirclePool.push(circle);d3_geom_voronoiRedBlackNode(circle);arc.circle=null;}}
function d3_geom_voronoiClipEdges(extent){var edges=d3_geom_voronoiEdges,clip=d3_geom_clipLine(extent[0][0],extent[0][1],extent[1][0],extent[1][1]),i=edges.length,e;while(i--){e=edges[i];if(!d3_geom_voronoiConnectEdge(e,extent)||!clip(e)||abs(e.a.x-e.b.x)<ε&&abs(e.a.y-e.b.y)<ε){e.a=e.b=null;edges.splice(i,1);}}}
function d3_geom_voronoiConnectEdge(edge,extent){var vb=edge.b;if(vb)return true;var va=edge.a,x0=extent[0][0],x1=extent[1][0],y0=extent[0][1],y1=extent[1][1],lSite=edge.l,rSite=edge.r,lx=lSite.x,ly=lSite.y,rx=rSite.x,ry=rSite.y,fx=(lx+rx)/2,fy=(ly+ry)/2,fm,fb;if(ry===ly){if(fx<x0||fx>=x1)return;if(lx>rx){if(!va)va={x:fx,y:y0};else if(va.y>=y1)return;vb={x:fx,y:y1};}else{if(!va)va={x:fx,y:y1};else if(va.y<y0)return;vb={x:fx,y:y0};}}else{fm=(lx-rx)/(ry-ly);fb=fy-fm*fx;if(fm<-1||fm>1){if(lx>rx){if(!va)va={x:(y0-fb)/fm,y:y0};else if(va.y>=y1)return;vb={x:(y1-fb)/fm,y:y1};}else{if(!va)va={x:(y1-fb)/fm,y:y1};else if(va.y<y0)return;vb={x:(y0-fb)/fm,y:y0};}}else{if(ly<ry){if(!va)va={x:x0,y:fm*x0+fb};else if(va.x>=x1)return;vb={x:x1,y:fm*x1+fb};}else{if(!va)va={x:x1,y:fm*x1+fb};else if(va.x<x0)return;vb={x:x0,y:fm*x0+fb};}}}
edge.a=va;edge.b=vb;return true;}
function d3_geom_voronoiEdge(lSite,rSite){this.l=lSite;this.r=rSite;this.a=this.b=null;}
function d3_geom_voronoiCreateEdge(lSite,rSite,va,vb){var edge=new d3_geom_voronoiEdge(lSite,rSite);d3_geom_voronoiEdges.push(edge);if(va)d3_geom_voronoiSetEdgeEnd(edge,lSite,rSite,va);if(vb)d3_geom_voronoiSetEdgeEnd(edge,rSite,lSite,vb);d3_geom_voronoiCells[lSite.i].edges.push(new d3_geom_voronoiHalfEdge(edge,lSite,rSite));d3_geom_voronoiCells[rSite.i].edges.push(new d3_geom_voronoiHalfEdge(edge,rSite,lSite));return edge;}
function d3_geom_voronoiCreateBorderEdge(lSite,va,vb){var edge=new d3_geom_voronoiEdge(lSite,null);edge.a=va;edge.b=vb;d3_geom_voronoiEdges.push(edge);return edge;}
function d3_geom_voronoiSetEdgeEnd(edge,lSite,rSite,vertex){if(!edge.a&&!edge.b){edge.a=vertex;edge.l=lSite;edge.r=rSite;}else if(edge.l===rSite){edge.b=vertex;}else{edge.a=vertex;}}
function d3_geom_voronoiHalfEdge(edge,lSite,rSite){var va=edge.a,vb=edge.b;this.edge=edge;this.site=lSite;this.angle=rSite?Math.atan2(rSite.y-lSite.y,rSite.x-lSite.x):edge.l===lSite?Math.atan2(vb.x-va.x,va.y-vb.y):Math.atan2(va.x-vb.x,vb.y-va.y);}
d3_geom_voronoiHalfEdge.prototype={start:function(){return this.edge.l===this.site?this.edge.a:this.edge.b;},end:function(){return this.edge.l===this.site?this.edge.b:this.edge.a;}};function d3_geom_voronoiRedBlackTree(){this._=null;}
function d3_geom_voronoiRedBlackNode(node){node.U=node.C=node.L=node.R=node.P=node.N=null;}
d3_geom_voronoiRedBlackTree.prototype={insert:function(after,node){var parent,grandpa,uncle;if(after){node.P=after;node.N=after.N;if(after.N)after.N.P=node;after.N=node;if(after.R){after=after.R;while(after.L)after=after.L;after.L=node;}else{after.R=node;}
parent=after;}else if(this._){after=d3_geom_voronoiRedBlackFirst(this._);node.P=null;node.N=after;after.P=after.L=node;parent=after;}else{node.P=node.N=null;this._=node;parent=null;}
node.L=node.R=null;node.U=parent;node.C=true;after=node;while(parent&&parent.C){grandpa=parent.U;if(parent===grandpa.L){uncle=grandpa.R;if(uncle&&uncle.C){parent.C=uncle.C=false;grandpa.C=true;after=grandpa;}else{if(after===parent.R){d3_geom_voronoiRedBlackRotateLeft(this,parent);after=parent;parent=after.U;}
parent.C=false;grandpa.C=true;d3_geom_voronoiRedBlackRotateRight(this,grandpa);}}else{uncle=grandpa.L;if(uncle&&uncle.C){parent.C=uncle.C=false;grandpa.C=true;after=grandpa;}else{if(after===parent.L){d3_geom_voronoiRedBlackRotateRight(this,parent);after=parent;parent=after.U;}
parent.C=false;grandpa.C=true;d3_geom_voronoiRedBlackRotateLeft(this,grandpa);}}
parent=after.U;}
this._.C=false;},remove:function(node){if(node.N)node.N.P=node.P;if(node.P)node.P.N=node.N;node.N=node.P=null;var parent=node.U,sibling,left=node.L,right=node.R,next,red;if(!left)next=right;else if(!right)next=left;else next=d3_geom_voronoiRedBlackFirst(right);if(parent){if(parent.L===node)parent.L=next;else parent.R=next;}else{this._=next;}
if(left&&right){red=next.C;next.C=node.C;next.L=left;left.U=next;if(next!==right){parent=next.U;next.U=node.U;node=next.R;parent.L=node;next.R=right;right.U=next;}else{next.U=parent;parent=next;node=next.R;}}else{red=node.C;node=next;}
if(node)node.U=parent;if(red)return;if(node&&node.C){node.C=false;return;}
do{if(node===this._)break;if(node===parent.L){sibling=parent.R;if(sibling.C){sibling.C=false;parent.C=true;d3_geom_voronoiRedBlackRotateLeft(this,parent);sibling=parent.R;}
if(sibling.L&&sibling.L.C||sibling.R&&sibling.R.C){if(!sibling.R||!sibling.R.C){sibling.L.C=false;sibling.C=true;d3_geom_voronoiRedBlackRotateRight(this,sibling);sibling=parent.R;}
sibling.C=parent.C;parent.C=sibling.R.C=false;d3_geom_voronoiRedBlackRotateLeft(this,parent);node=this._;break;}}else{sibling=parent.L;if(sibling.C){sibling.C=false;parent.C=true;d3_geom_voronoiRedBlackRotateRight(this,parent);sibling=parent.L;}
if(sibling.L&&sibling.L.C||sibling.R&&sibling.R.C){if(!sibling.L||!sibling.L.C){sibling.R.C=false;sibling.C=true;d3_geom_voronoiRedBlackRotateLeft(this,sibling);sibling=parent.L;}
sibling.C=parent.C;parent.C=sibling.L.C=false;d3_geom_voronoiRedBlackRotateRight(this,parent);node=this._;break;}}
sibling.C=true;node=parent;parent=parent.U;}while(!node.C);if(node)node.C=false;}};function d3_geom_voronoiRedBlackRotateLeft(tree,node){var p=node,q=node.R,parent=p.U;if(parent){if(parent.L===p)parent.L=q;else parent.R=q;}else{tree._=q;}
q.U=parent;p.U=q;p.R=q.L;if(p.R)p.R.U=p;q.L=p;}
function d3_geom_voronoiRedBlackRotateRight(tree,node){var p=node,q=node.L,parent=p.U;if(parent){if(parent.L===p)parent.L=q;else parent.R=q;}else{tree._=q;}
q.U=parent;p.U=q;p.L=q.R;if(p.L)p.L.U=p;q.R=p;}
function d3_geom_voronoiRedBlackFirst(node){while(node.L)node=node.L;return node;}
function d3_geom_voronoi(sites,bbox){var site=sites.sort(d3_geom_voronoiVertexOrder).pop(),x0,y0,circle;d3_geom_voronoiEdges=[];d3_geom_voronoiCells=new Array(sites.length);d3_geom_voronoiBeaches=new d3_geom_voronoiRedBlackTree();d3_geom_voronoiCircles=new d3_geom_voronoiRedBlackTree();while(true){circle=d3_geom_voronoiFirstCircle;if(site&&(!circle||site.y<circle.y||site.y===circle.y&&site.x<circle.x)){if(site.x!==x0||site.y!==y0){d3_geom_voronoiCells[site.i]=new d3_geom_voronoiCell(site);d3_geom_voronoiAddBeach(site);x0=site.x,y0=site.y;}
site=sites.pop();}else if(circle){d3_geom_voronoiRemoveBeach(circle.arc);}else{break;}}
if(bbox)d3_geom_voronoiClipEdges(bbox),d3_geom_voronoiCloseCells(bbox);var diagram={cells:d3_geom_voronoiCells,edges:d3_geom_voronoiEdges};d3_geom_voronoiBeaches=d3_geom_voronoiCircles=d3_geom_voronoiEdges=d3_geom_voronoiCells=null;return diagram;}
function d3_geom_voronoiVertexOrder(a,b){return b.y-a.y||b.x-a.x;}
d3.geom.voronoi=function(points){var x=d3_geom_pointX,y=d3_geom_pointY,fx=x,fy=y,clipExtent=d3_geom_voronoiClipExtent;if(points)return voronoi(points);function voronoi(data){var polygons=new Array(data.length),x0=clipExtent[0][0],y0=clipExtent[0][1],x1=clipExtent[1][0],y1=clipExtent[1][1];d3_geom_voronoi(sites(data),clipExtent).cells.forEach(function(cell,i){var edges=cell.edges,site=cell.site,polygon=polygons[i]=edges.length?edges.map(function(e){var s=e.start();return[s.x,s.y];}):site.x>=x0&&site.x<=x1&&site.y>=y0&&site.y<=y1?[[x0,y1],[x1,y1],[x1,y0],[x0,y0]]:[];polygon.point=data[i];});return polygons;}
function sites(data){return data.map(function(d,i){return{x:Math.round(fx(d,i)/ε)*ε,y:Math.round(fy(d,i)/ε)*ε,i:i};});}
voronoi.links=function(data){return d3_geom_voronoi(sites(data)).edges.filter(function(edge){return edge.l&&edge.r;}).map(function(edge){return{source:data[edge.l.i],target:data[edge.r.i]};});};voronoi.triangles=function(data){var triangles=[];d3_geom_voronoi(sites(data)).cells.forEach(function(cell,i){var site=cell.site,edges=cell.edges.sort(d3_geom_voronoiHalfEdgeOrder),j=-1,m=edges.length,e0,s0,e1=edges[m-1].edge,s1=e1.l===site?e1.r:e1.l;while(++j<m){e0=e1;s0=s1;e1=edges[j].edge;s1=e1.l===site?e1.r:e1.l;if(i<s0.i&&i<s1.i&&d3_geom_voronoiTriangleArea(site,s0,s1)<0){triangles.push([data[i],data[s0.i],data[s1.i]]);}}});return triangles;};voronoi.x=function(_){return arguments.length?(fx=d3_functor(x=_),voronoi):x;};voronoi.y=function(_){return arguments.length?(fy=d3_functor(y=_),voronoi):y;};voronoi.clipExtent=function(_){if(!arguments.length)return clipExtent===d3_geom_voronoiClipExtent?null:clipExtent;clipExtent=_==null?d3_geom_voronoiClipExtent:_;return voronoi;};voronoi.size=function(_){if(!arguments.length)return clipExtent===d3_geom_voronoiClipExtent?null:clipExtent&&clipExtent[1];return voronoi.clipExtent(_&&[[0,0],_]);};return voronoi;};var d3_geom_voronoiClipExtent=[[-1e6,-1e6],[1e6,1e6]];function d3_geom_voronoiTriangleArea(a,b,c){return(a.x-c.x)*(b.y-a.y)-(a.x-b.x)*(c.y-a.y);}
d3.geom.delaunay=function(vertices){return d3.geom.voronoi().triangles(vertices);};d3.geom.quadtree=function(points,x1,y1,x2,y2){var x=d3_geom_pointX,y=d3_geom_pointY,compat;if(compat=arguments.length){x=d3_geom_quadtreeCompatX;y=d3_geom_quadtreeCompatY;if(compat===3){y2=y1;x2=x1;y1=x1=0;}
return quadtree(points);}
function quadtree(data){var d,fx=d3_functor(x),fy=d3_functor(y),xs,ys,i,n,x1_,y1_,x2_,y2_;if(x1!=null){x1_=x1,y1_=y1,x2_=x2,y2_=y2;}else{x2_=y2_=-(x1_=y1_=Infinity);xs=[],ys=[];n=data.length;if(compat)for(i=0;i<n;++i){d=data[i];if(d.x<x1_)x1_=d.x;if(d.y<y1_)y1_=d.y;if(d.x>x2_)x2_=d.x;if(d.y>y2_)y2_=d.y;xs.push(d.x);ys.push(d.y);}else for(i=0;i<n;++i){var x_=+fx(d=data[i],i),y_=+fy(d,i);if(x_<x1_)x1_=x_;if(y_<y1_)y1_=y_;if(x_>x2_)x2_=x_;if(y_>y2_)y2_=y_;xs.push(x_);ys.push(y_);}}
var dx=x2_-x1_,dy=y2_-y1_;if(dx>dy)y2_=y1_+dx;else x2_=x1_+dy;function insert(n,d,x,y,x1,y1,x2,y2){if(isNaN(x)||isNaN(y))return;if(n.leaf){var nx=n.x,ny=n.y;if(nx!=null){if(abs(nx-x)+abs(ny-y)<.01){insertChild(n,d,x,y,x1,y1,x2,y2);}else{var nPoint=n.point;n.x=n.y=n.point=null;insertChild(n,nPoint,nx,ny,x1,y1,x2,y2);insertChild(n,d,x,y,x1,y1,x2,y2);}}else{n.x=x,n.y=y,n.point=d;}}else{insertChild(n,d,x,y,x1,y1,x2,y2);}}
function insertChild(n,d,x,y,x1,y1,x2,y2){var xm=(x1+x2)*.5,ym=(y1+y2)*.5,right=x>=xm,below=y>=ym,i=below<<1|right;n.leaf=false;n=n.nodes[i]||(n.nodes[i]=d3_geom_quadtreeNode());if(right)x1=xm;else x2=xm;if(below)y1=ym;else y2=ym;insert(n,d,x,y,x1,y1,x2,y2);}
var root=d3_geom_quadtreeNode();root.add=function(d){insert(root,d,+fx(d,++i),+fy(d,i),x1_,y1_,x2_,y2_);};root.visit=function(f){d3_geom_quadtreeVisit(f,root,x1_,y1_,x2_,y2_);};root.find=function(point){return d3_geom_quadtreeFind(root,point[0],point[1],x1_,y1_,x2_,y2_);};i=-1;if(x1==null){while(++i<n){insert(root,data[i],xs[i],ys[i],x1_,y1_,x2_,y2_);}
--i;}else data.forEach(root.add);xs=ys=data=d=null;return root;}
quadtree.x=function(_){return arguments.length?(x=_,quadtree):x;};quadtree.y=function(_){return arguments.length?(y=_,quadtree):y;};quadtree.extent=function(_){if(!arguments.length)return x1==null?null:[[x1,y1],[x2,y2]];if(_==null)x1=y1=x2=y2=null;else x1=+_[0][0],y1=+_[0][1],x2=+_[1][0],y2=+_[1][1];return quadtree;};quadtree.size=function(_){if(!arguments.length)return x1==null?null:[x2-x1,y2-y1];if(_==null)x1=y1=x2=y2=null;else x1=y1=0,x2=+_[0],y2=+_[1];return quadtree;};return quadtree;};function d3_geom_quadtreeCompatX(d){return d.x;}
function d3_geom_quadtreeCompatY(d){return d.y;}
function d3_geom_quadtreeNode(){return{leaf:true,nodes:[],point:null,x:null,y:null};}
function d3_geom_quadtreeVisit(f,node,x1,y1,x2,y2){if(!f(node,x1,y1,x2,y2)){var sx=(x1+x2)*.5,sy=(y1+y2)*.5,children=node.nodes;if(children[0])d3_geom_quadtreeVisit(f,children[0],x1,y1,sx,sy);if(children[1])d3_geom_quadtreeVisit(f,children[1],sx,y1,x2,sy);if(children[2])d3_geom_quadtreeVisit(f,children[2],x1,sy,sx,y2);if(children[3])d3_geom_quadtreeVisit(f,children[3],sx,sy,x2,y2);}}
function d3_geom_quadtreeFind(root,x,y,x0,y0,x3,y3){var minDistance2=Infinity,closestPoint;(function find(node,x1,y1,x2,y2){if(x1>x3||y1>y3||x2<x0||y2<y0)return;if(point=node.point){var point,dx=x-node.x,dy=y-node.y,distance2=dx*dx+dy*dy;if(distance2<minDistance2){var distance=Math.sqrt(minDistance2=distance2);x0=x-distance,y0=y-distance;x3=x+distance,y3=y+distance;closestPoint=point;}}
var children=node.nodes,xm=(x1+x2)*.5,ym=(y1+y2)*.5,right=x>=xm,below=y>=ym;for(var i=below<<1|right,j=i+4;i<j;++i){if(node=children[i&3])switch(i&3){case 0:find(node,x1,y1,xm,ym);break;case 1:find(node,xm,y1,x2,ym);break;case 2:find(node,x1,ym,xm,y2);break;case 3:find(node,xm,ym,x2,y2);break;}}})(root,x0,y0,x3,y3);return closestPoint;}
d3.interpolateRgb=d3_interpolateRgb;function d3_interpolateRgb(a,b){a=d3.rgb(a);b=d3.rgb(b);var ar=a.r,ag=a.g,ab=a.b,br=b.r-ar,bg=b.g-ag,bb=b.b-ab;return function(t){return"#"+d3_rgb_hex(Math.round(ar+br*t))+d3_rgb_hex(Math.round(ag+bg*t))+d3_rgb_hex(Math.round(ab+bb*t));};}
d3.interpolateObject=d3_interpolateObject;function d3_interpolateObject(a,b){var i={},c={},k;for(k in a){if(k in b){i[k]=d3_interpolate(a[k],b[k]);}else{c[k]=a[k];}}
for(k in b){if(!(k in a)){c[k]=b[k];}}
return function(t){for(k in i)c[k]=i[k](t);return c;};}
d3.interpolateNumber=d3_interpolateNumber;function d3_interpolateNumber(a,b){a=+a,b=+b;return function(t){return a*(1-t)+b*t;};}
d3.interpolateString=d3_interpolateString;function d3_interpolateString(a,b){var bi=d3_interpolate_numberA.lastIndex=d3_interpolate_numberB.lastIndex=0,am,bm,bs,i=-1,s=[],q=[];a=a+"",b=b+"";while((am=d3_interpolate_numberA.exec(a))&&(bm=d3_interpolate_numberB.exec(b))){if((bs=bm.index)>bi){bs=b.slice(bi,bs);if(s[i])s[i]+=bs;else s[++i]=bs;}
if((am=am[0])===(bm=bm[0])){if(s[i])s[i]+=bm;else s[++i]=bm;}else{s[++i]=null;q.push({i:i,x:d3_interpolateNumber(am,bm)});}
bi=d3_interpolate_numberB.lastIndex;}
if(bi<b.length){bs=b.slice(bi);if(s[i])s[i]+=bs;else s[++i]=bs;}
return s.length<2?q[0]?(b=q[0].x,function(t){return b(t)+"";}):function(){return b;}:(b=q.length,function(t){for(var i=0,o;i<b;++i)s[(o=q[i]).i]=o.x(t);return s.join("");});}
var d3_interpolate_numberA=/[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g,d3_interpolate_numberB=new RegExp(d3_interpolate_numberA.source,"g");d3.interpolate=d3_interpolate;function d3_interpolate(a,b){var i=d3.interpolators.length,f;while(--i>=0&&!(f=d3.interpolators[i](a,b)));return f;}
d3.interpolators=[function(a,b){var t=typeof b;return(t==="string"?d3_rgb_names.has(b.toLowerCase())||/^(#|rgb\(|hsl\()/i.test(b)?d3_interpolateRgb:d3_interpolateString:b instanceof d3_color?d3_interpolateRgb:Array.isArray(b)?d3_interpolateArray:t==="object"&&isNaN(b)?d3_interpolateObject:d3_interpolateNumber)(a,b);}];d3.interpolateArray=d3_interpolateArray;function d3_interpolateArray(a,b){var x=[],c=[],na=a.length,nb=b.length,n0=Math.min(a.length,b.length),i;for(i=0;i<n0;++i)x.push(d3_interpolate(a[i],b[i]));for(;i<na;++i)c[i]=a[i];for(;i<nb;++i)c[i]=b[i];return function(t){for(i=0;i<n0;++i)c[i]=x[i](t);return c;};}
var d3_ease_default=function(){return d3_identity;};var d3_ease=d3.map({linear:d3_ease_default,poly:d3_ease_poly,quad:function(){return d3_ease_quad;},cubic:function(){return d3_ease_cubic;},sin:function(){return d3_ease_sin;},exp:function(){return d3_ease_exp;},circle:function(){return d3_ease_circle;},elastic:d3_ease_elastic,back:d3_ease_back,bounce:function(){return d3_ease_bounce;}});var d3_ease_mode=d3.map({"in":d3_identity,out:d3_ease_reverse,"in-out":d3_ease_reflect,"out-in":function(f){return d3_ease_reflect(d3_ease_reverse(f));}});d3.ease=function(name){var i=name.indexOf("-"),t=i>=0?name.slice(0,i):name,m=i>=0?name.slice(i+1):"in";t=d3_ease.get(t)||d3_ease_default;m=d3_ease_mode.get(m)||d3_identity;return d3_ease_clamp(m(t.apply(null,d3_arraySlice.call(arguments,1))));};function d3_ease_clamp(f){return function(t){return t<=0?0:t>=1?1:f(t);};}
function d3_ease_reverse(f){return function(t){return 1-f(1-t);};}
function d3_ease_reflect(f){return function(t){return.5*(t<.5?f(2*t):2-f(2-2*t));};}
function d3_ease_quad(t){return t*t;}
function d3_ease_cubic(t){return t*t*t;}
function d3_ease_cubicInOut(t){if(t<=0)return 0;if(t>=1)return 1;var t2=t*t,t3=t2*t;return 4*(t<.5?t3:3*(t-t2)+t3-.75);}
function d3_ease_poly(e){return function(t){return Math.pow(t,e);};}
function d3_ease_sin(t){return 1-Math.cos(t*halfπ);}
function d3_ease_exp(t){return Math.pow(2,10*(t-1));}
function d3_ease_circle(t){return 1-Math.sqrt(1-t*t);}
function d3_ease_elastic(a,p){var s;if(arguments.length<2)p=.45;if(arguments.length)s=p/τ*Math.asin(1/a);else a=1,s=p/4;return function(t){return 1+a*Math.pow(2,-10*t)*Math.sin((t-s)*τ/p);};}
function d3_ease_back(s){if(!s)s=1.70158;return function(t){return t*t*((s+1)*t-s);};}
function d3_ease_bounce(t){return t<1/2.75?7.5625*t*t:t<2/2.75?7.5625*(t-=1.5/2.75)*t+.75:t<2.5/2.75?7.5625*(t-=2.25/2.75)*t+.9375:7.5625*(t-=2.625/2.75)*t+.984375;}
d3.interpolateHcl=d3_interpolateHcl;function d3_interpolateHcl(a,b){a=d3.hcl(a);b=d3.hcl(b);var ah=a.h,ac=a.c,al=a.l,bh=b.h-ah,bc=b.c-ac,bl=b.l-al;if(isNaN(bc))bc=0,ac=isNaN(ac)?b.c:ac;if(isNaN(bh))bh=0,ah=isNaN(ah)?b.h:ah;else if(bh>180)bh-=360;else if(bh<-180)bh+=360;return function(t){return d3_hcl_lab(ah+bh*t,ac+bc*t,al+bl*t)+"";};}
d3.interpolateHsl=d3_interpolateHsl;function d3_interpolateHsl(a,b){a=d3.hsl(a);b=d3.hsl(b);var ah=a.h,as=a.s,al=a.l,bh=b.h-ah,bs=b.s-as,bl=b.l-al;if(isNaN(bs))bs=0,as=isNaN(as)?b.s:as;if(isNaN(bh))bh=0,ah=isNaN(ah)?b.h:ah;else if(bh>180)bh-=360;else if(bh<-180)bh+=360;return function(t){return d3_hsl_rgb(ah+bh*t,as+bs*t,al+bl*t)+"";};}
d3.interpolateLab=d3_interpolateLab;function d3_interpolateLab(a,b){a=d3.lab(a);b=d3.lab(b);var al=a.l,aa=a.a,ab=a.b,bl=b.l-al,ba=b.a-aa,bb=b.b-ab;return function(t){return d3_lab_rgb(al+bl*t,aa+ba*t,ab+bb*t)+"";};}
d3.interpolateRound=d3_interpolateRound;function d3_interpolateRound(a,b){b-=a;return function(t){return Math.round(a+b*t);};}
d3.transform=function(string){var g=d3_document.createElementNS(d3.ns.prefix.svg,"g");return(d3.transform=function(string){if(string!=null){g.setAttribute("transform",string);var t=g.transform.baseVal.consolidate();}
return new d3_transform(t?t.matrix:d3_transformIdentity);})(string);};function d3_transform(m){var r0=[m.a,m.b],r1=[m.c,m.d],kx=d3_transformNormalize(r0),kz=d3_transformDot(r0,r1),ky=d3_transformNormalize(d3_transformCombine(r1,r0,-kz))||0;if(r0[0]*r1[1]<r1[0]*r0[1]){r0[0]*=-1;r0[1]*=-1;kx*=-1;kz*=-1;}
this.rotate=(kx?Math.atan2(r0[1],r0[0]):Math.atan2(-r1[0],r1[1]))*d3_degrees;this.translate=[m.e,m.f];this.scale=[kx,ky];this.skew=ky?Math.atan2(kz,ky)*d3_degrees:0;}
d3_transform.prototype.toString=function(){return"translate("+this.translate+")rotate("+this.rotate+")skewX("+this.skew+")scale("+this.scale+")";};function d3_transformDot(a,b){return a[0]*b[0]+a[1]*b[1];}
function d3_transformNormalize(a){var k=Math.sqrt(d3_transformDot(a,a));if(k){a[0]/=k;a[1]/=k;}
return k;}
function d3_transformCombine(a,b,k){a[0]+=k*b[0];a[1]+=k*b[1];return a;}
var d3_transformIdentity={a:1,b:0,c:0,d:1,e:0,f:0};d3.interpolateTransform=d3_interpolateTransform;function d3_interpolateTransform(a,b){var s=[],q=[],n,A=d3.transform(a),B=d3.transform(b),ta=A.translate,tb=B.translate,ra=A.rotate,rb=B.rotate,wa=A.skew,wb=B.skew,ka=A.scale,kb=B.scale;if(ta[0]!=tb[0]||ta[1]!=tb[1]){s.push("translate(",null,",",null,")");q.push({i:1,x:d3_interpolateNumber(ta[0],tb[0])},{i:3,x:d3_interpolateNumber(ta[1],tb[1])});}else if(tb[0]||tb[1]){s.push("translate("+tb+")");}else{s.push("");}
if(ra!=rb){if(ra-rb>180)rb+=360;else if(rb-ra>180)ra+=360;q.push({i:s.push(s.pop()+"rotate(",null,")")-2,x:d3_interpolateNumber(ra,rb)});}else if(rb){s.push(s.pop()+"rotate("+rb+")");}
if(wa!=wb){q.push({i:s.push(s.pop()+"skewX(",null,")")-2,x:d3_interpolateNumber(wa,wb)});}else if(wb){s.push(s.pop()+"skewX("+wb+")");}
if(ka[0]!=kb[0]||ka[1]!=kb[1]){n=s.push(s.pop()+"scale(",null,",",null,")");q.push({i:n-4,x:d3_interpolateNumber(ka[0],kb[0])},{i:n-2,x:d3_interpolateNumber(ka[1],kb[1])});}else if(kb[0]!=1||kb[1]!=1){s.push(s.pop()+"scale("+kb+")");}
n=q.length;return function(t){var i=-1,o;while(++i<n)s[(o=q[i]).i]=o.x(t);return s.join("");};}
function d3_uninterpolateNumber(a,b){b=(b-=a=+a)||1/b;return function(x){return(x-a)/b;};}
function d3_uninterpolateClamp(a,b){b=(b-=a=+a)||1/b;return function(x){return Math.max(0,Math.min(1,(x-a)/b));};}
d3.layout={};d3.layout.bundle=function(){return function(links){var paths=[],i=-1,n=links.length;while(++i<n)paths.push(d3_layout_bundlePath(links[i]));return paths;};};function d3_layout_bundlePath(link){var start=link.source,end=link.target,lca=d3_layout_bundleLeastCommonAncestor(start,end),points=[start];while(start!==lca){start=start.parent;points.push(start);}
var k=points.length;while(end!==lca){points.splice(k,0,end);end=end.parent;}
return points;}
function d3_layout_bundleAncestors(node){var ancestors=[],parent=node.parent;while(parent!=null){ancestors.push(node);node=parent;parent=parent.parent;}
ancestors.push(node);return ancestors;}
function d3_layout_bundleLeastCommonAncestor(a,b){if(a===b)return a;var aNodes=d3_layout_bundleAncestors(a),bNodes=d3_layout_bundleAncestors(b),aNode=aNodes.pop(),bNode=bNodes.pop(),sharedNode=null;while(aNode===bNode){sharedNode=aNode;aNode=aNodes.pop();bNode=bNodes.pop();}
return sharedNode;}
d3.layout.chord=function(){var chord={},chords,groups,matrix,n,padding=0,sortGroups,sortSubgroups,sortChords;function relayout(){var subgroups={},groupSums=[],groupIndex=d3.range(n),subgroupIndex=[],k,x,x0,i,j;chords=[];groups=[];k=0,i=-1;while(++i<n){x=0,j=-1;while(++j<n){x+=matrix[i][j];}
groupSums.push(x);subgroupIndex.push(d3.range(n));k+=x;}
if(sortGroups){groupIndex.sort(function(a,b){return sortGroups(groupSums[a],groupSums[b]);});}
if(sortSubgroups){subgroupIndex.forEach(function(d,i){d.sort(function(a,b){return sortSubgroups(matrix[i][a],matrix[i][b]);});});}
k=(τ-padding*n)/k;x=0,i=-1;while(++i<n){x0=x,j=-1;while(++j<n){var di=groupIndex[i],dj=subgroupIndex[di][j],v=matrix[di][dj],a0=x,a1=x+=v*k;subgroups[di+"-"+dj]={index:di,subindex:dj,startAngle:a0,endAngle:a1,value:v};}
groups[di]={index:di,startAngle:x0,endAngle:x,value:(x-x0)/k};x+=padding;}
i=-1;while(++i<n){j=i-1;while(++j<n){var source=subgroups[i+"-"+j],target=subgroups[j+"-"+i];if(source.value||target.value){chords.push(source.value<target.value?{source:target,target:source}:{source:source,target:target});}}}
if(sortChords)resort();}
function resort(){chords.sort(function(a,b){return sortChords((a.source.value+a.target.value)/2,(b.source.value+b.target.value)/2);});}
chord.matrix=function(x){if(!arguments.length)return matrix;n=(matrix=x)&&matrix.length;chords=groups=null;return chord;};chord.padding=function(x){if(!arguments.length)return padding;padding=x;chords=groups=null;return chord;};chord.sortGroups=function(x){if(!arguments.length)return sortGroups;sortGroups=x;chords=groups=null;return chord;};chord.sortSubgroups=function(x){if(!arguments.length)return sortSubgroups;sortSubgroups=x;chords=null;return chord;};chord.sortChords=function(x){if(!arguments.length)return sortChords;sortChords=x;if(chords)resort();return chord;};chord.chords=function(){if(!chords)relayout();return chords;};chord.groups=function(){if(!groups)relayout();return groups;};return chord;};d3.layout.force=function(){var force={},event=d3.dispatch("start","tick","end"),size=[1,1],drag,alpha,friction=.9,linkDistance=d3_layout_forceLinkDistance,linkStrength=d3_layout_forceLinkStrength,charge=-30,chargeDistance2=d3_layout_forceChargeDistance2,gravity=.1,theta2=.64,nodes=[],links=[],distances,strengths,charges;function repulse(node){return function(quad,x1,_,x2){if(quad.point!==node){var dx=quad.cx-node.x,dy=quad.cy-node.y,dw=x2-x1,dn=dx*dx+dy*dy;if(dw*dw/theta2<dn){if(dn<chargeDistance2){var k=quad.charge/dn;node.px-=dx*k;node.py-=dy*k;}
return true;}
if(quad.point&&dn&&dn<chargeDistance2){var k=quad.pointCharge/dn;node.px-=dx*k;node.py-=dy*k;}}
return!quad.charge;};}
force.tick=function(){if((alpha*=.99)<.005){event.end({type:"end",alpha:alpha=0});return true;}
var n=nodes.length,m=links.length,q,i,o,s,t,l,k,x,y;for(i=0;i<m;++i){o=links[i];s=o.source;t=o.target;x=t.x-s.x;y=t.y-s.y;if(l=x*x+y*y){l=alpha*strengths[i]*((l=Math.sqrt(l))-distances[i])/l;x*=l;y*=l;t.x-=x*(k=s.weight/(t.weight+s.weight));t.y-=y*k;s.x+=x*(k=1-k);s.y+=y*k;}}
if(k=alpha*gravity){x=size[0]/2;y=size[1]/2;i=-1;if(k)while(++i<n){o=nodes[i];o.x+=(x-o.x)*k;o.y+=(y-o.y)*k;}}
if(charge){d3_layout_forceAccumulate(q=d3.geom.quadtree(nodes),alpha,charges);i=-1;while(++i<n){if(!(o=nodes[i]).fixed){q.visit(repulse(o));}}}
i=-1;while(++i<n){o=nodes[i];if(o.fixed){o.x=o.px;o.y=o.py;}else{o.x-=(o.px-(o.px=o.x))*friction;o.y-=(o.py-(o.py=o.y))*friction;}}
event.tick({type:"tick",alpha:alpha});};force.nodes=function(x){if(!arguments.length)return nodes;nodes=x;return force;};force.links=function(x){if(!arguments.length)return links;links=x;return force;};force.size=function(x){if(!arguments.length)return size;size=x;return force;};force.linkDistance=function(x){if(!arguments.length)return linkDistance;linkDistance=typeof x==="function"?x:+x;return force;};force.distance=force.linkDistance;force.linkStrength=function(x){if(!arguments.length)return linkStrength;linkStrength=typeof x==="function"?x:+x;return force;};force.friction=function(x){if(!arguments.length)return friction;friction=+x;return force;};force.charge=function(x){if(!arguments.length)return charge;charge=typeof x==="function"?x:+x;return force;};force.chargeDistance=function(x){if(!arguments.length)return Math.sqrt(chargeDistance2);chargeDistance2=x*x;return force;};force.gravity=function(x){if(!arguments.length)return gravity;gravity=+x;return force;};force.theta=function(x){if(!arguments.length)return Math.sqrt(theta2);theta2=x*x;return force;};force.alpha=function(x){if(!arguments.length)return alpha;x=+x;if(alpha){if(x>0)alpha=x;else alpha=0;}else if(x>0){event.start({type:"start",alpha:alpha=x});d3.timer(force.tick);}
return force;};force.start=function(){var i,n=nodes.length,m=links.length,w=size[0],h=size[1],neighbors,o;for(i=0;i<n;++i){(o=nodes[i]).index=i;o.weight=0;}
for(i=0;i<m;++i){o=links[i];if(typeof o.source=="number")o.source=nodes[o.source];if(typeof o.target=="number")o.target=nodes[o.target];++o.source.weight;++o.target.weight;}
for(i=0;i<n;++i){o=nodes[i];if(isNaN(o.x))o.x=position("x",w);if(isNaN(o.y))o.y=position("y",h);if(isNaN(o.px))o.px=o.x;if(isNaN(o.py))o.py=o.y;}
distances=[];if(typeof linkDistance==="function")for(i=0;i<m;++i)distances[i]=+linkDistance.call(this,links[i],i);else for(i=0;i<m;++i)distances[i]=linkDistance;strengths=[];if(typeof linkStrength==="function")for(i=0;i<m;++i)strengths[i]=+linkStrength.call(this,links[i],i);else for(i=0;i<m;++i)strengths[i]=linkStrength;charges=[];if(typeof charge==="function")for(i=0;i<n;++i)charges[i]=+charge.call(this,nodes[i],i);else for(i=0;i<n;++i)charges[i]=charge;function position(dimension,size){if(!neighbors){neighbors=new Array(n);for(j=0;j<n;++j){neighbors[j]=[];}
for(j=0;j<m;++j){var o=links[j];neighbors[o.source.index].push(o.target);neighbors[o.target.index].push(o.source);}}
var candidates=neighbors[i],j=-1,l=candidates.length,x;while(++j<l)if(!isNaN(x=candidates[j][dimension]))return x;return Math.random()*size;}
return force.resume();};force.resume=function(){return force.alpha(.1);};force.stop=function(){return force.alpha(0);};force.drag=function(){if(!drag)drag=d3.behavior.drag().origin(d3_identity).on("dragstart.force",d3_layout_forceDragstart).on("drag.force",dragmove).on("dragend.force",d3_layout_forceDragend);if(!arguments.length)return drag;this.on("mouseover.force",d3_layout_forceMouseover).on("mouseout.force",d3_layout_forceMouseout).call(drag);};function dragmove(d){d.px=d3.event.x,d.py=d3.event.y;force.resume();}
return d3.rebind(force,event,"on");};function d3_layout_forceDragstart(d){d.fixed|=2;}
function d3_layout_forceDragend(d){d.fixed&=~6;}
function d3_layout_forceMouseover(d){d.fixed|=4;d.px=d.x,d.py=d.y;}
function d3_layout_forceMouseout(d){d.fixed&=~4;}
function d3_layout_forceAccumulate(quad,alpha,charges){var cx=0,cy=0;quad.charge=0;if(!quad.leaf){var nodes=quad.nodes,n=nodes.length,i=-1,c;while(++i<n){c=nodes[i];if(c==null)continue;d3_layout_forceAccumulate(c,alpha,charges);quad.charge+=c.charge;cx+=c.charge*c.cx;cy+=c.charge*c.cy;}}
if(quad.point){if(!quad.leaf){quad.point.x+=Math.random()-.5;quad.point.y+=Math.random()-.5;}
var k=alpha*charges[quad.point.index];quad.charge+=quad.pointCharge=k;cx+=k*quad.point.x;cy+=k*quad.point.y;}
quad.cx=cx/quad.charge;quad.cy=cy/quad.charge;}
var d3_layout_forceLinkDistance=20,d3_layout_forceLinkStrength=1,d3_layout_forceChargeDistance2=Infinity;d3.layout.hierarchy=function(){var sort=d3_layout_hierarchySort,children=d3_layout_hierarchyChildren,value=d3_layout_hierarchyValue;function hierarchy(root){var stack=[root],nodes=[],node;root.depth=0;while((node=stack.pop())!=null){nodes.push(node);if((childs=children.call(hierarchy,node,node.depth))&&(n=childs.length)){var n,childs,child;while(--n>=0){stack.push(child=childs[n]);child.parent=node;child.depth=node.depth+1;}
if(value)node.value=0;node.children=childs;}else{if(value)node.value=+value.call(hierarchy,node,node.depth)||0;delete node.children;}}
d3_layout_hierarchyVisitAfter(root,function(node){var childs,parent;if(sort&&(childs=node.children))childs.sort(sort);if(value&&(parent=node.parent))parent.value+=node.value;});return nodes;}
hierarchy.sort=function(x){if(!arguments.length)return sort;sort=x;return hierarchy;};hierarchy.children=function(x){if(!arguments.length)return children;children=x;return hierarchy;};hierarchy.value=function(x){if(!arguments.length)return value;value=x;return hierarchy;};hierarchy.revalue=function(root){if(value){d3_layout_hierarchyVisitBefore(root,function(node){if(node.children)node.value=0;});d3_layout_hierarchyVisitAfter(root,function(node){var parent;if(!node.children)node.value=+value.call(hierarchy,node,node.depth)||0;if(parent=node.parent)parent.value+=node.value;});}
return root;};return hierarchy;};function d3_layout_hierarchyRebind(object,hierarchy){d3.rebind(object,hierarchy,"sort","children","value");object.nodes=object;object.links=d3_layout_hierarchyLinks;return object;}
function d3_layout_hierarchyVisitBefore(node,callback){var nodes=[node];while((node=nodes.pop())!=null){callback(node);if((children=node.children)&&(n=children.length)){var n,children;while(--n>=0)nodes.push(children[n]);}}}
function d3_layout_hierarchyVisitAfter(node,callback){var nodes=[node],nodes2=[];while((node=nodes.pop())!=null){nodes2.push(node);if((children=node.children)&&(n=children.length)){var i=-1,n,children;while(++i<n)nodes.push(children[i]);}}
while((node=nodes2.pop())!=null){callback(node);}}
function d3_layout_hierarchyChildren(d){return d.children;}
function d3_layout_hierarchyValue(d){return d.value;}
function d3_layout_hierarchySort(a,b){return b.value-a.value;}
function d3_layout_hierarchyLinks(nodes){return d3.merge(nodes.map(function(parent){return(parent.children||[]).map(function(child){return{source:parent,target:child};});}));}
d3.layout.partition=function(){var hierarchy=d3.layout.hierarchy(),size=[1,1];function position(node,x,dx,dy){var children=node.children;node.x=x;node.y=node.depth*dy;node.dx=dx;node.dy=dy;if(children&&(n=children.length)){var i=-1,n,c,d;dx=node.value?dx/node.value:0;while(++i<n){position(c=children[i],x,d=c.value*dx,dy);x+=d;}}}
function depth(node){var children=node.children,d=0;if(children&&(n=children.length)){var i=-1,n;while(++i<n)d=Math.max(d,depth(children[i]));}
return 1+d;}
function partition(d,i){var nodes=hierarchy.call(this,d,i);position(nodes[0],0,size[0],size[1]/depth(nodes[0]));return nodes;}
partition.size=function(x){if(!arguments.length)return size;size=x;return partition;};return d3_layout_hierarchyRebind(partition,hierarchy);};d3.layout.pie=function(){var value=Number,sort=d3_layout_pieSortByValue,startAngle=0,endAngle=τ,padAngle=0;function pie(data){var n=data.length,values=data.map(function(d,i){return+value.call(pie,d,i);}),a=+(typeof startAngle==="function"?startAngle.apply(this,arguments):startAngle),da=(typeof endAngle==="function"?endAngle.apply(this,arguments):endAngle)-a,p=Math.min(Math.abs(da)/n,+(typeof padAngle==="function"?padAngle.apply(this,arguments):padAngle)),pa=p*(da<0?-1:1),k=(da-n*pa)/d3.sum(values),index=d3.range(n),arcs=[],v;if(sort!=null)index.sort(sort===d3_layout_pieSortByValue?function(i,j){return values[j]-values[i];}:function(i,j){return sort(data[i],data[j]);});index.forEach(function(i){arcs[i]={data:data[i],value:v=values[i],startAngle:a,endAngle:a+=v*k+pa,padAngle:p};});return arcs;}
pie.value=function(_){if(!arguments.length)return value;value=_;return pie;};pie.sort=function(_){if(!arguments.length)return sort;sort=_;return pie;};pie.startAngle=function(_){if(!arguments.length)return startAngle;startAngle=_;return pie;};pie.endAngle=function(_){if(!arguments.length)return endAngle;endAngle=_;return pie;};pie.padAngle=function(_){if(!arguments.length)return padAngle;padAngle=_;return pie;};return pie;};var d3_layout_pieSortByValue={};d3.layout.stack=function(){var values=d3_identity,order=d3_layout_stackOrderDefault,offset=d3_layout_stackOffsetZero,out=d3_layout_stackOut,x=d3_layout_stackX,y=d3_layout_stackY;function stack(data,index){if(!(n=data.length))return data;var series=data.map(function(d,i){return values.call(stack,d,i);});var points=series.map(function(d){return d.map(function(v,i){return[x.call(stack,v,i),y.call(stack,v,i)];});});var orders=order.call(stack,points,index);series=d3.permute(series,orders);points=d3.permute(points,orders);var offsets=offset.call(stack,points,index);var m=series[0].length,n,i,j,o;for(j=0;j<m;++j){out.call(stack,series[0][j],o=offsets[j],points[0][j][1]);for(i=1;i<n;++i){out.call(stack,series[i][j],o+=points[i-1][j][1],points[i][j][1]);}}
return data;}
stack.values=function(x){if(!arguments.length)return values;values=x;return stack;};stack.order=function(x){if(!arguments.length)return order;order=typeof x==="function"?x:d3_layout_stackOrders.get(x)||d3_layout_stackOrderDefault;return stack;};stack.offset=function(x){if(!arguments.length)return offset;offset=typeof x==="function"?x:d3_layout_stackOffsets.get(x)||d3_layout_stackOffsetZero;return stack;};stack.x=function(z){if(!arguments.length)return x;x=z;return stack;};stack.y=function(z){if(!arguments.length)return y;y=z;return stack;};stack.out=function(z){if(!arguments.length)return out;out=z;return stack;};return stack;};function d3_layout_stackX(d){return d.x;}
function d3_layout_stackY(d){return d.y;}
function d3_layout_stackOut(d,y0,y){d.y0=y0;d.y=y;}
var d3_layout_stackOrders=d3.map({"inside-out":function(data){var n=data.length,i,j,max=data.map(d3_layout_stackMaxIndex),sums=data.map(d3_layout_stackReduceSum),index=d3.range(n).sort(function(a,b){return max[a]-max[b];}),top=0,bottom=0,tops=[],bottoms=[];for(i=0;i<n;++i){j=index[i];if(top<bottom){top+=sums[j];tops.push(j);}else{bottom+=sums[j];bottoms.push(j);}}
return bottoms.reverse().concat(tops);},reverse:function(data){return d3.range(data.length).reverse();},"default":d3_layout_stackOrderDefault});var d3_layout_stackOffsets=d3.map({silhouette:function(data){var n=data.length,m=data[0].length,sums=[],max=0,i,j,o,y0=[];for(j=0;j<m;++j){for(i=0,o=0;i<n;i++)o+=data[i][j][1];if(o>max)max=o;sums.push(o);}
for(j=0;j<m;++j){y0[j]=(max-sums[j])/2;}
return y0;},wiggle:function(data){var n=data.length,x=data[0],m=x.length,i,j,k,s1,s2,s3,dx,o,o0,y0=[];y0[0]=o=o0=0;for(j=1;j<m;++j){for(i=0,s1=0;i<n;++i)s1+=data[i][j][1];for(i=0,s2=0,dx=x[j][0]-x[j-1][0];i<n;++i){for(k=0,s3=(data[i][j][1]-data[i][j-1][1])/(2*dx);k<i;++k){s3+=(data[k][j][1]-data[k][j-1][1])/dx;}
s2+=s3*data[i][j][1];}
y0[j]=o-=s1?s2/s1*dx:0;if(o<o0)o0=o;}
for(j=0;j<m;++j)y0[j]-=o0;return y0;},expand:function(data){var n=data.length,m=data[0].length,k=1/n,i,j,o,y0=[];for(j=0;j<m;++j){for(i=0,o=0;i<n;i++)o+=data[i][j][1];if(o)for(i=0;i<n;i++)data[i][j][1]/=o;else for(i=0;i<n;i++)data[i][j][1]=k;}
for(j=0;j<m;++j)y0[j]=0;return y0;},zero:d3_layout_stackOffsetZero});function d3_layout_stackOrderDefault(data){return d3.range(data.length);}
function d3_layout_stackOffsetZero(data){var j=-1,m=data[0].length,y0=[];while(++j<m)y0[j]=0;return y0;}
function d3_layout_stackMaxIndex(array){var i=1,j=0,v=array[0][1],k,n=array.length;for(;i<n;++i){if((k=array[i][1])>v){j=i;v=k;}}
return j;}
function d3_layout_stackReduceSum(d){return d.reduce(d3_layout_stackSum,0);}
function d3_layout_stackSum(p,d){return p+d[1];}
d3.layout.histogram=function(){var frequency=true,valuer=Number,ranger=d3_layout_histogramRange,binner=d3_layout_histogramBinSturges;function histogram(data,i){var bins=[],values=data.map(valuer,this),range=ranger.call(this,values,i),thresholds=binner.call(this,range,values,i),bin,i=-1,n=values.length,m=thresholds.length-1,k=frequency?1:1/n,x;while(++i<m){bin=bins[i]=[];bin.dx=thresholds[i+1]-(bin.x=thresholds[i]);bin.y=0;}
if(m>0){i=-1;while(++i<n){x=values[i];if(x>=range[0]&&x<=range[1]){bin=bins[d3.bisect(thresholds,x,1,m)-1];bin.y+=k;bin.push(data[i]);}}}
return bins;}
histogram.value=function(x){if(!arguments.length)return valuer;valuer=x;return histogram;};histogram.range=function(x){if(!arguments.length)return ranger;ranger=d3_functor(x);return histogram;};histogram.bins=function(x){if(!arguments.length)return binner;binner=typeof x==="number"?function(range){return d3_layout_histogramBinFixed(range,x);}:d3_functor(x);return histogram;};histogram.frequency=function(x){if(!arguments.length)return frequency;frequency=!!x;return histogram;};return histogram;};function d3_layout_histogramBinSturges(range,values){return d3_layout_histogramBinFixed(range,Math.ceil(Math.log(values.length)/Math.LN2+1));}
function d3_layout_histogramBinFixed(range,n){var x=-1,b=+range[0],m=(range[1]-b)/n,f=[];while(++x<=n)f[x]=m*x+b;return f;}
function d3_layout_histogramRange(values){return[d3.min(values),d3.max(values)];}
d3.layout.pack=function(){var hierarchy=d3.layout.hierarchy().sort(d3_layout_packSort),padding=0,size=[1,1],radius;function pack(d,i){var nodes=hierarchy.call(this,d,i),root=nodes[0],w=size[0],h=size[1],r=radius==null?Math.sqrt:typeof radius==="function"?radius:function(){return radius;};root.x=root.y=0;d3_layout_hierarchyVisitAfter(root,function(d){d.r=+r(d.value);});d3_layout_hierarchyVisitAfter(root,d3_layout_packSiblings);if(padding){var dr=padding*(radius?1:Math.max(2*root.r/w,2*root.r/h))/2;d3_layout_hierarchyVisitAfter(root,function(d){d.r+=dr;});d3_layout_hierarchyVisitAfter(root,d3_layout_packSiblings);d3_layout_hierarchyVisitAfter(root,function(d){d.r-=dr;});}
d3_layout_packTransform(root,w/2,h/2,radius?1:1/Math.max(2*root.r/w,2*root.r/h));return nodes;}
pack.size=function(_){if(!arguments.length)return size;size=_;return pack;};pack.radius=function(_){if(!arguments.length)return radius;radius=_==null||typeof _==="function"?_:+_;return pack;};pack.padding=function(_){if(!arguments.length)return padding;padding=+_;return pack;};return d3_layout_hierarchyRebind(pack,hierarchy);};function d3_layout_packSort(a,b){return a.value-b.value;}
function d3_layout_packInsert(a,b){var c=a._pack_next;a._pack_next=b;b._pack_prev=a;b._pack_next=c;c._pack_prev=b;}
function d3_layout_packSplice(a,b){a._pack_next=b;b._pack_prev=a;}
function d3_layout_packIntersects(a,b){var dx=b.x-a.x,dy=b.y-a.y,dr=a.r+b.r;return.999*dr*dr>dx*dx+dy*dy;}
function d3_layout_packSiblings(node){if(!(nodes=node.children)||!(n=nodes.length))return;var nodes,xMin=Infinity,xMax=-Infinity,yMin=Infinity,yMax=-Infinity,a,b,c,i,j,k,n;function bound(node){xMin=Math.min(node.x-node.r,xMin);xMax=Math.max(node.x+node.r,xMax);yMin=Math.min(node.y-node.r,yMin);yMax=Math.max(node.y+node.r,yMax);}
nodes.forEach(d3_layout_packLink);a=nodes[0];a.x=-a.r;a.y=0;bound(a);if(n>1){b=nodes[1];b.x=b.r;b.y=0;bound(b);if(n>2){c=nodes[2];d3_layout_packPlace(a,b,c);bound(c);d3_layout_packInsert(a,c);a._pack_prev=c;d3_layout_packInsert(c,b);b=a._pack_next;for(i=3;i<n;i++){d3_layout_packPlace(a,b,c=nodes[i]);var isect=0,s1=1,s2=1;for(j=b._pack_next;j!==b;j=j._pack_next,s1++){if(d3_layout_packIntersects(j,c)){isect=1;break;}}
if(isect==1){for(k=a._pack_prev;k!==j._pack_prev;k=k._pack_prev,s2++){if(d3_layout_packIntersects(k,c)){break;}}}
if(isect){if(s1<s2||s1==s2&&b.r<a.r)d3_layout_packSplice(a,b=j);else d3_layout_packSplice(a=k,b);i--;}else{d3_layout_packInsert(a,c);b=c;bound(c);}}}}
var cx=(xMin+xMax)/2,cy=(yMin+yMax)/2,cr=0;for(i=0;i<n;i++){c=nodes[i];c.x-=cx;c.y-=cy;cr=Math.max(cr,c.r+Math.sqrt(c.x*c.x+c.y*c.y));}
node.r=cr;nodes.forEach(d3_layout_packUnlink);}
function d3_layout_packLink(node){node._pack_next=node._pack_prev=node;}
function d3_layout_packUnlink(node){delete node._pack_next;delete node._pack_prev;}
function d3_layout_packTransform(node,x,y,k){var children=node.children;node.x=x+=k*node.x;node.y=y+=k*node.y;node.r*=k;if(children){var i=-1,n=children.length;while(++i<n)d3_layout_packTransform(children[i],x,y,k);}}
function d3_layout_packPlace(a,b,c){var db=a.r+c.r,dx=b.x-a.x,dy=b.y-a.y;if(db&&(dx||dy)){var da=b.r+c.r,dc=dx*dx+dy*dy;da*=da;db*=db;var x=.5+(db-da)/(2*dc),y=Math.sqrt(Math.max(0,2*da*(db+dc)-(db-=dc)*db-da*da))/(2*dc);c.x=a.x+x*dx+y*dy;c.y=a.y+x*dy-y*dx;}else{c.x=a.x+db;c.y=a.y;}}
d3.layout.tree=function(){var hierarchy=d3.layout.hierarchy().sort(null).value(null),separation=d3_layout_treeSeparation,size=[1,1],nodeSize=null;function tree(d,i){var nodes=hierarchy.call(this,d,i),root0=nodes[0],root1=wrapTree(root0);d3_layout_hierarchyVisitAfter(root1,firstWalk),root1.parent.m=-root1.z;d3_layout_hierarchyVisitBefore(root1,secondWalk);if(nodeSize)d3_layout_hierarchyVisitBefore(root0,sizeNode);else{var left=root0,right=root0,bottom=root0;d3_layout_hierarchyVisitBefore(root0,function(node){if(node.x<left.x)left=node;if(node.x>right.x)right=node;if(node.depth>bottom.depth)bottom=node;});var tx=separation(left,right)/2-left.x,kx=size[0]/(right.x+separation(right,left)/2+tx),ky=size[1]/(bottom.depth||1);d3_layout_hierarchyVisitBefore(root0,function(node){node.x=(node.x+tx)*kx;node.y=node.depth*ky;});}
return nodes;}
function wrapTree(root0){var root1={A:null,children:[root0]},queue=[root1],node1;while((node1=queue.pop())!=null){for(var children=node1.children,child,i=0,n=children.length;i<n;++i){queue.push((children[i]=child={_:children[i],parent:node1,children:(child=children[i].children)&&child.slice()||[],A:null,a:null,z:0,m:0,c:0,s:0,t:null,i:i}).a=child);}}
return root1.children[0];}
function firstWalk(v){var children=v.children,siblings=v.parent.children,w=v.i?siblings[v.i-1]:null;if(children.length){d3_layout_treeShift(v);var midpoint=(children[0].z+children[children.length-1].z)/2;if(w){v.z=w.z+separation(v._,w._);v.m=v.z-midpoint;}else{v.z=midpoint;}}else if(w){v.z=w.z+separation(v._,w._);}
v.parent.A=apportion(v,w,v.parent.A||siblings[0]);}
function secondWalk(v){v._.x=v.z+v.parent.m;v.m+=v.parent.m;}
function apportion(v,w,ancestor){if(w){var vip=v,vop=v,vim=w,vom=vip.parent.children[0],sip=vip.m,sop=vop.m,sim=vim.m,som=vom.m,shift;while(vim=d3_layout_treeRight(vim),vip=d3_layout_treeLeft(vip),vim&&vip){vom=d3_layout_treeLeft(vom);vop=d3_layout_treeRight(vop);vop.a=v;shift=vim.z+sim-vip.z-sip+separation(vim._,vip._);if(shift>0){d3_layout_treeMove(d3_layout_treeAncestor(vim,v,ancestor),v,shift);sip+=shift;sop+=shift;}
sim+=vim.m;sip+=vip.m;som+=vom.m;sop+=vop.m;}
if(vim&&!d3_layout_treeRight(vop)){vop.t=vim;vop.m+=sim-sop;}
if(vip&&!d3_layout_treeLeft(vom)){vom.t=vip;vom.m+=sip-som;ancestor=v;}}
return ancestor;}
function sizeNode(node){node.x*=size[0];node.y=node.depth*size[1];}
tree.separation=function(x){if(!arguments.length)return separation;separation=x;return tree;};tree.size=function(x){if(!arguments.length)return nodeSize?null:size;nodeSize=(size=x)==null?sizeNode:null;return tree;};tree.nodeSize=function(x){if(!arguments.length)return nodeSize?size:null;nodeSize=(size=x)==null?null:sizeNode;return tree;};return d3_layout_hierarchyRebind(tree,hierarchy);};function d3_layout_treeSeparation(a,b){return a.parent==b.parent?1:2;}
function d3_layout_treeLeft(v){var children=v.children;return children.length?children[0]:v.t;}
function d3_layout_treeRight(v){var children=v.children,n;return(n=children.length)?children[n-1]:v.t;}
function d3_layout_treeMove(wm,wp,shift){var change=shift/(wp.i-wm.i);wp.c-=change;wp.s+=shift;wm.c+=change;wp.z+=shift;wp.m+=shift;}
function d3_layout_treeShift(v){var shift=0,change=0,children=v.children,i=children.length,w;while(--i>=0){w=children[i];w.z+=shift;w.m+=shift;shift+=w.s+(change+=w.c);}}
function d3_layout_treeAncestor(vim,v,ancestor){return vim.a.parent===v.parent?vim.a:ancestor;}
d3.layout.cluster=function(){var hierarchy=d3.layout.hierarchy().sort(null).value(null),separation=d3_layout_treeSeparation,size=[1,1],nodeSize=false;function cluster(d,i){var nodes=hierarchy.call(this,d,i),root=nodes[0],previousNode,x=0;d3_layout_hierarchyVisitAfter(root,function(node){var children=node.children;if(children&&children.length){node.x=d3_layout_clusterX(children);node.y=d3_layout_clusterY(children);}else{node.x=previousNode?x+=separation(node,previousNode):0;node.y=0;previousNode=node;}});var left=d3_layout_clusterLeft(root),right=d3_layout_clusterRight(root),x0=left.x-separation(left,right)/2,x1=right.x+separation(right,left)/2;d3_layout_hierarchyVisitAfter(root,nodeSize?function(node){node.x=(node.x-root.x)*size[0];node.y=(root.y-node.y)*size[1];}:function(node){node.x=(node.x-x0)/(x1-x0)*size[0];node.y=(1-(root.y?node.y/root.y:1))*size[1];});return nodes;}
cluster.separation=function(x){if(!arguments.length)return separation;separation=x;return cluster;};cluster.size=function(x){if(!arguments.length)return nodeSize?null:size;nodeSize=(size=x)==null;return cluster;};cluster.nodeSize=function(x){if(!arguments.length)return nodeSize?size:null;nodeSize=(size=x)!=null;return cluster;};return d3_layout_hierarchyRebind(cluster,hierarchy);};function d3_layout_clusterY(children){return 1+d3.max(children,function(child){return child.y;});}
function d3_layout_clusterX(children){return children.reduce(function(x,child){return x+child.x;},0)/children.length;}
function d3_layout_clusterLeft(node){var children=node.children;return children&&children.length?d3_layout_clusterLeft(children[0]):node;}
function d3_layout_clusterRight(node){var children=node.children,n;return children&&(n=children.length)?d3_layout_clusterRight(children[n-1]):node;}
d3.layout.treemap=function(){var hierarchy=d3.layout.hierarchy(),round=Math.round,size=[1,1],padding=null,pad=d3_layout_treemapPadNull,sticky=false,stickies,mode="squarify",ratio=.5*(1+Math.sqrt(5));function scale(children,k){var i=-1,n=children.length,child,area;while(++i<n){area=(child=children[i]).value*(k<0?0:k);child.area=isNaN(area)||area<=0?0:area;}}
function squarify(node){var children=node.children;if(children&&children.length){var rect=pad(node),row=[],remaining=children.slice(),child,best=Infinity,score,u=mode==="slice"?rect.dx:mode==="dice"?rect.dy:mode==="slice-dice"?node.depth&1?rect.dy:rect.dx:Math.min(rect.dx,rect.dy),n;scale(remaining,rect.dx*rect.dy/node.value);row.area=0;while((n=remaining.length)>0){row.push(child=remaining[n-1]);row.area+=child.area;if(mode!=="squarify"||(score=worst(row,u))<=best){remaining.pop();best=score;}else{row.area-=row.pop().area;position(row,u,rect,false);u=Math.min(rect.dx,rect.dy);row.length=row.area=0;best=Infinity;}}
if(row.length){position(row,u,rect,true);row.length=row.area=0;}
children.forEach(squarify);}}
function stickify(node){var children=node.children;if(children&&children.length){var rect=pad(node),remaining=children.slice(),child,row=[];scale(remaining,rect.dx*rect.dy/node.value);row.area=0;while(child=remaining.pop()){row.push(child);row.area+=child.area;if(child.z!=null){position(row,child.z?rect.dx:rect.dy,rect,!remaining.length);row.length=row.area=0;}}
children.forEach(stickify);}}
function worst(row,u){var s=row.area,r,rmax=0,rmin=Infinity,i=-1,n=row.length;while(++i<n){if(!(r=row[i].area))continue;if(r<rmin)rmin=r;if(r>rmax)rmax=r;}
s*=s;u*=u;return s?Math.max(u*rmax*ratio/s,s/(u*rmin*ratio)):Infinity;}
function position(row,u,rect,flush){var i=-1,n=row.length,x=rect.x,y=rect.y,v=u?round(row.area/u):0,o;if(u==rect.dx){if(flush||v>rect.dy)v=rect.dy;while(++i<n){o=row[i];o.x=x;o.y=y;o.dy=v;x+=o.dx=Math.min(rect.x+rect.dx-x,v?round(o.area/v):0);}
o.z=true;o.dx+=rect.x+rect.dx-x;rect.y+=v;rect.dy-=v;}else{if(flush||v>rect.dx)v=rect.dx;while(++i<n){o=row[i];o.x=x;o.y=y;o.dx=v;y+=o.dy=Math.min(rect.y+rect.dy-y,v?round(o.area/v):0);}
o.z=false;o.dy+=rect.y+rect.dy-y;rect.x+=v;rect.dx-=v;}}
function treemap(d){var nodes=stickies||hierarchy(d),root=nodes[0];root.x=0;root.y=0;root.dx=size[0];root.dy=size[1];if(stickies)hierarchy.revalue(root);scale([root],root.dx*root.dy/root.value);(stickies?stickify:squarify)(root);if(sticky)stickies=nodes;return nodes;}
treemap.size=function(x){if(!arguments.length)return size;size=x;return treemap;};treemap.padding=function(x){if(!arguments.length)return padding;function padFunction(node){var p=x.call(treemap,node,node.depth);return p==null?d3_layout_treemapPadNull(node):d3_layout_treemapPad(node,typeof p==="number"?[p,p,p,p]:p);}
function padConstant(node){return d3_layout_treemapPad(node,x);}
var type;pad=(padding=x)==null?d3_layout_treemapPadNull:(type=typeof x)==="function"?padFunction:type==="number"?(x=[x,x,x,x],padConstant):padConstant;return treemap;};treemap.round=function(x){if(!arguments.length)return round!=Number;round=x?Math.round:Number;return treemap;};treemap.sticky=function(x){if(!arguments.length)return sticky;sticky=x;stickies=null;return treemap;};treemap.ratio=function(x){if(!arguments.length)return ratio;ratio=x;return treemap;};treemap.mode=function(x){if(!arguments.length)return mode;mode=x+"";return treemap;};return d3_layout_hierarchyRebind(treemap,hierarchy);};function d3_layout_treemapPadNull(node){return{x:node.x,y:node.y,dx:node.dx,dy:node.dy};}
function d3_layout_treemapPad(node,padding){var x=node.x+padding[3],y=node.y+padding[0],dx=node.dx-padding[1]-padding[3],dy=node.dy-padding[0]-padding[2];if(dx<0){x+=dx/2;dx=0;}
if(dy<0){y+=dy/2;dy=0;}
return{x:x,y:y,dx:dx,dy:dy};}
d3.random={normal:function(µ,σ){var n=arguments.length;if(n<2)σ=1;if(n<1)µ=0;return function(){var x,y,r;do{x=Math.random()*2-1;y=Math.random()*2-1;r=x*x+y*y;}while(!r||r>1);return µ+σ*x*Math.sqrt(-2*Math.log(r)/r);};},logNormal:function(){var random=d3.random.normal.apply(d3,arguments);return function(){return Math.exp(random());};},bates:function(m){var random=d3.random.irwinHall(m);return function(){return random()/m;};},irwinHall:function(m){return function(){for(var s=0,j=0;j<m;j++)s+=Math.random();return s;};}};d3.scale={};function d3_scaleExtent(domain){var start=domain[0],stop=domain[domain.length-1];return start<stop?[start,stop]:[stop,start];}
function d3_scaleRange(scale){return scale.rangeExtent?scale.rangeExtent():d3_scaleExtent(scale.range());}
function d3_scale_bilinear(domain,range,uninterpolate,interpolate){var u=uninterpolate(domain[0],domain[1]),i=interpolate(range[0],range[1]);return function(x){return i(u(x));};}
function d3_scale_nice(domain,nice){var i0=0,i1=domain.length-1,x0=domain[i0],x1=domain[i1],dx;if(x1<x0){dx=i0,i0=i1,i1=dx;dx=x0,x0=x1,x1=dx;}
domain[i0]=nice.floor(x0);domain[i1]=nice.ceil(x1);return domain;}
function d3_scale_niceStep(step){return step?{floor:function(x){return Math.floor(x/step)*step;},ceil:function(x){return Math.ceil(x/step)*step;}}:d3_scale_niceIdentity;}
var d3_scale_niceIdentity={floor:d3_identity,ceil:d3_identity};function d3_scale_polylinear(domain,range,uninterpolate,interpolate){var u=[],i=[],j=0,k=Math.min(domain.length,range.length)-1;if(domain[k]<domain[0]){domain=domain.slice().reverse();range=range.slice().reverse();}
while(++j<=k){u.push(uninterpolate(domain[j-1],domain[j]));i.push(interpolate(range[j-1],range[j]));}
return function(x){var j=d3.bisect(domain,x,1,k)-1;return i[j](u[j](x));};}
d3.scale.linear=function(){return d3_scale_linear([0,1],[0,1],d3_interpolate,false);};function d3_scale_linear(domain,range,interpolate,clamp){var output,input;function rescale(){var linear=Math.min(domain.length,range.length)>2?d3_scale_polylinear:d3_scale_bilinear,uninterpolate=clamp?d3_uninterpolateClamp:d3_uninterpolateNumber;output=linear(domain,range,uninterpolate,interpolate);input=linear(range,domain,uninterpolate,d3_interpolate);return scale;}
function scale(x){return output(x);}
scale.invert=function(y){return input(y);};scale.domain=function(x){if(!arguments.length)return domain;domain=x.map(Number);return rescale();};scale.range=function(x){if(!arguments.length)return range;range=x;return rescale();};scale.rangeRound=function(x){return scale.range(x).interpolate(d3_interpolateRound);};scale.clamp=function(x){if(!arguments.length)return clamp;clamp=x;return rescale();};scale.interpolate=function(x){if(!arguments.length)return interpolate;interpolate=x;return rescale();};scale.ticks=function(m){return d3_scale_linearTicks(domain,m);};scale.tickFormat=function(m,format){return d3_scale_linearTickFormat(domain,m,format);};scale.nice=function(m){d3_scale_linearNice(domain,m);return rescale();};scale.copy=function(){return d3_scale_linear(domain,range,interpolate,clamp);};return rescale();}
function d3_scale_linearRebind(scale,linear){return d3.rebind(scale,linear,"range","rangeRound","interpolate","clamp");}
function d3_scale_linearNice(domain,m){return d3_scale_nice(domain,d3_scale_niceStep(d3_scale_linearTickRange(domain,m)[2]));}
function d3_scale_linearTickRange(domain,m){if(m==null)m=10;var extent=d3_scaleExtent(domain),span=extent[1]-extent[0],step=Math.pow(10,Math.floor(Math.log(span/m)/Math.LN10)),err=m/span*step;if(err<=.15)step*=10;else if(err<=.35)step*=5;else if(err<=.75)step*=2;extent[0]=Math.ceil(extent[0]/step)*step;extent[1]=Math.floor(extent[1]/step)*step+step*.5;extent[2]=step;return extent;}
function d3_scale_linearTicks(domain,m){return d3.range.apply(d3,d3_scale_linearTickRange(domain,m));}
function d3_scale_linearTickFormat(domain,m,format){var range=d3_scale_linearTickRange(domain,m);if(format){var match=d3_format_re.exec(format);match.shift();if(match[8]==="s"){var prefix=d3.formatPrefix(Math.max(abs(range[0]),abs(range[1])));if(!match[7])match[7]="."+d3_scale_linearPrecision(prefix.scale(range[2]));match[8]="f";format=d3.format(match.join(""));return function(d){return format(prefix.scale(d))+prefix.symbol;};}
if(!match[7])match[7]="."+d3_scale_linearFormatPrecision(match[8],range);format=match.join("");}else{format=",."+d3_scale_linearPrecision(range[2])+"f";}
return d3.format(format);}
var d3_scale_linearFormatSignificant={s:1,g:1,p:1,r:1,e:1};function d3_scale_linearPrecision(value){return-Math.floor(Math.log(value)/Math.LN10+.01);}
function d3_scale_linearFormatPrecision(type,range){var p=d3_scale_linearPrecision(range[2]);return type in d3_scale_linearFormatSignificant?Math.abs(p-d3_scale_linearPrecision(Math.max(abs(range[0]),abs(range[1]))))+ +(type!=="e"):p-(type==="%")*2;}
d3.scale.log=function(){return d3_scale_log(d3.scale.linear().domain([0,1]),10,true,[1,10]);};function d3_scale_log(linear,base,positive,domain){function log(x){return(positive?Math.log(x<0?0:x):-Math.log(x>0?0:-x))/Math.log(base);}
function pow(x){return positive?Math.pow(base,x):-Math.pow(base,-x);}
function scale(x){return linear(log(x));}
scale.invert=function(x){return pow(linear.invert(x));};scale.domain=function(x){if(!arguments.length)return domain;positive=x[0]>=0;linear.domain((domain=x.map(Number)).map(log));return scale;};scale.base=function(_){if(!arguments.length)return base;base=+_;linear.domain(domain.map(log));return scale;};scale.nice=function(){var niced=d3_scale_nice(domain.map(log),positive?Math:d3_scale_logNiceNegative);linear.domain(niced);domain=niced.map(pow);return scale;};scale.ticks=function(){var extent=d3_scaleExtent(domain),ticks=[],u=extent[0],v=extent[1],i=Math.floor(log(u)),j=Math.ceil(log(v)),n=base%1?2:base;if(isFinite(j-i)){if(positive){for(;i<j;i++)for(var k=1;k<n;k++)ticks.push(pow(i)*k);ticks.push(pow(i));}else{ticks.push(pow(i));for(;i++<j;)for(var k=n-1;k>0;k--)ticks.push(pow(i)*k);}
for(i=0;ticks[i]<u;i++){}
for(j=ticks.length;ticks[j-1]>v;j--){}
ticks=ticks.slice(i,j);}
return ticks;};scale.tickFormat=function(n,format){if(!arguments.length)return d3_scale_logFormat;if(arguments.length<2)format=d3_scale_logFormat;else if(typeof format!=="function")format=d3.format(format);var k=Math.max(.1,n/scale.ticks().length),f=positive?(e=1e-12,Math.ceil):(e=-1e-12,Math.floor),e;return function(d){return d/pow(f(log(d)+e))<=k?format(d):"";};};scale.copy=function(){return d3_scale_log(linear.copy(),base,positive,domain);};return d3_scale_linearRebind(scale,linear);}
var d3_scale_logFormat=d3.format(".0e"),d3_scale_logNiceNegative={floor:function(x){return-Math.ceil(-x);},ceil:function(x){return-Math.floor(-x);}};d3.scale.pow=function(){return d3_scale_pow(d3.scale.linear(),1,[0,1]);};function d3_scale_pow(linear,exponent,domain){var powp=d3_scale_powPow(exponent),powb=d3_scale_powPow(1/exponent);function scale(x){return linear(powp(x));}
scale.invert=function(x){return powb(linear.invert(x));};scale.domain=function(x){if(!arguments.length)return domain;linear.domain((domain=x.map(Number)).map(powp));return scale;};scale.ticks=function(m){return d3_scale_linearTicks(domain,m);};scale.tickFormat=function(m,format){return d3_scale_linearTickFormat(domain,m,format);};scale.nice=function(m){return scale.domain(d3_scale_linearNice(domain,m));};scale.exponent=function(x){if(!arguments.length)return exponent;powp=d3_scale_powPow(exponent=x);powb=d3_scale_powPow(1/exponent);linear.domain(domain.map(powp));return scale;};scale.copy=function(){return d3_scale_pow(linear.copy(),exponent,domain);};return d3_scale_linearRebind(scale,linear);}
function d3_scale_powPow(e){return function(x){return x<0?-Math.pow(-x,e):Math.pow(x,e);};}
d3.scale.sqrt=function(){return d3.scale.pow().exponent(.5);};d3.scale.ordinal=function(){return d3_scale_ordinal([],{t:"range",a:[[]]});};function d3_scale_ordinal(domain,ranger){var index,range,rangeBand;function scale(x){return range[((index.get(x)||(ranger.t==="range"?index.set(x,domain.push(x)):NaN))-1)%range.length];}
function steps(start,step){return d3.range(domain.length).map(function(i){return start+step*i;});}
scale.domain=function(x){if(!arguments.length)return domain;domain=[];index=new d3_Map();var i=-1,n=x.length,xi;while(++i<n)if(!index.has(xi=x[i]))index.set(xi,domain.push(xi));return scale[ranger.t].apply(scale,ranger.a);};scale.range=function(x){if(!arguments.length)return range;range=x;rangeBand=0;ranger={t:"range",a:arguments};return scale;};scale.rangePoints=function(x,padding){if(arguments.length<2)padding=0;var start=x[0],stop=x[1],step=domain.length<2?(start=(start+stop)/2,0):(stop-start)/(domain.length-1+padding);range=steps(start+step*padding/2,step);rangeBand=0;ranger={t:"rangePoints",a:arguments};return scale;};scale.rangeRoundPoints=function(x,padding){if(arguments.length<2)padding=0;var start=x[0],stop=x[1],step=domain.length<2?(start=stop=Math.round((start+stop)/2),0):(stop-start)/(domain.length-1+padding)|0;range=steps(start+Math.round(step*padding/2+(stop-start-(domain.length-1+padding)*step)/2),step);rangeBand=0;ranger={t:"rangeRoundPoints",a:arguments};return scale;};scale.rangeBands=function(x,padding,outerPadding){if(arguments.length<2)padding=0;if(arguments.length<3)outerPadding=padding;var reverse=x[1]<x[0],start=x[reverse-0],stop=x[1-reverse],step=(stop-start)/(domain.length-padding+2*outerPadding);range=steps(start+step*outerPadding,step);if(reverse)range.reverse();rangeBand=step*(1-padding);ranger={t:"rangeBands",a:arguments};return scale;};scale.rangeRoundBands=function(x,padding,outerPadding){if(arguments.length<2)padding=0;if(arguments.length<3)outerPadding=padding;var reverse=x[1]<x[0],start=x[reverse-0],stop=x[1-reverse],step=Math.floor((stop-start)/(domain.length-padding+2*outerPadding));range=steps(start+Math.round((stop-start-(domain.length-padding)*step)/2),step);if(reverse)range.reverse();rangeBand=Math.round(step*(1-padding));ranger={t:"rangeRoundBands",a:arguments};return scale;};scale.rangeBand=function(){return rangeBand;};scale.rangeExtent=function(){return d3_scaleExtent(ranger.a[0]);};scale.copy=function(){return d3_scale_ordinal(domain,ranger);};return scale.domain(domain);}
d3.scale.category10=function(){return d3.scale.ordinal().range(d3_category10);};d3.scale.category20=function(){return d3.scale.ordinal().range(d3_category20);};d3.scale.category20b=function(){return d3.scale.ordinal().range(d3_category20b);};d3.scale.category20c=function(){return d3.scale.ordinal().range(d3_category20c);};var d3_category10=[2062260,16744206,2924588,14034728,9725885,9197131,14907330,8355711,12369186,1556175].map(d3_rgbString);var d3_category20=[2062260,11454440,16744206,16759672,2924588,10018698,14034728,16750742,9725885,12955861,9197131,12885140,14907330,16234194,8355711,13092807,12369186,14408589,1556175,10410725].map(d3_rgbString);var d3_category20b=[3750777,5395619,7040719,10264286,6519097,9216594,11915115,13556636,9202993,12426809,15186514,15190932,8666169,11356490,14049643,15177372,8077683,10834324,13528509,14589654].map(d3_rgbString);var d3_category20c=[3244733,7057110,10406625,13032431,15095053,16616764,16625259,16634018,3253076,7652470,10607003,13101504,7695281,10394312,12369372,14342891,6513507,9868950,12434877,14277081].map(d3_rgbString);d3.scale.quantile=function(){return d3_scale_quantile([],[]);};function d3_scale_quantile(domain,range){var thresholds;function rescale(){var k=0,q=range.length;thresholds=[];while(++k<q)thresholds[k-1]=d3.quantile(domain,k/q);return scale;}
function scale(x){if(!isNaN(x=+x))return range[d3.bisect(thresholds,x)];}
scale.domain=function(x){if(!arguments.length)return domain;domain=x.map(d3_number).filter(d3_numeric).sort(d3_ascending);return rescale();};scale.range=function(x){if(!arguments.length)return range;range=x;return rescale();};scale.quantiles=function(){return thresholds;};scale.invertExtent=function(y){y=range.indexOf(y);return y<0?[NaN,NaN]:[y>0?thresholds[y-1]:domain[0],y<thresholds.length?thresholds[y]:domain[domain.length-1]];};scale.copy=function(){return d3_scale_quantile(domain,range);};return rescale();}
d3.scale.quantize=function(){return d3_scale_quantize(0,1,[0,1]);};function d3_scale_quantize(x0,x1,range){var kx,i;function scale(x){return range[Math.max(0,Math.min(i,Math.floor(kx*(x-x0))))];}
function rescale(){kx=range.length/(x1-x0);i=range.length-1;return scale;}
scale.domain=function(x){if(!arguments.length)return[x0,x1];x0=+x[0];x1=+x[x.length-1];return rescale();};scale.range=function(x){if(!arguments.length)return range;range=x;return rescale();};scale.invertExtent=function(y){y=range.indexOf(y);y=y<0?NaN:y/kx+x0;return[y,y+1/kx];};scale.copy=function(){return d3_scale_quantize(x0,x1,range);};return rescale();}
d3.scale.threshold=function(){return d3_scale_threshold([.5],[0,1]);};function d3_scale_threshold(domain,range){function scale(x){if(x<=x)return range[d3.bisect(domain,x)];}
scale.domain=function(_){if(!arguments.length)return domain;domain=_;return scale;};scale.range=function(_){if(!arguments.length)return range;range=_;return scale;};scale.invertExtent=function(y){y=range.indexOf(y);return[domain[y-1],domain[y]];};scale.copy=function(){return d3_scale_threshold(domain,range);};return scale;}
d3.scale.identity=function(){return d3_scale_identity([0,1]);};function d3_scale_identity(domain){function identity(x){return+x;}
identity.invert=identity;identity.domain=identity.range=function(x){if(!arguments.length)return domain;domain=x.map(identity);return identity;};identity.ticks=function(m){return d3_scale_linearTicks(domain,m);};identity.tickFormat=function(m,format){return d3_scale_linearTickFormat(domain,m,format);};identity.copy=function(){return d3_scale_identity(domain);};return identity;}
d3.svg={};function d3_zero(){return 0;}
d3.svg.arc=function(){var innerRadius=d3_svg_arcInnerRadius,outerRadius=d3_svg_arcOuterRadius,cornerRadius=d3_zero,padRadius=d3_svg_arcAuto,startAngle=d3_svg_arcStartAngle,endAngle=d3_svg_arcEndAngle,padAngle=d3_svg_arcPadAngle;function arc(){var r0=Math.max(0,+innerRadius.apply(this,arguments)),r1=Math.max(0,+outerRadius.apply(this,arguments)),a0=startAngle.apply(this,arguments)-halfπ,a1=endAngle.apply(this,arguments)-halfπ,da=Math.abs(a1-a0),cw=a0>a1?0:1;if(r1<r0)rc=r1,r1=r0,r0=rc;if(da>=τε)return circleSegment(r1,cw)+(r0?circleSegment(r0,1-cw):"")+"Z";var rc,cr,rp,ap,p0=0,p1=0,x0,y0,x1,y1,x2,y2,x3,y3,path=[];if(ap=(+padAngle.apply(this,arguments)||0)/2){rp=padRadius===d3_svg_arcAuto?Math.sqrt(r0*r0+r1*r1):+padRadius.apply(this,arguments);if(!cw)p1*=-1;if(r1)p1=d3_asin(rp/r1*Math.sin(ap));if(r0)p0=d3_asin(rp/r0*Math.sin(ap));}
if(r1){x0=r1*Math.cos(a0+p1);y0=r1*Math.sin(a0+p1);x1=r1*Math.cos(a1-p1);y1=r1*Math.sin(a1-p1);var l1=Math.abs(a1-a0-2*p1)<=π?0:1;if(p1&&d3_svg_arcSweep(x0,y0,x1,y1)===cw^l1){var h1=(a0+a1)/2;x0=r1*Math.cos(h1);y0=r1*Math.sin(h1);x1=y1=null;}}else{x0=y0=0;}
if(r0){x2=r0*Math.cos(a1-p0);y2=r0*Math.sin(a1-p0);x3=r0*Math.cos(a0+p0);y3=r0*Math.sin(a0+p0);var l0=Math.abs(a0-a1+2*p0)<=π?0:1;if(p0&&d3_svg_arcSweep(x2,y2,x3,y3)===1-cw^l0){var h0=(a0+a1)/2;x2=r0*Math.cos(h0);y2=r0*Math.sin(h0);x3=y3=null;}}else{x2=y2=0;}
if((rc=Math.min(Math.abs(r1-r0)/2,+cornerRadius.apply(this,arguments)))>.001){cr=r0<r1^cw?0:1;var oc=x3==null?[x2,y2]:x1==null?[x0,y0]:d3_geom_polygonIntersect([x0,y0],[x3,y3],[x1,y1],[x2,y2]),ax=x0-oc[0],ay=y0-oc[1],bx=x1-oc[0],by=y1-oc[1],kc=1/Math.sin(Math.acos((ax*bx+ay*by)/(Math.sqrt(ax*ax+ay*ay)*Math.sqrt(bx*bx+by*by)))/2),lc=Math.sqrt(oc[0]*oc[0]+oc[1]*oc[1]);if(x1!=null){var rc1=Math.min(rc,(r1-lc)/(kc+1)),t30=d3_svg_arcCornerTangents(x3==null?[x2,y2]:[x3,y3],[x0,y0],r1,rc1,cw),t12=d3_svg_arcCornerTangents([x1,y1],[x2,y2],r1,rc1,cw);if(rc===rc1){path.push("M",t30[0],"A",rc1,",",rc1," 0 0,",cr," ",t30[1],"A",r1,",",r1," 0 ",1-cw^d3_svg_arcSweep(t30[1][0],t30[1][1],t12[1][0],t12[1][1]),",",cw," ",t12[1],"A",rc1,",",rc1," 0 0,",cr," ",t12[0]);}else{path.push("M",t30[0],"A",rc1,",",rc1," 0 1,",cr," ",t12[0]);}}else{path.push("M",x0,",",y0);}
if(x3!=null){var rc0=Math.min(rc,(r0-lc)/(kc-1)),t03=d3_svg_arcCornerTangents([x0,y0],[x3,y3],r0,-rc0,cw),t21=d3_svg_arcCornerTangents([x2,y2],x1==null?[x0,y0]:[x1,y1],r0,-rc0,cw);if(rc===rc0){path.push("L",t21[0],"A",rc0,",",rc0," 0 0,",cr," ",t21[1],"A",r0,",",r0," 0 ",cw^d3_svg_arcSweep(t21[1][0],t21[1][1],t03[1][0],t03[1][1]),",",1-cw," ",t03[1],"A",rc0,",",rc0," 0 0,",cr," ",t03[0]);}else{path.push("L",t21[0],"A",rc0,",",rc0," 0 0,",cr," ",t03[0]);}}else{path.push("L",x2,",",y2);}}else{path.push("M",x0,",",y0);if(x1!=null)path.push("A",r1,",",r1," 0 ",l1,",",cw," ",x1,",",y1);path.push("L",x2,",",y2);if(x3!=null)path.push("A",r0,",",r0," 0 ",l0,",",1-cw," ",x3,",",y3);}
path.push("Z");return path.join("");}
function circleSegment(r1,cw){return"M0,"+r1+"A"+r1+","+r1+" 0 1,"+cw+" 0,"+-r1+"A"+r1+","+r1+" 0 1,"+cw+" 0,"+r1;}
arc.innerRadius=function(v){if(!arguments.length)return innerRadius;innerRadius=d3_functor(v);return arc;};arc.outerRadius=function(v){if(!arguments.length)return outerRadius;outerRadius=d3_functor(v);return arc;};arc.cornerRadius=function(v){if(!arguments.length)return cornerRadius;cornerRadius=d3_functor(v);return arc;};arc.padRadius=function(v){if(!arguments.length)return padRadius;padRadius=v==d3_svg_arcAuto?d3_svg_arcAuto:d3_functor(v);return arc;};arc.startAngle=function(v){if(!arguments.length)return startAngle;startAngle=d3_functor(v);return arc;};arc.endAngle=function(v){if(!arguments.length)return endAngle;endAngle=d3_functor(v);return arc;};arc.padAngle=function(v){if(!arguments.length)return padAngle;padAngle=d3_functor(v);return arc;};arc.centroid=function(){var r=(+innerRadius.apply(this,arguments)+ +outerRadius.apply(this,arguments))/2,a=(+startAngle.apply(this,arguments)+ +endAngle.apply(this,arguments))/2-halfπ;return[Math.cos(a)*r,Math.sin(a)*r];};return arc;};var d3_svg_arcAuto="auto";function d3_svg_arcInnerRadius(d){return d.innerRadius;}
function d3_svg_arcOuterRadius(d){return d.outerRadius;}
function d3_svg_arcStartAngle(d){return d.startAngle;}
function d3_svg_arcEndAngle(d){return d.endAngle;}
function d3_svg_arcPadAngle(d){return d&&d.padAngle;}
function d3_svg_arcSweep(x0,y0,x1,y1){return(x0-x1)*y0-(y0-y1)*x0>0?0:1;}
function d3_svg_arcCornerTangents(p0,p1,r1,rc,cw){var x01=p0[0]-p1[0],y01=p0[1]-p1[1],lo=(cw?rc:-rc)/Math.sqrt(x01*x01+y01*y01),ox=lo*y01,oy=-lo*x01,x1=p0[0]+ox,y1=p0[1]+oy,x2=p1[0]+ox,y2=p1[1]+oy,x3=(x1+x2)/2,y3=(y1+y2)/2,dx=x2-x1,dy=y2-y1,d2=dx*dx+dy*dy,r=r1-rc,D=x1*y2-x2*y1,d=(dy<0?-1:1)*Math.sqrt(r*r*d2-D*D),cx0=(D*dy-dx*d)/d2,cy0=(-D*dx-dy*d)/d2,cx1=(D*dy+dx*d)/d2,cy1=(-D*dx+dy*d)/d2,dx0=cx0-x3,dy0=cy0-y3,dx1=cx1-x3,dy1=cy1-y3;if(dx0*dx0+dy0*dy0>dx1*dx1+dy1*dy1)cx0=cx1,cy0=cy1;return[[cx0-ox,cy0-oy],[cx0*r1/r,cy0*r1/r]];}
function d3_svg_line(projection){var x=d3_geom_pointX,y=d3_geom_pointY,defined=d3_true,interpolate=d3_svg_lineLinear,interpolateKey=interpolate.key,tension=.7;function line(data){var segments=[],points=[],i=-1,n=data.length,d,fx=d3_functor(x),fy=d3_functor(y);function segment(){segments.push("M",interpolate(projection(points),tension));}
while(++i<n){if(defined.call(this,d=data[i],i)){points.push([+fx.call(this,d,i),+fy.call(this,d,i)]);}else if(points.length){segment();points=[];}}
if(points.length)segment();return segments.length?segments.join(""):null;}
line.x=function(_){if(!arguments.length)return x;x=_;return line;};line.y=function(_){if(!arguments.length)return y;y=_;return line;};line.defined=function(_){if(!arguments.length)return defined;defined=_;return line;};line.interpolate=function(_){if(!arguments.length)return interpolateKey;if(typeof _==="function")interpolateKey=interpolate=_;else interpolateKey=(interpolate=d3_svg_lineInterpolators.get(_)||d3_svg_lineLinear).key;return line;};line.tension=function(_){if(!arguments.length)return tension;tension=_;return line;};return line;}
d3.svg.line=function(){return d3_svg_line(d3_identity);};var d3_svg_lineInterpolators=d3.map({linear:d3_svg_lineLinear,"linear-closed":d3_svg_lineLinearClosed,step:d3_svg_lineStep,"step-before":d3_svg_lineStepBefore,"step-after":d3_svg_lineStepAfter,basis:d3_svg_lineBasis,"basis-open":d3_svg_lineBasisOpen,"basis-closed":d3_svg_lineBasisClosed,bundle:d3_svg_lineBundle,cardinal:d3_svg_lineCardinal,"cardinal-open":d3_svg_lineCardinalOpen,"cardinal-closed":d3_svg_lineCardinalClosed,monotone:d3_svg_lineMonotone});d3_svg_lineInterpolators.forEach(function(key,value){value.key=key;value.closed=/-closed$/.test(key);});function d3_svg_lineLinear(points){return points.join("L");}
function d3_svg_lineLinearClosed(points){return d3_svg_lineLinear(points)+"Z";}
function d3_svg_lineStep(points){var i=0,n=points.length,p=points[0],path=[p[0],",",p[1]];while(++i<n)path.push("H",(p[0]+(p=points[i])[0])/2,"V",p[1]);if(n>1)path.push("H",p[0]);return path.join("");}
function d3_svg_lineStepBefore(points){var i=0,n=points.length,p=points[0],path=[p[0],",",p[1]];while(++i<n)path.push("V",(p=points[i])[1],"H",p[0]);return path.join("");}
function d3_svg_lineStepAfter(points){var i=0,n=points.length,p=points[0],path=[p[0],",",p[1]];while(++i<n)path.push("H",(p=points[i])[0],"V",p[1]);return path.join("");}
function d3_svg_lineCardinalOpen(points,tension){return points.length<4?d3_svg_lineLinear(points):points[1]+d3_svg_lineHermite(points.slice(1,-1),d3_svg_lineCardinalTangents(points,tension));}
function d3_svg_lineCardinalClosed(points,tension){return points.length<3?d3_svg_lineLinear(points):points[0]+d3_svg_lineHermite((points.push(points[0]),points),d3_svg_lineCardinalTangents([points[points.length-2]].concat(points,[points[1]]),tension));}
function d3_svg_lineCardinal(points,tension){return points.length<3?d3_svg_lineLinear(points):points[0]+d3_svg_lineHermite(points,d3_svg_lineCardinalTangents(points,tension));}
function d3_svg_lineHermite(points,tangents){if(tangents.length<1||points.length!=tangents.length&&points.length!=tangents.length+2){return d3_svg_lineLinear(points);}
var quad=points.length!=tangents.length,path="",p0=points[0],p=points[1],t0=tangents[0],t=t0,pi=1;if(quad){path+="Q"+(p[0]-t0[0]*2/3)+","+(p[1]-t0[1]*2/3)+","+p[0]+","+p[1];p0=points[1];pi=2;}
if(tangents.length>1){t=tangents[1];p=points[pi];pi++;path+="C"+(p0[0]+t0[0])+","+(p0[1]+t0[1])+","+(p[0]-t[0])+","+(p[1]-t[1])+","+p[0]+","+p[1];for(var i=2;i<tangents.length;i++,pi++){p=points[pi];t=tangents[i];path+="S"+(p[0]-t[0])+","+(p[1]-t[1])+","+p[0]+","+p[1];}}
if(quad){var lp=points[pi];path+="Q"+(p[0]+t[0]*2/3)+","+(p[1]+t[1]*2/3)+","+lp[0]+","+lp[1];}
return path;}
function d3_svg_lineCardinalTangents(points,tension){var tangents=[],a=(1-tension)/2,p0,p1=points[0],p2=points[1],i=1,n=points.length;while(++i<n){p0=p1;p1=p2;p2=points[i];tangents.push([a*(p2[0]-p0[0]),a*(p2[1]-p0[1])]);}
return tangents;}
function d3_svg_lineBasis(points){if(points.length<3)return d3_svg_lineLinear(points);var i=1,n=points.length,pi=points[0],x0=pi[0],y0=pi[1],px=[x0,x0,x0,(pi=points[1])[0]],py=[y0,y0,y0,pi[1]],path=[x0,",",y0,"L",d3_svg_lineDot4(d3_svg_lineBasisBezier3,px),",",d3_svg_lineDot4(d3_svg_lineBasisBezier3,py)];points.push(points[n-1]);while(++i<=n){pi=points[i];px.shift();px.push(pi[0]);py.shift();py.push(pi[1]);d3_svg_lineBasisBezier(path,px,py);}
points.pop();path.push("L",pi);return path.join("");}
function d3_svg_lineBasisOpen(points){if(points.length<4)return d3_svg_lineLinear(points);var path=[],i=-1,n=points.length,pi,px=[0],py=[0];while(++i<3){pi=points[i];px.push(pi[0]);py.push(pi[1]);}
path.push(d3_svg_lineDot4(d3_svg_lineBasisBezier3,px)+","+d3_svg_lineDot4(d3_svg_lineBasisBezier3,py));--i;while(++i<n){pi=points[i];px.shift();px.push(pi[0]);py.shift();py.push(pi[1]);d3_svg_lineBasisBezier(path,px,py);}
return path.join("");}
function d3_svg_lineBasisClosed(points){var path,i=-1,n=points.length,m=n+4,pi,px=[],py=[];while(++i<4){pi=points[i%n];px.push(pi[0]);py.push(pi[1]);}
path=[d3_svg_lineDot4(d3_svg_lineBasisBezier3,px),",",d3_svg_lineDot4(d3_svg_lineBasisBezier3,py)];--i;while(++i<m){pi=points[i%n];px.shift();px.push(pi[0]);py.shift();py.push(pi[1]);d3_svg_lineBasisBezier(path,px,py);}
return path.join("");}
function d3_svg_lineBundle(points,tension){var n=points.length-1;if(n){var x0=points[0][0],y0=points[0][1],dx=points[n][0]-x0,dy=points[n][1]-y0,i=-1,p,t;while(++i<=n){p=points[i];t=i/n;p[0]=tension*p[0]+(1-tension)*(x0+t*dx);p[1]=tension*p[1]+(1-tension)*(y0+t*dy);}}
return d3_svg_lineBasis(points);}
function d3_svg_lineDot4(a,b){return a[0]*b[0]+a[1]*b[1]+a[2]*b[2]+a[3]*b[3];}
var d3_svg_lineBasisBezier1=[0,2/3,1/3,0],d3_svg_lineBasisBezier2=[0,1/3,2/3,0],d3_svg_lineBasisBezier3=[0,1/6,2/3,1/6];function d3_svg_lineBasisBezier(path,x,y){path.push("C",d3_svg_lineDot4(d3_svg_lineBasisBezier1,x),",",d3_svg_lineDot4(d3_svg_lineBasisBezier1,y),",",d3_svg_lineDot4(d3_svg_lineBasisBezier2,x),",",d3_svg_lineDot4(d3_svg_lineBasisBezier2,y),",",d3_svg_lineDot4(d3_svg_lineBasisBezier3,x),",",d3_svg_lineDot4(d3_svg_lineBasisBezier3,y));}
function d3_svg_lineSlope(p0,p1){return(p1[1]-p0[1])/(p1[0]-p0[0]);}
function d3_svg_lineFiniteDifferences(points){var i=0,j=points.length-1,m=[],p0=points[0],p1=points[1],d=m[0]=d3_svg_lineSlope(p0,p1);while(++i<j){m[i]=(d+(d=d3_svg_lineSlope(p0=p1,p1=points[i+1])))/2;}
m[i]=d;return m;}
function d3_svg_lineMonotoneTangents(points){var tangents=[],d,a,b,s,m=d3_svg_lineFiniteDifferences(points),i=-1,j=points.length-1;while(++i<j){d=d3_svg_lineSlope(points[i],points[i+1]);if(abs(d)<ε){m[i]=m[i+1]=0;}else{a=m[i]/d;b=m[i+1]/d;s=a*a+b*b;if(s>9){s=d*3/Math.sqrt(s);m[i]=s*a;m[i+1]=s*b;}}}
i=-1;while(++i<=j){s=(points[Math.min(j,i+1)][0]-points[Math.max(0,i-1)][0])/(6*(1+m[i]*m[i]));tangents.push([s||0,m[i]*s||0]);}
return tangents;}
function d3_svg_lineMonotone(points){return points.length<3?d3_svg_lineLinear(points):points[0]+d3_svg_lineHermite(points,d3_svg_lineMonotoneTangents(points));}
d3.svg.line.radial=function(){var line=d3_svg_line(d3_svg_lineRadial);line.radius=line.x,delete line.x;line.angle=line.y,delete line.y;return line;};function d3_svg_lineRadial(points){var point,i=-1,n=points.length,r,a;while(++i<n){point=points[i];r=point[0];a=point[1]-halfπ;point[0]=r*Math.cos(a);point[1]=r*Math.sin(a);}
return points;}
function d3_svg_area(projection){var x0=d3_geom_pointX,x1=d3_geom_pointX,y0=0,y1=d3_geom_pointY,defined=d3_true,interpolate=d3_svg_lineLinear,interpolateKey=interpolate.key,interpolateReverse=interpolate,L="L",tension=.7;function area(data){var segments=[],points0=[],points1=[],i=-1,n=data.length,d,fx0=d3_functor(x0),fy0=d3_functor(y0),fx1=x0===x1?function(){return x;}:d3_functor(x1),fy1=y0===y1?function(){return y;}:d3_functor(y1),x,y;function segment(){segments.push("M",interpolate(projection(points1),tension),L,interpolateReverse(projection(points0.reverse()),tension),"Z");}
while(++i<n){if(defined.call(this,d=data[i],i)){points0.push([x=+fx0.call(this,d,i),y=+fy0.call(this,d,i)]);points1.push([+fx1.call(this,d,i),+fy1.call(this,d,i)]);}else if(points0.length){segment();points0=[];points1=[];}}
if(points0.length)segment();return segments.length?segments.join(""):null;}
area.x=function(_){if(!arguments.length)return x1;x0=x1=_;return area;};area.x0=function(_){if(!arguments.length)return x0;x0=_;return area;};area.x1=function(_){if(!arguments.length)return x1;x1=_;return area;};area.y=function(_){if(!arguments.length)return y1;y0=y1=_;return area;};area.y0=function(_){if(!arguments.length)return y0;y0=_;return area;};area.y1=function(_){if(!arguments.length)return y1;y1=_;return area;};area.defined=function(_){if(!arguments.length)return defined;defined=_;return area;};area.interpolate=function(_){if(!arguments.length)return interpolateKey;if(typeof _==="function")interpolateKey=interpolate=_;else interpolateKey=(interpolate=d3_svg_lineInterpolators.get(_)||d3_svg_lineLinear).key;interpolateReverse=interpolate.reverse||interpolate;L=interpolate.closed?"M":"L";return area;};area.tension=function(_){if(!arguments.length)return tension;tension=_;return area;};return area;}
d3_svg_lineStepBefore.reverse=d3_svg_lineStepAfter;d3_svg_lineStepAfter.reverse=d3_svg_lineStepBefore;d3.svg.area=function(){return d3_svg_area(d3_identity);};d3.svg.area.radial=function(){var area=d3_svg_area(d3_svg_lineRadial);area.radius=area.x,delete area.x;area.innerRadius=area.x0,delete area.x0;area.outerRadius=area.x1,delete area.x1;area.angle=area.y,delete area.y;area.startAngle=area.y0,delete area.y0;area.endAngle=area.y1,delete area.y1;return area;};d3.svg.chord=function(){var source=d3_source,target=d3_target,radius=d3_svg_chordRadius,startAngle=d3_svg_arcStartAngle,endAngle=d3_svg_arcEndAngle;function chord(d,i){var s=subgroup(this,source,d,i),t=subgroup(this,target,d,i);return"M"+s.p0+arc(s.r,s.p1,s.a1-s.a0)+(equals(s,t)?curve(s.r,s.p1,s.r,s.p0):curve(s.r,s.p1,t.r,t.p0)+arc(t.r,t.p1,t.a1-t.a0)+curve(t.r,t.p1,s.r,s.p0))+"Z";}
function subgroup(self,f,d,i){var subgroup=f.call(self,d,i),r=radius.call(self,subgroup,i),a0=startAngle.call(self,subgroup,i)-halfπ,a1=endAngle.call(self,subgroup,i)-halfπ;return{r:r,a0:a0,a1:a1,p0:[r*Math.cos(a0),r*Math.sin(a0)],p1:[r*Math.cos(a1),r*Math.sin(a1)]};}
function equals(a,b){return a.a0==b.a0&&a.a1==b.a1;}
function arc(r,p,a){return"A"+r+","+r+" 0 "+ +(a>π)+",1 "+p;}
function curve(r0,p0,r1,p1){return"Q 0,0 "+p1;}
chord.radius=function(v){if(!arguments.length)return radius;radius=d3_functor(v);return chord;};chord.source=function(v){if(!arguments.length)return source;source=d3_functor(v);return chord;};chord.target=function(v){if(!arguments.length)return target;target=d3_functor(v);return chord;};chord.startAngle=function(v){if(!arguments.length)return startAngle;startAngle=d3_functor(v);return chord;};chord.endAngle=function(v){if(!arguments.length)return endAngle;endAngle=d3_functor(v);return chord;};return chord;};function d3_svg_chordRadius(d){return d.radius;}
d3.svg.diagonal=function(){var source=d3_source,target=d3_target,projection=d3_svg_diagonalProjection;function diagonal(d,i){var p0=source.call(this,d,i),p3=target.call(this,d,i),m=(p0.y+p3.y)/2,p=[p0,{x:p0.x,y:m},{x:p3.x,y:m},p3];p=p.map(projection);return"M"+p[0]+"C"+p[1]+" "+p[2]+" "+p[3];}
diagonal.source=function(x){if(!arguments.length)return source;source=d3_functor(x);return diagonal;};diagonal.target=function(x){if(!arguments.length)return target;target=d3_functor(x);return diagonal;};diagonal.projection=function(x){if(!arguments.length)return projection;projection=x;return diagonal;};return diagonal;};function d3_svg_diagonalProjection(d){return[d.x,d.y];}
d3.svg.diagonal.radial=function(){var diagonal=d3.svg.diagonal(),projection=d3_svg_diagonalProjection,projection_=diagonal.projection;diagonal.projection=function(x){return arguments.length?projection_(d3_svg_diagonalRadialProjection(projection=x)):projection;};return diagonal;};function d3_svg_diagonalRadialProjection(projection){return function(){var d=projection.apply(this,arguments),r=d[0],a=d[1]-halfπ;return[r*Math.cos(a),r*Math.sin(a)];};}
d3.svg.symbol=function(){var type=d3_svg_symbolType,size=d3_svg_symbolSize;function symbol(d,i){return(d3_svg_symbols.get(type.call(this,d,i))||d3_svg_symbolCircle)(size.call(this,d,i));}
symbol.type=function(x){if(!arguments.length)return type;type=d3_functor(x);return symbol;};symbol.size=function(x){if(!arguments.length)return size;size=d3_functor(x);return symbol;};return symbol;};function d3_svg_symbolSize(){return 64;}
function d3_svg_symbolType(){return"circle";}
function d3_svg_symbolCircle(size){var r=Math.sqrt(size/π);return"M0,"+r+"A"+r+","+r+" 0 1,1 0,"+-r+"A"+r+","+r+" 0 1,1 0,"+r+"Z";}
var d3_svg_symbols=d3.map({circle:d3_svg_symbolCircle,cross:function(size){var r=Math.sqrt(size/5)/2;return"M"+-3*r+","+-r+"H"+-r+"V"+-3*r+"H"+r+"V"+-r+"H"+3*r+"V"+r+"H"+r+"V"+3*r+"H"+-r+"V"+r+"H"+-3*r+"Z";},diamond:function(size){var ry=Math.sqrt(size/(2*d3_svg_symbolTan30)),rx=ry*d3_svg_symbolTan30;return"M0,"+-ry+"L"+rx+",0"+" 0,"+ry+" "+-rx+",0"+"Z";},square:function(size){var r=Math.sqrt(size)/2;return"M"+-r+","+-r+"L"+r+","+-r+" "+r+","+r+" "+-r+","+r+"Z";},"triangle-down":function(size){var rx=Math.sqrt(size/d3_svg_symbolSqrt3),ry=rx*d3_svg_symbolSqrt3/2;return"M0,"+ry+"L"+rx+","+-ry+" "+-rx+","+-ry+"Z";},"triangle-up":function(size){var rx=Math.sqrt(size/d3_svg_symbolSqrt3),ry=rx*d3_svg_symbolSqrt3/2;return"M0,"+-ry+"L"+rx+","+ry+" "+-rx+","+ry+"Z";}});d3.svg.symbolTypes=d3_svg_symbols.keys();var d3_svg_symbolSqrt3=Math.sqrt(3),d3_svg_symbolTan30=Math.tan(30*d3_radians);d3_selectionPrototype.transition=function(name){var id=d3_transitionInheritId||++d3_transitionId,ns=d3_transitionNamespace(name),subgroups=[],subgroup,node,transition=d3_transitionInherit||{time:Date.now(),ease:d3_ease_cubicInOut,delay:0,duration:250};for(var j=-1,m=this.length;++j<m;){subgroups.push(subgroup=[]);for(var group=this[j],i=-1,n=group.length;++i<n;){if(node=group[i])d3_transitionNode(node,i,ns,id,transition);subgroup.push(node);}}
return d3_transition(subgroups,ns,id);};d3_selectionPrototype.interrupt=function(name){return this.each(name==null?d3_selection_interrupt:d3_selection_interruptNS(d3_transitionNamespace(name)));};var d3_selection_interrupt=d3_selection_interruptNS(d3_transitionNamespace());function d3_selection_interruptNS(ns){return function(){var lock,active;if((lock=this[ns])&&(active=lock[lock.active])){if(--lock.count)delete lock[lock.active];else delete this[ns];lock.active+=.5;active.event&&active.event.interrupt.call(this,this.__data__,active.index);}};}
function d3_transition(groups,ns,id){d3_subclass(groups,d3_transitionPrototype);groups.namespace=ns;groups.id=id;return groups;}
var d3_transitionPrototype=[],d3_transitionId=0,d3_transitionInheritId,d3_transitionInherit;d3_transitionPrototype.call=d3_selectionPrototype.call;d3_transitionPrototype.empty=d3_selectionPrototype.empty;d3_transitionPrototype.node=d3_selectionPrototype.node;d3_transitionPrototype.size=d3_selectionPrototype.size;d3.transition=function(selection,name){return selection&&selection.transition?d3_transitionInheritId?selection.transition(name):selection:d3.selection().transition(selection);};d3.transition.prototype=d3_transitionPrototype;d3_transitionPrototype.select=function(selector){var id=this.id,ns=this.namespace,subgroups=[],subgroup,subnode,node;selector=d3_selection_selector(selector);for(var j=-1,m=this.length;++j<m;){subgroups.push(subgroup=[]);for(var group=this[j],i=-1,n=group.length;++i<n;){if((node=group[i])&&(subnode=selector.call(node,node.__data__,i,j))){if("__data__"in node)subnode.__data__=node.__data__;d3_transitionNode(subnode,i,ns,id,node[ns][id]);subgroup.push(subnode);}else{subgroup.push(null);}}}
return d3_transition(subgroups,ns,id);};d3_transitionPrototype.selectAll=function(selector){var id=this.id,ns=this.namespace,subgroups=[],subgroup,subnodes,node,subnode,transition;selector=d3_selection_selectorAll(selector);for(var j=-1,m=this.length;++j<m;){for(var group=this[j],i=-1,n=group.length;++i<n;){if(node=group[i]){transition=node[ns][id];subnodes=selector.call(node,node.__data__,i,j);subgroups.push(subgroup=[]);for(var k=-1,o=subnodes.length;++k<o;){if(subnode=subnodes[k])d3_transitionNode(subnode,k,ns,id,transition);subgroup.push(subnode);}}}}
return d3_transition(subgroups,ns,id);};d3_transitionPrototype.filter=function(filter){var subgroups=[],subgroup,group,node;if(typeof filter!=="function")filter=d3_selection_filter(filter);for(var j=0,m=this.length;j<m;j++){subgroups.push(subgroup=[]);for(var group=this[j],i=0,n=group.length;i<n;i++){if((node=group[i])&&filter.call(node,node.__data__,i,j)){subgroup.push(node);}}}
return d3_transition(subgroups,this.namespace,this.id);};d3_transitionPrototype.tween=function(name,tween){var id=this.id,ns=this.namespace;if(arguments.length<2)return this.node()[ns][id].tween.get(name);return d3_selection_each(this,tween==null?function(node){node[ns][id].tween.remove(name);}:function(node){node[ns][id].tween.set(name,tween);});};function d3_transition_tween(groups,name,value,tween){var id=groups.id,ns=groups.namespace;return d3_selection_each(groups,typeof value==="function"?function(node,i,j){node[ns][id].tween.set(name,tween(value.call(node,node.__data__,i,j)));}:(value=tween(value),function(node){node[ns][id].tween.set(name,value);}));}
d3_transitionPrototype.attr=function(nameNS,value){if(arguments.length<2){for(value in nameNS)this.attr(value,nameNS[value]);return this;}
var interpolate=nameNS=="transform"?d3_interpolateTransform:d3_interpolate,name=d3.ns.qualify(nameNS);function attrNull(){this.removeAttribute(name);}
function attrNullNS(){this.removeAttributeNS(name.space,name.local);}
function attrTween(b){return b==null?attrNull:(b+="",function(){var a=this.getAttribute(name),i;return a!==b&&(i=interpolate(a,b),function(t){this.setAttribute(name,i(t));});});}
function attrTweenNS(b){return b==null?attrNullNS:(b+="",function(){var a=this.getAttributeNS(name.space,name.local),i;return a!==b&&(i=interpolate(a,b),function(t){this.setAttributeNS(name.space,name.local,i(t));});});}
return d3_transition_tween(this,"attr."+nameNS,value,name.local?attrTweenNS:attrTween);};d3_transitionPrototype.attrTween=function(nameNS,tween){var name=d3.ns.qualify(nameNS);function attrTween(d,i){var f=tween.call(this,d,i,this.getAttribute(name));return f&&function(t){this.setAttribute(name,f(t));};}
function attrTweenNS(d,i){var f=tween.call(this,d,i,this.getAttributeNS(name.space,name.local));return f&&function(t){this.setAttributeNS(name.space,name.local,f(t));};}
return this.tween("attr."+nameNS,name.local?attrTweenNS:attrTween);};d3_transitionPrototype.style=function(name,value,priority){var n=arguments.length;if(n<3){if(typeof name!=="string"){if(n<2)value="";for(priority in name)this.style(priority,name[priority],value);return this;}
priority="";}
function styleNull(){this.style.removeProperty(name);}
function styleString(b){return b==null?styleNull:(b+="",function(){var a=d3_window(this).getComputedStyle(this,null).getPropertyValue(name),i;return a!==b&&(i=d3_interpolate(a,b),function(t){this.style.setProperty(name,i(t),priority);});});}
return d3_transition_tween(this,"style."+name,value,styleString);};d3_transitionPrototype.styleTween=function(name,tween,priority){if(arguments.length<3)priority="";function styleTween(d,i){var f=tween.call(this,d,i,d3_window(this).getComputedStyle(this,null).getPropertyValue(name));return f&&function(t){this.style.setProperty(name,f(t),priority);};}
return this.tween("style."+name,styleTween);};d3_transitionPrototype.text=function(value){return d3_transition_tween(this,"text",value,d3_transition_text);};function d3_transition_text(b){if(b==null)b="";return function(){this.textContent=b;};}
d3_transitionPrototype.remove=function(){var ns=this.namespace;return this.each("end.transition",function(){var p;if(this[ns].count<2&&(p=this.parentNode))p.removeChild(this);});};d3_transitionPrototype.ease=function(value){var id=this.id,ns=this.namespace;if(arguments.length<1)return this.node()[ns][id].ease;if(typeof value!=="function")value=d3.ease.apply(d3,arguments);return d3_selection_each(this,function(node){node[ns][id].ease=value;});};d3_transitionPrototype.delay=function(value){var id=this.id,ns=this.namespace;if(arguments.length<1)return this.node()[ns][id].delay;return d3_selection_each(this,typeof value==="function"?function(node,i,j){node[ns][id].delay=+value.call(node,node.__data__,i,j);}:(value=+value,function(node){node[ns][id].delay=value;}));};d3_transitionPrototype.duration=function(value){var id=this.id,ns=this.namespace;if(arguments.length<1)return this.node()[ns][id].duration;return d3_selection_each(this,typeof value==="function"?function(node,i,j){node[ns][id].duration=Math.max(1,value.call(node,node.__data__,i,j));}:(value=Math.max(1,value),function(node){node[ns][id].duration=value;}));};d3_transitionPrototype.each=function(type,listener){var id=this.id,ns=this.namespace;if(arguments.length<2){var inherit=d3_transitionInherit,inheritId=d3_transitionInheritId;try{d3_transitionInheritId=id;d3_selection_each(this,function(node,i,j){d3_transitionInherit=node[ns][id];type.call(node,node.__data__,i,j);});}finally{d3_transitionInherit=inherit;d3_transitionInheritId=inheritId;}}else{d3_selection_each(this,function(node){var transition=node[ns][id];(transition.event||(transition.event=d3.dispatch("start","end","interrupt"))).on(type,listener);});}
return this;};d3_transitionPrototype.transition=function(){var id0=this.id,id1=++d3_transitionId,ns=this.namespace,subgroups=[],subgroup,group,node,transition;for(var j=0,m=this.length;j<m;j++){subgroups.push(subgroup=[]);for(var group=this[j],i=0,n=group.length;i<n;i++){if(node=group[i]){transition=node[ns][id0];d3_transitionNode(node,i,ns,id1,{time:transition.time,ease:transition.ease,delay:transition.delay+transition.duration,duration:transition.duration});}
subgroup.push(node);}}
return d3_transition(subgroups,ns,id1);};function d3_transitionNamespace(name){return name==null?"__transition__":"__transition_"+name+"__";}
function d3_transitionNode(node,i,ns,id,inherit){var lock=node[ns]||(node[ns]={active:0,count:0}),transition=lock[id];if(!transition){var time=inherit.time;transition=lock[id]={tween:new d3_Map(),time:time,delay:inherit.delay,duration:inherit.duration,ease:inherit.ease,index:i};inherit=null;++lock.count;d3.timer(function(elapsed){var delay=transition.delay,duration,ease,timer=d3_timer_active,tweened=[];timer.t=delay+time;if(delay<=elapsed)return start(elapsed-delay);timer.c=start;function start(elapsed){if(lock.active>id)return stop();var active=lock[lock.active];if(active){--lock.count;delete lock[lock.active];active.event&&active.event.interrupt.call(node,node.__data__,active.index);}
lock.active=id;transition.event&&transition.event.start.call(node,node.__data__,i);transition.tween.forEach(function(key,value){if(value=value.call(node,node.__data__,i)){tweened.push(value);}});ease=transition.ease;duration=transition.duration;d3.timer(function(){timer.c=tick(elapsed||1)?d3_true:tick;return 1;},0,time);}
function tick(elapsed){if(lock.active!==id)return 1;var t=elapsed/duration,e=ease(t),n=tweened.length;while(n>0){tweened[--n].call(node,e);}
if(t>=1){transition.event&&transition.event.end.call(node,node.__data__,i);return stop();}}
function stop(){if(--lock.count)delete lock[id];else delete node[ns];return 1;}},0,time);}}
d3.svg.axis=function(){var scale=d3.scale.linear(),orient=d3_svg_axisDefaultOrient,innerTickSize=6,outerTickSize=6,tickPadding=3,tickArguments_=[10],tickValues=null,tickFormat_;function axis(g){g.each(function(){var g=d3.select(this);var scale0=this.__chart__||scale,scale1=this.__chart__=scale.copy();var ticks=tickValues==null?scale1.ticks?scale1.ticks.apply(scale1,tickArguments_):scale1.domain():tickValues,tickFormat=tickFormat_==null?scale1.tickFormat?scale1.tickFormat.apply(scale1,tickArguments_):d3_identity:tickFormat_,tick=g.selectAll(".tick").data(ticks,scale1),tickEnter=tick.enter().insert("g",".domain").attr("class","tick").style("opacity",ε),tickExit=d3.transition(tick.exit()).style("opacity",ε).remove(),tickUpdate=d3.transition(tick.order()).style("opacity",1),tickSpacing=Math.max(innerTickSize,0)+tickPadding,tickTransform;var range=d3_scaleRange(scale1),path=g.selectAll(".domain").data([0]),pathUpdate=(path.enter().append("path").attr("class","domain"),d3.transition(path));tickEnter.append("line");tickEnter.append("text");var lineEnter=tickEnter.select("line"),lineUpdate=tickUpdate.select("line"),text=tick.select("text").text(tickFormat),textEnter=tickEnter.select("text"),textUpdate=tickUpdate.select("text"),sign=orient==="top"||orient==="left"?-1:1,x1,x2,y1,y2;if(orient==="bottom"||orient==="top"){tickTransform=d3_svg_axisX,x1="x",y1="y",x2="x2",y2="y2";text.attr("dy",sign<0?"0em":".71em").style("text-anchor","middle");pathUpdate.attr("d","M"+range[0]+","+sign*outerTickSize+"V0H"+range[1]+"V"+sign*outerTickSize);}else{tickTransform=d3_svg_axisY,x1="y",y1="x",x2="y2",y2="x2";text.attr("dy",".32em").style("text-anchor",sign<0?"end":"start");pathUpdate.attr("d","M"+sign*outerTickSize+","+range[0]+"H0V"+range[1]+"H"+sign*outerTickSize);}
lineEnter.attr(y2,sign*innerTickSize);textEnter.attr(y1,sign*tickSpacing);lineUpdate.attr(x2,0).attr(y2,sign*innerTickSize);textUpdate.attr(x1,0).attr(y1,sign*tickSpacing);if(scale1.rangeBand){var x=scale1,dx=x.rangeBand()/2;scale0=scale1=function(d){return x(d)+dx;};}else if(scale0.rangeBand){scale0=scale1;}else{tickExit.call(tickTransform,scale1,scale0);}
tickEnter.call(tickTransform,scale0,scale1);tickUpdate.call(tickTransform,scale1,scale1);});}
axis.scale=function(x){if(!arguments.length)return scale;scale=x;return axis;};axis.orient=function(x){if(!arguments.length)return orient;orient=x in d3_svg_axisOrients?x+"":d3_svg_axisDefaultOrient;return axis;};axis.ticks=function(){if(!arguments.length)return tickArguments_;tickArguments_=arguments;return axis;};axis.tickValues=function(x){if(!arguments.length)return tickValues;tickValues=x;return axis;};axis.tickFormat=function(x){if(!arguments.length)return tickFormat_;tickFormat_=x;return axis;};axis.tickSize=function(x){var n=arguments.length;if(!n)return innerTickSize;innerTickSize=+x;outerTickSize=+arguments[n-1];return axis;};axis.innerTickSize=function(x){if(!arguments.length)return innerTickSize;innerTickSize=+x;return axis;};axis.outerTickSize=function(x){if(!arguments.length)return outerTickSize;outerTickSize=+x;return axis;};axis.tickPadding=function(x){if(!arguments.length)return tickPadding;tickPadding=+x;return axis;};axis.tickSubdivide=function(){return arguments.length&&axis;};return axis;};var d3_svg_axisDefaultOrient="bottom",d3_svg_axisOrients={top:1,right:1,bottom:1,left:1};function d3_svg_axisX(selection,x0,x1){selection.attr("transform",function(d){var v0=x0(d);return"translate("+(isFinite(v0)?v0:x1(d))+",0)";});}
function d3_svg_axisY(selection,y0,y1){selection.attr("transform",function(d){var v0=y0(d);return"translate(0,"+(isFinite(v0)?v0:y1(d))+")";});}
d3.svg.brush=function(){var event=d3_eventDispatch(brush,"brushstart","brush","brushend"),x=null,y=null,xExtent=[0,0],yExtent=[0,0],xExtentDomain,yExtentDomain,xClamp=true,yClamp=true,resizes=d3_svg_brushResizes[0];function brush(g){g.each(function(){var g=d3.select(this).style("pointer-events","all").style("-webkit-tap-highlight-color","rgba(0,0,0,0)").on("mousedown.brush",brushstart).on("touchstart.brush",brushstart);var background=g.selectAll(".background").data([0]);background.enter().append("rect").attr("class","background").style("visibility","hidden").style("cursor","crosshair");g.selectAll(".extent").data([0]).enter().append("rect").attr("class","extent").style("cursor","move");var resize=g.selectAll(".resize").data(resizes,d3_identity);resize.exit().remove();resize.enter().append("g").attr("class",function(d){return"resize "+d;}).style("cursor",function(d){return d3_svg_brushCursor[d];}).append("rect").attr("x",function(d){return/[ew]$/.test(d)?-3:null;}).attr("y",function(d){return/^[ns]/.test(d)?-3:null;}).attr("width",6).attr("height",6).style("visibility","hidden");resize.style("display",brush.empty()?"none":null);var gUpdate=d3.transition(g),backgroundUpdate=d3.transition(background),range;if(x){range=d3_scaleRange(x);backgroundUpdate.attr("x",range[0]).attr("width",range[1]-range[0]);redrawX(gUpdate);}
if(y){range=d3_scaleRange(y);backgroundUpdate.attr("y",range[0]).attr("height",range[1]-range[0]);redrawY(gUpdate);}
redraw(gUpdate);});}
brush.event=function(g){g.each(function(){var event_=event.of(this,arguments),extent1={x:xExtent,y:yExtent,i:xExtentDomain,j:yExtentDomain},extent0=this.__chart__||extent1;this.__chart__=extent1;if(d3_transitionInheritId){d3.select(this).transition().each("start.brush",function(){xExtentDomain=extent0.i;yExtentDomain=extent0.j;xExtent=extent0.x;yExtent=extent0.y;event_({type:"brushstart"});}).tween("brush:brush",function(){var xi=d3_interpolateArray(xExtent,extent1.x),yi=d3_interpolateArray(yExtent,extent1.y);xExtentDomain=yExtentDomain=null;return function(t){xExtent=extent1.x=xi(t);yExtent=extent1.y=yi(t);event_({type:"brush",mode:"resize"});};}).each("end.brush",function(){xExtentDomain=extent1.i;yExtentDomain=extent1.j;event_({type:"brush",mode:"resize"});event_({type:"brushend"});});}else{event_({type:"brushstart"});event_({type:"brush",mode:"resize"});event_({type:"brushend"});}});};function redraw(g){g.selectAll(".resize").attr("transform",function(d){return"translate("+xExtent[+/e$/.test(d)]+","+yExtent[+/^s/.test(d)]+")";});}
function redrawX(g){g.select(".extent").attr("x",xExtent[0]);g.selectAll(".extent,.n>rect,.s>rect").attr("width",xExtent[1]-xExtent[0]);}
function redrawY(g){g.select(".extent").attr("y",yExtent[0]);g.selectAll(".extent,.e>rect,.w>rect").attr("height",yExtent[1]-yExtent[0]);}
function brushstart(){var target=this,eventTarget=d3.select(d3.event.target),event_=event.of(target,arguments),g=d3.select(target),resizing=eventTarget.datum(),resizingX=!/^(n|s)$/.test(resizing)&&x,resizingY=!/^(e|w)$/.test(resizing)&&y,dragging=eventTarget.classed("extent"),dragRestore=d3_event_dragSuppress(target),center,origin=d3.mouse(target),offset;var w=d3.select(d3_window(target)).on("keydown.brush",keydown).on("keyup.brush",keyup);if(d3.event.changedTouches){w.on("touchmove.brush",brushmove).on("touchend.brush",brushend);}else{w.on("mousemove.brush",brushmove).on("mouseup.brush",brushend);}
g.interrupt().selectAll("*").interrupt();if(dragging){origin[0]=xExtent[0]-origin[0];origin[1]=yExtent[0]-origin[1];}else if(resizing){var ex=+/w$/.test(resizing),ey=+/^n/.test(resizing);offset=[xExtent[1-ex]-origin[0],yExtent[1-ey]-origin[1]];origin[0]=xExtent[ex];origin[1]=yExtent[ey];}else if(d3.event.altKey)center=origin.slice();g.style("pointer-events","none").selectAll(".resize").style("display",null);d3.select("body").style("cursor",eventTarget.style("cursor"));event_({type:"brushstart"});brushmove();function keydown(){if(d3.event.keyCode==32){if(!dragging){center=null;origin[0]-=xExtent[1];origin[1]-=yExtent[1];dragging=2;}
d3_eventPreventDefault();}}
function keyup(){if(d3.event.keyCode==32&&dragging==2){origin[0]+=xExtent[1];origin[1]+=yExtent[1];dragging=0;d3_eventPreventDefault();}}
function brushmove(){var point=d3.mouse(target),moved=false;if(offset){point[0]+=offset[0];point[1]+=offset[1];}
if(!dragging){if(d3.event.altKey){if(!center)center=[(xExtent[0]+xExtent[1])/2,(yExtent[0]+yExtent[1])/2];origin[0]=xExtent[+(point[0]<center[0])];origin[1]=yExtent[+(point[1]<center[1])];}else center=null;}
if(resizingX&&move1(point,x,0)){redrawX(g);moved=true;}
if(resizingY&&move1(point,y,1)){redrawY(g);moved=true;}
if(moved){redraw(g);event_({type:"brush",mode:dragging?"move":"resize"});}}
function move1(point,scale,i){var range=d3_scaleRange(scale),r0=range[0],r1=range[1],position=origin[i],extent=i?yExtent:xExtent,size=extent[1]-extent[0],min,max;if(dragging){r0-=position;r1-=size+position;}
min=(i?yClamp:xClamp)?Math.max(r0,Math.min(r1,point[i])):point[i];if(dragging){max=(min+=position)+size;}else{if(center)position=Math.max(r0,Math.min(r1,2*center[i]-min));if(position<min){max=min;min=position;}else{max=position;}}
if(extent[0]!=min||extent[1]!=max){if(i)yExtentDomain=null;else xExtentDomain=null;extent[0]=min;extent[1]=max;return true;}}
function brushend(){brushmove();g.style("pointer-events","all").selectAll(".resize").style("display",brush.empty()?"none":null);d3.select("body").style("cursor",null);w.on("mousemove.brush",null).on("mouseup.brush",null).on("touchmove.brush",null).on("touchend.brush",null).on("keydown.brush",null).on("keyup.brush",null);dragRestore();event_({type:"brushend"});}}
brush.x=function(z){if(!arguments.length)return x;x=z;resizes=d3_svg_brushResizes[!x<<1|!y];return brush;};brush.y=function(z){if(!arguments.length)return y;y=z;resizes=d3_svg_brushResizes[!x<<1|!y];return brush;};brush.clamp=function(z){if(!arguments.length)return x&&y?[xClamp,yClamp]:x?xClamp:y?yClamp:null;if(x&&y)xClamp=!!z[0],yClamp=!!z[1];else if(x)xClamp=!!z;else if(y)yClamp=!!z;return brush;};brush.extent=function(z){var x0,x1,y0,y1,t;if(!arguments.length){if(x){if(xExtentDomain){x0=xExtentDomain[0],x1=xExtentDomain[1];}else{x0=xExtent[0],x1=xExtent[1];if(x.invert)x0=x.invert(x0),x1=x.invert(x1);if(x1<x0)t=x0,x0=x1,x1=t;}}
if(y){if(yExtentDomain){y0=yExtentDomain[0],y1=yExtentDomain[1];}else{y0=yExtent[0],y1=yExtent[1];if(y.invert)y0=y.invert(y0),y1=y.invert(y1);if(y1<y0)t=y0,y0=y1,y1=t;}}
return x&&y?[[x0,y0],[x1,y1]]:x?[x0,x1]:y&&[y0,y1];}
if(x){x0=z[0],x1=z[1];if(y)x0=x0[0],x1=x1[0];xExtentDomain=[x0,x1];if(x.invert)x0=x(x0),x1=x(x1);if(x1<x0)t=x0,x0=x1,x1=t;if(x0!=xExtent[0]||x1!=xExtent[1])xExtent=[x0,x1];}
if(y){y0=z[0],y1=z[1];if(x)y0=y0[1],y1=y1[1];yExtentDomain=[y0,y1];if(y.invert)y0=y(y0),y1=y(y1);if(y1<y0)t=y0,y0=y1,y1=t;if(y0!=yExtent[0]||y1!=yExtent[1])yExtent=[y0,y1];}
return brush;};brush.clear=function(){if(!brush.empty()){xExtent=[0,0],yExtent=[0,0];xExtentDomain=yExtentDomain=null;}
return brush;};brush.empty=function(){return!!x&&xExtent[0]==xExtent[1]||!!y&&yExtent[0]==yExtent[1];};return d3.rebind(brush,event,"on");};var d3_svg_brushCursor={n:"ns-resize",e:"ew-resize",s:"ns-resize",w:"ew-resize",nw:"nwse-resize",ne:"nesw-resize",se:"nwse-resize",sw:"nesw-resize"};var d3_svg_brushResizes=[["n","e","s","w","nw","ne","se","sw"],["e","w"],["n","s"],[]];var d3_time_format=d3_time.format=d3_locale_enUS.timeFormat;var d3_time_formatUtc=d3_time_format.utc;var d3_time_formatIso=d3_time_formatUtc("%Y-%m-%dT%H:%M:%S.%LZ");d3_time_format.iso=Date.prototype.toISOString&&+new Date("2000-01-01T00:00:00.000Z")?d3_time_formatIsoNative:d3_time_formatIso;function d3_time_formatIsoNative(date){return date.toISOString();}
d3_time_formatIsoNative.parse=function(string){var date=new Date(string);return isNaN(date)?null:date;};d3_time_formatIsoNative.toString=d3_time_formatIso.toString;d3_time.second=d3_time_interval(function(date){return new d3_date(Math.floor(date/1e3)*1e3);},function(date,offset){date.setTime(date.getTime()+Math.floor(offset)*1e3);},function(date){return date.getSeconds();});d3_time.seconds=d3_time.second.range;d3_time.seconds.utc=d3_time.second.utc.range;d3_time.minute=d3_time_interval(function(date){return new d3_date(Math.floor(date/6e4)*6e4);},function(date,offset){date.setTime(date.getTime()+Math.floor(offset)*6e4);},function(date){return date.getMinutes();});d3_time.minutes=d3_time.minute.range;d3_time.minutes.utc=d3_time.minute.utc.range;d3_time.hour=d3_time_interval(function(date){var timezone=date.getTimezoneOffset()/60;return new d3_date((Math.floor(date/36e5-timezone)+timezone)*36e5);},function(date,offset){date.setTime(date.getTime()+Math.floor(offset)*36e5);},function(date){return date.getHours();});d3_time.hours=d3_time.hour.range;d3_time.hours.utc=d3_time.hour.utc.range;d3_time.month=d3_time_interval(function(date){date=d3_time.day(date);date.setDate(1);return date;},function(date,offset){date.setMonth(date.getMonth()+offset);},function(date){return date.getMonth();});d3_time.months=d3_time.month.range;d3_time.months.utc=d3_time.month.utc.range;function d3_time_scale(linear,methods,format){function scale(x){return linear(x);}
scale.invert=function(x){return d3_time_scaleDate(linear.invert(x));};scale.domain=function(x){if(!arguments.length)return linear.domain().map(d3_time_scaleDate);linear.domain(x);return scale;};function tickMethod(extent,count){var span=extent[1]-extent[0],target=span/count,i=d3.bisect(d3_time_scaleSteps,target);return i==d3_time_scaleSteps.length?[methods.year,d3_scale_linearTickRange(extent.map(function(d){return d/31536e6;}),count)[2]]:!i?[d3_time_scaleMilliseconds,d3_scale_linearTickRange(extent,count)[2]]:methods[target/d3_time_scaleSteps[i-1]<d3_time_scaleSteps[i]/target?i-1:i];}
scale.nice=function(interval,skip){var domain=scale.domain(),extent=d3_scaleExtent(domain),method=interval==null?tickMethod(extent,10):typeof interval==="number"&&tickMethod(extent,interval);if(method)interval=method[0],skip=method[1];function skipped(date){return!isNaN(date)&&!interval.range(date,d3_time_scaleDate(+date+1),skip).length;}
return scale.domain(d3_scale_nice(domain,skip>1?{floor:function(date){while(skipped(date=interval.floor(date)))date=d3_time_scaleDate(date-1);return date;},ceil:function(date){while(skipped(date=interval.ceil(date)))date=d3_time_scaleDate(+date+1);return date;}}:interval));};scale.ticks=function(interval,skip){var extent=d3_scaleExtent(scale.domain()),method=interval==null?tickMethod(extent,10):typeof interval==="number"?tickMethod(extent,interval):!interval.range&&[{range:interval},skip];if(method)interval=method[0],skip=method[1];return interval.range(extent[0],d3_time_scaleDate(+extent[1]+1),skip<1?1:skip);};scale.tickFormat=function(){return format;};scale.copy=function(){return d3_time_scale(linear.copy(),methods,format);};return d3_scale_linearRebind(scale,linear);}
function d3_time_scaleDate(t){return new Date(t);}
var d3_time_scaleSteps=[1e3,5e3,15e3,3e4,6e4,3e5,9e5,18e5,36e5,108e5,216e5,432e5,864e5,1728e5,6048e5,2592e6,7776e6,31536e6];var d3_time_scaleLocalMethods=[[d3_time.second,1],[d3_time.second,5],[d3_time.second,15],[d3_time.second,30],[d3_time.minute,1],[d3_time.minute,5],[d3_time.minute,15],[d3_time.minute,30],[d3_time.hour,1],[d3_time.hour,3],[d3_time.hour,6],[d3_time.hour,12],[d3_time.day,1],[d3_time.day,2],[d3_time.week,1],[d3_time.month,1],[d3_time.month,3],[d3_time.year,1]];var d3_time_scaleLocalFormat=d3_time_format.multi([[".%L",function(d){return d.getMilliseconds();}],[":%S",function(d){return d.getSeconds();}],["%I:%M",function(d){return d.getMinutes();}],["%I %p",function(d){return d.getHours();}],["%a %d",function(d){return d.getDay()&&d.getDate()!=1;}],["%b %d",function(d){return d.getDate()!=1;}],["%B",function(d){return d.getMonth();}],["%Y",d3_true]]);var d3_time_scaleMilliseconds={range:function(start,stop,step){return d3.range(Math.ceil(start/step)*step,+stop,step).map(d3_time_scaleDate);},floor:d3_identity,ceil:d3_identity};d3_time_scaleLocalMethods.year=d3_time.year;d3_time.scale=function(){return d3_time_scale(d3.scale.linear(),d3_time_scaleLocalMethods,d3_time_scaleLocalFormat);};var d3_time_scaleUtcMethods=d3_time_scaleLocalMethods.map(function(m){return[m[0].utc,m[1]];});var d3_time_scaleUtcFormat=d3_time_formatUtc.multi([[".%L",function(d){return d.getUTCMilliseconds();}],[":%S",function(d){return d.getUTCSeconds();}],["%I:%M",function(d){return d.getUTCMinutes();}],["%I %p",function(d){return d.getUTCHours();}],["%a %d",function(d){return d.getUTCDay()&&d.getUTCDate()!=1;}],["%b %d",function(d){return d.getUTCDate()!=1;}],["%B",function(d){return d.getUTCMonth();}],["%Y",d3_true]]);d3_time_scaleUtcMethods.year=d3_time.year.utc;d3_time.scale.utc=function(){return d3_time_scale(d3.scale.linear(),d3_time_scaleUtcMethods,d3_time_scaleUtcFormat);};d3.text=d3_xhrType(function(request){return request.responseText;});d3.json=function(url,callback){return d3_xhr(url,"application/json",d3_json,callback);};function d3_json(request){return JSON.parse(request.responseText);}
d3.html=function(url,callback){return d3_xhr(url,"text/html",d3_html,callback);};function d3_html(request){var range=d3_document.createRange();range.selectNode(d3_document.body);return range.createContextualFragment(request.responseText);}
d3.xml=d3_xhrType(function(request){return request.responseXML;});if(typeof define==="function"&&define.amd)define(d3);else if(typeof module==="object"&&module.exports)module.exports=d3;this.d3=d3;}();;

/* /web/static/lib/nvd3/nv.d3.js defined in bundle 'web.assets_frontend' */
(function(){var nv={};nv.dev=false;nv.tooltip=nv.tooltip||{};nv.utils=nv.utils||{};nv.models=nv.models||{};nv.charts={};nv.logs={};nv.dom={};if(typeof(module)!=='undefined'&&typeof(exports)!=='undefined'&&typeof(d3)=='undefined'){d3=require('d3');}
nv.dispatch=d3.dispatch('render_start','render_end');if(!Function.prototype.bind){Function.prototype.bind=function(oThis){if(typeof this!=="function"){throw new TypeError("Function.prototype.bind - what is trying to be bound is not callable");}
var aArgs=Array.prototype.slice.call(arguments,1),fToBind=this,fNOP=function(){},fBound=function(){return fToBind.apply(this instanceof fNOP&&oThis?this:oThis,aArgs.concat(Array.prototype.slice.call(arguments)));};fNOP.prototype=this.prototype;fBound.prototype=new fNOP();return fBound;};}
if(nv.dev){nv.dispatch.on('render_start',function(e){nv.logs.startTime=+new Date();});nv.dispatch.on('render_end',function(e){nv.logs.endTime=+new Date();nv.logs.totalTime=nv.logs.endTime-nv.logs.startTime;nv.log('total',nv.logs.totalTime);});}
nv.log=function(){if(nv.dev&&window.console&&console.log&&console.log.apply)
console.log.apply(console,arguments);else if(nv.dev&&window.console&&typeof console.log=="function"&&Function.prototype.bind){var log=Function.prototype.bind.call(console.log,console);log.apply(console,arguments);}
return arguments[arguments.length-1];};nv.deprecated=function(name,info){if(console&&console.warn){console.warn('nvd3 warning: `'+name+'` has been deprecated. ',info||'');}};nv.render=function render(step){step=step||1;nv.render.active=true;nv.dispatch.render_start();var renderLoop=function(){var chart,graph;for(var i=0;i<step&&(graph=nv.render.queue[i]);i++){chart=graph.generate();if(typeof graph.callback==typeof(Function))graph.callback(chart);}
nv.render.queue.splice(0,i);if(nv.render.queue.length){setTimeout(renderLoop);}
else{nv.dispatch.render_end();nv.render.active=false;}};setTimeout(renderLoop);};nv.render.active=false;nv.render.queue=[];nv.addGraph=function(obj){if(typeof arguments[0]===typeof(Function)){obj={generate:arguments[0],callback:arguments[1]};}
nv.render.queue.push(obj);if(!nv.render.active){nv.render();}};if(typeof(module)!=='undefined'&&typeof(exports)!=='undefined'){module.exports=nv;}
if(typeof(window)!=='undefined'){window.nv=nv;}
nv.dom.write=function(callback){if(window.fastdom!==undefined){return fastdom.write(callback);}
return callback();};nv.dom.read=function(callback){if(window.fastdom!==undefined){return fastdom.read(callback);}
return callback();};nv.interactiveGuideline=function(){"use strict";var margin={left:0,top:0},width=null,height=null,xScale=d3.scale.linear(),dispatch=d3.dispatch('elementMousemove','elementMouseout','elementClick','elementDblclick','elementMouseDown','elementMouseUp'),showGuideLine=true,svgContainer=null,tooltip=nv.models.tooltip(),isMSIE="ActiveXObject"in window;tooltip.duration(0).hideDelay(0).hidden(false);function layer(selection){selection.each(function(data){var container=d3.select(this);var availableWidth=(width||960),availableHeight=(height||400);var wrap=container.selectAll("g.nv-wrap.nv-interactiveLineLayer").data([data]);var wrapEnter=wrap.enter().append("g").attr("class"," nv-wrap nv-interactiveLineLayer");wrapEnter.append("g").attr("class","nv-interactiveGuideLine");if(!svgContainer){return;}
function mouseHandler(){var d3mouse=d3.mouse(this);var mouseX=d3mouse[0];var mouseY=d3mouse[1];var subtractMargin=true;var mouseOutAnyReason=false;if(isMSIE){mouseX=d3.event.offsetX;mouseY=d3.event.offsetY;if(d3.event.target.tagName!=="svg"){subtractMargin=false;}
if(d3.event.target.className.baseVal.match("nv-legend")){mouseOutAnyReason=true;}}
if(subtractMargin){mouseX-=margin.left;mouseY-=margin.top;}
if(d3.event.type==='mouseout'||mouseX<0||mouseY<0||mouseX>availableWidth||mouseY>availableHeight||(d3.event.relatedTarget&&d3.event.relatedTarget.ownerSVGElement===undefined)||mouseOutAnyReason){if(isMSIE){if(d3.event.relatedTarget&&d3.event.relatedTarget.ownerSVGElement===undefined&&(d3.event.relatedTarget.className===undefined||d3.event.relatedTarget.className.match(tooltip.nvPointerEventsClass))){return;}}
dispatch.elementMouseout({mouseX:mouseX,mouseY:mouseY});layer.renderGuideLine(null);tooltip.hidden(true);return;}else{tooltip.hidden(false);}
var scaleIsOrdinal=typeof xScale.rangeBands==='function';var pointXValue=undefined;if(scaleIsOrdinal){var elementIndex=d3.bisect(xScale.range(),mouseX)-1;if(xScale.range()[elementIndex]+xScale.rangeBand()>=mouseX){pointXValue=xScale.domain()[d3.bisect(xScale.range(),mouseX)-1];}
else{dispatch.elementMouseout({mouseX:mouseX,mouseY:mouseY});layer.renderGuideLine(null);tooltip.hidden(true);return;}}
else{pointXValue=xScale.invert(mouseX);}
dispatch.elementMousemove({mouseX:mouseX,mouseY:mouseY,pointXValue:pointXValue});if(d3.event.type==="dblclick"){dispatch.elementDblclick({mouseX:mouseX,mouseY:mouseY,pointXValue:pointXValue});}
if(d3.event.type==='click'){dispatch.elementClick({mouseX:mouseX,mouseY:mouseY,pointXValue:pointXValue});}
if(d3.event.type==='mousedown'){dispatch.elementMouseDown({mouseX:mouseX,mouseY:mouseY,pointXValue:pointXValue});}
if(d3.event.type==='mouseup'){dispatch.elementMouseUp({mouseX:mouseX,mouseY:mouseY,pointXValue:pointXValue});}}
svgContainer.on("touchmove",mouseHandler).on("mousemove",mouseHandler,true).on("mouseout",mouseHandler,true).on("mousedown",mouseHandler,true).on("mouseup",mouseHandler,true).on("dblclick",mouseHandler).on("click",mouseHandler);layer.guideLine=null;layer.renderGuideLine=function(x){if(!showGuideLine)return;if(layer.guideLine&&layer.guideLine.attr("x1")===x)return;nv.dom.write(function(){var line=wrap.select(".nv-interactiveGuideLine").selectAll("line").data((x!=null)?[nv.utils.NaNtoZero(x)]:[],String);line.enter().append("line").attr("class","nv-guideline").attr("x1",function(d){return d;}).attr("x2",function(d){return d;}).attr("y1",availableHeight).attr("y2",0);line.exit().remove();});}});}
layer.dispatch=dispatch;layer.tooltip=tooltip;layer.margin=function(_){if(!arguments.length)return margin;margin.top=typeof _.top!='undefined'?_.top:margin.top;margin.left=typeof _.left!='undefined'?_.left:margin.left;return layer;};layer.width=function(_){if(!arguments.length)return width;width=_;return layer;};layer.height=function(_){if(!arguments.length)return height;height=_;return layer;};layer.xScale=function(_){if(!arguments.length)return xScale;xScale=_;return layer;};layer.showGuideLine=function(_){if(!arguments.length)return showGuideLine;showGuideLine=_;return layer;};layer.svgContainer=function(_){if(!arguments.length)return svgContainer;svgContainer=_;return layer;};return layer;};nv.interactiveBisect=function(values,searchVal,xAccessor){"use strict";if(!(values instanceof Array)){return null;}
var _xAccessor;if(typeof xAccessor!=='function'){_xAccessor=function(d){return d.x;}}else{_xAccessor=xAccessor;}
var _cmp=function(d,v){return _xAccessor(d)-v;};var bisect=d3.bisector(_cmp).left;var index=d3.max([0,bisect(values,searchVal)-1]);var currentValue=_xAccessor(values[index]);if(typeof currentValue==='undefined'){currentValue=index;}
if(currentValue===searchVal){return index;}
var nextIndex=d3.min([index+1,values.length-1]);var nextValue=_xAccessor(values[nextIndex]);if(typeof nextValue==='undefined'){nextValue=nextIndex;}
if(Math.abs(nextValue-searchVal)>=Math.abs(currentValue-searchVal)){return index;}else{return nextIndex}};nv.nearestValueIndex=function(values,searchVal,threshold){"use strict";var yDistMax=Infinity,indexToHighlight=null;values.forEach(function(d,i){var delta=Math.abs(searchVal-d);if(d!=null&&delta<=yDistMax&&delta<threshold){yDistMax=delta;indexToHighlight=i;}});return indexToHighlight;};nv.models.tooltip=function(){"use strict";var id="nvtooltip-"+Math.floor(Math.random()*100000),data=null,gravity='w',distance=25,snapDistance=0,classes=null,chartContainer=null,hidden=true,hideDelay=200,tooltip=null,lastPosition={left:null,top:null},enabled=true,duration=100,headerEnabled=true,nvPointerEventsClass="nv-pointer-events-none";var position=function(){return{left:d3.event!==null?d3.event.clientX:0,top:d3.event!==null?d3.event.clientY:0};};var valueFormatter=function(d,i){return d;};var headerFormatter=function(d){return d;};var keyFormatter=function(d,i){return d;};var contentGenerator=function(d){if(d===null){return'';}
var table=d3.select(document.createElement("table"));if(headerEnabled){var theadEnter=table.selectAll("thead").data([d]).enter().append("thead");theadEnter.append("tr").append("td").attr("colspan",3).append("strong").classed("x-value",true).html(headerFormatter(d.value));}
var tbodyEnter=table.selectAll("tbody").data([d]).enter().append("tbody");var trowEnter=tbodyEnter.selectAll("tr").data(function(p){return p.series}).enter().append("tr").classed("highlight",function(p){return p.highlight});trowEnter.append("td").classed("legend-color-guide",true).append("div").style("background-color",function(p){return p.color});trowEnter.append("td").classed("key",true).classed("total",function(p){return!!p.total}).html(function(p,i){return keyFormatter(p.key,i)});trowEnter.append("td").classed("value",true).html(function(p,i){return valueFormatter(p.value,i)});trowEnter.selectAll("td").each(function(p){if(p.highlight){var opacityScale=d3.scale.linear().domain([0,1]).range(["#fff",p.color]);var opacity=0.6;d3.select(this).style("border-bottom-color",opacityScale(opacity)).style("border-top-color",opacityScale(opacity));}});var html=table.node().outerHTML;if(d.footer!==undefined)
html+="<div class='footer'>"+d.footer+"</div>";return html;};var dataSeriesExists=function(d){if(d&&d.series){if(nv.utils.isArray(d.series)){return true;}
if(nv.utils.isObject(d.series)){d.series=[d.series];return true;}}
return false;};var calcGravityOffset=function(pos){var height=tooltip.node().offsetHeight,width=tooltip.node().offsetWidth,clientWidth=document.documentElement.clientWidth,clientHeight=document.documentElement.clientHeight,left,top,tmp;switch(gravity){case'e':left=-width-distance;top=-(height/2);if(pos.left+left<0)left=distance;if((tmp=pos.top+top)<0)top-=tmp;if((tmp=pos.top+top+height)>clientHeight)top-=tmp-clientHeight;break;case'w':left=distance;top=-(height/2);if(pos.left+left+width>clientWidth)left=-width-distance;if((tmp=pos.top+top)<0)top-=tmp;if((tmp=pos.top+top+height)>clientHeight)top-=tmp-clientHeight;break;case'n':left=-(width/2)-5;top=distance;if(pos.top+top+height>clientHeight)top=-height-distance;if((tmp=pos.left+left)<0)left-=tmp;if((tmp=pos.left+left+width)>clientWidth)left-=tmp-clientWidth;break;case's':left=-(width/2);top=-height-distance;if(pos.top+top<0)top=distance;if((tmp=pos.left+left)<0)left-=tmp;if((tmp=pos.left+left+width)>clientWidth)left-=tmp-clientWidth;break;case'center':left=-(width/2);top=-(height/2);break;default:left=0;top=0;break;}
return{'left':left,'top':top};};var positionTooltip=function(){nv.dom.read(function(){var pos=position(),gravityOffset=calcGravityOffset(pos),left=pos.left+gravityOffset.left,top=pos.top+gravityOffset.top;if(hidden){tooltip.interrupt().transition().delay(hideDelay).duration(0).style('opacity',0);}else{var old_translate='translate('+lastPosition.left+'px, '+lastPosition.top+'px)';var new_translate='translate('+left+'px, '+top+'px)';var translateInterpolator=d3.interpolateString(old_translate,new_translate);var is_hidden=tooltip.style('opacity')<0.1;tooltip.interrupt().transition().duration(is_hidden?0:duration).styleTween('transform',function(d){return translateInterpolator;},'important').styleTween('-webkit-transform',function(d){return translateInterpolator;}).style('-ms-transform',new_translate).style('opacity',1);}
lastPosition.left=left;lastPosition.top=top;});};function initTooltip(){if(!tooltip||!tooltip.node()){var container=chartContainer?chartContainer:document.body;var data=[1];tooltip=d3.select(container).selectAll('.nvtooltip').data(data);tooltip.enter().append('div').attr("class","nvtooltip "+(classes?classes:"xy-tooltip")).attr("id",id).style("top",0).style("left",0).style('opacity',0).style('position','fixed').selectAll("div, table, td, tr").classed(nvPointerEventsClass,true).classed(nvPointerEventsClass,true);tooltip.exit().remove()}}
function nvtooltip(){if(!enabled)return;if(!dataSeriesExists(data))return;nv.dom.write(function(){initTooltip();var newContent=contentGenerator(data);if(newContent){tooltip.node().innerHTML=newContent;}
positionTooltip();});return nvtooltip;}
nvtooltip.nvPointerEventsClass=nvPointerEventsClass;nvtooltip.options=nv.utils.optionsFunc.bind(nvtooltip);nvtooltip._options=Object.create({},{duration:{get:function(){return duration;},set:function(_){duration=_;}},gravity:{get:function(){return gravity;},set:function(_){gravity=_;}},distance:{get:function(){return distance;},set:function(_){distance=_;}},snapDistance:{get:function(){return snapDistance;},set:function(_){snapDistance=_;}},classes:{get:function(){return classes;},set:function(_){classes=_;}},chartContainer:{get:function(){return chartContainer;},set:function(_){chartContainer=_;}},enabled:{get:function(){return enabled;},set:function(_){enabled=_;}},hideDelay:{get:function(){return hideDelay;},set:function(_){hideDelay=_;}},contentGenerator:{get:function(){return contentGenerator;},set:function(_){contentGenerator=_;}},valueFormatter:{get:function(){return valueFormatter;},set:function(_){valueFormatter=_;}},headerFormatter:{get:function(){return headerFormatter;},set:function(_){headerFormatter=_;}},keyFormatter:{get:function(){return keyFormatter;},set:function(_){keyFormatter=_;}},headerEnabled:{get:function(){return headerEnabled;},set:function(_){headerEnabled=_;}},position:{get:function(){return position;},set:function(_){position=_;}},fixedTop:{get:function(){return null;},set:function(_){nv.deprecated('fixedTop','feature removed after 1.8.1');}},offset:{get:function(){return{left:0,top:0};},set:function(_){nv.deprecated('offset','use chart.tooltip.distance() instead');}},hidden:{get:function(){return hidden;},set:function(_){if(hidden!=_){hidden=!!_;nvtooltip();}}},data:{get:function(){return data;},set:function(_){if(_.point){_.value=_.point.x;_.series=_.series||{};_.series.value=_.point.y;_.series.color=_.point.color||_.series.color;}
data=_;}},node:{get:function(){return tooltip.node();},set:function(_){}},id:{get:function(){return id;},set:function(_){}}});nv.utils.initOptions(nvtooltip);return nvtooltip;};nv.utils.windowSize=function(){var size={width:640,height:480};if(window.innerWidth&&window.innerHeight){size.width=window.innerWidth;size.height=window.innerHeight;return(size);}
if(document.compatMode=='CSS1Compat'&&document.documentElement&&document.documentElement.offsetWidth){size.width=document.documentElement.offsetWidth;size.height=document.documentElement.offsetHeight;return(size);}
if(document.body&&document.body.offsetWidth){size.width=document.body.offsetWidth;size.height=document.body.offsetHeight;return(size);}
return(size);};nv.utils.isArray=Array.isArray;nv.utils.isObject=function(a){return a!==null&&typeof a==='object';};nv.utils.isFunction=function(a){return typeof a==='function';};nv.utils.isDate=function(a){return toString.call(a)==='[object Date]';};nv.utils.isNumber=function(a){return!isNaN(a)&&typeof a==='number';};nv.utils.windowResize=function(handler){if(window.addEventListener){window.addEventListener('resize',handler);}else{nv.log("ERROR: Failed to bind to window.resize with: ",handler);}
return{callback:handler,clear:function(){window.removeEventListener('resize',handler);}}};nv.utils.getColor=function(color){if(color===undefined){return nv.utils.defaultColor();}else if(nv.utils.isArray(color)){var color_scale=d3.scale.ordinal().range(color);return function(d,i){var key=i===undefined?d:i;return d.color||color_scale(key);};}else{return color;}};nv.utils.defaultColor=function(){return nv.utils.getColor(d3.scale.category20().range());};nv.utils.customTheme=function(dictionary,getKey,defaultColors){getKey=getKey||function(series){return series.key};defaultColors=defaultColors||d3.scale.category20().range();var defIndex=defaultColors.length;return function(series,index){var key=getKey(series);if(nv.utils.isFunction(dictionary[key])){return dictionary[key]();}else if(dictionary[key]!==undefined){return dictionary[key];}else{if(!defIndex){defIndex=defaultColors.length;}
defIndex=defIndex-1;return defaultColors[defIndex];}};};nv.utils.pjax=function(links,content){var load=function(href){d3.html(href,function(fragment){var target=d3.select(content).node();target.parentNode.replaceChild(d3.select(fragment).select(content).node(),target);nv.utils.pjax(links,content);});};d3.selectAll(links).on("click",function(){history.pushState(this.href,this.textContent,this.href);load(this.href);d3.event.preventDefault();});d3.select(window).on("popstate",function(){if(d3.event.state){load(d3.event.state);}});};nv.utils.calcApproxTextWidth=function(svgTextElem){if(nv.utils.isFunction(svgTextElem.style)&&nv.utils.isFunction(svgTextElem.text)){var fontSize=parseInt(svgTextElem.style("font-size").replace("px",""),10);var textLength=svgTextElem.text().length;return nv.utils.NaNtoZero(textLength*fontSize*0.5);}
return 0;};nv.utils.NaNtoZero=function(n){if(!nv.utils.isNumber(n)||isNaN(n)||n===null||n===Infinity||n===-Infinity){return 0;}
return n;};d3.selection.prototype.watchTransition=function(renderWatch){var args=[this].concat([].slice.call(arguments,1));return renderWatch.transition.apply(renderWatch,args);};nv.utils.renderWatch=function(dispatch,duration){if(!(this instanceof nv.utils.renderWatch)){return new nv.utils.renderWatch(dispatch,duration);}
var _duration=duration!==undefined?duration:250;var renderStack=[];var self=this;this.models=function(models){models=[].slice.call(arguments,0);models.forEach(function(model){model.__rendered=false;(function(m){m.dispatch.on('renderEnd',function(arg){m.__rendered=true;self.renderEnd('model');});})(model);if(renderStack.indexOf(model)<0){renderStack.push(model);}});return this;};this.reset=function(duration){if(duration!==undefined){_duration=duration;}
renderStack=[];};this.transition=function(selection,args,duration){args=arguments.length>1?[].slice.call(arguments,1):[];if(args.length>1){duration=args.pop();}else{duration=_duration!==undefined?_duration:250;}
selection.__rendered=false;if(renderStack.indexOf(selection)<0){renderStack.push(selection);}
if(duration===0){selection.__rendered=true;selection.delay=function(){return this;};selection.duration=function(){return this;};return selection;}else{if(selection.length===0){selection.__rendered=true;}else if(selection.every(function(d){return!d.length;})){selection.__rendered=true;}else{selection.__rendered=false;}
var n=0;return selection.transition().duration(duration).each(function(){++n;}).each('end',function(d,i){if(--n===0){selection.__rendered=true;self.renderEnd.apply(this,args);}});}};this.renderEnd=function(){if(renderStack.every(function(d){return d.__rendered;})){renderStack.forEach(function(d){d.__rendered=false;});dispatch.renderEnd.apply(this,arguments);}}};nv.utils.deepExtend=function(dst){var sources=arguments.length>1?[].slice.call(arguments,1):[];sources.forEach(function(source){for(var key in source){var isArray=nv.utils.isArray(dst[key]);var isObject=nv.utils.isObject(dst[key]);var srcObj=nv.utils.isObject(source[key]);if(isObject&&!isArray&&srcObj){nv.utils.deepExtend(dst[key],source[key]);}else{dst[key]=source[key];}}});};nv.utils.state=function(){if(!(this instanceof nv.utils.state)){return new nv.utils.state();}
var state={};var _self=this;var _setState=function(){};var _getState=function(){return{};};var init=null;var changed=null;this.dispatch=d3.dispatch('change','set');this.dispatch.on('set',function(state){_setState(state,true);});this.getter=function(fn){_getState=fn;return this;};this.setter=function(fn,callback){if(!callback){callback=function(){};}
_setState=function(state,update){fn(state);if(update){callback();}};return this;};this.init=function(state){init=init||{};nv.utils.deepExtend(init,state);};var _set=function(){var settings=_getState();if(JSON.stringify(settings)===JSON.stringify(state)){return false;}
for(var key in settings){if(state[key]===undefined){state[key]={};}
state[key]=settings[key];changed=true;}
return true;};this.update=function(){if(init){_setState(init,false);init=null;}
if(_set.call(this)){this.dispatch.change(state);}};};nv.utils.optionsFunc=function(args){if(args){d3.map(args).forEach((function(key,value){if(nv.utils.isFunction(this[key])){this[key](value);}}).bind(this));}
return this;};nv.utils.calcTicksX=function(numTicks,data){var numValues=1;var i=0;for(i;i<data.length;i+=1){var stream_len=data[i]&&data[i].values?data[i].values.length:0;numValues=stream_len>numValues?stream_len:numValues;}
nv.log("Requested number of ticks: ",numTicks);nv.log("Calculated max values to be: ",numValues);numTicks=numTicks>numValues?numTicks=numValues-1:numTicks;numTicks=numTicks<1?1:numTicks;numTicks=Math.floor(numTicks);nv.log("Calculating tick count as: ",numTicks);return numTicks;};nv.utils.calcTicksY=function(numTicks,data){return nv.utils.calcTicksX(numTicks,data);};nv.utils.initOption=function(chart,name){if(chart._calls&&chart._calls[name]){chart[name]=chart._calls[name];}else{chart[name]=function(_){if(!arguments.length)return chart._options[name];chart._overrides[name]=true;chart._options[name]=_;return chart;};chart['_'+name]=function(_){if(!arguments.length)return chart._options[name];if(!chart._overrides[name]){chart._options[name]=_;}
return chart;}}};nv.utils.initOptions=function(chart){chart._overrides=chart._overrides||{};var ops=Object.getOwnPropertyNames(chart._options||{});var calls=Object.getOwnPropertyNames(chart._calls||{});ops=ops.concat(calls);for(var i in ops){nv.utils.initOption(chart,ops[i]);}};nv.utils.inheritOptionsD3=function(target,d3_source,oplist){target._d3options=oplist.concat(target._d3options||[]);oplist.unshift(d3_source);oplist.unshift(target);d3.rebind.apply(this,oplist);};nv.utils.arrayUnique=function(a){return a.sort().filter(function(item,pos){return!pos||item!=a[pos-1];});};nv.utils.symbolMap=d3.map();nv.utils.symbol=function(){var type,size=64;function symbol(d,i){var t=type.call(this,d,i);var s=size.call(this,d,i);if(d3.svg.symbolTypes.indexOf(t)!==-1){return d3.svg.symbol().type(t).size(s)();}else{return nv.utils.symbolMap.get(t)(s);}}
symbol.type=function(_){if(!arguments.length)return type;type=d3.functor(_);return symbol;};symbol.size=function(_){if(!arguments.length)return size;size=d3.functor(_);return symbol;};return symbol;};nv.utils.inheritOptions=function(target,source){var ops=Object.getOwnPropertyNames(source._options||{});var calls=Object.getOwnPropertyNames(source._calls||{});var inherited=source._inherited||[];var d3ops=source._d3options||[];var args=ops.concat(calls).concat(inherited).concat(d3ops);args.unshift(source);args.unshift(target);d3.rebind.apply(this,args);target._inherited=nv.utils.arrayUnique(ops.concat(calls).concat(inherited).concat(ops).concat(target._inherited||[]));target._d3options=nv.utils.arrayUnique(d3ops.concat(target._d3options||[]));};nv.utils.initSVG=function(svg){svg.classed({'nvd3-svg':true});};nv.utils.sanitizeHeight=function(height,container){return(height||parseInt(container.style('height'),10)||400);};nv.utils.sanitizeWidth=function(width,container){return(width||parseInt(container.style('width'),10)||960);};nv.utils.availableHeight=function(height,container,margin){return Math.max(0,nv.utils.sanitizeHeight(height,container)-margin.top-margin.bottom);};nv.utils.availableWidth=function(width,container,margin){return Math.max(0,nv.utils.sanitizeWidth(width,container)-margin.left-margin.right);};nv.utils.noData=function(chart,container){var opt=chart.options(),margin=opt.margin(),noData=opt.noData(),data=(noData==null)?["No Data Available."]:[noData],height=nv.utils.availableHeight(null,container,margin),width=nv.utils.availableWidth(null,container,margin),x=margin.left+width/2,y=margin.top+height/2;container.selectAll('g').remove();var noDataText=container.selectAll('.nv-noData').data(data);noDataText.enter().append('text').attr('class','nvd3 nv-noData').attr('dy','-.7em').style('text-anchor','middle');noDataText.attr('x',x).attr('y',y).text(function(t){return t;});};nv.utils.wrapTicks=function(text,width){text.each(function(){var text=d3.select(this),words=text.text().split(/\s+/).reverse(),word,line=[],lineNumber=0,lineHeight=1.1,y=text.attr("y"),dy=parseFloat(text.attr("dy")),tspan=text.text(null).append("tspan").attr("x",0).attr("y",y).attr("dy",dy+"em");while(word=words.pop()){line.push(word);tspan.text(line.join(" "));if(tspan.node().getComputedTextLength()>width){line.pop();tspan.text(line.join(" "));line=[word];tspan=text.append("tspan").attr("x",0).attr("y",y).attr("dy",++lineNumber*lineHeight+dy+"em").text(word);}}});};nv.utils.arrayEquals=function(array1,array2){if(array1===array2)
return true;if(!array1||!array2)
return false;if(array1.length!=array2.length)
return false;for(var i=0,l=array1.length;i<l;i++){if(array1[i]instanceof Array&&array2[i]instanceof Array){if(!nv.arrayEquals(array1[i],array2[i]))
return false;}else if(array1[i]!=array2[i]){return false;}}
return true;};nv.models.axis=function(){"use strict";var axis=d3.svg.axis();var scale=d3.scale.linear();var margin={top:0,right:0,bottom:0,left:0},width=75,height=60,axisLabelText=null,showMaxMin=true,rotateLabels=0,rotateYLabel=true,staggerLabels=false,isOrdinal=false,ticks=null,axisLabelDistance=0,fontSize=undefined,duration=250,dispatch=d3.dispatch('renderEnd');axis.scale(scale).orient('bottom').tickFormat(function(d){return d});var scale0;var renderWatch=nv.utils.renderWatch(dispatch,duration);function chart(selection){renderWatch.reset();selection.each(function(data){var container=d3.select(this);nv.utils.initSVG(container);var wrap=container.selectAll('g.nv-wrap.nv-axis').data([data]);var wrapEnter=wrap.enter().append('g').attr('class','nvd3 nv-wrap nv-axis');var gEnter=wrapEnter.append('g');var g=wrap.select('g');if(ticks!==null)
axis.ticks(ticks);else if(axis.orient()=='top'||axis.orient()=='bottom')
axis.ticks(Math.abs(scale.range()[1]-scale.range()[0])/100);g.watchTransition(renderWatch,'axis').call(axis);scale0=scale0||axis.scale();var fmt=axis.tickFormat();if(fmt==null){fmt=scale0.tickFormat();}
var axisLabel=g.selectAll('text.nv-axislabel').data([axisLabelText||null]);axisLabel.exit().remove();if(fontSize!==undefined){g.selectAll('g').select("text").style('font-size',fontSize);}
var xLabelMargin;var axisMaxMin;var w;switch(axis.orient()){case'top':axisLabel.enter().append('text').attr('class','nv-axislabel');w=0;if(scale.range().length===1){w=isOrdinal?scale.range()[0]*2+scale.rangeBand():0;}else if(scale.range().length===2){w=isOrdinal?scale.range()[0]+scale.range()[1]+scale.rangeBand():scale.range()[1];}else if(scale.range().length>2){w=scale.range()[scale.range().length-1]+(scale.range()[1]-scale.range()[0]);};axisLabel.attr('text-anchor','middle').attr('y',0).attr('x',w/2);if(showMaxMin){axisMaxMin=wrap.selectAll('g.nv-axisMaxMin').data(scale.domain());axisMaxMin.enter().append('g').attr('class',function(d,i){return['nv-axisMaxMin','nv-axisMaxMin-x',(i==0?'nv-axisMin-x':'nv-axisMax-x')].join(' ')}).append('text');axisMaxMin.exit().remove();axisMaxMin.attr('transform',function(d,i){return'translate('+nv.utils.NaNtoZero(scale(d))+',0)'}).select('text').attr('dy','-0.5em').attr('y',-axis.tickPadding()).attr('text-anchor','middle').text(function(d,i){var v=fmt(d);return(''+v).match('NaN')?'':v;});axisMaxMin.watchTransition(renderWatch,'min-max top').attr('transform',function(d,i){return'translate('+nv.utils.NaNtoZero(scale.range()[i])+',0)'});}
break;case'bottom':xLabelMargin=axisLabelDistance+36;var maxTextWidth=30;var textHeight=0;var xTicks=g.selectAll('g').select("text");var rotateLabelsRule='';if(rotateLabels%360){xTicks.attr('transform','');xTicks.each(function(d,i){var box=this.getBoundingClientRect();var width=box.width;textHeight=box.height;if(width>maxTextWidth)maxTextWidth=width;});rotateLabelsRule='rotate('+rotateLabels+' 0,'+(textHeight/2+axis.tickPadding())+')';var sin=Math.abs(Math.sin(rotateLabels*Math.PI/180));xLabelMargin=(sin?sin*maxTextWidth:maxTextWidth)+30;xTicks.attr('transform',rotateLabelsRule).style('text-anchor',rotateLabels%360>0?'start':'end');}else{if(staggerLabels){xTicks.attr('transform',function(d,i){return'translate(0,'+(i%2==0?'0':'12')+')'});}else{xTicks.attr('transform',"translate(0,0)");}}
axisLabel.enter().append('text').attr('class','nv-axislabel');w=0;if(scale.range().length===1){w=isOrdinal?scale.range()[0]*2+scale.rangeBand():0;}else if(scale.range().length===2){w=isOrdinal?scale.range()[0]+scale.range()[1]+scale.rangeBand():scale.range()[1];}else if(scale.range().length>2){w=scale.range()[scale.range().length-1]+(scale.range()[1]-scale.range()[0]);};axisLabel.attr('text-anchor','middle').attr('y',xLabelMargin).attr('x',w/2);if(showMaxMin){axisMaxMin=wrap.selectAll('g.nv-axisMaxMin').data([scale.domain()[0],scale.domain()[scale.domain().length-1]]);axisMaxMin.enter().append('g').attr('class',function(d,i){return['nv-axisMaxMin','nv-axisMaxMin-x',(i==0?'nv-axisMin-x':'nv-axisMax-x')].join(' ')}).append('text');axisMaxMin.exit().remove();axisMaxMin.attr('transform',function(d,i){return'translate('+nv.utils.NaNtoZero((scale(d)+(isOrdinal?scale.rangeBand()/2:0)))+',0)'}).select('text').attr('dy','.71em').attr('y',axis.tickPadding()).attr('transform',rotateLabelsRule).style('text-anchor',rotateLabels?(rotateLabels%360>0?'start':'end'):'middle').text(function(d,i){var v=fmt(d);return(''+v).match('NaN')?'':v;});axisMaxMin.watchTransition(renderWatch,'min-max bottom').attr('transform',function(d,i){return'translate('+nv.utils.NaNtoZero((scale(d)+(isOrdinal?scale.rangeBand()/2:0)))+',0)'});}
break;case'right':axisLabel.enter().append('text').attr('class','nv-axislabel');axisLabel.style('text-anchor',rotateYLabel?'middle':'begin').attr('transform',rotateYLabel?'rotate(90)':'').attr('y',rotateYLabel?(-Math.max(margin.right,width)+12):-10).attr('x',rotateYLabel?(d3.max(scale.range())/2):axis.tickPadding());if(showMaxMin){axisMaxMin=wrap.selectAll('g.nv-axisMaxMin').data(scale.domain());axisMaxMin.enter().append('g').attr('class',function(d,i){return['nv-axisMaxMin','nv-axisMaxMin-y',(i==0?'nv-axisMin-y':'nv-axisMax-y')].join(' ')}).append('text').style('opacity',0);axisMaxMin.exit().remove();axisMaxMin.attr('transform',function(d,i){return'translate(0,'+nv.utils.NaNtoZero(scale(d))+')'}).select('text').attr('dy','.32em').attr('y',0).attr('x',axis.tickPadding()).style('text-anchor','start').text(function(d,i){var v=fmt(d);return(''+v).match('NaN')?'':v;});axisMaxMin.watchTransition(renderWatch,'min-max right').attr('transform',function(d,i){return'translate(0,'+nv.utils.NaNtoZero(scale.range()[i])+')'}).select('text').style('opacity',1);}
break;case'left':axisLabel.enter().append('text').attr('class','nv-axislabel');axisLabel.style('text-anchor',rotateYLabel?'middle':'end').attr('transform',rotateYLabel?'rotate(-90)':'').attr('y',rotateYLabel?(-Math.max(margin.left,width)+25-(axisLabelDistance||0)):-10).attr('x',rotateYLabel?(-d3.max(scale.range())/2):-axis.tickPadding());if(showMaxMin){axisMaxMin=wrap.selectAll('g.nv-axisMaxMin').data(scale.domain());axisMaxMin.enter().append('g').attr('class',function(d,i){return['nv-axisMaxMin','nv-axisMaxMin-y',(i==0?'nv-axisMin-y':'nv-axisMax-y')].join(' ')}).append('text').style('opacity',0);axisMaxMin.exit().remove();axisMaxMin.attr('transform',function(d,i){return'translate(0,'+nv.utils.NaNtoZero(scale0(d))+')'}).select('text').attr('dy','.32em').attr('y',0).attr('x',-axis.tickPadding()).attr('text-anchor','end').text(function(d,i){var v=fmt(d);return(''+v).match('NaN')?'':v;});axisMaxMin.watchTransition(renderWatch,'min-max right').attr('transform',function(d,i){return'translate(0,'+nv.utils.NaNtoZero(scale.range()[i])+')'}).select('text').style('opacity',1);}
break;}
axisLabel.text(function(d){return d});if(showMaxMin&&(axis.orient()==='left'||axis.orient()==='right')){g.selectAll('g').each(function(d,i){d3.select(this).select('text').attr('opacity',1);if(scale(d)<scale.range()[1]+10||scale(d)>scale.range()[0]-10){if(d>1e-10||d<-1e-10)
d3.select(this).attr('opacity',0);d3.select(this).select('text').attr('opacity',0);}});if(scale.domain()[0]==scale.domain()[1]&&scale.domain()[0]==0){wrap.selectAll('g.nv-axisMaxMin').style('opacity',function(d,i){return!i?1:0});}}
if(showMaxMin&&(axis.orient()==='top'||axis.orient()==='bottom')){var maxMinRange=[];wrap.selectAll('g.nv-axisMaxMin').each(function(d,i){try{if(i)
maxMinRange.push(scale(d)-this.getBoundingClientRect().width-4);else
maxMinRange.push(scale(d)+this.getBoundingClientRect().width+4)}catch(err){if(i)
maxMinRange.push(scale(d)-4);else
maxMinRange.push(scale(d)+4);}});g.selectAll('g').each(function(d,i){if(scale(d)<maxMinRange[0]||scale(d)>maxMinRange[1]){if(d>1e-10||d<-1e-10)
d3.select(this).remove();else
d3.select(this).select('text').remove();}});}
g.selectAll('.tick').filter(function(d){return!parseFloat(Math.round(d*100000)/1000000)&&(d!==undefined)}).classed('zero',true);scale0=scale.copy();});renderWatch.renderEnd('axis immediate');return chart;}
chart.axis=axis;chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{axisLabelDistance:{get:function(){return axisLabelDistance;},set:function(_){axisLabelDistance=_;}},staggerLabels:{get:function(){return staggerLabels;},set:function(_){staggerLabels=_;}},rotateLabels:{get:function(){return rotateLabels;},set:function(_){rotateLabels=_;}},rotateYLabel:{get:function(){return rotateYLabel;},set:function(_){rotateYLabel=_;}},showMaxMin:{get:function(){return showMaxMin;},set:function(_){showMaxMin=_;}},axisLabel:{get:function(){return axisLabelText;},set:function(_){axisLabelText=_;}},height:{get:function(){return height;},set:function(_){height=_;}},ticks:{get:function(){return ticks;},set:function(_){ticks=_;}},width:{get:function(){return width;},set:function(_){width=_;}},fontSize:{get:function(){return fontSize;},set:function(_){fontSize=_;}},margin:{get:function(){return margin;},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left;}},duration:{get:function(){return duration;},set:function(_){duration=_;renderWatch.reset(duration);}},scale:{get:function(){return scale;},set:function(_){scale=_;axis.scale(scale);isOrdinal=typeof scale.rangeBands==='function';nv.utils.inheritOptionsD3(chart,scale,['domain','range','rangeBand','rangeBands']);}}});nv.utils.initOptions(chart);nv.utils.inheritOptionsD3(chart,axis,['orient','tickValues','tickSubdivide','tickSize','tickPadding','tickFormat']);nv.utils.inheritOptionsD3(chart,scale,['domain','range','rangeBand','rangeBands']);return chart;};nv.models.scatter=function(){"use strict";var margin={top:0,right:0,bottom:0,left:0},width=null,height=null,color=nv.utils.defaultColor(),id=Math.floor(Math.random()*100000),container=null,x=d3.scale.linear(),y=d3.scale.linear(),z=d3.scale.linear(),getX=function(d){return d.x},getY=function(d){return d.y},getSize=function(d){return d.size||1},getShape=function(d){return d.shape||'circle'},forceX=[],forceY=[],forceSize=[],interactive=true,pointActive=function(d){return!d.notActive},padData=false,padDataOuter=.1,clipEdge=false,clipVoronoi=true,showVoronoi=false,clipRadius=function(){return 25},xDomain=null,yDomain=null,xRange=null,yRange=null,sizeDomain=null,sizeRange=null,singlePoint=false,dispatch=d3.dispatch('elementClick','elementDblClick','elementMouseover','elementMouseout','renderEnd'),useVoronoi=true,duration=250,interactiveUpdateDelay=300,showLabels=false;var x0,y0,z0,timeoutID,needsUpdate=false,renderWatch=nv.utils.renderWatch(dispatch,duration),_sizeRange_def=[16,256],_caches;function getCache(d){var cache,i;cache=_caches=_caches||{};i=d[0].series;cache=cache[i]=cache[i]||{};i=d[1];cache=cache[i]=cache[i]||{};return cache;}
function getDiffs(d){var i,key,point=d[0],cache=getCache(d),diffs=false;for(i=1;i<arguments.length;i++){key=arguments[i];if(cache[key]!==point[key]||!cache.hasOwnProperty(key)){cache[key]=point[key];diffs=true;}}
return diffs;}
function chart(selection){renderWatch.reset();selection.each(function(data){container=d3.select(this);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);nv.utils.initSVG(container);data.forEach(function(series,i){series.values.forEach(function(point){point.series=i;});});var logScale=chart.yScale().name===d3.scale.log().name?true:false;var seriesData=(xDomain&&yDomain&&sizeDomain)?[]:d3.merge(data.map(function(d){return d.values.map(function(d,i){return{x:getX(d,i),y:getY(d,i),size:getSize(d,i)}})}));x.domain(xDomain||d3.extent(seriesData.map(function(d){return d.x;}).concat(forceX)))
if(padData&&data[0])
x.range(xRange||[(availableWidth*padDataOuter+availableWidth)/(2*data[0].values.length),availableWidth-availableWidth*(1+padDataOuter)/(2*data[0].values.length)]);else
x.range(xRange||[0,availableWidth]);if(logScale){var min=d3.min(seriesData.map(function(d){if(d.y!==0)return d.y;}));y.clamp(true).domain(yDomain||d3.extent(seriesData.map(function(d){if(d.y!==0)return d.y;else return min*0.1;}).concat(forceY))).range(yRange||[availableHeight,0]);}else{y.domain(yDomain||d3.extent(seriesData.map(function(d){return d.y;}).concat(forceY))).range(yRange||[availableHeight,0]);}
z.domain(sizeDomain||d3.extent(seriesData.map(function(d){return d.size}).concat(forceSize))).range(sizeRange||_sizeRange_def);singlePoint=x.domain()[0]===x.domain()[1]||y.domain()[0]===y.domain()[1];if(x.domain()[0]===x.domain()[1])
x.domain()[0]?x.domain([x.domain()[0]-x.domain()[0]*0.01,x.domain()[1]+x.domain()[1]*0.01]):x.domain([-1,1]);if(y.domain()[0]===y.domain()[1])
y.domain()[0]?y.domain([y.domain()[0]-y.domain()[0]*0.01,y.domain()[1]+y.domain()[1]*0.01]):y.domain([-1,1]);if(isNaN(x.domain()[0])){x.domain([-1,1]);}
if(isNaN(y.domain()[0])){y.domain([-1,1]);}
x0=x0||x;y0=y0||y;z0=z0||z;var scaleDiff=x(1)!==x0(1)||y(1)!==y0(1)||z(1)!==z0(1);var wrap=container.selectAll('g.nv-wrap.nv-scatter').data([data]);var wrapEnter=wrap.enter().append('g').attr('class','nvd3 nv-wrap nv-scatter nv-chart-'+id);var defsEnter=wrapEnter.append('defs');var gEnter=wrapEnter.append('g');var g=wrap.select('g');wrap.classed('nv-single-point',singlePoint);gEnter.append('g').attr('class','nv-groups');gEnter.append('g').attr('class','nv-point-paths');wrapEnter.append('g').attr('class','nv-point-clips');wrap.attr('transform','translate('+margin.left+','+margin.top+')');defsEnter.append('clipPath').attr('id','nv-edge-clip-'+id).append('rect');wrap.select('#nv-edge-clip-'+id+' rect').attr('width',availableWidth).attr('height',(availableHeight>0)?availableHeight:0);g.attr('clip-path',clipEdge?'url(#nv-edge-clip-'+id+')':'');function updateInteractiveLayer(){needsUpdate=false;if(!interactive)return false;if(useVoronoi===true){var vertices=d3.merge(data.map(function(group,groupIndex){return group.values.map(function(point,pointIndex){var pX=getX(point,pointIndex);var pY=getY(point,pointIndex);return[nv.utils.NaNtoZero(x(pX))+Math.random()*1e-4,nv.utils.NaNtoZero(y(pY))+Math.random()*1e-4,groupIndex,pointIndex,point];}).filter(function(pointArray,pointIndex){return pointActive(pointArray[4],pointIndex);})}));if(vertices.length==0)return false;if(vertices.length<3){vertices.push([x.range()[0]-20,y.range()[0]-20,null,null]);vertices.push([x.range()[1]+20,y.range()[1]+20,null,null]);vertices.push([x.range()[0]-20,y.range()[0]+20,null,null]);vertices.push([x.range()[1]+20,y.range()[1]-20,null,null]);}
var bounds=d3.geom.polygon([[-10,-10],[-10,height+10],[width+10,height+10],[width+10,-10]]);var voronoi=d3.geom.voronoi(vertices).map(function(d,i){return{'data':bounds.clip(d),'series':vertices[i][2],'point':vertices[i][3]}});wrap.select('.nv-point-paths').selectAll('path').remove();var pointPaths=wrap.select('.nv-point-paths').selectAll('path').data(voronoi);var vPointPaths=pointPaths.enter().append("svg:path").attr("d",function(d){if(!d||!d.data||d.data.length===0)
return'M 0 0';else
return"M"+d.data.join(",")+"Z";}).attr("id",function(d,i){return"nv-path-"+i;}).attr("clip-path",function(d,i){return"url(#nv-clip-"+id+"-"+i+")";});if(showVoronoi){vPointPaths.style("fill",d3.rgb(230,230,230)).style('fill-opacity',0.4).style('stroke-opacity',1).style("stroke",d3.rgb(200,200,200));}
if(clipVoronoi){wrap.select('.nv-point-clips').selectAll('*').remove();var pointClips=wrap.select('.nv-point-clips').selectAll('clipPath').data(vertices);var vPointClips=pointClips.enter().append("svg:clipPath").attr("id",function(d,i){return"nv-clip-"+id+"-"+i;}).append("svg:circle").attr('cx',function(d){return d[0];}).attr('cy',function(d){return d[1];}).attr('r',clipRadius);}
var mouseEventCallback=function(d,mDispatch){if(needsUpdate)return 0;var series=data[d.series];if(series===undefined)return;var point=series.values[d.point];point['color']=color(series,d.series);point['x']=getX(point);point['y']=getY(point);var box=container.node().getBoundingClientRect();var scrollTop=window.pageYOffset||document.documentElement.scrollTop;var scrollLeft=window.pageXOffset||document.documentElement.scrollLeft;var pos={left:x(getX(point,d.point))+box.left+scrollLeft+margin.left+10,top:y(getY(point,d.point))+box.top+scrollTop+margin.top+10};mDispatch({point:point,series:series,pos:pos,relativePos:[x(getX(point,d.point))+margin.left,y(getY(point,d.point))+margin.top],seriesIndex:d.series,pointIndex:d.point});};pointPaths.on('click',function(d){mouseEventCallback(d,dispatch.elementClick);}).on('dblclick',function(d){mouseEventCallback(d,dispatch.elementDblClick);}).on('mouseover',function(d){mouseEventCallback(d,dispatch.elementMouseover);}).on('mouseout',function(d,i){mouseEventCallback(d,dispatch.elementMouseout);});}else{wrap.select('.nv-groups').selectAll('.nv-group').selectAll('.nv-point').on('click',function(d,i){if(needsUpdate||!data[d.series])return 0;var series=data[d.series],point=series.values[i];dispatch.elementClick({point:point,series:series,pos:[x(getX(point,i))+margin.left,y(getY(point,i))+margin.top],relativePos:[x(getX(point,i))+margin.left,y(getY(point,i))+margin.top],seriesIndex:d.series,pointIndex:i});}).on('dblclick',function(d,i){if(needsUpdate||!data[d.series])return 0;var series=data[d.series],point=series.values[i];dispatch.elementDblClick({point:point,series:series,pos:[x(getX(point,i))+margin.left,y(getY(point,i))+margin.top],relativePos:[x(getX(point,i))+margin.left,y(getY(point,i))+margin.top],seriesIndex:d.series,pointIndex:i});}).on('mouseover',function(d,i){if(needsUpdate||!data[d.series])return 0;var series=data[d.series],point=series.values[i];dispatch.elementMouseover({point:point,series:series,pos:[x(getX(point,i))+margin.left,y(getY(point,i))+margin.top],relativePos:[x(getX(point,i))+margin.left,y(getY(point,i))+margin.top],seriesIndex:d.series,pointIndex:i,color:color(d,i)});}).on('mouseout',function(d,i){if(needsUpdate||!data[d.series])return 0;var series=data[d.series],point=series.values[i];dispatch.elementMouseout({point:point,series:series,pos:[x(getX(point,i))+margin.left,y(getY(point,i))+margin.top],relativePos:[x(getX(point,i))+margin.left,y(getY(point,i))+margin.top],seriesIndex:d.series,pointIndex:i,color:color(d,i)});});}}
needsUpdate=true;var groups=wrap.select('.nv-groups').selectAll('.nv-group').data(function(d){return d},function(d){return d.key});groups.enter().append('g').style('stroke-opacity',1e-6).style('fill-opacity',1e-6);groups.exit().remove();groups.attr('class',function(d,i){return(d.classed||'')+' nv-group nv-series-'+i;}).classed('nv-noninteractive',!interactive).classed('hover',function(d){return d.hover});groups.watchTransition(renderWatch,'scatter: groups').style('fill',function(d,i){return color(d,i)}).style('stroke',function(d,i){return color(d,i)}).style('stroke-opacity',1).style('fill-opacity',.5);var points=groups.selectAll('path.nv-point').data(function(d){return d.values.map(function(point,pointIndex){return[point,pointIndex]}).filter(function(pointArray,pointIndex){return pointActive(pointArray[0],pointIndex)})});points.enter().append('path').attr('class',function(d){return'nv-point nv-point-'+d[1];}).style('fill',function(d){return d.color}).style('stroke',function(d){return d.color}).attr('transform',function(d){return'translate('+nv.utils.NaNtoZero(x0(getX(d[0],d[1])))+','+nv.utils.NaNtoZero(y0(getY(d[0],d[1])))+')'}).attr('d',nv.utils.symbol().type(function(d){return getShape(d[0]);}).size(function(d){return z(getSize(d[0],d[1]))}));points.exit().remove();groups.exit().selectAll('path.nv-point').watchTransition(renderWatch,'scatter exit').attr('transform',function(d){return'translate('+nv.utils.NaNtoZero(x(getX(d[0],d[1])))+','+nv.utils.NaNtoZero(y(getY(d[0],d[1])))+')'}).remove();points.filter(function(d){return scaleDiff||getDiffs(d,'x','y');}).watchTransition(renderWatch,'scatter points').attr('transform',function(d){return'translate('+nv.utils.NaNtoZero(x(getX(d[0],d[1])))+','+nv.utils.NaNtoZero(y(getY(d[0],d[1])))+')'});points.filter(function(d){return scaleDiff||getDiffs(d,'shape','size');}).watchTransition(renderWatch,'scatter points').attr('d',nv.utils.symbol().type(function(d){return getShape(d[0]);}).size(function(d){return z(getSize(d[0],d[1]))}));if(showLabels)
{var titles=groups.selectAll('.nv-label').data(function(d){return d.values.map(function(point,pointIndex){return[point,pointIndex]}).filter(function(pointArray,pointIndex){return pointActive(pointArray[0],pointIndex)})});titles.enter().append('text').style('fill',function(d,i){return d.color}).style('stroke-opacity',0).style('fill-opacity',1).attr('transform',function(d){var dx=nv.utils.NaNtoZero(x0(getX(d[0],d[1])))+Math.sqrt(z(getSize(d[0],d[1]))/Math.PI)+2;return'translate('+dx+','+nv.utils.NaNtoZero(y0(getY(d[0],d[1])))+')';}).text(function(d,i){return d[0].label;});titles.exit().remove();groups.exit().selectAll('path.nv-label').watchTransition(renderWatch,'scatter exit').attr('transform',function(d){var dx=nv.utils.NaNtoZero(x(getX(d[0],d[1])))+Math.sqrt(z(getSize(d[0],d[1]))/Math.PI)+2;return'translate('+dx+','+nv.utils.NaNtoZero(y(getY(d[0],d[1])))+')';}).remove();titles.each(function(d){d3.select(this).classed('nv-label',true).classed('nv-label-'+d[1],false).classed('hover',false);});titles.watchTransition(renderWatch,'scatter labels').attr('transform',function(d){var dx=nv.utils.NaNtoZero(x(getX(d[0],d[1])))+Math.sqrt(z(getSize(d[0],d[1]))/Math.PI)+2;return'translate('+dx+','+nv.utils.NaNtoZero(y(getY(d[0],d[1])))+')'});}
if(interactiveUpdateDelay)
{clearTimeout(timeoutID);timeoutID=setTimeout(updateInteractiveLayer,interactiveUpdateDelay);}
else
{updateInteractiveLayer();}
x0=x.copy();y0=y.copy();z0=z.copy();});renderWatch.renderEnd('scatter immediate');return chart;}
chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._calls=new function(){this.clearHighlights=function(){nv.dom.write(function(){container.selectAll(".nv-point.hover").classed("hover",false);});return null;};this.highlightPoint=function(seriesIndex,pointIndex,isHoverOver){nv.dom.write(function(){container.select('.nv-groups').selectAll(".nv-series-"+seriesIndex).selectAll(".nv-point-"+pointIndex).classed("hover",isHoverOver);});};};dispatch.on('elementMouseover.point',function(d){if(interactive)chart._calls.highlightPoint(d.seriesIndex,d.pointIndex,true);});dispatch.on('elementMouseout.point',function(d){if(interactive)chart._calls.highlightPoint(d.seriesIndex,d.pointIndex,false);});chart._options=Object.create({},{width:{get:function(){return width;},set:function(_){width=_;}},height:{get:function(){return height;},set:function(_){height=_;}},xScale:{get:function(){return x;},set:function(_){x=_;}},yScale:{get:function(){return y;},set:function(_){y=_;}},pointScale:{get:function(){return z;},set:function(_){z=_;}},xDomain:{get:function(){return xDomain;},set:function(_){xDomain=_;}},yDomain:{get:function(){return yDomain;},set:function(_){yDomain=_;}},pointDomain:{get:function(){return sizeDomain;},set:function(_){sizeDomain=_;}},xRange:{get:function(){return xRange;},set:function(_){xRange=_;}},yRange:{get:function(){return yRange;},set:function(_){yRange=_;}},pointRange:{get:function(){return sizeRange;},set:function(_){sizeRange=_;}},forceX:{get:function(){return forceX;},set:function(_){forceX=_;}},forceY:{get:function(){return forceY;},set:function(_){forceY=_;}},forcePoint:{get:function(){return forceSize;},set:function(_){forceSize=_;}},interactive:{get:function(){return interactive;},set:function(_){interactive=_;}},pointActive:{get:function(){return pointActive;},set:function(_){pointActive=_;}},padDataOuter:{get:function(){return padDataOuter;},set:function(_){padDataOuter=_;}},padData:{get:function(){return padData;},set:function(_){padData=_;}},clipEdge:{get:function(){return clipEdge;},set:function(_){clipEdge=_;}},clipVoronoi:{get:function(){return clipVoronoi;},set:function(_){clipVoronoi=_;}},clipRadius:{get:function(){return clipRadius;},set:function(_){clipRadius=_;}},showVoronoi:{get:function(){return showVoronoi;},set:function(_){showVoronoi=_;}},id:{get:function(){return id;},set:function(_){id=_;}},interactiveUpdateDelay:{get:function(){return interactiveUpdateDelay;},set:function(_){interactiveUpdateDelay=_;}},showLabels:{get:function(){return showLabels;},set:function(_){showLabels=_;}},x:{get:function(){return getX;},set:function(_){getX=d3.functor(_);}},y:{get:function(){return getY;},set:function(_){getY=d3.functor(_);}},pointSize:{get:function(){return getSize;},set:function(_){getSize=d3.functor(_);}},pointShape:{get:function(){return getShape;},set:function(_){getShape=d3.functor(_);}},margin:{get:function(){return margin;},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left;}},duration:{get:function(){return duration;},set:function(_){duration=_;renderWatch.reset(duration);}},color:{get:function(){return color;},set:function(_){color=nv.utils.getColor(_);}},useVoronoi:{get:function(){return useVoronoi;},set:function(_){useVoronoi=_;if(useVoronoi===false){clipVoronoi=false;}}}});nv.utils.initOptions(chart);return chart;};nv.models.multiBar=function(){"use strict";var margin={top:0,right:0,bottom:0,left:0},width=960,height=500,x=d3.scale.ordinal(),y=d3.scale.linear(),id=Math.floor(Math.random()*10000),container=null,getX=function(d){return d.x},getY=function(d){return d.y},forceY=[0],clipEdge=true,stacked=false,stackOffset='zero',color=nv.utils.defaultColor(),hideable=false,barColor=null,disabled,duration=500,xDomain,yDomain,xRange,yRange,groupSpacing=0.1,dispatch=d3.dispatch('chartClick','elementClick','elementDblClick','elementMouseover','elementMouseout','elementMousemove','renderEnd');var x0,y0,renderWatch=nv.utils.renderWatch(dispatch,duration);var last_datalength=0;function chart(selection){renderWatch.reset();selection.each(function(data){var availableWidth=width-margin.left-margin.right,availableHeight=height-margin.top-margin.bottom;container=d3.select(this);nv.utils.initSVG(container);var nonStackableCount=0;var endFn=function(d,i){if(d.series===data.length-1&&i===data[0].values.length-1)
return true;return false;};if(hideable&&data.length)hideable=[{values:data[0].values.map(function(d){return{x:d.x,y:0,series:d.series,size:0.01};})}];if(stacked){var parsed=d3.layout.stack().offset(stackOffset).values(function(d){return d.values}).y(getY)
(!data.length&&hideable?hideable:data);parsed.forEach(function(series,i){if(series.nonStackable){data[i].nonStackableSeries=nonStackableCount++;parsed[i]=data[i];}else{if(i>0&&parsed[i-1].nonStackable){parsed[i].values.map(function(d,j){d.y0-=parsed[i-1].values[j].y;d.y1=d.y0+d.y;});}}});data=parsed;}
data.forEach(function(series,i){series.values.forEach(function(point){point.series=i;point.key=series.key;});});if(stacked){data[0].values.map(function(d,i){var posBase=0,negBase=0;data.map(function(d,idx){if(!data[idx].nonStackable){var f=d.values[i]
f.size=Math.abs(f.y);if(f.y<0){f.y1=negBase;negBase=negBase-f.size;}else
{f.y1=f.size+posBase;posBase=posBase+f.size;}}});});}
var seriesData=(xDomain&&yDomain)?[]:data.map(function(d,idx){return d.values.map(function(d,i){return{x:getX(d,i),y:getY(d,i),y0:d.y0,y1:d.y1,idx:idx}})});x.domain(xDomain||d3.merge(seriesData).map(function(d){return d.x})).rangeBands(xRange||[0,availableWidth],groupSpacing);y.domain(yDomain||d3.extent(d3.merge(seriesData).map(function(d){var domain=d.y;if(stacked&&!data[d.idx].nonStackable){if(d.y>0){domain=d.y1}else{domain=d.y1+d.y}}
return domain;}).concat(forceY))).range(yRange||[availableHeight,0]);if(x.domain()[0]===x.domain()[1])
x.domain()[0]?x.domain([x.domain()[0]-x.domain()[0]*0.01,x.domain()[1]+x.domain()[1]*0.01]):x.domain([-1,1]);if(y.domain()[0]===y.domain()[1])
y.domain()[0]?y.domain([y.domain()[0]+y.domain()[0]*0.01,y.domain()[1]-y.domain()[1]*0.01]):y.domain([-1,1]);x0=x0||x;y0=y0||y;var wrap=container.selectAll('g.nv-wrap.nv-multibar').data([data]);var wrapEnter=wrap.enter().append('g').attr('class','nvd3 nv-wrap nv-multibar');var defsEnter=wrapEnter.append('defs');var gEnter=wrapEnter.append('g');var g=wrap.select('g');gEnter.append('g').attr('class','nv-groups');wrap.attr('transform','translate('+margin.left+','+margin.top+')');defsEnter.append('clipPath').attr('id','nv-edge-clip-'+id).append('rect');wrap.select('#nv-edge-clip-'+id+' rect').attr('width',availableWidth).attr('height',availableHeight);g.attr('clip-path',clipEdge?'url(#nv-edge-clip-'+id+')':'');var groups=wrap.select('.nv-groups').selectAll('.nv-group').data(function(d){return d},function(d,i){return i});groups.enter().append('g').style('stroke-opacity',1e-6).style('fill-opacity',1e-6);var exitTransition=renderWatch.transition(groups.exit().selectAll('rect.nv-bar'),'multibarExit',Math.min(100,duration)).attr('y',function(d,i,j){var yVal=y0(0)||0;if(stacked){if(data[d.series]&&!data[d.series].nonStackable){yVal=y0(d.y0);}}
return yVal;}).attr('height',0).remove();if(exitTransition.delay)
exitTransition.delay(function(d,i){var delay=i*(duration/(last_datalength+1))-i;return delay;});groups.attr('class',function(d,i){return'nv-group nv-series-'+i}).classed('hover',function(d){return d.hover}).style('fill',function(d,i){return color(d,i)}).style('stroke',function(d,i){return color(d,i)});groups.style('stroke-opacity',1).style('fill-opacity',0.75);var bars=groups.selectAll('rect.nv-bar').data(function(d){return(hideable&&!data.length)?hideable.values:d.values});bars.exit().remove();var barsEnter=bars.enter().append('rect').attr('class',function(d,i){return getY(d,i)<0?'nv-bar negative':'nv-bar positive'}).attr('x',function(d,i,j){return stacked&&!data[j].nonStackable?0:(j*x.rangeBand()/data.length)}).attr('y',function(d,i,j){return y0(stacked&&!data[j].nonStackable?d.y0:0)||0}).attr('height',0).attr('width',function(d,i,j){return x.rangeBand()/(stacked&&!data[j].nonStackable?1:data.length)}).attr('transform',function(d,i){return'translate('+x(getX(d,i))+',0)';});bars.style('fill',function(d,i,j){return color(d,j,i);}).style('stroke',function(d,i,j){return color(d,j,i);}).on('mouseover',function(d,i){d3.select(this).classed('hover',true);dispatch.elementMouseover({data:d,index:i,color:d3.select(this).style("fill")});}).on('mouseout',function(d,i){d3.select(this).classed('hover',false);dispatch.elementMouseout({data:d,index:i,color:d3.select(this).style("fill")});}).on('mousemove',function(d,i){dispatch.elementMousemove({data:d,index:i,color:d3.select(this).style("fill")});}).on('click',function(d,i){var element=this;dispatch.elementClick({data:d,index:i,color:d3.select(this).style("fill"),event:d3.event,element:element});d3.event.stopPropagation();}).on('dblclick',function(d,i){dispatch.elementDblClick({data:d,index:i,color:d3.select(this).style("fill")});d3.event.stopPropagation();});bars.attr('class',function(d,i){return getY(d,i)<0?'nv-bar negative':'nv-bar positive'}).attr('transform',function(d,i){return'translate('+x(getX(d,i))+',0)';})
if(barColor){if(!disabled)disabled=data.map(function(){return true});bars.style('fill',function(d,i,j){return d3.rgb(barColor(d,i)).darker(disabled.map(function(d,i){return i}).filter(function(d,i){return!disabled[i]})[j]).toString();}).style('stroke',function(d,i,j){return d3.rgb(barColor(d,i)).darker(disabled.map(function(d,i){return i}).filter(function(d,i){return!disabled[i]})[j]).toString();});}
var barSelection=bars.watchTransition(renderWatch,'multibar',Math.min(250,duration)).delay(function(d,i){return i*duration/data[0].values.length;});if(stacked){barSelection.attr('y',function(d,i,j){var yVal=0;if(!data[j].nonStackable){yVal=y(d.y1);}else{if(getY(d,i)<0){yVal=y(0);}else{if(y(0)-y(getY(d,i))<-1){yVal=y(0)-1;}else{yVal=y(getY(d,i))||0;}}}
return yVal;}).attr('height',function(d,i,j){if(!data[j].nonStackable){return Math.max(Math.abs(y(d.y+d.y0)-y(d.y0)),0);}else{return Math.max(Math.abs(y(getY(d,i))-y(0)),0)||0;}}).attr('x',function(d,i,j){var width=0;if(data[j].nonStackable){width=d.series*x.rangeBand()/data.length;if(data.length!==nonStackableCount){width=data[j].nonStackableSeries*x.rangeBand()/(nonStackableCount*2);}}
return width;}).attr('width',function(d,i,j){if(!data[j].nonStackable){return x.rangeBand();}else{var width=(x.rangeBand()/nonStackableCount);if(data.length!==nonStackableCount){width=x.rangeBand()/(nonStackableCount*2);}
return width;}});}
else{barSelection.attr('x',function(d,i){return d.series*x.rangeBand()/data.length;}).attr('width',x.rangeBand()/data.length).attr('y',function(d,i){return getY(d,i)<0?y(0):y(0)-y(getY(d,i))<1?y(0)-1:y(getY(d,i))||0;}).attr('height',function(d,i){return Math.max(Math.abs(y(getY(d,i))-y(0)),1)||0;});}
x0=x.copy();y0=y.copy();if(data[0]&&data[0].values){last_datalength=data[0].values.length;}});renderWatch.renderEnd('multibar immediate');return chart;}
chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width;},set:function(_){width=_;}},height:{get:function(){return height;},set:function(_){height=_;}},x:{get:function(){return getX;},set:function(_){getX=_;}},y:{get:function(){return getY;},set:function(_){getY=_;}},xScale:{get:function(){return x;},set:function(_){x=_;}},yScale:{get:function(){return y;},set:function(_){y=_;}},xDomain:{get:function(){return xDomain;},set:function(_){xDomain=_;}},yDomain:{get:function(){return yDomain;},set:function(_){yDomain=_;}},xRange:{get:function(){return xRange;},set:function(_){xRange=_;}},yRange:{get:function(){return yRange;},set:function(_){yRange=_;}},forceY:{get:function(){return forceY;},set:function(_){forceY=_;}},stacked:{get:function(){return stacked;},set:function(_){stacked=_;}},stackOffset:{get:function(){return stackOffset;},set:function(_){stackOffset=_;}},clipEdge:{get:function(){return clipEdge;},set:function(_){clipEdge=_;}},disabled:{get:function(){return disabled;},set:function(_){disabled=_;}},id:{get:function(){return id;},set:function(_){id=_;}},hideable:{get:function(){return hideable;},set:function(_){hideable=_;}},groupSpacing:{get:function(){return groupSpacing;},set:function(_){groupSpacing=_;}},margin:{get:function(){return margin;},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left;}},duration:{get:function(){return duration;},set:function(_){duration=_;renderWatch.reset(duration);}},color:{get:function(){return color;},set:function(_){color=nv.utils.getColor(_);}},barColor:{get:function(){return barColor;},set:function(_){barColor=_?nv.utils.getColor(_):null;}}});nv.utils.initOptions(chart);return chart;};nv.models.legend=function(){"use strict";var margin={top:5,right:0,bottom:5,left:0},width=400,height=20,getKey=function(d){return d.key},color=nv.utils.getColor(),maxKeyLength=20,align=true,padding=32,rightAlign=true,updateState=true,radioButtonMode=false,expanded=false,dispatch=d3.dispatch('legendClick','legendDblclick','legendMouseover','legendMouseout','stateChange'),vers='classic';function chart(selection){selection.each(function(data){var availableWidth=width-margin.left-margin.right,container=d3.select(this);nv.utils.initSVG(container);var wrap=container.selectAll('g.nv-legend').data([data]);var gEnter=wrap.enter().append('g').attr('class','nvd3 nv-legend').append('g');var g=wrap.select('g');wrap.attr('transform','translate('+margin.left+','+margin.top+')');var series=g.selectAll('.nv-series').data(function(d){if(vers!='furious')return d;return d.filter(function(n){return expanded?true:!n.disengaged;});});var seriesEnter=series.enter().append('g').attr('class','nv-series');var seriesShape;var versPadding;switch(vers){case'furious':versPadding=23;break;case'classic':versPadding=20;}
if(vers=='classic'){seriesEnter.append('circle').style('stroke-width',2).attr('class','nv-legend-symbol').attr('r',5);seriesShape=series.select('circle');}else if(vers=='furious'){seriesEnter.append('rect').style('stroke-width',2).attr('class','nv-legend-symbol').attr('rx',3).attr('ry',3);seriesShape=series.select('.nv-legend-symbol');seriesEnter.append('g').attr('class','nv-check-box').property('innerHTML','<path d="M0.5,5 L22.5,5 L22.5,26.5 L0.5,26.5 L0.5,5 Z" class="nv-box"></path><path d="M5.5,12.8618467 L11.9185089,19.2803556 L31,0.198864511" class="nv-check"></path>').attr('transform','translate(-10,-8)scale(0.5)');var seriesCheckbox=series.select('.nv-check-box');seriesCheckbox.each(function(d,i){d3.select(this).selectAll('path').attr('stroke',setTextColor(d,i));});}
seriesEnter.append('text').attr('text-anchor','start').attr('class','nv-legend-text').attr('dy','.32em').attr('dx','8');var seriesText=series.select('text.nv-legend-text');series.on('mouseover',function(d,i){dispatch.legendMouseover(d,i);}).on('mouseout',function(d,i){dispatch.legendMouseout(d,i);}).on('click',function(d,i){dispatch.legendClick(d,i);var data=series.data();if(updateState){if(vers=='classic'){if(radioButtonMode){data.forEach(function(series){series.disabled=true});d.disabled=false;}
else{d.disabled=!d.disabled;if(data.every(function(series){return series.disabled})){data.forEach(function(series){series.disabled=false});}}}else if(vers=='furious'){if(expanded){d.disengaged=!d.disengaged;d.userDisabled=d.userDisabled==undefined?!!d.disabled:d.userDisabled;d.disabled=d.disengaged||d.userDisabled;}else if(!expanded){d.disabled=!d.disabled;d.userDisabled=d.disabled;var engaged=data.filter(function(d){return!d.disengaged;});if(engaged.every(function(series){return series.userDisabled})){data.forEach(function(series){series.disabled=series.userDisabled=false;});}}}
dispatch.stateChange({disabled:data.map(function(d){return!!d.disabled}),disengaged:data.map(function(d){return!!d.disengaged})});}}).on('dblclick',function(d,i){if(vers=='furious'&&expanded)return;dispatch.legendDblclick(d,i);if(updateState){var data=series.data();data.forEach(function(series){series.disabled=true;if(vers=='furious')series.userDisabled=series.disabled;});d.disabled=false;if(vers=='furious')d.userDisabled=d.disabled;dispatch.stateChange({disabled:data.map(function(d){return!!d.disabled})});}});series.classed('nv-disabled',function(d){return d.userDisabled});series.exit().remove();seriesText.attr('fill',setTextColor).text(getKey);var legendWidth=0;if(align){var seriesWidths=[];series.each(function(d,i){var legendText;if(getKey(d).length>maxKeyLength){var trimmedKey=getKey(d).substring(0,maxKeyLength);legendText=d3.select(this).select('text').text(trimmedKey+"...");d3.select(this).append("svg:title").text(getKey(d));}else{legendText=d3.select(this).select('text');}
var nodeTextLength;try{nodeTextLength=legendText.node().getComputedTextLength();if(nodeTextLength<=0)throw Error();}
catch(e){nodeTextLength=nv.utils.calcApproxTextWidth(legendText);}
seriesWidths.push(nodeTextLength+padding);});var seriesPerRow=0;var columnWidths=[];legendWidth=0;while(legendWidth<availableWidth&&seriesPerRow<seriesWidths.length){columnWidths[seriesPerRow]=seriesWidths[seriesPerRow];legendWidth+=seriesWidths[seriesPerRow++];}
if(seriesPerRow===0)seriesPerRow=1;while(legendWidth>availableWidth&&seriesPerRow>1){columnWidths=[];seriesPerRow--;for(var k=0;k<seriesWidths.length;k++){if(seriesWidths[k]>(columnWidths[k%seriesPerRow]||0))
columnWidths[k%seriesPerRow]=seriesWidths[k];}
legendWidth=columnWidths.reduce(function(prev,cur,index,array){return prev+cur;});}
var xPositions=[];for(var i=0,curX=0;i<seriesPerRow;i++){xPositions[i]=curX;curX+=columnWidths[i];}
series.attr('transform',function(d,i){return'translate('+xPositions[i%seriesPerRow]+','+(5+Math.floor(i/seriesPerRow)*versPadding)+')';});if(rightAlign){g.attr('transform','translate('+(width-margin.right-legendWidth)+','+margin.top+')');}
else{g.attr('transform','translate(0'+','+margin.top+')');}
height=margin.top+margin.bottom+(Math.ceil(seriesWidths.length/seriesPerRow)*versPadding);}else{var ypos=5,newxpos=5,maxwidth=0,xpos;series.attr('transform',function(d,i){var length=d3.select(this).select('text').node().getComputedTextLength()+padding;xpos=newxpos;if(width<margin.left+margin.right+xpos+length){newxpos=xpos=5;ypos+=versPadding;}
newxpos+=length;if(newxpos>maxwidth)maxwidth=newxpos;if(legendWidth<xpos+maxwidth){legendWidth=xpos+maxwidth;}
return'translate('+xpos+','+ypos+')';});g.attr('transform','translate('+(width-margin.right-maxwidth)+','+margin.top+')');height=margin.top+margin.bottom+ypos+15;}
if(vers=='furious'){seriesShape.attr('width',function(d,i){return seriesText[0][i].getComputedTextLength()+27;}).attr('height',18).attr('y',-9).attr('x',-15);gEnter.insert('rect',':first-child').attr('class','nv-legend-bg').attr('fill','#eee').attr('opacity',0);var seriesBG=g.select('.nv-legend-bg');seriesBG.transition().duration(300).attr('x',-versPadding).attr('width',legendWidth+versPadding-12).attr('height',height+10).attr('y',-margin.top-10).attr('opacity',expanded?1:0);}
seriesShape.style('fill',setBGColor).style('fill-opacity',setBGOpacity).style('stroke',setBGColor);});function setTextColor(d,i){if(vers!='furious')return'#000';if(expanded){return d.disengaged?'#000':'#fff';}else if(!expanded){if(!d.color)d.color=color(d,i);return!!d.disabled?d.color:'#fff';}}
function setBGColor(d,i){if(expanded&&vers=='furious'){return d.disengaged?'#eee':d.color||color(d,i);}else{return d.color||color(d,i);}}
function setBGOpacity(d,i){if(expanded&&vers=='furious'){return 1;}else{return!!d.disabled?0:1;}}
return chart;}
chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width;},set:function(_){width=_;}},height:{get:function(){return height;},set:function(_){height=_;}},key:{get:function(){return getKey;},set:function(_){getKey=_;}},align:{get:function(){return align;},set:function(_){align=_;}},maxKeyLength:{get:function(){return maxKeyLength;},set:function(_){maxKeyLength=_;}},rightAlign:{get:function(){return rightAlign;},set:function(_){rightAlign=_;}},padding:{get:function(){return padding;},set:function(_){padding=_;}},updateState:{get:function(){return updateState;},set:function(_){updateState=_;}},radioButtonMode:{get:function(){return radioButtonMode;},set:function(_){radioButtonMode=_;}},expanded:{get:function(){return expanded;},set:function(_){expanded=_;}},vers:{get:function(){return vers;},set:function(_){vers=_;}},margin:{get:function(){return margin;},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left;}},color:{get:function(){return color;},set:function(_){color=nv.utils.getColor(_);}}});nv.utils.initOptions(chart);return chart;};nv.models.lineChart=function(){"use strict";var lines=nv.models.line(),xAxis=nv.models.axis(),yAxis=nv.models.axis(),legend=nv.models.legend(),interactiveLayer=nv.interactiveGuideline(),tooltip=nv.models.tooltip(),lines2=nv.models.line(),x2Axis=nv.models.axis(),y2Axis=nv.models.axis(),brush=d3.svg.brush();var margin={top:30,right:20,bottom:50,left:60},margin2={top:0,right:20,bottom:20,left:60},color=nv.utils.defaultColor(),width=null,height=null,showLegend=true,legendPosition='top',showXAxis=true,showYAxis=true,rightAlignYAxis=false,useInteractiveGuideline=false,x,y,x2,y2,focusEnable=false,focusShowAxisY=false,focusShowAxisX=true,focusHeight=50,brushExtent=null,state=nv.utils.state(),defaultState=null,noData=null,dispatch=d3.dispatch('tooltipShow','tooltipHide','brush','stateChange','changeState','renderEnd'),duration=250;xAxis.orient('bottom').tickPadding(7);yAxis.orient(rightAlignYAxis?'right':'left');lines.clipEdge(true).duration(0);lines2.interactive(false);lines2.pointActive(function(d){return false;});x2Axis.orient('bottom').tickPadding(5);y2Axis.orient(rightAlignYAxis?'right':'left');tooltip.valueFormatter(function(d,i){return yAxis.tickFormat()(d,i);}).headerFormatter(function(d,i){return xAxis.tickFormat()(d,i);});interactiveLayer.tooltip.valueFormatter(function(d,i){return yAxis.tickFormat()(d,i);}).headerFormatter(function(d,i){return xAxis.tickFormat()(d,i);});var renderWatch=nv.utils.renderWatch(dispatch,duration);var stateGetter=function(data){return function(){return{active:data.map(function(d){return!d.disabled;})};};};var stateSetter=function(data){return function(state){if(state.active!==undefined)
data.forEach(function(series,i){series.disabled=!state.active[i];});};};function chart(selection){renderWatch.reset();renderWatch.models(lines);renderWatch.models(lines2);if(showXAxis)renderWatch.models(xAxis);if(showYAxis)renderWatch.models(yAxis);if(focusShowAxisX)renderWatch.models(x2Axis);if(focusShowAxisY)renderWatch.models(y2Axis);selection.each(function(data){var container=d3.select(this);nv.utils.initSVG(container);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight1=nv.utils.availableHeight(height,container,margin)-(focusEnable?focusHeight:0),availableHeight2=focusHeight-margin2.top-margin2.bottom;chart.update=function(){if(duration===0){container.call(chart);}else{container.transition().duration(duration).call(chart);}};chart.container=this;state.setter(stateSetter(data),chart.update).getter(stateGetter(data)).update();state.disabled=data.map(function(d){return!!d.disabled;});if(!defaultState){var key;defaultState={};for(key in state){if(state[key]instanceof Array)
defaultState[key]=state[key].slice(0);else
defaultState[key]=state[key];}}
if(!data||!data.length||!data.filter(function(d){return d.values.length;}).length){nv.utils.noData(chart,container);return chart;}else{container.selectAll('.nv-noData').remove();}
x=lines.xScale();y=lines.yScale();x2=lines2.xScale();y2=lines2.yScale();var wrap=container.selectAll('g.nv-wrap.nv-lineChart').data([data]);var gEnter=wrap.enter().append('g').attr('class','nvd3 nv-wrap nv-lineChart').append('g');var g=wrap.select('g');gEnter.append('g').attr('class','nv-legendWrap');var focusEnter=gEnter.append('g').attr('class','nv-focus');focusEnter.append('g').attr('class','nv-background').append('rect');focusEnter.append('g').attr('class','nv-x nv-axis');focusEnter.append('g').attr('class','nv-y nv-axis');focusEnter.append('g').attr('class','nv-linesWrap');focusEnter.append('g').attr('class','nv-interactive');var contextEnter=gEnter.append('g').attr('class','nv-context');contextEnter.append('g').attr('class','nv-background').append('rect');contextEnter.append('g').attr('class','nv-x nv-axis');contextEnter.append('g').attr('class','nv-y nv-axis');contextEnter.append('g').attr('class','nv-linesWrap');contextEnter.append('g').attr('class','nv-brushBackground');contextEnter.append('g').attr('class','nv-x nv-brush');if(!showLegend){g.select('.nv-legendWrap').selectAll('*').remove();}else{legend.width(availableWidth);g.select('.nv-legendWrap').datum(data).call(legend);if(legendPosition==='bottom'){wrap.select('.nv-legendWrap').attr('transform','translate(0,'+(availableHeight1+legend.height())+')');}else if(legendPosition==='top'){if(margin.top!=legend.height()){margin.top=legend.height();availableHeight1=nv.utils.availableHeight(height,container,margin)-(focusEnable?focusHeight:0);}
wrap.select('.nv-legendWrap').attr('transform','translate(0,'+(-margin.top)+')');}}
wrap.attr('transform','translate('+margin.left+','+margin.top+')');if(rightAlignYAxis){g.select(".nv-y.nv-axis").attr("transform","translate("+availableWidth+",0)");}
if(useInteractiveGuideline){interactiveLayer.width(availableWidth).height(availableHeight1).margin({left:margin.left,top:margin.top}).svgContainer(container).xScale(x);wrap.select(".nv-interactive").call(interactiveLayer);}
g.select('.nv-focus .nv-background rect').attr('width',availableWidth).attr('height',availableHeight1);lines.width(availableWidth).height(availableHeight1).color(data.map(function(d,i){return d.color||color(d,i);}).filter(function(d,i){return!data[i].disabled;}));var linesWrap=g.select('.nv-linesWrap').datum(data.filter(function(d){return!d.disabled;}));if(showXAxis){xAxis.scale(x)._ticks(nv.utils.calcTicksX(availableWidth/100,data)).tickSize(-availableHeight1,0);}
if(showYAxis){yAxis.scale(y)._ticks(nv.utils.calcTicksY(availableHeight1/36,data)).tickSize(-availableWidth,0);}
function updateXAxis(){if(showXAxis){g.select('.nv-focus .nv-x.nv-axis').transition().duration(duration).call(xAxis);}}
function updateYAxis(){if(showYAxis){g.select('.nv-focus .nv-y.nv-axis').transition().duration(duration).call(yAxis);}}
g.select('.nv-focus .nv-x.nv-axis').attr('transform','translate(0,'+availableHeight1+')');if(!focusEnable)
{linesWrap.call(lines);updateXAxis();updateYAxis();}
else
{lines2.defined(lines.defined()).width(availableWidth).height(availableHeight2).color(data.map(function(d,i){return d.color||color(d,i);}).filter(function(d,i){return!data[i].disabled;}));g.select('.nv-context').attr('transform','translate(0,'+(availableHeight1+margin.bottom+margin2.top)+')').style('display',focusEnable?'initial':'none');var contextLinesWrap=g.select('.nv-context .nv-linesWrap').datum(data.filter(function(d){return!d.disabled;}));d3.transition(contextLinesWrap).call(lines2);brush.x(x2).on('brush',function(){onBrush();});if(brushExtent)brush.extent(brushExtent);var brushBG=g.select('.nv-brushBackground').selectAll('g').data([brushExtent||brush.extent()]);var brushBGenter=brushBG.enter().append('g');brushBGenter.append('rect').attr('class','left').attr('x',0).attr('y',0).attr('height',availableHeight2);brushBGenter.append('rect').attr('class','right').attr('x',0).attr('y',0).attr('height',availableHeight2);var gBrush=g.select('.nv-x.nv-brush').call(brush);gBrush.selectAll('rect').attr('height',availableHeight2);gBrush.selectAll('.resize').append('path').attr('d',resizePath);onBrush();g.select('.nv-context .nv-background rect').attr('width',availableWidth).attr('height',availableHeight2);if(focusShowAxisX){x2Axis.scale(x2)._ticks(nv.utils.calcTicksX(availableWidth/100,data)).tickSize(-availableHeight2,0);g.select('.nv-context .nv-x.nv-axis').attr('transform','translate(0,'+y2.range()[0]+')');d3.transition(g.select('.nv-context .nv-x.nv-axis')).call(x2Axis);}
if(focusShowAxisY){y2Axis.scale(y2)._ticks(nv.utils.calcTicksY(availableHeight2/36,data)).tickSize(-availableWidth,0);d3.transition(g.select('.nv-context .nv-y.nv-axis')).call(y2Axis);}
g.select('.nv-context .nv-x.nv-axis').attr('transform','translate(0,'+y2.range()[0]+')');}
legend.dispatch.on('stateChange',function(newState){for(var key in newState)
state[key]=newState[key];dispatch.stateChange(state);chart.update();});interactiveLayer.dispatch.on('elementMousemove',function(e){lines.clearHighlights();var singlePoint,pointIndex,pointXLocation,allData=[];data.filter(function(series,i){series.seriesIndex=i;return!series.disabled&&!series.disableTooltip;}).forEach(function(series,i){var extent=focusEnable?(brush.empty()?x2.domain():brush.extent()):x.domain();var currentValues=series.values.filter(function(d,i){return lines.x()(d,i)>=extent[0]&&lines.x()(d,i)<=extent[1];});pointIndex=nv.interactiveBisect(currentValues,e.pointXValue,lines.x());var point=currentValues[pointIndex];var pointYValue=chart.y()(point,pointIndex);if(pointYValue!==null){lines.highlightPoint(series.seriesIndex,pointIndex,true);}
if(point===undefined)return;if(singlePoint===undefined)singlePoint=point;if(pointXLocation===undefined)pointXLocation=chart.xScale()(chart.x()(point,pointIndex));allData.push({key:series.key,value:pointYValue,color:color(series,series.seriesIndex),data:point});});if(allData.length>2){var yValue=chart.yScale().invert(e.mouseY);var domainExtent=Math.abs(chart.yScale().domain()[0]-chart.yScale().domain()[1]);var threshold=0.03*domainExtent;var indexToHighlight=nv.nearestValueIndex(allData.map(function(d){return d.value;}),yValue,threshold);if(indexToHighlight!==null)
allData[indexToHighlight].highlight=true;}
var defaultValueFormatter=function(d,i){return d==null?"N/A":yAxis.tickFormat()(d);};interactiveLayer.tooltip.chartContainer(chart.container.parentNode).valueFormatter(interactiveLayer.tooltip.valueFormatter()||defaultValueFormatter).data({value:chart.x()(singlePoint,pointIndex),index:pointIndex,series:allData})();interactiveLayer.renderGuideLine(pointXLocation);});interactiveLayer.dispatch.on('elementClick',function(e){var pointXLocation,allData=[];data.filter(function(series,i){series.seriesIndex=i;return!series.disabled;}).forEach(function(series){var pointIndex=nv.interactiveBisect(series.values,e.pointXValue,chart.x());var point=series.values[pointIndex];if(typeof point==='undefined')return;if(typeof pointXLocation==='undefined')pointXLocation=chart.xScale()(chart.x()(point,pointIndex));var yPos=chart.yScale()(chart.y()(point,pointIndex));allData.push({point:point,pointIndex:pointIndex,pos:[pointXLocation,yPos],seriesIndex:series.seriesIndex,series:series});});lines.dispatch.elementClick(allData);});interactiveLayer.dispatch.on("elementMouseout",function(e){lines.clearHighlights();});dispatch.on('changeState',function(e){if(typeof e.disabled!=='undefined'&&data.length===e.disabled.length){data.forEach(function(series,i){series.disabled=e.disabled[i];});state.disabled=e.disabled;}
chart.update();});function resizePath(d){var e=+(d=='e'),x=e?1:-1,y=availableHeight2/3;return'M'+(0.5*x)+','+y
+'A6,6 0 0 '+e+' '+(6.5*x)+','+(y+6)
+'V'+(2*y-6)
+'A6,6 0 0 '+e+' '+(0.5*x)+','+(2*y)
+'Z'
+'M'+(2.5*x)+','+(y+8)
+'V'+(2*y-8)
+'M'+(4.5*x)+','+(y+8)
+'V'+(2*y-8);}
function updateBrushBG(){if(!brush.empty())brush.extent(brushExtent);brushBG.data([brush.empty()?x2.domain():brushExtent]).each(function(d,i){var leftWidth=x2(d[0])-x.range()[0],rightWidth=availableWidth-x2(d[1]);d3.select(this).select('.left').attr('width',leftWidth<0?0:leftWidth);d3.select(this).select('.right').attr('x',x2(d[1])).attr('width',rightWidth<0?0:rightWidth);});}
function onBrush(){brushExtent=brush.empty()?null:brush.extent();var extent=brush.empty()?x2.domain():brush.extent();if(Math.abs(extent[0]-extent[1])<=1){return;}
dispatch.brush({extent:extent,brush:brush});updateBrushBG();var focusLinesWrap=g.select('.nv-focus .nv-linesWrap').datum(data.filter(function(d){return!d.disabled;}).map(function(d,i){return{key:d.key,area:d.area,classed:d.classed,values:d.values.filter(function(d,i){return lines.x()(d,i)>=extent[0]&&lines.x()(d,i)<=extent[1];}),disableTooltip:d.disableTooltip};}));focusLinesWrap.transition().duration(duration).call(lines);updateXAxis();updateYAxis();}});renderWatch.renderEnd('lineChart immediate');return chart;}
lines.dispatch.on('elementMouseover.tooltip',function(evt){if(!evt.series.disableTooltip){tooltip.data(evt).hidden(false);}});lines.dispatch.on('elementMouseout.tooltip',function(evt){tooltip.hidden(true);});chart.dispatch=dispatch;chart.lines=lines;chart.lines2=lines2;chart.legend=legend;chart.xAxis=xAxis;chart.x2Axis=x2Axis;chart.yAxis=yAxis;chart.y2Axis=y2Axis;chart.interactiveLayer=interactiveLayer;chart.tooltip=tooltip;chart.state=state;chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width;},set:function(_){width=_;}},height:{get:function(){return height;},set:function(_){height=_;}},showLegend:{get:function(){return showLegend;},set:function(_){showLegend=_;}},legendPosition:{get:function(){return legendPosition;},set:function(_){legendPosition=_;}},showXAxis:{get:function(){return showXAxis;},set:function(_){showXAxis=_;}},showYAxis:{get:function(){return showYAxis;},set:function(_){showYAxis=_;}},focusEnable:{get:function(){return focusEnable;},set:function(_){focusEnable=_;}},focusHeight:{get:function(){return height2;},set:function(_){focusHeight=_;}},focusShowAxisX:{get:function(){return focusShowAxisX;},set:function(_){focusShowAxisX=_;}},focusShowAxisY:{get:function(){return focusShowAxisY;},set:function(_){focusShowAxisY=_;}},brushExtent:{get:function(){return brushExtent;},set:function(_){brushExtent=_;}},defaultState:{get:function(){return defaultState;},set:function(_){defaultState=_;}},noData:{get:function(){return noData;},set:function(_){noData=_;}},margin:{get:function(){return margin;},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left;}},duration:{get:function(){return duration;},set:function(_){duration=_;renderWatch.reset(duration);lines.duration(duration);xAxis.duration(duration);x2Axis.duration(duration);yAxis.duration(duration);y2Axis.duration(duration);}},focusMargin:{get:function(){return margin2;},set:function(_){margin2.top=_.top!==undefined?_.top:margin2.top;margin2.right=_.right!==undefined?_.right:margin2.right;margin2.bottom=_.bottom!==undefined?_.bottom:margin2.bottom;margin2.left=_.left!==undefined?_.left:margin2.left;}},color:{get:function(){return color;},set:function(_){color=nv.utils.getColor(_);legend.color(color);lines.color(color);}},interpolate:{get:function(){return lines.interpolate();},set:function(_){lines.interpolate(_);lines2.interpolate(_);}},xTickFormat:{get:function(){return xAxis.tickFormat();},set:function(_){xAxis.tickFormat(_);x2Axis.tickFormat(_);}},yTickFormat:{get:function(){return yAxis.tickFormat();},set:function(_){yAxis.tickFormat(_);y2Axis.tickFormat(_);}},x:{get:function(){return lines.x();},set:function(_){lines.x(_);lines2.x(_);}},y:{get:function(){return lines.y();},set:function(_){lines.y(_);lines2.y(_);}},rightAlignYAxis:{get:function(){return rightAlignYAxis;},set:function(_){rightAlignYAxis=_;yAxis.orient(rightAlignYAxis?'right':'left');}},useInteractiveGuideline:{get:function(){return useInteractiveGuideline;},set:function(_){useInteractiveGuideline=_;if(useInteractiveGuideline){lines.interactive(false);lines.useVoronoi(false);}}}});nv.utils.inheritOptions(chart,lines);nv.utils.initOptions(chart);return chart;};nv.models.lineWithFocusChart=function(){return nv.models.lineChart().margin({bottom:30}).focusEnable(true);};nv.models.line=function(){"use strict";var scatter=nv.models.scatter();var margin={top:0,right:0,bottom:0,left:0},width=960,height=500,container=null,strokeWidth=1.5,color=nv.utils.defaultColor(),getX=function(d){return d.x},getY=function(d){return d.y},defined=function(d,i){return!isNaN(getY(d,i))&&getY(d,i)!==null},isArea=function(d){return d.area},clipEdge=false,x,y,interpolate="linear",duration=250,dispatch=d3.dispatch('elementClick','elementMouseover','elementMouseout','renderEnd');scatter.pointSize(16).pointDomain([16,256]);var x0,y0,renderWatch=nv.utils.renderWatch(dispatch,duration);function chart(selection){renderWatch.reset();renderWatch.models(scatter);selection.each(function(data){container=d3.select(this);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);nv.utils.initSVG(container);x=scatter.xScale();y=scatter.yScale();x0=x0||x;y0=y0||y;var wrap=container.selectAll('g.nv-wrap.nv-line').data([data]);var wrapEnter=wrap.enter().append('g').attr('class','nvd3 nv-wrap nv-line');var defsEnter=wrapEnter.append('defs');var gEnter=wrapEnter.append('g');var g=wrap.select('g');gEnter.append('g').attr('class','nv-groups');gEnter.append('g').attr('class','nv-scatterWrap');wrap.attr('transform','translate('+margin.left+','+margin.top+')');scatter.width(availableWidth).height(availableHeight);var scatterWrap=wrap.select('.nv-scatterWrap');scatterWrap.call(scatter);defsEnter.append('clipPath').attr('id','nv-edge-clip-'+scatter.id()).append('rect');wrap.select('#nv-edge-clip-'+scatter.id()+' rect').attr('width',availableWidth).attr('height',(availableHeight>0)?availableHeight:0);g.attr('clip-path',clipEdge?'url(#nv-edge-clip-'+scatter.id()+')':'');scatterWrap.attr('clip-path',clipEdge?'url(#nv-edge-clip-'+scatter.id()+')':'');var groups=wrap.select('.nv-groups').selectAll('.nv-group').data(function(d){return d},function(d){return d.key});groups.enter().append('g').style('stroke-opacity',1e-6).style('stroke-width',function(d){return d.strokeWidth||strokeWidth}).style('fill-opacity',1e-6);groups.exit().remove();groups.attr('class',function(d,i){return(d.classed||'')+' nv-group nv-series-'+i;}).classed('hover',function(d){return d.hover}).style('fill',function(d,i){return color(d,i)}).style('stroke',function(d,i){return color(d,i)});groups.watchTransition(renderWatch,'line: groups').style('stroke-opacity',1).style('fill-opacity',function(d){return d.fillOpacity||.5});var areaPaths=groups.selectAll('path.nv-area').data(function(d){return isArea(d)?[d]:[]});areaPaths.enter().append('path').attr('class','nv-area').attr('d',function(d){return d3.svg.area().interpolate(interpolate).defined(defined).x(function(d,i){return nv.utils.NaNtoZero(x0(getX(d,i)))}).y0(function(d,i){return nv.utils.NaNtoZero(y0(getY(d,i)))}).y1(function(d,i){return y0(y.domain()[0]<=0?y.domain()[1]>=0?0:y.domain()[1]:y.domain()[0])}).apply(this,[d.values])});groups.exit().selectAll('path.nv-area').remove();areaPaths.watchTransition(renderWatch,'line: areaPaths').attr('d',function(d){return d3.svg.area().interpolate(interpolate).defined(defined).x(function(d,i){return nv.utils.NaNtoZero(x(getX(d,i)))}).y0(function(d,i){return nv.utils.NaNtoZero(y(getY(d,i)))}).y1(function(d,i){return y(y.domain()[0]<=0?y.domain()[1]>=0?0:y.domain()[1]:y.domain()[0])}).apply(this,[d.values])});var linePaths=groups.selectAll('path.nv-line').data(function(d){return[d.values]});linePaths.enter().append('path').attr('class','nv-line').attr('d',d3.svg.line().interpolate(interpolate).defined(defined).x(function(d,i){return nv.utils.NaNtoZero(x0(getX(d,i)))}).y(function(d,i){return nv.utils.NaNtoZero(y0(getY(d,i)))}));linePaths.watchTransition(renderWatch,'line: linePaths').attr('d',d3.svg.line().interpolate(interpolate).defined(defined).x(function(d,i){return nv.utils.NaNtoZero(x(getX(d,i)))}).y(function(d,i){return nv.utils.NaNtoZero(y(getY(d,i)))}));x0=x.copy();y0=y.copy();});renderWatch.renderEnd('line immediate');return chart;}
chart.dispatch=dispatch;chart.scatter=scatter;scatter.dispatch.on('elementClick',function(){dispatch.elementClick.apply(this,arguments);});scatter.dispatch.on('elementMouseover',function(){dispatch.elementMouseover.apply(this,arguments);});scatter.dispatch.on('elementMouseout',function(){dispatch.elementMouseout.apply(this,arguments);});chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width;},set:function(_){width=_;}},height:{get:function(){return height;},set:function(_){height=_;}},defined:{get:function(){return defined;},set:function(_){defined=_;}},interpolate:{get:function(){return interpolate;},set:function(_){interpolate=_;}},clipEdge:{get:function(){return clipEdge;},set:function(_){clipEdge=_;}},margin:{get:function(){return margin;},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left;}},duration:{get:function(){return duration;},set:function(_){duration=_;renderWatch.reset(duration);scatter.duration(duration);}},isArea:{get:function(){return isArea;},set:function(_){isArea=d3.functor(_);}},x:{get:function(){return getX;},set:function(_){getX=_;scatter.x(_);}},y:{get:function(){return getY;},set:function(_){getY=_;scatter.y(_);}},color:{get:function(){return color;},set:function(_){color=nv.utils.getColor(_);scatter.color(color);}}});nv.utils.inheritOptions(chart,scatter);nv.utils.initOptions(chart);return chart;};nv.models.discreteBarChart=function(){"use strict";var discretebar=nv.models.discreteBar(),xAxis=nv.models.axis(),yAxis=nv.models.axis(),legend=nv.models.legend(),tooltip=nv.models.tooltip();var margin={top:15,right:10,bottom:50,left:60},width=null,height=null,color=nv.utils.getColor(),showLegend=false,showXAxis=true,showYAxis=true,rightAlignYAxis=false,staggerLabels=false,wrapLabels=false,rotateLabels=0,x,y,noData=null,dispatch=d3.dispatch('beforeUpdate','renderEnd'),duration=250;xAxis.orient('bottom').showMaxMin(false).tickFormat(function(d){return d});yAxis.orient((rightAlignYAxis)?'right':'left').tickFormat(d3.format(',.1f'));tooltip.duration(0).headerEnabled(false).valueFormatter(function(d,i){return yAxis.tickFormat()(d,i);}).keyFormatter(function(d,i){return xAxis.tickFormat()(d,i);});var renderWatch=nv.utils.renderWatch(dispatch,duration);function chart(selection){renderWatch.reset();renderWatch.models(discretebar);if(showXAxis)renderWatch.models(xAxis);if(showYAxis)renderWatch.models(yAxis);selection.each(function(data){var container=d3.select(this),that=this;nv.utils.initSVG(container);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);chart.update=function(){dispatch.beforeUpdate();container.transition().duration(duration).call(chart);};chart.container=this;if(!data||!data.length||!data.filter(function(d){return d.values.length}).length){nv.utils.noData(chart,container);return chart;}else{container.selectAll('.nv-noData').remove();}
x=discretebar.xScale();y=discretebar.yScale().clamp(true);var wrap=container.selectAll('g.nv-wrap.nv-discreteBarWithAxes').data([data]);var gEnter=wrap.enter().append('g').attr('class','nvd3 nv-wrap nv-discreteBarWithAxes').append('g');var defsEnter=gEnter.append('defs');var g=wrap.select('g');gEnter.append('g').attr('class','nv-x nv-axis');gEnter.append('g').attr('class','nv-y nv-axis').append('g').attr('class','nv-zeroLine').append('line');gEnter.append('g').attr('class','nv-barsWrap');gEnter.append('g').attr('class','nv-legendWrap');g.attr('transform','translate('+margin.left+','+margin.top+')');if(!showLegend){g.select('.nv-legendWrap').selectAll('*').remove();}else{legend.width(availableWidth);g.select('.nv-legendWrap').datum(data).call(legend);if(margin.top!=legend.height()){margin.top=legend.height();availableHeight=nv.utils.availableHeight(height,container,margin);}
wrap.select('.nv-legendWrap').attr('transform','translate(0,'+(-margin.top)+')')}
if(rightAlignYAxis){g.select(".nv-y.nv-axis").attr("transform","translate("+availableWidth+",0)");}
discretebar.width(availableWidth).height(availableHeight);var barsWrap=g.select('.nv-barsWrap').datum(data.filter(function(d){return!d.disabled}));barsWrap.transition().call(discretebar);defsEnter.append('clipPath').attr('id','nv-x-label-clip-'+discretebar.id()).append('rect');g.select('#nv-x-label-clip-'+discretebar.id()+' rect').attr('width',x.rangeBand()*(staggerLabels?2:1)).attr('height',16).attr('x',-x.rangeBand()/(staggerLabels?1:2));if(showXAxis){xAxis.scale(x)._ticks(nv.utils.calcTicksX(availableWidth/100,data)).tickSize(-availableHeight,0);g.select('.nv-x.nv-axis').attr('transform','translate(0,'+(y.range()[0]+((discretebar.showValues()&&y.domain()[0]<0)?16:0))+')');g.select('.nv-x.nv-axis').call(xAxis);var xTicks=g.select('.nv-x.nv-axis').selectAll('g');if(staggerLabels){xTicks.selectAll('text').attr('transform',function(d,i,j){return'translate(0,'+(j%2==0?'5':'17')+')'})}
if(rotateLabels){xTicks.selectAll('.tick text').attr('transform','rotate('+rotateLabels+' 0,0)').style('text-anchor',rotateLabels>0?'start':'end');}
if(wrapLabels){g.selectAll('.tick text').call(nv.utils.wrapTicks,chart.xAxis.rangeBand())}}
if(showYAxis){yAxis.scale(y)._ticks(nv.utils.calcTicksY(availableHeight/36,data)).tickSize(-availableWidth,0);g.select('.nv-y.nv-axis').call(yAxis);}
g.select(".nv-zeroLine line").attr("x1",0).attr("x2",(rightAlignYAxis)?-availableWidth:availableWidth).attr("y1",y(0)).attr("y2",y(0));});renderWatch.renderEnd('discreteBar chart immediate');return chart;}
discretebar.dispatch.on('elementMouseover.tooltip',function(evt){evt['series']={key:chart.x()(evt.data),value:chart.y()(evt.data),color:evt.color};tooltip.data(evt).hidden(false);});discretebar.dispatch.on('elementMouseout.tooltip',function(evt){tooltip.hidden(true);});discretebar.dispatch.on('elementMousemove.tooltip',function(evt){tooltip();});chart.dispatch=dispatch;chart.discretebar=discretebar;chart.legend=legend;chart.xAxis=xAxis;chart.yAxis=yAxis;chart.tooltip=tooltip;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width;},set:function(_){width=_;}},height:{get:function(){return height;},set:function(_){height=_;}},showLegend:{get:function(){return showLegend;},set:function(_){showLegend=_;}},staggerLabels:{get:function(){return staggerLabels;},set:function(_){staggerLabels=_;}},rotateLabels:{get:function(){return rotateLabels;},set:function(_){rotateLabels=_;}},wrapLabels:{get:function(){return wrapLabels;},set:function(_){wrapLabels=!!_;}},showXAxis:{get:function(){return showXAxis;},set:function(_){showXAxis=_;}},showYAxis:{get:function(){return showYAxis;},set:function(_){showYAxis=_;}},noData:{get:function(){return noData;},set:function(_){noData=_;}},margin:{get:function(){return margin;},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left;}},duration:{get:function(){return duration;},set:function(_){duration=_;renderWatch.reset(duration);discretebar.duration(duration);xAxis.duration(duration);yAxis.duration(duration);}},color:{get:function(){return color;},set:function(_){color=nv.utils.getColor(_);discretebar.color(color);legend.color(color);}},rightAlignYAxis:{get:function(){return rightAlignYAxis;},set:function(_){rightAlignYAxis=_;yAxis.orient((_)?'right':'left');}}});nv.utils.inheritOptions(chart,discretebar);nv.utils.initOptions(chart);return chart;}
nv.models.pieChart=function(){"use strict";var pie=nv.models.pie();var legend=nv.models.legend();var tooltip=nv.models.tooltip();var margin={top:30,right:20,bottom:20,left:20},width=null,height=null,showLegend=true,legendPosition="top",color=nv.utils.defaultColor(),state=nv.utils.state(),defaultState=null,noData=null,duration=250,dispatch=d3.dispatch('stateChange','changeState','renderEnd');tooltip.duration(0).headerEnabled(false).valueFormatter(function(d,i){return pie.valueFormat()(d,i);});var renderWatch=nv.utils.renderWatch(dispatch);var stateGetter=function(data){return function(){return{active:data.map(function(d){return!d.disabled})};}};var stateSetter=function(data){return function(state){if(state.active!==undefined){data.forEach(function(series,i){series.disabled=!state.active[i];});}}};function chart(selection){renderWatch.reset();renderWatch.models(pie);selection.each(function(data){var container=d3.select(this);nv.utils.initSVG(container);var that=this;var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);chart.update=function(){container.transition().call(chart);};chart.container=this;state.setter(stateSetter(data),chart.update).getter(stateGetter(data)).update();state.disabled=data.map(function(d){return!!d.disabled});if(!defaultState){var key;defaultState={};for(key in state){if(state[key]instanceof Array)
defaultState[key]=state[key].slice(0);else
defaultState[key]=state[key];}}
if(!data||!data.length){nv.utils.noData(chart,container);return chart;}else{container.selectAll('.nv-noData').remove();}
var wrap=container.selectAll('g.nv-wrap.nv-pieChart').data([data]);var gEnter=wrap.enter().append('g').attr('class','nvd3 nv-wrap nv-pieChart').append('g');var g=wrap.select('g');gEnter.append('g').attr('class','nv-pieWrap');gEnter.append('g').attr('class','nv-legendWrap');if(!showLegend){g.select('.nv-legendWrap').selectAll('*').remove();}else{if(legendPosition==="top"){legend.width(availableWidth).key(pie.x());wrap.select('.nv-legendWrap').datum(data).call(legend);if(margin.top!=legend.height()){margin.top=legend.height();availableHeight=nv.utils.availableHeight(height,container,margin);}
wrap.select('.nv-legendWrap').attr('transform','translate(0,'+(-margin.top)+')');}else if(legendPosition==="right"){var legendWidth=nv.models.legend().width();if(availableWidth/2<legendWidth){legendWidth=(availableWidth/2)}
legend.height(availableHeight).key(pie.x());legend.width(legendWidth);availableWidth-=legend.width();wrap.select('.nv-legendWrap').datum(data).call(legend).attr('transform','translate('+(availableWidth)+',0)');}}
wrap.attr('transform','translate('+margin.left+','+margin.top+')');pie.width(availableWidth).height(availableHeight);var pieWrap=g.select('.nv-pieWrap').datum([data]);d3.transition(pieWrap).call(pie);legend.dispatch.on('stateChange',function(newState){for(var key in newState){state[key]=newState[key];}
dispatch.stateChange(state);chart.update();});dispatch.on('changeState',function(e){if(typeof e.disabled!=='undefined'){data.forEach(function(series,i){series.disabled=e.disabled[i];});state.disabled=e.disabled;}
chart.update();});});renderWatch.renderEnd('pieChart immediate');return chart;}
pie.dispatch.on('elementMouseover.tooltip',function(evt){evt['series']={key:chart.x()(evt.data),value:chart.y()(evt.data),color:evt.color};tooltip.data(evt).hidden(false);});pie.dispatch.on('elementMouseout.tooltip',function(evt){tooltip.hidden(true);});pie.dispatch.on('elementMousemove.tooltip',function(evt){tooltip();});chart.legend=legend;chart.dispatch=dispatch;chart.pie=pie;chart.tooltip=tooltip;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width;},set:function(_){width=_;}},height:{get:function(){return height;},set:function(_){height=_;}},noData:{get:function(){return noData;},set:function(_){noData=_;}},showLegend:{get:function(){return showLegend;},set:function(_){showLegend=_;}},legendPosition:{get:function(){return legendPosition;},set:function(_){legendPosition=_;}},defaultState:{get:function(){return defaultState;},set:function(_){defaultState=_;}},color:{get:function(){return color;},set:function(_){color=_;legend.color(color);pie.color(color);}},duration:{get:function(){return duration;},set:function(_){duration=_;renderWatch.reset(duration);}},margin:{get:function(){return margin;},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left;}}});nv.utils.inheritOptions(chart,pie);nv.utils.initOptions(chart);return chart;};nv.models.discreteBar=function(){"use strict";var margin={top:0,right:0,bottom:0,left:0},width=960,height=500,id=Math.floor(Math.random()*10000),container,x=d3.scale.ordinal(),y=d3.scale.linear(),getX=function(d){return d.x},getY=function(d){return d.y},forceY=[0],color=nv.utils.defaultColor(),showValues=false,valueFormat=d3.format(',.2f'),xDomain,yDomain,xRange,yRange,dispatch=d3.dispatch('chartClick','elementClick','elementDblClick','elementMouseover','elementMouseout','elementMousemove','renderEnd'),rectClass='discreteBar',duration=250;var x0,y0;var renderWatch=nv.utils.renderWatch(dispatch,duration);function chart(selection){renderWatch.reset();selection.each(function(data){var availableWidth=width-margin.left-margin.right,availableHeight=height-margin.top-margin.bottom;container=d3.select(this);nv.utils.initSVG(container);data.forEach(function(series,i){series.values.forEach(function(point){point.series=i;});});var seriesData=(xDomain&&yDomain)?[]:data.map(function(d){return d.values.map(function(d,i){return{x:getX(d,i),y:getY(d,i),y0:d.y0}})});x.domain(xDomain||d3.merge(seriesData).map(function(d){return d.x})).rangeBands(xRange||[0,availableWidth],.1);y.domain(yDomain||d3.extent(d3.merge(seriesData).map(function(d){return d.y}).concat(forceY)));if(showValues)y.range(yRange||[availableHeight-(y.domain()[0]<0?12:0),y.domain()[1]>0?12:0]);else y.range(yRange||[availableHeight,0]);x0=x0||x;y0=y0||y.copy().range([y(0),y(0)]);var wrap=container.selectAll('g.nv-wrap.nv-discretebar').data([data]);var wrapEnter=wrap.enter().append('g').attr('class','nvd3 nv-wrap nv-discretebar');var gEnter=wrapEnter.append('g');var g=wrap.select('g');gEnter.append('g').attr('class','nv-groups');wrap.attr('transform','translate('+margin.left+','+margin.top+')');var groups=wrap.select('.nv-groups').selectAll('.nv-group').data(function(d){return d},function(d){return d.key});groups.enter().append('g').style('stroke-opacity',1e-6).style('fill-opacity',1e-6);groups.exit().watchTransition(renderWatch,'discreteBar: exit groups').style('stroke-opacity',1e-6).style('fill-opacity',1e-6).remove();groups.attr('class',function(d,i){return'nv-group nv-series-'+i}).classed('hover',function(d){return d.hover});groups.watchTransition(renderWatch,'discreteBar: groups').style('stroke-opacity',1).style('fill-opacity',.75);var bars=groups.selectAll('g.nv-bar').data(function(d){return d.values});bars.exit().remove();var barsEnter=bars.enter().append('g').attr('transform',function(d,i,j){return'translate('+(x(getX(d,i))+x.rangeBand()*.05)+', '+y(0)+')'}).on('mouseover',function(d,i){d3.select(this).classed('hover',true);dispatch.elementMouseover({data:d,index:i,color:d3.select(this).style("fill")});}).on('mouseout',function(d,i){d3.select(this).classed('hover',false);dispatch.elementMouseout({data:d,index:i,color:d3.select(this).style("fill")});}).on('mousemove',function(d,i){dispatch.elementMousemove({data:d,index:i,color:d3.select(this).style("fill")});}).on('click',function(d,i){var element=this;dispatch.elementClick({data:d,index:i,color:d3.select(this).style("fill"),event:d3.event,element:element});d3.event.stopPropagation();}).on('dblclick',function(d,i){dispatch.elementDblClick({data:d,index:i,color:d3.select(this).style("fill")});d3.event.stopPropagation();});barsEnter.append('rect').attr('height',0).attr('width',x.rangeBand()*.9/data.length)
if(showValues){barsEnter.append('text').attr('text-anchor','middle');bars.select('text').text(function(d,i){return valueFormat(getY(d,i))}).watchTransition(renderWatch,'discreteBar: bars text').attr('x',x.rangeBand()*.9/2).attr('y',function(d,i){return getY(d,i)<0?y(getY(d,i))-y(0)+12:-4});}else{bars.selectAll('text').remove();}
bars.attr('class',function(d,i){return getY(d,i)<0?'nv-bar negative':'nv-bar positive'}).style('fill',function(d,i){return d.color||color(d,i)}).style('stroke',function(d,i){return d.color||color(d,i)}).select('rect').attr('class',rectClass).watchTransition(renderWatch,'discreteBar: bars rect').attr('width',x.rangeBand()*.9/data.length);bars.watchTransition(renderWatch,'discreteBar: bars').attr('transform',function(d,i){var left=x(getX(d,i))+x.rangeBand()*.05,top=getY(d,i)<0?y(0):y(0)-y(getY(d,i))<1?y(0)-1:y(getY(d,i));return'translate('+left+', '+top+')'}).select('rect').attr('height',function(d,i){return Math.max(Math.abs(y(getY(d,i))-y(0)),1)});x0=x.copy();y0=y.copy();});renderWatch.renderEnd('discreteBar immediate');return chart;}
chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width;},set:function(_){width=_;}},height:{get:function(){return height;},set:function(_){height=_;}},forceY:{get:function(){return forceY;},set:function(_){forceY=_;}},showValues:{get:function(){return showValues;},set:function(_){showValues=_;}},x:{get:function(){return getX;},set:function(_){getX=_;}},y:{get:function(){return getY;},set:function(_){getY=_;}},xScale:{get:function(){return x;},set:function(_){x=_;}},yScale:{get:function(){return y;},set:function(_){y=_;}},xDomain:{get:function(){return xDomain;},set:function(_){xDomain=_;}},yDomain:{get:function(){return yDomain;},set:function(_){yDomain=_;}},xRange:{get:function(){return xRange;},set:function(_){xRange=_;}},yRange:{get:function(){return yRange;},set:function(_){yRange=_;}},valueFormat:{get:function(){return valueFormat;},set:function(_){valueFormat=_;}},id:{get:function(){return id;},set:function(_){id=_;}},rectClass:{get:function(){return rectClass;},set:function(_){rectClass=_;}},margin:{get:function(){return margin;},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left;}},color:{get:function(){return color;},set:function(_){color=nv.utils.getColor(_);}},duration:{get:function(){return duration;},set:function(_){duration=_;renderWatch.reset(duration);}}});nv.utils.initOptions(chart);return chart;};nv.models.multiBarChart=function(){"use strict";var multibar=nv.models.multiBar(),xAxis=nv.models.axis(),yAxis=nv.models.axis(),interactiveLayer=nv.interactiveGuideline(),legend=nv.models.legend(),controls=nv.models.legend(),tooltip=nv.models.tooltip();var margin={top:30,right:20,bottom:50,left:60},width=null,height=null,color=nv.utils.defaultColor(),showControls=true,controlLabels={},showLegend=true,showXAxis=true,showYAxis=true,rightAlignYAxis=false,reduceXTicks=true,staggerLabels=false,wrapLabels=false,rotateLabels=0,x,y,state=nv.utils.state(),defaultState=null,noData=null,dispatch=d3.dispatch('stateChange','changeState','renderEnd'),controlWidth=function(){return showControls?180:0},duration=250,useInteractiveGuideline=false;state.stacked=false
multibar.stacked(false);xAxis.orient('bottom').tickPadding(7).showMaxMin(false).tickFormat(function(d){return d});yAxis.orient((rightAlignYAxis)?'right':'left').tickFormat(d3.format(',.1f'));tooltip.duration(0).valueFormatter(function(d,i){return yAxis.tickFormat()(d,i);}).headerFormatter(function(d,i){return xAxis.tickFormat()(d,i);});controls.updateState(false);var renderWatch=nv.utils.renderWatch(dispatch);var stacked=false;var stateGetter=function(data){return function(){return{active:data.map(function(d){return!d.disabled}),stacked:stacked};}};var stateSetter=function(data){return function(state){if(state.stacked!==undefined)
stacked=state.stacked;if(state.active!==undefined)
data.forEach(function(series,i){series.disabled=!state.active[i];});}};function chart(selection){renderWatch.reset();renderWatch.models(multibar);if(showXAxis)renderWatch.models(xAxis);if(showYAxis)renderWatch.models(yAxis);selection.each(function(data){var container=d3.select(this),that=this;nv.utils.initSVG(container);var availableWidth=nv.utils.availableWidth(width,container,margin),availableHeight=nv.utils.availableHeight(height,container,margin);chart.update=function(){if(duration===0)
container.call(chart);else
container.transition().duration(duration).call(chart);};chart.container=this;state.setter(stateSetter(data),chart.update).getter(stateGetter(data)).update();state.disabled=data.map(function(d){return!!d.disabled});if(!defaultState){var key;defaultState={};for(key in state){if(state[key]instanceof Array)
defaultState[key]=state[key].slice(0);else
defaultState[key]=state[key];}}
if(!data||!data.length||!data.filter(function(d){return d.values.length}).length){nv.utils.noData(chart,container)
return chart;}else{container.selectAll('.nv-noData').remove();}
x=multibar.xScale();y=multibar.yScale();var wrap=container.selectAll('g.nv-wrap.nv-multiBarWithLegend').data([data]);var gEnter=wrap.enter().append('g').attr('class','nvd3 nv-wrap nv-multiBarWithLegend').append('g');var g=wrap.select('g');gEnter.append('g').attr('class','nv-x nv-axis');gEnter.append('g').attr('class','nv-y nv-axis');gEnter.append('g').attr('class','nv-barsWrap');gEnter.append('g').attr('class','nv-legendWrap');gEnter.append('g').attr('class','nv-controlsWrap');gEnter.append('g').attr('class','nv-interactive');if(!showLegend){g.select('.nv-legendWrap').selectAll('*').remove();}else{legend.width(availableWidth-controlWidth());g.select('.nv-legendWrap').datum(data).call(legend);if(margin.top!=legend.height()){margin.top=legend.height();availableHeight=nv.utils.availableHeight(height,container,margin);}
g.select('.nv-legendWrap').attr('transform','translate('+controlWidth()+','+(-margin.top)+')');}
if(!showControls){g.select('.nv-controlsWrap').selectAll('*').remove();}else{var controlsData=[{key:controlLabels.grouped||'Grouped',disabled:multibar.stacked()},{key:controlLabels.stacked||'Stacked',disabled:!multibar.stacked()}];controls.width(controlWidth()).color(['#444','#444','#444']);g.select('.nv-controlsWrap').datum(controlsData).attr('transform','translate(0,'+(-margin.top)+')').call(controls);}
wrap.attr('transform','translate('+margin.left+','+margin.top+')');if(rightAlignYAxis){g.select(".nv-y.nv-axis").attr("transform","translate("+availableWidth+",0)");}
multibar.disabled(data.map(function(series){return series.disabled})).width(availableWidth).height(availableHeight).color(data.map(function(d,i){return d.color||color(d,i);}).filter(function(d,i){return!data[i].disabled}));var barsWrap=g.select('.nv-barsWrap').datum(data.filter(function(d){return!d.disabled}));barsWrap.call(multibar);if(showXAxis){xAxis.scale(x)._ticks(nv.utils.calcTicksX(availableWidth/100,data)).tickSize(-availableHeight,0);g.select('.nv-x.nv-axis').attr('transform','translate(0,'+y.range()[0]+')');g.select('.nv-x.nv-axis').call(xAxis);var xTicks=g.select('.nv-x.nv-axis > g').selectAll('g');xTicks.selectAll('line, text').style('opacity',1)
if(staggerLabels){var getTranslate=function(x,y){return"translate("+x+","+y+")";};var staggerUp=5,staggerDown=17;xTicks.selectAll("text").attr('transform',function(d,i,j){return getTranslate(0,(j%2==0?staggerUp:staggerDown));});var totalInBetweenTicks=d3.selectAll(".nv-x.nv-axis .nv-wrap g g text")[0].length;g.selectAll(".nv-x.nv-axis .nv-axisMaxMin text").attr("transform",function(d,i){return getTranslate(0,(i===0||totalInBetweenTicks%2!==0)?staggerDown:staggerUp);});}
if(wrapLabels){g.selectAll('.tick text').call(nv.utils.wrapTicks,chart.xAxis.rangeBand())}
if(reduceXTicks)
xTicks.filter(function(d,i){return i%Math.ceil(data[0].values.length/(availableWidth/100))!==0;}).selectAll('text, line').style('opacity',0);if(rotateLabels)
xTicks.selectAll('.tick text').attr('transform','rotate('+rotateLabels+' 0,0)').style('text-anchor',rotateLabels>0?'start':'end');g.select('.nv-x.nv-axis').selectAll('g.nv-axisMaxMin text').style('opacity',1);}
if(showYAxis){yAxis.scale(y)._ticks(nv.utils.calcTicksY(availableHeight/36,data)).tickSize(-availableWidth,0);g.select('.nv-y.nv-axis').call(yAxis);}
if(useInteractiveGuideline){interactiveLayer.width(availableWidth).height(availableHeight).margin({left:margin.left,top:margin.top}).svgContainer(container).xScale(x);wrap.select(".nv-interactive").call(interactiveLayer);}
legend.dispatch.on('stateChange',function(newState){for(var key in newState)
state[key]=newState[key];dispatch.stateChange(state);chart.update();});controls.dispatch.on('legendClick',function(d,i){if(!d.disabled)return;controlsData=controlsData.map(function(s){s.disabled=true;return s;});d.disabled=false;switch(d.key){case'Grouped':case controlLabels.grouped:multibar.stacked(false);break;case'Stacked':case controlLabels.stacked:multibar.stacked(true);break;}
state.stacked=multibar.stacked();dispatch.stateChange(state);chart.update();});dispatch.on('changeState',function(e){if(typeof e.disabled!=='undefined'){data.forEach(function(series,i){series.disabled=e.disabled[i];});state.disabled=e.disabled;}
if(typeof e.stacked!=='undefined'){multibar.stacked(e.stacked);state.stacked=e.stacked;stacked=e.stacked;}
chart.update();});if(useInteractiveGuideline){interactiveLayer.dispatch.on('elementMousemove',function(e){if(e.pointXValue==undefined)return;var singlePoint,pointIndex,pointXLocation,xValue,allData=[];data.filter(function(series,i){series.seriesIndex=i;return!series.disabled;}).forEach(function(series,i){pointIndex=x.domain().indexOf(e.pointXValue)
var point=series.values[pointIndex];if(point===undefined)return;xValue=point.x;if(singlePoint===undefined)singlePoint=point;if(pointXLocation===undefined)pointXLocation=e.mouseX
allData.push({key:series.key,value:chart.y()(point,pointIndex),color:color(series,series.seriesIndex),data:series.values[pointIndex]});});interactiveLayer.tooltip.chartContainer(that.parentNode).data({value:xValue,index:pointIndex,series:allData})();interactiveLayer.renderGuideLine(pointXLocation);});interactiveLayer.dispatch.on("elementMouseout",function(e){interactiveLayer.tooltip.hidden(true);});}
else{multibar.dispatch.on('elementMouseover.tooltip',function(evt){evt.value=chart.x()(evt.data);evt['series']={key:evt.data.key,value:chart.y()(evt.data),color:evt.color};tooltip.data(evt).hidden(false);});multibar.dispatch.on('elementMouseout.tooltip',function(evt){tooltip.hidden(true);});multibar.dispatch.on('elementMousemove.tooltip',function(evt){tooltip();});}});renderWatch.renderEnd('multibarchart immediate');return chart;}
chart.dispatch=dispatch;chart.multibar=multibar;chart.legend=legend;chart.controls=controls;chart.xAxis=xAxis;chart.yAxis=yAxis;chart.state=state;chart.tooltip=tooltip;chart.interactiveLayer=interactiveLayer;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{width:{get:function(){return width;},set:function(_){width=_;}},height:{get:function(){return height;},set:function(_){height=_;}},showLegend:{get:function(){return showLegend;},set:function(_){showLegend=_;}},showControls:{get:function(){return showControls;},set:function(_){showControls=_;}},controlLabels:{get:function(){return controlLabels;},set:function(_){controlLabels=_;}},showXAxis:{get:function(){return showXAxis;},set:function(_){showXAxis=_;}},showYAxis:{get:function(){return showYAxis;},set:function(_){showYAxis=_;}},defaultState:{get:function(){return defaultState;},set:function(_){defaultState=_;}},noData:{get:function(){return noData;},set:function(_){noData=_;}},reduceXTicks:{get:function(){return reduceXTicks;},set:function(_){reduceXTicks=_;}},rotateLabels:{get:function(){return rotateLabels;},set:function(_){rotateLabels=_;}},staggerLabels:{get:function(){return staggerLabels;},set:function(_){staggerLabels=_;}},wrapLabels:{get:function(){return wrapLabels;},set:function(_){wrapLabels=!!_;}},margin:{get:function(){return margin;},set:function(_){margin.top=_.top!==undefined?_.top:margin.top;margin.right=_.right!==undefined?_.right:margin.right;margin.bottom=_.bottom!==undefined?_.bottom:margin.bottom;margin.left=_.left!==undefined?_.left:margin.left;}},duration:{get:function(){return duration;},set:function(_){duration=_;multibar.duration(duration);xAxis.duration(duration);yAxis.duration(duration);renderWatch.reset(duration);}},color:{get:function(){return color;},set:function(_){color=nv.utils.getColor(_);legend.color(color);}},rightAlignYAxis:{get:function(){return rightAlignYAxis;},set:function(_){rightAlignYAxis=_;yAxis.orient(rightAlignYAxis?'right':'left');}},useInteractiveGuideline:{get:function(){return useInteractiveGuideline;},set:function(_){useInteractiveGuideline=_;}},barColor:{get:function(){return multibar.barColor;},set:function(_){multibar.barColor(_);legend.color(function(d,i){return d3.rgb('#ccc').darker(i*1.5).toString();})}}});nv.utils.inheritOptions(chart,multibar);nv.utils.initOptions(chart);return chart;};nv.models.pie=function(){"use strict";var margin={top:0,right:0,bottom:0,left:0},width=500,height=500,getX=function(d){return d.x},getY=function(d){return d.y},id=Math.floor(Math.random()*10000),container=null,color=nv.utils.defaultColor(),valueFormat=d3.format(',.2f'),showLabels=true,labelsOutside=false,labelType="key",labelThreshold=.02,donut=false,title=false,growOnHover=true,titleOffset=0,labelSunbeamLayout=false,startAngle=false,padAngle=false,endAngle=false,cornerRadius=0,donutRatio=0.5,arcsRadius=[],dispatch=d3.dispatch('chartClick','elementClick','elementDblClick','elementMouseover','elementMouseout','elementMousemove','renderEnd');var arcs=[];var arcsOver=[];var renderWatch=nv.utils.renderWatch(dispatch);function chart(selection){renderWatch.reset();selection.each(function(data){var availableWidth=width-margin.left-margin.right,availableHeight=height-margin.top-margin.bottom,radius=Math.min(availableWidth,availableHeight)/2,arcsRadiusOuter=[],arcsRadiusInner=[];container=d3.select(this)
if(arcsRadius.length===0){var outer=radius-radius/5;var inner=donutRatio*radius;for(var i=0;i<data[0].length;i++){arcsRadiusOuter.push(outer);arcsRadiusInner.push(inner);}}else{if(growOnHover){arcsRadiusOuter=arcsRadius.map(function(d){return(d.outer-d.outer/5)*radius;});arcsRadiusInner=arcsRadius.map(function(d){return(d.inner-d.inner/5)*radius;});donutRatio=d3.min(arcsRadius.map(function(d){return(d.inner-d.inner/5);}));}else{arcsRadiusOuter=arcsRadius.map(function(d){return d.outer*radius;});arcsRadiusInner=arcsRadius.map(function(d){return d.inner*radius;});donutRatio=d3.min(arcsRadius.map(function(d){return d.inner;}));}}
nv.utils.initSVG(container);var wrap=container.selectAll('.nv-wrap.nv-pie').data(data);var wrapEnter=wrap.enter().append('g').attr('class','nvd3 nv-wrap nv-pie nv-chart-'+id);var gEnter=wrapEnter.append('g');var g=wrap.select('g');var g_pie=gEnter.append('g').attr('class','nv-pie');gEnter.append('g').attr('class','nv-pieLabels');wrap.attr('transform','translate('+margin.left+','+margin.top+')');g.select('.nv-pie').attr('transform','translate('+availableWidth/2+','+availableHeight/2+')');g.select('.nv-pieLabels').attr('transform','translate('+availableWidth/2+','+availableHeight/2+')');container.on('click',function(d,i){dispatch.chartClick({data:d,index:i,pos:d3.event,id:id});});arcs=[];arcsOver=[];for(var i=0;i<data[0].length;i++){var arc=d3.svg.arc().outerRadius(arcsRadiusOuter[i]);var arcOver=d3.svg.arc().outerRadius(arcsRadiusOuter[i]+5);if(startAngle!==false){arc.startAngle(startAngle);arcOver.startAngle(startAngle);}
if(endAngle!==false){arc.endAngle(endAngle);arcOver.endAngle(endAngle);}
if(donut){arc.innerRadius(arcsRadiusInner[i]);arcOver.innerRadius(arcsRadiusInner[i]);}
if(arc.cornerRadius&&cornerRadius){arc.cornerRadius(cornerRadius);arcOver.cornerRadius(cornerRadius);}
arcs.push(arc);arcsOver.push(arcOver);}
var pie=d3.layout.pie().sort(null).value(function(d){return d.disabled?0:getY(d)});if(pie.padAngle&&padAngle){pie.padAngle(padAngle);}
if(donut&&title){g_pie.append("text").attr('class','nv-pie-title');wrap.select('.nv-pie-title').style("text-anchor","middle").text(function(d){return title;}).style("font-size",(Math.min(availableWidth,availableHeight))*donutRatio*2/(title.length+2)+"px").attr("dy","0.35em").attr('transform',function(d,i){return'translate(0, '+titleOffset+')';});}
var slices=wrap.select('.nv-pie').selectAll('.nv-slice').data(pie);var pieLabels=wrap.select('.nv-pieLabels').selectAll('.nv-label').data(pie);slices.exit().remove();pieLabels.exit().remove();var ae=slices.enter().append('g');ae.attr('class','nv-slice');ae.on('mouseover',function(d,i){d3.select(this).classed('hover',true);if(growOnHover){d3.select(this).select("path").transition().duration(70).attr("d",arcsOver[i]);}
dispatch.elementMouseover({data:d.data,index:i,color:d3.select(this).style("fill")});});ae.on('mouseout',function(d,i){d3.select(this).classed('hover',false);if(growOnHover){d3.select(this).select("path").transition().duration(50).attr("d",arcs[i]);}
dispatch.elementMouseout({data:d.data,index:i});});ae.on('mousemove',function(d,i){dispatch.elementMousemove({data:d.data,index:i});});ae.on('click',function(d,i){var element=this;dispatch.elementClick({data:d.data,index:i,color:d3.select(this).style("fill"),event:d3.event,element:element});});ae.on('dblclick',function(d,i){dispatch.elementDblClick({data:d.data,index:i,color:d3.select(this).style("fill")});});slices.attr('fill',function(d,i){return color(d.data,i);});slices.attr('stroke',function(d,i){return color(d.data,i);});var paths=ae.append('path').each(function(d){this._current=d;});slices.select('path').transition().attr('d',function(d,i){return arcs[i](d);}).attrTween('d',arcTween);if(showLabels){var labelsArc=[];for(var i=0;i<data[0].length;i++){labelsArc.push(arcs[i]);if(labelsOutside){if(donut){labelsArc[i]=d3.svg.arc().outerRadius(arcs[i].outerRadius());if(startAngle!==false)labelsArc[i].startAngle(startAngle);if(endAngle!==false)labelsArc[i].endAngle(endAngle);}}else if(!donut){labelsArc[i].innerRadius(0);}}
pieLabels.enter().append("g").classed("nv-label",true).each(function(d,i){var group=d3.select(this);group.attr('transform',function(d,i){if(labelSunbeamLayout){d.outerRadius=arcsRadiusOuter[i]+10;d.innerRadius=arcsRadiusOuter[i]+15;var rotateAngle=(d.startAngle+d.endAngle)/2*(180/Math.PI);if((d.startAngle+d.endAngle)/2<Math.PI){rotateAngle-=90;}else{rotateAngle+=90;}
return'translate('+labelsArc[i].centroid(d)+') rotate('+rotateAngle+')';}else{d.outerRadius=radius+10;d.innerRadius=radius+15;return'translate('+labelsArc[i].centroid(d)+')'}});group.append('rect').style('stroke','#fff').style('fill','#fff').attr("rx",3).attr("ry",3);group.append('text').style('text-anchor',labelSunbeamLayout?((d.startAngle+d.endAngle)/2<Math.PI?'start':'end'):'middle').style('fill','#000')});var labelLocationHash={};var avgHeight=14;var avgWidth=140;var createHashKey=function(coordinates){return Math.floor(coordinates[0]/avgWidth)*avgWidth+','+Math.floor(coordinates[1]/avgHeight)*avgHeight;};var getSlicePercentage=function(d){return(d.endAngle-d.startAngle)/(2*Math.PI);};pieLabels.watchTransition(renderWatch,'pie labels').attr('transform',function(d,i){if(labelSunbeamLayout){d.outerRadius=arcsRadiusOuter[i]+10;d.innerRadius=arcsRadiusOuter[i]+15;var rotateAngle=(d.startAngle+d.endAngle)/2*(180/Math.PI);if((d.startAngle+d.endAngle)/2<Math.PI){rotateAngle-=90;}else{rotateAngle+=90;}
return'translate('+labelsArc[i].centroid(d)+') rotate('+rotateAngle+')';}else{d.outerRadius=radius+10;d.innerRadius=radius+15;var center=labelsArc[i].centroid(d);var percent=getSlicePercentage(d);if(d.value&&percent>=labelThreshold){var hashKey=createHashKey(center);if(labelLocationHash[hashKey]){center[1]-=avgHeight;}
labelLocationHash[createHashKey(center)]=true;}
return'translate('+center+')'}});pieLabels.select(".nv-label text").style('text-anchor',function(d,i){return labelSunbeamLayout?((d.startAngle+d.endAngle)/2<Math.PI?'start':'end'):'middle';}).text(function(d,i){var percent=getSlicePercentage(d);var label='';if(!d.value||percent<labelThreshold)return'';if(typeof labelType==='function'){label=labelType(d,i,{'key':getX(d.data),'value':getY(d.data),'percent':valueFormat(percent)});}else{switch(labelType){case'key':label=getX(d.data);break;case'value':label=valueFormat(getY(d.data));break;case'percent':label=d3.format('%')(percent);break;}}
return label;});}
function angle(d){var a=(d.startAngle+d.endAngle)*90/Math.PI-90;return a>90?a-180:a;}
function arcTween(a,idx){a.endAngle=isNaN(a.endAngle)?0:a.endAngle;a.startAngle=isNaN(a.startAngle)?0:a.startAngle;if(!donut)a.innerRadius=0;var i=d3.interpolate(this._current,a);this._current=i(0);return function(t){return arcs[idx](i(t));};}});renderWatch.renderEnd('pie immediate');return chart;}
chart.dispatch=dispatch;chart.options=nv.utils.optionsFunc.bind(chart);chart._options=Object.create({},{arcsRadius:{get:function(){return arcsRadius;},set:function(_){arcsRadius=_;}},width:{get:function(){return width;},set:function(_){width=_;}},height:{get:function(){return height;},set:function(_){height=_;}},showLabels:{get:function(){return showLabels;},set:function(_){showLabels=_;}},title:{get:function(){return title;},set:function(_){title=_;}},titleOffset:{get:function(){return titleOffset;},set:function(_){titleOffset=_;}},labelThreshold:{get:function(){return labelThreshold;},set:function(_){labelThreshold=_;}},valueFormat:{get:function(){return valueFormat;},set:function(_){valueFormat=_;}},x:{get:function(){return getX;},set:function(_){getX=_;}},id:{get:function(){return id;},set:function(_){id=_;}},endAngle:{get:function(){return endAngle;},set:function(_){endAngle=_;}},startAngle:{get:function(){return startAngle;},set:function(_){startAngle=_;}},padAngle:{get:function(){return padAngle;},set:function(_){padAngle=_;}},cornerRadius:{get:function(){return cornerRadius;},set:function(_){cornerRadius=_;}},donutRatio:{get:function(){return donutRatio;},set:function(_){donutRatio=_;}},labelsOutside:{get:function(){return labelsOutside;},set:function(_){labelsOutside=_;}},labelSunbeamLayout:{get:function(){return labelSunbeamLayout;},set:function(_){labelSunbeamLayout=_;}},donut:{get:function(){return donut;},set:function(_){donut=_;}},growOnHover:{get:function(){return growOnHover;},set:function(_){growOnHover=_;}},pieLabelsOutside:{get:function(){return labelsOutside;},set:function(_){labelsOutside=_;nv.deprecated('pieLabelsOutside','use labelsOutside instead');}},donutLabelsOutside:{get:function(){return labelsOutside;},set:function(_){labelsOutside=_;nv.deprecated('donutLabelsOutside','use labelsOutside instead');}},labelFormat:{get:function(){return valueFormat;},set:function(_){valueFormat=_;nv.deprecated('labelFormat','use valueFormat instead');}},margin:{get:function(){return margin;},set:function(_){margin.top=typeof _.top!='undefined'?_.top:margin.top;margin.right=typeof _.right!='undefined'?_.right:margin.right;margin.bottom=typeof _.bottom!='undefined'?_.bottom:margin.bottom;margin.left=typeof _.left!='undefined'?_.left:margin.left;}},y:{get:function(){return getY;},set:function(_){getY=d3.functor(_);}},color:{get:function(){return color;},set:function(_){color=nv.utils.getColor(_);}},labelType:{get:function(){return labelType;},set:function(_){labelType=_||'key';}}});nv.utils.initOptions(chart);return chart;};nv.version="1.8.2-dev";})();;

/* /survey/static/src/js/survey_result.js defined in bundle 'web.assets_frontend' */
odoo.define('survey.result',function(require){'use strict';require('web.dom_ready');if(!$('.js_surveyresult').length){return $.Deferred().reject("DOM doesn't contain '.js_surveyresult'");}
console.debug("[survey] Survey Result JS is loading...");var survey_pagination=$('.pagination');$.each(survey_pagination,function(index,pagination){var question_id=$(pagination).attr("data-question_id");var limit=$(pagination).attr("data-record_limit");$('#table_question_'+question_id+' tbody tr:lt('+limit+')').removeClass('hidden');$('#pagination_'+question_id+' li a').click(function(event){event.preventDefault();$('#pagination_'+question_id+' li').removeClass('active');$(this).parent('li').addClass('active');$('#table_question_'+question_id+' tbody tr').addClass('hidden');var num=$(this).text();var min=(limit*(num-1))-1;if(min==-1){$('#table_question_'+question_id+' tbody tr:lt('+limit*num+')').removeClass('hidden');}
else{$('#table_question_'+question_id+' tbody tr:lt('+limit*num+'):gt('+min+')').removeClass('hidden');}});$('#pagination_'+question_id+' li:first').addClass('active').find('a').click();});function init_multibar_chart(){var chart=nv.models.multiBarChart().x(function(d){return d.text;}).y(function(d){return d.count;}).staggerLabels(true);chart.tooltip(function(key,x,y,e){return'<h5 class="panel-primary"><div class="panel-heading">'+x+'</div></h5>'+'<p>'+'<b>Responses : </b>'+key+'</p>'+'<p>'+"<b>Total Vote : </b>"+y+'</p>';});return chart;}
function init_bar_chart(){var chart=nv.models.discreteBarChart().x(function(d){return d.text;}).y(function(d){return d.count;}).staggerLabels(true).showValues(true);chart.tooltip.enabled(false);return chart;}
function init_pie_chart(){return nv.models.pieChart().x(function(d){return d.text;}).y(function(d){return d.count;}).showLabels(false);}
function load_chart(chart,response,question_id,tick_limit,graph_type){var customtick_function=function(d){if(!this||d.length<=tick_limit){return d;}
else{return d.slice(0,tick_limit)+'...';}};if(graph_type!='pie'){chart.xAxis.tickFormat(customtick_function);chart.yAxis.tickFormat(d3.format('d'));}
d3.select('#graph_question_'+question_id+' svg').datum(response).transition().duration(500).call(chart);nv.utils.windowResize(chart.update);return chart;}
var survey_graphs=$('.survey_graph');$.each(survey_graphs,function(index,graph){var question_id=$(graph).attr("data-question_id");var graph_type=$(graph).attr("data-graph_type");var graph_data=JSON.parse($(graph).attr("graph-data"));if(graph_type=='multi_bar'){nv.addGraph(function(){var chart=init_multibar_chart();return load_chart(chart,graph_data,question_id,25);});}
else if(graph_type=='bar'){nv.addGraph(function(){var chart=init_bar_chart();return load_chart(chart,graph_data,question_id,35);});}
else if(graph_type=='pie'){nv.addGraph(function(){var chart=init_pie_chart();return load_chart(chart,graph_data,question_id,25,'pie');});}});$('td.survey_answer').hover(function(){$(this).find('i.fa-filter').removeClass('invisible');},function(){$(this).find('i.fa-filter').addClass('invisible');});$('td.survey_answer i.fa-filter').click(function(){var cell=$(this);var row_id=cell.attr('data-row_id')|0;var answer_id=cell.attr('data-answer_id');if(document.URL.indexOf("?")==-1){window.location.href=document.URL+'?'+encodeURI(row_id+','+answer_id);}
else{window.location.href=document.URL+'&'+encodeURI(row_id+','+answer_id);}});$('.clear_survey_filter').click(function(){window.location.href=document.URL.substring(0,document.URL.indexOf("?"));});$('span.filter-all').click(function(){event.preventDefault();if(document.URL.indexOf("finished")!=-1){window.location.href=document.URL.replace('?finished&','?').replace('&finished&','&').replace('?finished','').replace('&finished','');}}).hover(function(){if(document.URL.indexOf("finished")==-1){$(this)[0].style.cursor='default';}});$('span.filter-finished').click(function(){event.preventDefault();if(document.URL.indexOf("?")==-1){window.location.href=document.URL+'?'+encodeURI('finished');}
else if(document.URL.indexOf("finished")==-1){window.location.href=document.URL+'&'+encodeURI('finished');}}).hover(function(){if(document.URL.indexOf("finished")!=-1){$(this)[0].style.cursor='default';}});console.debug("[survey] Survey Result JS loaded!");});;

/* /mass_mailing_custom_unsubscribe/static/src/js/require_details.js defined in bundle 'web.assets_frontend' */
odoo.define("mass_mailing_custom_unsubscribe.require_details",function(require){"use strict";var animation=require("website.content.snippets.animation");animation.registry.mass_mailing_custom_unsubscribe_require_details=animation.Class.extend({selector:".js_unsubscription_reason",start:function(){this.$radio=this.$(":radio");this.$details=this.$("[name=details]");this.$radio.on("change click",$.proxy(this.toggle,this));this.$radio.filter(":checked").trigger("change");},toggle:function(event){this.$details.prop("required",$(event.target).is("[data-details-required]")&&$(event.target).is(":visible"));},});return animation.registry.mass_mailing_custom_unsubscribe_require_details;});;

/* /mass_mailing_custom_unsubscribe/static/src/js/unsubscribe.js defined in bundle 'web.assets_frontend' */
odoo.define("mass_mailing_custom_unsubscribe.unsubscribe",function(require){"use strict";var core=require("web.core");var ajax=require("web.ajax");var animation=require("website.content.snippets.animation");var _t=core._t;animation.registry.mass_mailing_unsubscribe=animation.Class.extend({selector:"#unsubscribe_form",start:function(){this.controller='/mail/mailing/unsubscribe';this.$alert=this.$(".alert");this.$email=this.$("input[name='email']");this.$contacts=this.$("input[name='contact_ids']");this.$mailing_id=this.$("input[name='mailing_id']");this.$token=this.$("input[name='token']");this.$res_id=this.$("input[name='res_id']");this.$reasons=this.$(".js_unsubscription_reason");this.$details=this.$reasons.find("[name='details']");this.$el.on("submit",$.proxy(this.submit,this));this.$contacts.on("change",$.proxy(this.toggle_reasons,this));this.toggle_reasons();},int_val:function(index,element){return parseInt($(element).val(),10);},contact_ids:function(checked){var filter=checked?":checked":":not(:checked)";return this.$contacts.filter(filter).map(this.int_val).get();},toggle_reasons:function(){var $disabled=this.$contacts.filter(function(){var $this=$(this);return!$this.prop("checked")&&$this.attr("checked");});this.$reasons.toggleClass("hidden",!$disabled.length);var $radios=this.$reasons.find(":radio");if(this.$reasons.is(":hidden")){$radios.prop("checked",false).prop("required",false).trigger("change");}else{$radios.prop("required",true);}},values:function(){var result={email:this.$email.val(),mailing_id:parseInt(this.$mailing_id.val(),10),opt_in_ids:this.contact_ids(true),opt_out_ids:this.contact_ids(false),res_id:parseInt(this.$res_id.val(),10),token:this.$token.val(),};if(this.$reasons.is(":visible")){result.reason_id=parseInt(this.$reasons.find("[name='reason_id']:checked").val(),10);result.details=this.$details.val();}
return result;},submit:function(event){event.preventDefault();return ajax.jsonRpc(this.controller,"call",this.values()).done($.proxy(this.success,this)).fail($.proxy(this.failure,this));},success:function(){this.$alert.html(_t('Your changes have been saved.')).removeClass("alert-info alert-warning").addClass("alert-success");this.$contacts.each(function(){var $this=$(this);$this.attr("checked",$this.prop("checked"));});this.toggle_reasons();},failure:function(){this.$alert.html(_t('Your changes have not been saved, try again later.')).removeClass("alert-info alert-success").addClass("alert-warning");},});return animation.registry.mass_mailing_unsubscribe;});;

/* /theme_crafito/static/src/js/plugins/waypoints.min.js defined in bundle 'web.assets_frontend' */
(function(){var t=[].indexOf||function(t){for(var e=0,n=this.length;e<n;e++){if(e in this&&this[e]===t)return e}return-1},e=[].slice;(function(t,e){if(typeof define==="function"&&define.amd){return define("waypoints",["jquery"],function(n){return e(n,t)})}else{return e(t.jQuery,t)}})(this,function(n,r){var i,o,l,s,f,u,a,c,h,d,p,y,v,w,g,m;i=n(r);c=t.call(r,"ontouchstart")>=0;s={horizontal:{},vertical:{}};f=1;a={};u="waypoints-context-id";p="resize.waypoints";y="scroll.waypoints";v=1;w="waypoints-waypoint-ids";g="waypoint";m="waypoints";o=function(){function t(t){var e=this;this.$element=t;this.element=t[0];this.didResize=false;this.didScroll=false;this.id="context"+f++;this.oldScroll={x:t.scrollLeft(),y:t.scrollTop()};this.waypoints={horizontal:{},vertical:{}};t.data(u,this.id);a[this.id]=this;t.bind(y,function(){var t;if(!(e.didScroll||c)){e.didScroll=true;t=function(){e.doScroll();return e.didScroll=false};return r.setTimeout(t,n[m].settings.scrollThrottle)}});t.bind(p,function(){var t;if(!e.didResize){e.didResize=true;t=function(){n[m]("refresh");return e.didResize=false};return r.setTimeout(t,n[m].settings.resizeThrottle)}})}t.prototype.doScroll=function(){var t,e=this;t={horizontal:{newScroll:this.$element.scrollLeft(),oldScroll:this.oldScroll.x,forward:"right",backward:"left"},vertical:{newScroll:this.$element.scrollTop(),oldScroll:this.oldScroll.y,forward:"down",backward:"up"}};if(c&&(!t.vertical.oldScroll||!t.vertical.newScroll)){n[m]("refresh")}n.each(t,function(t,r){var i,o,l;l=[];o=r.newScroll>r.oldScroll;i=o?r.forward:r.backward;n.each(e.waypoints[t],function(t,e){var n,i;if(r.oldScroll<(n=e.offset)&&n<=r.newScroll){return l.push(e)}else if(r.newScroll<(i=e.offset)&&i<=r.oldScroll){return l.push(e)}});l.sort(function(t,e){return t.offset-e.offset});if(!o){l.reverse()}return n.each(l,function(t,e){if(e.options.continuous||t===l.length-1){return e.trigger([i])}})});return this.oldScroll={x:t.horizontal.newScroll,y:t.vertical.newScroll}};t.prototype.refresh=function(){var t,e,r,i=this;r=n.isWindow(this.element);e=this.$element.offset();this.doScroll();t={horizontal:{contextOffset:r?0:e.left,contextScroll:r?0:this.oldScroll.x,contextDimension:this.$element.width(),oldScroll:this.oldScroll.x,forward:"right",backward:"left",offsetProp:"left"},vertical:{contextOffset:r?0:e.top,contextScroll:r?0:this.oldScroll.y,contextDimension:r?n[m]("viewportHeight"):this.$element.height(),oldScroll:this.oldScroll.y,forward:"down",backward:"up",offsetProp:"top"}};return n.each(t,function(t,e){return n.each(i.waypoints[t],function(t,r){var i,o,l,s,f;i=r.options.offset;l=r.offset;o=n.isWindow(r.element)?0:r.$element.offset()[e.offsetProp];if(n.isFunction(i)){i=i.apply(r.element)}else if(typeof i==="string"){i=parseFloat(i);if(r.options.offset.indexOf("%")>-1){i=Math.ceil(e.contextDimension*i/100)}}r.offset=o-e.contextOffset+e.contextScroll-i;if(r.options.onlyOnScroll&&l!=null||!r.enabled){return}if(l!==null&&l<(s=e.oldScroll)&&s<=r.offset){return r.trigger([e.backward])}else if(l!==null&&l>(f=e.oldScroll)&&f>=r.offset){return r.trigger([e.forward])}else if(l===null&&e.oldScroll>=r.offset){return r.trigger([e.forward])}})})};t.prototype.checkEmpty=function(){if(n.isEmptyObject(this.waypoints.horizontal)&&n.isEmptyObject(this.waypoints.vertical)){this.$element.unbind([p,y].join(" "));return delete a[this.id]}};return t}();l=function(){function t(t,e,r){var i,o;r=n.extend({},n.fn[g].defaults,r);if(r.offset==="bottom-in-view"){r.offset=function(){var t;t=n[m]("viewportHeight");if(!n.isWindow(e.element)){t=e.$element.height()}return t-n(this).outerHeight()}}this.$element=t;this.element=t[0];this.axis=r.horizontal?"horizontal":"vertical";this.callback=r.handler;this.context=e;this.enabled=r.enabled;this.id="waypoints"+v++;this.offset=null;this.options=r;e.waypoints[this.axis][this.id]=this;s[this.axis][this.id]=this;i=(o=t.data(w))!=null?o:[];i.push(this.id);t.data(w,i)}t.prototype.trigger=function(t){if(!this.enabled){return}if(this.callback!=null){this.callback.apply(this.element,t)}if(this.options.triggerOnce){return this.destroy()}};t.prototype.disable=function(){return this.enabled=false};t.prototype.enable=function(){this.context.refresh();return this.enabled=true};t.prototype.destroy=function(){delete s[this.axis][this.id];delete this.context.waypoints[this.axis][this.id];return this.context.checkEmpty()};t.getWaypointsByElement=function(t){var e,r;r=n(t).data(w);if(!r){return[]}e=n.extend({},s.horizontal,s.vertical);return n.map(r,function(t){return e[t]})};return t}();d={init:function(t,e){var r;if(e==null){e={}}if((r=e.handler)==null){e.handler=t}this.each(function(){var t,r,i,s;t=n(this);i=(s=e.context)!=null?s:n.fn[g].defaults.context;if(!n.isWindow(i)){i=t.closest(i)}i=n(i);r=a[i.data(u)];if(!r){r=new o(i)}return new l(t,r,e)});n[m]("refresh");return this},disable:function(){return d._invoke(this,"disable")},enable:function(){return d._invoke(this,"enable")},destroy:function(){return d._invoke(this,"destroy")},prev:function(t,e){return d._traverse.call(this,t,e,function(t,e,n){if(e>0){return t.push(n[e-1])}})},next:function(t,e){return d._traverse.call(this,t,e,function(t,e,n){if(e<n.length-1){return t.push(n[e+1])}})},_traverse:function(t,e,i){var o,l;if(t==null){t="vertical"}if(e==null){e=r}l=h.aggregate(e);o=[];this.each(function(){var e;e=n.inArray(this,l[t]);return i(o,e,l[t])});return this.pushStack(o)},_invoke:function(t,e){t.each(function(){var t;t=l.getWaypointsByElement(this);return n.each(t,function(t,n){n[e]();return true})});return this}};n.fn[g]=function(){var t,r;r=arguments[0],t=2<=arguments.length?e.call(arguments,1):[];if(d[r]){return d[r].apply(this,t)}else if(n.isFunction(r)){return d.init.apply(this,arguments)}else if(n.isPlainObject(r)){return d.init.apply(this,[null,r])}else if(!r){return n.error("jQuery Waypoints needs a callback function or handler option.")}else{return n.error("The "+r+" method does not exist in jQuery Waypoints.")}};n.fn[g].defaults={context:r,continuous:true,enabled:true,horizontal:false,offset:0,triggerOnce:false};h={refresh:function(){return n.each(a,function(t,e){return e.refresh()})},viewportHeight:function(){var t;return(t=r.innerHeight)!=null?t:i.height()},aggregate:function(t){var e,r,i;e=s;if(t){e=(i=a[n(t).data(u)])!=null?i.waypoints:void 0}if(!e){return[]}r={horizontal:[],vertical:[]};n.each(r,function(t,i){n.each(e[t],function(t,e){return i.push(e)});i.sort(function(t,e){return t.offset-e.offset});r[t]=n.map(i,function(t){return t.element});return r[t]=n.unique(r[t])});return r},above:function(t){if(t==null){t=r}return h._filter(t,"vertical",function(t,e){return e.offset<=t.oldScroll.y})},below:function(t){if(t==null){t=r}return h._filter(t,"vertical",function(t,e){return e.offset>t.oldScroll.y})},left:function(t){if(t==null){t=r}return h._filter(t,"horizontal",function(t,e){return e.offset<=t.oldScroll.x})},right:function(t){if(t==null){t=r}return h._filter(t,"horizontal",function(t,e){return e.offset>t.oldScroll.x})},enable:function(){return h._invoke("enable")},disable:function(){return h._invoke("disable")},destroy:function(){return h._invoke("destroy")},extendFn:function(t,e){return d[t]=e},_invoke:function(t){var e;e=n.extend({},s.vertical,s.horizontal);return n.each(e,function(e,n){n[t]();return true})},_filter:function(t,e,r){var i,o;i=a[n(t).data(u)];if(!i){return[]}o=[];n.each(i.waypoints[e],function(t,e){if(r(i,e)){return o.push(e)}});o.sort(function(t,e){return t.offset-e.offset});return n.map(o,function(t){return t.element})}};n[m]=function(){var t,n;n=arguments[0],t=2<=arguments.length?e.call(arguments,1):[];if(h[n]){return h[n].apply(null,t)}else{return h.aggregate.call(null,n)}};n[m].settings={resizeThrottle:100,scrollThrottle:30};return i.load(function(){return n[m]("refresh")})})}).call(this);;

/* /theme_crafito/static/src/js/plugins/jquery.counterup.js defined in bundle 'web.assets_frontend' */
(function($){"use strict";$.fn.counterUp=function(options){var settings=$.extend({'time':400,'delay':10},options);return this.each(function(){var $this=$(this);var $settings=settings;var counterUpper=function(){var nums=[];var divisions=$settings.time/$settings.delay;var num=$this.text();var isComma=/[0-9]+,[0-9]+/.test(num);num=num.replace(/,/g,'');var isInt=/^[0-9]+$/.test(num);var isFloat=/^[0-9]+\.[0-9]+$/.test(num);var decimalPlaces=isFloat?(num.split('.')[1]||[]).length:0;for(var i=divisions;i>=1;i--){var newNum=parseInt(num/divisions*i);if(isFloat){newNum=parseFloat(num/divisions*i).toFixed(decimalPlaces);}
if(isComma){while(/(\d+)(\d{3})/.test(newNum.toString())){newNum=newNum.toString().replace(/(\d+)(\d{3})/,'$1'+','+'$2');}}
nums.unshift(newNum);}
$this.data('counterup-nums',nums);$this.text('0');var f=function(){$this.text($this.data('counterup-nums').shift());if($this.data('counterup-nums').length){setTimeout($this.data('counterup-func'),$settings.delay);}else{delete $this.data('counterup-nums');$this.data('counterup-nums',null);$this.data('counterup-func',null);}};$this.data('counterup-func',f);setTimeout($this.data('counterup-func'),$settings.delay);};$this.waypoint(counterUpper,{offset:'100%',triggerOnce:true});});};})(jQuery);;

/* /theme_crafito/static/src/js/plugins/owl.carousel.min.js defined in bundle 'web.assets_frontend' */
!function(a,b,c,d){function e(b,c){this.settings=null,this.options=a.extend({},e.Defaults,c),this.$element=a(b),this.drag=a.extend({},m),this.state=a.extend({},n),this.e=a.extend({},o),this._plugins={},this._supress={},this._current=null,this._speed=null,this._coordinates=[],this._breakpoint=null,this._width=null,this._items=[],this._clones=[],this._mergers=[],this._invalidated={},this._pipe=[],a.each(e.Plugins,a.proxy(function(a,b){this._plugins[a[0].toLowerCase()+a.slice(1)]=new b(this)},this)),a.each(e.Pipe,a.proxy(function(b,c){this._pipe.push({filter:c.filter,run:a.proxy(c.run,this)})},this)),this.setup(),this.initialize()}function f(a){if(a.touches!==d)return{x:a.touches[0].pageX,y:a.touches[0].pageY};if(a.touches===d){if(a.pageX!==d)return{x:a.pageX,y:a.pageY};if(a.pageX===d)return{x:a.clientX,y:a.clientY}}}function g(a){var b,d,e=c.createElement("div"),f=a;for(b in f)if(d=f[b],"undefined"!=typeof e.style[d])return e=null,[d,b];return[!1]}function h(){return g(["transition","WebkitTransition","MozTransition","OTransition"])[1]}function i(){return g(["transform","WebkitTransform","MozTransform","OTransform","msTransform"])[0]}function j(){return g(["perspective","webkitPerspective","MozPerspective","OPerspective","MsPerspective"])[0]}function k(){return"ontouchstart"in b||!!navigator.msMaxTouchPoints}function l(){return b.navigator.msPointerEnabled}var m,n,o;m={start:0,startX:0,startY:0,current:0,currentX:0,currentY:0,offsetX:0,offsetY:0,distance:null,startTime:0,endTime:0,updatedX:0,targetEl:null},n={isTouch:!1,isScrolling:!1,isSwiping:!1,direction:!1,inMotion:!1},o={_onDragStart:null,_onDragMove:null,_onDragEnd:null,_transitionEnd:null,_resizer:null,_responsiveCall:null,_goToLoop:null,_checkVisibile:null},e.Defaults={items:3,loop:!1,center:!1,mouseDrag:!0,touchDrag:!0,pullDrag:!0,freeDrag:!1,margin:0,stagePadding:0,merge:!1,mergeFit:!0,autoWidth:!1,startPosition:0,rtl:!1,smartSpeed:250,fluidSpeed:!1,dragEndSpeed:!1,responsive:{},responsiveRefreshRate:200,responsiveBaseElement:b,responsiveClass:!1,fallbackEasing:"swing",info:!1,nestedItemSelector:!1,itemElement:"div",stageElement:"div",themeClass:"owl-theme",baseClass:"owl-carousel",itemClass:"owl-item",centerClass:"center",activeClass:"active"},e.Width={Default:"default",Inner:"inner",Outer:"outer"},e.Plugins={},e.Pipe=[{filter:["width","items","settings"],run:function(a){a.current=this._items&&this._items[this.relative(this._current)]}},{filter:["items","settings"],run:function(){var a=this._clones,b=this.$stage.children(".cloned");(b.length!==a.length||!this.settings.loop&&a.length>0)&&(this.$stage.children(".cloned").remove(),this._clones=[])}},{filter:["items","settings"],run:function(){var a,b,c=this._clones,d=this._items,e=this.settings.loop?c.length-Math.max(2*this.settings.items,4):0;for(a=0,b=Math.abs(e/2);b>a;a++)e>0?(this.$stage.children().eq(d.length+c.length-1).remove(),c.pop(),this.$stage.children().eq(0).remove(),c.pop()):(c.push(c.length/2),this.$stage.append(d[c[c.length-1]].clone().addClass("cloned")),c.push(d.length-1-(c.length-1)/2),this.$stage.prepend(d[c[c.length-1]].clone().addClass("cloned")))}},{filter:["width","items","settings"],run:function(){var a,b,c,d=this.settings.rtl?1:-1,e=(this.width()/this.settings.items).toFixed(3),f=0;for(this._coordinates=[],b=0,c=this._clones.length+this._items.length;c>b;b++)a=this._mergers[this.relative(b)],a=this.settings.mergeFit&&Math.min(a,this.settings.items)||a,f+=(this.settings.autoWidth?this._items[this.relative(b)].width()+this.settings.margin:e*a)*d,this._coordinates.push(f)}},{filter:["width","items","settings"],run:function(){var b,c,d=(this.width()/this.settings.items).toFixed(3),e={width:Math.abs(this._coordinates[this._coordinates.length-1])+2*this.settings.stagePadding,"padding-left":this.settings.stagePadding||"","padding-right":this.settings.stagePadding||""};if(this.$stage.css(e),e={width:this.settings.autoWidth?"auto":d-this.settings.margin},e[this.settings.rtl?"margin-left":"margin-right"]=this.settings.margin,!this.settings.autoWidth&&a.grep(this._mergers,function(a){return a>1}).length>0)for(b=0,c=this._coordinates.length;c>b;b++)e.width=Math.abs(this._coordinates[b])-Math.abs(this._coordinates[b-1]||0)-this.settings.margin,this.$stage.children().eq(b).css(e);else this.$stage.children().css(e)}},{filter:["width","items","settings"],run:function(a){a.current&&this.reset(this.$stage.children().index(a.current))}},{filter:["position"],run:function(){this.animate(this.coordinates(this._current))}},{filter:["width","position","items","settings"],run:function(){var a,b,c,d,e=this.settings.rtl?1:-1,f=2*this.settings.stagePadding,g=this.coordinates(this.current())+f,h=g+this.width()*e,i=[];for(c=0,d=this._coordinates.length;d>c;c++)a=this._coordinates[c-1]||0,b=Math.abs(this._coordinates[c])+f*e,(this.op(a,"<=",g)&&this.op(a,">",h)||this.op(b,"<",g)&&this.op(b,">",h))&&i.push(c);this.$stage.children("."+this.settings.activeClass).removeClass(this.settings.activeClass),this.$stage.children(":eq("+i.join("), :eq(")+")").addClass(this.settings.activeClass),this.settings.center&&(this.$stage.children("."+this.settings.centerClass).removeClass(this.settings.centerClass),this.$stage.children().eq(this.current()).addClass(this.settings.centerClass))}}],e.prototype.initialize=function(){if(this.trigger("initialize"),this.$element.addClass(this.settings.baseClass).addClass(this.settings.themeClass).toggleClass("owl-rtl",this.settings.rtl),this.browserSupport(),this.settings.autoWidth&&this.state.imagesLoaded!==!0){var b,c,e;if(b=this.$element.find("img"),c=this.settings.nestedItemSelector?"."+this.settings.nestedItemSelector:d,e=this.$element.children(c).width(),b.length&&0>=e)return this.preloadAutoWidthImages(b),!1}this.$element.addClass("owl-loading"),this.$stage=a("<"+this.settings.stageElement+' class="owl-stage"/>').wrap('<div class="owl-stage-outer">'),this.$element.append(this.$stage.parent()),this.replace(this.$element.children().not(this.$stage.parent())),this._width=this.$element.width(),this.refresh(),this.$element.removeClass("owl-loading").addClass("owl-loaded"),this.eventsCall(),this.internalEvents(),this.addTriggerableEvents(),this.trigger("initialized")},e.prototype.setup=function(){var b=this.viewport(),c=this.options.responsive,d=-1,e=null;c?(a.each(c,function(a){b>=a&&a>d&&(d=Number(a))}),e=a.extend({},this.options,c[d]),delete e.responsive,e.responsiveClass&&this.$element.attr("class",function(a,b){return b.replace(/\b owl-responsive-\S+/g,"")}).addClass("owl-responsive-"+d)):e=a.extend({},this.options),(null===this.settings||this._breakpoint!==d)&&(this.trigger("change",{property:{name:"settings",value:e}}),this._breakpoint=d,this.settings=e,this.invalidate("settings"),this.trigger("changed",{property:{name:"settings",value:this.settings}}))},e.prototype.optionsLogic=function(){this.$element.toggleClass("owl-center",this.settings.center),this.settings.loop&&this._items.length<this.settings.items&&(this.settings.loop=!1),this.settings.autoWidth&&(this.settings.stagePadding=!1,this.settings.merge=!1)},e.prototype.prepare=function(b){var c=this.trigger("prepare",{content:b});return c.data||(c.data=a("<"+this.settings.itemElement+"/>").addClass(this.settings.itemClass).append(b)),this.trigger("prepared",{content:c.data}),c.data},e.prototype.update=function(){for(var b=0,c=this._pipe.length,d=a.proxy(function(a){return this[a]},this._invalidated),e={};c>b;)(this._invalidated.all||a.grep(this._pipe[b].filter,d).length>0)&&this._pipe[b].run(e),b++;this._invalidated={}},e.prototype.width=function(a){switch(a=a||e.Width.Default){case e.Width.Inner:case e.Width.Outer:return this._width;default:return this._width-2*this.settings.stagePadding+this.settings.margin}},e.prototype.refresh=function(){if(0===this._items.length)return!1;(new Date).getTime();this.trigger("refresh"),this.setup(),this.optionsLogic(),this.$stage.addClass("owl-refresh"),this.update(),this.$stage.removeClass("owl-refresh"),this.state.orientation=b.orientation,this.watchVisibility(),this.trigger("refreshed")},e.prototype.eventsCall=function(){this.e._onDragStart=a.proxy(function(a){this.onDragStart(a)},this),this.e._onDragMove=a.proxy(function(a){this.onDragMove(a)},this),this.e._onDragEnd=a.proxy(function(a){this.onDragEnd(a)},this),this.e._onResize=a.proxy(function(a){this.onResize(a)},this),this.e._transitionEnd=a.proxy(function(a){this.transitionEnd(a)},this),this.e._preventClick=a.proxy(function(a){this.preventClick(a)},this)},e.prototype.onThrottledResize=function(){b.clearTimeout(this.resizeTimer),this.resizeTimer=b.setTimeout(this.e._onResize,this.settings.responsiveRefreshRate)},e.prototype.onResize=function(){return this._items.length?this._width===this.$element.width()?!1:this.trigger("resize").isDefaultPrevented()?!1:(this._width=this.$element.width(),this.invalidate("width"),this.refresh(),void this.trigger("resized")):!1},e.prototype.eventsRouter=function(a){var b=a.type;"mousedown"===b||"touchstart"===b?this.onDragStart(a):"mousemove"===b||"touchmove"===b?this.onDragMove(a):"mouseup"===b||"touchend"===b?this.onDragEnd(a):"touchcancel"===b&&this.onDragEnd(a)},e.prototype.internalEvents=function(){var c=(k(),l());this.settings.mouseDrag?(this.$stage.on("mousedown",a.proxy(function(a){this.eventsRouter(a)},this)),this.$stage.on("dragstart",function(){return!1}),this.$stage.get(0).onselectstart=function(){return!1}):this.$element.addClass("owl-text-select-on"),this.settings.touchDrag&&!c&&this.$stage.on("touchstart touchcancel",a.proxy(function(a){this.eventsRouter(a)},this)),this.transitionEndVendor&&this.on(this.$stage.get(0),this.transitionEndVendor,this.e._transitionEnd,!1),this.settings.responsive!==!1&&this.on(b,"resize",a.proxy(this.onThrottledResize,this))},e.prototype.onDragStart=function(d){var e,g,h,i;if(e=d.originalEvent||d||b.event,3===e.which||this.state.isTouch)return!1;if("mousedown"===e.type&&this.$stage.addClass("owl-grab"),this.trigger("drag"),this.drag.startTime=(new Date).getTime(),this.speed(0),this.state.isTouch=!0,this.state.isScrolling=!1,this.state.isSwiping=!1,this.drag.distance=0,g=f(e).x,h=f(e).y,this.drag.offsetX=this.$stage.position().left,this.drag.offsetY=this.$stage.position().top,this.settings.rtl&&(this.drag.offsetX=this.$stage.position().left+this.$stage.width()-this.width()+this.settings.margin),this.state.inMotion&&this.support3d)i=this.getTransformProperty(),this.drag.offsetX=i,this.animate(i),this.state.inMotion=!0;else if(this.state.inMotion&&!this.support3d)return this.state.inMotion=!1,!1;this.drag.startX=g-this.drag.offsetX,this.drag.startY=h-this.drag.offsetY,this.drag.start=g-this.drag.startX,this.drag.targetEl=e.target||e.srcElement,this.drag.updatedX=this.drag.start,("IMG"===this.drag.targetEl.tagName||"A"===this.drag.targetEl.tagName)&&(this.drag.targetEl.draggable=!1),a(c).on("mousemove.owl.dragEvents mouseup.owl.dragEvents touchmove.owl.dragEvents touchend.owl.dragEvents",a.proxy(function(a){this.eventsRouter(a)},this))},e.prototype.onDragMove=function(a){var c,e,g,h,i,j;this.state.isTouch&&(this.state.isScrolling||(c=a.originalEvent||a||b.event,e=f(c).x,g=f(c).y,this.drag.currentX=e-this.drag.startX,this.drag.currentY=g-this.drag.startY,this.drag.distance=this.drag.currentX-this.drag.offsetX,this.drag.distance<0?this.state.direction=this.settings.rtl?"right":"left":this.drag.distance>0&&(this.state.direction=this.settings.rtl?"left":"right"),this.settings.loop?this.op(this.drag.currentX,">",this.coordinates(this.minimum()))&&"right"===this.state.direction?this.drag.currentX-=(this.settings.center&&this.coordinates(0))-this.coordinates(this._items.length):this.op(this.drag.currentX,"<",this.coordinates(this.maximum()))&&"left"===this.state.direction&&(this.drag.currentX+=(this.settings.center&&this.coordinates(0))-this.coordinates(this._items.length)):(h=this.coordinates(this.settings.rtl?this.maximum():this.minimum()),i=this.coordinates(this.settings.rtl?this.minimum():this.maximum()),j=this.settings.pullDrag?this.drag.distance/5:0,this.drag.currentX=Math.max(Math.min(this.drag.currentX,h+j),i+j)),(this.drag.distance>8||this.drag.distance<-8)&&(c.preventDefault!==d?c.preventDefault():c.returnValue=!1,this.state.isSwiping=!0),this.drag.updatedX=this.drag.currentX,(this.drag.currentY>16||this.drag.currentY<-16)&&this.state.isSwiping===!1&&(this.state.isScrolling=!0,this.drag.updatedX=this.drag.start),this.animate(this.drag.updatedX)))},e.prototype.onDragEnd=function(b){var d,e,f;if(this.state.isTouch){if("mouseup"===b.type&&this.$stage.removeClass("owl-grab"),this.trigger("dragged"),this.drag.targetEl.removeAttribute("draggable"),this.state.isTouch=!1,this.state.isScrolling=!1,this.state.isSwiping=!1,0===this.drag.distance&&this.state.inMotion!==!0)return this.state.inMotion=!1,!1;this.drag.endTime=(new Date).getTime(),d=this.drag.endTime-this.drag.startTime,e=Math.abs(this.drag.distance),(e>3||d>300)&&this.removeClick(this.drag.targetEl),f=this.closest(this.drag.updatedX),this.speed(this.settings.dragEndSpeed||this.settings.smartSpeed),this.current(f),this.invalidate("position"),this.update(),this.settings.pullDrag||this.drag.updatedX!==this.coordinates(f)||this.transitionEnd(),this.drag.distance=0,a(c).off(".owl.dragEvents")}},e.prototype.removeClick=function(c){this.drag.targetEl=c,a(c).on("click.preventClick",this.e._preventClick),b.setTimeout(function(){a(c).off("click.preventClick")},300)},e.prototype.preventClick=function(b){b.preventDefault?b.preventDefault():b.returnValue=!1,b.stopPropagation&&b.stopPropagation(),a(b.target).off("click.preventClick")},e.prototype.getTransformProperty=function(){var a,c;return a=b.getComputedStyle(this.$stage.get(0),null).getPropertyValue(this.vendorName+"transform"),a=a.replace(/matrix(3d)?\(|\)/g,"").split(","),c=16===a.length,c!==!0?a[4]:a[12]},e.prototype.closest=function(b){var c=-1,d=30,e=this.width(),f=this.coordinates();return this.settings.freeDrag||a.each(f,a.proxy(function(a,g){return b>g-d&&g+d>b?c=a:this.op(b,"<",g)&&this.op(b,">",f[a+1]||g-e)&&(c="left"===this.state.direction?a+1:a),-1===c},this)),this.settings.loop||(this.op(b,">",f[this.minimum()])?c=b=this.minimum():this.op(b,"<",f[this.maximum()])&&(c=b=this.maximum())),c},e.prototype.animate=function(b){this.trigger("translate"),this.state.inMotion=this.speed()>0,this.support3d?this.$stage.css({transform:"translate3d("+b+"px,0px, 0px)",transition:this.speed()/1e3+"s"}):this.state.isTouch?this.$stage.css({left:b+"px"}):this.$stage.animate({left:b},this.speed()/1e3,this.settings.fallbackEasing,a.proxy(function(){this.state.inMotion&&this.transitionEnd()},this))},e.prototype.current=function(a){if(a===d)return this._current;if(0===this._items.length)return d;if(a=this.normalize(a),this._current!==a){var b=this.trigger("change",{property:{name:"position",value:a}});b.data!==d&&(a=this.normalize(b.data)),this._current=a,this.invalidate("position"),this.trigger("changed",{property:{name:"position",value:this._current}})}return this._current},e.prototype.invalidate=function(a){this._invalidated[a]=!0},e.prototype.reset=function(a){a=this.normalize(a),a!==d&&(this._speed=0,this._current=a,this.suppress(["translate","translated"]),this.animate(this.coordinates(a)),this.release(["translate","translated"]))},e.prototype.normalize=function(b,c){var e=c?this._items.length:this._items.length+this._clones.length;return!a.isNumeric(b)||1>e?d:b=this._clones.length?(b%e+e)%e:Math.max(this.minimum(c),Math.min(this.maximum(c),b))},e.prototype.relative=function(a){return a=this.normalize(a),a-=this._clones.length/2,this.normalize(a,!0)},e.prototype.maximum=function(a){var b,c,d,e=0,f=this.settings;if(a)return this._items.length-1;if(!f.loop&&f.center)b=this._items.length-1;else if(f.loop||f.center)if(f.loop||f.center)b=this._items.length+f.items;else{if(!f.autoWidth&&!f.merge)throw"Can not detect maximum absolute position.";for(revert=f.rtl?1:-1,c=this.$stage.width()-this.$element.width();(d=this.coordinates(e))&&!(d*revert>=c);)b=++e}else b=this._items.length-f.items;return b},e.prototype.minimum=function(a){return a?0:this._clones.length/2},e.prototype.items=function(a){return a===d?this._items.slice():(a=this.normalize(a,!0),this._items[a])},e.prototype.mergers=function(a){return a===d?this._mergers.slice():(a=this.normalize(a,!0),this._mergers[a])},e.prototype.clones=function(b){var c=this._clones.length/2,e=c+this._items.length,f=function(a){return a%2===0?e+a/2:c-(a+1)/2};return b===d?a.map(this._clones,function(a,b){return f(b)}):a.map(this._clones,function(a,c){return a===b?f(c):null})},e.prototype.speed=function(a){return a!==d&&(this._speed=a),this._speed},e.prototype.coordinates=function(b){var c=null;return b===d?a.map(this._coordinates,a.proxy(function(a,b){return this.coordinates(b)},this)):(this.settings.center?(c=this._coordinates[b],c+=(this.width()-c+(this._coordinates[b-1]||0))/2*(this.settings.rtl?-1:1)):c=this._coordinates[b-1]||0,c)},e.prototype.duration=function(a,b,c){return Math.min(Math.max(Math.abs(b-a),1),6)*Math.abs(c||this.settings.smartSpeed)},e.prototype.to=function(c,d){if(this.settings.loop){var e=c-this.relative(this.current()),f=this.current(),g=this.current(),h=this.current()+e,i=0>g-h?!0:!1,j=this._clones.length+this._items.length;h<this.settings.items&&i===!1?(f=g+this._items.length,this.reset(f)):h>=j-this.settings.items&&i===!0&&(f=g-this._items.length,this.reset(f)),b.clearTimeout(this.e._goToLoop),this.e._goToLoop=b.setTimeout(a.proxy(function(){this.speed(this.duration(this.current(),f+e,d)),this.current(f+e),this.update()},this),30)}else this.speed(this.duration(this.current(),c,d)),this.current(c),this.update()},e.prototype.next=function(a){a=a||!1,this.to(this.relative(this.current())+1,a)},e.prototype.prev=function(a){a=a||!1,this.to(this.relative(this.current())-1,a)},e.prototype.transitionEnd=function(a){return a!==d&&(a.stopPropagation(),(a.target||a.srcElement||a.originalTarget)!==this.$stage.get(0))?!1:(this.state.inMotion=!1,void this.trigger("translated"))},e.prototype.viewport=function(){var d;if(this.options.responsiveBaseElement!==b)d=a(this.options.responsiveBaseElement).width();else if(b.innerWidth)d=b.innerWidth;else{if(!c.documentElement||!c.documentElement.clientWidth)throw"Can not detect viewport width.";d=c.documentElement.clientWidth}return d},e.prototype.replace=function(b){this.$stage.empty(),this._items=[],b&&(b=b instanceof jQuery?b:a(b)),this.settings.nestedItemSelector&&(b=b.find("."+this.settings.nestedItemSelector)),b.filter(function(){return 1===this.nodeType}).each(a.proxy(function(a,b){b=this.prepare(b),this.$stage.append(b),this._items.push(b),this._mergers.push(1*b.find("[data-merge]").andSelf("[data-merge]").attr("data-merge")||1)},this)),this.reset(a.isNumeric(this.settings.startPosition)?this.settings.startPosition:0),this.invalidate("items")},e.prototype.add=function(a,b){b=b===d?this._items.length:this.normalize(b,!0),this.trigger("add",{content:a,position:b}),0===this._items.length||b===this._items.length?(this.$stage.append(a),this._items.push(a),this._mergers.push(1*a.find("[data-merge]").andSelf("[data-merge]").attr("data-merge")||1)):(this._items[b].before(a),this._items.splice(b,0,a),this._mergers.splice(b,0,1*a.find("[data-merge]").andSelf("[data-merge]").attr("data-merge")||1)),this.invalidate("items"),this.trigger("added",{content:a,position:b})},e.prototype.remove=function(a){a=this.normalize(a,!0),a!==d&&(this.trigger("remove",{content:this._items[a],position:a}),this._items[a].remove(),this._items.splice(a,1),this._mergers.splice(a,1),this.invalidate("items"),this.trigger("removed",{content:null,position:a}))},e.prototype.addTriggerableEvents=function(){var b=a.proxy(function(b,c){return a.proxy(function(a){a.relatedTarget!==this&&(this.suppress([c]),b.apply(this,[].slice.call(arguments,1)),this.release([c]))},this)},this);a.each({next:this.next,prev:this.prev,to:this.to,destroy:this.destroy,refresh:this.refresh,replace:this.replace,add:this.add,remove:this.remove},a.proxy(function(a,c){this.$element.on(a+".owl.carousel",b(c,a+".owl.carousel"))},this))},e.prototype.watchVisibility=function(){function c(a){return a.offsetWidth>0&&a.offsetHeight>0}function d(){c(this.$element.get(0))&&(this.$element.removeClass("owl-hidden"),this.refresh(),b.clearInterval(this.e._checkVisibile))}c(this.$element.get(0))||(this.$element.addClass("owl-hidden"),b.clearInterval(this.e._checkVisibile),this.e._checkVisibile=b.setInterval(a.proxy(d,this),500))},e.prototype.preloadAutoWidthImages=function(b){var c,d,e,f;c=0,d=this,b.each(function(g,h){e=a(h),f=new Image,f.onload=function(){c++,e.attr("src",f.src),e.css("opacity",1),c>=b.length&&(d.state.imagesLoaded=!0,d.initialize())},f.src=e.attr("src")||e.attr("data-src")||e.attr("data-src-retina")})},e.prototype.destroy=function(){this.$element.hasClass(this.settings.themeClass)&&this.$element.removeClass(this.settings.themeClass),this.settings.responsive!==!1&&a(b).off("resize.owl.carousel"),this.transitionEndVendor&&this.off(this.$stage.get(0),this.transitionEndVendor,this.e._transitionEnd);for(var d in this._plugins)this._plugins[d].destroy();(this.settings.mouseDrag||this.settings.touchDrag)&&(this.$stage.off("mousedown touchstart touchcancel"),a(c).off(".owl.dragEvents"),this.$stage.get(0).onselectstart=function(){},this.$stage.off("dragstart",function(){return!1})),this.$element.off(".owl"),this.$stage.children(".cloned").remove(),this.e=null,this.$element.removeData("owlCarousel"),this.$stage.children().contents().unwrap(),this.$stage.children().unwrap(),this.$stage.unwrap()},e.prototype.op=function(a,b,c){var d=this.settings.rtl;switch(b){case"<":return d?a>c:c>a;case">":return d?c>a:a>c;case">=":return d?c>=a:a>=c;case"<=":return d?a>=c:c>=a}},e.prototype.on=function(a,b,c,d){a.addEventListener?a.addEventListener(b,c,d):a.attachEvent&&a.attachEvent("on"+b,c)},e.prototype.off=function(a,b,c,d){a.removeEventListener?a.removeEventListener(b,c,d):a.detachEvent&&a.detachEvent("on"+b,c)},e.prototype.trigger=function(b,c,d){var e={item:{count:this._items.length,index:this.current()}},f=a.camelCase(a.grep(["on",b,d],function(a){return a}).join("-").toLowerCase()),g=a.Event([b,"owl",d||"carousel"].join(".").toLowerCase(),a.extend({relatedTarget:this},e,c));return this._supress[b]||(a.each(this._plugins,function(a,b){b.onTrigger&&b.onTrigger(g)}),this.$element.trigger(g),this.settings&&"function"==typeof this.settings[f]&&this.settings[f].apply(this,g)),g},e.prototype.suppress=function(b){a.each(b,a.proxy(function(a,b){this._supress[b]=!0},this))},e.prototype.release=function(b){a.each(b,a.proxy(function(a,b){delete this._supress[b]},this))},e.prototype.browserSupport=function(){if(this.support3d=j(),this.support3d){this.transformVendor=i();var a=["transitionend","webkitTransitionEnd","transitionend","oTransitionEnd"];this.transitionEndVendor=a[h()],this.vendorName=this.transformVendor.replace(/Transform/i,""),this.vendorName=""!==this.vendorName?"-"+this.vendorName.toLowerCase()+"-":""}this.state.orientation=b.orientation},a.fn.owlCarousel=function(b){return this.each(function(){a(this).data("owlCarousel")||a(this).data("owlCarousel",new e(this,b))})},a.fn.owlCarousel.Constructor=e}(window.Zepto||window.jQuery,window,document),function(a,b){var c=function(b){this._core=b,this._loaded=[],this._handlers={"initialized.owl.carousel change.owl.carousel":a.proxy(function(b){if(b.namespace&&this._core.settings&&this._core.settings.lazyLoad&&(b.property&&"position"==b.property.name||"initialized"==b.type))for(var c=this._core.settings,d=c.center&&Math.ceil(c.items/2)||c.items,e=c.center&&-1*d||0,f=(b.property&&b.property.value||this._core.current())+e,g=this._core.clones().length,h=a.proxy(function(a,b){this.load(b)},this);e++<d;)this.load(g/2+this._core.relative(f)),g&&a.each(this._core.clones(this._core.relative(f++)),h)},this)},this._core.options=a.extend({},c.Defaults,this._core.options),this._core.$element.on(this._handlers)};c.Defaults={lazyLoad:!1},c.prototype.load=function(c){var d=this._core.$stage.children().eq(c),e=d&&d.find(".owl-lazy");!e||a.inArray(d.get(0),this._loaded)>-1||(e.each(a.proxy(function(c,d){var e,f=a(d),g=b.devicePixelRatio>1&&f.attr("data-src-retina")||f.attr("data-src");this._core.trigger("load",{element:f,url:g},"lazy"),f.is("img")?f.one("load.owl.lazy",a.proxy(function(){f.css("opacity",1),this._core.trigger("loaded",{element:f,url:g},"lazy")},this)).attr("src",g):(e=new Image,e.onload=a.proxy(function(){f.css({"background-image":"url("+g+")",opacity:"1"}),this._core.trigger("loaded",{element:f,url:g},"lazy")},this),e.src=g)},this)),this._loaded.push(d.get(0)))},c.prototype.destroy=function(){var a,b;for(a in this.handlers)this._core.$element.off(a,this.handlers[a]);for(b in Object.getOwnPropertyNames(this))"function"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Lazy=c}(window.Zepto||window.jQuery,window,document),function(a){var b=function(c){this._core=c,this._handlers={"initialized.owl.carousel":a.proxy(function(){this._core.settings.autoHeight&&this.update()},this),"changed.owl.carousel":a.proxy(function(a){this._core.settings.autoHeight&&"position"==a.property.name&&this.update()},this),"loaded.owl.lazy":a.proxy(function(a){this._core.settings.autoHeight&&a.element.closest("."+this._core.settings.itemClass)===this._core.$stage.children().eq(this._core.current())&&this.update()},this)},this._core.options=a.extend({},b.Defaults,this._core.options),this._core.$element.on(this._handlers)};b.Defaults={autoHeight:!1,autoHeightClass:"owl-height"},b.prototype.update=function(){this._core.$stage.parent().height(this._core.$stage.children().eq(this._core.current()).height()).addClass(this._core.settings.autoHeightClass)},b.prototype.destroy=function(){var a,b;for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(b in Object.getOwnPropertyNames(this))"function"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.AutoHeight=b}(window.Zepto||window.jQuery,window,document),function(a,b,c){var d=function(b){this._core=b,this._videos={},this._playing=null,this._fullscreen=!1,this._handlers={"resize.owl.carousel":a.proxy(function(a){this._core.settings.video&&!this.isInFullScreen()&&a.preventDefault()},this),"refresh.owl.carousel changed.owl.carousel":a.proxy(function(){this._playing&&this.stop()},this),"prepared.owl.carousel":a.proxy(function(b){var c=a(b.content).find(".owl-video");c.length&&(c.css("display","none"),this.fetch(c,a(b.content)))},this)},this._core.options=a.extend({},d.Defaults,this._core.options),this._core.$element.on(this._handlers),this._core.$element.on("click.owl.video",".owl-video-play-icon",a.proxy(function(a){this.play(a)},this))};d.Defaults={video:!1,videoHeight:!1,videoWidth:!1},d.prototype.fetch=function(a,b){var c=a.attr("data-vimeo-id")?"vimeo":"youtube",d=a.attr("data-vimeo-id")||a.attr("data-youtube-id"),e=a.attr("data-width")||this._core.settings.videoWidth,f=a.attr("data-height")||this._core.settings.videoHeight,g=a.attr("href");if(!g)throw new Error("Missing video URL.");if(d=g.match(/(http:|https:|)\/\/(player.|www.)?(vimeo\.com|youtu(be\.com|\.be|be\.googleapis\.com))\/(video\/|embed\/|watch\?v=|v\/)?([A-Za-z0-9._%-]*)(\&\S+)?/),d[3].indexOf("youtu")>-1)c="youtube";else{if(!(d[3].indexOf("vimeo")>-1))throw new Error("Video URL not supported.");c="vimeo"}d=d[6],this._videos[g]={type:c,id:d,width:e,height:f},b.attr("data-video",g),this.thumbnail(a,this._videos[g])},d.prototype.thumbnail=function(b,c){var d,e,f,g=c.width&&c.height?'style="width:'+c.width+"px;height:"+c.height+'px;"':"",h=b.find("img"),i="src",j="",k=this._core.settings,l=function(a){e='<div class="owl-video-play-icon"></div>',d=k.lazyLoad?'<div class="owl-video-tn '+j+'" '+i+'="'+a+'"></div>':'<div class="owl-video-tn" style="opacity:1;background-image:url('+a+')"></div>',b.after(d),b.after(e)};return b.wrap('<div class="owl-video-wrapper"'+g+"></div>"),this._core.settings.lazyLoad&&(i="data-src",j="owl-lazy"),h.length?(l(h.attr(i)),h.remove(),!1):void("youtube"===c.type?(f="http://img.youtube.com/vi/"+c.id+"/hqdefault.jpg",l(f)):"vimeo"===c.type&&a.ajax({type:"GET",url:"http://vimeo.com/api/v2/video/"+c.id+".json",jsonp:"callback",dataType:"jsonp",success:function(a){f=a[0].thumbnail_large,l(f)}}))},d.prototype.stop=function(){this._core.trigger("stop",null,"video"),this._playing.find(".owl-video-frame").remove(),this._playing.removeClass("owl-video-playing"),this._playing=null},d.prototype.play=function(b){this._core.trigger("play",null,"video"),this._playing&&this.stop();var c,d,e=a(b.target||b.srcElement),f=e.closest("."+this._core.settings.itemClass),g=this._videos[f.attr("data-video")],h=g.width||"100%",i=g.height||this._core.$stage.height();"youtube"===g.type?c='<iframe width="'+h+'" height="'+i+'" src="http://www.youtube.com/embed/'+g.id+"?autoplay=1&v="+g.id+'" frameborder="0" allowfullscreen></iframe>':"vimeo"===g.type&&(c='<iframe src="http://player.vimeo.com/video/'+g.id+'?autoplay=1" width="'+h+'" height="'+i+'" frameborder="0" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>'),f.addClass("owl-video-playing"),this._playing=f,d=a('<div style="height:'+i+"px; width:"+h+'px" class="owl-video-frame">'+c+"</div>"),e.after(d)},d.prototype.isInFullScreen=function(){var d=c.fullscreenElement||c.mozFullScreenElement||c.webkitFullscreenElement;return d&&a(d).parent().hasClass("owl-video-frame")&&(this._core.speed(0),this._fullscreen=!0),d&&this._fullscreen&&this._playing?!1:this._fullscreen?(this._fullscreen=!1,!1):this._playing&&this._core.state.orientation!==b.orientation?(this._core.state.orientation=b.orientation,!1):!0},d.prototype.destroy=function(){var a,b;this._core.$element.off("click.owl.video");for(a in this._handlers)this._core.$element.off(a,this._handlers[a]);for(b in Object.getOwnPropertyNames(this))"function"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Video=d}(window.Zepto||window.jQuery,window,document),function(a,b,c,d){var e=function(b){this.core=b,this.core.options=a.extend({},e.Defaults,this.core.options),this.swapping=!0,this.previous=d,this.next=d,this.handlers={"change.owl.carousel":a.proxy(function(a){"position"==a.property.name&&(this.previous=this.core.current(),this.next=a.property.value)},this),"drag.owl.carousel dragged.owl.carousel translated.owl.carousel":a.proxy(function(a){this.swapping="translated"==a.type},this),"translate.owl.carousel":a.proxy(function(){this.swapping&&(this.core.options.animateOut||this.core.options.animateIn)&&this.swap()},this)},this.core.$element.on(this.handlers)};e.Defaults={animateOut:!1,animateIn:!1},e.prototype.swap=function(){if(1===this.core.settings.items&&this.core.support3d){this.core.speed(0);var b,c=a.proxy(this.clear,this),d=this.core.$stage.children().eq(this.previous),e=this.core.$stage.children().eq(this.next),f=this.core.settings.animateIn,g=this.core.settings.animateOut;this.core.current()!==this.previous&&(g&&(b=this.core.coordinates(this.previous)-this.core.coordinates(this.next),d.css({left:b+"px"}).addClass("animated owl-animated-out").addClass(g).one("webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend",c)),f&&e.addClass("animated owl-animated-in").addClass(f).one("webkitAnimationEnd mozAnimationEnd MSAnimationEnd oanimationend animationend",c))}},e.prototype.clear=function(b){a(b.target).css({left:""}).removeClass("animated owl-animated-out owl-animated-in").removeClass(this.core.settings.animateIn).removeClass(this.core.settings.animateOut),this.core.transitionEnd()},e.prototype.destroy=function(){var a,b;for(a in this.handlers)this.core.$element.off(a,this.handlers[a]);for(b in Object.getOwnPropertyNames(this))"function"!=typeof this[b]&&(this[b]=null)},a.fn.owlCarousel.Constructor.Plugins.Animate=e}(window.Zepto||window.jQuery,window,document),function(a,b,c){var d=function(b){this.core=b,this.core.options=a.extend({},d.Defaults,this.core.options),this.handlers={"translated.owl.carousel refreshed.owl.carousel":a.proxy(function(){this.autoplay()},this),"play.owl.autoplay":a.proxy(function(a,b,c){this.play(b,c)},this),"stop.owl.autoplay":a.proxy(function(){this.stop()},this),"mouseover.owl.autoplay":a.proxy(function(){this.core.settings.autoplayHoverPause&&this.pause()},this),"mouseleave.owl.autoplay":a.proxy(function(){this.core.settings.autoplayHoverPause&&this.autoplay()},this)},this.core.$element.on(this.handlers)};d.Defaults={autoplay:!1,autoplayTimeout:5e3,autoplayHoverPause:!1,autoplaySpeed:!1},d.prototype.autoplay=function(){this.core.settings.autoplay&&!this.core.state.videoPlay?(b.clearInterval(this.interval),this.interval=b.setInterval(a.proxy(function(){this.play()},this),this.core.settings.autoplayTimeout)):b.clearInterval(this.interval)},d.prototype.play=function(){return c.hidden===!0||this.core.state.isTouch||this.core.state.isScrolling||this.core.state.isSwiping||this.core.state.inMotion?void 0:this.core.settings.autoplay===!1?void b.clearInterval(this.interval):void this.core.next(this.core.settings.autoplaySpeed)},d.prototype.stop=function(){b.clearInterval(this.interval)},d.prototype.pause=function(){b.clearInterval(this.interval)},d.prototype.destroy=function(){var a,c;b.clearInterval(this.interval);for(a in this.handlers)this.core.$element.off(a,this.handlers[a]);for(c in Object.getOwnPropertyNames(this))"function"!=typeof this[c]&&(this[c]=null)},a.fn.owlCarousel.Constructor.Plugins.autoplay=d}(window.Zepto||window.jQuery,window,document),function(a){"use strict";var b=function(c){this._core=c,this._initialized=!1,this._pages=[],this._controls={},this._templates=[],this.$element=this._core.$element,this._overrides={next:this._core.next,prev:this._core.prev,to:this._core.to},this._handlers={"prepared.owl.carousel":a.proxy(function(b){this._core.settings.dotsData&&this._templates.push(a(b.content).find("[data-dot]").andSelf("[data-dot]").attr("data-dot"))},this),"add.owl.carousel":a.proxy(function(b){this._core.settings.dotsData&&this._templates.splice(b.position,0,a(b.content).find("[data-dot]").andSelf("[data-dot]").attr("data-dot"))},this),"remove.owl.carousel prepared.owl.carousel":a.proxy(function(a){this._core.settings.dotsData&&this._templates.splice(a.position,1)},this),"change.owl.carousel":a.proxy(function(a){if("position"==a.property.name&&!this._core.state.revert&&!this._core.settings.loop&&this._core.settings.navRewind){var b=this._core.current(),c=this._core.maximum(),d=this._core.minimum();a.data=a.property.value>c?b>=c?d:c:a.property.value<d?c:a.property.value}},this),"changed.owl.carousel":a.proxy(function(a){"position"==a.property.name&&this.draw()},this),"refreshed.owl.carousel":a.proxy(function(){this._initialized||(this.initialize(),this._initialized=!0),this._core.trigger("refresh",null,"navigation"),this.update(),this.draw(),this._core.trigger("refreshed",null,"navigation")},this)},this._core.options=a.extend({},b.Defaults,this._core.options),this.$element.on(this._handlers)};b.Defaults={nav:!1,navRewind:!0,navText:["prev","next"],navSpeed:!1,navElement:"div",navContainer:!1,navContainerClass:"owl-nav",navClass:["owl-prev","owl-next"],slideBy:1,dotClass:"owl-dot",dotsClass:"owl-dots",dots:!0,dotsEach:!1,dotData:!1,dotsSpeed:!1,dotsContainer:!1,controlsClass:"owl-controls"},b.prototype.initialize=function(){var b,c,d=this._core.settings;d.dotsData||(this._templates=[a("<div>").addClass(d.dotClass).append(a("<span>")).prop("outerHTML")]),d.navContainer&&d.dotsContainer||(this._controls.$container=a("<div>").addClass(d.controlsClass).appendTo(this.$element)),this._controls.$indicators=d.dotsContainer?a(d.dotsContainer):a("<div>").hide().addClass(d.dotsClass).appendTo(this._controls.$container),this._controls.$indicators.on("click","div",a.proxy(function(b){var c=a(b.target).parent().is(this._controls.$indicators)?a(b.target).index():a(b.target).parent().index();b.preventDefault(),this.to(c,d.dotsSpeed)},this)),b=d.navContainer?a(d.navContainer):a("<div>").addClass(d.navContainerClass).prependTo(this._controls.$container),this._controls.$next=a("<"+d.navElement+">"),this._controls.$previous=this._controls.$next.clone(),this._controls.$previous.addClass(d.navClass[0]).html(d.navText[0]).hide().prependTo(b).on("click",a.proxy(function(){this.prev(d.navSpeed)},this)),this._controls.$next.addClass(d.navClass[1]).html(d.navText[1]).hide().appendTo(b).on("click",a.proxy(function(){this.next(d.navSpeed)},this));for(c in this._overrides)this._core[c]=a.proxy(this[c],this)},b.prototype.destroy=function(){var a,b,c,d;for(a in this._handlers)this.$element.off(a,this._handlers[a]);for(b in this._controls)this._controls[b].remove();for(d in this.overides)this._core[d]=this._overrides[d];for(c in Object.getOwnPropertyNames(this))"function"!=typeof this[c]&&(this[c]=null)},b.prototype.update=function(){var a,b,c,d=this._core.settings,e=this._core.clones().length/2,f=e+this._core.items().length,g=d.center||d.autoWidth||d.dotData?1:d.dotsEach||d.items;if("page"!==d.slideBy&&(d.slideBy=Math.min(d.slideBy,d.items)),d.dots||"page"==d.slideBy)for(this._pages=[],a=e,b=0,c=0;f>a;a++)(b>=g||0===b)&&(this._pages.push({start:a-e,end:a-e+g-1}),b=0,++c),b+=this._core.mergers(this._core.relative(a))},b.prototype.draw=function(){var b,c,d="",e=this._core.settings,f=(this._core.$stage.children(),this._core.relative(this._core.current()));if(!e.nav||e.loop||e.navRewind||(this._controls.$previous.toggleClass("disabled",0>=f),this._controls.$next.toggleClass("disabled",f>=this._core.maximum())),this._controls.$previous.toggle(e.nav),this._controls.$next.toggle(e.nav),e.dots){if(b=this._pages.length-this._controls.$indicators.children().length,e.dotData&&0!==b){for(c=0;c<this._controls.$indicators.children().length;c++)d+=this._templates[this._core.relative(c)];this._controls.$indicators.html(d)}else b>0?(d=new Array(b+1).join(this._templates[0]),this._controls.$indicators.append(d)):0>b&&this._controls.$indicators.children().slice(b).remove();this._controls.$indicators.find(".active").removeClass("active"),this._controls.$indicators.children().eq(a.inArray(this.current(),this._pages)).addClass("active")}this._controls.$indicators.toggle(e.dots)},b.prototype.onTrigger=function(b){var c=this._core.settings;b.page={index:a.inArray(this.current(),this._pages),count:this._pages.length,size:c&&(c.center||c.autoWidth||c.dotData?1:c.dotsEach||c.items)}},b.prototype.current=function(){var b=this._core.relative(this._core.current());return a.grep(this._pages,function(a){return a.start<=b&&a.end>=b}).pop()},b.prototype.getPosition=function(b){var c,d,e=this._core.settings;return"page"==e.slideBy?(c=a.inArray(this.current(),this._pages),d=this._pages.length,b?++c:--c,c=this._pages[(c%d+d)%d].start):(c=this._core.relative(this._core.current()),d=this._core.items().length,b?c+=e.slideBy:c-=e.slideBy),c},b.prototype.next=function(b){a.proxy(this._overrides.to,this._core)(this.getPosition(!0),b)},b.prototype.prev=function(b){a.proxy(this._overrides.to,this._core)(this.getPosition(!1),b)},b.prototype.to=function(b,c,d){var e;d?a.proxy(this._overrides.to,this._core)(b,c):(e=this._pages.length,a.proxy(this._overrides.to,this._core)(this._pages[(b%e+e)%e].start,c))},a.fn.owlCarousel.Constructor.Plugins.Navigation=b}(window.Zepto||window.jQuery,window,document),function(a,b){"use strict";var c=function(d){this._core=d,this._hashes={},this.$element=this._core.$element,this._handlers={"initialized.owl.carousel":a.proxy(function(){"URLHash"==this._core.settings.startPosition&&a(b).trigger("hashchange.owl.navigation")},this),"prepared.owl.carousel":a.proxy(function(b){var c=a(b.content).find("[data-hash]").andSelf("[data-hash]").attr("data-hash");this._hashes[c]=b.content},this)},this._core.options=a.extend({},c.Defaults,this._core.options),this.$element.on(this._handlers),a(b).on("hashchange.owl.navigation",a.proxy(function(){var a=b.location.hash.substring(1),c=this._core.$stage.children(),d=this._hashes[a]&&c.index(this._hashes[a])||0;return a?void this._core.to(d,!1,!0):!1},this))};c.Defaults={URLhashListener:!1},c.prototype.destroy=function(){var c,d;a(b).off("hashchange.owl.navigation");for(c in this._handlers)this._core.$element.off(c,this._handlers[c]);for(d in Object.getOwnPropertyNames(this))"function"!=typeof this[d]&&(this[d]=null)},a.fn.owlCarousel.Constructor.Plugins.Hash=c}(window.Zepto||window.jQuery,window,document);;

/* /theme_crafito/static/src/js/plugins/ion.rangeSlider.min.js defined in bundle 'web.assets_frontend' */
﻿;(function(f,r,h,t,v){var u=0,p=function(){var a=t.userAgent,b=/msie\s\d+/i;return 0<a.search(b)&&(a=b.exec(a).toString(),a=a.split(" ")[1],9>a)?(f("html").addClass("lt-ie9"),!0):!1}();Function.prototype.bind||(Function.prototype.bind=function(a){var b=this,d=[].slice;if("function"!=typeof b)throw new TypeError;var c=d.call(arguments,1),e=function(){if(this instanceof e){var g=function(){};g.prototype=b.prototype;var g=new g,l=b.apply(g,c.concat(d.call(arguments)));return Object(l)===l?l:g}return b.apply(a,c.concat(d.call(arguments)))};return e});Array.prototype.indexOf||(Array.prototype.indexOf=function(a,b){var d;if(null==this)throw new TypeError('"this" is null or not defined');var c=Object(this),e=c.length>>>0;if(0===e)return-1;d=+b||0;Infinity===Math.abs(d)&&(d=0);if(d>=e)return-1;for(d=Math.max(0<=d?d:e-Math.abs(d),0);d<e;){if(d in c&&c[d]===a)return d;d++}return-1});var q=function(a,b,d){this.VERSION="2.1.2";this.input=a;this.plugin_count=d;this.old_to=this.old_from=this.update_tm=this.calc_count=this.current_plugin=0;this.raf_id=this.old_min_interval=null;this.is_update=this.is_key=this.no_diapason=this.force_redraw=this.dragging=!1;this.is_start=!0;this.is_click=this.is_resize=this.is_active=this.is_finish=!1;this.$cache={win:f(h),body:f(r.body),input:f(a),cont:null,rs:null,min:null,max:null,from:null,to:null,single:null,bar:null,line:null,s_single:null,s_from:null,s_to:null,shad_single:null,shad_from:null,shad_to:null,edge:null,grid:null,grid_labels:[]};this.coords={x_gap:0,x_pointer:0,w_rs:0,w_rs_old:0,w_handle:0,p_gap:0,p_gap_left:0,p_gap_right:0,p_step:0,p_pointer:0,p_handle:0,p_single_fake:0,p_single_real:0,p_from_fake:0,p_from_real:0,p_to_fake:0,p_to_real:0,p_bar_x:0,p_bar_w:0,grid_gap:0,big_num:0,big:[],big_w:[],big_p:[],big_x:[]};this.labels={w_min:0,w_max:0,w_from:0,w_to:0,w_single:0,p_min:0,p_max:0,p_from_fake:0,p_from_left:0,p_to_fake:0,p_to_left:0,p_single_fake:0,p_single_left:0};var c=this.$cache.input;a=c.prop("value");var e;d={type:"single",min:10,max:100,from:null,to:null,step:1,min_interval:0,max_interval:0,drag_interval:!1,values:[],p_values:[],from_fixed:!1,from_min:null,from_max:null,from_shadow:!1,to_fixed:!1,to_min:null,to_max:null,to_shadow:!1,prettify_enabled:!0,prettify_separator:" ",prettify:null,force_edges:!1,keyboard:!1,keyboard_step:5,grid:!1,grid_margin:!0,grid_num:4,grid_snap:!1,hide_min_max:!1,hide_from_to:!1,prefix:"",postfix:"",max_postfix:"",decorate_both:!0,values_separator:" \u2014 ",input_values_separator:";",disable:!1,onStart:null,onChange:null,onFinish:null,onUpdate:null};c={type:c.data("type"),min:c.data("min"),max:c.data("max"),from:c.data("from"),to:c.data("to"),step:c.data("step"),min_interval:c.data("minInterval"),max_interval:c.data("maxInterval"),drag_interval:c.data("dragInterval"),values:c.data("values"),from_fixed:c.data("fromFixed"),from_min:c.data("fromMin"),from_max:c.data("fromMax"),from_shadow:c.data("fromShadow"),to_fixed:c.data("toFixed"),to_min:c.data("toMin"),to_max:c.data("toMax"),to_shadow:c.data("toShadow"),prettify_enabled:c.data("prettifyEnabled"),prettify_separator:c.data("prettifySeparator"),force_edges:c.data("forceEdges"),keyboard:c.data("keyboard"),keyboard_step:c.data("keyboardStep"),grid:c.data("grid"),grid_margin:c.data("gridMargin"),grid_num:c.data("gridNum"),grid_snap:c.data("gridSnap"),hide_min_max:c.data("hideMinMax"),hide_from_to:c.data("hideFromTo"),prefix:c.data("prefix"),postfix:c.data("postfix"),max_postfix:c.data("maxPostfix"),decorate_both:c.data("decorateBoth"),values_separator:c.data("valuesSeparator"),input_values_separator:c.data("inputValuesSeparator"),disable:c.data("disable")};c.values=c.values&&c.values.split(",");for(e in c)c.hasOwnProperty(e)&&(c[e]||0===c[e]||delete c[e]);a&&(a=a.split(c.input_values_separator||b.input_values_separator||";"),a[0]&&a[0]==+a[0]&&(a[0]=+a[0]),a[1]&&a[1]==+a[1]&&(a[1]=+a[1]),b&&b.values&&b.values.length?(d.from=a[0]&&b.values.indexOf(a[0]),d.to=a[1]&&b.values.indexOf(a[1])):(d.from=a[0]&&+a[0],d.to=a[1]&&+a[1]));f.extend(d,b);f.extend(d,c);this.options=d;this.validate();this.result={input:this.$cache.input,slider:null,min:this.options.min,max:this.options.max,from:this.options.from,from_percent:0,from_value:null,to:this.options.to,to_percent:0,to_value:null};this.init()};q.prototype={init:function(a){this.no_diapason=!1;this.coords.p_step=this.convertToPercent(this.options.step,!0);this.target="base";this.toggleInput();this.append();this.setMinMax();a?(this.force_redraw=!0,this.calc(!0),this.callOnUpdate()):(this.force_redraw=!0,this.calc(!0),this.callOnStart());this.updateScene()},append:function(){this.$cache.input.before('<span class="irs js-irs-'+this.plugin_count+'"></span>');this.$cache.input.prop("readonly",!0);this.$cache.cont=this.$cache.input.prev();this.result.slider=this.$cache.cont;this.$cache.cont.html('<span class="irs"><span class="irs-line" tabindex="-1"><span class="irs-line-left"></span><span class="irs-line-mid"></span><span class="irs-line-right"></span></span><span class="irs-min">0</span><span class="irs-max">1</span><span class="irs-from">0</span><span class="irs-to">0</span><span class="irs-single">0</span></span><span class="irs-grid"></span><span class="irs-bar"></span>');this.$cache.rs=this.$cache.cont.find(".irs");this.$cache.min=this.$cache.cont.find(".irs-min");this.$cache.max=this.$cache.cont.find(".irs-max");this.$cache.from=this.$cache.cont.find(".irs-from");this.$cache.to=this.$cache.cont.find(".irs-to");this.$cache.single=this.$cache.cont.find(".irs-single");this.$cache.bar=this.$cache.cont.find(".irs-bar");this.$cache.line=this.$cache.cont.find(".irs-line");this.$cache.grid=this.$cache.cont.find(".irs-grid");"single"===this.options.type?(this.$cache.cont.append('<span class="irs-bar-edge"></span><span class="irs-shadow shadow-single"></span><span class="irs-slider single"></span>'),this.$cache.edge=this.$cache.cont.find(".irs-bar-edge"),this.$cache.s_single=this.$cache.cont.find(".single"),this.$cache.from[0].style.visibility="hidden",this.$cache.to[0].style.visibility="hidden",this.$cache.shad_single=this.$cache.cont.find(".shadow-single")):(this.$cache.cont.append('<span class="irs-shadow shadow-from"></span><span class="irs-shadow shadow-to"></span><span class="irs-slider from"></span><span class="irs-slider to"></span>'),this.$cache.s_from=this.$cache.cont.find(".from"),this.$cache.s_to=this.$cache.cont.find(".to"),this.$cache.shad_from=this.$cache.cont.find(".shadow-from"),this.$cache.shad_to=this.$cache.cont.find(".shadow-to"),this.setTopHandler());this.options.hide_from_to&&(this.$cache.from[0].style.display="none",this.$cache.to[0].style.display="none",this.$cache.single[0].style.display="none");this.appendGrid();this.options.disable?(this.appendDisableMask(),this.$cache.input[0].disabled=!0):(this.$cache.cont.removeClass("irs-disabled"),this.$cache.input[0].disabled=!1,this.bindEvents());this.options.drag_interval&&(this.$cache.bar[0].style.cursor="ew-resize")},setTopHandler:function(){var a=this.options.max,b=this.options.to;this.options.from>this.options.min&&b===a?this.$cache.s_from.addClass("type_last"):b<a&&this.$cache.s_to.addClass("type_last")},changeLevel:function(a){switch(a){case"single":this.coords.p_gap=this.toFixed(this.coords.p_pointer-this.coords.p_single_fake);break;case"from":this.coords.p_gap=this.toFixed(this.coords.p_pointer-this.coords.p_from_fake);this.$cache.s_from.addClass("state_hover");this.$cache.s_from.addClass("type_last");this.$cache.s_to.removeClass("type_last");break;case"to":this.coords.p_gap=this.toFixed(this.coords.p_pointer-this.coords.p_to_fake);this.$cache.s_to.addClass("state_hover");this.$cache.s_to.addClass("type_last");this.$cache.s_from.removeClass("type_last");break;case"both":this.coords.p_gap_left=this.toFixed(this.coords.p_pointer-this.coords.p_from_fake),this.coords.p_gap_right=this.toFixed(this.coords.p_to_fake-
this.coords.p_pointer),this.$cache.s_to.removeClass("type_last"),this.$cache.s_from.removeClass("type_last")}},appendDisableMask:function(){this.$cache.cont.append('<span class="irs-disable-mask"></span>');this.$cache.cont.addClass("irs-disabled")},remove:function(){this.$cache.cont.remove();this.$cache.cont=null;this.$cache.line.off("keydown.irs_"+this.plugin_count);this.$cache.body.off("touchmove.irs_"+this.plugin_count);this.$cache.body.off("mousemove.irs_"+this.plugin_count);this.$cache.win.off("touchend.irs_"+
this.plugin_count);this.$cache.win.off("mouseup.irs_"+this.plugin_count);p&&(this.$cache.body.off("mouseup.irs_"+this.plugin_count),this.$cache.body.off("mouseleave.irs_"+this.plugin_count));this.$cache.grid_labels=[];this.coords.big=[];this.coords.big_w=[];this.coords.big_p=[];this.coords.big_x=[];cancelAnimationFrame(this.raf_id)},bindEvents:function(){if(!this.no_diapason){this.$cache.body.on("touchmove.irs_"+this.plugin_count,this.pointerMove.bind(this));this.$cache.body.on("mousemove.irs_"+this.plugin_count,this.pointerMove.bind(this));this.$cache.win.on("touchend.irs_"+this.plugin_count,this.pointerUp.bind(this));this.$cache.win.on("mouseup.irs_"+this.plugin_count,this.pointerUp.bind(this));this.$cache.line.on("touchstart.irs_"+this.plugin_count,this.pointerClick.bind(this,"click"));this.$cache.line.on("mousedown.irs_"+this.plugin_count,this.pointerClick.bind(this,"click"));this.options.drag_interval&&"double"===this.options.type?(this.$cache.bar.on("touchstart.irs_"+this.plugin_count,this.pointerDown.bind(this,"both")),this.$cache.bar.on("mousedown.irs_"+this.plugin_count,this.pointerDown.bind(this,"both"))):(this.$cache.bar.on("touchstart.irs_"+this.plugin_count,this.pointerClick.bind(this,"click")),this.$cache.bar.on("mousedown.irs_"+this.plugin_count,this.pointerClick.bind(this,"click")));"single"===this.options.type?(this.$cache.single.on("touchstart.irs_"+this.plugin_count,this.pointerDown.bind(this,"single")),this.$cache.s_single.on("touchstart.irs_"+this.plugin_count,this.pointerDown.bind(this,"single")),this.$cache.shad_single.on("touchstart.irs_"+this.plugin_count,this.pointerClick.bind(this,"click")),this.$cache.single.on("mousedown.irs_"+this.plugin_count,this.pointerDown.bind(this,"single")),this.$cache.s_single.on("mousedown.irs_"+this.plugin_count,this.pointerDown.bind(this,"single")),this.$cache.edge.on("mousedown.irs_"+this.plugin_count,this.pointerClick.bind(this,"click")),this.$cache.shad_single.on("mousedown.irs_"+this.plugin_count,this.pointerClick.bind(this,"click"))):(this.$cache.single.on("touchstart.irs_"+
this.plugin_count,this.pointerDown.bind(this,null)),this.$cache.single.on("mousedown.irs_"+this.plugin_count,this.pointerDown.bind(this,null)),this.$cache.from.on("touchstart.irs_"+this.plugin_count,this.pointerDown.bind(this,"from")),this.$cache.s_from.on("touchstart.irs_"+this.plugin_count,this.pointerDown.bind(this,"from")),this.$cache.to.on("touchstart.irs_"+this.plugin_count,this.pointerDown.bind(this,"to")),this.$cache.s_to.on("touchstart.irs_"+this.plugin_count,this.pointerDown.bind(this,"to")),this.$cache.shad_from.on("touchstart.irs_"+this.plugin_count,this.pointerClick.bind(this,"click")),this.$cache.shad_to.on("touchstart.irs_"+this.plugin_count,this.pointerClick.bind(this,"click")),this.$cache.from.on("mousedown.irs_"+this.plugin_count,this.pointerDown.bind(this,"from")),this.$cache.s_from.on("mousedown.irs_"+this.plugin_count,this.pointerDown.bind(this,"from")),this.$cache.to.on("mousedown.irs_"+this.plugin_count,this.pointerDown.bind(this,"to")),this.$cache.s_to.on("mousedown.irs_"+
this.plugin_count,this.pointerDown.bind(this,"to")),this.$cache.shad_from.on("mousedown.irs_"+this.plugin_count,this.pointerClick.bind(this,"click")),this.$cache.shad_to.on("mousedown.irs_"+this.plugin_count,this.pointerClick.bind(this,"click")));if(this.options.keyboard)this.$cache.line.on("keydown.irs_"+this.plugin_count,this.key.bind(this,"keyboard"));p&&(this.$cache.body.on("mouseup.irs_"+this.plugin_count,this.pointerUp.bind(this)),this.$cache.body.on("mouseleave.irs_"+this.plugin_count,this.pointerUp.bind(this)))}},pointerMove:function(a){this.dragging&&(this.coords.x_pointer=(a.pageX||a.originalEvent.touches&&a.originalEvent.touches[0].pageX)-this.coords.x_gap,this.calc())},pointerUp:function(a){if(this.current_plugin===this.plugin_count&&this.is_active){this.is_active=!1;this.$cache.cont.find(".state_hover").removeClass("state_hover");this.force_redraw=!0;p&&f("*").prop("unselectable",!1);this.updateScene();this.restoreOriginalMinInterval();if(f.contains(this.$cache.cont[0],a.target)||this.dragging)this.is_finish=!0,this.callOnFinish();this.dragging=!1}},pointerDown:function(a,b){b.preventDefault();var d=b.pageX||b.originalEvent.touches&&b.originalEvent.touches[0].pageX;2!==b.button&&("both"===a&&this.setTempMinInterval(),a||(a=this.target),this.current_plugin=this.plugin_count,this.target=a,this.dragging=this.is_active=!0,this.coords.x_gap=this.$cache.rs.offset().left,this.coords.x_pointer=d-this.coords.x_gap,this.calcPointerPercent(),this.changeLevel(a),p&&f("*").prop("unselectable",!0),this.$cache.line.trigger("focus"),this.updateScene())},pointerClick:function(a,b){b.preventDefault();var d=b.pageX||b.originalEvent.touches&&b.originalEvent.touches[0].pageX;2!==b.button&&(this.current_plugin=this.plugin_count,this.target=a,this.is_click=!0,this.coords.x_gap=this.$cache.rs.offset().left,this.coords.x_pointer=+(d-this.coords.x_gap).toFixed(),this.force_redraw=!0,this.calc(),this.$cache.line.trigger("focus"))},key:function(a,b){if(!(this.current_plugin!==this.plugin_count||b.altKey||b.ctrlKey||b.shiftKey||b.metaKey)){switch(b.which){case 83:case 65:case 40:case 37:b.preventDefault();this.moveByKey(!1);break;case 87:case 68:case 38:case 39:b.preventDefault(),this.moveByKey(!0)}return!0}},moveByKey:function(a){var b=this.coords.p_pointer,b=a?b+this.options.keyboard_step:b-this.options.keyboard_step;this.coords.x_pointer=this.toFixed(this.coords.w_rs/100*b);this.is_key=!0;this.calc()},setMinMax:function(){this.options&&(this.options.hide_min_max?(this.$cache.min[0].style.display="none",this.$cache.max[0].style.display="none"):(this.options.values.length?(this.$cache.min.html(this.decorate(this.options.p_values[this.options.min])),this.$cache.max.html(this.decorate(this.options.p_values[this.options.max]))):(this.$cache.min.html(this.decorate(this._prettify(this.options.min),this.options.min)),this.$cache.max.html(this.decorate(this._prettify(this.options.max),this.options.max))),this.labels.w_min=this.$cache.min.outerWidth(!1),this.labels.w_max=this.$cache.max.outerWidth(!1)))},setTempMinInterval:function(){var a=this.result.to-this.result.from;null===this.old_min_interval&&(this.old_min_interval=this.options.min_interval);this.options.min_interval=a},restoreOriginalMinInterval:function(){null!==this.old_min_interval&&(this.options.min_interval=this.old_min_interval,this.old_min_interval=null)},calc:function(a){if(this.options){this.calc_count++;if(10===this.calc_count||a)this.calc_count=0,this.coords.w_rs=this.$cache.rs.outerWidth(!1),this.calcHandlePercent();if(this.coords.w_rs){this.calcPointerPercent();a=this.getHandleX();"click"===this.target&&(this.coords.p_gap=this.coords.p_handle/2,a=this.getHandleX(),this.target=this.options.drag_interval?"both_one":this.chooseHandle(a));switch(this.target){case"base":var b=(this.options.max-this.options.min)/100;a=(this.result.from-this.options.min)/b;b=(this.result.to-this.options.min)/b;this.coords.p_single_real=this.toFixed(a);this.coords.p_from_real=this.toFixed(a);this.coords.p_to_real=this.toFixed(b);this.coords.p_single_real=this.checkDiapason(this.coords.p_single_real,this.options.from_min,this.options.from_max);this.coords.p_from_real=this.checkDiapason(this.coords.p_from_real,this.options.from_min,this.options.from_max);this.coords.p_to_real=this.checkDiapason(this.coords.p_to_real,this.options.to_min,this.options.to_max);this.coords.p_single_fake=this.convertToFakePercent(this.coords.p_single_real);this.coords.p_from_fake=this.convertToFakePercent(this.coords.p_from_real);this.coords.p_to_fake=this.convertToFakePercent(this.coords.p_to_real);this.target=null;break;case"single":if(this.options.from_fixed)break;this.coords.p_single_real=this.convertToRealPercent(a);this.coords.p_single_real=this.calcWithStep(this.coords.p_single_real);this.coords.p_single_real=this.checkDiapason(this.coords.p_single_real,this.options.from_min,this.options.from_max);this.coords.p_single_fake=this.convertToFakePercent(this.coords.p_single_real);break;case"from":if(this.options.from_fixed)break;this.coords.p_from_real=this.convertToRealPercent(a);this.coords.p_from_real=this.calcWithStep(this.coords.p_from_real);this.coords.p_from_real>this.coords.p_to_real&&(this.coords.p_from_real=this.coords.p_to_real);this.coords.p_from_real=this.checkDiapason(this.coords.p_from_real,this.options.from_min,this.options.from_max);this.coords.p_from_real=this.checkMinInterval(this.coords.p_from_real,this.coords.p_to_real,"from");this.coords.p_from_real=this.checkMaxInterval(this.coords.p_from_real,this.coords.p_to_real,"from");this.coords.p_from_fake=this.convertToFakePercent(this.coords.p_from_real);break;case"to":if(this.options.to_fixed)break;this.coords.p_to_real=this.convertToRealPercent(a);this.coords.p_to_real=this.calcWithStep(this.coords.p_to_real);this.coords.p_to_real<this.coords.p_from_real&&(this.coords.p_to_real=this.coords.p_from_real);this.coords.p_to_real=this.checkDiapason(this.coords.p_to_real,this.options.to_min,this.options.to_max);this.coords.p_to_real=this.checkMinInterval(this.coords.p_to_real,this.coords.p_from_real,"to");this.coords.p_to_real=this.checkMaxInterval(this.coords.p_to_real,this.coords.p_from_real,"to");this.coords.p_to_fake=this.convertToFakePercent(this.coords.p_to_real);break;case"both":if(this.options.from_fixed||this.options.to_fixed)break;a=this.toFixed(a+.1*this.coords.p_handle);this.coords.p_from_real=this.convertToRealPercent(a)-this.coords.p_gap_left;this.coords.p_from_real=this.calcWithStep(this.coords.p_from_real);this.coords.p_from_real=this.checkDiapason(this.coords.p_from_real,this.options.from_min,this.options.from_max);this.coords.p_from_real=this.checkMinInterval(this.coords.p_from_real,this.coords.p_to_real,"from");this.coords.p_from_fake=this.convertToFakePercent(this.coords.p_from_real);this.coords.p_to_real=this.convertToRealPercent(a)+this.coords.p_gap_right;this.coords.p_to_real=this.calcWithStep(this.coords.p_to_real);this.coords.p_to_real=this.checkDiapason(this.coords.p_to_real,this.options.to_min,this.options.to_max);this.coords.p_to_real=this.checkMinInterval(this.coords.p_to_real,this.coords.p_from_real,"to");this.coords.p_to_fake=this.convertToFakePercent(this.coords.p_to_real);break;case"both_one":if(this.options.from_fixed||this.options.to_fixed)break;var d=this.convertToRealPercent(a);a=this.result.to_percent-this.result.from_percent;var c=a/2,b=d-c,d=d+c;0>b&&(b=0,d=b+a);100<d&&(d=100,b=d-a);this.coords.p_from_real=this.calcWithStep(b);this.coords.p_from_real=this.checkDiapason(this.coords.p_from_real,this.options.from_min,this.options.from_max);this.coords.p_from_fake=this.convertToFakePercent(this.coords.p_from_real);this.coords.p_to_real=this.calcWithStep(d);this.coords.p_to_real=this.checkDiapason(this.coords.p_to_real,this.options.to_min,this.options.to_max);this.coords.p_to_fake=this.convertToFakePercent(this.coords.p_to_real)}"single"===this.options.type?(this.coords.p_bar_x=this.coords.p_handle/2,this.coords.p_bar_w=this.coords.p_single_fake,this.result.from_percent=this.coords.p_single_real,this.result.from=this.convertToValue(this.coords.p_single_real),this.options.values.length&&(this.result.from_value=this.options.values[this.result.from])):(this.coords.p_bar_x=this.toFixed(this.coords.p_from_fake+this.coords.p_handle/2),this.coords.p_bar_w=this.toFixed(this.coords.p_to_fake-
this.coords.p_from_fake),this.result.from_percent=this.coords.p_from_real,this.result.from=this.convertToValue(this.coords.p_from_real),this.result.to_percent=this.coords.p_to_real,this.result.to=this.convertToValue(this.coords.p_to_real),this.options.values.length&&(this.result.from_value=this.options.values[this.result.from],this.result.to_value=this.options.values[this.result.to]));this.calcMinMax();this.calcLabels()}}},calcPointerPercent:function(){this.coords.w_rs?(0>this.coords.x_pointer||isNaN(this.coords.x_pointer)?this.coords.x_pointer=0:this.coords.x_pointer>this.coords.w_rs&&(this.coords.x_pointer=this.coords.w_rs),this.coords.p_pointer=this.toFixed(this.coords.x_pointer/this.coords.w_rs*100)):this.coords.p_pointer=0},convertToRealPercent:function(a){return a/(100-this.coords.p_handle)*100},convertToFakePercent:function(a){return a/100*(100-this.coords.p_handle)},getHandleX:function(){var a=100-this.coords.p_handle,b=this.toFixed(this.coords.p_pointer-this.coords.p_gap);0>b?b=0:b>a&&(b=a);return b},calcHandlePercent:function(){this.coords.w_handle="single"===this.options.type?this.$cache.s_single.outerWidth(!1):this.$cache.s_from.outerWidth(!1);this.coords.p_handle=this.toFixed(this.coords.w_handle/this.coords.w_rs*100)},chooseHandle:function(a){return"single"===this.options.type?"single":a>=this.coords.p_from_real+(this.coords.p_to_real-this.coords.p_from_real)/2?this.options.to_fixed?"from":"to":this.options.from_fixed?"to":"from"},calcMinMax:function(){this.coords.w_rs&&(this.labels.p_min=this.labels.w_min/this.coords.w_rs*100,this.labels.p_max=this.labels.w_max/this.coords.w_rs*100)},calcLabels:function(){this.coords.w_rs&&!this.options.hide_from_to&&("single"===this.options.type?(this.labels.w_single=this.$cache.single.outerWidth(!1),this.labels.p_single_fake=this.labels.w_single/this.coords.w_rs*100,this.labels.p_single_left=this.coords.p_single_fake+this.coords.p_handle/2-this.labels.p_single_fake/2):(this.labels.w_from=this.$cache.from.outerWidth(!1),this.labels.p_from_fake=this.labels.w_from/this.coords.w_rs*100,this.labels.p_from_left=this.coords.p_from_fake+this.coords.p_handle/2-this.labels.p_from_fake/2,this.labels.p_from_left=this.toFixed(this.labels.p_from_left),this.labels.p_from_left=this.checkEdges(this.labels.p_from_left,this.labels.p_from_fake),this.labels.w_to=this.$cache.to.outerWidth(!1),this.labels.p_to_fake=this.labels.w_to/this.coords.w_rs*100,this.labels.p_to_left=this.coords.p_to_fake+this.coords.p_handle/2-this.labels.p_to_fake/2,this.labels.p_to_left=this.toFixed(this.labels.p_to_left),this.labels.p_to_left=this.checkEdges(this.labels.p_to_left,this.labels.p_to_fake),this.labels.w_single=this.$cache.single.outerWidth(!1),this.labels.p_single_fake=this.labels.w_single/this.coords.w_rs*100,this.labels.p_single_left=(this.labels.p_from_left+this.labels.p_to_left+this.labels.p_to_fake)/2-this.labels.p_single_fake/2,this.labels.p_single_left=this.toFixed(this.labels.p_single_left)),this.labels.p_single_left=this.checkEdges(this.labels.p_single_left,this.labels.p_single_fake))},updateScene:function(){this.raf_id&&(cancelAnimationFrame(this.raf_id),this.raf_id=null);clearTimeout(this.update_tm);this.update_tm=null;this.options&&(this.drawHandles(),this.is_active?this.raf_id=requestAnimationFrame(this.updateScene.bind(this)):this.update_tm=setTimeout(this.updateScene.bind(this),300))},drawHandles:function(){this.coords.w_rs=this.$cache.rs.outerWidth(!1);if(this.coords.w_rs){this.coords.w_rs!==this.coords.w_rs_old&&(this.target="base",this.is_resize=!0);if(this.coords.w_rs!==this.coords.w_rs_old||this.force_redraw)this.setMinMax(),this.calc(!0),this.drawLabels(),this.options.grid&&(this.calcGridMargin(),this.calcGridLabels()),this.force_redraw=!0,this.coords.w_rs_old=this.coords.w_rs,this.drawShadow();if(this.coords.w_rs&&(this.dragging||this.force_redraw||this.is_key)){if(this.old_from!==this.result.from||this.old_to!==this.result.to||this.force_redraw||this.is_key){this.drawLabels();this.$cache.bar[0].style.left=this.coords.p_bar_x+"%";this.$cache.bar[0].style.width=this.coords.p_bar_w+"%";if("single"===this.options.type)this.$cache.s_single[0].style.left=this.coords.p_single_fake+"%",this.$cache.single[0].style.left=this.labels.p_single_left+"%",this.options.values.length?this.$cache.input.prop("value",this.result.from_value):this.$cache.input.prop("value",this.result.from),this.$cache.input.data("from",this.result.from);else{this.$cache.s_from[0].style.left=this.coords.p_from_fake+"%";this.$cache.s_to[0].style.left=this.coords.p_to_fake+"%";if(this.old_from!==this.result.from||this.force_redraw)this.$cache.from[0].style.left=this.labels.p_from_left+"%";if(this.old_to!==this.result.to||this.force_redraw)this.$cache.to[0].style.left=this.labels.p_to_left+"%";this.$cache.single[0].style.left=this.labels.p_single_left+"%";this.options.values.length?this.$cache.input.prop("value",this.result.from_value+this.options.input_values_separator+this.result.to_value):this.$cache.input.prop("value",this.result.from+this.options.input_values_separator+this.result.to);this.$cache.input.data("from",this.result.from);this.$cache.input.data("to",this.result.to)}this.old_from===this.result.from&&this.old_to===this.result.to||this.is_start||this.$cache.input.trigger("change");this.old_from=this.result.from;this.old_to=this.result.to;this.is_resize||this.is_update||this.is_start||this.is_finish||this.callOnChange();if(this.is_key||this.is_click)this.is_click=this.is_key=!1,this.callOnFinish();this.is_finish=this.is_resize=this.is_update=!1}this.force_redraw=this.is_click=this.is_key=this.is_start=!1}}},drawLabels:function(){if(this.options){var a=this.options.values.length,b=this.options.p_values,d;if(!this.options.hide_from_to)if("single"===this.options.type)a=a?this.decorate(b[this.result.from]):this.decorate(this._prettify(this.result.from),this.result.from),this.$cache.single.html(a),this.calcLabels(),this.$cache.min[0].style.visibility=this.labels.p_single_left<this.labels.p_min+1?"hidden":"visible",this.$cache.max[0].style.visibility=this.labels.p_single_left+this.labels.p_single_fake>100-this.labels.p_max-1?"hidden":"visible";else{a?(this.options.decorate_both?(a=this.decorate(b[this.result.from]),a+=this.options.values_separator,a+=this.decorate(b[this.result.to])):a=this.decorate(b[this.result.from]+this.options.values_separator+b[this.result.to]),d=this.decorate(b[this.result.from]),b=this.decorate(b[this.result.to])):(this.options.decorate_both?(a=this.decorate(this._prettify(this.result.from),this.result.from),a+=this.options.values_separator,a+=this.decorate(this._prettify(this.result.to),this.result.to)):a=this.decorate(this._prettify(this.result.from)+
this.options.values_separator+this._prettify(this.result.to),this.result.to),d=this.decorate(this._prettify(this.result.from),this.result.from),b=this.decorate(this._prettify(this.result.to),this.result.to));this.$cache.single.html(a);this.$cache.from.html(d);this.$cache.to.html(b);this.calcLabels();b=Math.min(this.labels.p_single_left,this.labels.p_from_left);a=this.labels.p_single_left+this.labels.p_single_fake;d=this.labels.p_to_left+this.labels.p_to_fake;var c=Math.max(a,d);this.labels.p_from_left+
this.labels.p_from_fake>=this.labels.p_to_left?(this.$cache.from[0].style.visibility="hidden",this.$cache.to[0].style.visibility="hidden",this.$cache.single[0].style.visibility="visible",this.result.from===this.result.to?("from"===this.target?this.$cache.from[0].style.visibility="visible":"to"===this.target&&(this.$cache.to[0].style.visibility="visible"),this.$cache.single[0].style.visibility="hidden",c=d):(this.$cache.from[0].style.visibility="hidden",this.$cache.to[0].style.visibility="hidden",this.$cache.single[0].style.visibility="visible",c=Math.max(a,d))):(this.$cache.from[0].style.visibility="visible",this.$cache.to[0].style.visibility="visible",this.$cache.single[0].style.visibility="hidden");this.$cache.min[0].style.visibility=b<this.labels.p_min+1?"hidden":"visible";this.$cache.max[0].style.visibility=c>100-this.labels.p_max-1?"hidden":"visible"}}},drawShadow:function(){var a=this.options,b=this.$cache,d="number"===typeof a.from_min&&!isNaN(a.from_min),c="number"===typeof a.from_max&&!isNaN(a.from_max),e="number"===typeof a.to_min&&!isNaN(a.to_min),g="number"===typeof a.to_max&&!isNaN(a.to_max);"single"===a.type?a.from_shadow&&(d||c)?(d=this.convertToPercent(d?a.from_min:a.min),c=this.convertToPercent(c?a.from_max:a.max)-d,d=this.toFixed(d-this.coords.p_handle/100*d),c=this.toFixed(c-this.coords.p_handle/100*c),d+=this.coords.p_handle/2,b.shad_single[0].style.display="block",b.shad_single[0].style.left=d+"%",b.shad_single[0].style.width=c+"%"):b.shad_single[0].style.display="none":(a.from_shadow&&(d||c)?(d=this.convertToPercent(d?a.from_min:a.min),c=this.convertToPercent(c?a.from_max:a.max)-d,d=this.toFixed(d-this.coords.p_handle/100*d),c=this.toFixed(c-this.coords.p_handle/100*c),d+=this.coords.p_handle/2,b.shad_from[0].style.display="block",b.shad_from[0].style.left=d+"%",b.shad_from[0].style.width=c+"%"):b.shad_from[0].style.display="none",a.to_shadow&&(e||g)?(e=this.convertToPercent(e?a.to_min:a.min),a=this.convertToPercent(g?a.to_max:a.max)-e,e=this.toFixed(e-this.coords.p_handle/100*e),a=this.toFixed(a-this.coords.p_handle/100*a),e+=this.coords.p_handle/2,b.shad_to[0].style.display="block",b.shad_to[0].style.left=e+"%",b.shad_to[0].style.width=a+"%"):b.shad_to[0].style.display="none")},callOnStart:function(){if(this.options.onStart&&"function"===typeof this.options.onStart)this.options.onStart(this.result)},callOnChange:function(){if(this.options.onChange&&"function"===typeof this.options.onChange)this.options.onChange(this.result)},callOnFinish:function(){if(this.options.onFinish&&"function"===typeof this.options.onFinish)this.options.onFinish(this.result)},callOnUpdate:function(){if(this.options.onUpdate&&"function"===typeof this.options.onUpdate)this.options.onUpdate(this.result)},toggleInput:function(){this.$cache.input.toggleClass("irs-hidden-input")},convertToPercent:function(a,b){var d=this.options.max-this.options.min;return d?this.toFixed((b?a:a-this.options.min)/(d/100)):(this.no_diapason=!0,0)},convertToValue:function(a){var b=this.options.min,d=this.options.max,c=b.toString().split(".")[1],e=d.toString().split(".")[1],g,l,k=0,f=0;if(0===a)return this.options.min;if(100===a)return this.options.max;c&&(k=g=c.length);e&&(k=l=e.length);g&&l&&(k=g>=l?g:l);0>b&&(f=Math.abs(b),b=+(b+f).toFixed(k),d=+(d+f).toFixed(k));a=(d-b)/100*a+b;(b=this.options.step.toString().split(".")[1])?a=+a.toFixed(b.length):(a/=this.options.step,a*=this.options.step,a=+a.toFixed(0));f&&(a-=f);f=b?+a.toFixed(b.length):this.toFixed(a);f<this.options.min?f=this.options.min:f>this.options.max&&(f=this.options.max);return f},calcWithStep:function(a){var b=Math.round(a/this.coords.p_step)*this.coords.p_step;100<b&&(b=100);100===a&&(b=100);return this.toFixed(b)},checkMinInterval:function(a,b,d){var c=this.options;if(!c.min_interval)return a;a=this.convertToValue(a);b=this.convertToValue(b);"from"===d?b-a<c.min_interval&&(a=b-c.min_interval):a-b<c.min_interval&&(a=b+c.min_interval);return this.convertToPercent(a)},checkMaxInterval:function(a,b,d){var c=this.options;if(!c.max_interval)return a;a=this.convertToValue(a);b=this.convertToValue(b);"from"===d?b-a>c.max_interval&&(a=b-c.max_interval):a-b>c.max_interval&&(a=b+c.max_interval);return this.convertToPercent(a)},checkDiapason:function(a,b,d){a=this.convertToValue(a);var c=this.options;"number"!==typeof b&&(b=c.min);"number"!==typeof d&&(d=c.max);a<b&&(a=b);a>d&&(a=d);return this.convertToPercent(a)},toFixed:function(a){a=a.toFixed(9);return+a},_prettify:function(a){return this.options.prettify_enabled?this.options.prettify&&"function"===typeof this.options.prettify?this.options.prettify(a):this.prettify(a):a},prettify:function(a){return a.toString().replace(/(\d{1,3}(?=(?:\d\d\d)+(?!\d)))/g,"$1"+this.options.prettify_separator)},checkEdges:function(a,b){if(!this.options.force_edges)return this.toFixed(a);0>a?a=0:a>100-b&&(a=100-b);return this.toFixed(a)},validate:function(){var a=this.options,b=this.result,d=a.values,c=d.length,e,g;"string"===typeof a.min&&(a.min=+a.min);"string"===typeof a.max&&(a.max=+a.max);"string"===typeof a.from&&(a.from=+a.from);"string"===typeof a.to&&(a.to=+a.to);"string"===typeof a.step&&(a.step=+a.step);"string"===typeof a.from_min&&(a.from_min=+a.from_min);"string"===typeof a.from_max&&(a.from_max=+a.from_max);"string"===typeof a.to_min&&(a.to_min=+a.to_min);"string"===typeof a.to_max&&(a.to_max=+a.to_max);"string"===typeof a.keyboard_step&&(a.keyboard_step=+a.keyboard_step);"string"===typeof a.grid_num&&(a.grid_num=+a.grid_num);a.max<a.min&&(a.max=a.min);if(c)for(a.p_values=[],a.min=0,a.max=c-1,a.step=1,a.grid_num=a.max,a.grid_snap=!0,g=0;g<c;g++)e=+d[g],isNaN(e)?e=d[g]:(d[g]=e,e=this._prettify(e)),a.p_values.push(e);if("number"!==typeof a.from||isNaN(a.from))a.from=a.min;if("number"!==typeof a.to||isNaN(a.from))a.to=a.max;if("single"===a.type)a.from<a.min&&(a.from=a.min),a.from>a.max&&(a.from=a.max);else{if(a.from<a.min||a.from>a.max)a.from=a.min;if(a.to>a.max||a.to<a.min)a.to=a.max;a.from>a.to&&(a.from=a.to)}if("number"!==typeof a.step||isNaN(a.step)||!a.step||0>a.step)a.step=1;if("number"!==typeof a.keyboard_step||isNaN(a.keyboard_step)||!a.keyboard_step||0>a.keyboard_step)a.keyboard_step=5;"number"===typeof a.from_min&&a.from<a.from_min&&(a.from=a.from_min);"number"===typeof a.from_max&&a.from>a.from_max&&(a.from=a.from_max);"number"===typeof a.to_min&&a.to<a.to_min&&(a.to=a.to_min);"number"===typeof a.to_max&&a.from>a.to_max&&(a.to=a.to_max);if(b){b.min!==a.min&&(b.min=a.min);b.max!==a.max&&(b.max=a.max);if(b.from<b.min||b.from>b.max)b.from=a.from;if(b.to<b.min||b.to>b.max)b.to=a.to}if("number"!==typeof a.min_interval||isNaN(a.min_interval)||!a.min_interval||0>a.min_interval)a.min_interval=0;if("number"!==typeof a.max_interval||isNaN(a.max_interval)||!a.max_interval||0>a.max_interval)a.max_interval=0;a.min_interval&&a.min_interval>a.max-a.min&&(a.min_interval=a.max-a.min);a.max_interval&&a.max_interval>a.max-a.min&&(a.max_interval=a.max-a.min)},decorate:function(a,b){var d="",c=this.options;c.prefix&&(d+=c.prefix);d+=a;c.max_postfix&&(c.values.length&&a===c.p_values[c.max]?(d+=c.max_postfix,c.postfix&&(d+=" ")):b===c.max&&(d+=c.max_postfix,c.postfix&&(d+=" ")));c.postfix&&(d+=c.postfix);return d},updateFrom:function(){this.result.from=this.options.from;this.result.from_percent=this.convertToPercent(this.result.from);this.options.values&&(this.result.from_value=this.options.values[this.result.from])},updateTo:function(){this.result.to=this.options.to;this.result.to_percent=this.convertToPercent(this.result.to);this.options.values&&(this.result.to_value=this.options.values[this.result.to])},updateResult:function(){this.result.min=this.options.min;this.result.max=this.options.max;this.updateFrom();this.updateTo()},appendGrid:function(){if(this.options.grid){var a=this.options,b,d;b=a.max-a.min;var c=a.grid_num,e=0,g=0,f=4,k,h,m=0,n="";this.calcGridMargin();a.grid_snap?(c=b/a.step,e=this.toFixed(a.step/(b/100))):e=this.toFixed(100/c);4<c&&(f=3);7<c&&(f=2);14<c&&(f=1);28<c&&(f=0);for(b=0;b<c+1;b++){k=f;g=this.toFixed(e*b);100<g&&(g=100,k-=2,0>k&&(k=0));this.coords.big[b]=g;h=(g-e*(b-1))/(k+1);for(d=1;d<=k&&0!==g;d++)m=this.toFixed(g-h*d),n+='<span class="irs-grid-pol small" style="left: '+m+'%"></span>';n+='<span class="irs-grid-pol" style="left: '+g+'%"></span>';m=this.convertToValue(g);m=a.values.length?a.p_values[m]:this._prettify(m);n+='<span class="irs-grid-text js-grid-text-'+b+'" style="left: '+g+'%">'+m+"</span>"}this.coords.big_num=Math.ceil(c+1);this.$cache.cont.addClass("irs-with-grid");this.$cache.grid.html(n);this.cacheGridLabels()}},cacheGridLabels:function(){var a,b,d=this.coords.big_num;for(b=0;b<d;b++)a=this.$cache.grid.find(".js-grid-text-"+b),this.$cache.grid_labels.push(a);this.calcGridLabels()},calcGridLabels:function(){var a,b;b=[];var d=[],c=this.coords.big_num;for(a=0;a<c;a++)this.coords.big_w[a]=this.$cache.grid_labels[a].outerWidth(!1),this.coords.big_p[a]=this.toFixed(this.coords.big_w[a]/this.coords.w_rs*100),this.coords.big_x[a]=this.toFixed(this.coords.big_p[a]/2),b[a]=this.toFixed(this.coords.big[a]-this.coords.big_x[a]),d[a]=this.toFixed(b[a]+
this.coords.big_p[a]);this.options.force_edges&&(b[0]<-this.coords.grid_gap&&(b[0]=-this.coords.grid_gap,d[0]=this.toFixed(b[0]+this.coords.big_p[0]),this.coords.big_x[0]=this.coords.grid_gap),d[c-1]>100+this.coords.grid_gap&&(d[c-1]=100+this.coords.grid_gap,b[c-1]=this.toFixed(d[c-1]-this.coords.big_p[c-1]),this.coords.big_x[c-1]=this.toFixed(this.coords.big_p[c-1]-this.coords.grid_gap)));this.calcGridCollision(2,b,d);this.calcGridCollision(4,b,d);for(a=0;a<c;a++)b=this.$cache.grid_labels[a][0],b.style.marginLeft=-this.coords.big_x[a]+"%"},calcGridCollision:function(a,b,d){var c,e,g,f=this.coords.big_num;for(c=0;c<f;c+=a){e=c+a/2;if(e>=f)break;g=this.$cache.grid_labels[e][0];g.style.visibility=d[c]<=b[e]?"visible":"hidden"}},calcGridMargin:function(){this.options.grid_margin&&(this.coords.w_rs=this.$cache.rs.outerWidth(!1),this.coords.w_rs&&(this.coords.w_handle="single"===this.options.type?this.$cache.s_single.outerWidth(!1):this.$cache.s_from.outerWidth(!1),this.coords.p_handle=this.toFixed(this.coords.w_handle/this.coords.w_rs*100),this.coords.grid_gap=this.toFixed(this.coords.p_handle/2-.1),this.$cache.grid[0].style.width=this.toFixed(100-this.coords.p_handle)+"%",this.$cache.grid[0].style.left=this.coords.grid_gap+"%"))},update:function(a){this.input&&(this.is_update=!0,this.options.from=this.result.from,this.options.to=this.result.to,this.options=f.extend(this.options,a),this.validate(),this.updateResult(a),this.toggleInput(),this.remove(),this.init(!0))},reset:function(){this.input&&(this.updateResult(),this.update())},destroy:function(){this.input&&(this.toggleInput(),this.$cache.input.prop("readonly",!1),f.data(this.input,"ionRangeSlider",null),this.remove(),this.options=this.input=null)}};f.fn.ionRangeSlider=function(a){return this.each(function(){f.data(this,"ionRangeSlider")||f.data(this,"ionRangeSlider",new q(this,a,u++))})};(function(){for(var a=0,b=["ms","moz","webkit","o"],d=0;d<b.length&&!h.requestAnimationFrame;++d)h.requestAnimationFrame=h[b[d]+"RequestAnimationFrame"],h.cancelAnimationFrame=h[b[d]+"CancelAnimationFrame"]||h[b[d]+"CancelRequestAnimationFrame"];h.requestAnimationFrame||(h.requestAnimationFrame=function(b,d){var g=(new Date).getTime(),f=Math.max(0,16-(g-a)),k=h.setTimeout(function(){b(g+f)},f);a=g+f;return k});h.cancelAnimationFrame||(h.cancelAnimationFrame=function(a){clearTimeout(a)})})()})(jQuery,document,window,navigator);;

/* /theme_crafito/static/src/js/plugins/carousel-swipe.js defined in bundle 'web.assets_frontend' */
+function($){'use strict';if(!$.fn.carousel){throw new Error("carousel-swipe required bootstrap carousel")}
var CarouselSwipe=function(element){this.$element=$(element)
this.carousel=this.$element.data('bs.carousel')
this.options=$.extend({},CarouselSwipe.DEFAULTS,this.carousel.options)
this.startX=this.startY=this.startTime=this.cycling=this.$active=this.$items=this.$next=this.$prev=this.dx=null
this.sliding=false
this.$element.on('touchstart',$.proxy(this.touchstart,this)).on('touchmove',$.proxy(this.touchmove,this)).on('touchend',$.proxy(this.touchend,this)).on('slide.bs.carousel',$.proxy(this.sliding,this)).on('slid.bs.carousel',$.proxy(this.stopSliding,this))}
CarouselSwipe.DEFAULTS={swipe:50}
CarouselSwipe.prototype.sliding=function(){this.sliding=true}
CarouselSwipe.prototype.stopSliding=function(){this.sliding=false}
CarouselSwipe.prototype.touchstart=function(e){if(this.sliding||!this.options.swipe)return;var touch=e.originalEvent.touches?e.originalEvent.touches[0]:e
this.dx=0
this.startX=touch.pageX
this.startY=touch.pageY
this.cycling=null
this.width=this.$element.width()
this.startTime=e.timeStamp}
CarouselSwipe.prototype.touchmove=function(e){if(this.sliding||!this.options.swipe)return;var touch=e.originalEvent.touches?e.originalEvent.touches[0]:e
var dx=touch.pageX-this.startX
var dy=touch.pageY-this.startY
if(Math.abs(dx)<Math.abs(dy))return;if(this.cycling===null){this.cycling=!!this.carousel.interval
this.cycling&&this.carousel.pause()}
e.preventDefault()
this.dx=dx/(this.width||1)*100
this.swipe(this.dx)}
CarouselSwipe.prototype.touchend=function(e){if(this.sliding||!this.options.swipe)return;if(!this.$active)return;var all=$().add(this.$active).add(this.$prev).add(this.$next).carousel_transition(true)
var dt=(e.timeStamp-this.startTime)/1000
var speed=Math.abs(this.dx/dt)
if(this.dx>40||(this.dx>0&&speed>this.options.swipe)){this.carousel.prev()}else if(this.dx<-40||(this.dx<0&&speed>this.options.swipe)){this.carousel.next();}else{this.$active.one($.support.transition.end,function(){all.removeClass('prev next')}).emulateTransitionEnd(this.$active.css('transition-duration').slice(0,-1)*1000)}
all.css('transform','')
this.cycling&&this.carousel.cycle()
this.$active=null}
CarouselSwipe.prototype.swipe=function(percent){var $active=this.$active||this.getActive()
if(percent<0){this.$prev.css('transform','translate3d(0,0,0)').removeClass('prev').carousel_transition(true)
if(!this.$next.length||this.$next.hasClass('active'))return
this.$next.carousel_transition(false).addClass('next').css('transform','translate3d('+(percent+100)+'%,0,0)')}else{this.$next.css('transform','').removeClass('next').carousel_transition(true)
if(!this.$prev.length||this.$prev.hasClass('active'))return
this.$prev.carousel_transition(false).addClass('prev').css('transform','translate3d('+(percent-100)+'%,0,0)')}
$active.carousel_transition(false).css('transform','translate3d('+percent+'%, 0, 0)')}
CarouselSwipe.prototype.getActive=function(){this.$active=this.$element.find('.item.active')
this.$items=this.$active.parent().children()
this.$next=this.$active.next()
if(!this.$next.length&&this.options.wrap){this.$next=this.$items.first();}
this.$prev=this.$active.prev()
if(!this.$prev.length&&this.options.wrap){this.$prev=this.$items.last();}
return this.$active;}
var old=$.fn.carousel
$.fn.carousel=function(){old.apply(this,arguments);return this.each(function(){var $this=$(this)
var data=$this.data('bs.carousel.swipe')
if(!data)$this.data('bs.carousel.swipe',new CarouselSwipe(this))})}
$.extend($.fn.carousel,old);$.fn.carousel_transition=function(enable){enable=enable?'':'none';return this.each(function(){$(this).css('-webkit-transition',enable).css('transition',enable)})};}(jQuery);;

/* /theme_crafito/static/src/js/plugins/jquery.circleGraphic.js defined in bundle 'web.assets_frontend' */
(function($){$.fn.circleGraphic=function(options){$.fn.circleGraphic.defaults={color:'#F90',startAngle:0,};var opts=$.extend({},$.fn.circleGraphic.defaults,options);var percentage=this.html();var ID="c"+percentage+Math.random();this.append("<canvas id='"+ID+"'></canvas>");var canvas=document.getElementById(ID),context=canvas.getContext('2d');var Width=this.width();this.height(Width);var Height=this.height();canvas.width=Width;canvas.height=Height;var startAngle=opts.startAngle,endAngle=percentage/100,angle=startAngle,radius=Width*0.4;function drawTrackArc(){context.beginPath();context.strokeStyle='#ECECEC';context.lineWidth=5;context.arc(Width/2,Height/2,radius,(Math.PI/180)*(startAngle*360-90),(Math.PI/180)*(endAngle*360+270),false);context.stroke();context.closePath();}
function drawOuterArc(_angle,_color){var angle=_angle;var color=_color;context.beginPath();context.strokeStyle=color;context.lineWidth=10;context.arc(Width/2,Height/2,radius,(Math.PI/180)*(startAngle*360-90),(Math.PI/180)*(angle*360-90),false);context.stroke();context.closePath();}
function numOfPercentage(_angle,_color){var angle=Math.floor(_angle*100)+1;var color=_color;context.font="50px fantasy";context.fillStyle=color;var metrics=context.measureText(angle);var textWidth=metrics.width;var xPos=Width/2-textWidth/2,yPos=Height/2+textWidth/2;context.fillText(angle+"%",xPos,yPos);}
function draw(){var loop=setInterval(function(){context.clearRect(0,0,Width,Height);drawTrackArc();drawOuterArc(angle,opts.color);numOfPercentage(angle,opts.color);angle+=0.01;if(angle>endAngle){clearInterval(loop);}},1000/60);}
draw();return this;};})(jQuery);;

/* /theme_crafito/static/src/js/plugins/unitegallery.min.js defined in bundle 'web.assets_frontend' */
function debugLine(e,t,i){e===!0&&(e="true"),e===!1&&(e="false");var n=e;if("object"==typeof e){n="";for(name in e){var r=e[name];n+=" "+name+": "+r}}
if(1!=t||i||(n+=" "+Math.random()),1==i){var o=jQuery("#debug_line");o.width(200),o.height()>=500&&o.html("");var a=o.html();n=a+"<br> -------------- <br>"+n}
jQuery("#debug_line").show().html(n)}
function debugSide(e){var t="";for(name in e){var i=e[name];t+=name+" : "+i+"<br>"}
jQuery("#debug_side").show().html(t)}
function trace(e){"undefined"!=typeof console&&console.log(e)}
function UGFunctions(){function e(e,t,i){t.addEventListener?t.addEventListener(e,i,!1):t.attachEvent?t.attachEvent("on"+e,i):t[e]=i}
var t=null,i=this,n={starTime:0,arrThemes:[],isTouchDevice:-1,isRgbaSupported:-1,timeCache:{},dataCache:{},lastEventType:"",lastEventTime:0,handle:null};this.debugVar="",this.z__________FULL_SCREEN___________=function(){},this.toFullscreen=function(e,t){if(e.requestFullscreen)e.requestFullscreen();else if(e.mozRequestFullScreen)e.mozRequestFullScreen();else if(e.webkitRequestFullscreen)e.webkitRequestFullscreen();else{if(!e.msRequestFullscreen)return!1;e.msRequestFullscreen()}
return!0},this.exitFullscreen=function(){if(0==i.isFullScreen())return!1;if(document.exitFullscreen)document.exitFullscreen();else if(document.cancelFullScreen)document.cancelFullScreen();else if(document.mozCancelFullScreen)document.mozCancelFullScreen();else if(document.webkitExitFullscreen)document.webkitExitFullscreen();else{if(!document.msExitFullscreen)return!1;document.msExitFullscreen()}
return!0},this.addFullScreenChangeEvent=function(t){document.webkitCancelFullScreen?e("webkitfullscreenchange",document,t):document.msExitFullscreen?e("MSFullscreenChange",document,t):document.mozCancelFullScreen?e("mozfullscreenchange",document,t):e("fullscreenchange",document,t)},this.destroyFullScreenChangeEvent=function(){jQuery(document).unbind("fullscreenChange"),jQuery(document).unbind("mozfullscreenchange"),jQuery(document).unbind("webkitfullscreenchange"),jQuery(document).unbind("MSFullscreenChange")},this.getFullScreenElement=function(){var e=document.fullscreenElement||document.mozFullScreenElement||document.webkitFullscreenElement||document.msFullscreenElement;return e},this.isFullScreen=function(){var e=document.fullscreen||document.mozFullScreen||document.webkitIsFullScreen||document.msFullscreenElement;return e=e?!0:!1},this.z__________END_FULL_SCREEN___________=function(){},this.z__________GET_PROPS___________=function(){},this.getBrowserPrefix=function(){if(null!==t)return t;var e=["webkit","Moz","ms","O"],i=document.createElement("div");for(var n in e){var r=e[n];if(r+"Transform"in i.style)return r=r.toLowerCase(),t=r,r}
return t="",""},this.getImageInsideParentDataByImage=function(e,t,n){var r=e.parent(),o=i.getImageOriginalSize(e),a=i.getImageInsideParentData(r,o.width,o.height,t,n);return a},this.getImageInsideParentData=function(e,t,i,n,r,o,a){if(!r)var r={};var s={};if("undefined"==typeof o)var o=e.width();if("undefined"==typeof a)var a=e.height();r.padding_left&&(o-=r.padding_left),r.padding_right&&(o-=r.padding_right),r.padding_top&&(a-=r.padding_top),r.padding_bottom&&(a-=r.padding_bottom);var l=null,u="100%",d=null,_=null,g="display:block;margin:0px auto;";if(t>0&&i>0){if("down"==n&&o>t&&a>i)u=i,l=t,_=(o-l)/2,d=(a-u)/2;else if("fill"==n){var c=t/i;u=a,l=u*c,o>l?(l=o,u=l/c,_=0,d=Math.round((u-a)/2*-1)):(d=0,_=Math.round((l-o)/2*-1))}else{var c=t/i;u=a,l=u*c,d=0,_=(o-l)/2,"fitvert"!=n&&l>o&&(l=o,u=l/c,_=0,d=(a-u)/2)}
l=Math.floor(l),u=Math.floor(u),d=Math.floor(d),_=Math.floor(_),g="position:absolute;"}
return r.padding_top&&(d+=r.padding_top),r.padding_left&&(_+=r.padding_left),s.imageWidth=l,s.imageHeight=u,s.imageTop=d,s.imageLeft=_,s.imageRight=_+l,0==d||"100%"==u?s.imageBottom=null:s.imageBottom=d+u,s.style=g,s},this.getElementCenterPosition=function(e,t){var n=e.parent(),r=i.getElementSize(e),o=i.getElementSize(n),a=o.width,s=o.height;t&&void 0!==t.padding_top&&(s-=t.padding_top),t&&void 0!==t.padding_bottom&&(s-=t.padding_bottom),t&&void 0!==t.padding_left&&(a-=t.padding_left),t&&void 0!==t.padding_right&&(a-=t.padding_right);var l={};return l.left=Math.round((a-r.width)/2),l.top=Math.round((s-r.height)/2),t&&void 0!==t.padding_top&&(l.top+=t.padding_top),t&&void 0!==t.padding_left&&(l.left+=t.padding_left),l},this.getElementCenterPoint=function(e,t){if(!t)var t=!1;var n=i.getElementSize(e),r={};return r.x=n.width/2,r.y=n.height/2,1==t&&(r.x+=n.left,r.y+=n.top),r.x=Math.round(r.x),r.y=Math.round(r.y),r},this.getMousePosition=function(e,t){var i={pageX:e.pageX,pageY:e.pageY,clientX:e.clientX,clientY:e.clientY};if(e.originalEvent&&e.originalEvent.touches&&e.originalEvent.touches.length>0&&(i.pageX=e.originalEvent.touches[0].pageX,i.pageY=e.originalEvent.touches[0].pageY,i.clientX=e.originalEvent.touches[0].clientX,i.clientY=e.originalEvent.touches[0].clientY),t){var n=t.offset();i.mouseX=i.pageX-n.left,i.mouseY=i.pageY-n.top}
return i},this.getMouseElementPoint=function(e,t){var n={x:e.pageX,y:e.pageY},r=i.getElementLocalPoint(n,t);return r},this.getElementLocalPoint=function(e,t){var i={},n=t.offset();return i.x=Math.round(e.x-n.left),i.y=Math.round(e.y-n.top),i},this.getImageOriginalSize=function(e,t,i){if("undefined"!=typeof t&&"undefined"!=typeof i)return{width:t,height:i};var n=e[0];if("undefined"==typeof n)throw new Error("getImageOriginalSize error - Image not found");var r={};if("undefined"==typeof n.naturalWidth){if("number"==typeof e.data("naturalWidth")){var r={};return r.width=e.data("naturalWidth"),r.height=e.data("naturalHeight"),r}
var o=new Image;return o.src=n.src,o.complete?(r.width=o.width,r.height=o.height,e.data("naturalWidth",r.width),e.data("naturalHeight",r.height),r):{width:0,height:0}}
return r.width=n.naturalWidth,r.height=n.naturalHeight,r},this.getimageRatio=function(e){var t=i.getImageOriginalSize(e),n=i.getElementSize(e),r=n.width/t.width;return r},this.isImageFitParent=function(e){var t=e.parent(),n=i.getElementSize(e),r=i.getElementSize(t);return n.width<=r.width&&n.height<=r.height?!0:!1},this.getElementSize=function(e){if(void 0===e)throw new Error("Can't get size, empty element");var t=e.position();return t.height=e.outerHeight(),t.width=e.outerWidth(),t.left=Math.round(t.left),t.top=Math.round(t.top),t.right=t.left+t.width,t.bottom=t.top+t.height,t},this.isElementBiggerThenParent=function(e){var t=e.parent(),n=i.getElementSize(e),r=i.getElementSize(t);return n.width>r.width||n.height>r.height?!0:!1},this.isPointInsideElement=function(e,t){var i=e.x>=0&&e.x<t.width;if(0==i)return!1;var n=e.y>=0&&e.y<t.height;return 0==n?!1:!0},this.getElementRelativePos=function(e,t,n,r){if(!r)var r=e.parent();var o=i.getElementSize(e),a=i.getElementSize(r);switch(t){case"top":case"left":t=0,n&&(t+=n);break;case"center":t=Math.round((a.width-o.width)/2),n&&(t+=n);break;case"right":t=a.width-o.width,n&&(t-=n);break;case"middle":t=Math.round((a.height-o.height)/2),n&&(t+=n);break;case"bottom":t=a.height-o.height,n&&(t-=n)}
return t},this.z__________END_GET_PROPS___________=function(){},this.z_________SET_ELEMENT_PROPS_______=function(){},this.zoomImageInsideParent=function(e,t,n,r,o,a,s){if(!n)var n=1.2;if(!o)var o="fit";var l,u,d,_,g=n,c=e.parent(),h=i.getElementSize(e),p=i.getImageOriginalSize(e),f=!1,m=0,v=0,b=0,y=0;if(r){var I=i.getMouseElementPoint(r,e);f=i.isPointInsideElement(I,h),b=I.x,y=I.y}else f=!1;if(0==f){var w=i.getElementCenterPoint(e);b=w.x,y=w.y}
if(1==t)l=h.height*g,u=h.width*g,0!=b&&(m=-(b*g-b)),0!=y&&(v=-(y*g-y));else{l=h.height/g,u=h.width/g;var T=i.getImageInsideParentData(c,p.width,p.height,o,s);if(u<T.imageWidth)return i.scaleImageFitParent(e,p.width,p.height,o,s),!0;1==f&&(0!=b&&(m=-(b/g-b)),0!=y&&(v=-(y/g-y)))}
if(a){var E=1;if(0!=p.width&&(E=u/p.width),E>a)return!1}
if(i.setElementSize(e,u,l),0==t&&0==f){var S=i.getElementCenterPosition(e);d=S.left,_=S.top}else d=h.left+m,_=h.top+v;return i.placeElement(e,d,_),!0},this.placeElement=function(e,t,n,r,o,a){if(0==jQuery.isNumeric(t)||0==jQuery.isNumeric(n)){if(!a)var a=e.parent();var s=i.getElementSize(e),l=i.getElementSize(a)}
if(0==jQuery.isNumeric(t))switch(t){case"left":t=0,r&&(t+=r);break;case"center":t=Math.round((l.width-s.width)/2),r&&(t+=r);break;case"right":t=l.width-s.width,r&&(t-=r)}
if(0==jQuery.isNumeric(n))switch(n){case"top":n=0,o&&(n+=o);break;case"middle":case"center":n=Math.round((l.height-s.height)/2),o&&(n+=o);break;case"bottom":n=l.height-s.height,o&&(n-=o)}
var u={position:"absolute",margin:"0px"};null!==t&&(u.left=t),null!==n&&(u.top=n),e.css(u)},this.placeElementInParentCenter=function(e){i.placeElement(e,"center","middle")},this.setElementSizeAndPosition=function(e,t,i,n,r){var o={width:n+"px",height:r+"px",left:t+"px",top:i+"px",position:"absolute",margin:"0px"};e.css(o)},this.setElementSize=function(e,t,i){var n={width:t+"px"};null!==i&&"undefined"!=typeof i&&(n.height=i+"px"),e.css(n)},this.cloneElementSizeAndPos=function(e,t,n,r,o){var a=e.position();if(void 0==a)throw new Error("Can't get size, empty element");n===!0?(a.height=e.outerHeight(),a.width=e.outerWidth()):(a.height=e.height(),a.width=e.width()),a.left=Math.round(a.left),a.top=Math.round(a.top),r&&(a.left+=r),o&&(a.top+=o),i.setElementSizeAndPosition(t,a.left,a.top,a.width,a.height)},this.placeImageInsideParent=function(e,t,n,r,o,a){var s=i.getImageInsideParentData(t,n,r,o,a),l="<img";null!==s.imageWidth&&(l+=" width = '"+s.imageWidth+"'",s.style+="width:"+s.imageWidth+";"),null!=s.imageHeight&&("100%"==s.imageHeight?(l+=" height = '"+s.imageHeight+"'",s.style+="height:"+s.imageHeight+";"):(l+=" height = '"+s.imageHeight+"'",s.style+="height:"+s.imageHeight+"px;")),null!==s.imageTop&&(s.style+="top:"+s.imageTop+"px;"),null!==s.imageLeft&&(s.style+="left:"+s.imageLeft+"px;"),l+=" style='"+s.style+"'",l+=" src='"+e+"'",l+=">",t.html(l);var u=t.children("img");return u},this.scaleImageCoverParent=function(e,t,n){if("number"==typeof t)var r=t,o=n;else var r=t.outerWidth(),o=t.outerHeight();var a=i.getImageOriginalSize(e),s=a.width,l=a.height,u=s/l,d=o,_=d*u,g=0,c=0;r>_?(_=r,d=_/u,c=0,g=Math.round((d-o)/2*-1)):(g=0,c=Math.round((_-r)/2*-1)),_=Math.round(_),d=Math.round(d),e.css({width:_+"px",height:d+"px",left:c+"px",top:g+"px"})},this.scaleImageFitParent=function(e,t,n,r,o){var a=e.parent(),s=i.getImageInsideParentData(a,t,n,r,o),l=!1,u={};null!==s.imageWidth&&(l=!0,e.removeAttr("width"),u.width=s.imageWidth+"px"),null!=s.imageHeight&&(l=!0,e.removeAttr("height"),u.height=s.imageHeight+"px"),null!==s.imageTop&&(l=!0,u.top=s.imageTop+"px"),null!==s.imageLeft&&(l=!0,u.left=s.imageLeft+"px"),1==l&&(u.position="absolute",u.margin="0px 0px",e.css(u))},this.scaleImageByHeight=function(e,t,n,r){var o=i.getImageOriginalSize(e,n,r),a=o.width/o.height,s=Math.round(t*a);t=Math.round(t),i.setElementSize(e,s,t)},this.scaleImageByWidth=function(e,t,n,r){var o=i.getImageOriginalSize(e,n,r),a=o.width/o.height,s=Math.round(t/a);t=Math.round(t),i.setElementSize(e,t,s)},this.scaleImageExactSizeInParent=function(e,t,n,r,o,a){var s=e.parent(),l=i.getElementSize(s);l.width<r&&(r=l.width),l.height<o&&(o=l.height);var u=i.getImageInsideParentData(null,t,n,a,null,r,o),d=r,_=o,g=u.imageLeft,c=u.imageLeft,h=u.imageTop,p=u.imageTop,f=Math.round((l.width-r)/2),m=Math.round((l.height-o)/2),v=u.imageWidth+g+c,b=r-v;0!=b&&(c+=b);var y=u.imageHeight+h+p,b=o-y;0!=b&&(p+=b),e.removeAttr("width"),e.removeAttr("height");var I={position:"absolute",margin:"0px 0px"};I.width=d+"px",I.height=_+"px",I.left=f+"px",I.top=m+"px",I["padding-left"]=g+"px",I["padding-top"]=h+"px",I["padding-right"]=c+"px",I["padding-bottom"]=p+"px",e.css(I)},this.showElement=function(e,t,i){e.show().fadeTo(0,1),t&&t.show().fadeTo(0,1),i&&i.show().fadeTo(0,1)},this.z_________END_SET_ELEMENT_PROPS_______=function(){},this.z_________GALLERY_RELATED_FUNCTIONS_______=function(){},this.disableButton=function(e,t){if(!t)var t="ug-button-disabled";0==i.isButtonDisabled(e,t)&&e.addClass(t)},this.convertCustomPrefixOptions=function(e,t,i){if(!t)return e;var n={};return jQuery.each(e,function(e,r){if(0===e.indexOf(t+"_"+i+"_")){var o=e.replace(t+"_"+i+"_",i+"_");n[o]=r}else n[e]=r}),n},this.enableButton=function(e,t){if(!t)var t="ug-button-disabled";1==i.isButtonDisabled(e,t)&&e.removeClass(t)},this.isButtonDisabled=function(e,t){if(!t)var t="ug-button-disabled";return e.hasClass(t)?!0:!1},this.z_________END_GALLERY_RELATED_FUNCTIONS_______=function(){},this.z_________MATH_FUNCTIONS_______=function(){},this.normalizeSetting=function(e,t,i,n,r,o){if(!o)var o=!1;var a=(r-i)/(n-i);return r=e+(t-e)*a,1==o&&(e>r&&(r=e),r>t&&(r=t)),r},this.getNormalizedValue=function(e,t,i,n,r){var o=(r-e)/(t-e);return r=e+(n-i)*o},this.getDistance=function(e,t,i,n){var r=Math.round(Math.sqrt(Math.abs((i-e)*(i-e)+(n-t)*(n-t))));return r},this.getMiddlePoint=function(e,t,i,n){var r={};return r.x=e+Math.round((i-e)/2),r.y=t+Math.round((n-t)/2),r},this.getNumItemsInSpace=function(e,t,i){var n=Math.floor((e+i)/(t+i));return n},this.getNumItemsInSpaceRound=function(e,t,i){var n=Math.round((e+i)/(t+i));return n},this.getSpaceByNumItems=function(e,t,i){var n=e*t+(e-1)*i;return n},this.getItemSizeInSpace=function(e,t,i){var n=Math.floor((e-(t-1)*i)/t);return n},this.getColX=function(e,t,i){var n=e*(t+i);return n},this.getColByIndex=function(e,t){var i=t%e;return i},this.getColRowByIndex=function(e,t){var i=Math.floor(e/t),n=Math.floor(e%t);return{col:n,row:i}},this.getIndexByRowCol=function(e,t,i){if(0>e)return-1;if(0>t)return-1;var n=e*i+t;return n},this.getPrevRowSameColIndex=function(e,t){var n=i.getColRowByIndex(e,t),r=i.getIndexByRowCol(n.row-1,n.col,t);return r},this.getNextRowSameColIndex=function(e,t){var n=i.getColRowByIndex(e,t),r=i.getIndexByRowCol(n.row+1,n.col,t);return r},this.z_________DATA_FUNCTIONS_______=function(){},this.setGlobalData=function(e,t){jQuery.data(document.body,e,t)},this.getGlobalData=function(e){var t=jQuery.data(document.body,e);return t},this.z_________EVENT_DATA_FUNCTIONS_______=function(){},this.handleScrollTop=function(e){if(0==i.isTouchDevice())return null;var t=i.getStoredEventData(e),r=15,o=15;if(null===t.scrollDir&&(Math.abs(t.diffMouseX)>r?t.scrollDir="hor":Math.abs(t.diffMouseY)>o&&Math.abs(t.diffMouseY)>Math.abs(t.diffMouseX)&&(t.scrollDir="vert",t.scrollStartY=t.lastMouseClientY,t.scrollOrigin=jQuery(document).scrollTop(),n.dataCache[e].scrollStartY=t.lastMouseClientY,n.dataCache[e].scrollOrigin=t.scrollOrigin),n.dataCache[e].scrollDir=t.scrollDir),"vert"!==t.scrollDir)return t.scrollDir;var a=(jQuery(document).scrollTop(),t.scrollOrigin-(t.lastMouseClientY-t.scrollStartY));return a>=0&&jQuery(document).scrollTop(a),t.scrollDir},this.wasVerticalScroll=function(e){var t=i.getStoredEventData(e);return"vert"===t.scrollDir?!0:!1},this.storeEventData=function(e,t,r){var o=i.getMousePosition(e),a=jQuery.now(),s={startTime:a,lastTime:a,startMouseX:o.pageX,startMouseY:o.pageY,lastMouseX:o.pageX,lastMouseY:o.pageY,startMouseClientY:o.clientY,lastMouseClientY:o.clientY,scrollTop:jQuery(document).scrollTop(),scrollDir:null};r&&(s=jQuery.extend(s,r)),n.dataCache[t]=s},this.updateStoredEventData=function(e,t,r){if(!n.dataCache[t])throw new Error("updateEventData error: must have stored cache object");var o=n.dataCache[t],a=i.getMousePosition(e);o.lastTime=jQuery.now(),void 0!==a.pageX&&(o.lastMouseX=a.pageX,o.lastMouseY=a.pageY,o.lastMouseClientY=a.clientY),r&&(o=jQuery.extend(o,r)),n.dataCache[t]=o},this.getStoredEventData=function(e,t){if(!n.dataCache[e])throw new Error("updateEventData error: must have stored cache object");var i=n.dataCache[e];return i.diffMouseX=i.lastMouseX-i.startMouseX,i.diffMouseY=i.lastMouseY-i.startMouseY,i.diffMouseClientY=i.lastMouseClientY-i.startMouseClientY,i.diffTime=i.lastTime-i.startTime,t===!0?(i.startMousePos=i.lastMouseY,i.lastMousePos=i.lastMouseY,i.diffMousePos=i.diffMouseY):(i.startMousePos=i.lastMouseX,i.lastMousePos=i.lastMouseX,i.diffMousePos=i.diffMouseX),i},this.isApproveStoredEventClick=function(e,t){if(!n.dataCache[e])return!0;var r=i.getStoredEventData(e,t),o=Math.abs(r.diffMousePos);return r.diffTime>400?!1:o>30?!1:!0},this.clearStoredEventData=function(e){n.dataCache[e]=null},this.z_________CHECK_SUPPORT_FUNCTIONS_______=function(){},this.isCanvasExists=function(){var e=jQuery('<canvas width="500" height="500" > </canvas>')[0];return"function"==typeof e.getContext?!0:!1},this.isScrollbarExists=function(){var e=window.innerWidth>document.documentElement.clientWidth;return e},this.isTouchDevice=function(){if(-1!==n.isTouchDevice)return n.isTouchDevice;try{document.createEvent("TouchEvent"),n.isTouchDevice=!0}catch(e){n.isTouchDevice=!1}
return n.isTouchDevice},this.isDesktopDevice=function(){var e=void 0===typeof window.screenX||i.isTouchDevice()?!1:!0;return e},this.isRgbaSupported=function(){if(-1!==n.isRgbaSupported)return n.isRgbaSupported;var e=document.getElementsByTagName("script")[0],t=e.style.color;try{e.style.color="rgba(1,5,13,0.44)"}catch(i){}
var r=e.style.color!=t;return e.style.color=t,n.isRgbaSupported=r,r},this.z_________GENERAL_FUNCTIONS_______=function(){},this.checkMinJqueryVersion=function(e){for(var t=jQuery.fn.jquery.split("."),i=e.split("."),n=0,r=t.length;r>n;n++){var o=parseInt(t[n]),a=parseInt(i[n]);if("undefined"==typeof i[n])return!0;if(a>o)return!1;if(o>a)return!0}
return!0},this.getCssSizeParam=function(e){return jQuery.isNumeric(e)?e+"px":e},this.convertHexToRGB=function(e,t){var i=e.replace("#","");return i===e?e:(r=parseInt(i.substring(0,2),16),g=parseInt(i.substring(2,4),16),b=parseInt(i.substring(4,6),16),result="rgba("+r+","+g+","+b+","+t+")",result)},this.timestampToString=function(e){var t=new Date(e),i=t.getDate()+"/"+t.getMonth();return i+=" "+t.getHours()+":"+t.getMinutes()+":"+t.getSeconds()+":"+t.getMilliseconds()},this.getArrTouches=function(e){var t=[];return e.originalEvent&&e.originalEvent.touches&&e.originalEvent.touches.length>0&&(t=e.originalEvent.touches),t},this.getArrTouchPositions=function(e){for(var t=[],i=0;i<e.length;i++){var n={pageX:e[i].pageX,pageY:e[i].pageY};t.push(n)}
return t},this.startTimeDebug=function(){n.starTime=jQuery.now()},this.showTimeDebug=function(){var e=jQuery.now(),t=e-n.starTime;debugLine({"Time Passed":t},!0)},this.initProgressIndicator=function(e,t,n){switch("bar"!=e&&0==i.isCanvasExists()&&(e="bar"),e){case"bar":var r=new UGProgressBar;r.putHidden(n,t);break;default:case"pie":var r=new UGProgressPie;r.putHidden(n,t);break;case"pie2":t.type_fill=!0;var r=new UGProgressPie;r.putHidden(n,t)}
return r},this.setButtonMobileReady=function(e){e.on("touchstart",function(e){jQuery(this).addClass("ug-nohover")}),e.on("mousedown touchend",function(e){return e.stopPropagation(),e.stopImmediatePropagation(),!1})},this.registerTheme=function(e){n.arrThemes.push(e)},this.getArrThemes=function(){return n.arrThemes},this.isThemeRegistered=function(e){return-1!==jQuery.inArray(e,n.arrThemes)?!0:!1},this.getFirstRegisteredTheme=function(){if(0==n.arrThemes.length)return"";var e=n.arrThemes[0];return e},this.isTimePassed=function(e,t){if(!t)var t=100;var i=jQuery.now();0==n.timeCache.hasOwnProperty(e)?lastTime=0:lastTime=n.timeCache[e];var r=i-lastTime;return n.timeCache[e]=i,t>=r?!1:!0},this.whenContiniousEventOver=function(e,t,i){if(!i)var i=300;1==n.timeCache.hasOwnProperty(e)&&null!=n.timeCache[e]&&(clearTimeout(n.timeCache[e]),n.timeCache[e]=null),n.timeCache[e]=setTimeout(t,i)},this.validateClickTouchstartEvent=function(e){var t=!0,i=jQuery.now()-n.lastEventTime;return"click"==e&&"touchstart"==n.lastEventType&&1e3>i&&(t=!1),n.lastEventTime=jQuery.now(),n.lastEventType=e,t},this.addClassOnHover=function(e,t){if(!t)var t="ug-button-hover";e.hover(function(){jQuery(this).addClass(t)},function(){jQuery(this).removeClass(t)})},this.destroyButton=function(e){e.off("mouseenter"),e.off("mouseleave"),e.off("click"),e.off("touchstart"),e.off("touchend"),e.off("mousedown")},this.setButtonOnClick=function(e,t){i.setButtonMobileReady(e),e.on("click touchstart",function(e){return objThis=jQuery(this),e.stopPropagation(),e.stopImmediatePropagation(),0==i.validateClickTouchstartEvent(e.type)?!0:void t(objThis,e)})},this.loadJs=function(e,t){t===!0&&(e=location.protocol+"//"+e);var i=document.createElement("script");i.src=e;var n=document.getElementsByTagName("script")[0];n.parentNode.insertBefore(i,n)},this.loadCss=function(e,t){t===!0&&(e=location.protocol+"//"+e);var i=document.createElement("link");i.setAttribute("rel","stylesheet"),i.setAttribute("type","text/css"),i.setAttribute("href",e),document.getElementsByTagName("head")[0].appendChild(i)},this.addEvent=function(e,t,i){"undefined"!=typeof e.addEventListener?e.addEventListener(t,i,!1):e.attachEvent&&e.attachEvent("on"+t,i)},this.checkImagesLoaded=function(e,t,i){function n(e,n){r++,"function"==typeof i&&setTimeout(function(){i(e,n)}),r==o&&"function"==typeof t&&setTimeout(function(){t()})}
var r=0,o=e.length;return 0==o&&t?(t(),!1):void setTimeout(function(){for(var t=0;o>t;t++){var i=e[t];if(void 0!==i.naturalWidth&&0!==i.naturalWidth)n(e[t],!1);else{var r=jQuery("<img/>");r.data("index",t),r.on("load",function(){var t=jQuery(this).data("index");n(e[t],!1)}),r.on("error",function(){var t=jQuery(this).data("index");n(e[t],!0)}),r.attr("src",i.src)}}})},this.waitForWidth=function(e,t){var i=e.width();return 0!=i?(t(),!1):void(n.handle=setInterval(function(){i=e.width(),0!=i&&(clearInterval(n.handle),t())},300))},this.arrayShuffle=function(e){if("object"!=typeof e)return e;for(var t,i,n=e.length;n;t=parseInt(Math.random()*n),i=e[--n],e[n]=e[t],e[t]=i);return e},this.getObjectLength=function(e){var t=0;for(var i in e)t++;return t},this.normalizePercent=function(e){return 0>e&&(e=0),e>1&&(e=1),e},this.stripTags=function(e){var t=e.replace(/(<([^>]+)>)/gi,"");return t},this.htmlentitles=function(e){var t=jQuery("<div/>").text(e).html();return t},this.z_________END_GENERAL_FUNCTIONS_______=function(){}}
function UGThumbsGeneral(){function e(e,t,i,n){var r={width:e+"px",height:t+"px"},o={width:e-j.thumbInnerReduce+"px",height:t-j.thumbInnerReduce+"px"},a=".ug-thumb-loader, .ug-thumb-error, .ug-thumb-border-overlay, .ug-thumb-overlay";i?(n!==!0&&i.css(r),i.children(a).css(o)):(w.children(".ug-thumb-wrapper").css(r),w.find(a).css(o))}
function t(e,t,i,n){if(!n)var n=!1;S.isFakeFullscreen()&&(n=!0);var r=e.children(".ug-thumb-border-overlay"),o={};o["border-width"]=t+"px",0!=t&&(o["border-color"]=i),n&&n===!0?(r.css(o),0==t?r.hide():r.show()):(0==t?r.stop().fadeOut(x.thumb_transition_duration):r.show().stop().fadeIn(x.thumb_transition_duration),s(r,o))}
function i(e,t,i){var n=e.children(".ug-thumb-overlay"),r=x.thumb_transition_duration;i&&i===!0&&(r=0),t?n.stop(!0).fadeTo(r,j.colorOverlayOpacity):n.stop(!0).fadeTo(r,0)}
function n(e,t,i){var n=e.children("img.ug-thumb-image"),r=e.children("img.ug-thumb-image-overlay"),o=x.thumb_transition_duration;i&&i===!0&&(o=0),t?r.stop(!0).fadeTo(o,1):(n.fadeTo(0,1),r.stop(!0).fadeTo(o,0))}
function r(e,r){if(j.isEffectBorder&&t(e,x.thumb_selected_border_width,x.thumb_selected_border_color,r),j.isEffectOverlay){var o=1==x.thumb_overlay_reverse?!0:!1;i(e,o,r)}
j.isEffectImage&&n(e,!1,r),E.trigger(T.events.SETSELECTEDSTYLE,e)}
function o(e){var t=T.getItemByThumb(e);return t.isLoaded=!0,t.isThumbImageLoaded=!1,1==j.customThumbs?(E.trigger(T.events.IMAGELOADERROR,e),!0):(e.children(".ug-thumb-loader").hide(),void e.children(".ug-thumb-error").show())}
function a(){if(x.thumb_round_corners_radius<=0)return!1;var e={"border-radius":x.thumb_round_corners_radius+"px"};w.find(".ug-thumb-wrapper, .ug-thumb-wrapper .ug-thumb-border-overlay").css(e)}
function s(e,t){e.stop(!0).animate(t,{duration:x.thumb_transition_duration,easing:x.thumb_transition_easing,queue:!1})}
function l(e){1==g(e)?r(e,!0,"redraw"):T.setThumbNormalStyle(e,!0,"redraw")}
function u(t,i,n){if(1==x.thumb_fixed_size)P.scaleImageCoverParent(i,t);else{"height"==x.thumb_resize_by?P.scaleImageByHeight(i,x.thumb_height):P.scaleImageByWidth(i,x.thumb_width);var r=P.getElementSize(i);P.placeElement(i,0,0),e(r.width,r.height,t)}
t.children(".ug-thumb-loader").hide(),i.show(),0==x.thumb_image_overlay_effect?i.fadeTo(0,1):(1==x.thumb_image_overlay_effect&&d(i),i.fadeTo(0,0),l(t)),E.trigger(T.events.AFTERPLACEIMAGE,t)}
function d(e){var t=e.siblings(".ug-thumb-image-overlay");if(0==t.length)return!1;var i=P.getElementSize(e),n={width:i.width+"px",height:i.height+"px",left:i.left+"px",top:i.top+"px"};t.css(n),0==j.customThumbs&&t.fadeTo(0,1)}
function _(){var e="",t=x.thumb_image_overlay_type.split(",");for(var i in t){var n=t[i];switch(n){case"bw":e+=" ug-bw-effect";break;case"blur":e+=" ug-blur-effect";break;case"sepia":e+=" ug-sepia-effect"}}
return e}
function g(e){return e.hasClass("ug-thumb-selected")?!0:!1}
function c(t,i){i=jQuery(i);var n=(T.getItemByThumb(i),P.getElementSize(i));e(n.width,n.height,i,!0),l(i)}
function h(e){return 1==j.touchEnabled?(objThumbs.off("mouseenter").off("mouseleave"),!0):void(0==g(e)&&T.setThumbOverStyle(e))}
function p(e){return 1==j.touchEnabled?!0:void(0==g(e)&&T.setThumbNormalStyle(e,!1))}
function f(e,t){if(!t)var t=!1;var i=jQuery(e),n=i.parents(".ug-thumb-wrapper");return 0==n.parent().length?!1:(objItem=T.getItemByThumb(n),1==objItem.isLoaded&&t===!1?!1:(T.triggerImageLoadedEvent(n,i),void(1==j.customThumbs?E.trigger(T.events.PLACEIMAGE,[n,i]):u(n,i,objItem))))}
function m(e,t,i){objItem=T.getItemByThumb(t),objItem.isLoaded=!0,objItem.isThumbImageLoaded=!0;var n=P.getImageOriginalSize(i);objItem.thumbWidth=n.width,objItem.thumbHeight=n.height,objItem.thumbRatioByWidth=n.width/n.height,objItem.thumbRatioByHeight=n.height/n.width}
var v,b,y,I,w,T=this,E=jQuery(T),S=new UniteGalleryMain,P=new UGFunctions;this.events={SETOVERSTYLE:"thumbmouseover",SETNORMALSTYLE:"thumbmouseout",SETSELECTEDSTYLE:"thumbsetselected",PLACEIMAGE:"thumbplaceimage",AFTERPLACEIMAGE:"thumb_after_place_image",IMAGELOADERROR:"thumbimageloaderror",THUMB_IMAGE_LOADED:"thumb_image_loaded"};var x={thumb_width:88,thumb_height:50,thumb_fixed_size:!0,thumb_resize_by:"height",thumb_border_effect:!0,thumb_border_width:0,thumb_border_color:"#000000",thumb_over_border_width:0,thumb_over_border_color:"#d9d9d9",thumb_selected_border_width:1,thumb_selected_border_color:"#d9d9d9",thumb_round_corners_radius:0,thumb_color_overlay_effect:!0,thumb_overlay_color:"#000000",thumb_overlay_opacity:.4,thumb_overlay_reverse:!1,thumb_image_overlay_effect:!1,thumb_image_overlay_type:"bw",thumb_transition_duration:200,thumb_transition_easing:"easeOutQuad",thumb_show_loader:!0,thumb_loader_type:"dark",thumb_wrapper_as_link:!1,thumb_link_newpage:!1},j={touchEnabled:!1,num_thumbs_checking:0,customThumbs:!1,funcSetCustomThumbHtml:null,isEffectBorder:!1,isEffectOverlay:!1,isEffectImage:!1,colorOverlayOpacity:1,thumbInnerReduce:0,allowOnResize:!0},C={timeout_thumb_check:100,thumb_max_check_times:600,eventSizeChange:"thumb_size_change"};this.init=function(e,t){b=e.getObjects(),S=e,v=jQuery(e),y=b.g_objWrapper,I=b.g_arrItems,x=jQuery.extend(x,t),j.isEffectBorder=x.thumb_border_effect,j.isEffectOverlay=x.thumb_color_overlay_effect,j.isEffectImage=x.thumb_image_overlay_effect},this._____________EXTERNAL_SETTERS__________=function(){},this.setHtmlThumbs=function(e){w=e;var t=S.getNumItems();if(1==j.isEffectImage)var i=_();for(var n=0;t>n;n++){var r=I[n],o="";0==j.customThumbs&&(o=" ug-thumb-generated");var a=r.index+1,s="style='z-index:"+a+";'",l="<div class='ug-thumb-wrapper"+o+"' "+s+"></div>";if(1==x.thumb_wrapper_as_link){var u=r.link;""==r.link&&(u="javascript:void(0)");var d="";1==x.thumb_link_newpage&&r.link&&(d=" target='_blank'");var l="<a href='"+u+"'"+d+" class='ug-thumb-wrapper"+o+"'></a>"}
var g=jQuery(l),c=r.objThumbImage;if(0==j.customThumbs){if(1==x.thumb_show_loader&&c){var h="ug-thumb-loader-dark";"bright"==x.thumb_loader_type&&(h="ug-thumb-loader-bright"),g.append("<div class='ug-thumb-loader "+h+"'></div>"),g.append("<div class='ug-thumb-error' style='display:none'></div>")}
if(c){if(c.addClass("ug-thumb-image"),1==x.thumb_image_overlay_effect){var p=c.clone().appendTo(g);p.addClass("ug-thumb-image-overlay "+i).removeClass("ug-thumb-image"),p.fadeTo(0,0),r.objImageOverlay=p}
g.append(c)}}
j.isEffectBorder&&g.append("<div class='ug-thumb-border-overlay'></div>"),j.isEffectOverlay&&g.append("<div class='ug-thumb-overlay'></div>"),w.append(g),j.customThumbs&&j.funcSetCustomThumbHtml(g,r),I[n].objThumbWrapper=g}},this.setThumbNormalStyle=function(e,r,o){if(1==j.customThumbs&&e.removeClass("ug-thumb-over"),j.isEffectBorder&&t(e,x.thumb_border_width,x.thumb_border_color,r),j.isEffectOverlay){var a=1==x.thumb_overlay_reverse?!1:!0;i(e,a,r)}
j.isEffectImage&&n(e,!0,r),E.trigger(T.events.SETNORMALSTYLE,e)},this.setThumbOverStyle=function(e){if(1==j.customThumbs&&e.addClass("ug-thumb-over"),j.isEffectBorder&&t(e,x.thumb_over_border_width,x.thumb_over_border_color),j.isEffectOverlay){var r=1==x.thumb_overlay_reverse?!0:!1;i(e,r)}
1==j.isEffectImage&&n(e,!1),E.trigger(T.events.SETOVERSTYLE,e)},this.setHtmlProperties=function(){if(0==j.customThumbs){1==x.thumb_fixed_size&&e(x.thumb_width,x.thumb_height),a()}
if(w.children(".ug-thumb-wrapper").each(function(){var e=jQuery(this);l(e)}),j.isEffectOverlay&&x.thumb_overlay_color){var t={};if(P.isRgbaSupported()){var i=P.convertHexToRGB(x.thumb_overlay_color,x.thumb_overlay_opacity);t["background-color"]=i}else t["background-color"]=x.thumb_overlay_color,j.colorOverlayOpacity=x.thumb_overlay_opacity;w.find(".ug-thumb-wrapper .ug-thumb-overlay").css(t)}},this.setThumbSelected=function(e){return 1==j.customThumbs&&e.removeClass("ug-thumb-over"),1==g(e)?!0:(e.addClass("ug-thumb-selected"),void r(e))},this.setThumbUnselected=function(e){e.removeClass("ug-thumb-selected"),T.setThumbNormalStyle(e,!1,"set unselected")},this.setOptions=function(e){x=jQuery.extend(x,e)},this.setThumbInnerReduce=function(e){j.thumbInnerReduce=e},this.setCustomThumbs=function(e,t,i){if(j.customThumbs=!0,"function"!=typeof e)throw new Error("The argument should be function");j.funcSetCustomThumbHtml=e,-1==jQuery.inArray("overlay",t)&&(j.isEffectOverlay=!1),-1==jQuery.inArray("border",t)&&(j.isEffectBorder=!1),j.isEffectImage=!1,i&&i.allow_onresize===!1&&(j.allowOnResize=!1)},this._____________EXTERNAL_GETTERS__________=function(){},this.getOptions=function(){return x},this.getNumThumbs=function(){var e=I.length;return e},this.getThumbImage=function(e){var t=e.find(".ug-thumb-image");return t},this.getThumbByIndex=function(e){var t=T.getThumbs();if(e>=t.length||0>e)throw new Error("Wrong thumb index");var i=jQuery(t[e]);return i},this.getThumbs=function(){return w.children(".ug-thumb-wrapper")},this.getItemByThumb=function(e){var t=e.data("index");void 0===t&&(t=e.index());var i=I[t];return i},this.isThumbLoaded=function(e){var t=T.getItemByThumb(e);return t.isLoaded},this.getGlobalThumbSize=function(){var e={width:x.thumb_width,height:x.thumb_height};return e},this._____________EXTERNAL_OTHERS__________=function(){},this.initEvents=function(){var e=w.find(".ug-thumb-wrapper");e.on("touchstart",function(){j.touchEnabled=!0,e.off("mouseenter").off("mouseleave")}),1==j.allowOnResize&&y.on(C.eventSizeChange,c),e.hover(function(e){var t=jQuery(this);h(t)},function(e){var t=jQuery(this);p(t)}),E.on(T.events.THUMB_IMAGE_LOADED,m)},this.destroy=function(){var e=w.find(".ug-thumb-wrapper");e.off("touchstart"),y.off(C.eventSizeChange),e.off("mouseenter"),e.off("mouseleave"),E.off(T.events.THUMB_IMAGE_LOADED)},this.loadThumbsImages=function(){var e=w.find(".ug-thumb-image");P.checkImagesLoaded(e,null,function(e,t){if(0==t)f(e,!0);else{var i=jQuery(e).parent();o(i)}})},this.triggerImageLoadedEvent=function(e,t){E.trigger(T.events.THUMB_IMAGE_LOADED,[e,t])},this.hideThumbs=function(){w.find(".ug-thumb-wrapper").hide()}}
function UGThumbsStrip(){function e(e,i){S=e.getObjects(),O=e,O.attachThumbsPanel("strip",z),E=jQuery(e),P=S.g_objWrapper,x=S.g_arrItems,N=jQuery.extend(N,i),H=N.strip_vertical_type,1==H&&(N=jQuery.extend(N,Q),N=jQuery.extend(N,i),i.thumb_resize_by="width"),k.init(e,i),t()}
function t(){var e=k.getOptions();R.isNotFixedThumbs=e.thumb_fixed_size===!1,H=N.strip_vertical_type}
function n(){k.setHtmlProperties(),o(),l(),s(),0==R.isRunOnce&&(1==N.strip_control_touch&&(M=new UGTouchThumbsControl,M.init(z)),1==N.strip_control_avia&&(A=new UGAviaControl,A.init(z)),p(),k.loadThumbsImages(),y()),R.isRunOnce=!0}
function r(e){G.stripSize=e,0==H?G.stripActiveSize=G.stripSize-N.strip_padding_left-N.strip_padding_right:G.stripActiveSize=G.stripSize-N.strip_padding_top-N.strip_padding_bottom,G.stripActiveSize<0&&(G.stripActiveSize=0)}
function o(){var e=C.children(".ug-thumb-wrapper"),t=jQuery(e[0]),i=t.outerWidth(),n=t.outerHeight(),o=k.getOptions();0==H?(G.thumbSize=i,1==o.thumb_fixed_size?G.thumbSecondSize=n:G.thumbSecondSize=o.thumb_height,r(j.width()),G.stripInnerSize=C.width()):(G.thumbSize=n,1==o.thumb_fixed_size?G.thumbSecondSize=i:G.thumbSecondSize=o.thumb_width,r(j.height()),G.stripInnerSize=C.height())}
function a(e){0==H?C.width(e):C.height(e),G.stripInnerSize=e,p()}
function s(){var e=C.children(".ug-thumb-wrapper"),t=0,n=0;for(0==H&&(n=N.strip_padding_top),i=0;i<e.length;i++){var r=jQuery(e[i]);if(1==R.isNotFixedThumbs){if(objItem=k.getItemByThumb(r),0==objItem.isLoaded)continue;r.show()}
L.placeElement(r,t,n),0==H?t+=r.outerWidth()+N.strip_space_between_thumbs:n+=r.outerHeight()+N.strip_space_between_thumbs}
if(0==H)var o=t-N.strip_space_between_thumbs;else var o=n-N.strip_space_between_thumbs;a(o)}
function l(){if(0==H){var e=G.thumbSecondSize,t={};t.height=e+"px";var i={};i.height=e+"px"}else{var n=G.thumbSecondSize,t={};t.width=n+"px";var i={};i.width=n+"px"}
j.css(t),C.css(i)}
function u(e){var t=z.getInnerStripPos(),i=t+e;i=z.fixInnerStripLimits(i),z.positionInnerStrip(i,!0)}
function d(e){var t=T(e),i=-1*t.min;i=z.fixInnerStripLimits(i),z.positionInnerStrip(i,!0)}
function _(e){var t=T(e),i=-1*t.max+G.stripSize;i=z.fixInnerStripLimits(i),z.positionInnerStrip(i,!0)}
function g(e){if(0==I())return!1;var t=w(),i=T(e);if(i.min<t.minPosThumbs){var n=e.prev();d(n.length?n:e)}else if(i.max>t.maxPosThumbs){var r=e.next();_(r.length?r:e)}}
function c(){var e=O.getSelectedItem();if(null==e)return!0;var t=e.objThumbWrapper;t&&g(t)}
function h(){if(0==I())return!1;var e=z.getInnerStripPos(),t=z.fixInnerStripLimits(e);e!=t&&z.positionInnerStrip(t,!0)}
function p(){var e=I();1==e?(A&&A.enable(),M&&M.enable()):(A&&A.disable(),M&&M.disable())}
function f(){return I()?!1:void(0==H?L.placeElement(C,N.strip_thumbs_align,0):L.placeElement(C,0,N.strip_thumbs_align))}
function m(e){if(z.isTouchMotionActive()){var t=M.isSignificantPassed();if(1==t)return!0}
var i=k.getItemByThumb(e);O.selectItem(i)}
function v(){clearTimeout(R.handle),R.handle=setTimeout(function(){s()},50)}
function b(){var e=O.getSelectedItem();k.setThumbSelected(e.objThumbWrapper),g(e.objThumbWrapper)}
function y(){k.initEvents();var e=j.find(".ug-thumb-wrapper");e.on("click touchend",function(e){var t=jQuery(this);m(t)}),E.on(O.events.ITEM_CHANGE,b),R.isNotFixedThumbs&&jQuery(k).on(k.events.AFTERPLACEIMAGE,v)}
function I(){return G.stripInnerSize>G.stripActiveSize?!0:!1}
function w(){var e={},t=z.getInnerStripPos();return e.minPosThumbs=-1*t+1,e.maxPosThumbs=-1*t+G.stripSize-1,e}
function T(e){var t={},i=e.position();return 0==H?(t.min=i.left,t.max=i.left+G.thumbSize):(t.min=i.top,t.max=i.top+G.thumbSize),t}
var E,S,P,x,j,C,A,M,z=this,O=new UniteGalleryMain,L=new UGFunctions,H=!1,k=new UGThumbsGeneral,L=new UGFunctions,N={strip_vertical_type:!1,strip_thumbs_align:"left",strip_space_between_thumbs:6,strip_thumb_touch_sensetivity:15,strip_scroll_to_thumb_duration:500,strip_scroll_to_thumb_easing:"easeOutCubic",strip_control_avia:!0,strip_control_touch:!0,strip_padding_top:0,strip_padding_bottom:0,strip_padding_left:0,strip_padding_right:0},R={isRunOnce:!1,is_placed:!1,isNotFixedThumbs:!1,handle:null},G={stripSize:0,stripActiveSize:0,stripInnerSize:0,thumbSize:0,thumbSecondSize:0};this.events={STRIP_MOVE:"stripmove"};var Q={strip_thumbs_align:"top",thumb_resize_by:"width"};this.setHtml=function(e){if(!e){var e=P;null!=N.parent_container&&(e=N.parent_container)}
e.append("<div class='ug-thumbs-strip'><div class='ug-thumbs-strip-inner'></div></div>"),j=e.children(".ug-thumbs-strip"),C=j.children(".ug-thumbs-strip-inner"),k.setHtmlThumbs(C),1==R.isNotFixedThumbs&&k.hideThumbs()},this.destroy=function(){var e=j.find(".ug-thumb-wrapper");e.off("click"),e.off("touchend"),E.off(O.events.ITEM_CHANGE),jQuery(k).off(k.events.AFTERPLACEIMAGE),M&&M.destroy(),A&&A.destroy(),k.destroy()},this.________EXTERNAL_GENERAL___________=function(){},this.init=function(t,i){e(t,i)},this.run=function(){n()},this.positionInnerStrip=function(e,t){if(void 0===t)var t=!1;if(0==H)var i={left:e+"px"};else var i={top:e+"px"};0==t?(C.css(i),z.triggerStripMoveEvent()):(z.triggerStripMoveEvent(),C.stop(!0).animate(i,{duration:N.strip_scroll_to_thumb_duration,easing:N.strip_scroll_to_thumb_easing,queue:!1,progress:function(){z.triggerStripMoveEvent()},always:function(){z.triggerStripMoveEvent()}}))},this.triggerStripMoveEvent=function(){jQuery(z).trigger(z.events.STRIP_MOVE)},this.isTouchMotionActive=function(){if(!M)return!1;var e=M.isTouchActive();return e},this.isItemThumbVisible=function(e){var t=e.objThumbWrapper,i=t.position(),n=-1*z.getInnerStripPos();if(0==H)var r=n+G.stripSize,o=i.left,a=i.left+t.width();else var r=n+G.stripSize,o=i.top,a=i.top+t.height();var s=!1;return a>=n&&r>=o&&(s=!0),s},this.getInnerStripPos=function(){return 0==H?C.position().left:C.position().top},this.getInnerStripLimits=function(){var e={};return 0==H?e.maxPos=N.strip_padding_left:e.maxPos=N.strip_padding_top,e.minPos=-(G.stripInnerSize-G.stripActiveSize),e},this.fixInnerStripLimits=function(e){var t=z.getInnerStripLimits();return e>t.maxPos&&(e=t.maxPos),e<t.minPos&&(e=t.minPos),e},this.scrollForeward=function(){u(-G.stripSize)},this.scrollBack=function(){u(G.stripSize)},this.________EXTERNAL_SETTERS___________=function(){},this.setOptions=function(e){N=jQuery.extend(N,e),k.setOptions(e),t()},this.setSizeVertical=function(e){if(0==H)throw new Error("setSizeVertical error, the strip size is not vertical");var t=G.thumbSecondSize,i={};i.width=t+"px",i.height=e+"px",j.css(i),r(e);var n={};n.width=t+"px",n.left="0px",n.top="0px",C.css(n),R.is_placed=!0,p()},this.setSizeHorizontal=function(e){if(1==H)throw new Error("setSizeHorizontal error, the strip size is not horizontal");var t=G.thumbSecondSize+N.strip_padding_top+N.strip_padding_bottom,i={};i.width=e+"px",i.height=t+"px",j.css(i),r(e);var n=N.strip_padding_left,o={};o.height=t+"px",o.left=n+"px",o.top="0px",C.css(o),R.is_placed=!0,p()},this.setPosition=function(e,t,i,n){L.placeElement(j,e,t,i,n)},this.resize=function(e){0==H?(j.width(e),G.stripActiveSize=e-N.strip_padding_left-N.strip_padding_right):(j.height(e),G.stripActiveSize=e-N.strip_padding_top-N.strip_padding_bottom),r(e),p(),h(),f(),c()},this.setThumbUnselected=function(e){k.setThumbUnselected(e)},this.setCustomThumbs=function(e){k.setCustomThumbs(e)},this.________EXTERNAL_GETTERS___________=function(){},this.getObjects=function(){var e=k.getOptions(),t=jQuery.extend(N,e),i={g_gallery:O,g_objGallery:E,g_objWrapper:P,g_arrItems:x,g_objStrip:j,g_objStripInner:C,g_aviaControl:A,g_touchThumbsControl:M,isVertical:H,g_options:t,g_thumbs:k};return i},this.getObjThumbs=function(){return k},this.getSelectedThumb=function(){var e=O.getSelectedItemIndex();return-1==e?null:k.getThumbByIndex(e)},this.getSizeAndPosition=function(){var e=L.getElementSize(j);return e},this.getHeight=function(){var e=j.outerHeight();return e},this.getWidth=function(){var e=j.outerWidth();return e},this.getSizes=function(){return G},this.isVertical=function(){return H},this.isPlaced=function(){return R.is_placed},this.isMoveEnabled=function(){var e=I();return e}}
function UGTouchThumbsControl(){function e(){var e=jQuery.now(),t={};return t.passedTime=E.lastTime-E.startTime,t.lastActiveTime=e-E.buttonReleaseTime,t.passedDistance=E.lastPos-E.startPos,t.passedDistanceAbs=Math.abs(t.passedDistance),t}
function t(){T.thumb_touch_slowFactor=w.normalizeSetting(5e-5,.01,1,100,y.strip_thumb_touch_sensetivity,!0)}
function i(e){return 0==I?w.getMousePosition(e).pageX:w.getMousePosition(e).pageY}
function n(e){var t=E.mousePos-e,i=E.innerPos-t,n=h.getInnerStripLimits();if(i>n.maxPos){var r=i-n.maxPos;i=n.maxPos+r/3}
if(i<n.minPos){var r=n.minPos-i;i=n.minPos-r/3}
h.positionInnerStrip(i)}
function r(e){var t=h.getInnerStripPos();E.mousePos=e,E.innerPos=t,E.lastPortionPos=t,E.lastDeltaTime=0,E.lastDeltaPos=0,E.startTime=jQuery.now(),E.startPos=E.innerPos,E.lastTime=E.startTime,E.lastPos=E.startPos,E.speed=0}
function o(){var e=jQuery.now(),t=e-E.lastTime;t>=T.touch_portion_time&&(E.lastDeltaTime=e-E.lastTime,E.lastDeltaTime>T.touch_portion_time&&(E.lastDeltaTime=T.touch_portion_time),E.lastDeltaPos=E.lastPos-E.lastPortionPos,E.lastPortionPos=E.lastPos,E.lastTime=e)}
function a(){var e=T.thumb_touch_slowFactor,t=T.minDeltaTime,i=T.minPath,n=h.getInnerStripPos(),r=jQuery.now(),o=r-E.lastTime,a=n-E.lastPortionPos;t>o&&E.lastDeltaTime>0&&(o=E.lastDeltaTime,a=E.lastDeltaPos+a),t>o&&(o=t);var l=a>0?1:-1,u=0;o>0&&(u=a/o);var d=u*u/(2*e)*l;Math.abs(d)<=i&&(d=0);var _=h.getInnerStripPos(),g=_+d,c=h.fixInnerStripLimits(g),p=h.getInnerStripLimits(),f=T.limitsBreakAddition,m=!1,v=c;if(g>p.maxPos&&(m=!0,c=f,f>g&&(c=g)),g<p.minPos){m=!0;var y=p.minPos-f;c=y,g>y&&(c=g)}
var w=c-_,S=Math.abs(Math.round(u/e));if(0!=d&&(S=S*w/d),_!=c){var P={left:c+"px"};1==I&&(P={top:c+"px"}),b.animate(P,{duration:S,easing:T.animationEasing,queue:!0,progress:s})}
if(1==m){var x=T.returnAnimateSpeed,j={left:v+"px"};1==I&&(j={top:v+"px"}),b.animate(j,{duration:x,easing:T.returnAnimationEasing,queue:!0,progress:s})}}
function s(){E.lastPos=h.getInnerStripPos(),h.triggerStripMoveEvent()}
function l(){return 1==E.loop_active?!0:(E.loop_active=!0,void(E.handle=setInterval(o,10)))}
function u(e){if(0==E.loop_active)return!0;if(e){var t=i(e);a(t)}
E.loop_active=!1,E.handle=clearInterval(E.handle)}
function d(e){return 0==E.isControlEnabled?!0:(E.buttonReleaseTime=jQuery.now(),0==E.touch_active?(u(e),!0):(e.preventDefault(),E.touch_active=!1,u(e),void v.removeClass("ug-dragging")))}
function _(e){if(0==E.isControlEnabled)return!0;e.preventDefault(),E.touch_active=!0;var t=i(e);b.stop(!0),r(t),l(),v.addClass("ug-dragging")}
function g(e){if(0==E.isControlEnabled)return!0;if(0==E.touch_active)return!0;if(e.preventDefault(),0==e.buttons)return E.touch_active=!1,u(e),!0;var t=i(e);E.lastPos=h.getInnerStripPos(),n(t),o()}
function c(){v.bind("mousedown touchstart",_),jQuery(window).add("body").bind("mouseup touchend",d),jQuery("body").bind("mousemove touchmove",g)}
var h,p,f,m,v,b,y,I,w=new UGFunctions,T={touch_portion_time:200,thumb_touch_slowFactor:0,minDeltaTime:70,minPath:10,limitsBreakAddition:30,returnAnimateSpeed:500,animationEasing:"easeOutCubic",returnAnimationEasing:"easeOutCubic"},E={touch_active:!1,loop_active:!1,mousePos:0,innerPos:0,startPos:0,startTime:0,lastTime:0,buttonReleaseTime:0,lastPos:0,lastPortionPos:0,lastDeltaTime:0,lastDeltaPos:0,speed:0,handle:"",touchEnabled:!1,isControlEnabled:!0};this.enable=function(){E.isControlEnabled=!0},this.disable=function(){E.isControlEnabled=!1},this.init=function(e){h=e,m=e.getObjects(),p=m.g_gallery,f=m.g_objGallery,v=m.g_objStrip,b=m.g_objStripInner,y=m.g_options,I=m.isVertical,t(),c()},this.isSignificantPassed=function(){var t=e();return t.passedTime>300?!0:t.passedDistanceAbs>30?!0:!1},this.isTouchActive=function(){if(1==E.touch_active)return!0;if(1==b.is(":animated"))return!0;var t=e();return t.lastActiveTime<50?!0:!1},this.destroy=function(){v.unbind("mousedown"),v.unbind("touchstart"),jQuery(window).add("body").unbind("mouseup").unbind("touchend"),jQuery("body").unbind("mousemove").unbind("touchmove")}}
function UGPanelsBase(){function e(e,t){switch(n.orientation){case"right":case"left":var i={left:e+"px"};break;case"top":case"bottom":var i={top:e+"px"}}
o.stop(!0).animate(i,{duration:300,easing:"easeInOutQuad",queue:!1,complete:function(){t&&t()}})}
function t(e){switch(n.orientation){case"right":case"left":g.placeElement(o,e,null);break;case"top":case"bottom":g.placeElement(o,null,e)}}
function i(){s.trigger(r.events.FINISH_MOVE)}
var n,r,o,a,s,l,u,d=new UniteGalleryMain,_=this,g=new UGFunctions;this.init=function(e,t,i,o,l){n=t,r=i,d=e,a=o,s=l,u=jQuery(d)},this.setHtml=function(e){if(o=e,"strip"==n.panelType)var t=a.strippanel_enable_handle;else var t=a.gridpanel_enable_handle;if(1==t&&(l=new UGPanelHandle,l.init(r,o,a,n.panelType,d),l.setHtml()),n.isDisabledAtStart===!0){var i="<div class='ug-overlay-disabled'></div>";o.append(i),setTimeout(function(){o.children(".ug-overlay-disabled").hide()},n.disabledAtStartTimeout)}},this.placeElements=function(){l&&l.placeHandle()},this.initEvents=function(){l&&(l.initEvents(),u.on(d.events.SLIDER_ACTION_START,function(){l.hideHandle()}),u.on(d.events.SLIDER_ACTION_END,function(){l.showHandle()}))},this.destroy=function(){l&&(l.destroy(),u.off(d.events.SLIDER_ACTION_START),u.off(d.events.SLIDER_ACTION_END))},this.openPanel=function(a){if(!a)var a=!1;return o.is(":animated")?!1:0==n.isClosed?!1:(n.isClosed=!1,s.trigger(r.events.OPEN_PANEL),void(a===!1?e(n.originalPos,i):(t(n.originalPos),i())))},this.closePanel=function(a){if(!a)var a=!1;if(o.is(":animated"))return!1;if(1==n.isClosed)return!1;var l=_.getClosedPanelDest();n.isClosed=!0,s.trigger(r.events.CLOSE_PANEL),a===!1?e(l,i):(t(l),i())},this.setClosedState=function(e){n.originalPos=e,s.trigger(r.events.CLOSE_PANEL),n.isClosed=!0},this.setOpenedState=function(e){s.trigger(r.events.OPEN_PANEL),n.isClosed=!1},this.getClosedPanelDest=function(){var e,t=g.getElementSize(o);switch(n.orientation){case"left":n.originalPos=t.left,e=-n.panelWidth;break;case"right":n.originalPos=t.left;var i=d.getSize();e=i.width;break;case"top":n.originalPos=t.top,e=-n.panelHeight;break;case"bottom":n.originalPos=t.top;var i=d.getSize();e=i.height}
return e},this.isPanelClosed=function(){return n.isClosed},this.setDisabledAtStart=function(e){return 0>=e?!1:(n.isDisabledAtStart=!0,void(n.disabledAtStartTimeout=e))}}
function UGPanelHandle(){function e(){s.removeClass("ug-button-hover")}
function t(){s.addClass("ug-button-closed")}
function i(){s.removeClass("ug-button-closed")}
function n(e){return e.stopPropagation(),e.stopImmediatePropagation(),0==l.validateClickTouchstartEvent(e.type)?!0:void(a.isPanelClosed()?a.openPanel():a.closePanel())}
function r(){var e=a.getOrientation();switch(e){case"right":case"left":"top"!=u.panel_handle_align&&"bottom"!=u.panel_handle_align&&(u.panel_handle_align="top");break;case"bottom":"left"!=u.panel_handle_align&&"right"!=u.panel_handle_align&&(u.panel_handle_align="left");break;case"top":"left"!=u.panel_handle_align&&"right"!=u.panel_handle_align&&(u.panel_handle_align="right")}}
var o,a,s,l=new UGFunctions,u={panel_handle_align:"top",panel_handle_offset:0,panel_handle_skin:0};this.init=function(e,t,i,n,r){switch(a=e,o=t,n){case"grid":u.panel_handle_align=i.gridpanel_handle_align,u.panel_handle_offset=i.gridpanel_handle_offset,u.panel_handle_skin=i.gridpanel_handle_skin;break;case"strip":u.panel_handle_align=i.strippanel_handle_align,u.panel_handle_offset=i.strippanel_handle_offset,u.panel_handle_skin=i.strippanel_handle_skin;break;default:throw new Error("Panel handle error: wrong panel type: "+n)}
var s=r.getOptions(),l=s.gallery_skin;""==u.panel_handle_skin&&(u.panel_handle_skin=l)},this.setHtml=function(){var e=a.getOrientation(),t="ug-panel-handle-tip";switch(e){case"right":t+=" ug-handle-tip-left";break;case"left":t+=" ug-handle-tip-right";break;case"bottom":t+=" ug-handle-tip-top";break;case"top":t+=" ug-handle-tip-bottom"}
o.append("<div class='"+t+" ug-skin-"+u.panel_handle_skin+"'></div>"),s=o.children(".ug-panel-handle-tip")},this.initEvents=function(){l.addClassOnHover(s),s.bind("click touchstart",n),jQuery(a).on(a.events.OPEN_PANEL,function(){e(),i()}),jQuery(a).on(a.events.CLOSE_PANEL,function(){e(),t()})},this.destroy=function(){l.destroyButton(s),jQuery(a).off(a.events.OPEN_PANEL),jQuery(a).off(a.events.CLOSE_PANEL)},this.placeHandle=function(){var e=l.getElementSize(s);r();var t=a.getOrientation();switch(t){case"left":l.placeElement(s,"right",u.panel_handle_align,-e.width);break;case"right":l.placeElement(s,-e.width,u.panel_handle_align,0,u.panel_handle_offset);break;case"top":l.placeElement(s,u.panel_handle_align,"bottom",u.panel_handle_offset,-e.height);break;case"bottom":l.placeElement(s,u.panel_handle_align,"top",u.panel_handle_offset,-e.height);break;default:throw new Error("Wrong panel orientation: "+t)}},this.hideHandle=function(){1==s.is(":visible")&&s.hide()},this.showHandle=function(){0==s.is(":visible")&&s.show()}}
function UGStripPanel(){function e(e,t){E=e,m=jQuery(E),j=jQuery.extend(j,t);var i=!1;1==j.strippanel_vertical_type&&(j=jQuery.extend(j,C),i=!0),0==j.strippanel_enable_buttons&&(j=jQuery.extend(j,A),i=!0),1==i&&(j=jQuery.extend(j,t));var n=E.getOptions(),r=n.gallery_skin;""==j.strippanel_buttons_skin&&(j.strippanel_buttons_skin=r),v=E.getElement(),x.init(E,M,w,j,T),P=new UGThumbsStrip,P.init(E,j)}
function t(){if(0==j.strippanel_vertical_type){if(0==M.panelWidth)throw new Error("Strip panel error: The width not set, please set width")}else if(0==M.panelHeight)throw new Error("Strip panel error: The height not set, please set height");if(null==M.orientation)throw new Error("Wrong orientation, please set panel orientation before run");return!0}
function i(){return 1==M.isFirstRun&&0==t()?!1:(P.run(),s(),d(),f(),M.isFirstRun=!1,void c())}
function n(e){if(!e)var e=v;if(e.append("<div class='ug-strip-panel'></div>"),b=e.children(".ug-strip-panel"),1==j.strippanel_enable_buttons){var t="ug-strip-arrow-left",i="ug-strip-arrow-right";1==j.strippanel_vertical_type&&(t="ug-strip-arrow-up",i="ug-strip-arrow-down"),b.append("<div class='ug-strip-arrow "+t+" ug-skin-"+j.strippanel_buttons_skin+"'><div class='ug-strip-arrow-tip'></div></div>"),b.append("<div class='ug-strip-arrow "+i+" ug-skin-"+j.strippanel_buttons_skin+"'><div class='ug-strip-arrow-tip'></div></div>")}
x.setHtml(b),P.setHtml(b),1==j.strippanel_enable_buttons&&(I=b.children("."+t),y=b.children("."+i)),r()}
function r(){""!=j.strippanel_background_color&&b.css("background-color",j.strippanel_background_color)}
function o(){var e=P.getHeight(),t=M.panelWidth;if(y){I.height(e),y.height(e);var i=I.children(".ug-strip-arrow-tip");S.placeElement(i,"center","middle");var n=y.children(".ug-strip-arrow-tip");S.placeElement(n,"center","middle")}
var r=e+j.strippanel_padding_top+j.strippanel_padding_bottom;b.width(t),b.height(r),M.panelHeight=r;var o=t-j.strippanel_padding_left-j.strippanel_padding_right;if(y){var a=y.outerWidth();o=o-2*a-2*j.strippanel_padding_buttons}
P.resize(o)}
function a(){var e=P.getWidth(),t=M.panelHeight;if(y){I.width(e),y.width(e);var i=I.children(".ug-strip-arrow-tip");S.placeElement(i,"center","middle");var n=y.children(".ug-strip-arrow-tip");S.placeElement(n,"center","middle")}
var r=e+j.strippanel_padding_left+j.strippanel_padding_right;b.width(r),b.height(t),M.panelWidth=r;var o=t-j.strippanel_padding_top-j.strippanel_padding_bottom;if(y){var a=y.outerHeight();o=o-2*a-2*j.strippanel_padding_buttons}
P.resize(o)}
function s(){0==j.strippanel_vertical_type?o():a()}
function l(){y&&(S.placeElement(I,"left","top",j.strippanel_padding_left,j.strippanel_padding_top),S.placeElement(y,"right","top",j.strippanel_padding_right,j.strippanel_padding_top));var e=j.strippanel_padding_left;y&&(e+=y.outerWidth()+j.strippanel_padding_buttons),P.setPosition(e,j.strippanel_padding_top)}
function u(){y&&(S.placeElement(I,"left","top",j.strippanel_padding_left,j.strippanel_padding_top),S.placeElement(y,"left","bottom",j.strippanel_padding_left,j.strippanel_padding_bottom));var e=j.strippanel_padding_top;y&&(e+=y.outerHeight()+j.strippanel_padding_buttons),P.setPosition(j.strippanel_padding_left,e)}
function d(){0==j.strippanel_vertical_type?l():u(),x.placeElements()}
function _(e){return S.isButtonDisabled(e)?!0:void("advance_item"==j.strippanel_buttons_role?E.nextItem():P.scrollForeward())}
function g(e){return S.isButtonDisabled(e)?!0:void("advance_item"==j.strippanel_buttons_role?E.prevItem():P.scrollBack())}
function c(){if(!y)return!0;if(0==P.isMoveEnabled())return S.disableButton(I),S.disableButton(y),!0;var e=P.getInnerStripLimits(),t=P.getInnerStripPos();t>=e.maxPos?S.disableButton(I):S.enableButton(I),t<=e.minPos?S.disableButton(y):S.enableButton(y)}
function h(){c()}
function p(){E.isLastItem()?S.disableButton(y):S.enableButton(y),E.isFirstItem()?S.disableButton(I):S.enableButton(I)}
function f(){if(1==M.isEventsInited)return!1;if(M.isEventsInited=!0,y)
if(S.addClassOnHover(y,"ug-button-hover"),S.addClassOnHover(I,"ug-button-hover"),S.setButtonOnClick(I,g),S.setButtonOnClick(y,_),"advance_item"!=j.strippanel_buttons_role)jQuery(P).on(P.events.STRIP_MOVE,h),m.on(E.events.SIZE_CHANGE,c);else{var e=E.getOptions();0==e.gallery_carousel&&jQuery(E).on(E.events.ITEM_CHANGE,p)}
x.initEvents()}
var m,v,b,y,I,w=this,T=jQuery(this),E=new UniteGalleryMain,S=new UGFunctions,P=new UGThumbsStrip,x=new UGPanelsBase;this.events={FINISH_MOVE:"gridpanel_move_finish",OPEN_PANEL:"open_panel",CLOSE_PANEL:"close_panel"};var j={strippanel_vertical_type:!1,strippanel_padding_top:8,strippanel_padding_bottom:8,strippanel_padding_left:0,strippanel_padding_right:0,strippanel_enable_buttons:!0,strippanel_buttons_skin:"",strippanel_padding_buttons:2,strippanel_buttons_role:"scroll_strip",strippanel_enable_handle:!0,strippanel_handle_align:"top",strippanel_handle_offset:0,strippanel_handle_skin:"",strippanel_background_color:""},C={strip_vertical_type:!0,strippanel_padding_left:8,strippanel_padding_right:8,strippanel_padding_top:0,strippanel_padding_bottom:0},A={strippanel_padding_left:8,strippanel_padding_right:8,strippanel_padding_top:8,strippanel_padding_bottom:8},M={panelType:"strip",panelWidth:0,panelHeight:0,isEventsInited:!1,isClosed:!1,orientation:null,originalPos:null,isFirstRun:!0};this.destroy=function(){y&&(S.destroyButton(y),S.destroyButton(I),jQuery(P).off(P.events.STRIP_MOVE),jQuery(E).off(E.events.ITEM_CHANGE),jQuery(E).off(E.events.SIZE_CHANGE)),x.destroy(),P.destroy()},this.getOrientation=function(){return M.orientation},this.setOrientation=function(e){M.orientation=e},this.init=function(t,i){e(t,i)},this.run=function(){i()},this.setHtml=function(e){n(e)},this.getElement=function(){return b},this.getSize=function(){var e=S.getElementSize(b);return e},this.setWidth=function(e){M.panelWidth=e},this.setHeight=function(e){M.panelHeight=e},this.resize=function(e){w.setWidth(e),s(),d()},this.__________Functions_From_Base_____=function(){},this.isPanelClosed=function(){return x.isPanelClosed()},this.getClosedPanelDest=function(){return x.getClosedPanelDest()},this.openPanel=function(e){x.openPanel(e)},this.closePanel=function(e){x.closePanel(e)},this.setOpenedState=function(e){x.setOpenedState(e)},this.setClosedState=function(e){x.setClosedState(e)},this.setCustomThumbs=function(e){P.setCustomThumbs(e)},this.setDisabledAtStart=function(e){x.setDisabledAtStart(e)}}
function UGGridPanel(){function e(e,i){x=e,t(),i&&i.vertical_scroll&&(M.gridpanel_vertical_scroll=i.vertical_scroll),M=jQuery.extend(M,i),1==L.isHorType?(M=jQuery.extend(M,O),M=jQuery.extend(M,i)):1==M.gridpanel_vertical_scroll&&(M=jQuery.extend(M,z),M=jQuery.extend(M,i),M.grid_panes_direction="bottom");var n=x.getOptions(),r=n.gallery_skin;""==M.gridpanel_arrows_skin&&(M.gridpanel_arrows_skin=r);var o=e.getObjects();I=o.g_objWrapper,A.init(x,L,S,M,P),C=new UGThumbsGrid,C.init(x,M)}
function t(){if(null==L.orientation)throw new Error("Wrong orientation, please set panel orientation before run")}
function i(){t(),o(),C.run(),l(),u(),y(),d()}
function n(){I.append("<div class='ug-grid-panel'></div>"),w=I.children(".ug-grid-panel"),L.isHorType?(w.append("<div class='grid-arrow grid-arrow-left-hortype ug-skin-"+M.gridpanel_arrows_skin+"'></div>"),w.append("<div class='grid-arrow grid-arrow-right-hortype ug-skin-"+M.gridpanel_arrows_skin+"'></div>"),E=w.children(".grid-arrow-left-hortype"),T=w.children(".grid-arrow-right-hortype")):0==M.gridpanel_vertical_scroll?(w.append("<div class='grid-arrow grid-arrow-left ug-skin-"+M.gridpanel_arrows_skin+"'></div>"),w.append("<div class='grid-arrow grid-arrow-right ug-skin-"+M.gridpanel_arrows_skin+"'></div>"),E=w.children(".grid-arrow-left"),T=w.children(".grid-arrow-right")):(w.append("<div class='grid-arrow grid-arrow-up ug-skin-"+M.gridpanel_arrows_skin+"'></div>"),w.append("<div class='grid-arrow grid-arrow-down ug-skin-"+M.gridpanel_arrows_skin+"'></div>"),E=w.children(".grid-arrow-up"),T=w.children(".grid-arrow-down")),A.setHtml(w),E.fadeTo(0,0),T.fadeTo(0,0),C.setHtml(w),r()}
function r(){""!=M.gridpanel_background_color&&w.css("background-color",M.gridpanel_background_color)}
function o(){"center"==M.gridpanel_grid_align&&(M.gridpanel_grid_align="middle")}
function a(){var e=M.gridpanel_padding_border_top+M.gridpanel_padding_border_bottom,t=L.panelHeight-e;if(0==M.gridpanel_arrows_always_on){var i=C.getNumPanesEstimationByHeight(t);if(1==i)return t}
var n=j.getElementSize(T),r=n.height,e=r+M.gridpanel_arrows_padding_vert;return 1==M.gridpanel_vertical_scroll&&(e*=2),e+=M.gridpanel_padding_border_top+M.gridpanel_padding_border_bottom,t=L.panelHeight-e}
function s(){var e=M.gridpanel_padding_border_left+M.gridpanel_padding_border_right,t=L.panelWidth-e;if(0==M.gridpanel_arrows_always_on){var i=C.getNumPanesEstimationByWidth(t);if(1==i)return t}
var n=j.getElementSize(T),r=n.width;return e+=2*(r+M.gridpanel_arrows_padding_hor),t=L.panelWidth-e}
function l(){var e=!1;if(1==M.gridpanel_arrows_always_on)e=!0;else{var t=C.getNumPanes();t>1&&(e=!0)}
1==e?(T.show().fadeTo(0,1),E.show().fadeTo(0,1),L.arrowsVisible=!0):(T.hide(),E.hide(),L.arrowsVisible=!1)}
function u(){var e=C.getSize();1==L.isHorType?L.panelHeight=e.height+M.gridpanel_padding_border_top+M.gridpanel_padding_border_bottom:L.panelWidth=e.width+M.gridpanel_padding_border_left+M.gridpanel_padding_border_right,j.setElementSize(w,L.panelWidth,L.panelHeight)}
function d(){return 1==L.isEventsInited?!1:(L.isEventsInited=!0,E&&(j.addClassOnHover(E),C.attachPrevPaneButton(E)),T&&(j.addClassOnHover(T),C.attachNextPaneButton(T)),void A.initEvents())}
function _(){var e=M.gridpanel_padding_border_left;return e}
function g(){var e=M.gridpanel_grid_align,t=0;switch(e){case"top":t=M.gridpanel_padding_border_top;break;case"bottom":t=M.gridpanel_padding_border_bottom}
var i=_(),n=C.getElement();j.placeElement(n,i,e,0,t)}
function c(){var e,t,i,n,r=j.getElementSize(E),o=C.getSize();switch(M.gridpanel_grid_align){default:case"top":e=M.gridpanel_padding_border_top+r.height+M.gridpanel_arrows_padding_vert;break;case"middle":e="middle";break;case"bottom":e=L.panelHeight-o.height-r.height-M.gridpanel_padding_border_bottom-M.gridpanel_arrows_padding_vert}
var a=_(),s=C.getElement();j.placeElement(s,a,e);var o=C.getSize();switch(M.gridpanel_arrows_align_vert){default:case"center":case"middle":t=(o.top-r.height)/2,i=o.bottom+(L.panelHeight-o.bottom-r.height)/2,n=0;break;case"grid":t=o.top-r.height-M.gridpanel_arrows_padding_vert_vert,i=o.bottom+M.gridpanel_arrows_padding_vert,n=0;break;case"border":case"borders":t=M.gridpanel_padding_border_top,i="bottom",n=M.gridpanel_padding_border_bottom}
j.placeElement(E,"center",t),j.placeElement(T,"center",i,0,n)}
function h(){1==L.arrowsVisible?c():g()}
function p(){var e,t,i,n,r=j.getElementSize(E),o=C.getSize(),a=M.gridpanel_padding_border_top;switch(M.gridpanel_grid_align){case"middle":switch(M.gridpanel_arrows_align_vert){default:var s=o.height+M.gridpanel_arrows_padding_vert+r.height;a=(L.panelHeight-s)/2;break;case"border":case"borders":var l=L.panelHeight-r.height-M.gridpanel_padding_border_bottom;a=(l-o.height)/2}
break;case"bottom":var s=o.height+r.height+M.gridpanel_arrows_padding_vert;a=L.panelHeight-s-M.gridpanel_padding_border_bottom}
var u=C.getElement(),d=_();j.placeElement(u,d,a);var o=C.getSize();switch(M.gridpanel_arrows_align_vert){default:case"center":case"middle":e=o.bottom+(L.panelHeight-o.bottom-r.height)/2,i=0;break;case"grid":e=o.bottom+M.gridpanel_arrows_padding_vert,i=0;break;case"border":case"borders":e="bottom",i=M.gridpanel_padding_border_bottom}
t=-r.width/2-M.gridpanel_space_between_arrows/2,j.placeElement(E,"center",e,t,i);var n=Math.abs(t);j.placeElement(T,"center",e,n,i)}
function f(){1==L.arrowsVisible?p():g()}
function m(){var e,t,i,n,r=j.getElementSize(E),o=C.getSize();switch(M.gridpanel_grid_align){default:case"left":e=M.gridpanel_padding_border_left+M.gridpanel_arrows_padding_hor+r.width;break;case"middle":case"center":e="center";break;case"right":e=L.panelWidth-o.width-r.width-M.gridpanel_padding_border_right-M.gridpanel_arrows_padding_hor}
var a=C.getElement();switch(j.placeElement(a,e,M.gridpanel_padding_border_top),o=C.getSize(),M.gridpanel_arrows_align_vert){default:case"center":case"middle":n=(o.height-r.height)/2+o.top;break;case"top":n=M.gridpanel_padding_border_top+M.gridpanel_arrows_padding_vert;break;case"bottom":n=L.panelHeight-M.gridpanel_padding_border_bottom-M.gridpanel_arrows_padding_vert-r.height}
switch(M.gridpanel_arrows_align_hor){default:case"borders":t=M.gridpanel_padding_border_left,i=L.panelWidth-M.gridpanel_padding_border_right-r.width;break;case"grid":t=o.left-M.gridpanel_arrows_padding_hor-r.width,i=o.right+M.gridpanel_arrows_padding_hor;break;case"center":t=(o.left-r.width)/2,i=o.right+(L.panelWidth-o.right-r.width)/2}
j.placeElement(E,t,n),j.placeElement(T,i,n)}
function v(){var e,t=C.getSize();switch(M.gridpanel_grid_align){default:case"left":e=M.gridpanel_padding_border_left;break;case"middle":case"center":e="center";break;case"right":e=L.panelWidth-t.width-M.gridpanel_padding_border_right}
var i=C.getElement();j.placeElement(i,e,M.gridpanel_padding_border_top)}
function b(){1==L.arrowsVisible?m():v()}
function y(){0==L.isHorType?1==M.gridpanel_vertical_scroll?h():f():b(),A.placeElements()}
var I,w,T,E,S=this,P=jQuery(this),x=new UniteGalleryMain,j=new UGFunctions,C=new UGThumbsGrid,A=new UGPanelsBase;this.events={FINISH_MOVE:"gridpanel_move_finish",OPEN_PANEL:"open_panel",CLOSE_PANEL:"close_panel"};var M={gridpanel_vertical_scroll:!0,gridpanel_grid_align:"middle",gridpanel_padding_border_top:10,gridpanel_padding_border_bottom:4,gridpanel_padding_border_left:10,gridpanel_padding_border_right:10,gridpanel_arrows_skin:"",gridpanel_arrows_align_vert:"middle",gridpanel_arrows_padding_vert:4,gridpanel_arrows_align_hor:"center",gridpanel_arrows_padding_hor:10,gridpanel_space_between_arrows:20,gridpanel_arrows_always_on:!1,gridpanel_enable_handle:!0,gridpanel_handle_align:"top",gridpanel_handle_offset:0,gridpanel_handle_skin:"",gridpanel_background_color:""},z={gridpanel_grid_align:"middle",gridpanel_padding_border_top:2,gridpanel_padding_border_bottom:2},O={gridpanel_grid_align:"center"},L={panelType:"grid",isHorType:!1,arrowsVisible:!1,panelHeight:0,panelWidth:0,originalPosX:null,isEventsInited:!1,isClosed:!1,orientation:null};this.destroy=function(){E&&j.destroyButton(E),T&&j.destroyButton(T),A.destroy(),C.destroy()},this.getOrientation=function(){return L.orientation},this.setOrientation=function(e){switch(L.orientation=e,e){case"right":case"left":L.isHorType=!1;break;case"top":case"bottom":L.isHorType=!0;break;default:throw new Error("Wrong grid panel orientation: "+e)}},this.setHeight=function(e){if(1==L.isHorType)throw new Error("setHeight is not appliable to this orientatio ("+L.orientation+"). Please use setWidth");L.panelHeight=e;var t=a();C.setMaxHeight(t)},this.setWidth=function(e){if(0==L.isHorType)throw new Error("setWidth is not appliable to this orientatio ("+L.orientation+"). Please use setHeight");L.panelWidth=e;var t=s();C.setMaxWidth(t)},this.init=function(t,i){e(t,i)},this.setHtml=function(){n()},this.run=function(){i()},this.getElement=function(){return w},this.getSize=function(){var e=j.getElementSize(w);return e},this.__________Functions_From_Base_____=function(){},this.isPanelClosed=function(){return A.isPanelClosed()},this.getClosedPanelDest=function(){return A.getClosedPanelDest()},this.openPanel=function(e){A.openPanel(e)},this.closePanel=function(e){A.closePanel(e)},this.setOpenedState=function(e){A.setOpenedState(e)},this.setClosedState=function(e){A.setClosedState(e)},this.setDisabledAtStart=function(e){A.setDisabledAtStart(e)}}
function UGThumbsGrid(){function e(e,t,i){H=e.getObjects(),W=e,W.attachThumbsPanel("grid",Q),L=jQuery(e),k=H.g_objWrapper,N=H.g_arrItems,i===!0&&(V.isTilesMode=!0),V.numThumbs=N.length,d(t),V.isNavigationVertical="top"==U.grid_panes_direction||"bottom"==U.grid_panes_direction,1==V.isTilesMode?(Y.setFixedMode(),Y.setApproveClickFunction(P),Y.init(e,U),B=Y.getObjThumbs()):(t.thumb_fixed_size=!0,B.init(e,t))}
function t(e){var t=k;e&&(t=e),t.append("<div class='ug-thumbs-grid'><div class='ug-thumbs-grid-inner'></div></div>"),R=t.children(".ug-thumbs-grid"),G=R.children(".ug-thumbs-grid-inner"),1==V.isTilesMode?Y.setHtml(G):B.setHtmlThumbs(G)}
function n(){if(0==V.isHorizontal){if(0==V.gridHeight)throw new Error("You must set height before run.")}else if(0==V.gridWidth)throw new Error("You must set width before run.")}
function r(){var e=W.getSelectedItem();if(n(),1==V.isFirstTimeRun&&(O(),1==V.isTilesMode?(l(),Y.run()):(B.setHtmlProperties(),l(),B.loadThumbsImages())),h(),1==V.isFirstTimeRun&&V.isTilesMode){var t=B.getThumbs();t.each(function(e,t){k.trigger(V.eventSizeChange,jQuery(t))}),t.fadeTo(0,1)}
null!=e&&u(e.index),D.trigger(Q.events.PANE_CHANGE,V.currentPane),V.isFirstTimeRun=!1}
function o(){if(1==V.isTilesMode)var e=Y.getGlobalTileSize();else var e=B.getGlobalThumbSize();return e}
function a(){var e=o(),t=e.height,i=V.gridWidth,n=U.grid_num_rows*t+(U.grid_num_rows-1)*U.grid_space_between_rows+2*U.grid_padding;V.gridHeight=n,F.setElementSize(R,i,n),F.setElementSize(G,i,n),V.innerWidth=i,V.innerHeight=n}
function s(){var e=o(),t=e.width,i=U.grid_num_cols*t+(U.grid_num_cols-1)*U.grid_space_between_cols+2*U.grid_padding,n=V.gridHeight;V.gridWidth=i,F.setElementSize(R,i,n),F.setElementSize(G,i,n),V.innerWidth=i,V.innerHeight=n}
function l(){0==V.isHorizontal?s():a()}
function u(e){var t=T(e);return-1==t?!1:void Q.gotoPane(t,"scroll")}
function d(e){U=jQuery.extend(U,e),B.setOptions(e)}
function _(){var e=G.children(".ug-thumb-wrapper"),t=0,n=0,r=0,o=0,a=0,s=0;V.innerWidth=0,V.numPanes=1,V.arrPanes=[],V.numThumbsInPane=0,V.arrPanes.push(o);var l=e.length;for(i=0;i<l;i++){var u=jQuery(e[i]);F.placeElement(u,t,n);var d=u.outerWidth(),_=u.outerHeight();t>a&&(a=t);var g=n+_;g>s&&(s=g);var c=a+d;c>V.innerWidth&&(V.innerWidth=c),t+=d+U.grid_space_between_cols,r++,r>=U.grid_num_cols&&(n+=_+U.grid_space_between_rows,t=o,r=0),1==V.numPanes&&V.numThumbsInPane++,n+_>V.gridHeight&&(n=0,o=V.innerWidth+U.grid_space_between_cols,t=o,r=0,1==V.isMaxHeight&&1==V.numPanes&&(V.gridHeight=s,R.height(V.gridHeight)),i<l-1&&(V.numPanes++,V.arrPanes.push(o)))}
G.width(V.innerWidth),1==V.isMaxHeight&&1==V.numPanes&&(V.gridHeight=s,R.height(s))}
function g(){var e=G.children(".ug-thumb-wrapper"),t=0,n=0,r=0,o=0,a=0,s=0;V.innerWidth=0,V.numPanes=1,V.arrPanes=[],V.numThumbsInPane=0,V.arrPanes.push(a);var l=e.length;for(i=0;i<l;i++){var u=jQuery(e[i]);F.placeElement(u,t,n);var d=u.outerWidth(),_=u.outerHeight();t+=d+U.grid_space_between_cols;var g=n+_;g>r&&(r=g),o++,o>=U.grid_num_cols&&(n+=_+U.grid_space_between_rows,t=a,o=0),1==V.numPanes&&V.numThumbsInPane++,g=n+_;var c=s+V.gridHeight;g>c&&(1==V.isMaxHeight&&1==V.numPanes&&(V.gridHeight=r,R.height(V.gridHeight),c=V.gridHeight),n=c+U.grid_space_between_rows,s=n,a=0,t=a,o=0,i<l-1&&(V.numPanes++,V.arrPanes.push(n)))}
G.height(r),V.innerHeight=r,1==V.isMaxHeight&&1==V.numPanes&&(V.gridHeight=r,R.height(r))}
function c(){var e=G.children(".ug-thumb-wrapper"),t=U.grid_padding,n=U.grid_padding,r=n,o=t,a=0,s=0,l=0,u=0;V.innerWidth=0,V.numPanes=1,V.arrPanes=[],V.numThumbsInPane=0,V.arrPanes.push(t-U.grid_padding);var d=e.length;for(i=0;i<d;i++){var _=jQuery(e[i]),g=_.outerWidth(),c=_.outerHeight();o-t+g>V.gridWidth&&(u++,r=0,u>=U.grid_num_rows?(u=0,t=o,l=0,r=n,1==V.numPanes&&(V.gridWidth=a+U.grid_padding,R.width(V.gridWidth)),V.numPanes++,V.arrPanes.push(t-U.grid_padding)):(o=t,r=l+U.grid_space_between_rows)),F.placeElement(_,o,r);var h=o+g;h>a&&(a=h);var p=r+c;p>l&&(l=p),p>s&&(s=p);var h=a+g;h>V.innerWidth&&(V.innerWidth=h),o+=g+U.grid_space_between_cols,1==V.numPanes&&V.numThumbsInPane++}
V.innerWidth=a,V.innerHeight=l,G.width(V.innerWidth),G.height(V.innerHeight),1==V.numPanes&&(V.gridWidth=a+U.grid_padding,V.gridHeight=s+U.grid_padding,R.width(V.gridWidth),R.height(V.gridHeight))}
function h(){0==V.isHorizontal?V.isNavigationVertical?g():_():c()}
function p(e){if(0>e||e>=V.numThumbs)throw new Error("Thumb not exists: "+e);return!0}
function f(e){if(e>=V.numPanes||0>e)throw new Error("Pane "+index+" doesn't exists.");return!0}
function m(e){var t=I(e);return 0==t?!1:void G.css(t)}
function v(e){var t=I(e);return 0==t?!1:void G.stop(!0).animate(t,{duration:U.grid_transition_duration,easing:U.grid_transition_easing,queue:!1})}
function b(){var e=-V.arrPanes[V.currentPane];v(e)}
function y(){return 1==V.isNavigationVertical?V.gridHeight:V.gridWidth}
function I(e){var t={};return 1==V.isNavigationVertical?t.top=e+"px":t.left=e+"px",t}
function w(){var e=F.getElementSize(G);return 1==V.isNavigationVertical?e.top:e.left}
function T(e){if(0==p(e))return-1;var t=Math.floor(e/V.numThumbsInPane);return t}
function E(){if(1==V.numPanes)return!1;var e=F.getStoredEventData(V.storedEventID),t=e.diffTime,i=w(),n=Math.abs(i-e.startInnerPos);return n>30?!0:n>5&&t>300?!0:!1}
function S(){var e=F.getStoredEventData(V.storedEventID),t=w();diffPos=Math.abs(e.startInnerPos-t);var i=y(),n=Math.round(3*i/8);return diffPos>=n?!0:e.diffTime<300&&diffPos>25?!0:!1}
function P(){if(1==V.numPanes)return!0;var e=F.isApproveStoredEventClick(V.storedEventID,V.isNavigationVertical);return e}
function x(e){if(1==E())return!0;var t=jQuery(this),i=B.getItemByThumb(t);W.selectItem(i)}
function j(e){if(1==V.numPanes)return!0;if(1==V.touchActive)return!0;0==V.isTilesMode&&e.preventDefault(),V.touchActive=!0;var t={startInnerPos:w()};F.storeEventData(e,V.storedEventID,t)}
function C(){if(0==U.grid_vertical_scroll_ondrag)return!1;if(1==V.isNavigationVertical)return!1;var e=F.handleScrollTop(V.storedEventID);return"vert"===e?!0:!1}
function A(e){if(0==V.touchActive)return!0;e.preventDefault(),F.updateStoredEventData(e,V.storedEventID);var t=F.getStoredEventData(V.storedEventID,V.isNavigationVertical),i=C();if(i)return!0;var n=t.diffMousePos,r=t.startInnerPos+n,o=n>0?"prev":"next",a=V.arrPanes[V.numPanes-1];0==U.grid_carousel&&r>0&&"prev"==o&&(r/=3),0==U.grid_carousel&&-a>r&&"next"==o&&(r=t.startInnerPos+n/3),m(r)}
function M(e){if(0==V.touchActive)return!0;F.updateStoredEventData(e,V.storedEventID);var t=F.getStoredEventData(V.storedEventID,V.isNavigationVertical);if(V.touchActive=!1,0==S())return b(),!0;var i=w(),n=i-t.startInnerPos,r=n>0?"prev":"next";"next"==r?0==U.grid_carousel&&Q.isLastPane()?b():Q.nextPane():0==U.grid_carousel&&Q.isFirstPane()?b():Q.prevPane()}
function z(){var e=W.getSelectedItem();B.setThumbSelected(e.objThumbWrapper),u(e.index)}
function O(){if(0==V.isTilesMode){B.initEvents();var e=R.find(".ug-thumb-wrapper");e.on("click touchend",x),L.on(W.events.ITEM_CHANGE,z)}else Y.initEvents();R.bind("mousedown touchstart",j),jQuery("body").bind("mousemove touchmove",A),jQuery(window).add("body").bind("mouseup touchend",M)}
var L,H,k,N,R,G,Q=this,D=jQuery(this),W=new UniteGalleryMain,F=new UGFunctions,B=new UGThumbsGeneral,Y=new UGTileDesign,U={grid_panes_direction:"left",grid_num_cols:2,grid_num_rows:2,grid_space_between_cols:10,grid_space_between_rows:10,grid_transition_duration:300,grid_transition_easing:"easeInOutQuad",grid_carousel:!1,grid_padding:0,grid_vertical_scroll_ondrag:!1};this.events={PANE_CHANGE:"pane_change"};var V={eventSizeChange:"thumb_size_change",isHorizontal:!1,isMaxHeight:!1,isMaxWidth:!1,gridHeight:0,gridWidth:0,innerWidth:0,innerHeight:0,numPanes:0,arrPanes:0,numThumbs:0,currentPane:0,numThumbsInPane:0,isNavigationVertical:!1,touchActive:!1,startScrollPos:0,isFirstTimeRun:!0,isTilesMode:!1,storedEventID:"thumbsgrid"};this.destroy=function(){if(0==V.isTilesMode){var e=R.find(".ug-thumb-wrapper");e.off("click"),e.off("touchend"),L.on(W.events.ITEM_CHANGE),B.destroy()}else Y.destroy();R.unbind("mousedown"),R.unbind("touchstart"),jQuery("body").unbind("mousemove"),jQuery("body").unbind("touchmove"),jQuery(window).add("body").unbind("touchend"),jQuery(window).add("body").unbind("mouseup"),D.off(Q.events.PANE_CHANGE)},this.__________EXTERNAL_GENERAL_________=function(){},this.setThumbUnselected=function(e){B.setThumbUnselected(e)},this.isItemThumbVisible=function(e){var t=e.index,i=T(t);return i==V.currentPane?!0:!1},this.__________EXTERNAL_API_________=function(){},this.getNumPanesEstimationByHeight=function(e){if(1==V.isTilesMode)var t=U.tile_height;else var i=B.getOptions(),t=i.thumb_height;var n=B.getNumThumbs(),r=Math.ceil(n/U.grid_num_cols),o=r*t+(r-1)*U.grid_space_between_rows,a=Math.ceil(o/e);return a},this.getNumPanesEstimationByWidth=function(e){if(V.isTilesMode)var t=U.tile_width;else var i=B.getOptions(),t=i.thumb_width;var n=B.getNumThumbs(),r=Math.ceil(n/U.grid_num_rows),o=r*t+(r-1)*U.grid_space_between_cols,a=Math.ceil(o/e);return a},this.getHeightEstimationByWidth=function(e){if(0==V.isTilesMode)throw new Error("This function works only with tiles mode");var t=B.getNumThumbs(),i=F.getNumItemsInSpace(e,U.tile_width,U.grid_space_between_cols),n=Math.ceil(t/i);n>U.grid_num_rows&&(n=U.grid_num_rows);var r=F.getSpaceByNumItems(n,U.tile_height,U.grid_space_between_rows);return r+=2*U.grid_padding},this.getElement=function(){return R},this.getSize=function(){var e=F.getElementSize(R);return e},this.getNumPanes=function(){return V.numPanes},this.isFirstPane=function(){return 0==V.currentPane?!0:!1},this.isLastPane=function(){return V.currentPane==V.numPanes-1?!0:!1},this.getPaneInfo=function(){var e={pane:V.currentPane,total:V.numPanes};return e},this.getPane=function(){return V.currentPane},this.setWidth=function(e){V.gridWidth=e,V.isHorizontal=!0},this.setMaxWidth=function(e){V.gridWidth=e,V.isMaxWidth=!0,V.isHorizontal=!0},this.setHeight=function(e){V.gridHeight=e,V.isHorizontal=!1},this.setMaxHeight=function(e){V.gridHeight=e,V.isMaxHeight=!0,V.isHorizontal=!1},this.gotoPane=function(e,t){if(0==f(e))return!1;if(e==V.currentPane)return!1;var i=-V.arrPanes[e];V.currentPane=e,v(i),D.trigger(Q.events.PANE_CHANGE,e)},this.nextPane=function(){var e=V.currentPane+1;if(e>=V.numPanes){if(0==U.grid_carousel)return!0;e=0}
Q.gotoPane(e,"next")},this.prevPane=function(){var e=V.currentPane-1;return 0>e&&(e=V.numPanes-1,0==U.grid_carousel)?!1:void Q.gotoPane(e,"prev")},this.attachNextPaneButton=function(e){return F.setButtonOnClick(e,Q.nextPane),1==U.grid_carousel?!0:(Q.isLastPane()&&e.addClass("ug-button-disabled"),void D.on(Q.events.PANE_CHANGE,function(){Q.isLastPane()?e.addClass("ug-button-disabled"):e.removeClass("ug-button-disabled")}))},this.attachPrevPaneButton=function(e){return F.setButtonOnClick(e,Q.prevPane),1==U.grid_carousel?!0:(Q.isFirstPane()&&e.addClass("ug-button-disabled"),void D.on(Q.events.PANE_CHANGE,function(){Q.isFirstPane()?e.addClass("ug-button-disabled"):e.removeClass("ug-button-disabled")}))},this.attachBullets=function(e){e.setActive(V.currentPane),jQuery(e).on(e.events.BULLET_CLICK,function(t,i){Q.gotoPane(i,"theme"),e.setActive(i)}),jQuery(Q).on(Q.events.PANE_CHANGE,function(t,i){e.setActive(i)})},this.getObjTileDesign=function(){return Y},this.init=function(t,i,n){e(t,i,n)},this.run=function(){r()},this.setHtml=function(e){t(e)}}
function UGTiles(){function e(e,i){g_objects=e.getObjects(),re=e,q=jQuery(e),K=g_objects.g_objWrapper,$=g_objects.g_arrItems,ue=jQuery.extend(ue,i),t(),ae.init(e,ue),se=ae.getObjThumbs()}
function t(){ue.tiles_min_columns<1&&(ue.tiles_min_columns=1),0!=ue.tiles_max_columns&&ue.tiles_max_columns<ue.tiles_min_columns&&(ue.tiles_max_columns=ue.tiles_min_columns)}
function i(e){if(!e)var e=K;J=e;var t=ue.tiles_type;e.addClass("ug-tiletype-"+t),ae.setHtml(e),e.children(".ug-thumb-wrapper").hide()}
function n(){if(J.addClass("ug-tiles-rest-mode"),de.isTransInited=!0,1==ue.tiles_enable_transition){J.addClass("ug-tiles-transit");var e=ae.getOptions();1==e.tile_enable_image_effect&&0==e.tile_image_effect_reverse&&J.addClass("ug-tiles-transit-overlays"),de.isTransActive=!0}}
function r(){return oe.getElementSize(J).width}
function o(){return 0==de.isTransInited?!1:(J.addClass("ug-tiles-transition-active"),J.removeClass("ug-tiles-rest-mode"),0==de.isTransActive?!1:void ae.disableEvents())}
function a(){return 0==de.isTransInited?!1:(J.removeClass("ug-tiles-transition-active"),void J.addClass("ug-tiles-rest-mode"))}
function s(){1==de.isTransActive?(setTimeout(function(){ae.enableEvents(),ae.triggerSizeChangeEventAllTiles(),a()},800),de.handle&&clearTimeout(de.handle),de.handle=setTimeout(function(){a(),ae.triggerSizeChangeEventAllTiles(),de.handle=null},2e3)):(ae.triggerSizeChangeEventAllTiles(),a())}
function l(){le.colWidth=(le.availWidth-le.colGap*(le.numCols-1))/le.numCols,le.colWidth=Math.floor(le.colWidth),le.totalWidth=oe.getSpaceByNumItems(le.numCols,le.colWidth,le.colGap)}
function u(){if(le.colWidth=ue.tiles_col_width,le.minCols=ue.tiles_min_columns,0==re.isMobileMode()?le.colGap=ue.tiles_space_between_cols:le.colGap=ue.tiles_space_between_cols_mobile,le.galleryWidth=r(),le.availWidth=le.galleryWidth,1==ue.tiles_include_padding&&(le.availWidth=le.galleryWidth-2*le.colGap),1==ue.tiles_exact_width)le.numCols=oe.getNumItemsInSpace(le.availWidth,le.colWidth,le.colGap),le.maxCols>0&&le.numCols>le.maxCols&&(le.numCols=le.maxCols),le.numCols<le.minCols?(le.numCols=le.minCols,l()):le.totalWidth=le.numCols*(le.colWidth+le.colGap)-le.colGap;else{var e=oe.getNumItemsInSpaceRound(le.availWidth,le.colWidth,le.colGap);e<le.minCols?e=le.minCols:0!=le.maxCols&&e>le.maxCols&&(e=le.maxCols),le.numCols=e,l()}
switch(ue.tiles_align){case"center":default:le.addX=Math.round((le.galleryWidth-le.totalWidth)/2);break;case"left":le.addX=0;break;case"right":le.addX=le.galleryWidth-le.totalWidth}
for(le.maxColHeight=0,le.arrPosx=[],col=0;col<le.numCols;col++){var t=oe.getColX(col,le.colWidth,le.colGap);le.arrPosx[col]=t+le.addX}
le.colHeights=[0]}
function d(){var e=0,t=999999999;for(col=0;col<le.numCols;col++){if(void 0==le.colHeights[col]||0==le.colHeights[col])return col;le.colHeights[col]<t&&(e=col,t=le.colHeights[col])}
return e}
function _(e,t,i,n){if(null===n||"undefined"==typeof n)var n=d();var r=0;void 0!==le.colHeights[n]&&(r=le.colHeights[n]);var o=ae.getTileHeightByWidth(le.colWidth,e);if(null===o){if(1==ue.tiles_enable_transition)throw new Error("Can't know tile height, please turn off transition");var a=oe.getElementSize(e);o=a.height}
var s=le.arrPosx[n];oe.placeElement(e,s,r);var l=r+o;le.colHeights[n]=l+le.colGap,le.maxColHeight<l&&(le.maxColHeight=l),1==t&&e.show().fadeTo(0,1),1==i&&J.height(le.maxColHeight)}
function g(e){e||(e=!1),u();var t=se.getThumbs();o(),ae.resizeAllTiles(le.colWidth,ae.resizemode.VISIBLE_ELEMENTS);for(var i=0;i<t.length;i++){var n=jQuery(t[i]),r=void 0;1==ue.tiles_keep_order&&(r=oe.getColByIndex(le.numCols,i)),_(n,e,!1,r)}
s();var a=J.height();1==de.isTransActive&&a>le.maxColHeight?setTimeout(function(){J.height(le.maxColHeight)},700):J.height(le.maxColHeight)}
function c(e){var t=e.index(),i=re.getItem(t);if(i.ordered_placed===!0)return!1;var n=oe.getPrevRowSameColIndex(t,le.numCols);if(0>n)return!0;var r=re.getItem(n);return r.ordered_placed===!0?!0:!1}
function h(e,t){if(t!==!0){var i=c(e);if(0==i)return!1}
var n=e.index(),r=oe.getColByIndex(le.numCols,n),o=re.getItem(n);ae.resizeTile(e,le.colWidth),_(e,!0,!0,r),o.ordered_placed=!0;var a=re.getNumItems(),s=oe.getNextRowSameColIndex(n,le.numCols);if(s>=a)return!1;var l=se.getThumbByIndex(s),u=re.getItem(s);se.isThumbLoaded(l);se.isThumbLoaded(l)&&!u.ordered_placed&&h(l,!0)}
function p(e,t){if(1==t)return!1;e=jQuery(e);var i=jQuery(e).parent();se.triggerImageLoadedEvent(i,e),1==ue.tiles_keep_order?h(i):(ae.resizeTile(i,le.colWidth),_(i,!0,!0))}
function f(){var e=se.getThumbs();u();var t=Math.abs(le.galleryWidth-le.totalWidth);if(1==ue.tiles_set_initial_height&&0==oe.isScrollbarExists()&&25>t){var i=(e.length,Math.ceil(e.length/le.numCols)),r=i*ue.tiles_col_width*.75;J.height(r),u()}
e.fadeTo(0,0);var o=jQuery(J).find("img.ug-thumb-image");if(1==de.isFixedMode)ne.trigger(ie.events.TILES_FIRST_PLACED),g(!0),oe.checkImagesLoaded(o,function(){n()});else{var a=le.numCols,s=le.galleryWidth,l=!1;oe.checkImagesLoaded(o,function(){u(),(a!=le.numCols||s!=le.galleryWidth)&&g(!1),n()},function(e,t){0==l&&ne.trigger(ie.events.TILES_FIRST_PLACED),l=!0,p(e,t)})}}
function m(){var e=r(),t=se.getThumbs(),i=ue.tiles_justified_row_height,n=[],o=0,a=ue.tiles_justified_space_between,s=t.length;jQuery.each(t,function(e,t){t=jQuery(t);var r=se.getItemByThumb(t),a=r.thumbWidth,s=r.thumbHeight;s!==i&&(a=Math.floor(r.thumbRatioByWidth*i)),n[e]=a,o+=a});var l=Math.ceil(o/e);l>s&&(l=s);var u=o/l,d=[],_=0,g=[],c=[],h=0,p=0;jQuery.each(t,function(e,t){var i=n[e];h+i/2>(p+1)*u&&(g[d.length]=_,d.push(c),c=[],_=0,p++),h+=i,_+=i,c.push(t)}),g[d.length]=_,d.push(c);var f=[],m=[],v=0;jQuery.each(d,function(t,r){var o=(r.length,g[t]),s=(r.length-1)*a,l=(e-s)/o,u=Math.round(i*l);v+=u,t>0&&(v+=a),m.push(u);var d=u/i,_=[],c=s;jQuery.each(r,function(e,t){var i=jQuery(t),r=i.index(),o=n[r],a=Math.round(o*d);_[e]=a,c+=a});var h=c-e;jQuery.each(_,function(e,t){return 0==h?!1:(0>h?(_[e]=t+1,h++):(_[e]=t-1,h--),void(e==_.length-1&&0!=h&&(_[e]-=h)))}),f[t]=_});var b={arrRows:d,arrRowWidths:f,arrRowHeights:m,gap:a,totalHeight:v};return b}
function v(e){if(!e)var e=!1;var t=r(),i=m();J.height(i.totalHeight);var n=r();n!=t&&(i=m()),o();var a=0,l=0;jQuery.each(i.arrRows,function(t,n){var r=i.arrRowWidths[t],o=i.arrRowHeights[t],s=0;jQuery.each(n,function(t,n){var u=jQuery(n),d=o,_=r[t];ae.resizeTile(u,_,d,ae.resizemode.VISIBLE_ELEMENTS),oe.placeElement(u,s,a),s+=_,s>l&&(l=s),s+=i.gap,1==e&&jQuery(n).show()}),a+=o+i.gap}),s()}
function b(){var e=jQuery(K).find("img.ug-thumb-image"),t=se.getThumbs();t.fadeTo(0,0),oe.checkImagesLoaded(e,function(){setTimeout(function(){v(!0),t.fadeTo(0,1),ne.trigger(ie.events.TILES_FIRST_PLACED),n()})},function(e,t){e=jQuery(e);var i=jQuery(e).parent();se.triggerImageLoadedEvent(i,e)})}
function y(){var e=jQuery(K).find("img.ug-thumb-image"),t=se.getThumbs();t.fadeTo(0,0),oe.checkImagesLoaded(e,function(){w(!0),ne.trigger(ie.events.TILES_FIRST_PLACED),n()},function(e,t){e=jQuery(e);var i=jQuery(e).parent();se.triggerImageLoadedEvent(i,e)})}
function I(){var e=r();_e.galleryWidth=e,ee={},_e.colWidth=ue.tiles_nested_col_width,_e.optimalTileWidth=ue.tiles_nested_optimal_tile_width,_e.currentGap=ue.tiles_space_between_cols,1==re.isMobileMode()&&(_e.currentGap=ue.tiles_space_between_cols_mobile),null==_e.colWidth?_e.colWidth=Math.floor(_e.optimalTileWidth/_e.nestedOptimalCols):_e.optimalTileWidth>_e.colWidth?_e.nestedOptimalCols=Math.ceil(_e.optimalTileWidth/_e.colWidth):_e.nestedOptimalCols=1,_e.maxColumns=oe.getNumItemsInSpace(e,_e.colWidth,_e.currentGap),_e.colWidth=oe.getItemSizeInSpace(e,_e.maxColumns,_e.currentGap),_e.gridY=0,te=[];var t=se.getThumbs();switch(t.each(function(){var e=jQuery(this),t=T(e);te.push(t)}),_e.optimalTileWidth>_e.colWidth?_e.nestedOptimalCols=Math.ceil(_e.optimalTileWidth/_e.colWidth):_e.nestedOptimalCols=1,_e.totalWidth=_e.maxColumns*(_e.colWidth+_e.currentGap)-_e.currentGap,ue.tiles_align){case"center":default:_e.addX=Math.round((_e.galleryWidth-_e.totalWidth)/2);break;case"left":_e.addX=0;break;case"right":_e.addX=_e.galleryWidth-_e.totalWidth}
_e.maxGridY=0}
function w(e){var t=r();I(),P();var i=_e.maxGridY*(_e.colWidth+_e.currentGap)-_e.currentGap;J.height(i);var n=r();n!=t&&(I(),P()),0==ue.tiles_nested_debug&&Y(e)}
function T(e){var t,i,n={},r=_e.colWidth,o=_e.currentGap,a=ae.getTileImageSize(e),s=e.index(),l=Math.ceil(E(s)*(1*_e.nestedOptimalCols/3)+2*_e.nestedOptimalCols/3),u=a.width,d=a.height,_=u/d;return u>d?(t=l,i=Math.round(t/_),0==i&&(i=1)):(i=l,t=Math.round(i*_),0==t&&(t=1)),n.dimWidth=t,n.dimHeight=i,n.width=t*r+o*(t-1),n.height=i*r+o*(i-1),n.imgWidth=u,n.imgHeight=d,n.left=0,n.top=0,n}
function E(e){return Math.abs(Math.sin(Math.abs(1e3*Math.sin(e))))}
function S(e,t){if(0==t){for(var i=_e.currentItem;i<te.length;i++)x(i,!0);_e.currentItem=te.length-1}else x(_e.currentItem,!0);for(var i=0;i<=_e.currentItem;i++)U(i,!0);_e.currentItem++}
function P(e){if(1==ue.tiles_nested_debug)return"undefined"==typeof e&&(e=!0),S(!0,e),!1;for(var t=0;t<te.length;t++)x(t,!0)}
function x(e,t){if(!t)var t=!1;_e.maxColHeight=0;for(var i=oe.getObjectLength(ee),n=_e.gridY;i+1>=n;n++){for(var r=0;r<_e.maxColumns;r++)
if(0==Q(_e.gridY)||0==F(_e.gridY,r)){var o=G(r);return void j(e,o,r)}
_e.gridY++}}
function j(e,t,i){var n=jQuery.extend(!0,{},te[e]),r=n.dimWidth,o=t-n.dimWidth,a=_e.nestedOptimalCols,s=t<=n.dimWidth||.33*a>=o||a>=t;if(s)H(e,t);else if(a>=o)a>=4?1==R(Math.floor(t/2),i)?H(e,Math.floor(t/2)+1):H(e,Math.floor(t/2)):H(objImage,t);else if(1==R(r,i))switch(r>=a){case!0:H(e,r-1);break;case!1:H(e,r+1)}
n=jQuery.extend(!0,{},te[e]);var l=O(e,n.dimWidth,i);if(_e.columnsValueToEnableHeightResize<=l[0]&&_e.maxColumns>=2*_e.nestedOptimalCols){var u=L(i,n),d=k(e,u.newHeight,!0);te[e].dimHeight=d.dimHeight;var _=z(l,d.dimWidth,i),g=C(_),c=!1;g>=2&&(c=!0),u.newHeight>=n.dimHeight&&(n=k(e,u.newHeight,!0));var h=A(u.idToResize,u.newHeight,n.dimHeight);n.top=_e.gridY,n.left=i,h.push({tileID:e,sizes:n});var p=N(h),f=N(_);return f>p||1==c?void M(h):void M(_)}
n.left=i,n.top=_e.gridY,te[e]=n,D(e,n,i,_e.gridY),_e.maxGridY=n.top+n.dimHeight}
function C(e){for(var t=0,i=0,n=0;n<e.length-1;n++){var r=e[n].sizes,o=-1,a=-1;Q(r.top+r.dimHeight)&&_e.maxColumns>r.left+r.dimWidth&&(o=ee[r.top+r.dimHeight-1][r.left+r.dimWidth],a=ee[r.top+r.dimHeight][r.left+r.dimWidth]),o!=a&&t++}
for(var n=0;n<e.length-1;n++){var r=e[n].sizes,o=-1,a=-1;Q(r.top+r.dimHeight)&&r.left-1>=0&&(o=ee[r.top+r.dimHeight-1][r.left-1],a=ee[r.top+r.dimHeight][r.left-1]),o!=a&&i++}
return Math.max(i,t)}
function A(e,t,i){var n=te[e],r=n.dimHeight,o=(n.dimWidth,n.left),a=n.top,s=(parseInt(a/(_e.colWidth+_e.currentGap)),parseInt(o/(_e.colWidth+_e.currentGap)),r-t+i),l=k(e,s,!0),u=[];return u.push({tileID:e,sizes:l}),u}
function M(e){for(var t=0;t<e.length;t++){var i=e[t].sizes,n=e[t].tileID;te[n]=jQuery.extend(!0,{},i),D(n,i,i.left,i.top)}}
function z(e,t){for(var i=0,n=0,r=[],o=0,a=0,s=0;s<e[1].length;s++){var l=e[1][s],u=te[e[1][s]];if(n+=u.dimHeight,0!=s)i+=u.dimHeight,r.push([l,u.dimHeight]);else{var d=H(l,t,!0);i+=d.dimHeight,r.push([e[1][s],d.dimHeight])}}
o=u.left,a=u.top;for(var _=n,g=[],s=r.length-1;s>=0;s--){var c,l=r[s][0];0!=s?(c=Math.max(Math.round(1*n/3),Math.floor(r[s][1]*(n/i))),_-=c,d=k(l,c,!0),d.left=o,d.top=a,g.push({tileID:l,sizes:d}),a+=d.dimHeight):(c=_,d=k(l,c,!0),d.left=o,d.top=a,g.push({tileID:l,sizes:d}))}
return g}
function O(e,t,i){var n=_e.gridY-1,r=0,o=0,a=1,s=[],l=[];if(s.push(e),n>=0){for(o=0;n>=0;){if(r=ee[n][i],"undefined"!=typeof ee[n][i-1]&&ee[n][i-1]==ee[n][i]||"undefined"!=typeof ee[n][i+t]&&ee[n][i+t-1]==ee[n][i+t]||ee[n][i]!=ee[n][i+t-1])return l.push(a),l.push(s),l;o!=r&&(a++,s.push(r)),n--,o=r}
return l.push(a),l.push(s),l}
return[0,[]]}
function L(e,t){var i=0,n=0,r=t.dimWidth,o=t.dimHeight,a=0,s=0,l=jQuery.map(ee,function(e,t){return[e]});if("undefined"==typeof l[_e.gridY]||"undefined"==typeof l[_e.gridY][e-1])n=0;else
for(var u=0;;){if("undefined"==typeof ee[_e.gridY+u]||-1==ee[_e.gridY+u][e-1])break;a=ee[_e.gridY+u][e-2],u++,n++}
if("undefined"==typeof l[_e.gridY]||"undefined"==typeof l[_e.gridY][e+r])i=0;else
for(u=0;;){if("undefined"==typeof ee[_e.gridY+u]||-1==ee[_e.gridY+u][e+r])break;s=ee[_e.gridY+u][e+r+1],u++,i++}
var d=0,_=0;Math.abs(o-n)<Math.abs(o-i)&&0!=n?(d=n,_=a):0!=i?(d=i,_=s):d=o;var g={newHeight:d,idToResize:_};return g}
function H(e,t,i){i||(i=!1);var n=_e.colWidth,r=_e.currentGap,o=te[e],a=o.imgWidth,s=o.imgHeight,l=a/s;if(dimWidth=t,dimHeight=Math.round(dimWidth/l),1==i){var u=jQuery.extend(!0,{},o);return u.dimWidth=dimWidth,u.dimHeight=dimHeight,u.width=dimWidth*n+r*(dimWidth-1),u.height=dimHeight*n+r*(dimHeight-1),u}
o.dimWidth=dimWidth,o.dimHeight=dimHeight,o.width=dimWidth*n+r*(dimWidth-1),o.height=dimHeight*n+r*(dimHeight-1)}
function k(e,t,i){i||(i=!1);var n=te[e],r=n.dimWidth,o=_e.colWidth,a=_e.currentGap;if(1==i){var s=jQuery.extend(!0,{},n);return s.dimHeight=t,s.width=r*o+a*(r-1),s.height=t*o+a*(t-1),s}
n.dimHeight=t,n.width=r*o+a*(r-1),n.height=t*o+a*(t-1)}
function N(e){for(var t=0,i=0,n=0;n<e.length;n++){var r=te[e[n].tileID];if(0==r.dimHeight||0==r.height)return;resizeVal=r.dimWidth/r.dimHeight/(r.imgWidth/r.imgHeight),resizeVal<1&&(resizeVal=1/resizeVal),t+=resizeVal,i++}
return t/i}
function R(e,t){var i=_e.gridY-1;return 0>=i||0==Q(i)?!1:ee[i][t+e-1]!=ee[i][t+e]?!0:!1}
function G(e){var t=e,i=0;if(1==Q(_e.gridY))
for(;0==F(_e.gridY,t);)i++,t++;else i=_e.maxColumns;return i}
function Q(e){return"undefined"==typeof ee[e]?!1:!0}
function D(e,t,i,n){for(var r=0;r<t.dimHeight;r++)
for(var o=0;o<t.dimWidth;o++)0==Q(n+r)&&W(n+r),B(n+r,i+o,e)}
function W(e){ee[e]=new Object;for(var t=0;t<_e.maxColumns;t++)ee[e][t]=-1}
function F(e,t){return-1!=ee[e][t]}
function B(e,t,i){ee[e][t]=i}
function Y(e){if(!e)var e=!1;o();for(var t=0;t<te.length;t++)U(t,e);J.height(_e.maxColHeight),s()}
function U(e,t){var i=se.getThumbByIndex(e),n=te[e],r=n.top*(_e.colWidth+_e.currentGap),o=_e.addX+n.left*(_e.colWidth+_e.currentGap);ae.resizeTile(i,n.width,n.height,ae.resizemode.VISIBLE_ELEMENTS),oe.placeElement(i,o,r),r+n.height>_e.maxColHeight&&(_e.maxColHeight=r+n.height),1==t&&i.fadeTo(0,1)}
function V(){if(1==de.isFirstTimeRun)return!0;switch(ue.tiles_type){case"columns":g(!1);break;case"justified":v(!1);break;case"nested":var e=re.isMobileMode();1==e?g(!1):w(!1)}}
function X(){q.on(re.events.SIZE_CHANGE,V),ae.initEvents()}
function Z(){switch(K.children(".ug-tile").show(),1==de.isFirstTimeRun&&X(),ae.run(),ue.tiles_type){default:case"columns":f();break;case"justified":b();break;case"nested":y()}
de.isFirstTimeRun=!1}
var q,K,J,$,ee,te,ie=this,ne=jQuery(this),re=new UniteGalleryMain,oe=new UGFunctions,ae=new UGTileDesign,se=new UGThumbsGeneral,le={},ue={tiles_type:"columns",tiles_col_width:250,tiles_align:"center",tiles_exact_width:!1,tiles_space_between_cols:3,tiles_space_between_cols_mobile:3,tiles_include_padding:!0,tiles_min_columns:2,tiles_max_columns:0,tiles_keep_order:!1,tiles_set_initial_height:!0,tiles_justified_row_height:150,tiles_justified_space_between:3,tiles_nested_optimal_tile_width:250,tiles_nested_col_width:null,tiles_nested_debug:!1,tiles_enable_transition:!0};this.events={THUMB_SIZE_CHANGE:"thumb_size_change",TILES_FIRST_PLACED:"tiles_first_placed"};var de={isFixedMode:!1,isFirstTimeRun:!0,handle:null,isTransActive:!1,isTransInited:!1},_e={colWidth:null,nestedOptimalCols:5,gridY:0,maxColumns:0,columnsValueToEnableHeightResize:3,resizeLeftRightToColumn:!0,currentItem:0,currentGap:null,optimalTileWidth:null,maxGridY:0};this.destroy=function(){q.off(re.events.SIZE_CHANGE),ae.destroy()},this.setFixedSizeMode=function(){de.isFixedMode=!0,ae.setFixedMode()},this.init=function(t,i){e(t,i)},this.setHtml=function(e){i(e)},this.getObjTileDesign=function(){return ae},this.run=function(){Z()}}
function UGTileDesign(){function e(e,n){R=e,z=jQuery(e);var r=R.getObjects();L=r.g_objWrapper,H=R.getArrItems(),D=jQuery.extend(D,W),D=jQuery.extend(D,n),t(),Q.init(e,D);var o={allow_onresize:!1},a=["overlay"];F.funcCustomTileHtml&&(a=[]),Q.setCustomThumbs(i,a,o);var s=Q.getOptions();D=jQuery.extend(D,s),F.ratioByWidth=D.tile_width/D.tile_height,F.ratioByHeight=D.tile_height/D.tile_width,D.tile_size_by==k.sizeby.GLOBAL_RATIO&&F.isTextpanelOutside&&(F.hasImageContainer=!0)}
function t(){if(1==D.tile_enable_overlay?(D.thumb_overlay_opacity=D.tile_overlay_opacity,D.thumb_overlay_color=D.tile_overlay_color):0==D.tile_enable_icons?D.thumb_color_overlay_effect=!1:D.thumb_overlay_opacity=0,D.tile_as_link&&(D.thumb_wrapper_as_link=!0,D.thumb_link_newpage=D.tile_link_newpage),1==D.tile_enable_outline&&0==D.tile_enable_border&&(D.tile_enable_outline=!1),F.tileInnerReduce=0,D.tile_enable_border&&(F.tileInnerReduce=2*D.tile_border_width,Q.setThumbInnerReduce(F.tileInnerReduce)),F.isSaparateIcons=!G.isRgbaSupported(),1==D.tile_enable_textpanel){switch(D.tile_textpanel_position){case"top":D.tile_textpanel_align="top";case"bottom":F.isTextpanelOutside=!0,D.tile_textpanel_always_on=!0,D.tile_textpanel_offset=0;break;case"inside_top":D.tile_textpanel_align="top";break;case"middle":D.tile_textpanel_align="middle",D.tile_textpanel_appear_type="fade"}
0==D.tile_textpanel_always_on&&(F.isSaparateIcons=!0)}
0!=D.tile_textpanel_offset&&(D.tile_textpanel_appear_type="fade",D.tile_textpanel_margin=D.tile_textpanel_offset),"title_and_desc"==D.tile_textpanel_source&&(D.tile_textpanel_enable_description=!0,D.tile_textpanel_desc_style_as_title=!0)}
function i(e,t){if(e.addClass("ug-tile"),F.funcCustomTileHtml)return F.funcCustomTileHtml(e,t),!1;var i="";1==F.hasImageContainer&&(i+="<div class='ug-image-container ug-trans-enabled'>");var n="ug-thumb-image";(0==D.tile_enable_image_effect||1==D.tile_image_effect_reverse)&&(n+=" ug-trans-enabled");var r=G.stripTags(t.title);r=G.htmlentitles(r),i+="<img src='"+t.urlThumb+"' alt='"+r+"' class='"+n+"'>",1==F.hasImageContainer&&(i+="</div>"),e.append(i),D.tile_size_by==k.sizeby.GLOBAL_RATIO&&e.fadeTo(0,0);var o={};if(1==D.tile_enable_background&&(o["background-color"]=D.tile_background_color),1==D.tile_enable_border&&(o["border-width"]=D.tile_border_width+"px",o["border-style"]="solid",o["border-color"]=D.tile_border_color,D.tile_border_radius&&(o["border-radius"]=D.tile_border_radius+"px")),1==D.tile_enable_outline&&(o.outline="1px solid "+D.tile_outline_color),1==D.tile_enable_shadow){var a=D.tile_shadow_h+"px ";a+=D.tile_shadow_v+"px ",a+=D.tile_shadow_blur+"px ",a+=D.tile_shadow_spread+"px ",a+=D.tile_shadow_color,o["box-shadow"]=a}
e.css(o);var s="";if(D.tile_enable_icons){if(0==D.tile_as_link&&1==D.tile_enable_action){var l="ug-button-play ug-icon-zoom";"image"!=t.type&&(l="ug-button-play ug-icon-play"),s+="<div class='ug-tile-icon "+l+"' style='display:none'></div>"}
if(t.link&&1==D.tile_show_link_icon||1==D.tile_as_link)
if(0==D.tile_as_link){var d="";1==D.tile_link_newpage&&(d=" target='_blank'"),s+="<a href='"+t.link+"'"+d+" class='ug-tile-icon ug-icon-link'></a>"}else s+="<div class='ug-tile-icon ug-icon-link' style='display:none'></div>";var _=F.isSaparateIcons;if(0==_&&"image"!=t.type&&1==D.tile_videoplay_icon_always_on&&(_=!0),_)var g=e;else var g=e.children(".ug-thumb-overlay");g.append(s);var c=g.children("."+l);0==c.length?c=null:c.hide();var h=g.children(".ug-icon-link");0==h.length?h=null:h.hide(),h||1!=D.tile_enable_action||e.addClass("ug-tile-clickable")}else 1==D.tile_enable_action&&e.addClass("ug-tile-clickable");if(1==D.tile_enable_image_effect){var p="";0==D.tile_image_effect_reverse&&(p=" ug-trans-enabled");var f="<div class='ug-tile-image-overlay"+p+"' >",m=" ug-"+D.tile_image_effect_type+"-effect";f+="<img src='"+t.urlThumb+"' alt='"+t.title+"' class='"+m+p+"'>",f+="</div>",e.append(f),1==D.tile_image_effect_reverse&&e.children(".ug-tile-image-overlay").fadeTo(0,0)}
if(1==D.tile_enable_textpanel){var v=new UGTextPanel;v.init(R,D,"tile");var b="";(1==D.tile_textpanel_always_on||1==F.isTextpanelOutside)&&(b="ug-trans-enabled"),v.appendHTML(e,b);var y=t.title,I="";switch(D.tile_textpanel_source){case"desc":case"description":y=t.description;break;case"desc_title":""!=t.description&&(y=t.description);break;case"title_and_desc":y=t.title,I=t.description}
if(v.setTextPlain(y,I),0==D.tile_textpanel_always_on&&v.getElement().fadeTo(0,0),e.data("objTextPanel",v),1==D.tile_textpanel_always_on){var w=u(e);w.css("z-index",2)}
if(1==F.isTextpanelOutside){var T="<div class='ug-tile-cloneswrapper'></div>";e.append(T);var E=e.children(".ug-tile-cloneswrapper"),S=new UGTextPanel;S.init(R,D,"tile"),S.appendHTML(E),S.setTextPlain(y,I),e.data("objTextPanelClone",S)}}
null!==t.addHtml&&e.append(t.addHtml)}
function n(e){var t=e.children(".ug-tile-image-overlay");return t}
function r(e){var t=e.children(".ug-thumb-overlay");return t}
function o(e){if(0==F.hasImageContainer)return null;var t=e.children(".ug-image-container");return t}
function a(e){var t=e.find(".ug-tile-image-overlay img");return t}
function s(e){var t=e.data("objTextPanel");return t}
function l(e){var t=e.data("objTextPanelClone");return t}
function u(e){var t=e.children(".ug-textpanel");return t}
function d(e){var t=e.find(".ug-tile-cloneswrapper .ug-textpanel");if(0==t.length)throw new Error("text panel cloned element not found");return t}
function _(e){if(1==F.isTextpanelOutside)var t=d(e);else var t=u(e);if(!t)return 0;var i=G.getElementSize(t);return i.height}
function g(e){var t=e.find(".ug-icon-link");return 0==t.length?null:t}
function c(e){var t=F.ratioByHeight;switch(D.tile_size_by){default:t=F.ratioByHeight;break;case k.sizeby.IMAGE_RATIO:if(!e)throw new Error("tile should be given for tile ratio");var i=k.getItemByTile(e);if("undefined"!=typeof i.thumbRatioByHeight){if(0==i.thumbRatioByHeight)throw trace(i),new Error("the item ratio not inited yet");t=i.thumbRatioByHeight}
break;case k.sizeby.CUSTOM:return null}
return t}
function h(e){var t=e.find(".ug-button-play");return 0==t.length?null:t}
function p(e){return e.hasClass("ug-thumb-over")?!0:!1}
function f(e){return e.hasClass("ug-tile-clickable")}
function m(e,t,i,r){var s=n(e),l=k.getTileImage(e),u=a(e);t-=F.tileInnerReduce,i-=F.tileInnerReduce;var d=null;if(1==F.isTextpanelOutside){var g=_(e);if(i-=g,"top"==D.tile_textpanel_position&&(d=g),1==F.hasImageContainer){var c=o(e);G.setElementSize(c,t,i),null!==d&&G.placeElement(c,0,d)}}
if(0==D.tile_enable_image_effect)G.scaleImageCoverParent(l,t,i),0==F.hasImageContainer&&null!==d&&G.placeElement(l,0,d);else{var h="nothing";r===!0&&0==F.isTextpanelOutside&&(h=1==D.tile_image_effect_reverse?"effect":"image"),"effect"!=h&&(G.setElementSize(s,t,i),null!==d&&G.placeElement(s,0,d),G.scaleImageCoverParent(u,t,i)),"image"!=h&&(1==F.hasImageContainer?G.scaleImageCoverParent(l,t,i):"effect"==h?(G.scaleImageCoverParent(l,t,i),null!==d&&G.placeElement(l,0,d)):G.cloneElementSizeAndPos(u,l,!1,null,d))}}
function v(e,t,i,n){var r=null;if(i&&(r=i-F.tileInnerReduce),n&&(n-=F.tileInnerReduce),"clone"==t){var o=l(e);o.refresh(!0,!0,r);var a=k.getItemByTile(e);return a.textPanelCloneSizeSet=!0,!1}
var u=s(e);if(!u)return!1;var d=null;1==F.isTextpanelOutside&&(d=_(e)),u.refresh(!1,!0,r,d);var g=1==D.tile_textpanel_always_on||"fade"==D.tile_textpanel_appear_type;if(g)
if(1==F.isTextpanelOutside&&n&&"bottom"==D.tile_textpanel_position){var c=n-d;u.positionPanel(c)}else u.positionPanel()}
function b(e){var t=(k.getItemByTile(e),h(e)),i=g(e),n=G.getElementSize(e);m(e,n.width,n.height),1==D.tile_enable_textpanel&&v(e,"regular",n.width,n.height);var o=n.width-F.tileInnerReduce,a=n.height-F.tileInnerReduce,s=0;if(1==F.isTextpanelOutside){var l=_(e);a-=l,"top"==D.tile_textpanel_position&&(s=l)}
var d=r(e);if(G.setElementSizeAndPosition(d,0,s,o,a),t||i){var c=0;if(1==D.tile_enable_textpanel&&0==F.isTextpanelOutside){var p=u(e),f=G.getElementSize(p);f.height>0&&(c=Math.floor(f.height/2*-1))}}
if(t&&i){var b=G.getElementSize(t),y=G.getElementSize(i),I=D.tile_space_between_icons,w=b.width+I+y.width,T=Math.floor((n.width-w)/2);I>T&&(I=Math.floor((n.width-b.width-y.width)/3),w=b.width+I+y.width,T=Math.floor((n.width-w)/2)),G.placeElement(t,T,"middle",0,c),G.placeElement(i,T+b.width+I,"middle",0,c)}else t&&G.placeElement(t,"center","middle",0,c),i&&G.placeElement(i,"center","middle",0,c);t&&t.show(),i&&i.show()}
function y(e,t){var i=(k.getItemByTile(e),n(e)),r=D.thumb_transition_duration;if(0==D.tile_image_effect_reverse){var o=k.getTileImage(e);t?(o.fadeTo(1,1),i.stop(!0).fadeTo(r,0)):i.stop(!0).fadeTo(r,1)}else t?i.stop(!0).fadeTo(r,1):i.stop(!0).fadeTo(r,0)}
function I(e,t){var i=D.thumb_transition_duration,n=u(e);if(!n)return!0;if("slide"==D.tile_textpanel_appear_type){var r=G.getElementSize(n);if(0==r.width)return!1;var o=-r.height,a=0,s={},l={},d="bottom";"inside_top"==D.tile_textpanel_position&&(d="top"),s[d]=o+"px",l[d]=a+"px",1==t?(n.fadeTo(0,1),0==n.is(":animated")&&n.css(s),n.stop(!0).animate(l,i)):n.stop(!0).animate(s,i)}else 1==t?n.stop(!0).fadeTo(i,1):n.stop(!0).fadeTo(i,0)}
function w(e,t,i){var n=D.thumb_transition_duration;i&&i===!0&&(n=0);var r=h(e),o=g(e),a=t?1:0;r&&r.stop(!0).fadeTo(n,a),o&&o.stop(!0).fadeTo(n,a)}
function T(e,t){if(t=jQuery(t),D.tile_enable_image_effect&&y(t,!0),1==D.tile_enable_textpanel&&0==D.tile_textpanel_always_on&&I(t,!0),F.isSaparateIcons&&1==D.tile_enable_icons){var i=1==D.thumb_overlay_reverse,n=k.getItemByTile(t);(1!=D.tile_videoplay_icon_always_on||"image"==n.type)&&w(t,i,!1)}}
function E(e,t){if(t=jQuery(t),D.tile_enable_image_effect&&y(t,!1),1==D.tile_enable_textpanel&&0==D.tile_textpanel_always_on&&I(t,!1),1==F.isSaparateIcons&&1==D.tile_enable_icons){var i=1==D.thumb_overlay_reverse?!1:!0;w(t,i,!1)}}
function S(e){var t=Q.getThumbs().not(e);t.each(function(e,t){Q.setThumbNormalStyle(jQuery(t))})}
function P(e,t,i){return t=jQuery(t),1==D.tile_visible_before_image&&t.data("image_placed")!==!0&&i!==!0?!0:void b(t)}
function x(e,t,i){b(t),i.fadeTo(0,1),t.data("image_placed",!0)}
function j(e){return 1==f(e)?(N.trigger(k.events.TILE_CLICK,e),!0):void(0==p(e)&&(S(e),Q.setThumbOverStyle(e)))}
function C(e){var t=jQuery(this),i=t.prop("tagName").toLowerCase(),n=!0;if(F.funcParentApproveClick&&0==F.funcParentApproveClick()&&(n=!1),"a"==i)0==n&&e.preventDefault();else if(0==p(t))1==n&&j(t);else{if(0==f(t))return!0;1==n&&N.trigger(k.events.TILE_CLICK,t)}}
function A(e){e.stopPropagation();var t=jQuery(this).parents(".ug-tile"),i=!0;return F.funcParentApproveClick&&0==F.funcParentApproveClick()&&(i=!1),0==p(t)?(j(t),!0):1==i?(N.trigger(k.events.TILE_CLICK,t),!1):void 0}
function M(e){var t=jQuery(this).parents(".ug-tile");F.funcParentApproveClick&&0==F.funcParentApproveClick()&&e.preventDefault(),0==p(t)&&0==D.tile_as_link&&(e.preventDefault(),j(t))}
var z,O,L,H,k=this,N=jQuery(this),R=new UniteGalleryMain,G=new UGFunctions,Q=new UGThumbsGeneral;this.resizemode={FULL:"full",WRAPPER_ONLY:"wrapper_only",VISIBLE_ELEMENTS:"visible_elements"},this.sizeby={GLOBAL_RATIO:"global_ratio",TILE_RATIO:"tile_ratio",IMAGE_RATIO:"image_ratio",CUSTOM:"custom"},this.events={TILE_CLICK:"tile_click"};var D={tile_width:250,tile_height:200,tile_size_by:k.sizeby.IMAGE_RATIO,tile_visible_before_image:!1,tile_enable_background:!0,tile_background_color:"#F0F0F0",tile_enable_border:!1,tile_border_width:3,tile_border_color:"#F0F0F0",tile_border_radius:0,tile_enable_outline:!1,tile_outline_color:"#8B8B8B",tile_enable_shadow:!1,tile_shadow_h:1,tile_shadow_v:1,tile_shadow_blur:3,tile_shadow_spread:2,tile_shadow_color:"#8B8B8B",tile_enable_action:!0,tile_as_link:!1,tile_link_newpage:!0,tile_enable_overlay:!0,tile_overlay_opacity:.4,tile_overlay_color:"#000000",tile_enable_icons:!0,tile_show_link_icon:!1,tile_videoplay_icon_always_on:!1,tile_space_between_icons:26,tile_enable_image_effect:!1,tile_image_effect_type:"bw",tile_image_effect_reverse:!1,tile_enable_textpanel:!1,tile_textpanel_source:"title",tile_textpanel_always_on:!1,tile_textpanel_appear_type:"slide",tile_textpanel_position:"inside_bottom",tile_textpanel_offset:0},W={thumb_color_overlay_effect:!0,thumb_overlay_reverse:!0,thumb_image_overlay_effect:!1,tile_textpanel_enable_description:!1,tile_textpanel_bg_opacity:.6,tile_textpanel_padding_top:8,tile_textpanel_padding_bottom:8},F={ratioByHeight:0,ratioByWidth:0,eventSizeChange:"thumb_size_change",funcCustomTileHtml:null,funcCustomPositionElements:null,funcParentApproveClick:null,isSaparateIcons:!1,tileInnerReduce:0,isTextpanelOutside:!1,hasImageContainer:!1};this.loadTileImage=function(e){var t=k.getTileImage(e);G.checkImagesLoaded(t,null,function(t,i){x(null,e,jQuery(t))})},this.setHtml=function(e){O=e,Q.setHtmlThumbs(e)},this.initEvents=function(){Q.initEvents(),jQuery(Q).on(Q.events.SETOVERSTYLE,T),jQuery(Q).on(Q.events.SETNORMALSTYLE,E),jQuery(Q).on(Q.events.PLACEIMAGE,x),L.on(F.eventSizeChange,P),O.delegate(".ug-tile .ug-button-play","click",A),O.delegate(".ug-tile","click",C),O.delegate(".ug-tile .ug-icon-link","click",M)},this.destroy=function(){if(jQuery(Q).off(Q.events.SETOVERSTYLE),jQuery(Q).off(Q.events.SETNORMALSTYLE),jQuery(Q).off(Q.events.PLACEIMAGE),L.off(F.eventSizeChange),1==D.tile_enable_textpanel){var e=Q.getThumbs();jQuery.each(e,function(e,t){var i=s(jQuery(t));i&&i.destroy()})}
Q.destroy()},this.init=function(t,i,n){e(t,i,n)},this.setFixedMode=function(){D.tile_size_by=k.sizeby.GLOBAL_RATIO,D.tile_visible_before_image=!0},this.setApproveClickFunction=function(e){F.funcParentApproveClick=e},this.resizeTile=function(e,t,i,n){if(1==F.isTextpanelOutside&&v(e,"clone",t),t){if(!i)var i=k.getTileHeightByWidth(t,e)}else var t=D.tile_width,i=D.tile_height;switch(G.setElementSize(e,t,i),n){default:case k.resizemode.FULL:k.triggerSizeChangeEvent(e,!0);break;case k.resizemode.WRAPPER_ONLY:return!0;case k.resizemode.VISIBLE_ELEMENTS:if(F.funcCustomTileHtml)return k.triggerSizeChangeEvent(e,!0),!0;m(e,t,i,!0),1==D.tile_enable_textpanel&&1==D.tile_textpanel_always_on&&t&&v(e,"regular",t,i)}},this.resizeAllTiles=function(e,t){var i=null;D.tile_size_by==k.sizeby.GLOBAL_RATIO&&(i=k.getTileHeightByWidth(e));var n=Q.getThumbs();n.each(function(n,r){k.resizeTile(jQuery(r),e,i,t)})},this.triggerSizeChangeEvent=function(e,t){if(!e)return!1;if(!t)var t=!1;L.trigger(F.eventSizeChange,[e,t])},this.triggerSizeChangeEventAllTiles=function(e){var t=Q.getThumbs();t.each(function(){var t=jQuery(this);k.triggerSizeChangeEvent(t,e)})},this.disableEvents=function(){var e=Q.getThumbs();e.css("pointer-events","none")},this.enableEvents=function(){var e=Q.getThumbs();e.css("pointer-events","auto")},this.setOptions=function(e){D=jQuery.extend(D,e),Q.setOptions(e)},this.setCustomFunctions=function(e,t){F.funcCustomTileHtml=e,F.funcCustomPositionElements=t},this.run=function(){var e=Q.getThumbs();D.tile_size_by==k.sizeby.GLOBAL_RATIO&&k.resizeAllTiles(D.tile_width,k.resizemode.WRAPPER_ONLY),1==D.tile_enable_image_effect&&0==D.tile_image_effect_reverse&&e.children(".ug-thumb-image").fadeTo(0,0),Q.setHtmlProperties(),1==D.tile_visible_before_image&&(e.children(".ug-thumb-image").fadeTo(0,0),Q.loadThumbsImages())},this._____________EXTERNAL_GETTERS____________=function(){},this.getObjThumbs=function(){return Q},this.getOptions=function(){return D},this.getTileImage=function(e){var t=e.find("img.ug-thumb-image");return t},this.getItemByTile=function(e){return Q.getItemByThumb(e)},this.getTileHeightByWidth=function(e,t){var i=c(t);if(null===i)return null;var n=Math.floor((e-F.tileInnerReduce)*i)+F.tileInnerReduce;return t&&1==F.isTextpanelOutside&&D.tile_size_by==k.sizeby.IMAGE_RATIO&&(n+=_(t)),n},this.getTileImageSize=function(e){var t=k.getItemByTile(e);if(!t.thumbWidth||!t.thumbHeight)throw new Error("Can't get image size - image not inited.");var i={width:t.thumbWidth,height:t.thumbHeight};return i},this.getGlobalTileSize=function(){if(D.tile_size_by!=k.sizeby.GLOBAL_RATIO)throw new Error("The size has to be global ratio");var e={width:D.tile_width,height:D.tile_height};return e}}
function UGAviaControl(){function e(e){return 0==p?e.pageX:e.pageY}
function t(t){jQuery("body").on("touchstart",function(e){return 0==f.isControlEnabled?!0:void(f.touchEnabled=!0)}),jQuery("body").mousemove(function(t){if(0==f.isControlEnabled)return!0;if(1==f.touchEnabled)return jQuery("body").off("mousemove"),!0;f.isMouseInsideStrip=g.ismouseover();var i=u.isTouchMotionActive();if(1==f.isMouseInsideStrip&&0==i){var n=e(t);l(n)}else a()})}
function i(e){var t=h.strip_padding_top,i=(h.strip_padding_bottom,g.height()),n=c.height();if(i>n)return null;var r=g.offset(),o=r.top,a=e-o-t;if(0>a)return null;var s=h.thumb_height,l=i-h.thumb_height,u=l-s;s>a&&(a=s),a>l&&(a=l);var d=(a-s)/u,_=(n-i)*d;return _=-1*Math.round(_)+t}
function n(e){var t=h.strip_padding_left,i=h.strip_padding_right,n=g.width()-t-i,r=c.width();if(n>r)return null;var o=g.offset(),a=o.left,s=e-a-t,l=h.thumb_width,u=n-h.thumb_width,d=u-l;l>s&&(s=l),s>u&&(s=u);var _=(s-l)/d,p=(r-n)*_;return p=-1*Math.round(p)+t}
function r(){if(0==f.is_strip_moving)return!1;var e=u.getInnerStripPos();Math.floor(e)==Math.floor(f.strip_finalPos)&&a();var t,i=Math.abs(f.strip_finalPos-e);1>i?t=i:(t=i/4,t>0&&1>t&&(t=1)),f.strip_finalPos<e&&(t=-1*t);var n=e+t;u.positionInnerStrip(n)}
function o(){return 1==f.isStripMoving?!1:(f.isStripMoving=!0,void(f.handle_timeout=setInterval(r,10)))}
function a(){return 0==f.isStripMoving?!1:(f.isStripMoving=!1,void(f.handle_timeout=clearInterval(f.handle_timeout)))}
function s(e){return 0==p?n(e):i(e)}
function l(e){var t=s(e);return null===t?!1:(f.is_strip_moving=!0,f.strip_finalPos=t,void o())}
var u,d,_,g,c,h,p,f={touchEnabled:!1,isMouseInsideStrip:!1,strip_finalPos:0,handle_timeout:"",isStripMoving:!1,isControlEnabled:!0};this.enable=function(){f.isControlEnabled=!0},this.disable=function(){f.isControlEnabled=!1},this.init=function(e){u=e,_=e.getObjects(),d=_.g_gallery,g=_.g_objStrip,c=_.g_objStripInner,h=_.g_options,p=_.isVertical,t()},this.destroy=function(){jQuery("body").off("touchstart"),jQuery("body").off("mousemove")}}
function UGSlider(){function e(e,t,n){fe=e,n&&(ce=n,t=Ie.convertCustomPrefixOptions(t,ce,"slider")),ee=jQuery(e);var r=fe.getObjects();if(te=r.g_objWrapper,ie=r.g_objThumbs,t.hasOwnProperty("slider_progress_indicator_type")&&(Ee.slider_progress_indicator_type=t.slider_progress_indicator_type),"bar"==Ee.slider_progress_indicator_type&&(Ee=jQuery.extend(Ee,Se)),t&&he.setOptions(t),i(),1==Ee.slider_enable_bullets){be=new UGBullets;var o={bullets_skin:Ee.slider_bullets_skin,bullets_space_between:Ee.slider_bullets_space_between};be.init(fe,o)}
Ee.slider_enable_text_panel&&(Te=new UGTextPanel,Te.init(fe,Ee,"slider")),Ee.slider_enable_zoom_panel&&(ge=new UGZoomButtonsPanel,ge.init(he,Ee));var a=fe.getGalleryID();ye.init(Ee,!1,a)}
function t(){if(1==Pe.isRunOnce)return!1;if(Pe.isRunOnce=!0,Ee.slider_background_color){var e=Ee.slider_background_color;1!=Ee.slider_background_opacity&&(e=Ie.convertHexToRGB(e,Ee.slider_background_opacity)),ne.css("background-color",e)}else 1!=Ee.slider_background_opacity&&(e=Ie.convertHexToRGB("#000000",Ee.slider_background_opacity),ne.css("background-color",e));1==Ee.slider_control_swipe&&(de=new UGTouchSliderControl,de.init(he,Ee)),1==Ee.slider_control_zoom&&(_e=new UGZoomSliderControl,_e.init(he,Ee)),Te&&Te.run(),V()}
function i(){var e=fe.getOptions(),t=e.gallery_skin;""==Ee.slider_bullets_skin&&(Ee.slider_bullets_skin=t),""==Ee.slider_arrows_skin&&(Ee.slider_arrows_skin=t),""==Ee.slider_zoompanel_skin&&(Ee.slider_zoompanel_skin=t),""==Ee.slider_play_button_skin&&(Ee.slider_play_button_skin=t),""==Ee.slider_fullscreen_button_skin&&(Ee.slider_fullscreen_button_skin=t),Ee.video_enable_closebutton=Ee.slider_video_enable_closebutton,"zoom"!=e.gallery_mousewheel_role&&(Ee.slider_zoom_mousewheel=!1)}
function n(e,t){var i="ug-type-square";return"round"==Ee.slider_videoplay_button_type&&(i="ug-type-round"),html="",html+="<div class='ug-slide-wrapper ug-slide"+t+"'>",html+="<div class='ug-item-wrapper'></div>",html+="<div class='ug-slider-preloader "+e+"'></div>",html+="<div class='ug-button-videoplay "+i+"' style='display:none'></div>",html+="</div>",html}
function r(e){e&&(te=e);var t=X(),i=(fe.getOptions(),"<div class='ug-slider-wrapper'>");if(i+="<div class='ug-slider-inner'>",i+=n(t,1),i+=n(t,2),i+=n(t,3),i+="</div>",1==Ee.slider_enable_arrows&&(i+="<div class='ug-slider-control ug-arrow-left ug-skin-"+Ee.slider_arrows_skin+"'></div>",i+="<div class='ug-slider-control ug-arrow-right ug-skin-"+Ee.slider_arrows_skin+"'></div>"),1==Ee.slider_enable_play_button&&(i+="<div class='ug-slider-control ug-button-play ug-skin-"+Ee.slider_play_button_skin+"'></div>"),1==Ee.slider_enable_fullscreen_button&&(i+="<div class='ug-slider-control ug-button-fullscreen ug-skin-"+Ee.slider_fullscreen_button_skin+"'></div>"),i+="</div>",te.append(i),ne=te.children(".ug-slider-wrapper"),re=ne.children(".ug-slider-inner"),oe=re.children(".ug-slide1"),ae=re.children(".ug-slide2"),se=re.children(".ug-slide3"),oe.data("slidenum",1),ae.data("slidenum",2),se.data("slidenum",3),be&&be.appendHTML(ne),1==Ee.slider_enable_arrows&&(le=ne.children(".ug-arrow-left"),ue=ne.children(".ug-arrow-right")),1==Ee.slider_enable_play_button&&(me=ne.children(".ug-button-play")),1==Ee.slider_enable_fullscreen_button&&(ve=ne.children(".ug-button-fullscreen")),1==Ee.slider_enable_progress_indicator){we=Ie.initProgressIndicator(Ee.slider_progress_indicator_type,Ee,ne);var r=we.getType();"bar"==r&&"pie"==Ee.slider_progress_indicator_type&&(Ee.slider_progress_indicator_type="bar",Ee=jQuery.extend(Ee,Se)),fe.setProgressIndicator(we)}
if(1==Ee.slider_enable_text_panel&&(Te.appendHTML(ne),0==Ee.slider_textpanel_always_on)){var o=Te.getElement();o.hide().data("isHidden",!0),Pe.isTextPanelSaparateHover=!0}
1==Ee.slider_enable_zoom_panel&&ge.appendHTML(ne),ye.setHtml(re)}
function o(e){var t=K(e);Ie.placeElementInParentCenter(t);var i=J(e);Ie.placeElementInParentCenter(i)}
function a(){if(be&&(objBullets=be.getElement(),Ie.placeElement(objBullets,Ee.slider_bullets_align_hor,Ee.slider_bullets_align_vert,Ee.slider_bullets_offset_hor,Ee.slider_bullets_offset_vert),Ie.placeElement(objBullets,Ee.slider_bullets_align_hor,Ee.slider_bullets_align_vert,Ee.slider_bullets_offset_hor,Ee.slider_bullets_offset_vert)),1==Ee.slider_enable_arrows&&(Ie.placeElement(le,Ee.slider_arrow_left_align_hor,Ee.slider_arrow_left_align_vert,Ee.slider_arrow_left_offset_hor,Ee.slider_arrow_left_offset_vert),Ie.placeElement(ue,Ee.slider_arrow_right_align_hor,Ee.slider_arrow_left_align_vert,Ee.slider_arrow_right_offset_hor,Ee.slider_arrow_right_offset_vert)),0==Ee.slider_controls_always_on&&A(!0),we){var e=we.getElement();if("bar"==Ee.slider_progress_indicator_type){var t=ne.width();we.setSize(t),Ie.placeElement(e,"left",Ee.slider_progress_indicator_align_vert,0,Ee.slider_progress_indicator_offset_vert)}else Ie.placeElement(e,Ee.slider_progress_indicator_align_hor,Ee.slider_progress_indicator_align_vert,Ee.slider_progress_indicator_offset_hor,Ee.slider_progress_indicator_offset_vert)}
Te&&Te.positionPanel(),s(),o(oe),o(ae),o(se),j()}
function s(){if(me&&Ie.placeElement(me,Ee.slider_play_button_align_hor,Ee.slider_play_button_align_vert,Ee.slider_play_button_offset_hor,Ee.slider_play_button_offset_vert),ve&&Ie.placeElement(ve,Ee.slider_fullscreen_button_align_hor,Ee.slider_fullscreen_button_align_vert,Ee.slider_fullscreen_button_offset_hor,Ee.slider_fullscreen_button_offset_vert),ge){var e=ge.getElement();Ie.placeElement(e,Ee.slider_zoompanel_align_hor,Ee.slider_zoompanel_align_vert,Ee.slider_zoompanel_offset_hor,Ee.slider_zoompanel_offset_vert)}}
function l(){var e,t,i,n,r=he.getSlidesReference(),o=0,a=0,s=0;i=he.isSlideHasItem(r.objNextSlide),n=he.isSlideHasItem(r.objPrevSlide),n?(s=r.objPrevSlide.outerWidth(),r.objPrevSlide.css("z-index",1)):r.objPrevSlide.hide(),t=s+r.objCurrentSlide.outerWidth(),e=t,i?(e=t+r.objNextSlide.outerWidth(),r.objPrevSlide.css("z-index",2)):r.objNextSlide.hide(),r.objCurrentSlide.css("z-index",3),Ie.placeElement(r.objCurrentSlide,s,o),re.css({left:-s+"px",width:e+"px"}),n&&(Ie.placeElement(r.objPrevSlide,a,o),Ie.showElement(r.objPrevSlide)),i&&(Ie.showElement(r.objNextSlide),Ie.placeElement(r.objNextSlide,t,o))}
function u(e){var t=e.data("index");if(void 0===t||null==t)return!1;var i=fe.getItem(t);return i?void p(e,i):!1}
function d(e){e.stop(!0).show(100)}
function _(e){e.stop(!0).hide(100)}
function g(e,t){var i={};1==Ee.slider_image_border&&(i["border-style"]="solid",i["border-width"]=Ee.slider_image_border_width+"px",i["border-color"]=Ee.slider_image_border_color,i["border-radius"]=Ee.slider_image_border_radius),"image"!=t&&1==Ee.slider_video_constantsize&&(i["background-color"]="#000000"),1==Ee.slider_image_shadow&&(i["box-shadow"]="3px 3px 10px 0px #353535"),e.css(i)}
function c(e,t){var i=Ee.slider_video_constantsize_width,n=Ee.slider_video_constantsize_height,r=Ee.slider_video_constantsize_scalemode;Ie.scaleImageExactSizeInParent(e,t.imageWidth,t.imageHeight,i,n,r)}
function h(e,t,i){var n=e.children(".ug-item-wrapper"),r=K(e);if("undefined"==typeof t.urlImage||""==t.urlImage)throw new Error("The slide don't have big image defined ( data-image='imageurl' ). Please check gallery items.","showbig");var o=t.urlImage,a=e.data("urlImage");e.data("urlImage",o);var s=he.getScaleMode(e),l=he.getSlideType(e);if(objPadding=he.getObjImagePadding(),a==o&&i!==!0){var u=n.children("img");(0==t.imageWidth||0==t.imageHeight)&&fe.checkFillImageSize(u,t),"image"!=l&&1==Ee.slider_video_constantsize?c(u,t):Ie.scaleImageFitParent(u,t.imageWidth,t.imageHeight,s,objPadding),pe.trigger(he.events.AFTER_PUT_IMAGE,e)}else u=Ie.placeImageInsideParent(o,n,t.imageWidth,t.imageHeight,s,objPadding),1==t.isBigImageLoaded?(u.fadeTo(0,1),_(r),"image"!=l&&1==Ee.slider_video_constantsize&&c(u,t),pe.trigger(he.events.AFTER_PUT_IMAGE,e)):(u.fadeTo(0,0),d(r),e.data("isLoading",!0),he.isSlideCurrent(e)&&pe.trigger(he.events.CURRENTSLIDE_LOAD_START),u.data("itemIndex",t.index),u.on("load",function(){var e=jQuery(this),t=e.data("itemIndex");e.fadeTo(0,1);var i=e.parent().parent(),n=he.getSlideType(i),r=K(i),o=he.getObjImagePadding(),a=he.getScaleMode(i);_(r),i.data("isLoading",!1),he.isSlideCurrent(i)&&pe.trigger(he.events.CURRENTSLIDE_LOAD_END),fe.onItemBigImageLoaded(null,e);var s=fe.getItem(t);"image"!=n&&1==Ee.slider_video_constantsize?c(e,s):Ie.scaleImageFitParent(e,s.imageWidth,s.imageHeight,a,o),e.fadeTo(0,1),pe.trigger(he.events.AFTER_PUT_IMAGE,i)}));u&&g(u,l)}
function p(e,t){try{var i=e.children(".ug-item-wrapper");if(null==t)return i.html(""),e.removeData("index"),e.removeData("type"),e.removeData("urlImage"),!1;e.data("index");e.data("index",t.index),e.data("type",t.type),1==Ee.slider_enable_links&&"image"==t.type&&(t.link?e.addClass("ug-slide-clickable"):e.removeClass("ug-slide-clickable")),h(e,t);var n=J(e);switch(t.type){case"image":n.hide();break;default:n.show()}}catch(r){throw"undefined"!=typeof r.fileName&&"showbig"==r.fileName&&fe.showErrorMessageReplaceGallery(r.message),i.html(""),new Error(r)}}
function f(){if(!Te)return!1;if(1==v())return!1;var e=Te.getElement(),t=0;(1==Pe.isTextPanelSaparateHover||1==Ee.slider_textpanel_always_on)&&(t=Ee.slider_controls_appear_duration),e.stop().fadeTo(t,0),e.data("isHidden",!0)}
function m(){if(!Te)return!1;if(0==v())return!1;var e=Te.getElement(),t=0;(1==Pe.isTextPanelSaparateHover||1==Ee.slider_textpanel_always_on)&&(e.show(),Te.positionElements(),t=Ee.slider_controls_appear_duration),e.stop().show().fadeTo(t,1),e.data("isHidden",!1)}
function v(){var e=Te.getElement(),t=e.data("isHidden");return t===!1?!1:!0}
function b(e,t){if(void 0==t)var t=he.getCurrentSlide();var i=he.getSlideType(t);if(i!=e)throw new Error("Wrong slide type: "+i+", should be: "+e);return!0}
function y(){var e=he.getCurrentSlide(),t=he.getSlideImage(e),i=Ie.getElementSize(e),n=i.left,r=i.top;if(1==Ee.slider_video_constantsize){var o=Ie.getElementSize(t);n+=o.left,r+=o.top}else n+=Ee.slider_video_padding_left,r+=Ee.slider_video_padding_top;ye.setPosition(n,r)}
function I(){var e=Ee.slider_video_constantsize_width,t=Ee.slider_video_constantsize_height;ye.setSize(e,t);var i=ye.getObject();g(i)}
function w(e,t,i){pe.trigger(he.events.TRANSITION_START);var n=Ee.slider_transition;switch(i&&(n=i),he.stopSlideAction(null,!0),n){default:case"fade":S(t);break;case"slide":T(e,t);break;case"lightbox_open":S(t,!1,!0)}}
function T(e,t){var i=he.isAnimating();if(1==i)return Pe.itemWaiting=t,!0;null!=Pe.itemWaiting&&(Pe.itemWaiting=null);var n=he.getSlidesReference();switch(e){case"right":p(n.objPrevSlide,t),l();var r=Ie.getElementSize(n.objPrevSlide),o=-r.left;he.switchSlideNums("right");break;case"left":p(n.objNextSlide,t),l();var a=Ie.getElementSize(n.objNextSlide),o=-a.left;he.switchSlideNums("left");break;default:throw new Error("wrong direction: "+e)}
var s=Ee.slider_transition_speed,u=Ee.slider_transition_easing,d={duration:s,easing:u,queue:!1,always:function(){if(he.stopSlideAction(),ye.hide(),null!=Pe.itemWaiting){var e=q(Pe.itemWaiting);T(e,Pe.itemWaiting)}else he.placeNabourItems(),pe.trigger(he.events.TRANSITION_END)}};re.animate({left:o+"px"},d)}
function E(e,t,i){i?e.fadeTo(Ee.slider_transition_speed,t,i):e.fadeTo(Ee.slider_transition_speed,t)}
function S(e,t,i){if(!t)var t=!1;var n=he.getSlidesReference();p(n.objNextSlide,e);var r=Ie.getElementSize(n.objCurrentSlide);Ie.placeElement(n.objNextSlide,r.left,r.top);var o=Pe.numCurrent;if(Pe.numCurrent=Pe.numNext,Pe.numNext=o,pe.trigger(he.events.ITEM_CHANGED),n.objNextSlide.stop(!0),n.objCurrentSlide.stop(!0),1==t)n.objCurrentSlide.fadeTo(0,0),n.objNextSlide.fadeTo(0,1),he.placeNabourItems(),pe.trigger(he.events.TRANSITION_END),i!==!0&&ye.hide();else{if(n.objNextSlide.fadeTo(0,0),E(n.objCurrentSlide,0,function(){he.placeNabourItems(),pe.trigger(he.events.TRANSITION_END),i!==!0&&ye.hide()}),1==ye.isVisible()){var a=ye.getObject();E(a,0)}
E(n.objNextSlide,1)}}
function P(){1==Ee.slider_fullscreen_button_mobilehide&&ve&&ve.hide(),1==Ee.slider_play_button_mobilehide&&me&&me.hide(),1==Ee.slider_zoompanel_mobilehide&&ge&&ge.getElement().hide()}
function x(){1==Ee.slider_fullscreen_button_mobilehide&&ve&&ve.show(),1==Ee.slider_play_button_mobilehide&&me&&me.show(),1==Ee.slider_zoompanel_mobilehide&&ge&&ge.getElement().show()}
function j(){var e=fe.isMobileMode();e?P():x()}
function C(){var e=ne.children(".ug-slider-control");return e}
function A(e){if(0==Ie.isTimePassed("sliderControlsToggle"))return!1;if(0==Pe.isControlsVisible)return!1;if(!e)var e=!1;var t=C();e===!0?t.stop().fadeTo(0,0).hide():t.stop().fadeTo(Ee.slider_controls_appear_duration,0,function(){t.hide()}),Pe.isControlsVisible=!1}
function M(e){if(0==Ie.isTimePassed("sliderControlsToggle"))return!1;if(1==Pe.isControlsVisible)return!0;if(!e)var e=!1;var t=C();e===!0?t.stop().show():(t.stop().show().fadeTo(0,0),t.fadeTo(Ee.slider_controls_appear_duration,1)),Pe.isControlsVisible=!0}
function z(){0==Pe.isControlsVisible?M():A()}
function O(e){if(e==Pe.currentControlsMode)return!1;switch(e){case"image":ge&&ge.getElement().show();break;case"video":ge&&ge.getElement().hide();break;default:throw new Error("wrong controld mode: "+e)}
Pe.currentControlsMode=e}
function L(e,t,i){var n=fe.getSelectedItem();he.setItem(n,!1,i);var r=n.index;be&&be.setActive(r),Te&&0==Pe.isTextPanelSaparateHover&&m(),O("image"==n.type?"image":"video")}
function H(e,t){fe.selectItem(t)}
function k(e){return de&&0==de.isTapEventOccured(e)?!0:void pe.trigger(he.events.CLICK,e)}
function N(){var e=he.getCurrentSlide(),t=e.hasClass("ug-slide-clickable"),i=he.getCurrentItem();return t?(0==Ee.slider_links_newpage?location.href=i.link:window.open(i.link,"_blank"),!0):void(0==Ee.slider_controls_always_on&&1==Ee.slider_controls_appear_ontap&&1==he.isCurrentSlideType("image")&&(z(),Te&&1==Ee.slider_textpanel_always_on&&he.isCurrentSlideType("image")&&he.isCurrentSlideImageFit()&&m()))}
function R(e){Te&&he.isCurrentSlideType("image")&&0==he.isCurrentSlideImageFit()&&f()}
function G(){M()}
function Q(){A()}
function D(e){var t=e.parent();he.startSlideAction(t)}
function W(){fe.isPlayMode()&&fe.pausePlaying(),pe.trigger(he.events.ACTION_START)}
function F(){fe.isPlayMode()&&fe.continuePlaying(),pe.trigger(he.events.ACTION_END)}
function B(e,t,i){oe.data("index")==t&&(objItem=fe.getItem(t),h(oe,objItem,!0)),ae.data("index")==t&&(objItem=fe.getItem(t),h(ae,objItem,!0)),se.data("index")==t&&(objItem=fe.getItem(t),h(se,objItem,!0))}
function Y(e,t){t=jQuery(t);var i=he.getSlideImage(t),n=J(t),r=Ie.getElementSize(i);Ie.placeElement(n,"center","middle",r.left,r.top,i)}
function U(e){var t=J(e);Ie.addClassOnHover(t),Ie.setButtonOnClick(t,D)}
function V(){ee.on(fe.events.ITEM_IMAGE_UPDATED,B),ee.on(fe.events.ITEM_CHANGE,L),be&&jQuery(be).on(be.events.BULLET_CLICK,H),1==Ee.slider_enable_arrows&&(Ie.addClassOnHover(ue,"ug-arrow-hover"),Ie.addClassOnHover(le,"ug-arrow-hover"),fe.setNextButton(ue),fe.setPrevButton(le)),0==Ee.slider_controls_always_on&&ne.hover(G,Q),ne.on("touchend click",k),pe.on(he.events.CLICK,N),Te&&1==Pe.isTextPanelSaparateHover&&ne.hover(m,f),me&&(Ie.addClassOnHover(me,"ug-button-hover"),fe.setPlayButton(me)),ve&&(Ie.addClassOnHover(ve,"ug-button-hover"),fe.setFullScreenToggleButton(ve)),_e&&pe.on(he.events.ZOOM_CHANGE,R),ge&&ge.initEvents(),ye.initEvents(),jQuery(ye).on(ye.events.SHOW,W),jQuery(ye).on(ye.events.HIDE,F),U(oe),U(ae),U(se),pe.on(he.events.AFTER_PUT_IMAGE,Y),ne.delegate(".ug-item-wrapper img","mouseenter",function(e){pe.trigger(he.events.IMAGE_MOUSEENTER)}),ne.delegate(".ug-item-wrapper img","mouseleave",function(e){var t=he.isMouseInsideSlideImage(e);0==t&&pe.trigger(he.events.IMAGE_MOUSELEAVE)})}
function X(){var e;switch(Ee.slider_loader_type){default:case 1:e="ug-loader1";break;case 2:e="ug-loader2";break;case 3:e="ug-loader3";break;case 4:e="ug-loader4";break;case 5:e="ug-loader5";break;case 6:e="ug-loader6";break;case 7:e="ug-loader7";break;case 8:e="ug-loader8";break;case 9:e="ug-loader9"}
return"black"==Ee.slider_loader_color&&(e+=" ug-loader-black"),e}
function Z(e){switch(e){case 1:return oe;case 2:return ae;case 3:return se;default:throw new Error("wrong num: "+e)}}
function q(e){var t=he.getSlidesReference(),i=t.objCurrentSlide.data("index"),n=e.index,r="left";return i>n&&(r="right"),r}
function K(e){if(!e)var e=he.getCurrentSlide();var t=e.children(".ug-slider-preloader");return t}
function J(e){var t=e.children(".ug-button-videoplay");return t}
function $(e){if(!e)var e=he.getCurrentSlide();var t=e.data("index");if(void 0==t)return null;var i=fe.getItem(t);return i}
var ee,te,ie,ne,re,oe,ae,se,le,ue,de,_e,ge,ce,he=this,pe=jQuery(he),fe=new UniteGalleryMain,me=null,ve=null,be=null,ye=new UGVideoPlayer,Ie=new UGFunctions,we=null,Te=null;this.events={ITEM_CHANGED:"item_changed",BEFORE_SWITCH_SLIDES:"before_switch",BEFORE_RETURN:"before_return",AFTER_RETURN:"after_return",ZOOM_START:"slider_zoom_start",ZOOM_END:"slider_zoom_end",ZOOMING:"slider_zooming",ZOOM_CHANGE:"slider_zoom_change",START_DRAG:"start_drag",AFTER_DRAG_CHANGE:"after_drag_change",ACTION_START:"action_start",ACTION_END:"action_end",CLICK:"slider_click",TRANSITION_START:"slider_transition_start",TRANSITION_END:"slider_transition_end",AFTER_PUT_IMAGE:"after_put_image",IMAGE_MOUSEENTER:"slider_image_mouseenter",IMAGE_MOUSELEAVE:"slider_image_mouseleave",CURRENTSLIDE_LOAD_START:"slider_current_loadstart",CURRENTSLIDE_LOAD_END:"slider_current_loadend"};var Ee={slider_scale_mode:"fill",slider_scale_mode_media:"fill",slider_scale_mode_fullscreen:"down",slider_item_padding_top:0,slider_item_padding_bottom:0,slider_item_padding_left:0,slider_item_padding_right:0,slider_background_color:"",slider_background_opacity:1,slider_image_padding_top:0,slider_image_padding_bottom:0,slider_image_padding_left:0,slider_image_padding_right:0,slider_image_border:!1,slider_image_border_width:10,slider_image_border_color:"#ffffff",slider_image_border_radius:0,slider_image_shadow:!1,slider_video_constantsize:!1,slider_video_constantsize_scalemode:"fit",slider_video_constantsize_width:854,slider_video_constantsize_height:480,slider_video_padding_top:0,slider_video_padding_bottom:0,slider_video_padding_left:0,slider_video_padding_right:0,slider_video_enable_closebutton:!0,slider_transition:"slide",slider_transition_speed:300,slider_transition_easing:"easeInOutQuad",slider_control_swipe:!0,slider_control_zoom:!0,slider_zoom_mousewheel:!0,slider_vertical_scroll_ondrag:!1,slider_loader_type:1,slider_loader_color:"white",slider_enable_links:!0,slider_links_newpage:!1,slider_enable_bullets:!1,slider_bullets_skin:"",slider_bullets_space_between:-1,slider_bullets_align_hor:"center",slider_bullets_align_vert:"bottom",slider_bullets_offset_hor:0,slider_bullets_offset_vert:10,slider_enable_arrows:!0,slider_arrows_skin:"",slider_arrow_left_align_hor:"left",slider_arrow_left_align_vert:"middle",slider_arrow_left_offset_hor:20,slider_arrow_left_offset_vert:0,slider_arrow_right_align_hor:"right",slider_arrow_right_align_vert:"middle",slider_arrow_right_offset_hor:20,slider_arrow_right_offset_vert:0,slider_enable_progress_indicator:!0,slider_progress_indicator_type:"pie",slider_progress_indicator_align_hor:"right",slider_progress_indicator_align_vert:"top",slider_progress_indicator_offset_hor:10,slider_progress_indicator_offset_vert:10,slider_enable_play_button:!0,slider_play_button_skin:"",slider_play_button_align_hor:"left",slider_play_button_align_vert:"top",slider_play_button_offset_hor:50,slider_play_button_offset_vert:9,slider_play_button_mobilehide:!1,slider_enable_fullscreen_button:!0,slider_fullscreen_button_skin:"",slider_fullscreen_button_align_hor:"left",slider_fullscreen_button_align_vert:"top",slider_fullscreen_button_offset_hor:11,slider_fullscreen_button_offset_vert:9,slider_fullscreen_button_mobilehide:!1,slider_enable_zoom_panel:!0,slider_zoompanel_skin:"",slider_zoompanel_align_hor:"left",slider_zoompanel_align_vert:"top",slider_zoompanel_offset_hor:12,slider_zoompanel_offset_vert:92,slider_zoompanel_mobilehide:!1,slider_controls_always_on:!1,slider_controls_appear_ontap:!0,slider_controls_appear_duration:300,slider_enable_text_panel:!0,slider_textpanel_always_on:!0,slider_videoplay_button_type:"square"},Se={slider_progress_indicator_align_hor:"left",slider_progress_indicator_align_vert:"bottom",slider_progress_indicator_offset_hor:0,slider_progress_indicator_offset_vert:0},Pe={isRunOnce:!1,isTextPanelSaparateHover:!1,numPrev:1,numCurrent:2,numNext:3,isControlsVisible:!0,currentControlsMode:"image"};this.switchSlideNums=function(e){switch(pe.trigger(he.events.BEFORE_SWITCH_SLIDES),e){case"left":var t=Pe.numCurrent;Pe.numCurrent=Pe.numNext,Pe.numNext=Pe.numPrev,Pe.numPrev=t;break;case"right":var t=Pe.numCurrent;Pe.numCurrent=Pe.numPrev,Pe.numPrev=Pe.numNext,Pe.numNext=t;break;default:throw new Error("wrong direction: "+e)}
pe.trigger(he.events.ITEM_CHANGED)},this.destroy=function(){pe.off(he.events.AFTER_PUT_IMAGE),ee.off(fe.events.ITEM_IMAGE_UPDATED),ee.off(fe.events.ITEM_CHANGE),be&&jQuery(be).on(be.events.BULLET_CLICK),ne.off("mouseenter"),ne.off("mouseleave"),ne.off("touchend"),ne.off("click"),pe.off(he.events.CLICK),_e&&pe.off(he.events.ZOOM_CHANGE),pe.off(he.events.BEFORE_SWITCH_SLIDES),jQuery(ye).off(ye.events.SHOW),jQuery(ye).off(ye.events.HIDE),ye.destroy(),ne.undelegate(".ug-item-wrapper img","mouseenter"),ne.undelegate(".ug-item-wrapper img","mouseleave")},this.________EXTERNAL_GENERAL___________=function(){},this.init=function(t,i,n){e(t,i,n)},this.getSlideImage=function(e){if(!e)var e=he.getCurrentSlide();var t=e.find(".ug-item-wrapper img");return t},this.setHtml=function(e){r(e)},this.run=function(){t()},this.isInnerInPlace=function(){var e=he.getSlidesReference(),t=Ie.getElementSize(e.objCurrentSlide),i=-t.left,n=Ie.getElementSize(re);return i==n.left?!0:!1},this.isAnimating=function(){var e=re.is(":animated");return e},this.isSlideCurrent=function(e){var t=e.data("slidenum");return Pe.numCurrent==t?!0:!1},this.isSlideHasItem=function(e){var t=e.data("index");return void 0===t||null===t?!1:!0},this.getObjImagePadding=function(){var e={padding_top:Ee.slider_image_padding_top,padding_bottom:Ee.slider_image_padding_bottom,padding_left:Ee.slider_image_padding_left,padding_right:Ee.slider_image_padding_right};return e},this.getSlidesReference=function(){var e={objPrevSlide:Z(Pe.numPrev),objNextSlide:Z(Pe.numNext),objCurrentSlide:Z(Pe.numCurrent)};return e},this.getCurrentSlide=function(){var e=he.getSlidesReference();return e.objCurrentSlide},this.getCurrentItemIndex=function(){var e=he.getSlidesReference(),t=e.objCurrentSlide.data("index");return(null===t||void 0===t)&&(t=-1),t},this.getCurrentItem=function(){var e=he.getCurrentItemIndex();if(-1==e)return null;var t=fe.getItem(e);return t},this.getSlideType=function(e){void 0==e&&(e=he.getCurrentSlide());var t=e.data("type");return t},this.isMouseInsideSlideImage=function(e){var t=he.getSlideImage(),i=Ie.getMousePosition(e);void 0===i.pageX&&(i=de.getLastMousePos());var n=Ie.getMouseElementPoint(i,t),r=Ie.getElementSize(t);return isMouseInside=Ie.isPointInsideElement(n,r),isMouseInside},this.isCurrentSlideType=function(e){var t=he.getSlideType();return t==e?!0:!1},this.isCurrentSlideLoadingImage=function(){var e=he.getCurrentSlide(),t=e.data("isLoading");return t===!0?!0:!1},this.setItem=function(e,t,i){var n=he.getSlidesReference(),r=n.objCurrentSlide.data("index"),o=e.index;if(o==r)return!0;var a=void 0==r;if(a)p(n.objCurrentSlide,e),he.placeNabourItems();else{var s="left";fe.getNumItems();"next"==i?s="left":"prev"==i||r>o?s="right":r>o&&(s="right"),w(s,e,t)}},this.placeNabourItems=function(){var e=he.getSlidesReference(),t=e.objCurrentSlide.data("index"),i=fe.getPrevItem(t),n=fe.getNextItem(t);p(e.objNextSlide,n),p(e.objPrevSlide,i),l()},this.________EXTERNAL_API___________=function(){},this.stopSlideAction=function(e,t){e||(e=he.getCurrentSlide()),t===!0?ye.pause():ye.hide()},this.startSlideAction=function(e){e||(e=he.getCurrentSlide());var t=$(e);if("image"==t.type)return!0;switch(1==Ee.slider_video_constantsize&&I(),y(),ye.show(),t.type){case"youtube":ye.playYoutube(t.videoid);break;case"vimeo":ye.playVimeo(t.videoid);break;case"html5video":ye.playHtml5Video(t.videoogv,t.videowebm,t.videomp4,t.urlImage);break;case"soundcloud":ye.playSoundCloud(t.trackid);break;case"wistia":ye.playWistia(t.videoid)}},this.getScaleMode=function(e){if(!e)var e=he.getCurrentSlide();var t=he.getSlideType(e);return"image"!=t?Ee.slider_scale_mode_media:Ee.slider_scale_mode==Ee.slider_scale_mode_fullscreen?Ee.slider_scale_mode:1==fe.isFullScreen()?Ee.slider_scale_mode_fullscreen:Ee.slider_scale_mode},this.getObjects=function(){var e={g_objSlider:ne,g_objInner:re,g_options:Ee,g_objZoomSlider:_e};return e},this.getObjZoom=function(){return _e},this.getOptions=function(){return Ee},this.getElement=function(){return ne},this.getVideoObject=function(){return ye},this.isCurrentSlideImageFit=function(){var e=he.getCurrentSlide();he.getSlideType(e);b("image",e);var t=he.getSlideImage(e);if(0==t.length)return!1;var i=Ie.isImageFitParent(t);return i},this.isCurrentImageInPlace=function(){var e=he.getSlideImage();if(0==e.length)return!1;var t=he.getScaleMode(),i=he.getObjImagePadding(),n=$(),r=e.parent(),o=Ie.getImageInsideParentData(r,n.imageWidth,n.imageHeight,t,i),a=Ie.getElementSize(e);return o.imageWidth==a.width?!0:!1},this.isSlideActionActive=function(){return ye.isVisible()},this.isSwiping=function(){if(!de)return!1;var e=de.isTouchActive();return e},this.isPreloading=function(){var e=K();return e.is(":visible")?!0:!1},this.setOptions=function(e){ce&&(e=Ie.convertCustomPrefixOptions(e,ce,"slider")),Ee=jQuery.extend(Ee,e)},this.setSize=function(e,t){if(0>e||0>t)return!0;var i={};i.width=e+"px",i.height=t+"px",ne.css(i);var n={};n.height=t+"px",n.top="0px",n.left="0px",re.css(n);var r={};r.height=t+"px",r.width=e+"px",oe.css(r),ae.css(r),se.css(r);var o=e-Ee.slider_item_padding_left-Ee.slider_item_padding_right,s=t-Ee.slider_item_padding_top-Ee.slider_item_padding_bottom,d={};d.width=o+"px",d.height=s+"px",d.top=Ee.slider_item_padding_top+"px",d.left=Ee.slider_item_padding_left+"px",ne.find(".ug-item-wrapper").css(d),Te&&Te.setSizeByParent(),a(),u(oe),u(ae),u(se),l();var _=he.getSlideType();if("image"!=_&&1==Ee.slider_video_constantsize)I(),y();else{var g=e-Ee.slider_video_padding_left-Ee.slider_video_padding_right,c=t-Ee.slider_video_padding_top-Ee.slider_video_padding_bottom;ye.setSize(g,c)}},this.refreshSlideItems=function(){return 1==he.isAnimating()?!0:(u(oe),u(ae),u(se),void l())},this.isMouseOver=function(){return ne.ismouseover()},this.setPosition=function(e,t){Ie.placeElement(ne,e,t)},this.zoomIn=function(){return _e?void _e.zoomIn():!0},this.zoomOut=function(){return _e?void _e.zoomOut():!0},this.zoomBack=function(){return _e?void _e.zoomBack():!0}}
function UGTextPanel(){function e(e,t){if(!t)var t=v.textpanel_padding_top;var i=t;if(d){var n=i;f.placeElement(d,0,n);var o=f.getElementSize(d),i=o.bottom}
var a="";if(_&&(a=jQuery.trim(_.text())),""!=a){var s=i;d&&(s+=v.textpanel_padding_title_description),f.placeElement(_,0,s);var l=f.getElementSize(_);i=l.bottom}
if(!v.textpanel_height&&1==b.setInternalHeight){var u=i+v.textpanel_padding_bottom;r(u,e)}}
function t(){var e=0;if(d&&(e+=d.outerHeight()),_){var t="";_&&(t=jQuery.trim(_.text())),""!=t&&(d&&(e+=v.textpanel_padding_title_description),e+=_.outerHeight())}
return e}
function i(){var i=t(),n=(c.height()-i)/2;e(!1,n)}
function n(){var i=t(),n=c.height()-i-v.textpanel_padding_bottom;e(!1,n)}
function r(e,t){if(!t)var t=!1;if(1==t){if(g){var i=g.height();e>i&&g.height(e)}
var n={height:e+"px"};l.add(c).animate(n,v.textpanel_fade_duration)}else g&&g.height(e),l.add(c).height(e)}
function o(){if(1==v.textpanel_enable_bg){g=l.children(".ug-textpanel-bg"),g.fadeTo(0,v.textpanel_bg_opacity);var e={"background-color":v.textpanel_bg_color};e=jQuery.extend(e,v.textpanel_bg_css),g.css(e)}
if(1==v.textpanel_enable_title){d=c.children(".ug-textpanel-title");var t={};null!==v.textpanel_title_color&&(t.color=v.textpanel_title_color),null!==v.textpanel_title_font_family&&(t["font-family"]=v.textpanel_title_font_family),null!==v.textpanel_title_text_align&&(t["text-align"]=v.textpanel_title_text_align),null!==v.textpanel_title_font_size&&(t["font-size"]=v.textpanel_title_font_size+"px"),null!==v.textpanel_title_bold&&(v.textpanel_title_bold===!0?t["font-weight"]="bold":t["font-weight"]="normal"),v.textpanel_css_title&&(t=jQuery.extend(t,v.textpanel_css_title)),d.css(t)}
if(1==v.textpanel_enable_description){_=c.children(".ug-textpanel-description");var i={};null!==v.textpanel_desc_color&&(i.color=v.textpanel_desc_color),null!==v.textpanel_desc_font_family&&(i["font-family"]=v.textpanel_desc_font_family),null!==v.textpanel_desc_text_align&&(i["text-align"]=v.textpanel_desc_text_align),null!==v.textpanel_desc_font_size&&(i["font-size"]=v.textpanel_desc_font_size+"px"),null!==v.textpanel_desc_bold&&(v.textpanel_desc_bold===!0?i["font-weight"]="bold":i["font-weight"]="normal"),v.textpanel_css_title&&(i=jQuery.extend(i,v.textpanel_css_description)),_.css(i)}}
function a(){var e=h.getSelectedItem();p.setText(e.title,e.description)}
function s(){jQuery(h).on(h.events.ITEM_CHANGE,a)}
var l,u,d,_,g,c,h,p=this,f=new UGFunctions,m="",v={textpanel_align:"bottom",textpanel_margin:0,textpanel_text_valign:"middle",textpanel_padding_top:10,textpanel_padding_bottom:10,textpanel_height:null,textpanel_padding_title_description:5,textpanel_padding_right:11,textpanel_padding_left:11,textpanel_fade_duration:200,textpanel_enable_title:!0,textpanel_enable_description:!0,textpanel_enable_bg:!0,textpanel_bg_color:"#000000",textpanel_bg_opacity:.4,textpanel_title_color:null,textpanel_title_font_family:null,textpanel_title_text_align:null,textpanel_title_font_size:null,textpanel_title_bold:null,textpanel_css_title:{},textpanel_desc_color:null,textpanel_desc_font_family:null,textpanel_desc_text_align:null,textpanel_desc_font_size:null,textpanel_desc_bold:null,textpanel_css_description:{},textpanel_desc_style_as_title:!1,textpanel_bg_css:{}},b={isFirstTime:!0,setInternalHeight:!0};this.positionElements=function(t){if(!v.textpanel_height||"top"==v.textpanel_text_valign)return e(t),!1;switch(v.textpanel_text_valign){default:case"top":e(!1);break;case"bottom":n();break;case"center":case"middle":i()}},this.init=function(e,t,i){if(h=e,i&&(m=i,t=f.convertCustomPrefixOptions(t,m,"textpanel")),t&&(v=jQuery.extend(v,t)),0==v.textpanel_enable_title&&0==v.textpanel_enable_description)throw new Error("Textpanel Error: The title or description must be enabled");v.textpanel_height&&v.textpanel_height<0&&(v.textpanel_height=null),1==v.textpanel_desc_style_as_title&&(v.textpanel_desc_color||(v.textpanel_desc_color=v.textpanel_title_color),v.textpanel_desc_bold||(v.textpanel_desc_bold=v.textpanel_title_bold),v.textpanel_desc_font_family||(v.textpanel_desc_font_family=v.textpanel_title_font_family),v.textpanel_desc_font_size||(v.textpanel_desc_font_size=v.textpanel_title_font_size),v.textpanel_desc_text_align||(v.textpanel_desc_text_align=v.textpanel_title_text_align))},this.appendHTML=function(e,t){u=e,t=t?" "+t:"";var i="<div class='ug-textpanel"+t+"'>";1==v.textpanel_enable_bg&&(i+="<div class='ug-textpanel-bg"+t+"'></div>"),i+="<div class='ug-textpanel-textwrapper"+t+"'>",1==v.textpanel_enable_title&&(i+="<div class='ug-textpanel-title"+t+"'></div>"),1==v.textpanel_enable_description&&(i+="<div class='ug-textpanel-description"+t+"'></div>"),i+="</div></div>",e.append(i),l=e.children(".ug-textpanel"),c=l.children(".ug-textpanel-textwrapper"),o()},this.destroy=function(){jQuery(h).off(h.events.ITEM_CHANGE)},this.run=function(){p.setSizeByParent(),s()},this.setPanelSize=function(e,t){if(b.setInternalHeight=!0,t)b.setInternalHeight=!1;else var t=80;v.textpanel_height&&(t=v.textpanel_height),l.width(e),l.height(t),g&&(g.width(e),g.height(t));var i=e-v.textpanel_padding_left-v.textpanel_padding_right,n=v.textpanel_padding_left;f.setElementSizeAndPosition(c,n,0,i,t),d&&d.width(i),_&&_.width(i),0==b.isFirstTime&&p.positionElements(!1)},this.setSizeByParent=function(){var e=f.getElementSize(u);p.setPanelSize(e.width)},this.setTextPlain=function(e,t){d&&d.html(e),_&&_.html(t)},this.setText=function(e,t){1==b.isFirstTime?(p.setTextPlain(e,t),b.isFirstTime=!1,p.positionElements(!1)):c.stop().fadeTo(v.textpanel_fade_duration,0,function(){p.setTextPlain(e,t),p.positionElements(!0),jQuery(this).fadeTo(v.textpanel_fade_duration,1)})},this.positionPanel=function(e,t){var i={};if(void 0!==e&&null!==e)i.top=e,i.bottom="auto";else switch(v.textpanel_align){case"top":i.top=v.textpanel_margin+"px";break;case"bottom":i.top="auto",i.bottom=v.textpanel_margin+"px";break;case"middle":i.top=f.getElementRelativePos(l,"middle",v.textpanel_margin)}
void 0!==t&&null!==t&&(i.left=t),l.css(i)},this.setOptions=function(e){m&&(e=f.convertCustomPrefixOptions(e,m,"textpanel")),v=jQuery.extend(v,e)},this.getElement=function(){return l},this.getSize=function(){var e=f.getElementSize(l);return e},this.refresh=function(e,t,i,n){o(),i?p.setPanelSize(i,n):p.setSizeByParent(),p.positionElements(!1),t!==!0&&p.positionPanel(),e===!0&&p.show()},this.hide=function(){l.hide()},this.show=function(){l.show()},this.getOptions=function(){return v},this.getOption=function(e){return 0==v.hasOwnProperty(e)?null:v[e]}}
function UGZoomButtonsPanel(){function e(e){return e?e.hasClass("ug-zoompanel-button-disabled")?!0:!1:!0}
function t(e){e&&e.addClass("ug-zoompanel-button-disabled")}
function i(e){e&&e.removeClass("ug-zoompanel-button-disabled")}
function n(){if(0==d.isCurrentSlideType("image"))return!0;var n=d.isCurrentSlideImageFit();1==n?0==e(s)&&(t(s),t(l)):1==e(s)&&(i(s),i(l))}
var r,o,a,s,l,u=this,d=new UGSlider,_=new UGFunctions,g={slider_zoompanel_skin:""};this.init=function(e,t){d=e,t&&(g=jQuery.extend(g,t))},this.appendHTML=function(e){o=e;var t="<div class='ug-slider-control ug-zoompanel ug-skin-"+g.slider_zoompanel_skin+"'>";t+="<div class='ug-zoompanel-button ug-zoompanel-plus'></div>",t+="<div class='ug-zoompanel-button ug-zoompanel-minus ug-zoompanel-button-disabled'></div>",t+="<div class='ug-zoompanel-button ug-zoompanel-return ug-zoompanel-button-disabled'></div>",t+="</div>",e.append(t),r=e.children(".ug-zoompanel"),a=r.children(".ug-zoompanel-plus"),s=r.children(".ug-zoompanel-minus"),l=r.children(".ug-zoompanel-return")},this.setObjects=function(e,t,i){a=e,s=t,l=i,s&&s.addClass("ug-zoompanel-button-disabled"),l&&l.addClass("ug-zoompanel-button-disabled")},this.getElement=function(){return r},u.initEvents=function(){_.addClassOnHover(a,"ug-button-hover"),_.addClassOnHover(s,"ug-button-hover"),_.addClassOnHover(l,"ug-button-hover"),_.setButtonOnClick(a,function(){return 1==e(a)?!0:void d.zoomIn()}),_.setButtonOnClick(s,function(){return 1==e(s)?!0:void d.zoomOut()}),_.setButtonOnClick(l,function(){return 1==e(l)?!0:void d.zoomBack()}),jQuery(d).on(d.events.ZOOM_CHANGE,n),jQuery(d).on(d.events.ITEM_CHANGED,n)}}
function UGBullets(){function e(){var e="",t="";-1!=c.bullets_space_between&&(t=" style='margin-left:"+c.bullets_space_between+"px'");for(var i=0;l>i;i++)e+=0==i?"<div class='ug-bullet'></div>":"<div class='ug-bullet'"+t+"></div>";o.html(e)}
function t(e){if(1==s.isActive(e))return!0;var t=e.index();jQuery(s).trigger(s.events.BULLET_CLICK,t)}
function i(){var e=o.children(".ug-bullet");_.setButtonOnClick(e,t),e.on("mousedown mouseup",function(e){return!1})}
function n(e){if(0>e||e>=l)throw new Error("wrong bullet index: "+e)}
function r(){if(1==g.isInited)return!0;throw new Error("The bullets are not inited!")}
var o,a,s=this,l=0,u=new UniteGalleryMain,d=-1,_=new UGFunctions,g={isInited:!1},c={bullets_skin:"",bullets_addclass:"",bullets_space_between:-1};this.events={BULLET_CLICK:"bullet_click"},this.init=function(e,t,i){u=e,l=i?i:u.getNumItems(),g.isInited=!0,c=jQuery.extend(c,t),""==c.bullets_skin&&(c.bullets_skin=c.gallery_skin)},this.appendHTML=function(t){a=t,r();var n="";""!=c.bullets_addclass&&(n=" "+c.bullets_addclass);var s="<div class='ug-slider-control ug-bullets ug-skin-"+c.bullets_skin+n+"'>";s+="</div>",o=jQuery(s),t.append(o),e(),i()},this.updateNumBullets=function(t){l=t,e(),i()},this.getElement=function(){return o},this.setActive=function(e){r(),n(e);var t=o.children(".ug-bullet");t.removeClass("ug-bullet-active");var i=jQuery(t[e]);i.addClass("ug-bullet-active"),d=e},this.isActive=function(e){if(n(e),"number"!=typeof e)var t=e;else var t=o.children(".ug-bullet")[e];return t.hasClass("ug-bullet-active")?!0:!1}}
function UGProgressBar(){var e,t,i=this,n=0,r=new UGFunctions,o={slider_progressbar_color:"#ffffff",slider_progressbar_opacity:.6,slider_progressbar_line_width:5};this.put=function(i,n){n&&(o=jQuery.extend(o,n)),i.append("<div class='ug-progress-bar'><div class='ug-progress-bar-inner'></div></div>"),e=i.children(".ug-progress-bar"),t=e.children(".ug-progress-bar-inner"),t.css("background-color",o.slider_progressbar_color),e.height(o.slider_progressbar_line_width),t.height(o.slider_progressbar_line_width),t.width("0%");var r=o.slider_progressbar_opacity,a=t[0];a.style.opacity=r,a.style.filter="alpha(opacity="+100*r+")"},this.putHidden=function(t,n){i.put(t,n),e.hide()},this.getElement=function(){return e},this.setSize=function(n){e.width(n),t.width(n),i.draw()},this.setPosition=function(t,i,n,o){r.placeElement(e,t,i,n,o)},this.draw=function(){var e=100*n;t.width(e+"%")},this.setProgress=function(e){n=r.normalizePercent(e),i.draw()},this.getType=function(){return"bar"}}
function UGProgressPie(){function e(e){if(!e)var e=0;var t=Math.min(a.slider_progresspie_width,a.slider_progresspie_height)/2,n=i[0].getContext("2d");0==r&&(r=!0,n.rotate(1.5*Math.PI),n.translate(-2*t,0)),n.clearRect(0,0,a.slider_progresspie_width,a.slider_progresspie_height);var o=a.slider_progresspie_width/2,s=a.slider_progresspie_height/2,l=0,u=e*Math.PI*2;if(1==a.slider_progresspie_type_fill)n.beginPath(),n.moveTo(o,s),n.arc(o,s,t,l,u),n.lineTo(o,s),n.fillStyle=a.slider_progresspie_color1,n.fill(),n.closePath();else{n.globalCompositeOperation="source-over",n.beginPath(),n.moveTo(o,s),n.arc(o,s,t,l,u),n.lineTo(o,s),n.fillStyle=a.slider_progresspie_color1,n.fill(),n.closePath(),n.globalCompositeOperation="destination-out";var d=t-a.slider_progresspie_stroke_width;n.beginPath(),n.moveTo(o,s),n.arc(o,s,d,l,u),n.lineTo(o,s),n.fillStyle=a.slider_progresspie_color1,n.fill(),n.closePath()}
1==a.slider_progresspie_type_fill&&(l=u,u=2*Math.PI,n.beginPath(),n.arc(o,s,t,l,u),n.lineTo(o,s),n.fillStyle=a.slider_progresspie_color2,n.fill(),n.closePath())}
var t,i,n=this,r=!1,o=new UGFunctions,a={slider_progresspie_type_fill:!1,slider_progresspie_color1:"#B5B5B5",slider_progresspie_color2:"#E5E5E5",slider_progresspie_stroke_width:6,slider_progresspie_width:30,slider_progresspie_height:30};this.put=function(e,t){t&&(a=jQuery.extend(a,t)),e.append("<canvas class='ug-canvas-pie' width='"+a.slider_progresspie_width+"' height='"+a.slider_progresspie_height+"'></canvas>"),i=e.children(".ug-canvas-pie")},this.putHidden=function(t,r){n.put(t,r),e(.1),i.hide()},this.getElement=function(){return i},this.setPosition=function(e,t){o.placeElement(i,e,t)},this.getSize=function(){var e={width:a.slider_progresspie_width,height:a.slider_progresspie_height};return e},this.setProgress=function(i){i=o.normalizePercent(i),t=i,e(i)},this.getType=function(){return"pie"}}
function UGTouchSliderControl(){function e(e){if(!e)var e=m.getSlidesReference();var t=v.getElementSize(e.objCurrentSlide),i=-t.left,n=v.getElementSize(h),r=i-n.left;return r}
function t(){var t=m.getSlidesReference(),i=e(t),n=Math.round(3*t.objCurrentSlide.width()/8);if(Math.abs(i)>=n)return!0;var r=Math.abs(b.lastMouseX-b.startMouseX);Math.abs(b.lastMouseY-b.startMouseY);if(20>r)return!1;var o=jQuery.now(),a=o-b.startTime;return 500>a?!0:!1}
function i(e){if(1==m.isInnerInPlace())return!1;if(p.trigger(m.events.BEFORE_RETURN),!e)var e=m.getSlidesReference();var t=v.getElementSize(e.objCurrentSlide),i=-t.left;h.animate({left:i+"px"},{duration:f.slider_transition_return_speed,easing:f.slider_transition_continuedrag_easing,queue:!1,progress:function(e,t,n){if(1==b.isDragVideo){var r=v.getElementSize(h),o=r.left,a=o-i,s=b.videoStartX+a;b.videoObject.css("left",s)}},complete:function(){p.trigger(m.events.AFTER_RETURN)}})}
function n(e){m.getVideoObject().hide(),m.switchSlideNums(e),m.placeNabourItems()}
function r(){var t=m.getSlidesReference(),r=e(t);if(0==r)return!1;var o=r>0?"left":"right",a=!1;switch(o){case"right":if(m.isSlideHasItem(t.objPrevSlide))var s=v.getElementSize(t.objPrevSlide),l=-s.left;else a=!0;break;case"left":if(m.isSlideHasItem(t.objNextSlide))var u=v.getElementSize(t.objNextSlide),l=-u.left;else a=!0}
1==a?i(t):h.stop().animate({left:l+"px"},{duration:f.slider_transition_continuedrag_speed,easing:f.slider_transition_continuedrag_easing,queue:!1,progress:function(){if(1==b.isDragVideo){var e=v.getElementSize(h),t=e.left,i=t-b.startPosx,n=b.videoStartX+i;b.videoObject.css("left",n)}},always:function(){n(o),p.trigger(m.events.AFTER_DRAG_CHANGE)}})}
function o(e){var t=b.lastMouseX-b.startMouseX;if(0==t)return!0;var i=0>t?"left":"right",n=m.getObjZoom();if(n){var r=n.isPanEnabled(e,i);if(1==r)return b.isInitDataValid=!1,!0;if(0==b.isInitDataValid)return a(e),!0}
var o=b.startPosx+t;if(t>0&&o>0)o/=3;else if(0>t){var s=o+h.width(),l=c.width();l>s&&(o=b.startPosx+t/3)}
if(0==b.isDragging&&(b.isDragging=!0,p.trigger(m.events.START_DRAG)),h.css("left",o+"px"),1==b.isDragVideo){var u=o-b.startPosx,d=b.videoStartX+u;b.videoObject.css("left",d)}}
function a(e){var t=v.getMousePosition(e);b.startMouseX=t.pageX,b.startMouseY=t.pageY,b.lastMouseX=b.startMouseX,b.lastMouseY=b.startMouseY,b.startTime=jQuery.now();var i=v.getArrTouches(e);b.startArrTouches=v.getArrTouchPositions(i);var n=v.getElementSize(h);b.startPosx=n.left,b.isInitDataValid=!0,b.isDragVideo=!1,v.storeEventData(e,b.storedEventID)}
function s(e){b.touch_active=!1}
function l(e,t){b.touch_active=!0,a(t)}
function u(e){e.preventDefault(),b.isDragging=!1,1==m.isAnimating()&&h.stop(!0,!0);var t=v.getArrTouches(e);return t.length>1?(1==b.touch_active&&s("1"),!0):1==b.touch_active?!0:void l("1",e)}
function d(e){if(0==b.touch_active)return!0;if(0==e.buttons)return s("2"),r(),!0;v.updateStoredEventData(e,b.storedEventID),e.preventDefault();var t=v.getMousePosition(e);b.lastMouseX=t.pageX,b.lastMouseY=t.pageY;var i=null;1==f.slider_vertical_scroll_ondrag&&(i=v.handleScrollTop(b.storedEventID)),"vert"!==i&&o(e)}
function _(e){var n=v.getArrTouches(e),o=n.length,a=m.isInnerInPlace();if(1==a&&0==b.touch_active&&0==o)return!0;if(0==o&&1==b.touch_active){s("3");var u=!1,d=v.wasVerticalScroll(b.storedEventID);0==d&&(u=t()),1==u?r():i()}else 1==o&&0==b.touch_active&&l("2",e)}
function g(){c.bind("mousedown touchstart",u),jQuery("body").bind("mousemove touchmove",d),jQuery(window).add("body").bind("mouseup touchend",_)}
var c,h,p,f,m=new UGSlider,v=new UGFunctions,f={slider_transition_continuedrag_speed:250,slider_transition_continuedrag_easing:"linear",slider_transition_return_speed:300,slider_transition_return_easing:"easeInOutQuad"},b={touch_active:!1,startMouseX:0,startMouseY:0,lastMouseX:0,lastMouseY:0,startPosx:0,startTime:0,isInitDataValid:!1,slides:null,lastNumTouches:0,isDragging:!1,storedEventID:"touchSlider",videoStartX:0,isDragVideo:!1,videoObject:null};this.isTapEventOccured=function(t){var i=v.getArrTouches(t),n=i.length;if(0!=n||0!=b.lastNumTouches)return b.lastNumTouches=n,!1;b.lastNumTouches=n;var r=m.getSlidesReference(),o=(e(r),Math.abs(b.lastMouseX-b.startMouseX)),a=Math.abs(b.lastMouseY-b.startMouseY),s=jQuery.now(),l=s-b.startTime;return 20>o&&50>a&&500>l?!0:!1},this.init=function(e,t){m=e,p=jQuery(m),g_objects=e.getObjects(),c=g_objects.g_objSlider,h=g_objects.g_objInner,f=jQuery.extend(f,t),g()},this.getLastMousePos=function(){var e={pageX:b.lastMouseX,pageY:b.lastMouseY};return e},this.isTouchActive=function(){return b.touch_active}}
function UGZoomSliderControl(){function e(e,t){T=e,w=jQuery(T),g_objects=e.getObjects(),y=g_objects.g_objSlider,I=g_objects.g_objInner,S=jQuery.extend(S,t),b()}
function t(){var e=T.getScaleMode();return"down"!=e&&(e="fit"),e}
function i(){var e=jQuery.now(),i=e-P.storeImageLastTime;if(20>i)return!1;var n=T.getSlidesReference();if(P.objSlide=n.objCurrentSlide,P.objImage=n.objCurrentSlide.find("img"),0==P.objImage.length)return!1;P.objImageSize=E.getElementSize(P.objImage),P.objParent=P.objImage.parent(),P.objParentSize=E.getElementSize(P.objParent);var r=t();objPadding=T.getObjImagePadding(),P.objFitImageSize=E.getImageInsideParentDataByImage(P.objImage,r,objPadding);var e=jQuery.now();return P.storeImageLastTime=e,!0}
function n(e,i){var n=T.getSlidesReference(),r=n.objCurrentSlide.find("img"),o=t();w.trigger(T.events.ZOOM_START);var a=!0,s=T.getObjImagePadding();if("back"==e){var l=E.getImageOriginalSize(r);E.scaleImageFitParent(r,l.width,l.height,o,s)}else{var u="in"==e?!0:!1;a=E.zoomImageInsideParent(r,u,S.slider_zoom_step,i,o,S.slider_zoom_max_ratio,s)}
1==a&&(w.trigger(T.events.ZOOMING),w.trigger(T.events.ZOOM_CHANGE),w.trigger(T.events.ZOOM_END))}
function r(e,t,i){var n=E.getArrTouches(t);if(i===!0){if(1!=n.length)return!1}else if(n.length>1)return!1;return E.isElementBiggerThenParent(e)?!0:!1}
function o(e){var t=E.getMousePosition(e);P.startMouseX=t.pageX,P.startMouseY=t.pageY,P.lastMouseX=P.startMouseX,P.lastMouseY=P.startMouseY,P.startImageX=P.objImageSize.left,P.startImageY=P.objImageSize.top,P.panXActive=P.objImageSize.width>P.objParentSize.width,P.panYActive=P.objImageSize.height>P.objParentSize.height}
function a(e){P.isPanActive=!0,o(e)}
function s(e){if(void 0==P.objImage||0==P.objImage.length)return!0;var t=E.getMousePosition(e),i=(t.pageX-P.startMouseX,t.pageY-P.startMouseY,t.pageX-P.lastMouseX),n=t.pageY-P.lastMouseY,r=0>i?"left":"right",o=0>n?"up":"down";P.lastMouseX=t.pageX,P.lastMouseY=t.pageY;var a=E.getElementSize(P.objImage);0==P.panYActive?n=0:"down"==o&&a.top>0?n/=3:"up"==o&&a.bottom<P.objParentSize.height&&(n/=3),0==P.panXActive||0==T.isInnerInPlace()?i=0:"right"==r&&a.left>0?i/=3:"left"==r&&a.right<P.objParentSize.width&&(i/=3);var s=a.left+i,l=a.top+n;E.placeElement(P.objImage,s,l)}
function l(){var e=!1,t=!1,i=0,n=0,r=E.getElementSize(P.objImage),o=T.getObjImagePadding(),a=E.getElementCenterPosition(P.objImage,o);P.panXActive=P.objImageSize.width>P.objParentSize.width,P.panYActive=P.objImageSize.height>P.objParentSize.height,1==P.panYActive?r.top>0?(n=0,t=!0):r.bottom<P.objParentSize.height&&(n=P.objParentSize.height-r.height,t=!0):r.top!=a.top&&(t=!0,n=a.top),1==P.panXActive?r.left>0?(i=0,e=!0):r.right<P.objParentSize.width&&(i=P.objParentSize.width-r.width,e=!0):r.left!=a.left&&(e=!0,i=a.left);var s={};1==t&&(s.top=n+"px"),1==e&&(s.left=i+"px"),(1==t||1==e)&&P.objImage.animate(s,{duration:S.slider_zoom_return_pan_duration,easing:S.slider_zoom_return_pan_easing,queue:!1})}
function u(){return P.objImage&&P.objImage.is(":animated")?!0:!1}
function d(e){P.isZoomActive=!0,P.startDistance=E.getDistance(e[0].pageX,e[0].pageY,e[1].pageX,e[1].pageY),0==P.startDistance&&(P.startDistance=1),P.startMiddlePoint=E.getMiddlePoint(e[0].pageX,e[0].pageY,e[1].pageX,e[1].pageY),P.objImageSize=E.getElementSize(P.objImage),P.startImageX=P.objImageSize.left,P.startImageY=P.objImageSize.top,P.imageOrientPoint=E.getElementLocalPoint(P.startMiddlePoint,P.objImage);var t=E.isPointInsideElement(P.imageOrientPoint,P.objImageSize);0==t&&(P.imageOrientPoint=E.getElementCenterPoint(P.objImage)),w.trigger(T.events.ZOOM_START)}
function _(e){if(0==P.isZoomActive)return!1;var t=E.getArrTouches(e);2!=t.length&&(P.isZoomActive=!1,w.trigger(T.events.ZOOM_END))}
function g(e){if(1==P.isZoomActive)return!0;var t=E.getArrTouches(e);return 2!=t.length?!0:void d(t)}
function c(e){var t=E.getArrTouches(e),i=E.getDistance(t[0].pageX,t[0].pageY,t[1].pageX,t[1].pageY),n=i/P.startDistance,r=E.getMiddlePoint(t[0].pageX,t[0].pageY,t[1].pageX,t[1].pageY),o=P.objImageSize.width*n,a=P.objImageSize.height*n,s=E.getImageOriginalSize(P.objImage),l=1;if(s.width>0&&(l=o/s.width),l>S.slider_zoom_max_ratio)return!0;panX=-(P.imageOrientPoint.x*n-P.imageOrientPoint.x),panY=-(P.imageOrientPoint.y*n-P.imageOrientPoint.y);var u=r.x-P.startMiddlePoint.x,d=r.y-P.startMiddlePoint.y,_=P.startImageX+panX+u,g=P.startImageY+panY+d;E.setElementSizeAndPosition(P.objImage,_,g,o,a),w.trigger(T.events.ZOOMING),w.trigger(T.events.ZOOM_CHANGE)}
function h(){if(void 0==P.objImage||0==P.objImage.length)return!0;var e=E.getElementSize(P.objImage);if(e.width<P.objFitImageSize.imageWidth){P.objImage.css({position:"absolute",margin:"none"});var t={top:P.objFitImageSize.imageTop+"px",left:P.objFitImageSize.imageLeft+"px",width:P.objFitImageSize.imageWidth+"px",height:P.objFitImageSize.imageHeight+"px"};P.objImage.animate(t,{duration:S.slider_zoom_return_pan_duration,easing:S.slider_zoom_return_pan_easing,queue:!1})}else l()}
function p(e){if(0==T.isCurrentSlideType("image"))return!0;i();return void 0==P.objImage||0==P.objImage.length?!0:(e.preventDefault(),1==u()&&P.objImage.stop(!0),1==P.isZoomActive?_(e):g(e),void(1==P.isZoomActive?P.isPanActive=!1:1==r(P.objImage,e)&&1==P.isZoomedOnce&&a(e)))}
function f(e){if(0==T.isCurrentSlideType("image"))return!0;var t=jQuery(e.target);if(1==t.data("ug-button"))return!1;i();if(void 0==P.objImage||0==P.objImage.length)return!0;var n=P.isPanActive,o=P.isZoomActive;if(0==T.isInnerInPlace())return P.isZoomActive=!1,P.isPanActive=!1,!0;if(1==P.isZoomActive?_(e):g(e),1==P.isZoomActive)P.isPanActive=!1;else{var s=r(P.objImage,e,!0);1==P.isPanActive?P.isPanActive=!1:1==s&&a(e)}(n||o)&&0==P.isZoomActive&&0==P.isPanActive&&h()}
function m(e){return 0==T.isCurrentSlideType("image")?!0:void(1==P.isZoomActive?c(e):1==P.isPanActive&&s(e))}
function v(e,t,i,r){if(0==S.slider_zoom_mousewheel)return!0;if(0==T.isCurrentSlideType("image"))return!0;e.preventDefault();var o=t>0,a=E.getMousePosition(e),s=1==o?"in":"out";n(s,a)}
function b(){y.on("mousewheel",v),y.bind("mousedown touchstart",p),jQuery("body").bind("mousemove touchmove",m),jQuery(window).add("body").bind("mouseup touchend",f),w.bind(T.events.BEFORE_RETURN,function(){h()}),w.bind(T.events.ITEM_CHANGED,function(){P.isZoomedOnce=!1}),w.bind(T.events.ZOOM_CHANGE,function(){P.isZoomedOnce=!0})}
var y,I,w,T=new UGSlider,E=new UGFunctions,S={slider_zoom_step:1.2,slider_zoom_max_ratio:6,slider_zoom_return_pan_duration:400,slider_zoom_return_pan_easing:"easeOutCubic"},P={isPanActive:!1,startMouseX:0,startMouseY:0,lastMouseX:0,lastMouseY:0,startImageX:0,startImageY:0,panXActive:!1,panYActive:!1,objImage:null,objImageSize:null,objParent:null,objParentSize:null,objSlide:null,storeImageLastTime:0,isZoomActive:!1,startDistance:0,startMiddlePoint:null,imageOrientPoint:null,objFitImageSize:null,isZoomedOnce:!1};this.________EXTERNAL_____________=function(){},this.isPanEnabled=function(e,t){if(i(),void 0==P.objImage||0==P.objImage.length)return!1;if(0==P.isZoomedOnce)return!1;if(0==r(P.objImage,e))return!1;if(0==T.isInnerInPlace())return!1;if("left"==t){if(P.objImageSize.right<=P.objParentSize.width)return!1}else if(P.objImageSize.left>=0)return!1;return!0},this.init=function(t,i){e(t,i)},this.zoomIn=function(){n("in")},this.zoomOut=function(){n("out")},this.zoomBack=function(){n("back")}}
function UGWistiaAPI(){function e(){return"undefined"!=typeof Wistia}
function t(e,t,n,o,a){r=null,s=!1;var l=e+"_video",u="<div id='"+l+"' class='wistia_embed' style='width:"+n+";height:"+o+";' data-video-width='"+n+"' data-video-height='"+o+"'>&nbsp;</div>";jQuery("#"+e).html(u),r=Wistia.embed(t,{version:"v1",videoWidth:n,videoHeight:o,container:l,autoPlay:a}),s=!0,i()}
function i(){r.bind("play",function(){a.trigger(o.events.START_PLAYING)}),r.bind("pause",function(){a.trigger(o.events.STOP_PLAYING)}),r.bind("end",function(){a.trigger(o.events.STOP_PLAYING)})}
this.isAPILoaded=!1;var n,r,o=this,a=jQuery(this),s=!1;this.events={START_PLAYING:"start_playing",STOP_PLAYING:"stop_playing"},this.loadAPI=function(){return 1==g_ugWistiaAPI.isAPILoaded?!0:e()?(g_ugWistiaAPI.isAPILoaded=!0,!0):(g_ugFunctions.loadJs("fast.wistia.com/assets/external/E-v1.js",!0),void(g_ugWistiaAPI.isAPILoaded=!0))},this.doCommand=function(e){if(null==r)return!1;if(0==s)return!1;switch(e){case"play":r.play();break;case"pause":r.pause()}},this.pause=function(){o.doCommand("pause")},this.play=function(){o.doCommand("play")},this.putVideo=function(i,r,o,a,s){return e()?(t(i,r,o,a,s),!0):(this.loadAPI(),void(n=setInterval(function(){e()&&(t(i,r,o,a,s),clearInterval(n))},500)))},this.isPlayerReady=function(){return s&&r?!0:!1}}
function UGSoundCloudAPI(){function e(){return"undefined"!=typeof SC}
function t(e,t,n,a,s){r=null,g_isPlayerReady=!1;var l=e+"_iframe",u=location.protocol+"//w.soundcloud.com/player/?url=http://api.soundcloud.com/tracks/"+t;u+="&amp;buying=false&amp;liking=false&amp;download=false&amp;sharing=false&amp;show_artwork=true&show_comments=false&amp;show_playcount=true&amp;show_user=false&amp;hide_related=true&amp;visual=true&amp;start_track=0&amp;callback=true",u+=s===!0?"&amp;auto_play=true":"&amp;auto_play=false";var d="<iframe id='"+l+"' src="+u+" width='"+n+"' height='"+a+"' frameborder='0' scrolling='no' webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>";jQuery("#"+e).html(d),r=SC.Widget(l),r.bind(SC.Widget.Events.READY,function(){r&&(g_isPlayerReady=!0,i())}),o=e}
function i(){r.bind(SC.Widget.Events.PLAY,function(){s.trigger(a.events.START_PLAYING)}),r.bind(SC.Widget.Events.PAUSE,function(){s.trigger(a.events.STOP_PLAYING)}),r.bind(SC.Widget.Events.FINISH,function(){s.trigger(a.events.STOP_PLAYING)})}
this.isAPILoaded=!1;var n,r,o,a=this,s=jQuery(this);this.events={START_PLAYING:"start_playing",STOP_PLAYING:"stop_playing"},this.loadAPI=function(){return 1==g_ugSoundCloudAPI.isAPILoaded?!0:e()?(g_ugSoundCloudAPI.isAPILoaded=!0,!0):(g_ugFunctions.loadJs("w.soundcloud.com/player/api.js",!0),void(g_ugSoundCloudAPI.isAPILoaded=!0))},this.putSound=function(i,r,o,a,s){return e()?(t(i,r,o,a,s),!0):(this.loadAPI(),void(n=setInterval(function(){e()&&(t(i,r,o,a,s),clearInterval(n))},500)))},this.doCommand=function(e){if(null==r)return!1;if(0==g_isPlayerReady)return!1;switch(e){case"play":r.play();break;case"pause":r.pause()}},this.pause=function(){a.doCommand("pause")},this.play=function(){a.doCommand("play")},this.destroy=function(){g_isPlayerReady=!1,r=null,o&&(jQuery("#"+o).html(""),o=null)}}
function UGHtml5MediaAPI(){function e(){return"undefined"!=typeof mejs}
function t(e,t,n,o,a){r=null,g_isPlayerReady=!1;var s=location.protocol+"//cdnjs.cloudflare.com/ajax/libs/mediaelement/2.18.1/flashmediaelement-cdn.swf",l=location.protocol+"//cdnjs.cloudflare.com/ajax/libs/mediaelement/2.18.1/silverlightmediaelement.xap",u=e+"_video",d="";a&&a===!0&&(d="autoplay='autoplay'");var _="";t.posterImage&&(_="poster='"+t.posterImage+"'");var g="<video id='"+u+"' width='"+n+"' height='"+o+"'  controls='controls' preload='none' "+d+" "+_+">";""!=t.mp4&&(g+="<source type='video/mp4' src='"+t.mp4+"' />"),""!=t.webm&&(g+="<source type='video/webm' src='"+t.webm+"' />"),""!=t.ogv&&(g+="<source type='video/ogg' src='"+t.ogv+"' />"),g+="<object width='"+n+"' height='"+o+"' type='application/x-shockwave-flash' data='"+s+"'>",g+="<param name='movie' value='"+s+"' />",g+="<param name='flashvars' value='controls=true&file="+t.mp4+"' />",g+="</object>",g+="</video>",jQuery("#"+e).html(g),new MediaElement(u,{enablePluginDebug:!1,flashName:s,silverlightName:l,success:function(e,t){g_isPlayerReady=!0,r=e,0==a&&r.pause(),i()},error:function(e){trace(e)}})}
function i(){g_ugFunctions.addEvent(r,"play",function(){a.trigger(o.events.START_PLAYING)}),g_ugFunctions.addEvent(r,"pause",function(){a.trigger(o.events.STOP_PLAYING)}),g_ugFunctions.addEvent(r,"ended",function(){a.trigger(o.events.STOP_PLAYING)})}
this.isAPILoaded=!1;var n,r,o=this,a=jQuery(this);this.events={START_PLAYING:"start_playing",STOP_PLAYING:"stop_playing"},this.loadAPI=function(){return 1==g_ugHtml5MediaAPI.isAPILoaded?!0:e()?(g_ugHtml5MediaAPI.isAPILoaded=!0,!0):(g_ugFunctions.loadJs("cdnjs.cloudflare.com/ajax/libs/mediaelement/2.18.1/mediaelement.min.js",!0),g_ugFunctions.loadCss("cdnjs.cloudflare.com/ajax/libs/mediaelement/2.18.1/mediaelementplayer.min.css",!0),void(g_ugHtml5MediaAPI.isAPILoaded=!0))},this.putVideo=function(i,r,o,a,s){return e()?(t(i,r,o,a,s),!0):(this.loadAPI(),void(n=setInterval(function(){e()&&(t(i,r,o,a,s),clearInterval(n))},500)))},this.doCommand=function(e){if(null==r)return!1;if(0==g_isPlayerReady)return!1;switch(e){case"play":r.play();break;case"pause":r.pause()}},this.pause=function(){o.doCommand("pause")},this.play=function(){o.doCommand("play")}}
function UGVimeoAPI(){function e(){return"undefined"!=typeof Froogaloop}
function t(e,t,n,o,a){s=null,l=!1;var u=location.protocol+"//player.vimeo.com/video/"+t+"?api=1";a===!0&&(u+="&amp;byline=0&amp;autoplay=1&amp;title=0&amp;portrait=0");var d="<iframe src="+u+" width='"+n+"' height='"+o+"' frameborder='0' webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe>";jQuery("#"+e).html(d);var _=jQuery("#"+e+" iframe")[0];s=Froogaloop(_),s.addEvent("ready",function(){s&&(l=!0,i())}),r=e}
function i(){return s?(s.addEvent("cuechange",function(){1==u&&o.play()}),s.addEvent("play",function(){a.trigger(o.events.START_PLAYING)}),s.addEvent("pause",function(){a.trigger(o.events.STOP_PLAYING)}),void s.addEvent("finish",function(){a.trigger(o.events.STOP_PLAYING)})):!1}
this.isAPILoaded=!1;var n,r,o=this,a=jQuery(this),s=null,l=!1,u=!1;this.events={START_PLAYING:"start_playing",STOP_PLAYING:"stop_playing"},this.loadAPI=function(){return 1==g_ugVimeoAPI.isAPILoaded?!0:e()?(g_ugVimeoAPI.isAPILoaded=!0,!0):(g_ugFunctions.loadJs("f.vimeocdn.com/js/froogaloop2.min.js",!0),void(g_ugVimeoAPI.isAPILoaded=!0))},this.doCommand=function(e){if(null==s)return!1;if(0==l)return!1;switch(e){default:s.api(e)}},this.pause=function(){o.doCommand("pause")},this.play=function(){o.doCommand("play")},this.destroy=function(){s&&(s.api("unload"),s=null,l=!1),r&&jQuery("#"+r).html("")},this.putVideo=function(i,r,o,a,s){return e()?(t(i,r,o,a,s),!0):(this.loadAPI(),void(n=setInterval(function(){e()&&(t(i,r,o,a,s),clearInterval(n))},500)))},this.isPlayerReady=function(){return l&&s?!0:!1},this.changeVideo=function(e,t){return 0==o.isPlayerReady()?!1:(u=t,void s.api("loadVideo",e))},this.getVideoImages=function(e,t,i){var n=location.protocol+"//vimeo.com/api/v2/video/"+e+".json";jQuery.get(n,{},function(e){var n={};n.preview=e[0].thumbnail_large,n.thumb=e[0].thumbnail_medium,i(t,n)})}}
function UGYoutubeAPI(){function e(e,t,r,a,u){s&&l&&s.destroy();var d={controls:2,showinfo:_.video_youtube_showinfo,rel:0};u===!0&&(d.autoplay=1),l=!1,s=new YT.Player(e,{height:a,width:r,videoId:t,playerVars:d,events:{onReady:i,onStateChange:n}}),o=e}
function t(){return"undefined"!=typeof YT&&"undefined"!=typeof YT.Player?!0:!1}
function i(){l=!0}
function n(){if("function"!=typeof s.getPlayerState)return trace("Youtube API error: can't get player state"),!1;var e=s.getPlayerState();switch(e){case YT.PlayerState.PLAYING:u.trigger(a.events.START_PLAYING);break;default:d==YT.PlayerState.PLAYING&&u.trigger(a.events.STOP_PLAYING)}
d=e}
this.isAPILoaded=!1;var r,o,a=this,s=null,l=!1,u=jQuery(this),d=-1,_={video_youtube_showinfo:!0};this.events={START_PLAYING:"start_playing",STOP_PLAYING:"stop_playing"},this.setOptions=function(e){_=jQuery.extend(_,e)},this.putVideo=function(i,n,o,a,s){return t()?(e(i,n,o,a,s),!0):(this.loadAPI(),void(r=setInterval(function(){t()&&(e(i,n,o,a,s),clearInterval(r))},500)))},this.loadAPI=function(){return 1==g_ugYoutubeAPI.isAPILoaded?!0:"undefined"!=typeof YT?(g_ugYoutubeAPI.isAPILoaded=!0,!0):(g_ugFunctions.loadJs("www.youtube.com/player_api",!0),void(g_ugYoutubeAPI.isAPILoaded=!0))},this.doCommand=function(e,t){if(!s)return!0;if(0==l)return!1;switch(e){case"play":if("function"!=typeof s.playVideo)return!1;s.playVideo();break;case"pause":if("function"!=typeof s.pauseVideo)return!1;s.pauseVideo();break;case"seek":if("function"!=typeof s.seekTo)return!1;s.seekTo(t);break;case"stopToBeginning":var i=s.getPlayerState();switch(s.pauseVideo(),i){case YT.PlayerState.PLAYING:case YT.PlayerState.ENDED:case YT.PlayerState.PAUSED:s.seekTo(0)}}},this.play=function(){a.doCommand("play")},this.pause=function(){a.doCommand("pause")},this.destroy=function(){s&&(l=!1,s.destroy())},this.stopToBeginning=function(){a.doCommand("stopToBeginning")},this.changeVideo=function(e,t){return 0==a.isPlayerReady()?!1:void(t&&1==t?s.loadVideoById(e,0,"large"):s.cueVideoById(e,0,"large"))},this.isPlayerReady=function(){return l&&s?!0:!1},this.getVideoImages=function(e){var t={};return t.preview="https://i.ytimg.com/vi/"+e+"/sddefault.jpg",t.thumb="https://i.ytimg.com/vi/"+e+"/default.jpg",t}}
function UGVideoPlayer(){function e(){c.hide()}
function t(){h.trigger(c.events.PLAY_START),d&&d.hide()}
function i(){h.trigger(c.events.PLAY_STOP),d&&d.show()}
function n(){d&&(p.setButtonMobileReady(d),p.setButtonOnClick(d,e)),jQuery(f).on(f.events.START_PLAYING,t),jQuery(f).on(f.events.STOP_PLAYING,i),jQuery(m).on(m.events.START_PLAYING,t),jQuery(m).on(m.events.STOP_PLAYING,i),jQuery(v).on(v.events.START_PLAYING,t),jQuery(v).on(v.events.STOP_PLAYING,i),jQuery(b).on(b.events.START_PLAYING,t),jQuery(b).on(b.events.STOP_PLAYING,i),jQuery(y).on(y.events.START_PLAYING,t),jQuery(y).on(y.events.STOP_PLAYING,i)}
function r(e){var t=["youtube","vimeo","html5","soundcloud","wistia"];for(var i in t){var n=t[i];if(n!=e)switch(n){case"youtube":f.pause(),f.destroy(),s.hide();break;case"vimeo":m.pause(),m.destroy(),l.hide();break;case"html5":v.pause(),u.hide();break;case"soundcloud":b.pause(),b.destroy(),_.hide();break;case"wistia":y.pause(),g.hide()}}}
var o,a,s,l,u,d,_,g,c=this,h=jQuery(this),p=new UGFunctions,f=new UGYoutubeAPI,m=new UGVimeoAPI,v=new UGHtml5MediaAPI,b=new UGSoundCloudAPI,y=new UGWistiaAPI,I=null,w={video_enable_closebutton:!0};this.events={SHOW:"video_show",HIDE:"video_hide",PLAY_START:"video_play_start",PLAY_STOP:"video_play_stop"};var T={standAloneMode:!1,youtubeInnerID:"",vimeoPlayerID:"",html5PlayerID:"",wistiaPlayerID:"",soundCloudPlayerID:""};this.init=function(e,t,i){if(o=i,!o)throw new Error("missing gallery ID for video player, it's a must!");w=jQuery.extend(w,e),f.setOptions(w),t&&1==t&&(T.standAloneMode=!0)},this.setHtml=function(e){T.youtubeInnerID=o+"_youtube_inner",T.vimeoPlayerID=o+"_videoplayer_vimeo",T.html5PlayerID=o+"_videoplayer_html5",T.wistiaPlayerID=o+"_videoplayer_wistia",T.soundCloudPlayerID=o+"_videoplayer_soundcloud";var t="<div class='ug-videoplayer' style='display:none'>";t+="<div class='ug-videoplayer-wrapper ug-videoplayer-youtube' style='display:none'><div id='"+T.youtubeInnerID+"'></div></div>",t+="<div id='"+T.vimeoPlayerID+"' class='ug-videoplayer-wrapper ug-videoplayer-vimeo' style='display:none'></div>",t+="<div id='"+T.html5PlayerID+"' class='ug-videoplayer-wrapper ug-videoplayer-html5'></div>",t+="<div id='"+T.soundCloudPlayerID+"' class='ug-videoplayer-wrapper ug-videoplayer-soundcloud'></div>",t+="<div id='"+T.wistiaPlayerID+"' class='ug-videoplayer-wrapper ug-videoplayer-wistia'></div>",0==T.standAloneMode&&1==w.video_enable_closebutton&&(t+="<div class='ug-videoplayer-button-close'></div>"),t+="</div>",e.append(t),a=e.children(".ug-videoplayer"),s=a.children(".ug-videoplayer-youtube"),l=a.children(".ug-videoplayer-vimeo"),u=a.children(".ug-videoplayer-html5"),_=a.children(".ug-videoplayer-soundcloud"),g=a.children(".ug-videoplayer-wistia"),0==T.standAloneMode&&1==w.video_enable_closebutton&&(d=a.children(".ug-videoplayer-button-close"))},this.destroy=function(){d&&(d.off("click"),d.off("touchend")),jQuery(f).off(f.events.START_PLAYING),jQuery(f).off(f.events.STOP_PLAYING),jQuery(m).off(m.events.START_PLAYING),jQuery(m).off(m.events.STOP_PLAYING),jQuery(v).off(v.events.START_PLAYING),jQuery(v).off(v.events.STOP_PLAYING),jQuery(b).off(b.events.START_PLAYING,t),jQuery(b).off(b.events.STOP_PLAYING,i),jQuery(y).off(y.events.START_PLAYING,t),jQuery(y).off(y.events.STOP_PLAYING,i),I=null},this.initEvents=function(){n()},this.setSize=function(e,t){p.setElementSize(a,e,t),d&&p.placeElement(d,"right","top")},this.setPosition=function(e,t){p.placeElement(a,e,t)},this.getObject=function(){return a},this.show=function(){return 1==c.isVisible()?!0:(a.show(),a.fadeTo(0,1),d&&d.show(),void h.trigger(c.events.SHOW))},this.hide=function(){return 0==c.isVisible()?!0:(r(),I=null,a.hide(),void h.trigger(c.events.HIDE))},this.getActiveAPI=function(){switch(I){case"youtube":return f;case"vimeo":return m;case"wistia":return y;case"soundcloud":return b;case"html5":return v;default:return null}},this.pause=function(){var e=c.getActiveAPI();return null==e?!1:void("function"==typeof e.pause&&e.pause())},this.isVisible=function(){return a.is(":visible")},this.playYoutube=function(e,t){if("undefined"==typeof t)var t=!0;r("youtube"),s.show();var i=s.children("#"+T.youtubeInnerID);0==i.length&&s.append("<div id='"+T.youtubeInnerID+"'></div>"),1==f.isPlayerReady()&&1==T.standAloneMode?f.changeVideo(e,t):f.putVideo(T.youtubeInnerID,e,"100%","100%",t),I="youtube"},this.playVimeo=function(e,t){if("undefined"==typeof t)var t=!0;r("vimeo"),l.show(),m.isPlayerReady()&&1==T.standAloneMode?m.changeVideo(e,t):m.putVideo(T.vimeoPlayerID,e,"100%","100%",t),I="vimeo"},this.playHtml5Video=function(e,t,i,n,o){if("undefined"==typeof o)var o=!0;r("html5"),u.show();var a={ogv:e,webm:t,mp4:i,posterImage:n};v.putVideo(T.html5PlayerID,a,"100%","100%",o),I="html5"},this.playSoundCloud=function(e,t){if("undefined"==typeof t)var t=!0;r("soundcloud"),_.show(),b.putSound(T.soundCloudPlayerID,e,"100%","100%",t),I="soundcloud"},this.playWistia=function(e,t){if("undefined"==typeof t)var t=!0;r("wistia"),g.show(),y.putVideo(T.wistiaPlayerID,e,"100%","100%",t),I="wistia"}}
function ugCheckForMinJQueryVersion(){var e=g_ugFunctions.checkMinJqueryVersion("1.8.0");if(0==e)throw new Error("The gallery can run from jquery 1.8 You have jQuery "+jQuery.fn.jquery+" Please update your jQuery library.")}
function ugCheckForErrors(e,t){function i(){if("undefined"==typeof jQuery)throw new Error("jQuery library not included")}
function n(){if("function"==typeof jQuery.fn.unitegallery)return!0;var e="You have some jquery.js library include that comes after the gallery files js include.";throw e+="<br> This include eliminates the gallery libraries, and make it not work.","cms"==t?(e+="<br><br> To fix it you can:<br>&nbsp;&nbsp;&nbsp; 1. In the Gallery Settings -> Troubleshooting set option:  <strong><b>Put JS Includes To Body</b></strong> option to true.",e+="<br>&nbsp;&nbsp;&nbsp; 2. Find the double jquery.js include and remove it."):e+="<br><br> Please find and remove this jquery.js include and the gallery will work. <br> * There should be only one jquery.js include before all other js includes in the page.",new Error(e)}
try{"jquery"==t?(i(),ugCheckForMinJQueryVersion()):(ugCheckForMinJQueryVersion(),n())}catch(r){var o=r.message;if(o="Unite Gallery Error: "+o,o="<div style='font-size:16px;color:#BC0C06;max-width:900px;border:1px solid red;padding:10px;'>"+o+"</div>","jquery"==t){var a=document.getElementById(e);a.innerHTML=o,a.style.display="block"}else jQuery(e).show().html(o);return!1}
return!0}
function UniteGalleryMain(){function __________INIT_GALLERY_______(){}
function getThemeFunction(e){var t=e;return-1==t.indexOf("UGTheme_")&&(t="UGTheme_"+t),t}
function initTheme(objCustomOptions){if(objCustomOptions.hasOwnProperty("gallery_theme"))g_options.gallery_theme=objCustomOptions.gallery_theme;else{var defaultTheme=g_options.gallery_theme;0==g_ugFunctions.isThemeRegistered(defaultTheme)&&(g_options.gallery_theme=g_ugFunctions.getFirstRegisteredTheme())}
var themeFunction=getThemeFunction(g_options.gallery_theme);try{g_options.gallery_theme=eval(themeFunction)}catch(e){}
g_options.gallery_theme=eval(themeFunction),g_objTheme=new g_options.gallery_theme,g_objTheme.init(t,objCustomOptions)}
function resetOptions(){g_options=jQuery.extend({},g_temp.originalOptions),g_selectedItemIndex=-1,g_selectedItem=null,g_objSlider=void 0,g_objThumbs=void 0,g_objSlider=void 0}
function checkForStartupErrors(){try{ugCheckForMinJQueryVersion()}catch(e){throwErrorShowMessage(e.message)}"object"==typeof g_objWrapper.outerWidth()&&throwErrorShowMessage("You have some buggy script. most chances jquery-ui.js that destroy jquery outerWidth, outerHeight functions. The gallery can't run. Please update jquery-ui.js to latest version."),setTimeout(function(){ugCheckForErrors(g_galleryID,"cms")},5e3)}
function runGallery(e,i,n,r){var o="object"==typeof i;if(o&&(g_temp.objCustomOptions=i),1==g_temp.isRunFirstTime){if(g_galleryID=e,g_objWrapper=jQuery(g_galleryID),0==g_objWrapper.length)return trace("div with id: "+g_galleryID+" not found"),!1;g_objParent=g_objWrapper.parent(),checkForStartupErrors(),g_temp.originalOptions=jQuery.extend({},g_options),o&&(g_options=jQuery.extend(g_options,i)),1==g_options.gallery_enable_cache&&g_options.gallery_initial_catid&&cacheItems(g_options.gallery_initial_catid);var a=g_objWrapper.children();fillItemsArray(a),loadAPIs(),g_objWrapper.find("img").fadeTo(0,0).hide(),g_objWrapper.show(),clearInitData()}else if(t.destroy(),resetOptions(),g_options=jQuery.extend(g_options,g_temp.objCustomOptions),n){if(r&&1==g_options.gallery_enable_cache&&cacheItems(r,n),"noitems"==n)return showErrorMessage("No items in this category",""),!1;g_objWrapper.html(n);var a=g_objWrapper.children();fillItemsArray(a),loadAPIs(),g_objWrapper.children().fadeTo(0,0).hide(),g_objWrapper.show(),clearInitData()}
1==g_temp.isRunFirstTime&&1==g_options.gallery_enable_tabs&&(g_objTabs=new UGTabs,g_objTabs.init(t,g_options)),o&&modifyInitParams(g_temp.objCustomOptions),validateParams(),1==g_options.gallery_shuffle&&t.shuffleItems(),initTheme(g_temp.objCustomOptions),setGalleryHtml(),setHtmlObjectsProperties();var s=g_objWrapper.width();0==s?g_functions.waitForWidth(g_objWrapper,runGalleryActually):runGalleryActually()}
function runGalleryActually(){t.setSizeClass(),0==g_temp.isFreestyleMode&&1==g_options.gallery_preserve_ratio&&setHeightByOriginalRatio(),g_objTheme.run(),g_objTabs&&g_temp.isRunFirstTime&&g_objTabs.run(),preloadBigImages(),initEvents(),g_numItems>0&&t.selectItem(0),1==g_options.gallery_autoplay&&t.startPlayMode(),g_temp.isRunFirstTime=!1}
function showErrorMessage(e,t){if("undefined"==typeof t)var t="<b>Unite Gallery Error: </b>";e=t+e;var i="<div class='ug-error-message-wrapper'><div class='ug-error-message'>"+e+"</div></div>";g_objWrapper.children().remove(),g_objWrapper.html(i),g_objWrapper.show()}
function throwErrorShowMessage(e){throw showErrorMessage(e),new Error(e)}
function modifyInitParams(){g_options.gallery_images_preload_type||(g_options.gallery_images_preload_type="minimal"),(void 0==g_options.gallery_min_height||g_options.gallery_height<g_options.gallery_min_height)&&(g_options.gallery_min_height=0),(void 0==g_options.gallery_min_width||g_options.gallery_width<g_options.gallery_min_width)&&(g_options.gallery_min_width=0)}
function validateParams(){if(!g_options.gallery_theme)throw new Error("The gallery can't run without theme");if(jQuery.isNumeric(g_options.gallery_height)&&g_options.gallery_height<g_options.gallery_min_height)throw new Error("The <b>gallery_height</b> option must be bigger then <b>gallery_min_height option</b>");if(g_options.gallery_width<g_options.gallery_min_width)throw new Error("The <b>gallery_width</b> option must be bigger then <b>gallery_min_width option</b>")}
function setGalleryHtml(){g_objWrapper.addClass("ug-gallery-wrapper"),g_objWrapper.append("<div class='ug-overlay-disabled' style='display:none'></div>"),t.setSizeClass()}
function clearInitData(){g_objWrapper.children().remove()}
function storeLastSize(){var e=t.getSize();g_temp.lastWidth=e.width,g_temp.lastHeight=e.height}
function setHeightByOriginalRatio(){var e=t.getSize(),i=e.width/e.height;if(i!=e.orig_ratio){var n=e.width/e.orig_ratio;n=Math.round(n),n<g_options.gallery_min_height&&(n=g_options.gallery_min_height),g_objWrapper.height(n)}}
function setHtmlObjectsProperties(){var e=g_functions.getCssSizeParam(g_options.gallery_width),t={"max-width":e,"min-width":g_functions.getCssSizeParam(g_options.gallery_min_width)};if(0==g_temp.isFreestyleMode){var i=g_functions.getCssSizeParam(g_options.gallery_height);t.height=i}else t.overflow="visible";g_options.gallery_background_color&&(t["background-color"]=g_options.gallery_background_color),g_objWrapper.css(t)}
function fillItemsArray(e){g_arrItems=[];for(var t=0,i=0;i<e.length;i++){var n=jQuery(e[i]),r=n.prop("tagName").toLowerCase(),o="";if("a"==r){o=n.attr("href"),n=n.children();var r=n.prop("tagName").toLowerCase()}
var a=n.data("type");void 0==a&&(a="image");var s={};if(s.type=a,"img"==r){var l=n.data("lazyload-src");l&&""!=l&&(n.attr("src",l),jQuery.removeData(n,"lazyload-src"));var u=n.attr("src"),d=n.data("thumb");"undefined"!=typeof d&&""!=d?(s.urlThumb=d,s.urlImage=u,n.attr("src",d)):(s.urlThumb=u,s.urlImage=n.data("image")),s.title=n.attr("alt"),s.objThumbImage=n}else{if("image"==a)throw new Error("The item should not be image type");s.urlThumb=n.data("thumb"),s.title=n.data("title"),s.objThumbImage=null,s.urlImage=n.data("image")}
s.link=o,s.description=n.attr("title"),s.description||(s.description=n.data("description")),s.description||(s.description=""),s.isLoaded=!1,s.isThumbImageLoaded=!1,s.objPreloadImage=null,s.isBigImageLoadStarted=!1,s.isBigImageLoaded=!1,s.isBigImageLoadError=!1,s.imageWidth=0,s.imageHeight=0,s.thumbWidth=0,s.thumbHeight=0,s.thumbRatioByWidth=0,s.thumbRatioByHeight=0,s.addHtml=null;var _=void 0==s.urlImage||""==s.urlImage,g=void 0==s.urlThumb||""==s.urlThumb;switch(s.type){case"youtube":if(s.videoid=n.data("videoid"),_||g){var c=g_ugYoutubeAPI.getVideoImages(s.videoid);_&&(s.urlImage=c.preview),g&&(s.urlThumb=c.thumb,"img"==r&&n.attr("src",s.urlThumb))}
g_temp.isYoutubePresent=!0;break;case"vimeo":s.videoid=n.data("videoid"),g_temp.isVimeoPresent=!0;break;case"html5video":s.videoogv=n.data("videoogv"),s.videowebm=n.data("videowebm"),s.videomp4=n.data("videomp4"),g_temp.isHtml5VideoPresent=!0;break;case"soundcloud":s.trackid=n.data("trackid"),g_temp.isSoundCloudPresent=!0;break;case"wistia":s.videoid=n.data("videoid"),g_temp.isWistiaPresent=!0;break;case"custom":var h=n.children("img");h.length&&(h=jQuery(h[0]),s.urlThumb=h.attr("src"),s.title=h.attr("alt"),s.objThumbImage=h);var p=n.children().not("img:first-child");p.length&&(s.addHtml=p.clone())}
s.objThumbImage&&(s.objThumbImage.removeAttr("data-description",""),s.objThumbImage.removeAttr("data-image",""),s.objThumbImage.removeAttr("data-thumb",""),s.objThumbImage.removeAttr("title","")),s.index=t,g_arrItems.push(s),t++}
g_numItems=g_arrItems.length}
function loadAPIs(){g_temp.isYoutubePresent&&g_ugYoutubeAPI.loadAPI(),g_temp.isVimeoPresent&&g_ugVimeoAPI.loadAPI(),g_temp.isHtml5VideoPresent&&g_ugHtml5MediaAPI.loadAPI(),g_temp.isSoundCloudPresent&&g_ugSoundCloudAPI.loadAPI(),g_temp.isWistiaPresent&&g_ugWistiaAPI.loadAPI()}
function preloadBigImages(){if("visible"!=g_options.gallery_images_preload_type||g_objThumbs||(g_options.gallery_images_preload_type="minimal"),1==g_temp.isAllItemsPreloaded)return!0;switch(g_options.gallery_images_preload_type){default:case"minimal":break;case"all":jQuery(g_arrItems).each(function(){preloadItemImage(this)});break;case"visible":jQuery(g_arrItems).each(function(){var e=this,t=g_objThumbs.isItemThumbVisible(e);1==t&&preloadItemImage(e)})}}
function checkPreloadItemImage(e){if(1==e.isBigImageLoadStarted||1==e.isBigImageLoaded||1==e.isBigImageLoadError)return!1;switch(g_options.gallery_images_preload_type){default:case"minimal":break;case"all":preloadItemImage(e);break;case"visible":var t=g_objThumbs.isItemThumbVisible(e);1==t&&preloadItemImage(e)}}
function preloadItemImage(e){if(1==e.isBigImageLoadStarted||1==e.isBigImageLoaded||1==e.isBigImageLoadError)return!0;var i=e.urlImage;return""==i||void 0==i?(e.isBigImageLoadError=!0,!1):(e.isBigImageLoadStarted=!0,e.objPreloadImage=jQuery("<img/>").attr("src",i),e.objPreloadImage.data("itemIndex",e.index),e.objPreloadImage.on("load",t.onItemBigImageLoaded),e.objPreloadImage.on("error",function(){var e=jQuery(this),i=e.data("itemIndex"),n=g_arrItems[i];n.isBigImageLoadError=!0,n.isBigImageLoaded=!1;var r=jQuery(this).attr("src");console.log("Can't load image: "+r),g_objGallery.trigger(t.events.ITEM_IMAGE_UPDATED,[i,n.urlImage]),n.objThumbImage.attr("src",n.urlThumb)}),void checkAllItemsStartedPreloading())}
function preloadNearBigImages(e){if(1==g_temp.isAllItemsPreloaded)return!1;if(!e)var e=g_selectedItem;if(!e)return!0;var t=e.index,i=t-1,n=t+1;i>0&&preloadItemImage(g_arrItems[i]),g_numItems>n&&preloadItemImage(g_arrItems[n])}
function checkAllItemsStartedPreloading(){if(1==g_temp.isAllItemsPreloaded)return!1;for(var e in g_arrItems)
if(0==g_arrItems[e].isBigImageLoadStarted)return!1;g_temp.isAllItemsPreloaded=!0}
function __________END_INIT_GALLERY_______(){}
function __________EVENTS_____________(){}
function onSliderMouseEnter(e){1==g_options.gallery_pause_on_mouseover&&0==t.isFullScreen()&&1==g_temp.isPlayMode&&g_objSlider&&0==g_objSlider.isSlideActionActive()&&t.pausePlaying()}
function onSliderMouseLeave(e){if(1==g_options.gallery_pause_on_mouseover&&1==g_temp.isPlayMode&&g_objSlider&&0==g_objSlider.isSlideActionActive()){var i=g_objSlider.isCurrentSlideLoadingImage();0==i&&t.continuePlaying()}}
function onKeyPress(e){var i=jQuery(e.target);if(i.is("textarea")||i.is("select")||i.is("input"))return!0;var n=e.charCode?e.charCode:e.keyCode?e.keyCode:e.which?e.which:0;switch(n){case 39:t.nextItem(),e.preventDefault();break;case 37:t.prevItem(),e.preventDefault()}
g_objGallery.trigger(t.events.GALLERY_KEYPRESS,n)}
function onGalleryResized(){var e=t.getSize();if(0==e.width)return!0;t.setSizeClass();var e=t.getSize();(e.width!=g_temp.lastWidth||e.height!=g_temp.lastHeight)&&(1==g_options.gallery_preserve_ratio&&0==g_temp.isFreestyleMode&&setHeightByOriginalRatio(),storeLastSize(),g_objGallery.trigger(t.events.SIZE_CHANGE))}
function onThumbsChange(e){"visible"==g_options.gallery_images_preload_type&&0==g_temp.isAllItemsPreloaded&&preloadBigImages()}
function onFullScreenChange(){var e=g_functions.isFullScreen(),i=e?t.events.ENTER_FULLSCREEN:t.events.EXIT_FULLSCREEN,n=g_functions.getGlobalData("fullscreenID");return g_galleryID!==n?!0:(e?g_objWrapper.addClass("ug-fullscreen"):g_objWrapper.removeClass("ug-fullscreen"),g_objGallery.trigger(i),void onGalleryResized())}
function onItemImageUpdated(e,i){var n=t.getItem(i);checkPreloadItemImage(n)}
function onCurrentSlideImageLoadEnd(){1==t.isPlayMode()&&t.continuePlaying()}
function initEvents(){if(g_objWrapper.on("dragstart",function(e){e.preventDefault()}),g_objGallery.on(t.events.ITEM_IMAGE_UPDATED,onItemImageUpdated),g_objThumbs)switch(g_temp.thumbsType){case"strip":jQuery(g_objThumbs).on(g_objThumbs.events.STRIP_MOVE,onThumbsChange);break;case"grid":jQuery(g_objThumbs).on(g_objThumbs.events.PANE_CHANGE,onThumbsChange)}
if("advance"==g_options.gallery_mousewheel_role&&0==g_temp.isFreestyleMode&&g_objWrapper.on("mousewheel",t.onGalleryMouseWheel),storeLastSize(),jQuery(window).resize(function(){g_objWrapper.css("width","auto"),g_functions.whenContiniousEventOver("gallery_resize",onGalleryResized,g_temp.resizeDelay)}),g_functions.addFullScreenChangeEvent(onFullScreenChange),g_objSlider){if(jQuery(g_objSlider).on(g_objSlider.events.ITEM_CHANGED,function(){var e=g_objSlider.getCurrentItemIndex();-1!=e&&t.selectItem(e)}),1==g_options.gallery_pause_on_mouseover){var e=g_objSlider.getElement();e.hover(onSliderMouseEnter,onSliderMouseLeave),g_objGallery.on(t.events.ENTER_FULLSCREEN,function(){onSliderMouseLeave()})}
retriggerEvent(g_objSlider,g_objSlider.events.ACTION_START,t.events.SLIDER_ACTION_START),retriggerEvent(g_objSlider,g_objSlider.events.ACTION_END,t.events.SLIDER_ACTION_END),jQuery(g_objSlider).on(g_objSlider.events.CURRENTSLIDE_LOAD_END,onCurrentSlideImageLoadEnd)}
1==g_options.gallery_control_keyboard&&jQuery(document).keydown(onKeyPress)}
function __________GENERAL_______(){}
function cacheItems(e,t){if(t){var i=t;"noitems"!=i&&(i=jQuery(t).clone())}else var i=g_objWrapper.children().clone();g_objCache[e]=i}
function removeAllSizeClasses(e){e||(e=g_objWrapper),e.removeClass("ug-under-480"),e.removeClass("ug-under-780"),e.removeClass("ug-under-960")}
function retriggerEvent(e,t,i){jQuery(e).on(t,function(e){g_objGallery.trigger(i,[this])})}
function advanceNextStep(){var e=jQuery.now(),i=e-g_temp.playTimeLastStep;if(g_temp.playTimePassed+=i,g_temp.playTimeLastStep=e,g_temp.objProgress){var n=g_temp.playTimePassed/g_options.gallery_play_interval;g_temp.objProgress.setProgress(n)}
g_temp.playTimePassed>=g_options.gallery_play_interval&&(t.nextItem(),g_temp.playTimePassed=0)}
function unselectSeletedItem(){return null==g_selectedItem?!0:(g_objThumbs&&g_objThumbs.setThumbUnselected(g_selectedItem.objThumbWrapper),g_selectedItem=null,void(g_selectedItemIndex=-1))}
function toFakeFullScreen(){jQuery("body").addClass("ug-body-fullscreen"),g_objWrapper.addClass("ug-fake-fullscreen"),g_temp.isFakeFullscreen=!0,g_objGallery.trigger(t.events.ENTER_FULLSCREEN),g_objGallery.trigger(t.events.SIZE_CHANGE)}
function exitFakeFullscreen(){jQuery("body").removeClass("ug-body-fullscreen"),g_objWrapper.removeClass("ug-fake-fullscreen"),g_temp.isFakeFullscreen=!1,g_objGallery.trigger(t.events.EXIT_FULLSCREEN),g_objGallery.trigger(t.events.SIZE_CHANGE)}
var t=this,g_galleryID,g_objGallery=jQuery(t),g_objWrapper,g_objParent,g_objThumbs,g_objSlider,g_functions=new UGFunctions,g_objTabs,g_arrItems=[],g_numItems,g_selectedItem=null,g_selectedItemIndex=-1,g_objTheme,g_objCache={};this.events={ITEM_CHANGE:"item_change",SIZE_CHANGE:"size_change",ENTER_FULLSCREEN:"enter_fullscreen",EXIT_FULLSCREEN:"exit_fullscreen",START_PLAY:"start_play",STOP_PLAY:"stop_play",PAUSE_PLAYING:"pause_playing",CONTINUE_PLAYING:"continue_playing",SLIDER_ACTION_START:"slider_action_start",SLIDER_ACTION_END:"slider_action_end",ITEM_IMAGE_UPDATED:"item_image_updated",GALLERY_KEYPRESS:"gallery_keypress",GALLERY_BEFORE_REQUEST_ITEMS:"gallery_before_request_items"};var g_options={gallery_width:900,gallery_height:500,gallery_min_width:150,gallery_min_height:100,gallery_theme:"default",gallery_skin:"default",gallery_images_preload_type:"minimal",gallery_autoplay:!1,gallery_play_interval:3e3,gallery_pause_on_mouseover:!0,gallery_mousewheel_role:"zoom",gallery_control_keyboard:!0,gallery_carousel:!0,gallery_preserve_ratio:!0,gallery_background_color:"",gallery_debug_errors:!1,gallery_shuffle:!1,gallery_urlajax:null,gallery_enable_tabs:!1,gallery_enable_cache:!0,gallery_initial_catid:""},g_temp={objCustomOptions:{},isAllItemsPreloaded:!1,isFreestyleMode:!1,lastWidth:0,lastHeigh:0,handleResize:null,isInited:!1,isPlayMode:!1,isPlayModePaused:!1,playTimePassed:0,playTimeLastStep:0,playHandle:"",playStepInterval:33,objProgress:null,isFakeFullscreen:!1,thumbsType:null,isYoutubePresent:!1,isVimeoPresent:!1,isHtml5VideoPresent:!1,isSoundCloudPresent:!1,isWistiaPresent:!1,resizeDelay:100,isRunFirstTime:!0,originalOptions:{}};this.onItemBigImageLoaded=function(e,t){if(!t)var t=jQuery(this);var i=t.data("itemIndex"),n=g_arrItems[i];n.isBigImageLoaded=!0;var r=g_functions.getImageOriginalSize(t);n.imageWidth=r.width,n.imageHeight=r.height},this.checkFillImageSize=function(e,t){if(!t){var i=e.data("itemIndex");if(void 0===i)throw new Error("Wrong image given to gallery.checkFillImageSize");var t=g_arrItems[i]}
var n=g_functions.getImageOriginalSize(e);t.imageWidth=n.width,t.imageHeight=n.height},this.setFreestyleMode=function(){g_temp.isFreestyleMode=!0},this.attachThumbsPanel=function(e,t){g_temp.thumbsType=e,g_objThumbs=t},this.initSlider=function(e,i){if(!e)var e={};e=jQuery.extend(e,g_temp.objCustomOptions),g_objSlider=new UGSlider,g_objSlider.init(t,e,i)},this.onGalleryMouseWheel=function(e,i,n,r){e.preventDefault(),i>0?t.prevItem():t.nextItem()},this.destroy=function(){if(g_objWrapper.off("dragstart"),g_objGallery.off(t.events.ITEM_IMAGE_UPDATED),g_objThumbs)switch(g_temp.thumbsType){case"strip":jQuery(g_objThumbs).off(g_objThumbs.events.STRIP_MOVE);break;case"grid":jQuery(g_objThumbs).off(g_objThumbs.events.PANE_CHANGE)}
if(g_objWrapper.off("mousewheel"),jQuery(window).off("resize"),g_functions.destroyFullScreenChangeEvent(),g_objSlider){jQuery(g_objSlider).off(g_objSlider.events.ITEM_CHANGED);var e=g_objSlider.getElement();e.off("mouseenter"),e.off("mouseleave"),g_objGallery.off(t.events.ENTER_FULLSCREEN),jQuery(g_objSlider).off(g_objSlider.events.ACTION_START),jQuery(g_objSlider).off(g_objSlider.events.ACTION_END),jQuery(g_objSlider).off(g_objSlider.events.CURRENTSLIDE_LOAD_END)}
1==g_options.gallery_control_keyboard&&jQuery(document).off("keydown"),g_objTheme&&"function"==typeof g_objTheme.destroy&&g_objTheme.destroy(),g_objWrapper.html("")},this.getArrItems=function(){return g_arrItems},this.getObjects=function(){var e={g_galleryID:g_galleryID,g_objWrapper:g_objWrapper,g_objThumbs:g_objThumbs,g_objSlider:g_objSlider,g_options:g_options,g_arrItems:g_arrItems,g_numItems:g_numItems};return e},this.getObjSlider=function(){return g_objSlider},this.getItem=function(e){if(0>e)throw new Error("item with index: "+e+" not found");if(e>=g_numItems)throw new Error("item with index: "+e+" not found");return g_arrItems[e]},this.getWidth=function(){var e=t.getSize();return e.width},this.getHeight=function(){var e=t.getSize();return e.height},this.getSize=function(){var e=g_functions.getElementSize(g_objWrapper);return e.orig_width=g_options.gallery_width,e.orig_height=g_options.gallery_height,e.orig_ratio=e.orig_width/e.orig_height,e},this.getGalleryID=function(){var e=g_galleryID.replace("#","");return e},this.getNextItem=function(e,t){"object"==typeof e&&(e=e.index);var i=e+1;if(t!==!0&&1==g_numItems)return null;if(i>=g_numItems){if(1!=g_options.gallery_carousel&&t!==!0)return null;i=0}
var n=g_arrItems[i];return n},this.getPrevItem=function(e){"object"==typeof e&&(e=e.index);var t=e-1;if(0>t){if(1!=g_options.gallery_carousel&&forceCarousel!==!0)return null;t=g_numItems-1}
var i=g_arrItems[t];return i},this.getSelectedItem=function(){return g_selectedItem},this.getSelectedItemIndex=function(){return g_selectedItemIndex},this.getNumItems=function(){return g_numItems},this.isLastItem=function(){return g_selectedItemIndex==g_numItems-1?!0:!1},this.isFirstItem=function(){return 0==g_selectedItemIndex?!0:!1},this.getOptions=function(){return g_options},this.getElement=function(){return g_objWrapper},this.___________SET_CONTROLS___________=function(){},this.setNextButton=function(e){e.data("ug-button",!0),g_functions.setButtonOnClick(e,t.nextItem)},this.setPrevButton=function(e){e.data("ug-button",!0),g_functions.setButtonOnClick(e,t.prevItem)},this.setFullScreenToggleButton=function(e){e.data("ug-button",!0),g_functions.setButtonOnClick(e,t.toggleFullscreen),g_objGallery.on(t.events.ENTER_FULLSCREEN,function(){e.addClass("ug-fullscreenmode")}),g_objGallery.on(t.events.EXIT_FULLSCREEN,function(){e.removeClass("ug-fullscreenmode")})},this.destroyFullscreenButton=function(e){g_functions.destroyButton(e),g_objGallery.off(t.events.ENTER_FULLSCREEN),g_objGallery.off(t.events.EXIT_FULLSCREEN)},this.setPlayButton=function(e){e.data("ug-button",!0),g_functions.setButtonOnClick(e,t.togglePlayMode),g_objGallery.on(t.events.START_PLAY,function(){e.addClass("ug-stop-mode")}),g_objGallery.on(t.events.STOP_PLAY,function(){e.removeClass("ug-stop-mode")})},this.destroyPlayButton=function(e){g_functions.destroyButton(e),g_objGallery.off(t.events.START_PLAY),g_objGallery.off(t.events.STOP_PLAY)},this.setProgressIndicator=function(e){g_temp.objProgress=e},this.setTextContainers=function(e,i){g_objGallery.on(t.events.ITEM_CHANGE,function(){var n=t.getSelectedItem();e.html(n.title),i.html(n.description)})},this.showDisabledOverlay=function(){g_objWrapper.children(".ug-overlay-disabled").show()},this.hideDisabledOverlay=function(){g_objWrapper.children(".ug-overlay-disabled").hide()},this.___________END_SET_CONTROLS___________=function(){},this.___________PLAY_MODE___________=function(){},this.startPlayMode=function(){if(g_temp.isPlayMode=!0,g_temp.isPlayModePaused=!1,g_temp.playTimePassed=0,g_temp.playTimeLastStep=jQuery.now(),g_temp.playHandle=setInterval(advanceNextStep,g_temp.playStepInterval),g_temp.objProgress){var e=g_temp.objProgress.getElement();g_temp.objProgress.setProgress(0),e.show()}
g_objGallery.trigger(t.events.START_PLAY),g_objSlider&&1==g_objSlider.isCurrentSlideLoadingImage()&&t.pausePlaying()},this.resetPlaying=function(){return 0==g_temp.isPlayMode?!0:(g_temp.playTimePassed=0,void(g_temp.playTimeLastStep=jQuery.now()))},this.pausePlaying=function(){return 1==g_temp.isPlayModePaused?!0:(g_temp.isPlayModePaused=!0,clearInterval(g_temp.playHandle),void g_objGallery.trigger(t.events.PAUSE_PLAYING))},this.continuePlaying=function(){return 0==g_temp.isPlayModePaused?!0:(g_temp.isPlayModePaused=!1,g_temp.playTimeLastStep=jQuery.now(),void(g_temp.playHandle=setInterval(advanceNextStep,g_temp.playStepInterval)))},this.stopPlayMode=function(){if(g_temp.isPlayMode=!1,clearInterval(g_temp.playHandle),g_temp.playTimePassed=0,g_temp.objProgress){var e=g_temp.objProgress.getElement();e.hide()}
g_objGallery.trigger(t.events.STOP_PLAY)},this.isPlayMode=function(){return g_temp.isPlayMode},this.togglePlayMode=function(){0==t.isPlayMode()?t.startPlayMode():t.stopPlayMode()},this.___________GENERAL_EXTERNAL___________=function(){},this.shuffleItems=function(){g_arrItems=g_functions.arrayShuffle(g_arrItems);for(var e in g_arrItems)g_arrItems[e].index=parseInt(e)},this.setOptions=function(e){g_options=jQuery.extend(g_options,e)},this.selectItem=function(e,i){"number"==typeof e&&(e=t.getItem(e));var n=e.index;if(n==g_selectedItemIndex)return!0;if(unselectSeletedItem(),g_selectedItem=e,g_selectedItemIndex=n,g_objGallery.trigger(t.events.ITEM_CHANGE,[e,i]),1==g_temp.isPlayMode){t.resetPlaying();var r=g_objSlider.isCurrentSlideLoadingImage();1==r&&t.pausePlaying()}},this.nextItem=function(){var e=g_selectedItemIndex+1;return 0==g_numItems?!0:0==g_options.gallery_carousel&&e>=g_numItems?!0:(e>=g_numItems&&(e=0),void t.selectItem(e,"next"))},this.prevItem=function(){var e=g_selectedItemIndex-1;return-1==g_selectedItemIndex&&(e=0),0==g_numItems?!0:0==g_options.gallery_carousel&&0>e?!0:(0>e&&(e=g_numItems-1),void t.selectItem(e,"prev"))},this.isFullScreen=function(){return 1==g_temp.isFakeFullscreen?!0:1==g_functions.isFullScreen()?!0:!1},this.isFakeFullscreen=function(){return g_temp.isFakeFullscreen},this.toFullScreen=function(){g_functions.setGlobalData("fullscreenID",g_galleryID);var e=g_objWrapper.get(0),t=g_functions.toFullscreen(e);0==t&&toFakeFullScreen()},this.exitFullScreen=function(){1==g_temp.isFakeFullscreen?exitFakeFullscreen():g_functions.exitFullscreen()},this.toggleFullscreen=function(){0==t.isFullScreen()?t.toFullScreen():t.exitFullScreen()},this.resize=function(e,t,i){g_objWrapper.css("width","auto"),g_objWrapper.css("max-width",e+"px"),t&&g_objWrapper.height(t),i||i===!0||onGalleryResized()},this.setSizeClass=function(e,i){if(!e)var e=g_objWrapper;if(!i)var n=t.getSize(),i=n.width;var r="";return 480>=i?r="ug-under-480":780>=i?r="ug-under-780":960>i&&(r="ug-under-960"),1==e.hasClass(r)?!0:(removeAllSizeClasses(e),void(""!=r&&e.addClass(r)))},this.isMobileMode=function(){return g_objWrapper.hasClass("ug-under-480")?!0:!1},this.changeItems=function(e,t){if(!e)var e="noitems";runGallery(g_galleryID,"nochange",e,t)},this.showErrorMessageReplaceGallery=function(e){showErrorMessage(e)},this.__________AJAX_REQUEST_______=function(){},this.ajaxRequest=function(e,t,i,n){var r="html";if(1==i&&(r="json"),!n||"function"!=typeof n)throw new Error("ajaxRequest error: success function should be passed");var o=g_options.gallery_urlajax;if(""==o)throw new Error("ajaxRequest error: Ajax url don't passed");if("undefined"==typeof t)var t={};var a={action:"unitegallery_ajax_action",client_action:e,galleryID:g_galleryID,data:t};jQuery.ajax({type:"post",url:g_options.gallery_urlajax,dataType:"json",data:a,success:function(e){return e?-1==e||0===e?(showErrorMessage("ajax error!!!"),!1):"undefined"==typeof e.success?(showErrorMessage("The 'success' param is a must!"),!1):0==e.success?(showErrorMessage(e.message),!1):void n(e):(showErrorMessage("Empty ajax response!","Ajax Error"),!1)},error:function(e,t,i){console.log("Ajax Error!!! "+t)}})},this.requestNewItems=function(e,i,n){var r=g_options.gallery_enable_cache;if(n||(n=e),1==i&&(r=!1),1==r&&g_objCache.hasOwnProperty(n)){var o=g_objCache[n];t.changeItems(o,n)}else g_objGallery.trigger(t.events.GALLERY_BEFORE_REQUEST_ITEMS),t.ajaxRequest("front_get_cat_items",{catid:e},!0,function(e){var i=e.html;t.changeItems(i,n)})},this.run=function(e,t){g_options.gallery_debug_errors;if(t&&t.hasOwnProperty("gallery_debug_errors")&&(g_options.gallery_debug_errors=t.gallery_debug_errors),1==g_options.gallery_debug_errors)try{runGallery(e,t)}catch(i){if("object"==typeof i){var n=i.message,r=i.lineNumber,o=i.fileName;i.stack;n+=" <br><br> in file: "+o,n+=" <b> line "+r+"</b>",trace(i)}else var n=i;n=n.replace("Error:",""),showErrorMessage(n)}else runGallery(e,t)}}
function UGLightbox(){function e(e,i){ee=e,B=jQuery(e),re=jQuery.extend(re,ae),re=jQuery.extend(re,i),oe.originalOptions=jQuery.extend({},re),"compact"==re.lightbox_type&&(oe.isCompact=!0,re=jQuery.extend(re,se),re=jQuery.extend(re,i)),t(),1==oe.putSlider?(ee.initSlider(re,"lightbox"),g_objects=e.getObjects(),te=g_objects.g_objSlider):te=null,1==re.lightbox_show_textpanel?ne.init(ee,re,"lightbox"):ne=null}
function t(){1==oe.isCompact&&1==re.lightbox_show_textpanel&&(re.lightbox_slider_image_padding_bottom=oe.initTextPanelHeight),1==oe.isCompact&&"inside"==re.lightbox_arrows_position&&(oe.isArrowsInside=!0),1==oe.isArrowsInside&&0==re.lightbox_arrows_inside_alwayson&&(oe.isArrowsOnHoverMode=!0)}
function i(){var e="",t="";1==oe.isCompact&&(t=" ug-lightbox-compact"),e+="<div class='ug-gallery-wrapper ug-lightbox"+t+"'>",e+="<div class='ug-lightbox-overlay'></div>",0==oe.isCompact&&(e+="<div class='ug-lightbox-top-panel'>"),e+="<div class='ug-lightbox-top-panel-overlay'></div>",e+="<div class='ug-lightbox-button-close'></div>",re.lightbox_show_numbers&&(e+="<div class='ug-lightbox-numbers'></div>"),0==oe.isCompact&&(e+="</div>"),e+="<div class='ug-lightbox-arrow-left'></div>",e+="<div class='ug-lightbox-arrow-right'></div>",e+="</div>",Y=jQuery(e),jQuery("body").append(Y),te&&te.setHtml(Y),U=Y.children(".ug-lightbox-overlay"),0==oe.isCompact&&(K=Y.children(".ug-lightbox-top-panel")),Z=Y.find(".ug-lightbox-button-close"),re.lightbox_show_numbers&&(q=Y.find(".ug-lightbox-numbers")),V=Y.children(".ug-lightbox-arrow-left"),X=Y.children(".ug-lightbox-arrow-right"),ne&&(K?ne.appendHTML(K):ne.appendHTML(Y))}
function n(){if(null!==re.lightbox_overlay_color&&U.css("background-color",re.lightbox_overlay_color),null!==re.lightbox_overlay_opacity&&U.fadeTo(0,re.lightbox_overlay_opacity),K&&null!==re.lightbox_top_panel_opacity&&K.children(".ug-lightbox-top-panel-overlay").fadeTo(0,re.lightbox_top_panel_opacity),q){var e={};null!==re.lightbox_numbers_size&&(e["font-size"]=re.lightbox_numbers_size+"px"),re.lightbox_numbers_color&&(e.color=re.lightbox_numbers_color),null!==re.lightbox_numbers_padding_right&&(e["padding-right"]=re.lightbox_numbers_padding_right+"px"),null!==re.lightbox_numbers_padding_top&&(e["padding-top"]=re.lightbox_numbers_padding_top+"px"),q.css(e)}}
function r(e){if(!te)return!0;var t={slider_image_padding_top:e,slider_video_padding_top:e};te.setOptions(t),te.refreshSlideItems()}
function o(){if(!K)return!1;if(!ne)return!1;var e=K.height();if(0==e)return!1;var t=e,i=ne.getSize().height;e!=oe.topPanelHeight&&(t=oe.topPanelHeight),i>t&&(t=i),e!=t&&(K.height(t),te&&0==te.isAnimating()&&r(t))}
function a(e){var t={},i=re.lightbox_textpanel_width,n=47,r=40,a=e.width-n-r;i>a?(t.textpanel_padding_left=n,t.textpanel_padding_right=r,t.textpanel_title_text_align="center",t.textpanel_desc_text_align="center"):(t.textpanel_padding_left=Math.floor((e.width-i)/2),t.textpanel_padding_right=t.textpanel_padding_left,t.textpanel_title_text_align="left",t.textpanel_desc_text_align="left",re.lightbox_textpanel_title_text_align&&(t.textpanel_title_text_align=re.lightbox_textpanel_desc_text_align),re.lightbox_textpanel_desc_text_align&&(t.textpanel_desc_text_align=re.lightbox_textpanel_desc_text_align)),ne.setOptions(t),ne.refresh(!0,!0),o(),ne.positionPanel()}
function s(e){if(0==oe.isOpened)return!1;if(!ne)return!1;if(!te)return!1;var t=ie.getElementSize(Y),i=ne.getSize();if(0==i.width||i.height>120)return!1;if(!e)var n=te.getSlideImage(),e=ie.getElementSize(n);if(0==e.height||0==e.width)return!1;var r=e.bottom+i.height;if(r<t.height)return!1;var o=te.getOptions(),a=i.height;if(a!=o.slider_image_padding_bottom){var s={slider_image_padding_bottom:a};if(0==te.isAnimating())return te.setOptions(s),te.refreshSlideItems(),!0}
return!1}
function l(e,t){if(!e)var i=te.getSlideImage(),e=ie.getElementSize(i);oe.textPanelTop=e.bottom,t===!0&&ne.positionPanel(oe.textPanelTop,oe.textPanelLeft)}
function u(e){var t=(ie.getElementSize(Y),te.getSlideImage()),i=ie.getElementSize(t);if(0==i.width)return!1;oe.textPanelLeft=i.left,oe.textPanelTop=i.bottom;var n=i.width;if(q){var r=ie.getElementSize(q);n-=r.width;var o=i.right-r.width;ie.placeElement(q,o,oe.textPanelTop)}
ne&&(ne.show(),ne.refresh(!0,!0,n),l(i));var a=s(i);0==a&&(oe.positionFrom="handleCompactTextpanelSizes",ne&&(ne.positionPanel(oe.textPanelTop,oe.textPanelLeft),e===!0&&(e(),P())))}
function d(){if(0==te.isCurrentSlideType("image"))return!0;var e=1==te.isCurrentImageInPlace();return e}
function _(e,t){if(0==oe.isArrowsInside)return!1;if(!V)return!1;var i=d();if(V.show(),X.show(),oe.positionFrom="positionArrowsInside",1==oe.isArrowsOnHoverMode&&1==i&&0==v()&&b(!0),0==i)var n=ie.getElementRelativePos(V,"left",re.lightbox_arrows_offset),r=ie.getElementRelativePos(V,"middle"),o=ie.getElementRelativePos(X,"right",re.lightbox_arrows_offset),a=r;else var s=te.getSlideImage(),l=ie.getElementSize(s),n=(ie.getElementSize(te.getElement()),ie.getElementRelativePos(V,"left",0,s)+l.left+re.lightbox_arrows_inside_offset),r=ie.getElementRelativePos(V,"middle",0,s)+l.top,o=ie.getElementRelativePos(V,"right",0,s)+l.left-re.lightbox_arrows_inside_offset,a=r;if(t===!0){var u={left:n,top:r},_={left:o,top:a};V.stop().animate(u,{duration:oe.fadeDuration}),X.stop().animate(_,{duration:oe.fadeDuration})}else V.stop(),X.stop(),ie.placeElement(V,n,r),ie.placeElement(X,o,a);1==e&&I(t)}
function g(e,t){oe.positionFrom=null;var i=d(),n=2,r=ie.getElementRelativePos(Z,"right",2,Y);if(0==i)var o=n,a=r;else{var s=te.getSlideImage(),l=ie.getElementSize(s),u=ie.getElementSize(te.getElement()),_=ie.getElementSize(Z);u.top==u.height&&(u.top=0);var a=u.left+l.right-_.width/2+re.lightbox_compact_closebutton_offsetx,o=u.top+l.top-_.height/2-re.lightbox_compact_closebutton_offsety;n>o&&(o=n),a>r&&(a=r)}
if(t===!0){var g={left:a,top:o};Z.stop().animate(g,{duration:oe.fadeDuration})}else Z.stop(),ie.placeElement(Z,a,o);e===!0&&w(t)}
function c(){Z&&Z.stop().fadeTo(oe.fadeDuration,0),f(),m(),oe.positionFrom="hideCompactElements",1==oe.isArrowsInside&&b()}
function h(){Z&&Z.hide(),V&&1==oe.isArrowsInside&&(V.hide(),X.hide()),q&&q.hide(),ne&&ne.hide()}
function p(){var e=ie.getElementSize(Y);K&&ie.setElementSizeAndPosition(K,0,0,e.width,oe.topPanelHeight),V&&0==oe.isArrowsInside&&(1==re.lightbox_hide_arrows_onvideoplay&&(V.show(),X.show()),ie.placeElement(V,"left","middle",re.lightbox_arrows_offset),ie.placeElement(X,"right","middle",re.lightbox_arrows_offset)),0==oe.isCompact&&ie.placeElement(Z,"right","top",2,2),ne&&(oe.positionFrom="positionElements",0==oe.isCompact?a(e):(S(),P()));var t=e.width,i=e.height,n=0,r=0;if(te){if(K){var o=K.height(),s={slider_image_padding_top:o,slider_video_padding_top:o};te.setOptions(s)}
te.setSize(t,i),te.setPosition(r,n)}}
function f(){ne&&ne.getElement().stop().fadeTo(oe.fadeDuration,0)}
function m(){q&&q.stop().fadeTo(oe.fadeDuration,0)}
function v(){if(!oe.lastMouseX)return!0;var e={pageX:oe.lastMouseX,pageY:oe.lastMouseY},t=te.isMouseInsideSlideImage(e);return t}
function b(e,t){return V?1==oe.isArrowsOnHoverMode&&t===!1?(1==v(),!0):void(e===!0?(V.stop().fadeTo(0,0),X.stop().fadeTo(0,0)):(V.stop().fadeTo(oe.fadeDuration,0),X.stop().fadeTo(oe.fadeDuration,0))):!1}
function y(){if(!V)return!0;if(0==V.is(":visible"))return!0;var e=V.css("opacity");return 1!=e?!0:!1}
function I(e,t){return V?1==oe.isArrowsOnHoverMode&&t!==!0&&1==d()?!0:1==te.isSwiping()?!0:(e!==!0&&(V.stop(),X.stop()),V.fadeTo(oe.fadeDuration,1),void X.fadeTo(oe.fadeDuration,1)):!1}
function w(e){e!==!0&&Z.stop(),Z.fadeTo(oe.fadeDuration,1)}
function T(e){if(!ne)return!1;if(!e)var e=te.getCurrentItem();ne.setTextPlain(e.title,e.description)}
function E(e){if(!q)return!1;if(!e)var e=te.getCurrentItem();var t=ee.getNumItems(),i=e.index+1;q.html(i+" / "+t)}
function S(){return ne?void ne.getElement().show().stop().fadeTo(oe.fadeDuration,1):!1}
function P(){q&&q.stop().fadeTo(oe.fadeDuration,1)}
function x(){return 0==oe.isCompact?!0:void c()}
function j(){if(0==oe.isCompact)return!0;if(oe.positionFrom="onZoomChange",g(!1,!0),_(!1,!0),1==oe.isCompact){var e=te.isCurrentSlideType("image")&&1==te.isCurrentImageInPlace();0==e?(f(),m()):(oe.positionFrom="onZoomChange",S(),P())}}
function C(){if(0==oe.isCompact)return!0;oe.positionFrom="onSliderAfterReturn",g(!0),_(!0);var e=s();0==e&&u(),S(),P()}
function A(e,t){return t=jQuery(t),0==oe.isCompact?!0:0==te.isSlideCurrent(t)?!0:(oe.positionFrom="onSliderAfterPutImage",g(!0),_(!0),void u())}
function M(){var e=te.getOptions(),t=e.slider_image_padding_top;if(K){var i=K.height();i!=t&&r(i)}
if(1==oe.isCompact&&(T(),E(),oe.positionFrom="onSliderTransitionEnd",g(!0),_(!0),0==te.isSlideActionActive())){var n=s();0==n&&u(),S(),P()}}
function z(e,t){0==oe.isCompact?(q&&E(t),ne&&(T(t),ne.positionElements(!1),o(),ne.positionPanel())):0==te.isAnimating()&&(ne&&T(t),q&&E(t)),0==oe.isSliderChangedOnce&&(oe.isSliderChangedOnce=!0,$.trigger(J.events.LIGHTBOX_INIT))}
function O(e,t){var i=te.getSlideType();if("image"!=i&&0==oe.isCompact&&te.isSlideActionActive())return!0;var n=te.isPreloading();if(1==n)return J.close("slider"),!0;var r=te.isMouseInsideSlideImage(t);0==r&&J.close("slider_inside")}
function L(){p()}
function H(){V&&1==re.lightbox_hide_arrows_onvideoplay&&(V.hide(),X.hide())}
function k(){V&&1==re.lightbox_hide_arrows_onvideoplay&&(V.show(),X.show())}
function N(e,t){switch(t){case 27:1==oe.isOpened&&J.close("keypress")}}
function R(){1==oe.isArrowsOnHoverMode&&I(!1,!0)}
function G(e){oe.positionFrom="hideCompactElements",1==oe.isArrowsOnHoverMode&&1==d()&&b(!1,!0)}
function Q(e){oe.lastMouseX=e.pageX,oe.lastMouseY=e.pageY;var t=y();1==t&&v()&&0==te.isAnimating()&&(oe.positionFrom="onMouseMove",V&&0==V.is(":animated")&&I(!1,!0))}
function D(e,t,i,n){if(0==oe.isOpened)return!0;switch(re.gallery_mousewheel_role){default:case"zoom":var r=te.getSlideType();"image"!=r&&e.preventDefault();break;case"none":e.preventDefault();break;case"advance":ee.onGalleryMouseWheel(e,t,i,n)}}
function W(){if(U.on("touchstart",function(e){e.preventDefault()}),U.on("touchend",function(e){J.close("overlay")}),ie.addClassOnHover(X,"ug-arrow-hover"),ie.addClassOnHover(V,"ug-arrow-hover"),ie.addClassOnHover(Z),ee.setNextButton(X),ee.setPrevButton(V),Z.click(function(){J.close("button")}),B.on(ee.events.ITEM_CHANGE,z),te){jQuery(te).on(te.events.TRANSITION_END,M),jQuery(te).on(te.events.CLICK,O);var e=te.getVideoObject();jQuery(e).on(e.events.PLAY_START,H),jQuery(e).on(e.events.PLAY_STOP,k),jQuery(te).on(te.events.START_DRAG,x),jQuery(te).on(te.events.TRANSITION_START,x),jQuery(te).on(te.events.AFTER_DRAG_CHANGE,C),jQuery(te).on(te.events.AFTER_RETURN,C),jQuery(te).on(te.events.AFTER_PUT_IMAGE,A),jQuery(te).on(te.events.ZOOM_CHANGE,j),jQuery(te).on(te.events.IMAGE_MOUSEENTER,R),jQuery(te).on(te.events.IMAGE_MOUSELEAVE,G)}
jQuery(window).resize(function(){return 0==oe.isOpened?!0:void ie.whenContiniousEventOver("lightbox_resize",L,100)}),B.on(ee.events.GALLERY_KEYPRESS,N),1==oe.isArrowsOnHoverMode&&jQuery(document).bind("mousemove",Q),Y.on("mousewheel",D)}
function F(){oe.isCompact=!1,t(),re=jQuery.extend({},oe.originalOptions),trace(re),te.setOptions(re)}
var B,Y,U,V,X,Z,q,K,J=this,$=jQuery(this),ee=new UniteGalleryMain,te=new UGSlider,ie=new UGFunctions,ne=new UGTextPanel,re={lightbox_type:"wide",lightbox_show_textpanel:!0,lightbox_textpanel_width:550,lightbox_hide_arrows_onvideoplay:!0,lightbox_arrows_position:"sides",lightbox_arrows_offset:10,lightbox_arrows_inside_offset:10,lightbox_arrows_inside_alwayson:!1,lightbox_overlay_color:null,lightbox_overlay_opacity:1,lightbox_top_panel_opacity:null,lightbox_show_numbers:!0,lightbox_numbers_size:null,lightbox_numbers_color:null,lightbox_numbers_padding_top:null,lightbox_numbers_padding_right:null,lightbox_compact_closebutton_offsetx:1,lightbox_compact_closebutton_offsety:1};this.events={LIGHTBOX_INIT:"lightbox_init"};var oe={topPanelHeight:44,initTextPanelHeight:26,isOpened:!1,putSlider:!0,isCompact:!1,fadeDuration:300,positionFrom:null,textPanelTop:null,textPanelLeft:null,isArrowsInside:!1,isArrowsOnHoverMode:!1,lastMouseX:null,lastMouseY:null,originalOptions:null,isSliderChangedOnce:!1},ae={lightbox_slider_controls_always_on:!0,lightbox_slider_enable_bullets:!1,lightbox_slider_enable_arrows:!1,lightbox_slider_enable_progress_indicator:!1,lightbox_slider_enable_play_button:!1,lightbox_slider_enable_fullscreen_button:!1,lightbox_slider_enable_zoom_panel:!1,lightbox_slider_enable_text_panel:!1,lightbox_slider_scale_mode_media:"down",lightbox_slider_scale_mode:"down",lightbox_slider_loader_type:3,lightbox_slider_loader_color:"black",lightbox_slider_transition:"fade",lightbox_slider_image_padding_top:oe.topPanelHeight,lightbox_slider_image_padding_bottom:10,lightbox_slider_video_padding_top:oe.topPanelHeight,lightbox_slider_video_padding_bottom:0,lightbox_textpanel_align:"middle",lightbox_textpanel_padding_top:5,lightbox_textpanel_padding_bottom:5,slider_video_constantsize:!1,lightbox_slider_image_border:!1,lightbox_textpanel_enable_title:!0,lightbox_textpanel_enable_description:!1,lightbox_textpanel_desc_style_as_title:!0,lightbox_textpanel_enable_bg:!1,video_enable_closebutton:!1,lightbox_slider_video_enable_closebutton:!1,video_youtube_showinfo:!1,lightbox_slider_enable_links:!1},se={lightbox_overlay_opacity:.6,lightbox_slider_image_border:!0,lightbox_slider_image_shadow:!0,lightbox_slider_image_padding_top:30,lightbox_slider_image_padding_bottom:30,slider_video_constantsize:!0,lightbox_textpanel_align:"bottom",lightbox_textpanel_title_text_align:"left",lightbox_textpanel_desc_text_align:"left",lightbox_textpanel_padding_left:10,lightbox_textpanel_padding_right:10};this.destroy=function(){if(jQuery(document).unbind("mousemove"),U.off("touchstart"),U.off("touchend"),Z.off("click"),B.off(ee.events.ITEM_CHANGE),te){jQuery(te).off(te.events.TRANSITION_END),jQuery(te).off(te.events.CLICK),jQuery(te).off(te.events.START_DRAG),jQuery(te).off(te.events.TRANSITION_START),jQuery(te).off(te.events.AFTER_DRAG_CHANGE),jQuery(te).off(te.events.AFTER_RETURN);var e=te.getVideoObject();jQuery(e).off(e.events.PLAY_START),jQuery(e).off(e.events.PLAY_STOP),jQuery(te).on(te.events.IMAGE_MOUSEENTER,R),jQuery(te).on(te.events.IMAGE_MOUSELEAVE,G),te.destroy()}
jQuery(window).unbind("resize"),B.off(ee.events.GALLERY_KEYPRESS,N),Y.off("mousewheel"),Y.remove()},this.open=function(e){var t=ee.getItem(e);if(oe.isOpened=!0,te&&te.setItem(t,"lightbox_open"),ne&&ne.setTextPlain(t.title,t.description),U.stop().fadeTo(0,0),Y.show(),Y.fadeTo(0,1),U.stop().fadeTo(oe.fadeDuration,re.lightbox_overlay_opacity),p(),1==oe.isCompact){var i=te.isPreloading();1==i?h():1==oe.isArrowsInside&&(V.hide(),X.hide())}
te&&te.startSlideAction()},this.close=function(e){oe.isOpened=!1,1==oe.isCompact&&c(),te&&te.stopSlideAction();var t=te.getSlideType();"image"!=t?Y.hide():Y.fadeTo(oe.fadeDuration,0,function(){Y.hide()})},this.init=function(t,i){e(t,i)},this.putHtml=function(){var e=ee.isMobileMode();e&&1==oe.isCompact&&F(),i()},this.run=function(){n(),te&&te.run(),W()}}
function UGCarousel(){function e(e,t){g_objects=e.getObjects(),W=e,H=jQuery(e),k=g_objects.g_objWrapper,N=g_objects.g_arrItems,U=jQuery.extend(U,t),B.setFixedMode(),B.setApproveClickFunction(L),B.init(e,U),Y=B.getObjThumbs(),U=B.getOptions(),V.initTileWidth=U.tile_width,V.initTileHeight=U.tile_height,V.tileWidth=U.tile_width}
function t(e){if(!e)var e=k;var t="<div class='ug-carousel-wrapper'><div class='ug-carousel-inner'></div></div>";k.append(t),R=k.children(".ug-carousel-wrapper"),G=R.children(".ug-carousel-inner"),B.setHtml(G),Y.getThumbs().fadeTo(0,1)}
function i(e,t){if(!t)var t=V.initTileHeight/V.initTileWidth*e;V.tileWidth=e;var i={tile_width:e,tile_height:t};B.setOptions(i),U.tile_width=e,U.tile_height=t,B.resizeAllTiles(e),m(!0)}
function n(){if(null===V.carouselMaxWidth)throw new Error("The carousel width not set");if(V.tileWidth<V.initTileWidth){var e=V.carouselMaxWidth-2*U.carousel_padding;e>V.initTileWidth&&(e=V.initTileWidth),i(e);var t=F.getNumItemsInSpace(V.carouselMaxWidth,e,U.carousel_space_between_tiles)}else{var t=F.getNumItemsInSpace(V.carouselMaxWidth,V.tileWidth,U.carousel_space_between_tiles);if(0>=t){t=1;var e=V.carouselMaxWidth-2*U.carousel_padding;i(e)}}
var n=F.getSpaceByNumItems(t,V.tileWidth,U.carousel_space_between_tiles);n+=2*U.carousel_padding,R.width(n),1==V.isFirstTimeRun?(O(),B.run(),jQuery.each(N,function(e,t){t.objThumbWrapper.data("index",e),k.trigger(V.eventSizeChange,[t.objThumbWrapper,!0]),t.objTileOriginal=t.objThumbWrapper.clone(!0,!0)}),m(!0),1==U.carousel_autoplay&&Q.startAutoplay()):(1==U.carousel_autoplay&&Q.pauseAutoplay(),w(0,!1),1==U.carousel_autoplay&&Q.startAutoplay()),P(),V.isFirstTimeRun=!1}
function r(){return F.getElementSize(G).left}
function o(e){return F.getMousePosition(e).pageX}
function a(){var e=G.children(".ug-thumb-wrapper");return e}
function s(e){var t=F.getNumItemsInSpace(e,V.tileWidth,U.carousel_space_between_tiles);return t}
function l(){return a().length}
function u(e){v(e);var t=a(),i=jQuery(t[e]);return i}
function d(){return G.children(".ug-thumb-wrapper").first()}
function _(){return G.children(".ug-thumb-wrapper").last()}
function g(e,t,i){var n=e.data("index");if(void 0==n)throw new Error("every tile should have index!");for(var r=[],o=0;t>o;o++){if("prev"==i)var a=W.getPrevItem(n,!0);else var a=W.getNextItem(n,!0);if(!a)throw new Error("the item to add is empty");var s=a.objTileOriginal.clone(!0,!0);n=a.index,s.addClass("cloned"),r.push(s)}
return r}
function c(){var e=F.getElementSize(R),t=F.getElementSize(G),i=t.width-e.width+t.left,n=V.sideSpace-i;return n}
function h(){var e=-r(),t=V.sideSpace-e;return t}
function p(){var e=F.getElementSize(R);return e.width}
function f(){var e=p(),t=s(e);return t}
function m(e){if(!e)var e=!1;var t,i=a(),n=0,r=0;return jQuery.each(i,function(e,o){o=jQuery(o),F.placeElement(o,n,0);var a=F.getElementSize(o);n+=a.width+U.carousel_space_between_tiles,r=Math.max(r,a.height),e==i.length-1&&(t=a.right)}),G.width(t),r+=2*U.carousel_padding,e===!0&&(G.height(r),R.height(r)),w(V.numCurrent,!1),t}
function v(e){if(e>a().length-1)throw new Error("Wrogn tile number: "+e)}
function b(e,t){if("left"==t)var i=d();else var i=_();var n="left"==t?"prev":"next",r=g(i,e,n);jQuery.each(r,function(e,i){"left"==t?G.prepend(i):G.append(i),k.trigger(V.eventSizeChange,i),B.loadTileImage(i)})}
function y(e,t){v(n);for(var i=a(),n=i.length,r=0;e>r;r++)"left"==t?jQuery(i[r]).remove():jQuery(i[n-1-r]).remove()}
function I(e){var t={left:e+"px"};G.css(t)}
function w(e,t,i){if(void 0===t){var t=!0;if(G.is(":animated"))return!0}
var n=u(e),r=F.getElementSize(n),o=-r.left+U.carousel_padding,a={left:o+"px"};if(t===!0){var s=U.carousel_scroll_duration,l=U.carousel_scroll_easing;i===!0&&(s=V.scrollShortDuration,l=V.scrollShortEasing),G.stop(!0).animate(a,{duration:s,easing:l,queue:!1,complete:function(){V.numCurrent=e,S(!0)}})}else V.numCurrent=e,G.css(a)}
function T(){var e=-r(),t=s(e),i=F.getElementSize(u(t)).left,n=F.getElementSize(u(t+1)).left;return Math.abs(i-e)<Math.abs(n-e)?t:t+1}
function E(){var e=T();w(e,!0,!0)}
function S(){var e=h(),t=c(),i=0,n=0,r=0,o=0,a=l();if(e>V.spaceActionSize)i=s(e),b(i,"left"),V.numCurrent+=i;else if(e<-V.spaceActionSize){var r=s(Math.abs(e));y(r,"left"),V.numCurrent-=r}
if(t>V.spaceActionSize?(n=s(t),b(n,"right")):t<-V.spaceActionSize&&(o=s(Math.abs(t)),y(o,"right")),o>a)throw new Error("Can't remove more then num tiles");var u=!1;return(i||n||r||o)&&(m(),u=!0),u}
function P(e){F.placeElement(G,0,U.carousel_padding),S()}
function x(){"left"==U.carousel_autoplay_direction?Q.scrollRight(1):Q.scrollLeft(1)}
function j(e){return 1==V.touchActive?!0:(V.touchActive=!0,Q.pauseAutoplay(),V.startTime=jQuery.now(),V.startMousePos=o(e),V.startInnerPos=r(),V.lastTime=V.startTime,V.lastMousePos=V.startMousePos,void F.storeEventData(e,V.storedEventID))}
function C(e){if(0==V.touchActive)return!0;F.updateStoredEventData(e,V.storedEventID),e.preventDefault();var t=null;if(1==U.carousel_vertical_scroll_ondrag&&(t=F.handleScrollTop(V.storedEventID)),"vert"===t)return!0;V.lastMousePos=o(e);var i=V.lastMousePos-V.startMousePos,n=V.startInnerPos+i,r=i>0?"prev":"next",a=F.getElementSize(G).width;n>0&&"prev"==r&&(n/=3),-a>n&&"next"==r&&(n=V.startInnerPos+i/3),I(n)}
function A(e){return 0==V.touchActive?!0:(V.touchActive=!1,E(),void Q.unpauseAutoplay())}
function M(e){return 0==U.carousel_autoplay_pause_onhover?!0:void(1==V.isPlayMode&&0==V.isPaused&&Q.pauseAutoplay())}
function z(e){return 0==U.carousel_autoplay_pause_onhover?!0:void Q.unpauseAutoplay()}
function O(){B.initEvents(),R.bind("mousedown touchstart",j),jQuery("body").bind("mousemove touchmove",C),jQuery(window).add("body").bind("mouseup touchend",A),R.hover(M,z)}
function L(){var e=V.lastTime-V.startTime,t=Math.abs(V.lastMousePos-V.startMousePos);return e>300?!1:t>30?!1:!0}
var H,k,N,R,G,Q=this,D=jQuery(this),W=new UniteGalleryMain,F=new UGFunctions,B=new UGTileDesign,Y=new UGThumbsGeneral,U={carousel_padding:8,carousel_space_between_tiles:20,carousel_navigation_numtiles:3,carousel_scroll_duration:500,carousel_scroll_easing:"easeOutCubic",carousel_autoplay:!0,carousel_autoplay_timeout:3e3,carousel_autoplay_direction:"right",carousel_autoplay_pause_onhover:!0,carousel_vertical_scroll_ondrag:!1};this.events={START_PLAY:"carousel_start_play",PAUSE_PLAY:"carousel_pause_play",STOP_PLAY:"carousel_stop_play"};var V={eventSizeChange:"thumb_size_change",isFirstTimeRun:!0,carouselMaxWidth:null,tileWidth:0,initTileWidth:0,initTileHeight:0,sideSpace:1500,spaceActionSize:500,numCurrent:0,touchActive:!1,startInnerPos:0,lastTime:0,startTime:0,startMousePos:0,lastMousePos:0,scrollShortDuration:200,scrollShortEasing:"easeOutQuad",handle:null,isPlayMode:!1,isPaused:!1,storedEventID:"carousel"};this.startAutoplay=function(){V.isPlayMode=!0,V.isPaused=!1,D.trigger(Q.events.START_PLAY),V.handle&&clearInterval(V.handle),V.handle=setInterval(x,U.carousel_autoplay_timeout)},this.unpauseAutoplay=function(){return 0==V.isPlayMode?!0:0==V.isPaused?!0:void Q.startAutoplay()},this.pauseAutoplay=function(){return 0==V.isPlayMode?!0:(V.isPaused=!0,V.handle&&clearInterval(V.handle),void D.trigger(Q.events.PAUSE_PLAY))},this.stopAutoplay=function(){return 0==V.isPlayMode?!0:(V.isPaused=!1,V.isPlayMode=!1,V.handle&&clearInterval(V.handle),void D.trigger(Q.events.STOP_PLAY))},this.destroy=function(){V.handle&&clearInterval(V.handle),D.off(Q.events.START_PLAY),D.off(Q.events.STOP_PLAY),R.unbind("mousedown"),R.unbind("touchstart"),jQuery("body").unbind("mousemove"),jQuery("body").unbind("touchmove"),jQuery(window).add("body").unbind("mouseup").unbind("touchend"),R.off("mouseenter").off("mouseleave"),B.destroy()},this.init=function(t,i,n){n&&this.setMaxWidth(n),e(t,i)},this.setMaxWidth=function(e){V.carouselMaxWidth=e},this.setHtml=function(e){t(e)},this.getElement=function(){return R},this.getObjTileDesign=function(){return B},this.getEstimatedHeight=function(){var e=U.tile_height+2*U.carousel_padding;return e},this.run=function(){n()},this.scrollRight=function(e){if(!e||"object"==typeof e)var e=U.carousel_navigation_numtiles;var t=f();e>t&&(e=t);var i=V.numCurrent-e;0>=i&&(i=0),w(i)},this.scrollLeft=function(e){if(!e||"object"==typeof e)var e=U.carousel_navigation_numtiles;var t=f();e>t&&(e=t);var i=l(),n=V.numCurrent+e;n>=i&&(n=i-1),w(n)},this.setScrollLeftButton=function(e){F.setButtonMobileReady(e),F.setButtonOnClick(e,Q.scrollLeft)},this.setScrollRightButton=function(e){F.setButtonMobileReady(e),F.setButtonOnClick(e,Q.scrollRight)},this.setPlayPauseButton=function(e){F.setButtonMobileReady(e),1==V.isPlayMode&&0==V.isPaused&&e.addClass("ug-pause-icon"),D.on(Q.events.START_PLAY,function(){e.addClass("ug-pause-icon")}),D.on(Q.events.STOP_PLAY,function(){e.removeClass("ug-pause-icon")}),F.setButtonOnClick(e,function(){0==V.isPlayMode||1==V.isPaused?Q.startAutoplay():Q.stopAutoplay()})}}
function UGTabs(){function e(e,t){u=e,a=jQuery(u),d=jQuery.extend(d,t),"select"==d.tabs_type?l=jQuery(d.tabs_container):s=jQuery(d.tabs_container+" .ug-tab")}
function t(){o()}
function i(e){u.requestNewItems(e)}
function n(){var e=d.tabs_class_selected,t=jQuery(this);if(t.hasClass(e))return!0;s.not(t).removeClass(e),t.addClass(e);var n=t.data("catid");return n?void i(n):!0}
function r(){var e=jQuery(this),t=e.val();return t?void i(t):!0}
function o(){"select"==d.tabs_type?l.change(r):s.click(n)}
var a,s,l,u=(jQuery(this),new UniteGalleryMain),d=(new UGFunctions,{tabs_type:"tabs",tabs_container:"#ug_tabs",tabs_class_selected:"ug-tab-selected"});this.events={},this.destroy=function(){l&&l.off("change"),s&&s.off("click")},this.init=function(t,i){e(t,i)},this.run=function(){t()}}
function UG_API(e){function t(e){var t={index:e.index,title:e.title,description:e.description,urlImage:e.urlImage,urlThumb:e.urlThumb},i=e.objThumbImage.data();for(var n in i){switch(n){case"image":case"description":continue}
t[n]=i[n]}
return t}
var i,n=this,r=(jQuery(n),new UniteGalleryMain);r=e,i=jQuery(e),this.events={API_INIT_FUNCTIONS:"api_init",API_ON_EVENT:"api_on_event"},this.on=function(e,o){switch(e){case"item_change":i.on(r.events.ITEM_CHANGE,function(){var e=r.getSelectedItem(),i=t(e);o(i.index,i)});break;case"resize":i.on(r.events.SIZE_CHANGE,o);break;case"enter_fullscreen":i.on(r.events.ENTER_FULLSCREEN,o);break;case"exit_fullscreen":i.on(r.events.EXIT_FULLSCREEN,o);break;case"play":i.on(r.events.START_PLAY,o);break;case"stop":i.on(r.events.STOP_PLAY,o);break;case"pause":i.on(r.events.PAUSE_PLAYING,o);break;case"continue":i.on(r.events.CONTINUE_PLAYING,o);break